/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Awareness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Light;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfPrismaticLight;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Empty;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class SpellBook_Prismatic
extends SpellBook {
    public SpellBook_Prismatic() {
        this.image = ItemSpriteSheet.PRISMATIC_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        float procChance = ((float)this.buffedLvl() + 1.0f) / ((float)this.buffedLvl() + 3.0f);
        if (Random.Float() < procChance) {
            Buff.affect(defender, Blindness.class, 2 + this.buffedLvl());
        }
        if (defender.properties().contains((Object)Char.Property.DEMONIC) || defender.properties().contains((Object)Char.Property.UNDEAD)) {
            defender.sprite.emitter().start(ShadowParticle.UP, 0.05f, 10 + this.buffedLvl());
            Sample.INSTANCE.play("sounds/burning.mp3");
            damage = (int)((float)damage * 1.3333f);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        if (Dungeon.level.viewDistance < 6) {
            Buff.prolong(curUser, Light.class, 30.0f + (float)(5 * this.buffedLvl()));
            Sample.INSTANCE.play("sounds/burning.mp3");
        } else if (this.buffedLvl() >= 10) {
            Buff.affect(hero, Awareness.class, 2.0f);
            GLog.p(Messages.get(SpellBook_Empty.class, "awareness", new Object[0]), new Object[0]);
        } else {
            GLog.i(Messages.get(this, "nothing", new Object[0]), new Object[0]);
        }
        needAnimation = busy;
        if (needAnimation) {
            this.readAnimation();
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{SpellBook_Empty.class, WandOfPrismaticLight.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 10;
            this.output = SpellBook_Prismatic.class;
            this.outQuantity = 1;
        }
    }
}

