/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barkskin;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.EvasiveMove;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Haste;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.PrismaticGuard;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.MirrorImage;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.PrismaticImage;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfWarding;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Empty;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class SpellBook_Warding
extends SpellBook {
    private static final int NIMAGES = 3;

    public SpellBook_Warding() {
        this.image = ItemSpriteSheet.WARDING_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        float procChance = ((float)this.buffedLvl() + 1.0f) / ((float)this.buffedLvl() + 3.0f);
        if (Random.Float() < procChance) {
            boolean found = false;
            for (Mob m : Dungeon.level.mobs.toArray(new Mob[0])) {
                if (!(m instanceof PrismaticImage)) continue;
                found = true;
                if (m.HP >= m.HT) continue;
                m.HP = Math.min(m.HP + damage / 2, m.HT);
                m.sprite.emitter().burst(Speck.factory(0), 4);
                m.sprite.showStatus(65280, Integer.toString(Math.min(damage / 2, m.HT - m.HP)), new Object[0]);
            }
            if (!found) {
                if (Dungeon.hero.buff(PrismaticGuard.class) != null) {
                    Buff.affect(Dungeon.hero, PrismaticGuard.class).extend(damage / 2);
                } else {
                    Buff.affect(Dungeon.hero, PrismaticGuard.class).set(damage / 2);
                }
            }
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        this.spawnImages(curUser, 3);
        needAnimation = busy;
        if (needAnimation) {
            this.readAnimation();
        }
    }

    public void spawnImages(Hero hero, int nImages) {
        ArrayList<Integer> respawnPoints = new ArrayList<Integer>();
        for (int i = 0; i < PathFinder.NEIGHBOURS8.length; ++i) {
            int p = hero.pos + PathFinder.NEIGHBOURS8[i];
            if (Actor.findChar(p) != null || !Dungeon.level.passable[p]) continue;
            respawnPoints.add(p);
        }
        while (nImages > 0 && respawnPoints.size() > 0) {
            int index = Random.index(respawnPoints);
            MirrorImage mob = new MirrorImage();
            mob.duplicate(hero);
            Buff.affect(mob, EvasiveMove.class, this.buffedLvl() >= 10 ? 4.0f : 3.0f);
            Buff.affect(mob, Haste.class, this.buffedLvl() >= 10 ? 4.0f : 3.0f);
            if (this.buffedLvl() >= 10) {
                Buff.affect(mob, Barkskin.class).set(this.buffedLvl(), 1);
            }
            GameScene.add(mob);
            ScrollOfTeleportation.appear(mob, (Integer)respawnPoints.get(index));
            respawnPoints.remove(index);
            --nImages;
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{SpellBook_Empty.class, WandOfWarding.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 10;
            this.output = SpellBook_Warding.class;
            this.outQuantity = 1;
        }
    }
}

