/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.bombs.HolyBomb;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Bible;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.HeavyBoomerang;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MissileSprite;
import com.watabou.noosa.tweeners.AlphaTweener;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;

public class Cross
extends MissileWeapon {
    public Cross() {
        this.image = ItemSpriteSheet.CROSS;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 1.0f;
        this.tier = 5;
        this.sticky = false;
        this.alchemy = true;
        this.baseUses = 1000.0f;
    }

    @Override
    public int max(int lvl) {
        return 6 * this.tier + this.tier * lvl;
    }

    @Override
    protected void rangedHit(Char enemy, int cell) {
        this.decrementDurability();
        if (this.durability > 0.0f) {
            Buff.append(Dungeon.hero, CircleBack.class).setup(this, cell, Dungeon.hero.pos, Dungeon.depth);
        }
    }

    @Override
    protected void rangedMiss(int cell) {
        this.parent = null;
        Buff.append(Dungeon.hero, CircleBack.class).setup(this, cell, Dungeon.hero.pos, Dungeon.depth);
    }

    public static class CircleBack
    extends Buff {
        private MissileWeapon cross;
        private int thrownPos;
        private int returnPos;
        private int returnDepth;
        private int left;
        private static final String CROSS = "cross";
        private static final String THROWN_POS = "thrown_pos";
        private static final String RETURN_POS = "return_pos";
        private static final String RETURN_DEPTH = "return_depth";

        public CircleBack() {
            this.revivePersists = true;
        }

        public void setup(MissileWeapon cross, int thrownPos, int returnPos, int returnDepth) {
            this.cross = cross;
            this.thrownPos = thrownPos;
            this.returnPos = returnPos;
            this.returnDepth = returnDepth;
            this.left = 3;
        }

        public int returnPos() {
            return this.returnPos;
        }

        public MissileWeapon cancel() {
            this.detach();
            return this.cross;
        }

        public int activeDepth() {
            return this.returnDepth;
        }

        @Override
        public boolean act() {
            if (this.returnDepth == Dungeon.depth) {
                --this.left;
                if (this.left <= 0) {
                    final Char returnTarget = Actor.findChar(this.returnPos);
                    final Char target = this.target;
                    MissileSprite visual = (MissileSprite)Dungeon.hero.sprite.parent.recycle(MissileSprite.class);
                    visual.reset(this.thrownPos, this.returnPos, (Item)this.cross, new Callback(){

                        @Override
                        public void call() {
                            if (returnTarget == target) {
                                if (target instanceof Hero && cross.doPickUp((Hero)target)) {
                                    ((Hero)target).spend(-1.0f);
                                } else {
                                    Dungeon.level.drop((Item)((CircleBack)this).cross, (int)((CircleBack)this).returnPos).sprite.drop();
                                }
                            } else if (returnTarget != null) {
                                if (((Hero)target).shoot(returnTarget, cross)) {
                                    cross.decrementDurability();
                                }
                                if (((CircleBack)this).cross.durability > 0.0f) {
                                    Dungeon.level.drop((Item)((CircleBack)this).cross, (int)((CircleBack)this).returnPos).sprite.drop();
                                }
                            } else {
                                Dungeon.level.drop((Item)((CircleBack)this).cross, (int)((CircleBack)this).returnPos).sprite.drop();
                            }
                            this.next();
                        }
                    });
                    visual.alpha(0.0f);
                    float duration = Dungeon.level.trueDistance(this.thrownPos, this.returnPos) / 20.0f;
                    target.sprite.parent.add(new AlphaTweener(visual, 1.0f, duration));
                    this.detach();
                    return false;
                }
            }
            this.spend(1.0f);
            return true;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(CROSS, this.cross);
            bundle.put(THROWN_POS, this.thrownPos);
            bundle.put(RETURN_POS, this.returnPos);
            bundle.put(RETURN_DEPTH, this.returnDepth);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.cross = (MissileWeapon)bundle.get(CROSS);
            this.thrownPos = bundle.getInt(THROWN_POS);
            this.returnPos = bundle.getInt(RETURN_POS);
            this.returnDepth = bundle.getInt(RETURN_DEPTH);
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Bible.class, HolyBomb.class, HeavyBoomerang.class};
            this.inQuantity = new int[]{1, 1, 1};
            this.cost = 20;
            this.output = Cross.class;
            this.outQuantity = 1;
        }
    }
}

