/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.PinCushion;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.RevealedArea;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.KindOfWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.MagicalHolster;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfSharpshooting;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Projecting;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssultRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Carbine;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.DualPistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FlameThrower;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FrostGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GoldenPistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Handgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HuntingRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.KSG;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Magnum;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MarksmanRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MissileButton;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ParalysisGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Pistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.PlasmaCannon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RPG7;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Revolver;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RocketLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SleepGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SubMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WA2000;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Disintegration;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.FishingSpear;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.Javelin;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ThrowingSpear;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.Trident;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.darts.Dart;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;

public abstract class MissileWeapon
extends Weapon {
    protected boolean sticky;
    public static final float MAX_DURABILITY = 100.0f;
    protected float durability;
    protected float baseUses;
    public boolean holster;
    protected MissileWeapon parent;
    public int tier;
    private static final String DURABILITY = "durability";
    private static boolean bundleRestoring = false;

    public MissileWeapon() {
        this.stackable = true;
        this.levelKnown = true;
        this.bones = true;
        this.defaultAction = "THROW";
        this.usesTargeting = true;
        this.sticky = true;
        this.durability = 100.0f;
        this.baseUses = 10.0f;
    }

    @Override
    public int min() {
        return Math.max(0, this.min(this.buffedLvl() + RingOfSharpshooting.levelDamageBonus(Dungeon.hero)));
    }

    @Override
    public int min(int lvl) {
        return 2 * this.tier + (this.tier == 1 ? lvl : 2 * lvl);
    }

    @Override
    public int max() {
        return Math.max(0, this.max(this.buffedLvl() + RingOfSharpshooting.levelDamageBonus(Dungeon.hero)));
    }

    @Override
    public int max(int lvl) {
        return 5 * this.tier + (this.tier == 1 ? 2 * lvl : this.tier * lvl);
    }

    @Override
    public int STRReq(int lvl) {
        return MissileWeapon.STRReq(this.tier, lvl) - 1;
    }

    @Override
    public Item upgrade() {
        if (!bundleRestoring) {
            this.durability = 100.0f;
            if (this.quantity > 1) {
                MissileWeapon upgraded = (MissileWeapon)this.split(1);
                upgraded.parent = null;
                if ((upgraded = (MissileWeapon)upgraded.upgrade()).quantity() == 1 && !upgraded.collect()) {
                    Dungeon.level.drop(upgraded, Dungeon.hero.pos);
                }
                MissileWeapon.updateQuickslot();
                return upgraded;
            }
            super.upgrade();
            Item similar = Dungeon.hero.belongings.getSimilar(this);
            if (similar != null) {
                this.detach(Dungeon.hero.belongings.backpack);
                Item result = similar.merge(this);
                MissileWeapon.updateQuickslot();
                return result;
            }
            MissileWeapon.updateQuickslot();
            return this;
        }
        return super.upgrade();
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.remove("EQUIP");
        return actions;
    }

    @Override
    public boolean collect(Bag container) {
        if (container instanceof MagicalHolster) {
            this.holster = true;
        }
        return super.collect(container);
    }

    @Override
    public int throwPos(Hero user, int dst) {
        boolean projecting = this.hasEnchant(Projecting.class, user);
        if (this instanceof PlasmaCannon.Bullet || this instanceof PlasmaCannon.Bullet || this instanceof PlasmaCannon.Bullet || this instanceof FlameThrower.Bullet || this instanceof FlameThrower.Bullet || this instanceof FlameThrower.Bullet || this instanceof MissileButton.Rocket) {
            projecting = true;
        }
        if (!(projecting || Random.Int(3) >= user.pointsInTalent(Talent.SHARED_ENCHANTMENT) || this instanceof Dart && ((Dart)this).crossbowHasEnchant(Dungeon.hero) || this instanceof FishingSpear && ((FishingSpear)this).ballistaHasEnchant(Dungeon.hero) || this instanceof ThrowingSpear && ((ThrowingSpear)this).ballistaHasEnchant(Dungeon.hero) || this instanceof Javelin && ((Javelin)this).ballistaHasEnchant(Dungeon.hero) || this instanceof Trident && ((Trident)this).ballistaHasEnchant(Dungeon.hero))) {
            SpiritBow bow = Dungeon.hero.belongings.getItem(SpiritBow.class);
            WindBow bow2 = Dungeon.hero.belongings.getItem(WindBow.class);
            GoldenBow bow3 = Dungeon.hero.belongings.getItem(GoldenBow.class);
            NaturesBow bow4 = Dungeon.hero.belongings.getItem(NaturesBow.class);
            CorrosionBow bow5 = Dungeon.hero.belongings.getItem(CorrosionBow.class);
            if (bow != null && bow.hasEnchant(Projecting.class, user)) {
                projecting = true;
            }
            if (bow2 != null && bow2.hasEnchant(Projecting.class, user)) {
                projecting = true;
            }
            if (bow3 != null && bow3.hasEnchant(Projecting.class, user)) {
                projecting = true;
            }
            if (bow4 != null && bow4.hasEnchant(Projecting.class, user)) {
                projecting = true;
            }
            if (bow5 != null && bow5.hasEnchant(Projecting.class, user)) {
                projecting = true;
            }
        }
        if ((this instanceof CrudePistol.Bullet || this instanceof Pistol.Bullet || this instanceof GoldenPistol.Bullet || this instanceof Handgun.Bullet || this instanceof Magnum.Bullet || this instanceof TacticalHandgun.Bullet || this instanceof AutoHandgun.Bullet || this instanceof DualPistol.Bullet || this instanceof SubMachinegun.Bullet || this instanceof AssultRifle.Bullet || this instanceof HeavyMachinegun.Bullet || this instanceof MiniGun.Bullet || this instanceof AutoRifle.Bullet || this instanceof Revolver.Bullet || this instanceof HuntingRifle.Bullet || this instanceof Carbine.Bullet || this instanceof SniperRifle.Bullet || this instanceof AntimaterRifle.Bullet || this instanceof MarksmanRifle.Bullet || this instanceof WA2000.Bullet || this instanceof ShotGun.Bullet || this instanceof KSG.Bullet || this instanceof RocketLauncher.Rocket || this instanceof RPG7.Rocket || this instanceof GrenadeLauncher.Rocket || this instanceof GrenadeLauncherAP.Rocket || this instanceof GrenadeLauncherHP.Rocket || this instanceof SleepGun.Dart || this instanceof ParalysisGun.Dart || this instanceof FrostGun.Dart) && user.hasTalent(Talent.STREET_BATTLE)) {
            if (!Dungeon.level.solid[dst] && Dungeon.level.distance(user.pos, dst) <= (projecting ? 4 + user.pointsInTalent(Talent.STREET_BATTLE) : 1 + user.pointsInTalent(Talent.STREET_BATTLE)) && user.buff(Talent.StreetBattleCooldown.class) == null) {
                Buff.affect(user, Talent.StreetBattleCooldown.class, 40 - 10 * Dungeon.hero.pointsInTalent(Talent.STREET_BATTLE));
                return dst;
            }
            return super.throwPos(user, dst);
        }
        if (Dungeon.hero.belongings.weapon instanceof SpellBook_Disintegration) {
            if (!Dungeon.level.solid[dst] && Dungeon.level.distance(user.pos, dst) <= (projecting ? 4 + Math.min(10, ((SpellBook_Disintegration)Dungeon.hero.belongings.weapon).buffedLvl()) : 1 + Math.min(10, ((SpellBook_Disintegration)Dungeon.hero.belongings.weapon).buffedLvl()))) {
                return dst;
            }
            return super.throwPos(user, dst);
        }
        if (this instanceof PlasmaCannon.Bullet || this instanceof FlameThrower.Bullet || this instanceof MissileButton.Rocket) {
            return dst;
        }
        if (projecting && (Dungeon.level.passable[dst] || Dungeon.level.avoid[dst]) && Dungeon.level.distance(user.pos, dst) <= Math.round(4.0f * Weapon.Enchantment.genericProcChanceMultiplier(user))) {
            return dst;
        }
        return super.throwPos(user, dst);
    }

    @Override
    public float accuracyFactor(Char owner, Char target) {
        float accFactor = super.accuracyFactor(owner, target);
        if (owner instanceof Hero && owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
            accFactor *= 1.0f + 0.2f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM);
        }
        if (owner instanceof Hero && owner.buff(Bless.class) != null && ((Hero)owner).hasTalent(Talent.BLESSED_TALENT)) {
            accFactor *= 1.0f + 0.2f * (float)((Hero)owner).pointsInTalent(Talent.BLESSED_TALENT);
        }
        if (this.bullet && owner instanceof Hero && owner.buff(MeleeWeapon.PrecisionShooting.class) != null && owner.buff(MeleeWeapon.Charger.class) != null && owner.buff(MeleeWeapon.PrecisionShooting.class).onUse && owner.buff(MeleeWeapon.Charger.class).charges >= 1) {
            return Char.INFINITE_ACCURACY;
        }
        return accFactor *= this.adjacentAccFactor(owner, target);
    }

    protected float adjacentAccFactor(Char owner, Char target) {
        if (Dungeon.level.adjacent(owner.pos, target.pos)) {
            if (owner instanceof Hero) {
                return 0.5f + 0.2f * (float)((Hero)owner).pointsInTalent(Talent.POINT_BLANK);
            }
            return 0.5f;
        }
        return 1.5f;
    }

    @Override
    public void doThrow(Hero hero) {
        this.parent = null;
        super.doThrow(hero);
    }

    @Override
    protected void onThrow(int cell) {
        Char enemy = Actor.findChar(cell);
        if (enemy == null || enemy == curUser) {
            this.parent = null;
            if (curUser.hasTalent(Talent.SEER_SHOT) && MissileWeapon.curUser.heroClass != HeroClass.HUNTRESS && curUser.buff(Talent.SeerShotCooldown.class) == null && Actor.findChar(cell) == null) {
                RevealedArea a = Buff.affect(curUser, RevealedArea.class, 5 * curUser.pointsInTalent(Talent.SEER_SHOT));
                a.depth = Dungeon.depth;
                a.pos = cell;
                Buff.affect(curUser, Talent.SeerShotCooldown.class, 20.0f);
            }
            super.onThrow(cell);
        } else if (!curUser.shoot(enemy, this)) {
            this.rangedMiss(cell);
        } else {
            this.rangedHit(enemy, cell);
        }
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        KindOfWeapon wep;
        if (!(attacker != Dungeon.hero || Random.Int(3) >= Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) || this instanceof Dart && ((Dart)this).crossbowHasEnchant(Dungeon.hero) || this instanceof FishingSpear && ((FishingSpear)this).ballistaHasEnchant(Dungeon.hero) || this instanceof ThrowingSpear && ((ThrowingSpear)this).ballistaHasEnchant(Dungeon.hero) || this instanceof Javelin && ((Javelin)this).ballistaHasEnchant(Dungeon.hero) || this instanceof Trident && ((Trident)this).ballistaHasEnchant(Dungeon.hero))) {
            SpiritBow bow = Dungeon.hero.belongings.getItem(SpiritBow.class);
            WindBow bow2 = Dungeon.hero.belongings.getItem(WindBow.class);
            GoldenBow bow3 = Dungeon.hero.belongings.getItem(GoldenBow.class);
            NaturesBow bow4 = Dungeon.hero.belongings.getItem(NaturesBow.class);
            CorrosionBow bow5 = Dungeon.hero.belongings.getItem(CorrosionBow.class);
            if (bow != null && bow.enchantment != null && Dungeon.hero.buff(MagicImmune.class) == null) {
                damage = bow.enchantment.proc(this, attacker, defender, damage);
            }
            if (bow2 != null && bow2.enchantment != null && Dungeon.hero.buff(MagicImmune.class) == null) {
                damage = bow2.enchantment.proc(this, attacker, defender, damage);
            }
            if (bow3 != null && bow3.enchantment != null && Dungeon.hero.buff(MagicImmune.class) == null) {
                damage = bow3.enchantment.proc(this, attacker, defender, damage);
            }
            if (bow4 != null && bow4.enchantment != null && Dungeon.hero.buff(MagicImmune.class) == null) {
                damage = bow4.enchantment.proc(this, attacker, defender, damage);
            }
            if (bow5 != null && bow5.enchantment != null && Dungeon.hero.buff(MagicImmune.class) == null) {
                damage = bow5.enchantment.proc(this, attacker, defender, damage);
            }
        }
        if (!(attacker != Dungeon.hero || Random.Int(3) >= Dungeon.hero.pointsInTalent(Talent.MYSTICAL_THROW) || this instanceof Dart && ((Dart)this).crossbowHasEnchant(Dungeon.hero) || this instanceof FishingSpear && ((FishingSpear)this).ballistaHasEnchant(Dungeon.hero) || this instanceof ThrowingSpear && ((ThrowingSpear)this).ballistaHasEnchant(Dungeon.hero) || this instanceof Javelin && ((Javelin)this).ballistaHasEnchant(Dungeon.hero) || this instanceof Trident && ((Trident)this).ballistaHasEnchant(Dungeon.hero) || !((wep = Dungeon.hero.belongings.weapon) instanceof Weapon) || ((Weapon)wep).enchantment == null || Dungeon.hero.buff(MagicImmune.class) != null)) {
            damage = ((Weapon)wep).enchantment.proc(this, attacker, defender, damage);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public Item random() {
        if (!this.stackable) {
            return this;
        }
        this.quantity = 2;
        if (Random.Int(3) == 0) {
            ++this.quantity;
            if (Random.Int(5) == 0) {
                ++this.quantity;
            }
        }
        return this;
    }

    @Override
    public String status() {
        return Integer.toString(this.quantity);
    }

    @Override
    public float castDelay(Char user, int dst) {
        if (Dungeon.hero.subClass == HeroSubClass.GUNSLINGER) {
            if (user instanceof Hero && ((Hero)user).justMoved) {
                return 0.0f;
            }
            return this.delayFactor(user);
        }
        return this.delayFactor(user);
    }

    protected void rangedHit(Char enemy, int cell) {
        this.decrementDurability();
        if (this.durability > 0.0f) {
            if (this.sticky && enemy != null && enemy.isAlive() && enemy.alignment != Char.Alignment.ALLY) {
                PinCushion p = Buff.affect(enemy, PinCushion.class);
                if (p.target == enemy) {
                    p.stick(this);
                    return;
                }
            }
            Dungeon.level.drop((Item)this, (int)cell).sprite.drop();
        }
    }

    protected void rangedMiss(int cell) {
        this.parent = null;
        super.onThrow(cell);
    }

    public float durabilityLeft() {
        return this.durability;
    }

    public void repair(float amount) {
        this.durability += amount;
        this.durability = Math.min(this.durability, 100.0f);
    }

    public float durabilityPerUse() {
        float usages = this.baseUses * (float)Math.pow(3.0, this.level());
        if (Dungeon.hero.hasTalent(Talent.DURABLE_PROJECTILES)) {
            usages *= 1.25f + 0.25f * (float)Dungeon.hero.pointsInTalent(Talent.DURABLE_PROJECTILES);
        }
        if (this.holster) {
            usages *= 1.2f;
        }
        if ((usages *= RingOfSharpshooting.durabilityMultiplier(Dungeon.hero)) >= 100.0f) {
            return 0.0f;
        }
        usages = Math.round(usages);
        return 100.0f / usages + 0.001f;
    }

    protected void decrementDurability() {
        if (this.parent != null) {
            if (this.parent.durability <= this.parent.durabilityPerUse()) {
                this.durability = 0.0f;
                this.parent.durability = 100.0f;
            } else {
                this.parent.durability -= this.parent.durabilityPerUse();
                if (this.parent.durability > 0.0f && this.parent.durability <= this.parent.durabilityPerUse()) {
                    if (this.level() <= 0) {
                        GLog.w(Messages.get(this, "about_to_break", new Object[0]), new Object[0]);
                    } else {
                        GLog.n(Messages.get(this, "about_to_break", new Object[0]), new Object[0]);
                    }
                }
            }
            this.parent = null;
        } else {
            this.durability -= this.durabilityPerUse();
            if (this.durability > 0.0f && this.durability <= this.durabilityPerUse()) {
                if (this.level() <= 0) {
                    GLog.w(Messages.get(this, "about_to_break", new Object[0]), new Object[0]);
                } else {
                    GLog.n(Messages.get(this, "about_to_break", new Object[0]), new Object[0]);
                }
            }
        }
    }

    @Override
    public int damageRoll(Char owner) {
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero) {
            int exStr = ((Hero)owner).STR() - this.STRReq();
            if (exStr > 0) {
                damage += Random.IntRange(0, exStr);
            }
            if (owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
                damage = Math.round((float)damage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM)));
            }
            if (owner.buff(Bless.class) != null && ((Hero)owner).hasTalent(Talent.BLESSED_TALENT)) {
                damage = Math.round((float)damage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.BLESSED_TALENT)));
            }
        }
        return damage;
    }

    @Override
    public void reset() {
        super.reset();
        this.durability = 100.0f;
    }

    @Override
    public Item merge(Item other) {
        super.merge(other);
        if (this.isSimilar(other)) {
            this.durability += ((MissileWeapon)other).durability;
            this.durability -= 100.0f;
            while (this.durability <= 0.0f) {
                --this.quantity;
                this.durability += 100.0f;
            }
        }
        return this;
    }

    @Override
    public Item split(int amount) {
        bundleRestoring = true;
        Item split = super.split(amount);
        bundleRestoring = false;
        if (split != null) {
            MissileWeapon m = (MissileWeapon)split;
            m.durability = 100.0f;
            m.parent = this;
        }
        return split;
    }

    @Override
    public boolean doPickUp(Hero hero, int pos) {
        this.parent = null;
        return super.doPickUp(hero, pos);
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public String info() {
        String info = this.desc();
        info = info + "\n\n" + Messages.get(MissileWeapon.class, "stats", this.tier, Math.round(this.augment.damageFactor(this.min())), Math.round(this.augment.damageFactor(this.max())), this.STRReq());
        if (this.STRReq() > Dungeon.hero.STR()) {
            info = info + " " + Messages.get(Weapon.class, "too_heavy", new Object[0]);
        } else if (Dungeon.hero.STR() > this.STRReq()) {
            info = info + " " + Messages.get(Weapon.class, "excess_str", Dungeon.hero.STR() - this.STRReq());
        }
        if (this.enchantment != null && (this.cursedKnown || !this.enchantment.curse())) {
            info = info + "\n\n" + Messages.get(Weapon.class, "enchanted", this.enchantment.name());
            info = info + " " + Messages.get(this.enchantment, "desc", new Object[0]);
        }
        if (this.cursed && this.isEquipped(Dungeon.hero)) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed_worn", new Object[0]);
        } else if (this.cursedKnown && this.cursed) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed", new Object[0]);
        } else if (!this.isIdentified() && this.cursedKnown) {
            info = info + "\n\n" + Messages.get(Weapon.class, "not_cursed", new Object[0]);
        }
        info = info + "\n\n" + Messages.get(MissileWeapon.class, "distance", new Object[0]);
        info = info + "\n\n" + Messages.get(this, DURABILITY, new Object[0]);
        info = this.durabilityPerUse() > 0.0f ? info + " " + Messages.get(this, "uses_left", (int)Math.ceil(this.durability / this.durabilityPerUse()), (int)Math.ceil(100.0f / this.durabilityPerUse())) : info + " " + Messages.get(this, "unlimited_uses", new Object[0]);
        return info;
    }

    @Override
    public int value() {
        return 6 * this.tier * this.quantity * (this.level() + 1);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(DURABILITY, this.durability);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        bundleRestoring = true;
        super.restoreFromBundle(bundle);
        bundleRestoring = false;
        this.durability = bundle.getFloat(DURABILITY);
    }

    public static class PlaceHolder
    extends MissileWeapon {
        public PlaceHolder() {
            this.image = ItemSpriteSheet.MISSILE_HOLDER;
        }

        @Override
        public boolean isSimilar(Item item) {
            return item instanceof MissileWeapon;
        }

        @Override
        public String info() {
            return "";
        }
    }
}

