/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.journal;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.journal.Journal;
import com.watabou.utils.Bundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public enum Catalog {
    WEAPONS,
    ARMOR,
    WANDS,
    RINGS,
    ARTIFACTS,
    POTIONS,
    SCROLLS;

    private LinkedHashMap<Class<? extends Item>, Boolean> seen = new LinkedHashMap();
    public static LinkedHashMap<Catalog, Badges.Badge> catalogBadges;
    private static final String CATALOG_ITEMS = "catalog_items";

    public Collection<Class<? extends Item>> items() {
        return this.seen.keySet();
    }

    public boolean allSeen() {
        for (Class<? extends Item> item : this.items()) {
            if (this.seen.get(item).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean isSeen(Class<? extends Item> itemClass) {
        for (Catalog cat : Catalog.values()) {
            if (!cat.seen.containsKey(itemClass)) continue;
            return cat.seen.get(itemClass);
        }
        return false;
    }

    public static void setSeen(Class<? extends Item> itemClass) {
        for (Catalog cat : Catalog.values()) {
            if (!cat.seen.containsKey(itemClass) || cat.seen.get(itemClass).booleanValue()) continue;
            cat.seen.put(itemClass, true);
            Journal.saveNeeded = true;
        }
        Badges.validateItemsIdentified();
    }

    public static void store(Bundle bundle) {
        Badges.loadGlobal();
        ArrayList<Class<? extends Item>> seen = new ArrayList<Class<? extends Item>>();
        if (!Badges.isUnlocked(Badges.Badge.ALL_ITEMS_IDENTIFIED)) {
            for (Catalog cat : Catalog.values()) {
                if (Badges.isUnlocked(catalogBadges.get((Object)cat))) continue;
                for (Class<? extends Item> item : cat.items()) {
                    if (!cat.seen.get(item).booleanValue()) continue;
                    seen.add(item);
                }
            }
        }
        bundle.put(CATALOG_ITEMS, seen.toArray(new Class[0]));
    }

    public static void restore(Bundle bundle) {
        Badges.loadGlobal();
        if (Badges.isUnlocked(Badges.Badge.ALL_ITEMS_IDENTIFIED)) {
            for (Catalog cat : Catalog.values()) {
                for (Class<? extends Item> item : cat.items()) {
                    cat.seen.put(item, true);
                }
            }
            return;
        }
        for (Catalog cat : Catalog.values()) {
            if (!Badges.isUnlocked(catalogBadges.get((Object)cat))) continue;
            for (Class<? extends Item> item : cat.items()) {
                cat.seen.put(item, true);
            }
        }
        if (bundle.contains(CATALOG_ITEMS)) {
            List<Object> seenClasses = new ArrayList();
            if (bundle.contains(CATALOG_ITEMS)) {
                seenClasses = Arrays.asList(bundle.getClassArray(CATALOG_ITEMS));
            }
            for (Catalog cat : Catalog.values()) {
                for (Class<? extends Item> item : cat.items()) {
                    if (!seenClasses.contains(item)) continue;
                    cat.seen.put(item, true);
                }
            }
        }
    }

    static {
        for (Class<?> weapon : Generator.Category.WEP_T1.classes) {
            Catalog.WEAPONS.seen.put(weapon, false);
        }
        for (Class<?> weapon : Generator.Category.WEP_T2.classes) {
            Catalog.WEAPONS.seen.put(weapon, false);
        }
        for (Class<?> weapon : Generator.Category.WEP_T3.classes) {
            Catalog.WEAPONS.seen.put(weapon, false);
        }
        for (Class<?> weapon : Generator.Category.WEP_T4.classes) {
            Catalog.WEAPONS.seen.put(weapon, false);
        }
        for (Class<?> weapon : Generator.Category.WEP_T5.classes) {
            Catalog.WEAPONS.seen.put(weapon, false);
        }
        for (Class<?> weapon : Generator.Category.ADVANCED.classes) {
            Catalog.WEAPONS.seen.put(weapon, false);
        }
        for (Class<?> weapon : Generator.Category.ALCHEMY.classes) {
            Catalog.WEAPONS.seen.put(weapon, false);
        }
        for (Class<?> weapon : Generator.Category.SPELLBOOK.classes) {
            Catalog.WEAPONS.seen.put(weapon, false);
        }
        for (Class<?> weapon : Generator.Category.SUBWEAPON.classes) {
            Catalog.WEAPONS.seen.put(weapon, false);
        }
        for (Class<?> armor : Generator.Category.ARMOR.classes) {
            Catalog.ARMOR.seen.put(armor, false);
        }
        for (Class<?> wand : Generator.Category.WAND.classes) {
            Catalog.WANDS.seen.put(wand, false);
        }
        for (Class<?> ring : Generator.Category.RING.classes) {
            Catalog.RINGS.seen.put(ring, false);
        }
        for (Class<?> artifact : Generator.Category.ARTIFACT.classes) {
            Catalog.ARTIFACTS.seen.put(artifact, false);
        }
        for (Class<?> potion : Generator.Category.POTION.classes) {
            Catalog.POTIONS.seen.put(potion, false);
        }
        for (Class<?> scroll : Generator.Category.SCROLL.classes) {
            Catalog.SCROLLS.seen.put(scroll, false);
        }
        catalogBadges = new LinkedHashMap();
        catalogBadges.put(WEAPONS, Badges.Badge.ALL_WEAPONS_IDENTIFIED);
        catalogBadges.put(ARMOR, Badges.Badge.ALL_ARMOR_IDENTIFIED);
        catalogBadges.put(WANDS, Badges.Badge.ALL_WANDS_IDENTIFIED);
        catalogBadges.put(RINGS, Badges.Badge.ALL_RINGS_IDENTIFIED);
        catalogBadges.put(ARTIFACTS, Badges.Badge.ALL_ARTIFACTS_IDENTIFIED);
        catalogBadges.put(POTIONS, Badges.Badge.ALL_POTIONS_IDENTIFIED);
        catalogBadges.put(SCROLLS, Badges.Badge.ALL_SCROLLS_IDENTIFIED);
    }
}

