/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.effects.Ripple;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.RegularLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.SewerPainter;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.BlazingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ConfusionTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.CorrosionTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.CursingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.DisarmingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.DisintegrationTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.DistortionTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ExplosiveTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.FlashingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.FlockTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.FrostTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GatewayTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GeyserTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GrimTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GuardianTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.InfernoTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.OozeTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ParalysisTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.PitfallTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.PoisonDartTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.RockfallTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.StormTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ToxicTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.WeakeningTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.WornDartTrap;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTilemap;
import com.watabou.noosa.Game;
import com.watabou.noosa.Group;
import com.watabou.noosa.audio.Music;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.particles.PixelParticle;
import com.watabou.utils.ColorMath;
import com.watabou.utils.PointF;
import com.watabou.utils.Random;

public class LabsLevel
extends RegularLevel {
    public LabsLevel() {
        this.color1 = 4748860;
        this.color2 = 5871946;
    }

    @Override
    public void playLevelMusic() {
        Music.INSTANCE.playTracks(new String[]{"music/halls_1.ogg", "music/halls_2.ogg", "music/halls_2.ogg"}, new float[]{1.0f, 1.0f, 0.5f}, false);
    }

    @Override
    protected int standardRooms(boolean forceMax) {
        if (forceMax) {
            return 9;
        }
        return 8 + Random.chances(new float[]{1.0f, 2.0f});
    }

    @Override
    protected int specialRooms(boolean forceMax) {
        return 3;
    }

    @Override
    protected Painter painter() {
        return new SewerPainter().setWater(this.feeling == Level.Feeling.WATER ? 0.85f : 0.3f, 5).setGrass(this.feeling == Level.Feeling.GRASS ? 0.8f : 0.2f, 4).setTraps(this.nTraps(), this.trapClasses(), this.trapChances());
    }

    @Override
    public String tilesTex() {
        return "environment/tiles_labs.png";
    }

    @Override
    public String waterTex() {
        return "environment/water5.png";
    }

    @Override
    protected Class<?>[] trapClasses() {
        Class[] classArray;
        if (Dungeon.depth == 1) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = WornDartTrap.class;
        } else {
            Class[] classArray3 = new Class[24];
            classArray3[0] = GuardianTrap.class;
            classArray3[1] = GeyserTrap.class;
            classArray3[2] = BlazingTrap.class;
            classArray3[3] = FrostTrap.class;
            classArray3[4] = ToxicTrap.class;
            classArray3[5] = ConfusionTrap.class;
            classArray3[6] = GatewayTrap.class;
            classArray3[7] = DisarmingTrap.class;
            classArray3[8] = OozeTrap.class;
            classArray3[9] = CorrosionTrap.class;
            classArray3[10] = StormTrap.class;
            classArray3[11] = PoisonDartTrap.class;
            classArray3[12] = FlockTrap.class;
            classArray3[13] = PitfallTrap.class;
            classArray3[14] = InfernoTrap.class;
            classArray3[15] = ParalysisTrap.class;
            classArray3[16] = RockfallTrap.class;
            classArray3[17] = ExplosiveTrap.class;
            classArray3[18] = FlashingTrap.class;
            classArray3[19] = DisintegrationTrap.class;
            classArray3[20] = DistortionTrap.class;
            classArray3[21] = WeakeningTrap.class;
            classArray3[22] = GrimTrap.class;
            classArray = classArray3;
            classArray3[23] = CursingTrap.class;
        }
        return classArray;
    }

    @Override
    protected float[] trapChances() {
        float[] fArray;
        if (Dungeon.depth == 1) {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = 1.0f;
        } else {
            float[] fArray3 = new float[24];
            fArray3[0] = 5.0f;
            fArray3[1] = 5.0f;
            fArray3[2] = 5.0f;
            fArray3[3] = 5.0f;
            fArray3[4] = 5.0f;
            fArray3[5] = 5.0f;
            fArray3[6] = 5.0f;
            fArray3[7] = 5.0f;
            fArray3[8] = 4.0f;
            fArray3[9] = 4.0f;
            fArray3[10] = 4.0f;
            fArray3[11] = 4.0f;
            fArray3[12] = 4.0f;
            fArray3[13] = 3.0f;
            fArray3[14] = 3.0f;
            fArray3[15] = 3.0f;
            fArray3[16] = 3.0f;
            fArray3[17] = 3.0f;
            fArray3[18] = 3.0f;
            fArray3[19] = 2.0f;
            fArray3[20] = 2.0f;
            fArray3[21] = 2.0f;
            fArray3[22] = 1.0f;
            fArray = fArray3;
            fArray3[23] = 1.0f;
        }
        return fArray;
    }

    @Override
    protected void createItems() {
        super.createItems();
    }

    @Override
    public Group addVisuals() {
        super.addVisuals();
        LabsLevel.addSewerVisuals(this, this.visuals);
        return this.visuals;
    }

    public static void addSewerVisuals(Level level, Group group) {
        for (int i = 0; i < level.length(); ++i) {
            if (level.map[i] != 12 && level.map[i] != 35) continue;
            group.add(new Sink(i));
        }
    }

    @Override
    public String tileName(int tile) {
        switch (tile) {
            case 29: {
                return Messages.get(LabsLevel.class, "water_name", new Object[0]);
            }
            case 12: {
                return Messages.get(LabsLevel.class, "wall_deco_name", new Object[0]);
            }
            case 25: {
                return Messages.get(LabsLevel.class, "statue_name", new Object[0]);
            }
        }
        return super.tileName(tile);
    }

    @Override
    public String tileDesc(int tile) {
        switch (tile) {
            case 7: {
                return Messages.get(LabsLevel.class, "entrance_desc", new Object[0]);
            }
            case 8: {
                return Messages.get(LabsLevel.class, "exit_desc", new Object[0]);
            }
            case 20: {
                return Messages.get(LabsLevel.class, "empty_deco_desc", new Object[0]);
            }
            case 12: {
                return Messages.get(LabsLevel.class, "wall_deco_desc", new Object[0]);
            }
            case 27: {
                return Messages.get(LabsLevel.class, "bookshelf_desc", new Object[0]);
            }
            case 25: {
                return Messages.get(LabsLevel.class, "statue_desc", new Object[0]);
            }
        }
        return super.tileDesc(tile);
    }

    private static class Sink
    extends Emitter {
        private int pos;
        private float rippleDelay = 0.0f;
        private static final Emitter.Factory factory = new Emitter.Factory(){

            @Override
            public void emit(Emitter emitter, int index, float x, float y) {
                WaterParticle p = (WaterParticle)emitter.recycle(WaterParticle.class);
                p.reset(x, y);
            }
        };

        public Sink(int pos) {
            this.pos = pos;
            PointF p = DungeonTilemap.tileCenterToWorld(pos);
            this.pos(p.x - 2.0f, p.y + 3.0f, 4.0f, 0.0f);
            this.pour(factory, 0.1f);
        }

        @Override
        public void update() {
            this.visible = this.pos < Dungeon.level.heroFOV.length && Dungeon.level.heroFOV[this.pos];
            if (this.visible) {
                super.update();
                if (!this.isFrozen()) {
                    Ripple ripple;
                    float f;
                    this.rippleDelay -= Game.elapsed;
                    if (f <= 0.0f && (ripple = GameScene.ripple(this.pos + Dungeon.level.width())) != null) {
                        ripple.y -= 8.0f;
                        this.rippleDelay = Random.Float(0.4f, 0.6f);
                    }
                }
            }
        }
    }

    public static final class WaterParticle
    extends PixelParticle {
        public WaterParticle() {
            this.acc.y = 50.0f;
            this.am = 0.5f;
            this.color(ColorMath.random(11979970, 3892819));
            this.size(2.0f);
        }

        public void reset(float x, float y) {
            this.revive();
            this.x = x;
            this.y = y;
            this.speed.set(Random.Float(-2.0f, 2.0f), 0.0f);
            this.lifespan = 0.4f;
            this.left = 0.4f;
        }
    }
}

