/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.items.journal.GuidePage;
import com.shatteredpixel.shatteredpixeldungeon.items.journal.Guidebook;
import com.shatteredpixel.shatteredpixeldungeon.journal.Document;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.ExitRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.StandardRoom;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class EntranceRoom
extends StandardRoom {
    @Override
    public int minWidth() {
        return Math.max(super.minWidth(), 5);
    }

    @Override
    public int minHeight() {
        return Math.max(super.minHeight(), 5);
    }

    @Override
    public boolean canMerge(Level l, Point p, int mergeTerrain) {
        return false;
    }

    @Override
    public boolean canPlaceTrap(Point p) {
        if (Dungeon.depth == 1) {
            return false;
        }
        return super.canPlaceTrap(p);
    }

    @Override
    public void paint(Level level) {
        int entrance;
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 1);
        for (Room.Door door : this.connected.values()) {
            door.set(Room.Door.Type.REGULAR);
        }
        while (level.findMob(entrance = level.pointToCell(this.random(2))) != null) {
        }
        Painter.set(level, entrance, 7);
        if (Dungeon.depth == 1) {
            level.transitions.add(new LevelTransition(level, entrance, LevelTransition.Type.SURFACE));
        } else {
            level.transitions.add(new LevelTransition(level, entrance, LevelTransition.Type.REGULAR_ENTRANCE));
        }
        Random.pushGenerator();
        if (Dungeon.depth == 1 && (!Document.ADVENTURERS_GUIDE.isPageRead("Intro") || SPDSettings.intro())) {
            int pos;
            while ((pos = level.pointToCell(new Point(Random.IntRange(this.left + 1, this.right - 1), Random.IntRange(this.top + 1, this.bottom - 2)))) == level.entrance() || level.findMob(level.entrance()) != null) {
            }
            level.drop(new Guidebook(), pos);
        }
        if (Dungeon.depth == 2 && !Document.ADVENTURERS_GUIDE.isPageFound("Searching")) {
            int pos;
            while ((pos = level.pointToCell(new Point(Random.IntRange(this.left + 1, this.right - 1), Random.IntRange(this.top + 1, this.bottom - 2)))) == level.entrance() || level.findMob(level.entrance()) != null) {
            }
            GuidePage p = new GuidePage();
            p.page("Searching");
            level.drop(p, pos);
        }
        Random.popGenerator();
    }

    @Override
    public boolean connect(Room room) {
        if (room instanceof ExitRoom) {
            return false;
        }
        return super.connect(room);
    }
}

