/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.traps;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.PitfallParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Chasm;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;

public class PitfallTrap
extends Trap {
    public PitfallTrap() {
        this.color = 0;
        this.shape = 4;
    }

    @Override
    public void activate() {
        if (Dungeon.bossLevel() || Dungeon.depth > 30 || Dungeon.branch != 0) {
            GLog.w(Messages.get(this, "no_pit", new Object[0]), new Object[0]);
            return;
        }
        DelayedPit p = Buff.append(Dungeon.hero, DelayedPit.class, 1.0f);
        p.depth = Dungeon.depth;
        p.pos = this.pos;
        for (int i : PathFinder.NEIGHBOURS9) {
            if (Dungeon.level.solid[this.pos + i] && !Dungeon.level.passable[this.pos + i]) continue;
            CellEmitter.floor(this.pos + i).burst(PitfallParticle.FACTORY4, 8);
        }
        if (this.pos == Dungeon.hero.pos) {
            GLog.n(Messages.get(this, "triggered_hero", new Object[0]), new Object[0]);
        } else if (Dungeon.level.heroFOV[this.pos]) {
            GLog.n(Messages.get(this, "triggered", new Object[0]), new Object[0]);
        }
    }

    public static class DelayedPit
    extends FlavourBuff {
        int pos;
        int depth;
        int branch;
        private static final String POS = "pos";
        private static final String DEPTH = "depth";
        private static final String BRANCH = "branch";

        public DelayedPit() {
            this.revivePersists = true;
        }

        @Override
        public boolean act() {
            boolean herofell = false;
            if (this.depth == Dungeon.depth && this.branch == Dungeon.branch) {
                for (int i : PathFinder.NEIGHBOURS9) {
                    Char ch;
                    int cell = this.pos + i;
                    if (Dungeon.level.solid[this.pos + i] && !Dungeon.level.passable[this.pos + i]) continue;
                    CellEmitter.floor(this.pos + i).burst(PitfallParticle.FACTORY8, 12);
                    Heap heap = (Heap)Dungeon.level.heaps.get(cell);
                    if (heap != null && heap.type != Heap.Type.FOR_SALE && heap.type != Heap.Type.LOCKED_CHEST && heap.type != Heap.Type.CRYSTAL_CHEST) {
                        for (Item item : heap.items) {
                            Dungeon.dropToChasm(item);
                        }
                        heap.sprite.kill();
                        GameScene.discard(heap);
                        heap.sprite.drop();
                        Dungeon.level.heaps.remove(cell);
                    }
                    if ((ch = Actor.findChar(cell)) == null || ch.flying || ch.alignment == Char.Alignment.NEUTRAL && Char.hasProp(ch, Char.Property.IMMOVABLE)) continue;
                    if (ch == Dungeon.hero) {
                        Chasm.heroFall(cell);
                        herofell = true;
                        continue;
                    }
                    Chasm.mobFall((Mob)ch);
                }
            }
            this.detach();
            return !herofell;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(POS, this.pos);
            bundle.put(DEPTH, this.depth);
            bundle.put(BRANCH, this.branch);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.pos = bundle.getInt(POS);
            this.depth = bundle.getInt(DEPTH);
            this.branch = bundle.getInt(BRANCH);
        }
    }
}

