/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.sprites;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MissileSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MobSprite;
import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;

public class SWATSprite
extends MobSprite {
    private int cellToAttack;

    public SWATSprite() {
        this.texture("sprites/soldier.png");
        TextureFilm frames = new TextureFilm(this.texture, 12, 15);
        this.idle = new MovieClip.Animation(1, true);
        this.idle.frames(frames, 21, 21, 21, 22, 21, 21, 21, 22);
        this.run = new MovieClip.Animation(20, true);
        this.run.frames(frames, 23, 24, 25, 26, 27, 28);
        this.attack = new MovieClip.Animation(15, false);
        this.attack.frames(frames, 29, 30, 31, 21);
        this.zap = this.attack.clone();
        this.die = new MovieClip.Animation(20, false);
        this.die.frames(frames, 32, 33, 34, 35, 36, 35);
        this.play(this.idle);
    }

    @Override
    public void attack(int cell) {
        if (!Dungeon.level.adjacent(cell, this.ch.pos)) {
            this.cellToAttack = cell;
            this.turnTo(this.ch.pos, cell);
            this.play(this.zap);
        } else {
            super.attack(cell);
        }
    }

    @Override
    public void onComplete(MovieClip.Animation anim) {
        if (anim == this.zap) {
            this.idle();
            CellEmitter.get(this.ch.pos).burst(SmokeParticle.FACTORY, 2);
            CellEmitter.center(this.ch.pos).burst(BlastParticle.FACTORY, 2);
            Sample.INSTANCE.play("sounds/hit_crush.mp3", 1.0f, Random.Float(0.33f, 0.66f));
            ((MissileSprite)this.parent.recycle(MissileSprite.class)).reset((Visual)this, this.cellToAttack, (Item)new SWATShot(), new Callback(){

                @Override
                public void call() {
                    SWATSprite.this.ch.onAttackComplete();
                }
            });
        } else {
            super.onComplete(anim);
        }
    }

    public class SWATShot
    extends Item {
        public SWATShot() {
            this.image = ItemSpriteSheet.SNIPER_BULLET;
        }
    }
}

