/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;

public class MiniCheckBox
extends RedButton {
    private boolean checked = false;

    public MiniCheckBox(String label) {
        super(label, 7);
        this.icon(Icons.get(Icons.MINI_UNCHECKED));
    }

    @Override
    protected void layout() {
        super.layout();
        float margin = (this.height - this.text.height()) / 2.0f;
        this.text.setPos(this.x + margin, this.y + margin);
        PixelScene.align(this.text);
        margin = (this.height - this.icon.height) / 2.0f;
        this.icon.x = this.x + this.width - margin - this.icon.width;
        this.icon.y = this.y + margin;
        PixelScene.align(this.icon);
    }

    public boolean checked() {
        return this.checked;
    }

    public void checked(boolean value) {
        if (this.checked != value) {
            this.checked = value;
        }
        this.icon.copy(Icons.get(this.checked ? Icons.MINI_CHECKED : Icons.MINI_UNCHECKED));
    }

    @Override
    protected void onClick() {
        super.onClick();
        this.checked(!this.checked);
    }
}

