# Zotero 翻译服务自动启停教程 (macOS)

![功能效果截图](screenshot.png)

## 版本信息

- **当前版本**: v3.0.29
- **更新日期**: 2025-09-22
- **服务器版本要求**: >= 3.0.29

## 功能介绍

本项目旨在实现 Zotero 与外部翻译服务（通过新版 `server/server.py` 提供）的无缝集成。通过配置一个 macOS 后台服务，可以实现以下自动化流程：

- **自动启停**：当您打开 Zotero 应用程序时，后台会自动启动翻译服务（端口 8888）；关闭 Zotero 时，服务也会被自动终止，释放系统资源。
- **稳定守护**：在 Zotero 运行期间，如果翻译服务因任何原因意外崩溃，后台服务会检测到并在 10 秒内自动重启，确保服务的可用性。
- **静默通知**：服务在启动、停止或翻译PDF时，都会通过macOS通知中心发送静默通知，让您能实时了解服务状态和翻译进度，而不会打扰您的工作流程。
- **多翻译服务支持**：支持 Grok、OpenAI、DeepSeek、Gemini 等多种翻译 API。

本教程将指导你如何使用本文件夹中的脚本（`zotero_monitor.sh`、`start_server.sh`、`com.user.zotero.monitor.plist`），配置这一自动化服务。

## 第一步：环境准备

在开始之前，请确保你的 macOS 系统已经安装了以下软件：

1.  **Homebrew**: macOS 的包管理器。如果未安装，请访问 [brew.sh](https://brew.sh) 获取安装命令。

2.  **Conda (Anaconda / Miniconda)**: 用于管理 Python 环境。推荐安装 [Miniconda](https://docs.conda.io/projects/miniconda/en/latest/)。

3.  **安装依赖包**:
    打开终端，运行以下命令安装必要的工具和 Python 包。

    ```bash
    # 1. 安装桌面通知工具
    brew install terminal-notifier

    # 2. 创建并激活 Conda 环境
    conda create --name zotero-pdf2zh-venv python=3.12 -y
    conda activate zotero-pdf2zh-venv

    # 3. 进入项目目录
    cd /Users/你的用户名/Documents/zotero-pdf2zh

    # 4. 安装 Python 依赖库
    pip install -r server/requirements.txt
    ```

## 第二步：文件结构说明

项目的文件组织如下：

```
/Users/你的用户名/Documents/zotero-pdf2zh/
├── server/
│   ├── server.py              # 翻译服务主程序
│   ├── config/
│   │   └── config.json        # API 配置文件
│   ├── translate_pdf_client.py # PDF 翻译客户端
│   └── translated/            # 翻译文件存放目录
├── macos/
│   ├── zotero_monitor.sh      # 监控脚本
│   ├── start_server.sh        # 手动管理脚本
│   ├── com.user.zotero.monitor.plist  # LaunchAgent配置
│   └── translate_pdf_quick_action.sh  # 右键翻译脚本
└── logs/
    ├── monitor.log            # 监控日志
    ├── server.log             # 服务日志
    └── launchagent_*.log      # LaunchAgent日志
```

## 第三步：配置脚本

### 1. 监控脚本配置

`zotero_monitor.sh` 已预配置好，主要配置项：

```bash
# --- 配置 ---
PROJECT_PATH="/Users/你的用户名/Documents/zotero-pdf2zh"
CONDA_ENV_NAME="zotero-pdf2zh-venv"
SERVER_PORT=8888
```

如果你的路径或环境名不同，请相应修改。

### 2. 手动管理脚本

`start_server.sh` 提供手动管理服务的功能：

```bash
# 启动服务
./start_server.sh start

# 停止服务
./start_server.sh stop

# 重启服务
./start_server.sh restart

# 查看状态
./start_server.sh status

# 查看日志
./start_server.sh logs
```

### 3. LaunchAgent 配置

`com.user.zotero.monitor.plist` 是 macOS `launchd` 服务的配置文件，是实现自动化的核心。

**主要配置说明**:

- **监控脚本路径**: `/Users/你的用户名/Documents/zotero-pdf2zh/macos/zotero_monitor.sh`
- **运行间隔**: 每 10 秒检查一次
- **日志位置**: `~/Documents/zotero-pdf2zh/logs/`
- **环境变量**: 包含 conda 和 terminal-notifier 路径

### 4. 设置文件权限

确保脚本有执行权限：

```bash
cd /Users/你的用户名/Documents/zotero-pdf2zh/macos
chmod +x zotero_monitor.sh
chmod +x start_server.sh
chmod +x translate_pdf_quick_action.sh
```

## 第四步：配置翻译 API

### 1. 编辑配置文件

打开配置文件：

```bash
nano /Users/你的用户名/Documents/zotero-pdf2zh/server/config/config.json
```

### 2. 添加 API 密钥

配置示例（以 Grok 为例）：

```json
{
    "USE_MODELSCOPE": "0",
    "PDF2ZH_LANG_FROM": "English",
    "PDF2ZH_LANG_TO": "Simplified Chinese",
    "translators": [
        {
            "name": "grok",
            "envs": {
                "GROK_API_KEY": "xai-xxxxxxxxxxxxxxxxxxxxxx",
                "GROK_MODEL": "grok-2-1212"
            }
        },
        {
            "name": "openai",
            "envs": {
                "OPENAI_API_KEY": "sk-xxxxxxxxxxxxxxxxxxxxxx",
                "OPENAI_BASE_URL": "https://api.openai.com/v1",
                "OPENAI_MODEL": "gpt-4o-mini"
            }
        }
    ],
    "NOTO_FONT_PATH": "/app/SourceHanSerifCN-Regular.ttf"
}
```

### 3. 支持的翻译服务

- **Grok** - 推荐，快速准确（$25/月）
- **OpenAI** - GPT-4 高质量
- **DeepSeek** - 中文优化，性价比高
- **Gemini** - Google AI，有免费额度
- **智谱 AI** - 国内服务
- **阿里千问** - 专业翻译模型
- **Silicon Flow** - 多模型支持
- **Ollama** - 本地运行，隐私保护
- **Bing** - 完全免费

详细配置请参考 [API_SETUP.md](API_SETUP.md)。

## 第五步：启动服务

### 方法一：配置自动启动（推荐）

完成以上所有配置后，运行以下命令来加载并启动你的后台服务：

```bash
# 复制 LaunchAgent 配置文件
cp /Users/你的用户名/Documents/zotero-pdf2zh/macos/com.user.zotero.monitor.plist ~/Library/LaunchAgents/

# 加载服务
launchctl load ~/Library/LaunchAgents/com.user.zotero.monitor.plist
```

如果将来你需要修改脚本并重新加载服务，可以运行：

```bash
launchctl unload ~/Library/LaunchAgents/com.user.zotero.monitor.plist
launchctl load ~/Library/LaunchAgents/com.user.zotero.monitor.plist
```

### 方法二：手动启动

```bash
cd /Users/你的用户名/Documents/zotero-pdf2zh/macos
./start_server.sh start
```

## 第六步：验证和调试

服务现在应该已经在后台运行了。

### 1. 功能验证

- **启动/关闭 Zotero**: 尝试打开和关闭 Zotero 应用程序。你应该会收到服务启动和停止的桌面通知。

- **检查服务状态**:

    ```bash
    ./start_server.sh status
    ```

- **测试翻译功能**: 在 Zotero 中选择 PDF 文件进行翻译。

### 2. 查看日志

如果遇到问题，日志是最好的朋友。

- **监控脚本日志**:

    ```bash
    tail -f ~/Documents/zotero-pdf2zh/logs/monitor.log
    ```

- **Python 服务日志**:

    ```bash
    tail -f ~/Documents/zotero-pdf2zh/logs/server.log
    ```

- **LaunchAgent 日志**:
    ```bash
    tail -f ~/Documents/zotero-pdf2zh/logs/launchagent_out.log
    ```

### 3. 常见问题排查

#### 问题：服务无法启动

```bash
# 检查端口占用
lsof -i :8888

# 检查 Python 环境
conda activate zotero-pdf2zh-venv
which python
python --version
```

#### 问题：权限错误

```bash
# 清除扩展属性
xattr -cr /Users/你的用户名/Documents/zotero-pdf2zh/macos/

# 重新设置权限
chmod +x macos/*.sh
```

#### 问题：API 密钥被清除

确保使用 v3.0.29 或更高版本，该版本已修复此问题。

#### 问题：LaunchAgent 不工作

```bash
# 查看 LaunchAgent 状态
launchctl list | grep zotero

# 查看详细错误
launchctl print user/$(id -u)/com.user.zotero.monitor
```

## 第七步：配置右键翻译（可选）

如需在 Finder 中右键翻译 PDF 文件，请参考 [右键菜单配置教程.md](右键菜单配置教程.md)。

## 高级功能

### 使用自动安装脚本

提供了自动安装脚本，可以一键完成所有配置：

```bash
cd /Users/你的用户名/Documents/zotero-pdf2zh/macos
chmod +x install.sh
./install.sh
```

### 监控仪表板

创建实时监控仪表板：

```bash
# 创建监控脚本
cat > ~/monitor_dashboard.sh << 'EOF'
#!/bin/bash
while true; do
    clear
    echo "======================================"
    echo "   Zotero PDF2ZH 监控仪表板"
    echo "   $(date '+%Y-%m-%d %H:%M:%S')"
    echo "======================================"

    echo -n "Zotero 状态: "
    if pgrep -f "Zotero.app" > /dev/null; then
        echo "🟢 运行中"
    else
        echo "🔴 未运行"
    fi

    echo -n "翻译服务: "
    if lsof -i :8888 > /dev/null 2>&1; then
        echo "🟢 运行中"
    else
        echo "🔴 未运行"
    fi

    echo ""
    echo "最近日志:"
    tail -5 ~/Documents/zotero-pdf2zh/logs/monitor.log

    sleep 5
done
EOF

chmod +x ~/monitor_dashboard.sh
~/monitor_dashboard.sh
```

## 卸载方法

如需完全卸载服务：

```bash
# 1. 卸载 LaunchAgent
launchctl unload ~/Library/LaunchAgents/com.user.zotero.monitor.plist
rm ~/Library/LaunchAgents/com.user.zotero.monitor.plist

# 2. 停止服务
cd /Users/你的用户名/Documents/zotero-pdf2zh/macos
./start_server.sh stop

# 3. 删除项目文件（可选）
# rm -rf ~/Documents/zotero-pdf2zh
```

## 更新日志

### v3.0.30 (2025-09-22)

- ✅ 适配新版服务器架构（server/server.py）
- ✅ 修复 API 密钥自动清除问题
- ✅ 添加 terminal-notifier 通知支持
- ✅ 改进 LaunchAgent 配置
- ✅ 添加手动管理脚本 start_server.sh
- ✅ 支持多种翻译 API 服务
- ✅ 优化错误处理机制

---

## 致谢与免责声明

### 开源与贡献

本项目作为一个开源解决方案，旨在为 Zotero 用户提供便利。代码中可能存在未知的 Bug 或潜在的安全风险，欢迎社区开发者一同参与，提出改进意见或代码贡献，使其更加完善和健壮。

特别地，目前的方案仅针对 macOS。我们非常期待有能力的开发者能将其移植到 **Windows** 和 **Linux** 平台，造福更广泛的用户群体。

### 上手门槛与配置

请注意，本方案具有一定的上手门槛，需要用户对命令行和文件路径有基本的了解。在部署时，请务必仔细检查并修改配置文件中的所有路径和环境名称设置，确保它们与您的个人电脑配置完全一致。我们也期待有经验的开发者能帮助优化部署流程，进一步降低普通用户的上手门槛。

### **重要警告与免责声明**

此后台服务会持续在后台运行进程。如果您需要在电脑上运行任何带有**反作弊或系统监控软件**的程序（例如：**在线考试、远程面试、网络游戏**等），请务必**提前卸载或关闭**此后台服务，以避免任何潜在的冲突或被误判为作弊行为。

**卸载命令**:

```bash
launchctl unload ~/Library/LaunchAgents/com.user.zotero.monitor.plist
rm ~/Library/LaunchAgents/com.user.zotero.monitor.plist
```

**因使用此服务而导致的任何直接或间接问题，包括但不限于考试成绩无效、账号封禁等，本人概不负责。请您在充分理解其工作原理后，谨慎使用。**
