# SaltStack Arbitrary File Read and Write (CVE-2020-11652)

[中文版本(Chinese version)](README.zh-cn.md)

SaltStack is a Python-based client-server configuration management tool. A security team disclosed that SaltStack has an authentication bypass vulnerability (CVE-2020-11651) and a directory traversal vulnerability (CVE-2020-11652).

In the CVE-2020-11652, attackers can read and write arbitrary files on the server by constructing malicious requests.

References:

- https://labs.f-secure.com/advisories/saltstack-authorization-bypass
- [https://github.com/rossengeorgiev/salt-security-backports][1]
- [https://github.com/jasperla/CVE-2020-11651-poc][2]

## Environment Setup

Execute the following command to start a SaltStack Master service 2019.2.3:

```
docker compose up -d
```

After the environment starts, the following ports will be listening:

- 4505/4506: These are the ports for communication between SaltStack Master and minions
- 8000: This is the Salt API port
- 2222: This is the SSH server port inside the container

## Vulnerability Reproduction

This document demonstrates the CVE-2020-11652 vulnerability, referring to the vulnerability author's explanation:

> The wheel module contains commands used to read and write files under specific directory paths. The inputs to these functions are concatenated with the target directory and the resulting path is not canonicalized, leading to an escape of the intended path restriction.

The write method in wheel/file_roots.py uses `os.path.isabs` to check if the user input is an absolute path, possibly to prevent writing to other directories. However, attackers can actually use `../` to traverse to the root directory and write arbitrary files:

```
msg = {
    'key': root_key,
    'cmd': 'wheel',
    'fun': 'file_roots.write',
    'path': '../../path/to/target',
    'data': 'test'
#    'saltenv': 'base',
  }
```

Referring to [this project][1], we can write a simple POC to write to `/etc/cron.d/shell` and use crontab to execute arbitrary commands:

![](1.png)

`id > /tmp/success` was successfully executed.

You can also use this [POC][2] to reproduce the vulnerability.

[1]: https://github.com/rossengeorgiev/salt-security-backports
[2]: https://github.com/jasperla/CVE-2020-11651-poc
