# Weblogic Arbitrary File Upload Vulnerability (CVE-2018-2894)

[中文版本(Chinese version)](README.zh-cn.md)

Oracle Weblogic Server is a popular enterprise application server that provides a wide range of features for building and deploying enterprise applications.

In Oracle's July 2018 update, a vulnerability in the Weblogic Web Service Test Page was fixed that allowed arbitrary file upload. The Web Service Test Page is disabled by default in "Production Mode", so this vulnerability has certain limitations.

By exploiting this vulnerability, attackers can upload arbitrary JSP files and gain server access.

Reference links:

- http://www.oracle.com/technetwork/security-advisory/cpujul2018-4258247.html
- https://mp.weixin.qq.com/s/y5JGmM-aNaHcs_6P9a-gRQ
- https://xz.aliyun.com/t/2458

## Environment Setup

Execute the following command to start Weblogic 12.2.1.3:

```
docker compose up -d
```

After the environment starts, visit `http://your-ip:7001/console` to see the backend login page.

Execute `docker compose logs | grep password` to view the administrator password. The administrator username is `weblogic`.

After logging into the backend, click on the `base_domain` configuration, and in "Advanced" enable the "Enable Web Service Test Page" option:

![](img/1.png)

## Vulnerability Reproduce

As a attacker, visit `http://your-ip:7001/ws_utc/config.do` and set the Work Home Dir to `/u01/oracle/user_projects/domains/base_domain/servers/AdminServer/tmp/_WL_internal/com.oracle.webservices.wls.ws-testclient-app-wls/4mcj4y/war/css`. We set the directory to the static file CSS directory of the `ws_utc` application because this directory can be accessed without permissions, which is crucial.

![](img/2.png)

Then click on Security -> Add, and upload a webshell:

![](img/3.png)

After uploading, check the returned data packet which contains a timestamp:

![](img/4.png)

Then visit `http://your-ip:7001/ws_utc/css/config/keystore/[timestamp]_[filename]` to execute the webshell:

![](img/5.png)
