<?php

/**
 * intro.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // index
    'index_intro'                                                     => 'Vítejte na titulní stránce Firefly III. Věnujte čas projití se tímto úvodem, abyste se dozvěděli, jak Firefly III funguje.',
    'index_accounts-chart'                                            => 'Tento graf zobrazuje stávající zůstatky vašich majetkových účtů. Jaké účty se zde mají zobrazovat lze nastavit v předvolbách.',
    'index_box_out_holder'                                            => 'Tato malá oblast a ty další vedle něho podávají rychlý přehled vaší finanční situace.',
    'index_help'                                                      => 'Pokud budete potřebovat nápovědu ke stránce nebo formuláři, klikněte na toto tlačítko.',
    'index_outro'                                                     => 'Většina stránek Firefly III začíná krátkou prohlídkou, jako je tato. Obraťte se na mně, pokud máte dotazy nebo komentáře. Ať poslouží!',
    'index_sidebar-toggle'                                            => 'Nabídku pod touto ikonou použijte pro vytváření nových transakcí, účtů a ostatní věcí.',
    'index_cash_account'                                              => 'Toto jsou doposud vytvořené účty. Hotovostní účet můžete použít pro sledování výdajů v hotovosti, ale není to pochopitelně povinné.',

    // transactions
    'transactions_create_basic_info'                                  => 'Zadejte základní informace o vaší transakci. Zdroj, cíl, datum a popis.',
    'transactions_create_amount_info'                                 => 'Zadejte částku transakce. V případě potřeby budou pole automaticky aktualizována pro informace o zahraniční měně.',
    'transactions_create_optional_info'                               => 'Všechna tato pole jsou nepovinná. Přidáním metadat se ale vaše transakce lépe organizují.',
    'transactions_create_split'                                       => 'Pokud chcete transakci rozdělit, přidejte další rozdělení s tímto tlačítkem',

    // create account:
    'accounts_create_iban'                                            => 'Zadejte u svých účtů platný IBAN identifikátor. To by v budoucnu mohlo velmi ulehčit import dat.',
    'accounts_create_asset_opening_balance'                           => 'Majetkové účty mohou mít „počáteční zůstatek“, označující začátek historie tohoto účtu ve Firefly III.',
    'accounts_create_asset_currency'                                  => 'Firefly III podporuje vícero měn. Majetkové účty mají jednu hlavní měnu, kterou je třeba nastavit zde.',
    'accounts_create_asset_virtual'                                   => 'Někdy se může hodit dát svému účtu virtuální zůstatek: extra částku, vždy přičítanou nebo odečítanou od stávajícího zůstatku.',

    // budgets index
    'budgets_index_intro'                                             => 'Rozpočty slouží ke správě vašich financí a tvoří jednu z hlavních funkcí Firefly III.',
    'budgets_index_see_expenses_bar'                                  => 'Utracené peníze budou zvolna plnit tento pruh.',
    'budgets_index_navigate_periods'                                  => 'Procházejte obdobími a jednoduše nastavujte rozpočty dopředu.',
    'budgets_index_new_budget'                                        => 'Vytvářejte nové rozpočty, jak uznáte za vhodné.',
    'budgets_index_list_of_budgets'                                   => 'Použijte tuto tabulku k nastavení částek pro každý rozpočet a zjistěte, jak na tom jste.',
    'budgets_index_outro'                                             => 'Pokud se chcete dozvědět více o tvorbě rozpočtů, klikněte na ikonu nápovědy v pravém horním rohu.',



    // reports (index)
    'reports_index_intro'                                             => 'Pomocí těchto přehledů získáte podrobné informace o svých financích.',
    'reports_index_inputReportType'                                   => 'Vyberte typ přehledu. Podívejte se na stránky nápovědy a zjistěte, co vám každý přehled ukazuje.',
    'reports_index_inputAccountsSelect'                               => 'Můžete vynechávat nebo zahrnovat majetkové účty, jak potřebujete.',
    'reports_index_inputDateRange'                                    => 'Vybrané období je zcela na vás: od jednoho dne do 10 let a více.',
    'reports_index_extra-options-box'                                 => 'Podle toho, jaký výkaz jste vybrali, je zde možné vybrat další filtry a volby. Při změně typu výkazu sledujte tuto oblast.',

    // reports (reports)
    'reports_report_default_intro'                                    => 'Tento výkaz vám podá rychlý a podrobný přehled vašich financí. Pokud chcete vidět něco jiného, neváhejte se na mne obrátit!',
    'reports_report_audit_intro'                                      => 'Tento výkaz vám podá podrobný vhled do vašich majetkových účtů.',
    'reports_report_audit_optionsBox'                                 => 'Pomocí těchto zaškrtávacích kolonek zobrazujte nebo skrývejte sloupce, které vás (ne)zajímají.',

    'reports_report_category_intro'                                   => 'Tato sestava vám podá vhled do jedné nebo více kategorií.',
    'reports_report_category_pieCharts'                               => 'Tyto grafy vám podají vhled do výdajů a příjmů pro jednotlivé kategorie nebo účty.',
    'reports_report_category_incomeAndExpensesChart'                  => 'Tento graf zobrazuje vaše náklady a příjmy v jednotlivých kategoriích.',

    'reports_report_tag_intro'                                        => 'Tato sestava vám podává vhled do jednoho nebo více štítků.',
    'reports_report_tag_pieCharts'                                    => 'Tyto grafy vám podávají vhled do nákladů a příjmů pro jednotlivé štítky, účty, kategorie nebo rozpočty.',
    'reports_report_tag_incomeAndExpensesChart'                       => 'Tento graf zobrazuje vaše výdaje a příjmy pro každý štítek.',

    'reports_report_budget_intro'                                     => 'Tato sestava vám dává vhled do jednoho nebo více rozpočtů.',
    'reports_report_budget_pieCharts'                                 => 'Tyto grafy vám podají vhled do výdajů pro jednotlivé rozpočty nebo účty.',
    'reports_report_budget_incomeAndExpensesChart'                    => 'Tento graf zobrazuje vaše výdaje v jednotlivých rozpočtech.',

    // create transaction
    'transactions_create_switch_box'                                  => 'Pomocí těchto tlačítek můžete rychle přepínat typ transakce, kterou chcete uložit.',
    'transactions_create_ffInput_category'                            => 'Do této kolonky si můžete napsat, co chcete. Budou navrhovány dříve vytvořené kategorie.',
    'transactions_create_withdrawal_ffInput_budget'                   => 'Propojte svůj výběr s rozpočtem a získáte lepší kontrolu nad financemi.',
    'transactions_create_withdrawal_currency_dropdown_amount'         => 'Tuto rozbalovací nabídku použijte pokud je váš výběr v jiné měně.',
    'transactions_create_deposit_currency_dropdown_amount'            => 'Tuto rozbalovací nabídku použijte, pokud je váš vklad v jiné měně.',
    'transactions_create_transfer_ffInput_piggy_bank_id'              => 'Vyberte pokladničku a propojte tento převod se svými úsporami.',

    // piggy banks index:
    'piggy-banks_index_saved'                                         => 'Tato kolonka zobrazuje, kolik jste naspořili v každé z pokladniček.',
    'piggy-banks_index_button'                                        => 'Vedle tohoto ukazatele postupu se nachází dvě tlačítka (+ a -) pro přidání nebo odebrání peněz z každé z pokladniček.',
    'piggy-banks_index_accountStatus'                                 => 'Pro každý majetkový účet s alespoň jednou pokladničkou je v této tabulce vypsán stav.',



    // create piggy
    'piggy-banks_create_name'                                         => 'Co je vašim cílem? Nová pohovka, fotoaparát, rezerva pro nečekané výdaje?',
    'piggy-banks_create_date'                                         => 'Pro pokladničku je možné nastavit cílové datum nebo termín.',

    // show piggy
    'piggy-banks_show_piggyChart'                                     => 'Tento graf bude zobrazovat historii vaší pokladničky.',
    'piggy-banks_show_piggyDetails'                                   => 'Nějaké podrobnosti o vaší pokladničce',
    'piggy-banks_show_piggyEvents'                                    => 'Jsou zde uvedeny také všechny přírůstky i odebrání.',

    // bill index
    'bills_index_rules'                                               => 'Here you see which rules will check if this subscription is hit',
    'bills_index_paid_in_period'                                      => 'This field indicates when the subscription was last paid.',
    'bills_index_expected_in_period'                                  => 'This field indicates for each subscription if and when the next subscription is expected to hit.',

    'subscriptions_index_rules'                                       => 'Here you see which rules will check if this subscription is hit',
    'subscriptions_index_paid_in_period'                              => 'This field indicates when the subscription was last paid.',
    'subscriptions_index_expected_in_period'                          => 'This field indicates for each subscription if and when the next subscription is expected to hit.',

    // show bill
    'bills_show_billInfo'                                             => 'This table shows some general information about this subscription.',
    'bills_show_billButtons'                                          => 'Use this button to re-scan old transactions so they will be matched to this subscription.',
    'bills_show_billChart'                                            => 'This chart shows the transactions linked to this subscription.',
    'subscriptions_show_billInfo'                                     => 'This table shows some general information about this subscription.',
    'subscriptions_show_billButtons'                                  => 'Use this button to re-scan old transactions so they will be matched to this subscription.',
    'subscriptions_show_billChart'                                    => 'This chart shows the transactions linked to this subscription.',

    // create bill
    'bills_create_intro'                                              => 'Use subscriptions to track the amount of money you\'re due every period. Think about expenses like rent, insurance or mortgage payments.',
    'bills_create_name'                                               => 'Zadejte výstižný název, jako „Nájem“ nebo „Životní pojištění“.',
    // 'bills_create_match'                                      => 'To match transactions, use terms from those transactions or the expense account involved. All words must match.',
    'bills_create_amount_min_holder'                                  => 'Select a minimum and maximum amount for this subscription.',
    'bills_create_repeat_freq_holder'                                 => 'Most subscriptions repeat monthly, but you can set another frequency here.',
    'bills_create_skip_holder'                                        => 'If a subscription repeats every 2 weeks, the "skip"-field should be set to "1" to skip every other week.',

    // rules index
    'rules_index_intro'                                               => 'Firefly III umožňuje spravovat pravidla, která budou automaticky uplatňována na všechny transakce které vytvoříte nebo upravíte.',
    'rules_index_new_rule_group'                                      => 'Pro snazší zprávu je pravidla možné kombinovat ve skupinách.',
    'rules_index_new_rule'                                            => 'Vytvořte tolik pravidel, kolik chcete.',
    'rules_index_prio_buttons'                                        => 'Seřaďte je tak, jak se vám to hodí.',
    'rules_index_test_buttons'                                        => 'Pravidla je možné vyzkoušet nebo uplatnit na existující transakce.',
    'rules_index_rule-triggers'                                       => 'Pravidla mají „spouštěče“ a „akce“. Jejich pořadí je možné měnit jejich přetahováním.',
    'rules_index_outro'                                               => 'Podívejte se do nápovědy (ikona otazníku v pravém horním rohu)!',

    // create rule:
    'rules_create_mandatory'                                          => 'Zvolte výstižný název a nastavte, kdy má být pravidlo spuštěno.',
    'rules_create_ruletriggerholder'                                  => 'Přidejte tolik spouštěčů, kolik potřebujete, ale pamatujte, že aby byla spuštěná jakákoli akce je třeba, aby byly splněny podmínky VŠECH nastavených spouštěčů.',
    'rules_create_test_rule_triggers'                                 => 'Toto tlačítko slouží ke zobrazení transakcí, které odpovídají pravidlu.',
    'rules_create_actions'                                            => 'Nastavte tolik akcí, kolik chcete.',



    // preferences
    'preferences_index_tabs'                                          => 'Další volby jsou k dispozici v kartách.',

    // currencies
    'currencies_index_intro'                                          => 'Firefly III podporuje více měn, které můžete měnit na této stránce.',
    'currencies_index_default'                                        => 'Firefly III má jednu výchozí měnu.',
    'currencies_index_buttons'                                        => 'Tato tlačítka slouží pro změnu výchozí měny nebo pro zapnutí dalších měn.',

    // create currency
    'currencies_create_code'                                          => 'Tento kód by měl být v souladu s normou ISO (vyhledejte si pro novou měnu).',
];
