<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'gespeichert in „:timezone“',
    'displayed_in_tz'                           => 'angezeigt in „:timezone“',
    'close'                                     => 'Schließen',
    'actions'                                   => 'Aktionen',
    'edit'                                      => 'Bearbeiten',
    'loading'                                   => 'Wird geladen',
    'transaction_journal_id'                    => 'Buchungsnummer',
    'delete'                                    => 'Löschen',
    'split'                                     => 'Teilen',
    'single_split'                              => 'Teilen',
    'clone'                                     => 'Duplizieren',
    'clone_and_edit'                            => 'Duplizieren und Bearbeiten',
    'confirm_action'                            => 'Aktion bestätigen',
    'last_seven_days'                           => 'Letzte sieben Tage',
    'last_thirty_days'                          => 'Letzte 30 Tage',
    'last_180_days'                             => 'Letzte 180 Tage',
    'month_to_date'                             => 'Bisheriger Monat',
    'year_to_date'                              => 'Bisheriges Jahr',
    'YTD'                                       => 'Seit Jahresbeginn',
    'welcome_back'                              => 'Überblick',
    'main_dashboard_page_title'                 => 'Startseite',
    'everything'                                => 'Alle',
    'today'                                     => 'Heute',
    'customRange'                               => 'Individueller Bereich',
    'date_range'                                => 'Datumsbereich',
    'apply'                                     => 'Übernehmen',
    'select_date'                               => 'Wähle ein Datum..',
    'cancel'                                    => 'Abbrechen',
    'from'                                      => 'Von',
    'to'                                        => 'Bis',
    'structure'                                 => 'Struktur',
    'help_translating'                          => 'Dieser Hilfetext ist noch nicht in Deutsch verfügbar. <a href="https://crowdin.com/project/firefly-iii-help">Möchten Sie beim Übersetzen helfen?</a>',
    'showEverything'                            => 'Alles anzeigen',
    'never'                                     => 'Nie',
    'no_results_for_empty_search'               => 'Ihre Suche war leer, also wurde nichts gefunden.',
    'removed_amount'                            => ':amount entfernt',
    'added_amount'                              => ':amount hinzugefügt',
    'asset_account_role_help'                   => 'Alle zusätzlichen Optionen können später eingestellt werden.',
    'Opening balance'                           => 'Eröffnungssaldo',
    'create_new_stuff'                          => 'Erstelle neue Dinge',
    'new_withdrawal'                            => 'Neue Ausgabe',
    'create_new_transaction'                    => 'Neue Buchung erstellen',
    'sidebar_frontpage_create'                  => 'Erstellen',
    'new_transaction'                           => 'Neue Buchung',
    'no_rules_for_bill'                         => 'Diesem Abonnement sind keine Regeln zugeordnet.',
    'go_to_asset_accounts'                      => 'Bestandskonten anzeigen',
    'go_to_budgets'                             => 'Budgets anzeigen',
    'go_to_withdrawals'                         => 'Ausgaben anzeigen',
    'clones_journal_x'                          => 'Diese Buchung ist ein Duplikat von ":description" (#:id)',
    'go_to_categories'                          => 'Kategorien anzeigen',
    'go_to_bills'                               => 'Ihre Abonnements aufrufen',
    'go_to_expense_accounts'                    => 'Ausgabenkonten anzeigen',
    'go_to_revenue_accounts'                    => 'Einnahmekonten anzeigen',
    'go_to_piggies'                             => 'Sparschweine anzeigen',
    'new_deposit'                               => 'Neue Einnahme',
    'new_transfer'                              => 'Neue Umbuchung',
    'new_transfers'                             => 'Neue Umbuchung',
    'new_asset_account'                         => 'Neues Bestandskonto',
    'new_expense_account'                       => 'Neues Ausgabenkonto',
    'new_revenue_account'                       => 'Neues Einnahmenkonto',
    'new_liabilities_account'                   => 'Neue Verbindlichkeit',
    'new_budget'                                => 'Neues Budget',
    'new_bill'                                  => 'Neues Abonnement',
    'block_account_logout'                      => 'Sie wurden ausgeloggt. Blockierte Benutzerkonten können diese Seite nicht nutzen. Haben Sie sich mit einer gültigen E-Mail Adresse registriert?',
    'flash_success'                             => 'Geschafft!',
    'flash_info'                                => 'Nachricht',
    'flash_warning'                             => 'Achtung!',
    'flash_error'                               => 'Fehler!',
    'flash_danger'                              => 'Achtung!',
    'flash_info_multiple'                       => 'Es gibt eine Nachricht | Es gibt :count Nachrichten',
    'flash_error_multiple'                      => 'Es gibt einen Fehler|Es gibt :count Fehler',
    'net_worth'                                 => 'Eigenkapital',
    'help_for_this_page'                        => 'Hilfe zu dieser Seite',
    'help_for_this_page_body'                   => 'Weitere Informationen über diese Seite <a href="https://docs.firefly-iii.org/">finden Sie in unserer Dokumentation (engl.)</a>.',
    'two_factor_welcome'                        => 'Hallo!',
    'two_factor_enter_code'                     => 'Um fortzufahren geben Sie bitte ihren Zwei-Faktor-Authentifizierungscode ein. Ihre Anwendung kann diesen für Sie generieren.',
    'two_factor_code_here'                      => 'Code hier eingeben',
    'two_factor_title'                          => 'Zwei-Faktor-Authentifizierung',
    'authenticate'                              => 'Authentifizieren',
    'two_factor_forgot_title'                   => 'Zwei-Faktor-Authentifizierung verloren',
    'two_factor_forgot'                         => 'Ich kann keine 2FA-Codes generieren.',
    'two_factor_lost_header'                    => 'Haben Sie ihre Zwei-Faktor-Authentifizierung verloren?',
    'two_factor_lost_intro'                     => 'Wenn Sie auch Ihre Sicherungsschlüssel verloren haben, haben Sie Pech. Dies ist nichts, was Sie über die Weboberfläche beheben können. Sie haben jedoch zwei Möglichkeiten.',
    'two_factor_lost_fix_self'                  => 'Wenn Sie Ihre eigene Instanz von Firefly III betreiben, lesen Sie <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working>diesen Eintrag im FAQ</a> für Anweisungen.',
    'two_factor_lost_fix_owner'                 => 'Ansonsten, mailen Sie dem Inhaber der Website, <a href="mailto::site_owner">:site_owner</a> und bitten Sie ihn, Ihre Zwei-Faktor Authentifizierung zurückzusetzen.',
    'mfa_backup_code'                           => 'Sie haben sich mit einem Sicherungsschlüssel bei Firefly III angemeldet. Dieser kann nun nicht mehr verwendet werden, also streichen Sie ihn aus Ihrer Liste.',
    'pref_two_factor_new_backup_codes'          => 'Neue Sicherungsschlüssel abrufen',
    'pref_two_factor_backup_code_count'         => 'Sie haben :count gültigen Backup-Code.|Sie haben :count gültige Backup-Codes.',
    '2fa_i_have_them'                           => 'Wurde gespeichert!',
    'warning_much_data'                         => ':days Tage Daten können eine Weile zum Laden benötigen.',
    'registered'                                => 'Sie haben sich erfolgreich registriert!',
    'Default asset account'                     => 'Standard-Bestandskonto',
    'no_budget_pointer'                         => 'Sie scheinen noch keine Budgets festgelegt zu haben. Sie sollten einige davon auf der Seite <a href="budgets">Budgets</a> anlegen. Budgets können Ihnen dabei helfen, den Überblick über die Ausgaben zu behalten.',
    'no_bill_pointer'                           => 'Sie scheinen noch kein Abonnement zu haben. Sie sollten einige auf der Seite <a href="subscriptions">Abonnement</a> erstellen. Abonnements können Ihnen helfen, den Überblick über Ihre Ausgaben zu behalten.',
    'Savings account'                           => 'Sparkonto',
    'Credit card'                               => 'Kreditkarte',
    'source_accounts'                           => 'Quellkonto|Quellkonten',
    'destination_accounts'                      => 'Zielkonto|Zielkonten',
    'user_id_is'                                => 'Ihre Benutzerkennung ist <strong>:user</strong>',
    'field_supports_markdown'                   => 'Dieses Feld unterstützt <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Wenn Sie Hilfe beim Bedienen von Firefly III brauchen, <a href="https://github.com/firefly-iii/firefly-iii/issues">erstellen Sie ein Ticket auf Github</a>.',
    'reenable_intro_text'                       => 'Sie können <a href="#" id="reenableGuidance">die Einführungsanleitung</a> auch erneut aktivieren.',
    'intro_boxes_after_refresh'                 => 'Die Einführungsfelder werden wieder angezeigt, wenn Sie die Seite aktualisieren.',
    'show_all_no_filter'                        => 'Alle Buchungen anzeigen, ohne diese nach Datum zu gruppieren.',
    'expenses_by_category'                      => 'Ausgaben nach Kategorie',
    'expenses_by_budget'                        => 'Ausgaben nach Budget',
    'income_by_category'                        => 'Einnahmen nach Kategorie',
    'expenses_by_asset_account'                 => 'Ausgaben nach Bestandskonto',
    'expenses_by_expense_account'               => 'Ausgaben nach Zielkonto',
    'cannot_redirect_to_account'                => 'Entschuldigen Sie bitte. Firefly III kann Sie nicht zur richtigen Seite weiterleiten.',
    'sum_of_expenses'                           => 'Summe von Ausgaben',
    'sum_of_income'                             => 'Summe von Einnahmen',
    'liabilities'                               => 'Verbindlichkeiten',
    'spent_in_specific_budget'                  => 'Ausgaben im Budget „:budget”',
    'spent_in_specific_double'                  => 'Ausgaben auf Konto ":account"',
    'earned_in_specific_double'                 => 'Einnahmen auf Konto ":account"',
    'source_account'                            => 'Quellkonto',
    'source_account_reconciliation'             => 'Sie können das Quellkonto einer Kontenausgleichsbuchung nicht bearbeiten.',
    'destination_account'                       => 'Zielkonto',
    'destination_account_reconciliation'        => 'Sie können das Zielkonto einer Kontenausgleichsbuchung nicht bearbeiten.',
    'sum_of_expenses_in_budget'                 => 'Gesamtausgaben im Budget „:budget”',
    'left_in_budget_limit'                      => 'Verbleibend zum Ausgeben laut der Budgetplanung',
    'current_period'                            => 'Aktueller Zeitraum',
    'show_the_current_period_and_overview'      => 'Zeigen Sie den aktuellen Zeitraum und die Übersicht',
    'pref_languages_locale'                     => 'Damit eine andere Sprache als Englisch richtig funktioniert muss Ihr Betriebssystem mit den korrekten Gebietsschema-Informationen ausgestattet werden. Wenn diese nicht vorhanden sind, können die Währungsdaten, Termine und Mengen falsch formatiert sein.',
    'budget_in_period'                          => 'Alle Buchungen für den Kostenrahmen „:name” zwischen :start und :end in :currency',
    'chart_budget_in_period'                    => 'Diagramm für alle Buchungen für den Kostenrahmen ":name" zwischen :start und :end in :currency',
    'chart_budget_in_period_only_currency'      => 'Der von Ihnen geplante Betrag war in :currency, so dass dieses Diagramm nur die Buchungen in :currency anzeigt.',
    'chart_account_in_period'                   => 'Diagramm für alle Buchungen für das Konto „:name” (:balance) zwischen :start und :end',
    'chart_category_in_period'                  => 'Diagramm für alle Buchungen der Kategorie „:name” zwischen :start und :end',
    'chart_category_all'                        => 'Diagramm für alle Buchungen der Kategorie „:name”',
    'clone_withdrawal'                          => 'Diese Ausgabe duplizieren',
    'clone_deposit'                             => 'Diese Einnahme duplizieren',
    'clone_transfer'                            => 'Diese Umbuchung duplizieren',
    'multi_select_no_selection'                 => 'Nichts ausgewählt',
    'multi_select_select_all'                   => 'Alle auswählen',
    'multi_select_n_selected'                   => 'ausgewählt',
    'multi_select_all_selected'                 => 'Alle ausgewählt',
    'multi_select_filter_placeholder'           => 'Suche..',
    'intro_next_label'                          => 'Nächste',
    'intro_prev_label'                          => 'Vorherige',
    'intro_skip_label'                          => 'Überspringen',
    'intro_done_label'                          => 'Erledigt',
    'between_dates_breadcrumb'                  => 'Zwischen :start und :end',
    'all_journals_without_budget'               => 'Alle Buchungen ohne Budget',
    'journals_without_budget'                   => 'Buchungen ohne Budget',
    'all_journals_without_category'             => 'Alle Buchungen ohne Kategorie',
    'journals_without_category'                 => 'Buchungen ohne Kategorie',
    'all_journals_for_account'                  => 'Alle Buchungen für Konto „:name”',
    'chart_all_journals_for_account'            => 'Diagramm für alle Buchungen des Kontos „:name”',
    'journals_in_period_for_account'            => 'Alle Buchungen für Konto „:name” zwischen :start und :end',
    'journals_in_period_for_account_js'         => 'Alle Buchungen für Account {title} zwischen {start} und {end}',
    'transferred'                               => 'Umgebucht',
    'all_withdrawal'                            => 'Alle Ausgaben',
    'all_transactions'                          => 'Alle Buchungen',
    'title_withdrawal_between'                  => 'Alle Ausgaben zwischen :start und :end',
    'all_deposit'                               => 'Alle Einnahmen',
    'title_deposit_between'                     => 'Alle Einnahmen zwischen :start und :end',
    'all_transfers'                             => 'Alle Umbuchungen',
    'title_transfers_between'                   => 'Alle Umbuchungen zwischen :start und :end',
    'all_transfer'                              => 'Alle Umbuchungen',
    'all_journals_for_tag'                      => 'Alle Buchungen für das Schlagwort „:tag”',
    'title_transfer_between'                    => 'Alle Umbuchungen zwischen :start und :end',
    'all_journals_for_category'                 => 'Alle Buchungen für Kategorie „:name”',
    'all_journals_for_budget'                   => 'Alle Buchungen im Budget „:name”',
    'chart_all_journals_for_budget'             => 'Diagramm für alle Buchungen im Budget „:name”',
    'journals_in_period_for_category'           => 'Alle Buchungen für Kategorie „:name” zwischen :start und :end',
    'journals_in_period_for_tag'                => 'Alle Buchungen für das Schlagwort „:tag” zwischen :start und :end',
    'not_available_demo_user'                   => 'Die Funktionen, auf welche sie zugreifen wollen, steht Demo-Benutzern nicht zur Verfügung.',
    'exchange_rate_instructions'                => 'Das Bestandskonto „@name“ akzeptiert nur Buchungen in @primary_currency. Wenn Sie stattdessen @foreign_currency verwenden möchten, stellen Sie sicher, dass auch der Betrag in @primary_currency angegeben ist:',
    'transfer_exchange_rate_instructions'       => 'Das Quellkonto „@source_name” akzeptiert nur Buchungen in @source_currency. Das Zielkonto "@dest_name" akzeptiert nur Buchungen in @dest_currency. Sie müssen den Betrag in beiden Währungen korrekt angeben.',
    'transaction_data'                          => 'Transaktionsdaten',
    'invalid_server_configuration'              => 'Ungültige Serverkonfiguration',
    'invalid_locale_settings'                   => 'Firefly III ist nicht in der Lage, Geldbeträge zu formatieren, weil Ihrem Server die erforderlichen Pakete fehlen. Es gibt <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">Anleitungen, wie Sie dies tun können</a>.',
    'quickswitch'                               => 'Schnellauswahl',
    'sign_in_to_start'                          => 'Melden Sie sich an, um Ihre Sitzung zu starten',
    'sign_in'                                   => 'Anmelden',
    'register_new_account'                      => 'Neues Benutzerkonto anlegen',
    'forgot_my_password'                        => 'Passwort vergessen',
    'problems_with_input'                       => 'Es gab Probleme mit Ihrer Eingabe.',
    'reset_password'                            => 'Ihr Passwort zurücksetzen',
    'button_reset_password'                     => 'Passwort zurücksetzen',
    'reset_button'                              => 'Zurücksetzen',
    'want_to_login'                             => 'Ich möchte mich anmelden',
    'login_page_title'                          => 'Bei Firefly III anmelden',
    'register_page_title'                       => 'Bei Firefly III registrieren',
    'forgot_pw_page_title'                      => 'Haben Sie Ihr Passwort für Firefly III vergessen?',
    'reset_pw_page_title'                       => 'Passwort für Firefly III zurücksetzen',
    'cannot_reset_demo_user'                    => 'Sie können das Passwort des Demo-Benutzers nicht zurücksetzen.',
    'no_att_demo_user'                          => 'Anwender der Demo-Version können keine Anhänge hochladen.',
    'button_register'                           => 'Registrieren',
    'authorization'                             => 'Autorisierung',
    'active_bills_only'                         => 'nur aktive Abonnements',
    'active_bills_only_total'                   => 'alle aktiven Abonnements',
    'active_exp_bills_only'                     => 'nur aktive und zu erwartende Abonnements',
    'active_exp_bills_only_total'               => 'nur aktive zu erwartende Abonnements',
    'per_period_sum_1D'                         => 'Erwartete tägliche Kosten',
    'per_period_sum_1W'                         => 'Erwartete wöchentliche Kosten',
    'per_period_sum_1M'                         => 'Erwartete monatliche Kosten',
    'per_period_sum_3M'                         => 'Erwartete vierteljährliche Kosten',
    'per_period_sum_6M'                         => 'Erwartete halbjährliche Kosten',
    'per_period_sum_1Y'                         => 'Erwartete jährliche Kosten',
    'average_per_bill'                          => 'durchschnittlich pro Abonnement',
    'expected_total'                            => 'Voraussichtliche Summe',
    'reconciliation_account_name'               => ':name Kontenabgleich (:currency)',
    'saved'                                     => 'Gespeichert',
    'advanced_options'                          => 'Erweiterte Optionen',
    'advanced_options_explain'                  => 'Auf einigen Seiten in Firefly III sind hinter dieser Schaltfläche erweiterte Optionen zu finden. Diese Seite enthält hier nichts Außergewöhnliches, aber schauen Sie sich die anderen an!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III hat festgestellt, dass Sie Buchungen aus der Zeit vor 1970 haben. Bitte korrigieren Sie diese Buchungen so schnell wie möglich.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'deaktiviert',
    'no_webhook_messages'                       => 'Es gibt keine Webhook Nachrichten',
    'webhook_trigger_ANY'         => 'Nach jedem Ereignis',
    'webhook_trigger_STORE_TRANSACTION'         => 'Nach Erstellen einer Buchung',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Nach Aktualisierung einer Buchung',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Nach dem Löschen einer Buchung',
    'webhook_trigger_STORE_BUDGET'              => 'Nach der Erstellung des Budgets',
    'webhook_trigger_UPDATE_BUDGET'             => 'Nach der Aktualisierung des Budgets',
    'webhook_trigger_DESTROY_BUDGET'            => 'Nach dem Löschen des Budgets',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'Nach dem Ändern des budgetierten Betrags',
    'webhook_response_TRANSACTIONS'             => 'Buchungsdetails',
    'webhook_response_ACCOUNTS'                 => 'Kontodetails',
    'webhook_response_BUDGET'                   => 'Budgetdetails',
    'webhook_response_RELEVANT'                 => 'Relevante Details',
    'webhook_response_NONE'                     => 'Keine Details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Überprüfen',
    'create_new_webhook'                        => 'Neuen Webhook erstellen',
    'webhooks_create_breadcrumb'                => 'Neuen Webhook erstellen',
    'webhook_trigger_form_help'                 => 'Geben Sie an, bei welchem Ereignis der Webhook ausgelöst werden soll',
    'webhook_response_form_help'                => 'Geben Sie an, was der Webhook an die URL senden soll.',
    'webhook_delivery_form_help'                => 'In welchem Format der Webhook Daten liefern muss.',
    'webhook_active_form_help'                  => 'Der Webhook muss aktiv sein oder wird nicht aufgerufen.',
    'stored_new_webhook'                        => 'Neuer Webhook ":title " gespeichert',
    'delete_webhook'                            => 'Webhook löschen',
    'deleted_webhook'                           => 'Webhook ":title" gelöscht',
    'edit_webhook'                              => 'Webhook ":title " bearbeiten',
    'updated_webhook'                           => 'Webhook ":title " aktualisiert',
    'edit_webhook_js'                           => 'Webhook "{title} " bearbeiten',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'Der Webhook wurde für die angezeigte Transaktion ausgelöst. Bitte warten Sie, bis die Ergebnisse erscheinen.',
    'webhook_messages'                          => 'Webhook-Nachricht',
    'view_message'                              => 'Nachricht anzeigen',
    'view_attempts'                             => 'Gescheiterte Versuche anzeigen',
    'message_content_title'                     => 'Webhook Nachrichteninhalt',
    'message_content_help'                      => 'Dies ist der Inhalt der Nachricht, die mit diesem Webhook gesendet (oder zu Senden versucht) wurde.',
    'attempt_content_title'                     => 'Webhook Versuche',
    'attempt_content_help'                      => 'Dies sind alle erfolglosen Versuche dieser Webhook-Nachricht, an die konfigurierte URL zu senden. Nach einiger Zeit wird es Firefly III nicht mehr versuchen.',
    'no_attempts'                               => 'Es gibt keine erfolglosen Versuche. Das ist eine gute Sache!',
    'webhook_attempt_at'                        => 'Versuch bei {moment}',
    'logs'                                      => 'Protokolle',
    'response'                                  => 'Antwort',
    'visit_webhook_url'                         => 'Webhook-URL besuchen',
    'reset_webhook_secret'                      => 'Webhook Secret zurücksetzen',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> wurde gespeichert.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") wurde aktualisiert.',

    // API access
    'authorization_request'                     => 'Firefly III v:version Autorisierungsanfrage',
    'authorization_request_intro'               => 'Anwendung "<strong>:client</strong>" bittet um Erlaubnis, auf Ihre Finanzverwaltung zuzugreifen. Möchten Sie <strong>:client</strong> erlauben, auf diese Datensätze zuzugreifen?',
    'authorization_request_site'                => 'Sie werden zu <code>:url</code> weitergeleitet, welche dann auf Ihre Daten in Firefly III zugreifen kann.',
    'authorization_request_invalid'             => 'Diese Zugriffsanfrage ist ungültig. Bitte folgen Sie nie wieder diesem Link.',
    'scopes_will_be_able'                       => 'Diese Anwendung kann:',
    'button_authorize'                          => 'Erlauben',
    'none_in_select_list'                       => '(Keine)',
    'no_piggy_bank'                             => '(kein Sparschwein)',
    'name_in_currency'                          => ':name in :currency',
    'paid_in_currency'                          => 'Bezahlt in :currency',
    'unpaid_in_currency'                        => 'Unbezahlt in :currency',
    'is_alpha_warning'                          => 'Sie nutzen eine ALPHA-Version. Seien Sie vorsichtig bei Fehlern und Problemen.',
    'is_beta_warning'                           => 'Sie verwenden eine BETA-Version. Seien Sie vorsichtig bei Fehlern und Problemen.',
    'all_destination_accounts'                  => 'Zielkonten',
    'all_source_accounts'                       => 'Quellkonten',
    'back_to_index'                             => 'Zurück zum Index',
    'cant_logout_guard'                         => 'Firefly III kann Sie nicht abmelden.',
    'internal_reference'                        => 'Interne Referenz',

    // check for updates:
    'update_check_title'                        => 'Nach Updates suchen',
    'admin_update_check_title'                  => 'Automatisch nach Updates suchen',
    'admin_update_check_explain'                => 'Firefly III kann automatisch nach Aktualisierungen suchen. Wenn Sie diese Einstellung aktivieren, wird der Firefly III Aktualisierungsserver kontaktiert, um zu prüfen, ob eine neue Version von Firefly III verfügbar ist. Wenn dies der Fall ist, erhalten Sie eine Benachrichtigung. Sie können diese Benachrichtigung mit der Schaltfläche auf der rechten Seite testen. Bitte geben Sie unten an, ob Firefly III nach Aktualisierungen suchen soll.',
    'check_for_updates_permission'              => 'Firefly III kann nach Aktualisierungen suchen, benötigt dafür aber Ihre Zustimmung. Bitte öffnen Sie die <a href=„:link“>Einstellungen</a>, um anzugeben, ob Sie diese Funktion aktivieren möchten.',
    'updates_ask_me_later'                      => 'Später fragen',
    'updates_do_not_check'                      => 'Nicht nach Updates suchen',
    'updates_enable_check'                      => 'Nach Updates suchen',
    'admin_update_check_now_title'              => 'Auf Update überprüfen',
    'admin_update_check_now_explain'            => 'Wenn Sie den Knopf drücken, wird Firefly III überprüfen, ob Ihre Version die aktuellste ist.',
    'check_for_updates_button'                  => 'Jetzt prüfen!',
    'update_new_version_alert'                  => 'Eine neue Version von Firefly III ist verfügbar. Sie verwenden :your_version, die neueste Version ist :new_version, die am :date veröffentlicht wurde.',
    'update_version_beta'                       => 'Seien Sie vorsichtig bei der Verwendung dieser BETA-Version. Sie könnte noch Fehler enthaltern.',
    'update_version_alpha'                      => 'Seien Sie vorsichtig bei der Verwendung dieser APLPHA-Version. Sie kann Fehler enthaltern.',
    'update_current_dev_older'                  => 'Sie verwenden die Entwicklungsversion „:version”, die älter ist als die neueste Version :new_version. Bitte aktualisieren Sie!',
    'update_current_dev_newer'                  => 'Sie verwenden die Entwicklungsversion „:version”, die neuer ist als die letzte Version :new_version.',
    'update_current_version_alert'              => 'Sie verwenden Version :version. Dies ist die neueste verfügbare Version.',
    'update_newer_version_alert'                => 'Sie verwenden :your_version. Ihre Version ist neuer als die neueste Version (:new_version).',
    'update_check_error'                        => 'Bei der Suche nach Aktualisierungen ist ein Fehler aufgetreten: :error',
    'unknown_error'                             => 'Leider ist ein unbekannter Fehler aufgetreten.',
    'disabled_but_check'                        => 'Die Aktualisierungsprüfung ist deaktiviert. Vergessen Sie also nicht, von Zeit zu Zeit selbst nach Aktualisierungen zu suchen. Vielen Dank!',
    'admin_update_channel_title'                => 'Aktualisierungskanal',
    'admin_update_channel_explain'              => 'Firefly III verfügt über drei Aktualisierungskanäle, welche bestimmen, wie weit Sie in Bezug auf Funktionen, Verbesserungen und Fehler experimentierfreudig sind. Nutzen Sie den „Beta”-Kanal, wenn Sie abenteuerlustig sind, und den „Alpha”-Kanal, wenn Sie ein gefährliches Leben führen möchten.',
    'update_channel_stable'                     => 'Stabil — Alles sollte wie erwartet funktionieren.',
    'update_channel_beta'                       => 'Beta — Neue Funktionen, aber einige Funktionen könnten fehlerhaft sein.',
    'update_channel_alpha'                      => 'Alpha — Wir werfen neue Features hinein und schauen, was funktioniert.',

    // search
    'search'                                    => 'Suche',
    'search_query'                              => 'Abfrage',
    'search_found_transactions'                 => 'Firefly III hat :count Transaktion in :time Sekunden gefunden.|Firefly III hat :count Transaktionen in :time Sekunden gefunden.',
    'search_found_more_transactions'            => 'Firefly III hat mehr als :count Transaktionen in :time Sekunden gefunden.',
    'search_for_overview'                       => 'Firefly III sucht nach Umsätzen, die <b>alle</b> der folgenden Bedingungen erfüllen:',
    'search_for_query'                          => 'Alle diese Begriffe müssen vorhanden sein: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Keines dieser Begriffe darf vorhanden sein: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Diese Suchparameter sind ungültig und wurden ignoriert.',

    // old


    'search_modifier_date_on'                             => 'Buchungsdatum ist „:value”',
    'search_modifier_not_date_on'                         => 'Buchungsdatum ist nicht ":value"',
    'search_modifier_reconciled'                          => 'Buchung wurde abgeglichen',
    'search_modifier_not_reconciled'                      => 'Transaktion wurde nicht abgeglichen',
    'search_modifier_id'                                  => 'Buchungsnummer ist ":value"',
    'search_modifier_not_id'                              => 'Buchungs-ID ist nicht ":value"',
    'search_modifier_date_before'                         => 'Buchungsdatum ist vor oder am ":value"',
    'search_modifier_date_after'                          => 'Buchungsdatum ist nach oder am „:value”',
    'search_modifier_external_id_is'                      => 'Externe ID lautet „:value”',
    'search_modifier_not_external_id_is'                  => 'External ID ist nicht ":value"',
    'search_modifier_no_external_url'                     => 'Die Buchung besitzt keine externe URL',
    'search_modifier_no_external_id'                      => 'Die Buchung hat keine externe ID',
    'search_modifier_not_any_external_url'                => 'Die Buchung besitzt keine externe URL',
    'search_modifier_not_any_external_id'                 => 'Die Buchung hat keine externe ID',
    'search_modifier_any_external_url'                    => 'Die Buchung muss eine (beliebige) externe URL aufweisen',
    'search_modifier_any_external_id'                     => 'Die Buchung muss eine (beliebige) externe ID haben',
    'search_modifier_not_no_external_url'                 => 'Die Buchung muss eine (beliebige) externe URL haben',
    'search_modifier_not_no_external_id'                  => 'Die Buchung muss eine (beliebige) externe ID haben',
    'search_modifier_internal_reference_is'               => 'Interne Referenz lautet „:value”',
    'search_modifier_not_internal_reference_is'           => 'Interne Referenz ist nicht ":value"',
    'search_modifier_description_starts'                  => 'Beschreibung beginnt mit „:value”',
    'search_modifier_not_description_starts'              => 'Beschreibung beginnt nicht mit „:value”',
    'search_modifier_description_ends'                    => 'Beschreibung endet auf „:value”',
    'search_modifier_not_description_ends'                => 'Beschreibung endet nicht auf „:value”',
    'search_modifier_description_contains'                => 'Beschreibung enthält „:value”',
    'search_modifier_not_description_contains'            => 'Beschreibung enthält nicht „:value”',
    'search_modifier_description_is'                      => 'Beschreibung ist „:value”',
    'search_modifier_not_description_is'                  => 'Beschreibung ist nicht ":value"',
    'search_modifier_currency_is'                         => 'Buchungswährung ist „:value”',
    'search_modifier_not_currency_is'                     => 'Buchungswährung ist nicht „:value”',
    'search_modifier_foreign_currency_is'                 => 'Buchungsfremdwährung ist „:value”',
    'search_modifier_not_foreign_currency_is'             => 'Buchungsfremdwährung ist nicht „:value”',
    'search_modifier_has_attachments'                     => 'Die Buchung muss einen Anhang haben',
    'search_modifier_has_no_category'                     => 'Die Buchung darf keiner Kategorie zugeordnet sein',
    'search_modifier_not_has_no_category'                 => 'Der Buchung muss einer (beliebigen) Kategorie zugeordnet sein',
    'search_modifier_not_has_any_category'                => 'Der Buchung darf keiner Kategorie zugeordnet sein',
    'search_modifier_has_any_category'                    => 'Die Buchung muss einer Kategorie zugeordnet werden',
    'search_modifier_has_no_budget'                       => 'Der Buchung darf kein Budget zugeordnet werden',
    'search_modifier_not_has_any_budget'                  => 'Die Transaktion darf kein Budget haben',
    'search_modifier_has_any_budget'                      => 'Die Buchung muss einem Budget zugeordnet werden',
    'search_modifier_not_has_no_budget'                   => 'Die Buchung muss einem (beliebigen) Budget zugeordnet sein',
    'search_modifier_has_no_bill'                         => 'Der Buchung darf kein Abonnement zugeordnet sein',
    'search_modifier_not_has_no_bill'                     => 'Der Buchung muss ein (beliebiges) Abonnement zugeordnet sein',
    'search_modifier_has_any_bill'                        => 'Der Buchung muss ein (beliebiges) Abonnement zugeordnet sein',
    'search_modifier_not_has_any_bill'                    => 'Der Buchung darf kein Abonnement zugeordnet sein',
    'search_modifier_has_no_tag'                          => 'Der Buchung darf keine Schlagworte zugeordnet werden',
    'search_modifier_not_has_any_tag'                     => 'Der Buchung dürfen keine Schlagwörter zugeordnet sein',
    'search_modifier_not_has_no_tag'                      => 'Der Buchung muss ein (beliebiges) Schlagwort zugeordnet sein',
    'search_modifier_has_any_tag'                         => 'Die Buchung muss ein Schlagwort zugeordnet werden',
    'search_modifier_notes_contains'                      => 'Die Buchungsnotiz enthält „:value”',
    'search_modifier_not_notes_contains'                  => 'Die Buchungsnotiz enthält nicht „:value”',
    'search_modifier_notes_starts'                        => 'Die Buchungsnotiz beginnt mit „:value”',
    'search_modifier_not_notes_starts'                    => 'Die Buchungsnotiz beginnt nicht mit „:value”',
    'search_modifier_notes_ends'                          => 'Die Buchungsnotiz endet auf „:value”',
    'search_modifier_not_notes_ends'                      => 'Die Buchungsnotiz endet nicht auf „:value”',
    'search_modifier_notes_is'                            => 'Die Buchungsnotiz ist „:value”',
    'search_modifier_not_notes_is'                        => 'Die Buchungsnotiz ist nicht „:value”',
    'search_modifier_no_notes'                            => 'Die Buchung hat keine Notiz',
    'search_modifier_not_no_notes'                        => 'Die Buchung muss eine Notiz haben',
    'search_modifier_any_notes'                           => 'Die Buchung muss eine Notiz haben',
    'search_modifier_not_any_notes'                       => 'Die Buchung hat keine Notizen',
    'search_modifier_amount_is'                           => 'Betrag beträgt genau :value',
    'search_modifier_not_amount_is'                       => 'Betrag ist nicht :value',
    'search_modifier_amount_less'                         => 'Betrag ist geringer oder gleich :value',
    'search_modifier_not_amount_more'                     => 'Betrag ist geringer oder gleich :value',
    'search_modifier_amount_more'                         => 'Betrag ist größer oder gleich :value',
    'search_modifier_not_amount_less'                     => 'Betrag ist höher oder gleich :value',
    'search_modifier_source_account_is'                   => 'Quellkonto-Name ist ":value"',
    'search_modifier_not_source_account_is'               => 'Quellkonto-Name ist nicht „:value”',
    'search_modifier_source_account_contains'             => 'Quellkonto-Name enthält „:value”',
    'search_modifier_not_source_account_contains'         => 'Quellkonto-Name enthält nicht „:value”',
    'search_modifier_source_account_starts'               => 'Quellkonto-Name beginnt mit „:value”',
    'search_modifier_not_source_account_starts'           => 'Quellkonto-Name beginnt nicht mit „:value”',
    'search_modifier_source_account_ends'                 => 'Quellkonto-Name endet mit „:value”',
    'search_modifier_not_source_account_ends'             => 'Quellkonto-Name endet nicht mit „:value”',
    'search_modifier_source_account_id'                   => 'Quellkonto-ID ist :value',
    'search_modifier_not_source_account_id'               => 'Quellkonto-ID ist nicht :value',
    'search_modifier_source_account_nr_is'                => 'Quellkontonummer (IBAN) ist „:value”',
    'search_modifier_not_source_account_nr_is'            => 'Quellkontonummer (IBAN) ist nicht „:value”',
    'search_modifier_source_account_nr_contains'          => 'Quellkontonummer (IBAN) enthält „:value”',
    'search_modifier_not_source_account_nr_contains'      => 'Quellkontonummer (IBAN) enthält nicht „:value”',
    'search_modifier_source_account_nr_starts'            => 'Quellkontonummer (IBAN) beginnt mit „:value”',
    'search_modifier_not_source_account_nr_starts'        => 'Quellkontonummer (IBAN) beginnt nicht mit „:value”',
    'search_modifier_source_account_nr_ends'              => 'Quellkontonummer (IBAN) endet auf „:value”',
    'search_modifier_not_source_account_nr_ends'          => 'Quellkontonummer (IBAN) endet nicht auf „:value”',
    'search_modifier_destination_account_is'              => 'Zielkonto-Name ist „:value”',
    'search_modifier_not_destination_account_is'          => 'Zielkonto-Name ist nicht „:value”',
    'search_modifier_destination_account_contains'        => 'Zielkonto-Name enthält „:value”',
    'search_modifier_not_destination_account_contains'    => 'Zielkonto-Name enthält nicht „:value”',
    'search_modifier_destination_account_starts'          => 'Zielkonto-Name beginnt mit „:value”',
    'search_modifier_not_destination_account_starts'      => 'Zielkonto-Name beginnt nicht mit „:value”',
    'search_modifier_destination_account_ends'            => 'Zielkonto-Name endet mit „:value”',
    'search_modifier_not_destination_account_ends'        => 'Zielkonto-Name endet nicht mit „:value”',
    'search_modifier_destination_account_id'              => 'Zielkonto-ID ist :value',
    'search_modifier_not_destination_account_id'          => 'Zielkonto-ID ist nicht :value',
    'search_modifier_destination_is_cash'                 => 'Zielkonto ist das "(Bargeld)"-Konto',
    'search_modifier_not_destination_is_cash'             => 'Zielkonto ist nicht das "(Bargeld)"-Konto',
    'search_modifier_source_is_cash'                      => 'Quellkonto ist das "(Bargeld)"-Konto',
    'search_modifier_not_source_is_cash'                  => 'Quellkonto ist nicht das "(Bargeld)"-Konto',
    'search_modifier_destination_account_nr_is'           => 'Zielkontonummer (IBAN) ist „:value”',
    'search_modifier_not_destination_account_nr_is'       => 'Zielkontonummer (IBAN) ist „:value”',
    'search_modifier_destination_account_nr_contains'     => 'Zielkontonummer (IBAN) enthält „:value”',
    'search_modifier_not_destination_account_nr_contains' => 'Zielkontonummer (IBAN) enthält nicht „:value”',
    'search_modifier_destination_account_nr_starts'       => 'Zielkontonummer (IBAN) beginnt mit „:value”',
    'search_modifier_not_destination_account_nr_starts'   => 'Zielkontonummer (IBAN) beginnt nicht mit „:value”',
    'search_modifier_destination_account_nr_ends'         => 'Zielkontonummer (IBAN) endet mit „:value”',
    'search_modifier_not_destination_account_nr_ends'     => 'Zielkontonummer (IBAN) endet nicht auf „:value”',
    'search_modifier_account_id'                          => 'Quell- oder Zielkonto ID ist/sind :value',
    'search_modifier_not_account_id'                      => 'Quell- oder Zielkonten-ID ist/sind nicht „:value”',
    'search_modifier_category_is'                         => 'Kategorie ist „:value”',
    'search_modifier_not_category_is'                     => 'Kategorie ist nicht „:value”',
    'search_modifier_budget_is'                           => 'Budget ist „:value”',
    'search_modifier_not_budget_is'                       => 'Budget ist nicht „:value”',
    'search_modifier_bill_is'                             => 'Abonnement ist „:value“',
    'search_modifier_not_bill_is'                         => 'Abonnement ist nicht „:value“',
    'search_modifier_transaction_type'                    => 'Buchungstyp ist „:value”',
    'search_modifier_not_transaction_type'                => 'Buchungstyp ist nicht „:value”',
    'search_modifier_tag_is'                              => 'Schlagwort ist „:value”',
    'search_modifier_tag_contains'                        => 'Schlagwort enthält ":value"',
    'search_modifier_not_tag_contains'                    => 'Schlagwort enthält nicht ":value"',
    'search_modifier_tag_ends'                            => 'Schlagwort endet mit ":value"',
    'search_modifier_tag_starts'                          => 'Schlagwort beginnt mit ":value"',
    'search_modifier_not_tag_is'                          => 'Kein Schlagwort lautet ":value"',
    'search_modifier_date_on_year'                        => 'Buchung im Jahr „:value”',
    'search_modifier_not_date_on_year'                    => 'Buchung ist nicht im Jahr ":value"',
    'search_modifier_date_on_month'                       => 'Buchung im Monat „:value”',
    'search_modifier_not_date_on_month'                   => 'Buchung ist nicht im Monat ":value"',
    'search_modifier_date_on_day'                         => 'Buchung erfolgt am :value Tag des Monats',
    'search_modifier_not_date_on_day'                     => 'Buchung erfolgte nicht am Tag des Monats ":value"',
    'search_modifier_date_before_year'                    => 'Buchung ist vor dem oder im Jahr ":value"',
    'search_modifier_date_before_month'                   => 'Buchung ist vor oder im Monat ":value"',
    'search_modifier_date_before_day'                     => 'Buchung vor oder am ":value" Tag des Monats',
    'search_modifier_date_after_year'                     => 'Buchung ist in oder nach dem Jahr ":value"',
    'search_modifier_date_after_month'                    => 'Buchung ist in oder nach dem Monat ":value"',
    'search_modifier_date_after_day'                      => 'Buchung ist nach oder am ":value" Tag des Monats',

    // new
    'search_modifier_tag_is_not'                          => 'Kein Schlagwort lautet ":value"',
    'search_modifier_not_tag_is_not'                      => 'Schlagwort ist ":value"',
    'search_modifier_account_is'                          => 'Beide Konten sind ":value"',
    'search_modifier_not_account_is'                      => 'Beide Konten sind nicht ":value"',
    'search_modifier_account_contains'                    => 'Beide Konten enthalten ":value"',
    'search_modifier_not_account_contains'                => 'Beide Konten enthalten nicht ":value"',
    'search_modifier_account_ends'                        => 'Beide Konten enden mit ":value"',
    'search_modifier_not_account_ends'                    => 'Beide Konten enden nicht mit ":value"',
    'search_modifier_account_starts'                      => 'Beide Konten beginnen mit ":value"',
    'search_modifier_not_account_starts'                  => 'Beide Konten beginnen nicht mit ":value"',
    'search_modifier_account_nr_is'                       => 'Beide Kontonummern / IBANs sind ":value"',
    'search_modifier_not_account_nr_is'                   => 'Beide Kontonummern / IBANs sind nicht ":value"',
    'search_modifier_account_nr_contains'                 => 'Eine der Kontonummern / IBAN enthaltet ":value"',
    'search_modifier_not_account_nr_contains'             => 'Beide Kontonummern / IBANs enthalten ":value"',
    'search_modifier_account_nr_ends'                     => 'Beide Kontonummern /IBANs enden mit ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Beide Kontonummern / IBANs enden nicht mit ":value"',
    'search_modifier_account_nr_starts'                   => 'Beide Kontonummer / IBAN beginnen mit ":value"',
    'search_modifier_not_account_nr_starts'               => 'Beide Kontonummern / IBANs beginnen nicht mit ":value"',
    'search_modifier_category_contains'                   => 'Kategorie enthält ":value"',
    'search_modifier_not_category_contains'               => 'Kategorie enthält nicht „:value”',
    'search_modifier_category_ends'                       => 'Kategorie endet mit „:value”',
    'search_modifier_not_category_ends'                   => 'Kategorie endet nicht mit „:value”',
    'search_modifier_category_starts'                     => 'Kategorie beginnt mit ":value"',
    'search_modifier_not_category_starts'                 => 'Kategorie beginnt nicht mit „:value”',
    'search_modifier_budget_contains'                     => 'Budget enthält ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget enthält nicht „:value”',
    'search_modifier_budget_ends'                         => 'Budget endet mit ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget endet nicht mit „:value”',
    'search_modifier_budget_starts'                       => 'Budget beginnt mit ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget beginnt nicht mit „:value”',
    'search_modifier_bill_contains'                       => 'Abonnement enthält „:value”',
    'search_modifier_not_bill_contains'                   => 'Abonnement enthält nicht „:value“',
    'search_modifier_bill_ends'                           => 'Abonnement endet auf „:value”',
    'search_modifier_not_bill_ends'                       => 'Abonnement endet nicht auf „:value“',
    'search_modifier_bill_starts'                         => 'Abonnement beginnt mit „:value“',
    'search_modifier_not_bill_starts'                     => 'Abonnement beginnt nicht mit „:value“',
    'search_modifier_external_id_contains'                => 'Externe ID enthält ":value"',
    'search_modifier_not_external_id_contains'            => 'Externe ID enthält nicht ":value"',
    'search_modifier_external_id_ends'                    => 'Externe ID endet mit ":value"',
    'search_modifier_not_external_id_ends'                => 'Externe ID endet nicht mit ":value"',
    'search_modifier_external_id_starts'                  => 'Externe ID beginnt mit ":value"',
    'search_modifier_not_external_id_starts'              => 'Externe ID beginnt nicht mit ":value"',
    'search_modifier_internal_reference_contains'         => 'Interne Referenz enthält ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Interne Referenz enthält nicht „:value”',
    'search_modifier_internal_reference_ends'             => 'Interne Referenz endet mit ":value"',
    'search_modifier_internal_reference_starts'           => 'Interne Referenz beginnt mit ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Interne Referenz endet nicht mit „:value”',
    'search_modifier_not_internal_reference_starts'       => 'Interne Referenz beginnt nicht mit „:value”',
    'search_modifier_external_url_is'                     => 'Externe URL ist ":value"',
    'search_modifier_not_external_url_is'                 => 'Externe URL ist nicht ":value"',
    'search_modifier_external_url_contains'               => 'Externe URL enthält ":value"',
    'search_modifier_not_external_url_contains'           => 'Externe URL enthält nicht ":value"',
    'search_modifier_external_url_ends'                   => 'Externe URL endet mit ":value"',
    'search_modifier_not_external_url_ends'               => 'Externe URL endet nicht mit ":value"',
    'search_modifier_external_url_starts'                 => 'Externe URL beginnt mit ":value"',
    'search_modifier_not_external_url_starts'             => 'Externe URL beginnt nicht mit ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaktion hat keine Anhänge',
    'search_modifier_not_has_no_attachments'              => 'Buchung hat Anhänge',
    'search_modifier_not_has_attachments'                 => 'Buchung hat keine Anhänge',
    'search_modifier_account_is_cash'                     => 'Eines der Konten ist das (Bar-)Konto.',
    'search_modifier_not_account_is_cash'                 => 'Beide Konten sind keine Bargeldkonten.',
    'search_modifier_journal_id'                          => 'Transaktions-Journal-ID ist ":value"',
    'search_modifier_not_journal_id'                      => 'Die Journal-ID ist nicht ":value"',
    'search_modifier_recurrence_id'                       => 'Die Dauerauftrags-ID ist ":value"',
    'search_modifier_not_recurrence_id'                   => 'Die Dauerauftrags-ID ist nicht ":value"',
    'search_modifier_foreign_amount_is'                   => 'Buchungsbetrag (Fremdwährung) lautet ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Buchungsbetrag (Fremdwährung) ist nicht ":value"',
    'search_modifier_foreign_amount_less'                 => 'Der Fremdbetrag ist geringer als ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Buchungsbetrag (Fremdwährung) ist geringer als ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Buchungsbetrag (Fremdwährung) ist höher als ":value"',
    'search_modifier_foreign_amount_more'                 => 'Buchungsbetrag (Fremdwährung) ist höher als ":value"',
    'search_modifier_exists'                              => 'Buchung vorhanden (beliebige Buchung)',
    'search_modifier_not_exists'                          => 'Buchung existiert nicht (keine Buchung)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaktion Zinstermin ist am ":value"',
    'search_modifier_not_interest_date_on'                => 'Bungungs-Zinstermin ist nicht am ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaktion Zinstermin ist im Jahr ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Buchungs-Zinstermin ist nicht im Jahr ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaktion Zinstermin ist im Monat ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Buchungs-Zinstermin ist nicht im Monat ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaktion Zinstermin ist am Tag des Monats ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Buchungs-Zinstermin ist nicht am Tag des Monats ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaktion Zinstermin ist vor dem oder im Jahr ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaktion Zinstermin ist vor dem oder im Monat ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaktion Zinstermin ist vor dem oder am Tag des Monats ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaktion Zinstermin ist nach dem oder im Jahr ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaktion Zinstermin ist nach dem oder im Monat ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaktion Zinstermin ist nach dem oder am Tag des Monats ":value"',
    'search_modifier_book_date_on_year'                   => 'Buchungsdatum ist im Jahr ":value"',
    'search_modifier_book_date_on_month'                  => 'Buchungsdatum ist im Monat ":value"',
    'search_modifier_book_date_on_day'                    => 'Buchungsdatum ist am Tag des Monats ":value"',
    'search_modifier_not_book_date_on_year'               => 'Buchungsdatum ist nicht im Jahr ":value"',
    'search_modifier_not_book_date_on_month'              => 'Buchungsdatum ist nicht im Monat ":value"',
    'search_modifier_not_book_date_on_day'                => 'Buchungsdatum ist nicht am Tag des Monats ":value"',
    'search_modifier_book_date_before_year'               => 'Buchungsdatum ist vor oder im Jahr ":value"',
    'search_modifier_book_date_before_month'              => 'Buchungsdatum ist vor oder im Monat ":value"',
    'search_modifier_book_date_before_day'                => 'Buchungsdatum ist vor oder am Tag des Monats ":value"',
    'search_modifier_book_date_after_year'                => 'Buchungsdatum ist nach oder im Jahr ":value"',
    'search_modifier_book_date_after_month'               => 'Buchungsdatum ist nach oder im Monat ":value"',
    'search_modifier_book_date_after_day'                 => 'Buchungsdatum ist nach oder am Tag des Monats ":value"',
    'search_modifier_process_date_on_year'                => 'Wertstellungsdatum ist im Jahr ":value"',
    'search_modifier_process_date_on_month'               => 'Wertstellungsdatum ist im Monat ":value"',
    'search_modifier_process_date_on_day'                 => 'Wertstellungsdatum ist am Tag des Monats ":value"',
    'search_modifier_not_process_date_on_year'            => 'Wertstellungsdatum ist nicht im Jahr ":value"',
    'search_modifier_not_process_date_on_month'           => 'Wertstellungsdatum ist nicht im Monat ":value"',
    'search_modifier_not_process_date_on_day'             => 'Wertstellungsdatum ist nicht am Tag des Monats ":value"',
    'search_modifier_process_date_before_year'            => 'Wertstellungsdatum ist vor oder im Jahr ":value"',
    'search_modifier_process_date_before_month'           => 'Wertstellungsdatum ist vor oder im Monat ":value"',
    'search_modifier_process_date_before_day'             => 'Wertstellungsdatum ist vor oder am Tag des Monats ":value"',
    'search_modifier_process_date_after_year'             => 'Wertstellungsdatum ist nach oder im Jahr ":value"',
    'search_modifier_process_date_after_month'            => 'Wertstellungsdatum ist nach oder im Monat ":value"',
    'search_modifier_process_date_after_day'              => 'Wertstellungsdatum ist nach oder am Tag des Monats ":value"',
    'search_modifier_due_date_on_year'                    => 'Buchungs-Fälligkeitsdatum ist im Jahr ":value"',
    'search_modifier_due_date_on_month'                   => 'Buchungs-Fälligkeitsdatum ist im Monat ":value"',
    'search_modifier_due_date_on_day'                     => 'Buchungs-Fälligkeitsdatum ist am Tag des Monats ":value"',
    'search_modifier_not_due_date_on_year'                => 'Buchungs-Fälligkeitsdatum ist nicht im Jahr ":value"',
    'search_modifier_not_due_date_on_month'               => 'Buchungs-Fälligkeitsdatum ist nicht im Monat ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Buchungs-Fälligkeitsdatum ist nicht am Tag des Monats ":value"',
    'search_modifier_due_date_before_year'                => 'Buchungs-Fälligkeitsdatum ist vor dem oder im Jahr ":value"',
    'search_modifier_due_date_before_month'               => 'Buchungs-Fälligkeitsdatum ist vor dem oder im Monat ":value"',
    'search_modifier_due_date_before_day'                 => 'Buchungs-Fälligkeitsdatum ist vor dem oder am Tag des Monats ":value"',
    'search_modifier_due_date_after_year'                 => 'Buchungs-Fälligkeitsdatum ist nach dem oder im Jahr ":value"',
    'search_modifier_due_date_after_month'                => 'Buchungs-Fälligkeitsdatum ist nach dem oder im Monat ":value"',
    'search_modifier_due_date_after_day'                  => 'Buchungs-Fälligkeitsdatum ist nach dem oder am Tag des Monats ":value"',
    'search_modifier_payment_date_on_year'                => 'Buchungs-Wertstellung ist im Jahr ":value"',
    'search_modifier_payment_date_on_month'               => 'Buchungs-Wertstellung ist im Monat ":value"',
    'search_modifier_payment_date_on_day'                 => 'Buchungs-Wertstellung ist am Tag des Monats ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Buchungs-Wertstellung ist nicht im Jahr ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Buchungs-Wertstellung ist nicht im Monat ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Buchungs-Wertstellung ist nicht am Tag des Monats ":value"',
    'search_modifier_payment_date_before_year'            => 'Buchungs-Wertstellung ist vor dem oder im Jahr ":value"',
    'search_modifier_payment_date_before_month'           => 'Buchungs-Wertstellung ist vor dem oder im Monat ":value"',
    'search_modifier_payment_date_before_day'             => 'Buchungs-Wertstellung ist vor dem oder am Tag des Monats ":value"',
    'search_modifier_payment_date_after_year'             => 'Buchungs-Wertstellung ist nach dem oder im Jahr ":value"',
    'search_modifier_payment_date_after_month'            => 'Buchungs-Wertstellung ist nach dem oder im Monat ":value"',
    'search_modifier_payment_date_after_day'              => 'Buchungs-Wertstellung ist nach dem oder am Tag des Monats ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaktion Rechnungsdatum ist im Jahr ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaktion Rechnungsdatum ist im Monat ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaktion Rechnungsdatum ist am Tag des Monats ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Rechnungsdatum der Buchung ist nicht im Jahr ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Rechnungsdatum der Buchung ist nicht im Monat ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Rechnungsdatum der Buchung ist nicht am Tag des Monats ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaktion Rechnungsdatum ist vor dem oder im Jahr ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaktion Rechnungsdatum ist vor dem oder im Monat ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaktion Rechnungsdatum ist vor dem oder am Tag des Monats ":value"',
    'search_modifier_invoice_date_after_year'             => 'Transaktion Rechnungsdatum ist nach dem oder im Jahr ":value"',
    'search_modifier_invoice_date_after_month'            => 'Transaktion Rechnungsdatum ist nach dem oder im Monat ":value"',
    'search_modifier_invoice_date_after_day'              => 'Transaktion Rechnungsdatum ist nach dem oder am Tag des Monats ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaktion wurde zuletzt im Jahr ":value" aktualisiert',
    'search_modifier_updated_at_on_month'                 => 'Transaktion wurde zuletzt im Monat ":value" aktualisiert',
    'search_modifier_updated_at_on_day'                   => 'Transaktion wurde zuletzt am Tag des Monats ":value" aktualisiert',
    'search_modifier_not_updated_at_on_year'              => 'Buchung wurde nicht zuletzt im Jahr ":value" aktualisiert',
    'search_modifier_not_updated_at_on_month'             => 'Buchung wurde nicht zuletzt im Monat ":value" aktualisiert',
    'search_modifier_not_updated_at_on_day'               => 'Buchung wurde nicht zuletzt am Tag des Monats ":value" aktualisiert',
    'search_modifier_updated_at_before_year'              => 'Transaktion wurde zuletzt im oder vor dem Jahr ":value" aktualisiert',
    'search_modifier_updated_at_before_month'             => 'Transaktion wurde zuletzt im oder vor dem Monat ":value" aktualisiert',
    'search_modifier_updated_at_before_day'               => 'Transaktion wurde zuletzt am oder vor dem Tag des Monats ":value" aktualisiert',
    'search_modifier_updated_at_after_year'               => 'Transaktion wurde zuletzt im oder nach dem Jahr ":value" aktualisiert',
    'search_modifier_updated_at_after_month'              => 'Transaktion wurde zuletzt im oder nach dem Monat ":value" aktualisiert',
    'search_modifier_updated_at_after_day'                => 'Transaktion wurde zuletzt am oder nach dem Tag des Monats ":value" aktualisiert',
    'search_modifier_created_at_on_year'                  => 'Transaktion wurde im Jahr ":value" erstellt',
    'search_modifier_created_at_on_month'                 => 'Transaktion wurde im Monat ":value" erstellt',
    'search_modifier_created_at_on_day'                   => 'Transaktion wurde am Tag des Monats ":value" erstellt',
    'search_modifier_not_created_at_on_year'              => 'Transaktion wurde nicht im Jahr ":value" erstellt',
    'search_modifier_not_created_at_on_month'             => 'Transaktion wurde nicht im Monat ":value" erstellt',
    'search_modifier_not_created_at_on_day'               => 'Transaktion wurde nicht am Tag des Monats ":value" erstellt',
    'search_modifier_created_at_before_year'              => 'Transaktion wurde im oder vor dem Jahr ":value" erstellt',
    'search_modifier_created_at_before_month'             => 'Transaktion wurde im oder vor dem Monat ":value" erstellt',
    'search_modifier_created_at_before_day'               => 'Transaktion wurde am oder vor dem Tag des Monats ":value" erstellt',
    'search_modifier_created_at_after_year'               => 'Transaktion wurde im oder nach dem Jahr ":value" erstellt',
    'search_modifier_created_at_after_month'              => 'Transaktion wurde im oder nach dem Monat ":value" erstellt',
    'search_modifier_created_at_after_day'                => 'Transaktion wurde am oder nach dem Tag des Monats ":value" erstellt',
    'search_modifier_interest_date_before'                => 'Transaktion Zinstermin ist am oder vor dem ":value"',
    'search_modifier_interest_date_after'                 => 'Transaktion Zinstermin ist am oder nach dem ":value"',
    'search_modifier_book_date_on'                        => 'Buchungsdatum ist am ":value"',
    'search_modifier_not_book_date_on'                    => 'Buchungsdatum ist nicht am ":value"',
    'search_modifier_book_date_before'                    => 'Buchungsdatum ist am oder vor dem ":value"',
    'search_modifier_book_date_after'                     => 'Buchungsdatum ist am oder nach dem ":value"',
    'search_modifier_process_date_on'                     => 'Wertstellungsdatum ist am ":value"',
    'search_modifier_not_process_date_on'                 => 'Wertstellungsdatum ist nicht am ":value"',
    'search_modifier_process_date_before'                 => 'Wertstellungsdatum ist am oder vor dem ":value"',
    'search_modifier_process_date_after'                  => 'Wertstellungsdatum ist am oder nach dem ":value"',
    'search_modifier_due_date_on'                         => 'Buchungs-Fälligkeitsdatum ist am ":value"',
    'search_modifier_not_due_date_on'                     => 'Buchungs-Fälligkeitsdatum ist nicht am ":value"',
    'search_modifier_due_date_before'                     => 'Buchungs-Fälligkeitsdatum ist am oder vor dem ":value"',
    'search_modifier_due_date_after'                      => 'Buchungs-Fälligkeitsdatum ist am oder nach dem ":value"',
    'search_modifier_payment_date_on'                     => 'Buchungs-Wertstellung ist am ":value"',
    'search_modifier_not_payment_date_on'                 => 'Buchungs-Wertstellung ist nicht am ":value"',
    'search_modifier_payment_date_before'                 => 'Buchungs-Wertstellung ist am oder vor dem ":value"',
    'search_modifier_payment_date_after'                  => 'Buchungs-Wertstellung ist am oder nach dem ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaktion Rechnungsdatum ist am ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaktion Rechnungsdatum ist nicht am ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaktion Rechnungsdatum ist am oder vor dem ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaktion Rechnungsdatum ist am oder nach dem ":value"',
    'search_modifier_created_at_on'                       => 'Transaktion wurde am ":value" erstellt',
    'search_modifier_not_created_at_on'                   => 'Transaktion wurde nicht am ":value" erstellt',
    'search_modifier_created_at_before'                   => 'Transaktion wurde am oder vor dem ":value" erstellt',
    'search_modifier_created_at_after'                    => 'Transaktion wurde am oder nach dem ":value" erstellt',
    'search_modifier_updated_at_on'                       => 'Transaktion wurde aktualisiert am ":value"',
    'search_modifier_not_updated_at_on'                   => 'Buchung wurde nicht aktualisiert am ":value"',
    'search_modifier_updated_at_before'                   => 'Transaktion wurde aktualisiert am oder vor dem ":value"',
    'search_modifier_updated_at_after'                    => 'Transaktion wurde aktualisiert am oder nach dem ":value"',

    'search_modifier_attachment_name_is'            => 'Der Name eines Anhangs lautet ":value"',
    'search_modifier_attachment_name_contains'      => 'Der Name eines Anhangs enthält ":value"',
    'search_modifier_attachment_name_starts'        => 'Der Name eines Anhangs beginnt mit ":value"',
    'search_modifier_attachment_name_ends'          => 'Der Name eines Anhangs endet mit ":value"',
    'search_modifier_attachment_notes_are'          => 'Notizen des Anhangs lauten ":value"',
    'search_modifier_attachment_notes_contains'     => 'Notizen des Anhangs beinhalten ":value"',
    'search_modifier_attachment_notes_starts'       => 'Notizen des Anhangs beginnen mit ":value"',
    'search_modifier_attachment_notes_ends'         => 'Notizen des Anhangs enden mit ":value"',
    'search_modifier_not_attachment_name_is'        => 'Der Name eines Anhangs lautet nicht ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Der Name keines Anhangs enthält ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Der Name keines Anhangs beginnt mit ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Der Name keines Anhangs endet mit ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Notizen des Anhangs sind nicht ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Notizen des Anhangs enthalten nicht ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Notizen des Anhangs beginnen nicht mit ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Notizen des Anhangs enden nicht mit ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT ist ":value"',
    'update_rule_from_query'                        => 'Regel „:rule” aus Suchanfrage aktualisieren',
    'create_rule_from_query'                        => 'Neue Regel aus Suchanfrage erstellen',
    'rule_from_search_words'                        => 'Die Regel-Modul hat Schwierigkeiten „:string” zu verarbeiten. Die vorgeschlagene Regel, die Ihrer Suchanfrage entspricht, kann zu unterschiedlichen Ergebnissen führen. Bitte überprüfen Sie die Regelauslöser sorgfältig.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Saldo des Zielkontos beträgt genau „:value“',
    'search_modifier_not_destination_balance_is'    => 'Saldo des Zielkontos beträgt NICHT genau „:value“',
    'search_modifier_source_balance_is'             => 'Saldo des Quellkontos beträgt genau „:value“',
    'search_modifier_not_source_balance_is'         => 'Saldo des Quellkontos beträgt NICHT genau „:value“',

    'search_modifier_destination_balance_lte'     => 'Saldo des Zielkontos ist geringer oder gleich als „:value“',
    'search_modifier_not_destination_balance_lte' => 'Saldo des Zielkontos beträgt mehr als „:value“',
    'search_modifier_source_balance_lte'          => 'Saldo des Quellkontos ist geringer oder gleich als „:value“',
    'search_modifier_not_source_balance_lte'      => 'Saldo des Quellkontos beträgt mehr als „:value“',

    'search_modifier_destination_balance_lt'     => 'Saldo des Zielkontos beträgt weniger als „:value“',
    'search_modifier_not_destination_balance_lt' => 'Saldo des Zielkontos ist höher oder gleich „:value“',
    'search_modifier_source_balance_lt'          => 'Saldo des Quellkontos beträgt weniger als „:value“',
    'search_modifier_not_source_balance_lt'      => 'Saldo des Quellkontos ist höher oder gleich als „:value“',

    'search_modifier_destination_balance_gte'     => 'Saldo des Zielkontos ist höher als oder gleich „:value“',
    'search_modifier_not_destination_balance_gte' => 'Saldo des Zielkontos beträgt weniger als „:value“',
    'search_modifier_source_balance_gte'          => 'Saldo des Quellkontos ist höher oder gleich als „:value“',
    'search_modifier_not_source_balance_gte'      => 'Saldo des Quellkontos beträgt weniger als „:value“',

    'search_modifier_destination_balance_gt'              => 'Saldo des Zielkontos beträgt mehr als „:value“',
    'search_modifier_not_destination_balance_gt'          => 'Saldo des Zielkontos ist geringer als oder gleich „:value“',
    'search_modifier_source_balance_gt'                   => 'Saldo des Quellkontos beträgt mehr als „:value“',
    'search_modifier_not_source_balance_gt'               => 'Saldo des Quellkontos ist geringer oder gleich als „:value“',


    // END
    'general_search_error'                                => 'Bei der Suche ist ein Fehler aufgetreten. Bitte überprüfen Sie die Protokolldateien für weitere Informationen.',
    'search_box'                                          => 'Suche',
    'search_box_intro'                                    => 'Willkommen bei der Suchfunktion von Firefly III. Geben Sie Ihre Suchanfrage in das Feld ein. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Lesen Sie unbedingt die Hilfedatei</a>, denn die Suche ist ziemlich umfangreich.',
    'search_error'                                        => 'Fehler beim Suchen',
    'search_searching'                                    => 'Suche ...',
    'search_results'                                      => 'Suchergebnisse',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'jährlich',
    'repeat_freq_half-year'                               => 'halbjährlich',
    'repeat_freq_quarterly'                               => 'vierteljährlich',
    'repeat_freq_monthly'                                 => 'monatlich',
    'repeat_freq_weekly'                                  => 'wöchentlich',
    'repeat_freq_daily'                                   => 'täglich',
    'daily'                                               => 'täglich',
    'weekly'                                              => 'wöchentlich',
    'quarterly'                                           => 'vierteljährlich',
    'half-year'                                           => 'halbjährlich',
    'yearly'                                              => 'jährlich',

    // rules
    'is_not_rule_trigger'                                 => 'Nicht',
    'cannot_fire_inactive_rules'                          => 'Inaktive Regeln können nicht ausgeführt werden.',
    'show_triggers'                                       => 'Auslöser anzeigen',
    'show_actions'                                        => 'Aktionen anzeigen',
    'rules'                                               => 'Regeln',
    'rule_name'                                           => 'Name der Regel',
    'rule_triggers'                                       => 'Regel wird ausgelöst wenn',
    'rule_actions'                                        => 'Regel wird',
    'new_rule'                                            => 'Neue Regel',
    'new_rule_group'                                      => 'Neue Regelgruppe',
    'rule_priority_up'                                    => 'Regel eine höhere Priorität zuweisen',
    'rule_priority_down'                                  => 'Regel eine geringere Priorität zuweisen',
    'make_new_rule_group'                                 => 'Neue Regelgruppe erstellen',
    'store_new_rule_group'                                => 'Neue Regelgruppe speichern',
    'created_new_rule_group'                              => 'Neue Regelgruppe ":title" gespeichert!',
    'updated_rule_group'                                  => 'Regelgruppe ":title" erfolgreich aktualisiert.',
    'edit_rule_group'                                     => 'Regelgruppe ":title" bearbeiten',
    'duplicate_rule'                                      => 'Regel „:title” duplizieren',
    'rule_copy_of'                                        => 'Kopie von „:title”',
    'duplicated_rule'                                     => 'Regel „:title” nach „:newTitle” dupliziert',
    'delete_rule_group'                                   => 'Regelgruppe ":title" löschen',
    'deleted_rule_group'                                  => 'Regelgruppe ":title" gelöscht',
    'update_rule_group'                                   => 'Regelgruppe aktualisieren',
    'no_rules_in_group'                                   => 'Die Gruppe enthält keine Regeln',
    'move_rule_group_up'                                  => 'Regelgruppe nach oben verschieben',
    'move_rule_group_down'                                => 'Regelgruppe nach unten verschieben',
    'save_rules_by_moving'                                => 'Speichern Sie diese Regel, indem Sie sie in eine andere Regelgruppe verschieben:|Speichern Sie diese Regeln, indem Sie sie in eine andere Regelgruppe verschieben:',
    'make_new_rule'                                       => 'Neue Regel in der Regelgruppe „:title” erstellen',
    'make_new_rule_no_group'                              => 'Neue Regel erstellen',
    'instructions_rule_from_bill'                         => 'Um Buchungen mit Ihrem neuen Abonnement „:name“ abzugleichen, kann Firefly III eine Regel erstellen, die automatisch mit allen von Ihnen gespeicherten Buchungen abgeglichen wird. Bitte überprüfen Sie die nachfolgenden Angaben und speichern Sie die Regel, damit Firefly III die Buchungen automatisch mit Ihrer neuen Rechnung abgleichen kann.',
    'instructions_rule_from_journal'                      => 'Erstellen Sie eine Regel auf der Grundlage einer Ihrer Buchungen. Ergänzen oder übermitteln Sie das nachfolgende Formular.',
    'rule_is_strict'                                      => 'strikte Regel',
    'rule_is_not_strict'                                  => 'nicht-strenge Regel',
    'rule_help_stop_processing'                           => 'Wenn Sie dieses Kontrollkästchen aktivieren, werden nachfolgende Regeln in dieser Gruppe nicht ausgeführt, wenn diese spezielle Regel ausgeführt wird.',
    'rule_help_strict'                                    => 'In strengen Regeln müssen alle Auslöser auslösen, damit die Aktion(en) ausgeführt werden. In nicht strengen Regeln genügt jeder Auslöser, um die Aktion(en) auszuführen.',
    'rule_help_active'                                    => 'Inaktive Regeln werden nie ausgeführt.',
    'stored_new_rule'                                     => 'Neue Regel mit Titel ":title" wurde gespeichert',
    'deleted_rule'                                        => 'Regel mit Titel ":title" löschen',
    'store_new_rule'                                      => 'Neue Regel speichern',
    'updated_rule'                                        => 'Regel mit Titel ":title" bearbeiten',
    'default_rule_group_name'                             => 'Standardregeln',
    'default_rule_group_description'                      => 'Alle Ihre Regeln ohne eine bestimmte Gruppe.',
    'trigger'                                             => 'Auslöser',
    'trigger_value'                                       => 'Auslösen bei Wert',
    'stop_processing_other_triggers'                      => 'Keine weiteren Auslöser verarbeiten',
    'add_rule_trigger'                                    => 'Neue Auslöser hinzufügen',
    'action'                                              => 'Aktion',
    'action_value'                                        => 'Aktionswert',
    'stop_executing_other_actions'                        => 'Keine weiteren Aktionen durchführen',
    'add_rule_action'                                     => 'Neue Aktion hinzufügen',
    'edit_rule'                                           => 'Regel #:nr ":title" bearbeiten',
    'delete_rule'                                         => 'Regel ":title" löschen',
    'update_rule'                                         => 'Regel aktualisieren',
    'test_rule_triggers'                                  => 'Zeige übereinstimmende Buchungen',
    'warning_no_matching_transactions'                    => 'Keine passenden Buchungen gefunden.',
    'warning_no_valid_triggers'                           => 'Keine gültigen Auslöser gefunden.',
    'apply_rule_selection'                                => 'Regel „:title” auf eine Auswahl Ihrer Buchungen anwenden',
    'apply_rule_selection_intro'                          => 'Regeln wie „:title” werden im Normalfall nur auf neue oder aktualisierte Buchungen angewandt. Sie können die Regel aber auch auf eine Auswahl Ihrer bestehenden Buchungen anwenden. Dies kann nützlich sein, wenn Sie eine Regel aktualisiert haben und Sie die Änderungen auf andere Buchungen übertragen möchten.',
    'include_transactions_from_accounts'                  => 'Buchungen von diesem Konto einbeziehen',
    'include'                                             => 'Inbegriffen?',
    'applied_rule_selection'                              => '{0} In Ihrer Auswahl wurden keine Buchungen durch die Regel „:title” geändert.|[1] In Ihrer Auswahl wurde eine Buchung durch die Regel „:title” geändert.|[2,*] In Ihrer Auswahl wurden :count Buchungen durch die Regel „:title” geändert.',
    'execute'                                             => 'Ausführen',
    'apply_rule_group_selection'                          => 'Regelgruppe „:title” auf eine Auswahl Ihrer Buchungen anwenden',
    'apply_rule_group_selection_intro'                    => 'Regelgruppen wie „:title” werden in der Regel nur auf neue oder aktualisierte Buchungen angewandt, aber Sie können die Gruppe auch auf eine Auswahl Ihrer bestehenden Transaktionen anwenden. Dies kann nützlich sein, wenn Sie eine Gruppe aktualisiert haben und Sie die Änderungen auf andere Buchungen übertragen möchten.',
    'applied_rule_group_selection'                        => 'Regelgruppe ":title" wurde auf Ihre Auswahl angewendet.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Wenn eine Buchung erstellt wird',
    'rule_trigger_update_journal'                         => 'Wenn eine Buchung aktualisiert wird',
    'rule_trigger_manual'                                 => 'Nur bei Benutzeraktivierung',
    'rule_trigger_user_action'                            => 'Die Nutzeraktion ist ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Quellkonto-Name beginnt mit..',
    'rule_trigger_source_account_starts'                  => 'Name des Quellkontos beginnt mit ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Quellkonto-Name endet mit..',
    'rule_trigger_source_account_ends'                    => 'Quellkonto-Name endet mit ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Quellkonto-Name lautet..',
    'rule_trigger_source_account_is'                      => 'Quellkonto-Name lautet ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Quellkonto-Name enhält..',
    'rule_trigger_source_account_contains'                => 'Quellkonto-Name enthält ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Beide Konto IDs sind exakt..',
    'rule_trigger_account_id'                             => 'Beide Konto IDs sind exakt :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Quellkonto-ID ist genau..',
    'rule_trigger_source_account_id'                      => 'Quellkonto-ID ist genau :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Zielkonto-ID ist genau..',
    'rule_trigger_destination_account_id'                 => 'Quellkonto-ID ist genau :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Beide Konten sind Bargeld',
    'rule_trigger_account_is_cash'                        => 'Beide Konten sind Bargeld',
    'rule_trigger_source_is_cash_choice'                  => 'Quellkonto ist (bar)',
    'rule_trigger_source_is_cash'                         => 'Quellkonto ist (bar)',
    'rule_trigger_destination_is_cash_choice'             => 'Zielkonto ist (bar)',
    'rule_trigger_destination_is_cash'                    => 'Zielkonto ist (bar)',
    'rule_trigger_source_account_nr_starts_choice'        => 'Quellkontonummer/IBAN beginnt mit..',
    'rule_trigger_source_account_nr_starts'               => 'Quellkontonummer/IBAN beginnt mit „:trigger_value”',
    'rule_trigger_source_account_nr_ends_choice'          => 'Quellkontonummer/IBAN endet auf..',
    'rule_trigger_source_account_nr_ends'                 => 'Quellkontonummer/IBAN endet auf „:trigger_value”',
    'rule_trigger_source_account_nr_is_choice'            => 'Quellkontonummer/IBAN ist..',
    'rule_trigger_source_account_nr_is'                   => 'Quellkontonummer/IBAN ist „:trigger_value”',
    'rule_trigger_source_account_nr_contains_choice'      => 'Quellkontonummer/IBAN enthält..',
    'rule_trigger_source_account_nr_contains'             => 'Quellkontonummer/IBAN enthält „:trigger_value”',
    'rule_trigger_destination_account_starts_choice'      => 'Zielkonto-Name beginnt mit..',
    'rule_trigger_destination_account_starts'             => 'Zielkonto-Name beginnt mit „:trigger_value”',
    'rule_trigger_destination_account_ends_choice'        => 'Zielkonto-Name endet auf..',
    'rule_trigger_destination_account_ends'               => 'Zielkonto-Name endet auf „:trigger_value”',
    'rule_trigger_destination_account_is_choice'          => 'Zielkonto-Name ist..',
    'rule_trigger_destination_account_is'                 => 'Zielkonto-Name ist „:trigger_value”',
    'rule_trigger_destination_account_contains_choice'    => 'Zielkonto-Name enthält..',
    'rule_trigger_destination_account_contains'           => 'Zielkonto-Name enthält „:trigger_value”',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Zielkontonummer/IBAN beginnt mit..',
    'rule_trigger_destination_account_nr_starts'          => 'Zielkontonummer/IBAN beginnt mit „:trigger_value”',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Zielkontonummer/IBAN endet auf..',
    'rule_trigger_destination_account_nr_ends'            => 'Zielkontonummer/IBAN endet auf „:trigger_value”',
    'rule_trigger_destination_account_nr_is_choice'       => 'Zielkontonummer / IBAN ist..',
    'rule_trigger_destination_account_nr_is'              => 'Zielkontonummer/IBAN ist „:trigger_value”',
    'rule_trigger_destination_account_nr_contains_choice' => 'Zielkontonummer / IBAN enthält..',
    'rule_trigger_destination_account_nr_contains'        => 'Zielkontonummer / IBAN enthält „:trigger_value”',
    'rule_trigger_transaction_type_choice'                => 'Buchung ist vom Typ..',
    'rule_trigger_transaction_type'                       => 'Buchung ist vom Typ ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Kategorie ist..',
    'rule_trigger_category_is'                            => 'Kategorie ist ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Betrag ist geringer oder gleich …',
    'rule_trigger_amount_less'                            => 'Betrag ist geringer oder gleich :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Betrag ist..',
    'rule_trigger_amount_is'                              => 'Betrag lautet :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Betrag ist größer oder gleich …',
    'rule_trigger_amount_more'                            => 'Betrag ist größer oder gleich :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Beschreibung beginnt mit..',
    'rule_trigger_description_starts'                     => 'Beschreibung beginnt mit ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Beschreibung endet mit..',
    'rule_trigger_description_ends'                       => 'Beschreibung endet mit ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Beschreibung enthält..',
    'rule_trigger_description_contains'                   => 'Beschreibung enthält ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Beschreibung ist..',
    'rule_trigger_description_is'                         => 'Beschreibung ist ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Buchungsdatum lautet..',
    'rule_trigger_date_on'                                => 'Buchungsdatum lautet ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Buchungsdatum ist vor..',
    'rule_trigger_date_before'                            => 'Buchungsdatum ist vor „:trigger_value”',
    'rule_trigger_date_after_choice'                      => 'Buchungsdatum ist nach..',
    'rule_trigger_date_after'                             => 'Buchungsdatum ist nach „:trigger_value”',
    'rule_trigger_created_at_on_choice'                   => 'Transaktion wurde gemacht am..',
    'rule_trigger_created_at_on'                          => 'Transaktion wurde gemacht am ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaktion wurde zuletzt bearbeitet am..',
    'rule_trigger_updated_at_on'                          => 'Transaktion wurde zuletzt bearbeitet am ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Budget ist..',
    'rule_trigger_budget_is'                              => 'Budget ist „:trigger_value”',
    'rule_trigger_tag_is_choice'                          => 'Irgendein Schlagwort lautet..',
    'rule_trigger_tag_is'                                 => 'Irgendein Schlagwort lautet ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Beliebiges Schlagwort enthält …',
    'rule_trigger_tag_contains'                           => 'Beliebiges Schlagwort enthält „:trigger_value”',
    'rule_trigger_not_tag_contains'                           => 'Kein Schlagwort enthält „:trigger_value“',
    'rule_trigger_tag_ends_choice'                        => 'Beliebiges Schlagwort endet auf ...',
    'rule_trigger_tag_ends'                               => 'Beliebiges Schlagwort endet auf „:trigger_value”',
    'rule_trigger_tag_starts_choice'                      => 'Beliebiges Schlagwort beginnt mit ...',
    'rule_trigger_tag_starts'                             => 'Beliebiges Schlagwort beginnt mit „:trigger_value”',
    'rule_trigger_currency_is_choice'                     => 'Buchungswährung ist..',
    'rule_trigger_currency_is'                            => 'Buchungswährung ist „:trigger_value”',
    'rule_trigger_foreign_currency_is_choice'             => 'Fremdwährung der Buchung ist..',
    'rule_trigger_foreign_currency_is'                    => 'Fremdwährung der Buchung ist „:trigger_value”',
    'rule_trigger_has_attachments_choice'                 => 'Enthält Anhänge',
    'rule_trigger_has_attachments'                        => 'Enthält einen oder mehrere Anhänge',
    'rule_trigger_has_no_category_choice'                 => 'Ohne Kategorie',
    'rule_trigger_has_no_category'                        => 'Buchung ohne Kategorie',
    'rule_trigger_has_any_category_choice'                => 'Hat eine (beliebige) Kategorie',
    'rule_trigger_has_any_category'                       => 'Buchung hat eine (beliebige) Kategorie',
    'rule_trigger_has_no_budget_choice'                   => 'Enthält kein Budget',
    'rule_trigger_has_no_budget'                          => 'Buchung ohne Budget',
    'rule_trigger_has_any_budget_choice'                  => 'Enthält ein (beliebiges) Budget',
    'rule_trigger_has_any_budget'                         => 'Buchung enthält ein (beliebiges) Budget',
    'rule_trigger_has_no_bill_choice'                     => 'Verfügt über kein Abonnement',
    'rule_trigger_has_no_bill'                            => 'Buchung ist keinem Abonnement zugeordnet',
    'rule_trigger_has_any_bill_choice'                    => 'Ist einem (beliebigen) Abonnement zugeordnet',
    'rule_trigger_has_any_bill'                           => 'Buchung ist einem (beliebigen) Abonnement zugeordnet',
    'rule_trigger_has_no_tag_choice'                      => 'Enthält keine Schlagwörter',
    'rule_trigger_has_no_tag'                             => 'Transaktion enthält keine Schlagwörter',
    'rule_trigger_has_any_tag_choice'                     => 'Enthält einen oder mehrere (beliebige) Schlagwörter',
    'rule_trigger_has_any_tag'                            => 'Buchung enthält ein oder mehrere (beliebige) Schlagwörter',
    'rule_trigger_any_notes_choice'                       => 'Hat (beliebige) Notizen',
    'rule_trigger_any_notes'                              => 'Die Buchung hat (beliebige) Notizen',
    'rule_trigger_no_notes_choice'                        => 'Hat keine Notizen',
    'rule_trigger_no_notes'                               => 'Buchung hat keine Notizen',
    'rule_trigger_notes_is_choice'                        => 'Notizen lauten..',
    'rule_trigger_notes_is'                               => 'Notizen lauten ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notizen beinhalten..',
    'rule_trigger_notes_contains'                         => 'Notizen beinhalten ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notizen beginnen mit..',
    'rule_trigger_notes_starts'                           => 'Notizen beginnen mit ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notizen enden mit..',
    'rule_trigger_notes_ends'                             => 'Notizen enden mit ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Abonnement lautet ...',
    'rule_trigger_bill_is'                                => 'Abonnement lautet „:trigger_value“',
    'rule_trigger_external_id_is_choice'                  => 'Externe ID ist..',
    'rule_trigger_external_id_is'                         => 'Externe ID ist ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Interne Referenz ist..',
    'rule_trigger_internal_reference_is'                  => 'Interne Referenz ist ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Transaktions-Journal-ID ist..',
    'rule_trigger_journal_id'                             => 'Transaktions-Journal-ID ist „:trigger_value”',
    'rule_trigger_any_external_url'                       => 'Buchung enthält eine (beliebige) externe URL',
    'rule_trigger_any_external_url_choice'                => 'Enthält eine (beliebige) externe URL',
    'rule_trigger_any_external_id'                        => 'Buchung enthält eine (beliebige) externe ID',
    'rule_trigger_any_external_id_choice'                 => 'Enthält eine (beliebige) externe ID',
    'rule_trigger_no_external_url_choice'                 => 'Enthält keine externe URL',
    'rule_trigger_no_external_url'                        => 'Buchung hat keine externe URL',
    'rule_trigger_no_external_id_choice'                  => 'Enthält keine externe ID',
    'rule_trigger_no_external_id'                         => 'Buchung enthält keine externe ID',
    'rule_trigger_id_choice'                              => 'Buchungskennung lautet..',
    'rule_trigger_id'                                     => 'Buchungskennung lautet „:trigger_value”',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT ist...',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT ist ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Die Nutzeraktion ist ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Kein Schlagwort lautet..',
    'rule_trigger_tag_is_not'                             => 'Kein Schlagwort lautet ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Beide Konten lauten exakt..',
    'rule_trigger_account_is'                             => 'Beide Konten lauten exakt ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Beide Konten beinhalten..',
    'rule_trigger_account_contains'                       => 'Beide Konten beinhalten ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Beide Konten enden mit..',
    'rule_trigger_account_ends'                           => 'Beide Konten enden mit ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Beide Konten beginnen mit..',
    'rule_trigger_account_starts'                         => 'Beide Konten beginnen mit ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Beide Kontonummer / IBAN lauten..',
    'rule_trigger_account_nr_is'                          => 'Beide Kontonummer / IBAN lauten ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Beide Kontonummer / IBAN enthalten..',
    'rule_trigger_account_nr_contains'                    => 'Beide Kontonummer / IBAN enthalten ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Entweder Kontonummer oder IBAN enden auf..',
    'rule_trigger_account_nr_ends'                        => 'Entweder Kontonummer oder IBAN enden auf ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Entweder Kontonummer oder IBAN beginnen mit..',
    'rule_trigger_account_nr_starts'                      => 'Beide Kontonummer / IBAN beginnen mit ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Kategorie enthält..',
    'rule_trigger_category_contains'                      => 'Kategorie enthält ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Kategorie endet mit..',
    'rule_trigger_category_ends'                          => 'Kategorie endet mit ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Kategorie startet mit..',
    'rule_trigger_category_starts'                        => 'Kategorie startet mit ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget enthält..',
    'rule_trigger_budget_contains'                        => 'Budget enthält ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget endet mit..',
    'rule_trigger_budget_ends'                            => 'Budget endet mit ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget beginnt mit..',
    'rule_trigger_budget_starts'                          => 'Budget beginnt mit ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Abonnement enthält ...',
    'rule_trigger_bill_contains'                          => 'Abonnement enthält „:trigger_value“',
    'rule_trigger_bill_ends_choice'                       => 'Abonnement endet auf ...',
    'rule_trigger_bill_ends'                              => 'Abonnement endet auf „:trigger_value“',
    'rule_trigger_bill_starts_choice'                     => 'Abonnement beginnt mit ...',
    'rule_trigger_bill_starts'                            => 'Abonnement beginnt mit „:trigger_value“',
    'rule_trigger_external_id_contains_choice'            => 'Externe ID enthält..',
    'rule_trigger_external_id_contains'                   => 'Externe ID enthält ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'Externe ID endet mit..',
    'rule_trigger_external_id_ends'                       => 'Externe ID endet mit ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'Externe ID startet mit..',
    'rule_trigger_external_id_starts'                     => 'Externe ID beginnt mit ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Interne Referenz enthält..',
    'rule_trigger_internal_reference_contains'            => 'Interne Referenz enthält ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Interne Referenz endet mit..',
    'rule_trigger_internal_reference_ends'                => 'Interne Referenz endet mit ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Interne Referenz beginnt mit..',
    'rule_trigger_internal_reference_starts'              => 'Interne Referenz beginnt mit ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'Externe URL ist..',
    'rule_trigger_external_url_is'                        => 'Externe URL ist ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'Externe URL enthält..',
    'rule_trigger_external_url_contains'                  => 'Externe URL enthält ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'Externe URL endet mit..',
    'rule_trigger_external_url_ends'                      => 'Externe URL endet mit ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'Externe URL beginnt mit..',
    'rule_trigger_external_url_starts'                    => 'Externe URL beginnt mit ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Hat keine Anhänge',
    'rule_trigger_has_no_attachments'                     => 'Transaktion hat keine Anhänge',
    'rule_trigger_recurrence_id_choice'                   => 'Dauerauftrags-ID ist..',
    'rule_trigger_recurrence_id'                          => 'Dauerauftrags-ID ist ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Zinstermin ist am..',
    'rule_trigger_interest_date_on'                       => 'Zinstermin ist am ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Zinstermin ist vor dem..',
    'rule_trigger_interest_date_before'                   => 'Das Zinsdatum liegt vor dem „:trigger_value”',
    'rule_trigger_interest_date_after_choice'             => 'Zinstermin ist nach dem..',
    'rule_trigger_interest_date_after'                    => 'Das Zinsdatum liegt nach dem „:trigger_value”',
    'rule_trigger_book_date_on_choice'                    => 'Buchungsdatum ist am..',
    'rule_trigger_book_date_on'                           => 'Buchungsdatum ist am ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Buchungsdatum ist vor dem..',
    'rule_trigger_book_date_before'                       => 'Buchungsdatum ist vor dem ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Buchungsdatum ist nach dem..',
    'rule_trigger_book_date_after'                        => 'Buchungsdatum ist nach dem ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Wertstellungsdatum ist am..',
    'rule_trigger_process_date_on'                        => 'Wertstellungsdatum ist ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Wertstellungsdatum ist vor dem..',
    'rule_trigger_process_date_before'                    => 'Wertstellungsdatum ist vor dem ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Wertstellungsdatum ist nach dem..',
    'rule_trigger_process_date_after'                     => 'Wertstellungsdatum ist nach dem ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Fälligkeitstermin ist am..',
    'rule_trigger_due_date_on'                            => 'Fälligkeitstermin ist am ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Fälligkeitstermin ist vor dem..',
    'rule_trigger_due_date_before'                        => 'Fälligkeitstermin ist vor dem ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Fälligkeitstermin ist nach dem..',
    'rule_trigger_due_date_after'                         => 'Fälligkeitstermin ist nach dem ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Zahlungsdatum ist am..',
    'rule_trigger_payment_date_on'                        => 'Zahlungsdatum ist am ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Zahlungsdatum ist vor dem..',
    'rule_trigger_payment_date_before'                    => 'Zahlungsdatum ist vor dem ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Zahlungsdatum ist nach..',
    'rule_trigger_payment_date_after'                     => 'Zahlungsdatum ist nach dem ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Rechnungsdatum ist am..',
    'rule_trigger_invoice_date_on'                        => 'Rechnungsdatum ist am ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Rechnungsdatum ist vor dem..',
    'rule_trigger_invoice_date_before'                    => 'Rechnungsdatum ist vor dem ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Rechnungsdatum ist nach dem..',
    'rule_trigger_invoice_date_after'                     => 'Rechnungsdatum ist nach dem ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaktion wurde erstellt vor dem..',
    'rule_trigger_created_at_before'                      => 'Transaktion wurde erstellt vor dem ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaktion wurde erstellt nach dem..',
    'rule_trigger_created_at_after'                       => 'Transaktion wurde erstellt nach dem ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaktion wurde zuletzt aktualisiert vor dem..',
    'rule_trigger_updated_at_before'                      => 'Transaktion wurde zuletzt aktualisiert vor dem ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaktion wurde zuletzt aktualisiert nach dem..',
    'rule_trigger_updated_at_after'                       => 'Transaktion wurde zuletzt aktualisiert nach dem ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Buchungsbetrag (Fremdwährung) ist exakt..',
    'rule_trigger_foreign_amount_is'                      => 'Buchungsbetrag (Fremdwährung) ist exakt ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Buchungsbetrag (Fremdwährung) ist geringer als ...',
    'rule_trigger_foreign_amount_less'                    => 'Buchungsbetrag (Fremdwährung) ist geringer als ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Buchungsbetrag (Fremdwährung) ist höher als..',
    'rule_trigger_foreign_amount_more'                    => 'Buchungsbetrag (Fremdwährung) ist höher als ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Der Name eines Anhangs lautet..',
    'rule_trigger_attachment_name_is'                     => 'Der Name eines Anhangs lautet ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Der Name eines Anhangs enthält..',
    'rule_trigger_attachment_name_contains'               => 'Der Name eines Anhangs enthält ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Der Name eines Anhangs beginnt mit..',
    'rule_trigger_attachment_name_starts'                 => 'Der Name eines Anhangs beginnt mit ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Der Name eines Anhangs endet mit..',
    'rule_trigger_attachment_name_ends'                   => 'Der Name eines Anhangs endet mit ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Notizen des Anhangs lauten..',
    'rule_trigger_attachment_notes_are'                   => 'Notizen des Anhangs lauten ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Notizen des Anhangs beinhalten..',
    'rule_trigger_attachment_notes_contains'              => 'Notizen des Anhangs beinhalten ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Notizen des Anhangs beginnen mit..',
    'rule_trigger_attachment_notes_starts'                => 'Notizen des Anhangs beginnen mit ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Notizen des Anhangs enden mit..',
    'rule_trigger_attachment_notes_ends'                  => 'Notizen des Anhangs enden mit ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Buchung wurde ausgeglichen',
    'rule_trigger_reconciled'                             => 'Buchung wurde ausgeglichen',
    'rule_trigger_exists_choice'                          => 'Alle Buchungen stimmen überein(!)',
    'rule_trigger_exists'                                 => 'Alle Buchungen stimmen überein',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Konto-ID ist nicht ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Quellkonto-ID ist nicht ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Zielkonto-ID ist nicht ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Buchungstyp ist nicht „:trigger_value”',
    'rule_trigger_not_tag_is'                             => 'Schlagwort ist nicht ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Schlagwort ist ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Beschreibung ist nicht ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Die Beschreibung enthält nicht „:trigger_value“',
    'rule_trigger_not_description_ends'                   => 'Beschreibung endet nicht mit ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Beschreibung beginnt nicht mit ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notizen lauten nicht ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notizen enthalten nicht ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notizen enden nicht mit ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notizen beginnen nicht mit ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Quellkonto ist nicht ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Quellkonto enthält nicht ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Quellkonto endet nicht mit ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Quellkonto beginnt nicht mit ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Quellkontonummer / IBAN ist nicht „:trigger_value”',
    'rule_trigger_not_source_account_nr_contains'         => 'Quellkontonummer / IBAN enthält nicht „:trigger_value”',
    'rule_trigger_not_source_account_nr_ends'             => 'Quellkontonummer / IBAN endet nicht auf „:trigger_value”',
    'rule_trigger_not_source_account_nr_starts'           => 'Quellkontonummer / IBAN beginnt nicht mit „:trigger_value”',
    'rule_trigger_not_destination_account_is'             => 'Zielkonto ist nicht ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Zielkonto enthält nicht ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Zielkonto endet nicht mit ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Zielkonto beginnt nicht mit ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Zielkontonummer / IBAN ist nicht „:trigger_value”',
    'rule_trigger_not_destination_account_nr_contains'    => 'Zielkontonummer / IBAN enthält nicht „:trigger_value”',
    'rule_trigger_not_destination_account_nr_ends'        => 'Zielkontonummer / IBAN endet nicht mit „:trigger_value”',
    'rule_trigger_not_destination_account_nr_starts'      => 'Zielkontonummer / IBAN beginnt nicht mit „:trigger_value”',
    'rule_trigger_not_account_is'                         => 'Beide Konten sind nicht ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Beide Konten enthalten nicht ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Beide Konten enden nicht mit ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Beide Konten beginnen nicht mit ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Beide Kontonummern / IBANs sind nicht ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Beide Kontonummern / IBANs enthalten ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Beide Kontonummern / IBANs enden mit ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Beide Kontonummern / IBANs beginnen nicht mit ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Kategorie ist nicht ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Kategorie enthält nicht ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Kategorie endet nicht mit „:trigger_value”',
    'rule_trigger_not_category_starts'                    => 'Kategorie beginnt nicht mit „:trigger_value”',
    'rule_trigger_not_budget_is'                          => 'Budget ist nicht „:trigger_value”',
    'rule_trigger_not_budget_contains'                    => 'Budget enthält nicht „:trigger_value”',
    'rule_trigger_not_budget_ends'                        => 'Budget endet nicht mit „:trigger_value”',
    'rule_trigger_not_budget_starts'                      => 'Budget beginnt nicht mit „:trigger_value”',
    'rule_trigger_not_bill_is'                            => 'Abonnement ist nicht „:trigger_value“',
    'rule_trigger_not_bill_contains'                      => 'Abonnement enthält nicht „:trigger_value“',
    'rule_trigger_not_bill_ends'                          => 'Abonnement endet nicht auf „:trigger_value“',
    'rule_trigger_not_bill_starts'                        => 'Abonnement endet nicht auf „:trigger_value“',
    'rule_trigger_not_external_id_is'                     => 'Externe ID ist nicht ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'Externe ID enthält nicht ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'Externe ID endet nicht mit ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'Externe ID beginnt nicht mit ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Interne Referenz ist nicht „:trigger_value”',
    'rule_trigger_not_internal_reference_contains'        => 'Interne Referenz enthält nicht „:trigger_value”',
    'rule_trigger_not_internal_reference_ends'            => 'Interne Referenz endet nicht auf „:trigger_value”',
    'rule_trigger_not_internal_reference_starts'          => 'Interne Referenz beginnt nicht mit „:trigger_value”',
    'rule_trigger_not_external_url_is'                    => 'Externe URL ist nicht ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'Externe URL enthält nicht ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'Externe URL endet nicht mit ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'Externe URL beginnt nicht mit ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Währung ist nicht ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Fremdwährung ist nicht ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Buchungs-ID ist nicht ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaktions-Journal-ID ist nicht ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Wiederholungs-ID ist nicht ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Datum ist nicht am ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Datum liegt nicht vor ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Das Datum liegt nicht nach ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Zinsdatum ist nicht auf ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Zinsdatum liegt nicht vor ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Zinsdatum liegt nicht nach ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Buchungsdatum ist nicht am ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Buchungsdatum ist nicht vor ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Buchungsdatum ist nicht nach ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Wertstellungsdatum ist nicht am ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Wertstellungsdatum ist nicht vor dem ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Wertstellungsdatum ist nicht nach dem ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Fälligkeitstermin ist nicht am ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Fälligkeitstermin ist nicht vor ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Fälligkeitstermin ist nicht nach ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Zahlungsdatum ist nicht am ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Zahlungsdatum ist nicht vor ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Zahlungsdatum ist nicht nach ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Rechnungsdatum ist nicht ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Rechnungsdatum liegt nicht vor ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Rechnungsdatum liegt nicht nach ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Buchung wurde nicht am ":trigger_value" erstellt',
    'rule_trigger_not_created_at_before'                  => 'Buchung wurde nicht vor dem ":trigger_value" erstellt',
    'rule_trigger_not_created_at_after'                   => 'Buchung wurde nicht nach dem ":trigger_value" erstellt',
    'rule_trigger_not_updated_at_on'                      => 'Buchung wurde nicht am ":trigger_value" aktualisiert',
    'rule_trigger_not_updated_at_before'                  => 'Buchung wurde nicht vor dem ":trigger_value" aktualisiert',
    'rule_trigger_not_updated_at_after'                   => 'Buchung wurde nicht nach dem ":trigger_value" aktualisiert',
    'rule_trigger_not_amount_is'                          => 'Buchungsbetrag ist nicht ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Buchungsbetrag ist höher als ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Buchungsbetrag ist geringer als ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Buchungsbetrag (Fremdwährung) ist nicht ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Buchungsbetrag (Fremdwährung) ist höher als ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Buchungsbetrag (Fremdwährung) ist geringer als ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Kein Anhang heißt ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Kein Anhangsname enthält ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Kein Anhangsname beginnt mit ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Kein Anhangsname endet mit ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Notizen des Anhangs lauten nicht ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Notizen des Anhangs enthalten nicht ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Notizen des Anhangs beginnen nicht mit ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Notizen des Anhangs enden nicht mit ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Buchung wurde nicht abgeglichen',
    'rule_trigger_not_exists'                             => 'Buchung existiert nicht',
    'rule_trigger_not_has_attachments'                    => 'Buchung hat keine Anhänge',
    'rule_trigger_not_has_any_category'                   => 'Buchung ohne Kategorie',
    'rule_trigger_not_has_any_budget'                     => 'Für die Transaktion ist kein Budget vorhanden',
    'rule_trigger_not_has_any_bill'                       => 'Buchung ist keinem Abonnement zugeordnet',
    'rule_trigger_not_has_any_tag'                        => 'Buchung hat keine Schlagwörter',
    'rule_trigger_not_any_notes'                          => 'Buchung hat keine Notizen',
    'rule_trigger_not_any_external_url'                   => 'Buchung besitzt keine externe URL',
    'rule_trigger_not_has_no_attachments'                 => 'Buchung hat Anhänge',
    'rule_trigger_not_has_no_category'                    => 'Buchung hat eine (beliebige) Kategorie',
    'rule_trigger_not_has_no_budget'                      => 'Buchung hat ein (beliebiges) Budget',
    'rule_trigger_not_has_no_bill'                        => 'Buchung ist einem (beliebigen) Abonnement zugeordnet',
    'rule_trigger_not_has_no_tag'                         => 'Buchung hat ein (beliebiges) Schlagwort',
    'rule_trigger_not_no_notes'                           => 'Die Buchung hat Notizen',
    'rule_trigger_not_no_external_url'                    => 'Die Buchung besitzt eine externe URL',
    'rule_trigger_not_source_is_cash'                     => 'Zielkonto ist kein Bargeldkonto',
    'rule_trigger_not_destination_is_cash'                => 'Zielkonto ist kein Bargeldkonto',
    'rule_trigger_not_account_is_cash'                    => 'Beide Konten sind keine Bargeldkonten',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Saldo des Zielkontos beträgt mehr als ...',
    'rule_trigger_destination_balance_gte_choice'         => 'Saldo des Zielkontos ist höher als oder gleich ...',
    'rule_trigger_destination_balance_is_choice'          => 'Saldo des Zielkontos beträgt genau ...',
    'rule_trigger_destination_balance_lt_choice'          => 'Saldo des Zielkontos beträgt weniger als ...',
    'rule_trigger_destination_balance_lte_choice'         => 'Saldo des Zielkontos ist geringer oder gleich ...',

    'rule_trigger_source_balance_gt_choice'  => 'Saldo des Quellkontos beträgt mehr als ...',
    'rule_trigger_source_balance_gte_choice' => 'Saldo des Quellkontos ist höher oder gleich als ...',
    'rule_trigger_source_balance_is_choice'  => 'Saldo des Quellkontos beträgt ...',
    'rule_trigger_source_balance_lt_choice'  => 'Saldo des Quellkontos beträgt weniger als ...',
    'rule_trigger_source_balance_lte_choice' => 'Saldo des Quellkontos ist geringer als oder gleich ...',

    'rule_trigger_destination_balance_gt'  => 'Saldo des Zielkontos beträgt mehr als :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Saldo des Zielkontos ist höher als oder gleich :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Saldo des Zielkontos beträgt genau :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Saldo des Zielkontos beträgt weniger als :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Saldo des Zielkontos beträgt weniger als oder gleich :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Saldo des Quellkontos beträgt mehr als :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Saldo des Quellkontos ist höher als oder gleich :trigger_value',
    'rule_trigger_source_balance_is'           => 'Saldo des Quellkontos beträgt genau :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Saldo des Quellkontos beträgt weniger als :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Saldo des Quellkontos ist geringer oder gleich :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Saldo des Zielkontos beträgt weniger als oder gleich :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Saldo des Zielkontos beträgt weniger als :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Saldo des Zielkontos beträgt nicht :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Saldo des Zielkontos ist höher als oder gleich :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Saldo des Zielkontos beträgt mehr als :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Saldo des Quellkontos ist niedriger oder gleich :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Saldo des Quellkontos beträgt weniger als :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Saldo des Quellkontos beträgt nicht :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Saldo des Quellkontos ist höher als oder gleich :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Saldo des Quellkontos beträgt mehr als :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'Buchung LÖSCHEN(!)',
    'rule_action_delete_transaction'             => 'Buchung LÖSCHEN(!)',
    'rule_action_set_category'                   => 'Kategorie auf ":action_value" setzen',
    'rule_action_clear_category'                 => 'Kategorie entfernen',
    'rule_action_set_budget'                     => 'Budget auf „:action_value” setzen',
    'rule_action_clear_budget'                   => 'Budget leeren',
    'rule_action_add_tag'                        => 'Schlagwort „:action_value” hinzufügen',
    'rule_action_remove_tag'                     => 'Schlagwort „:action_value” entfernen',
    'rule_action_remove_all_tags'                => 'Alle Schlüsselwörter entfernen',
    'rule_action_set_description'                => 'Beschreibung setzen für ":action_value"',
    'rule_action_append_description'             => '":action_value" an Beschreibung anfügen',
    'rule_action_prepend_description'            => '":action_value" vor Beschreibung einfügen',
    'rule_action_set_category_choice'            => 'Kategorie zuweisen ...',
    'rule_action_clear_category_choice'          => 'Bereinige jede Kategorie',
    'rule_action_set_budget_choice'              => 'Setze Budget auf ..',
    'rule_action_clear_budget_choice'            => 'Alle Budgets leeren',
    'rule_action_add_tag_choice'                 => 'Schlagwort hinzufügen ..',
    'rule_action_remove_tag_choice'              => 'Schlagwort entfernen ..',
    'rule_action_remove_all_tags_choice'         => 'Alle Schlagwörter entfernen',
    'rule_action_set_description_choice'         => 'Beschreibung festlegen auf ..',
    'rule_action_update_piggy_choice'            => 'Hinzufügen / Entfernen des Transaktionsbetrags zu / aus Sparschwein ..',
    'rule_action_update_piggy'                   => 'Transaktionsbetrag zu / aus Sparschwein ":action_value" hinzufügen / entfernen',
    'rule_action_append_description_choice'      => 'Beschreibung anhängen mit ..',
    'rule_action_prepend_description_choice'     => 'Beschreibung voranstellen mit ..',
    'rule_action_set_source_account_choice'      => 'Quellkonto festlegen auf ..',
    'rule_action_set_source_account'             => 'Lege Quellkonto als :action_value fest',
    'rule_action_set_destination_account_choice' => 'Zielkonto festlegen auf ..',
    'rule_action_set_destination_account'        => 'Lege Zielkonto als :action_value fest',
    'rule_action_append_notes_choice'            => 'Notizen anhängen mit ..',
    'rule_action_append_notes'                   => '„:action_value” an Notizen anhängen',
    'rule_action_prepend_notes_choice'           => 'Notizen voranstellen mit ..',
    'rule_action_prepend_notes'                  => '„:action_value” vor Notizen voranstellen',
    'rule_action_clear_notes_choice'             => 'Alle Notizen entfernen',
    'rule_action_clear_notes'                    => 'Alle Notizen entfernen',
    'rule_action_set_notes_choice'               => 'Setze Notizen auf ..',
    'rule_action_link_to_bill_choice'            => 'Link zu einem Abonnement ...',
    'rule_action_link_to_bill'                   => 'Link zum Abonnement „:action_value“',
    'rule_action_switch_accounts_choice'         => 'Quell- und Zielkonten tauschen (nur Umbuchungen!)',
    'rule_action_switch_accounts'                => 'Quelle und Ziel tauschen',
    'rule_action_set_notes'                      => 'Notizen auf „:action_value” setzen',
    'rule_action_convert_deposit_choice'         => 'Buchung in eine Einnahme umwandeln',
    'rule_action_convert_deposit'                => 'Buchung von ":action_value" in eine Einnahme umwandeln',
    'rule_action_convert_withdrawal_choice'      => 'Buchung in eine Ausgabe umwandeln',
    'rule_action_convert_withdrawal'             => 'Buchung von ":action_value" in eine Ausgabe umwandeln',
    'rule_action_convert_transfer_choice'        => 'Buchung in eine Umbuchung umwandeln',
    'rule_action_convert_transfer'               => 'Buchung von ":action_value" in eine Umbuchung umwandeln',
    'rule_action_append_descr_to_notes_choice'   => 'Beschreibung an die Buchungsnotizen anhängen',
    'rule_action_append_notes_to_descr_choice'   => 'Buchungsnotizen an die Beschreibung anhängen',
    'rule_action_move_descr_to_notes_choice'     => 'Buchungsnotizen durch die Beschreibung ersetzen',
    'rule_action_move_notes_to_descr_choice'     => 'Beschreibung durch die Buchungsnotizen ersetzen',
    'rule_action_append_descr_to_notes'          => 'Beschreibung an die Notizen anhängen',
    'rule_action_append_notes_to_descr'          => 'Notizen an die Beschreibung anhängen',
    'rule_action_move_descr_to_notes'            => 'Notizen durch die Beschreibung ersetzen',
    'rule_action_move_notes_to_descr'            => 'Beschreibung durch die Notizen ersetzen',
    'rule_action_set_amount_choice'              => 'Betrag festlegen auf …',
    'rule_action_set_amount'                     => 'Betrag festlegen auf „:action_value”',
    'rule_action_set_destination_to_cash_choice' => 'Zielkonto auf (Bargeld) setzen',
    'rule_action_set_source_to_cash_choice'      => 'Quellkonto auf (Bargeld) setzen',
    'rulegroup_for_bills_title'                  => 'Regelgruppe für Abonnements',
    'rulegroup_for_bills_description'            => 'Eine spezielle Regelgruppe für alle Regeln, die Abonnements betreffen.',
    'rule_for_bill_title'                        => 'Automatisch generierte Regel für Abonnement „:name“',
    'rule_for_bill_description'                  => 'Diese Regel wird automatisch erstellt, um zu versuchen, das Abonnement „:name“ abzugleichen.',
    'create_rule_for_bill'                       => 'Neue Regel für das Abonnement „:name“ erstellen',
    'create_rule_for_bill_txt'                   => 'Sie haben soeben ein neues Abonnement mit dem Namen „:name“ erstellt, herzlichen Glückwunsch! Firefly III kann neue Abhebungen automatisch mit diesem Abonnement verknüpfen. Wenn Sie zum Beispiel Ihre Miete bezahlen, wird das Abonnement „Miete“ mit dieser Ausgabe verknüpft. Auf diese Weise kann Firefly III Ihnen genau zeigen, welche Abos fällig sind und welche nicht. Dazu muss eine neue Regel erstellt werden. Firefly III hat einige sinnvolle Voreinstellungen für Sie getroffen. Bitte stellen Sie sicher, dass diese korrekt sind. Wenn diese Werte korrekt sind, wird Firefly III automatisch die richtige Abhebung mit dem richtigen Abonnement verknüpfen. Bitte überprüfen Sie die Auslöser, um zu sehen, ob sie korrekt sind, und fügen Sie einige hinzu, wenn sie falsch sind.',
    'new_rule_for_bill_title'                    => 'Regel für Abonnement „:name“',
    'new_rule_for_bill_description'              => 'Diese Regel kennzeichnet Buchungen für das Abonnement „:name”.',

    'new_rule_for_journal_title'                => 'Regel basierend auf der Buchung „:description”',
    'new_rule_for_journal_description'          => 'Diese Regel basiert auf der Buchung „:description”. Sie stimmt mit Buchungen überein, die identisch sind.',

    // tags
    'store_new_tag'                             => 'Neues Schlagwort speichern',
    'update_tag'                                => 'Schlüsselwort aktualisieren',
    'no_location_set'                           => 'Kein Ort gesetzt.',
    'meta_data'                                 => 'Metadaten',
    'location'                                  => 'Standort',
    'location_first_split'                      => 'Der Standort für diese Buchung kann bei der ersten Aufteilung dieser Buchung festgelegt werden.',
    'without_date'                              => 'Ohne Datum',
    'result'                                    => 'Ergebnis',
    'sums_apply_to_range'                       => 'Alle Summen beziehen sich auf den ausgewählten Bereich.',
    'mapbox_api_key'                            => 'Um Karten zu verwenden, besorgen Sie sich einen API-Schlüssel von <a href="https://www.mapbox.com/">Mapbox</a>. Öffnen Sie Ihre Datei <code>.env</code> und geben Sie diesen Schlüssel nach <code>MAPBOX_API_KEY=</code> ein.',
    'press_object_location'                     => 'Rechtsklick oder Anklicken und gedrückt halten, um die Position des Objekts festzulegen.',
    'click_tap_location'                        => 'Klicken/Tippen Sie auf die Karte, um einen Standort hinzuzufügen',
    'clear_location'                            => 'Ort leeren',
    'delete_all_selected_tags'                  => 'Alle markierten Stichwörter löschen',
    'select_tags_to_delete'                     => 'Nicht vergessen, einige Schlagwörter auszuwählen.',
    'deleted_x_tags'                            => ':count Tag gelöscht.|:count Tags gelöscht.',
    'create_rule_from_transaction'              => 'Regel auf Basis der Buchung erstellen',
    'create_recurring_from_transaction'         => 'Dauerauftrag basierend auf der Buchung erstellen',

    // preferences
    'test_notifications_buttons'                => 'Um Ihre Konfiguration zu testen, verwenden Sie die Schaltflächen unten. Bitte beachten Sie, dass die Schaltflächen keine Spam-Kontrolle bieten.',
    'dark_mode_option_browser'                  => 'Browser entscheiden lassen',
    'dark_mode_option_light'                    => 'Immer hell',
    'dark_mode_option_dark'                     => 'Immer dunkel',
    'equal_to_language'                         => '(entsprechend der Sprache)',
    'dark_mode_preference'                      => 'Dunkel Modus',
    'dark_mode_preference_help'                 => 'Firefly III mitteilen, wann der Dunkelmodus verwendet werden soll.',
    'pref_home_screen_accounts'                 => 'Konten auf dem Startbildschirm',
    'pref_home_screen_accounts_help'            => 'Welche Konten sollen auf dem Startbildschirm angezeigt werden?',
    'pref_view_range'                           => 'Sichtbarer Zeitraum',
    'pref_view_range_help'                      => 'Einige Diagramme werden automatisch in Abschnitte aufgeteilt. Ihre Budgets werden ebenfalls in Abschnitte unterteilt. Welchen Zeitraum bevorzugen Sie?',
    'pref_1D'                                   => 'Ein Tag',
    'pref_1W'                                   => 'Eine Woche',
    'pref_1M'                                   => 'Ein Monat',
    'pref_3M'                                   => 'Drei Monate (Quartal)',
    'pref_6M'                                   => 'Sechs Monate',
    'pref_1Y'                                   => 'Ein Jahr',
    'pref_last365'                              => 'Letztes Jahr',
    'pref_last90'                               => 'Letzte 90 Tage',
    'pref_last30'                               => 'Letzte 30 Tage',
    'pref_last7'                                => 'Letzte 7 Tage',
    'pref_YTD'                                  => 'Jahr bis heute',
    'pref_QTD'                                  => 'Quartal bis heute',
    'pref_MTD'                                  => 'Monat bis heute',
    'pref_languages'                            => 'Sprachen',
    'pref_locale'                               => 'Lokale Einstellungen',
    'pref_languages_help'                       => 'Firefly III unterstützt mehrere Sprachen. Welche möchten Sie nutzen?',
    'pref_locale_help'                          => 'Mit Firefly III können Sie weitere lokale Einstellungen vornehmen, z.B. wie Währungen, Zahlen und Daten formatiert werden sollen. Einträge in dieser Liste werden von Ihrem System möglicherweise nicht unterstützt. Firefly III enthält nicht die korrekten Datumseinstellungen für jedes Gebietsschema. Kontaktieren Sie uns für Verbesserungen.',
    'pref_locale_no_demo'                       => 'Diese Funktion kann von Demo-Nutzern nicht genutzt werden.',
    'pref_convert_to_primary'                   => 'Beträge in Ihrer Landeswährung anzeigen',
    'pref_convert_to_primary_help'              => 'Mit dieser Option versucht Firefly III, Ihre Landeswährung an möglichst vielen Stellen anzuzeigen und zu verwenden und führt bei Bedarf Umrechnungen durch. Dies geht zu Lasten der Genauigkeit, da Umrechnungen nicht immer exakt sind. Bitte überprüfen Sie auf der Seite „Wechselkurse”, ob Firefly III über die erforderlichen Umrechnungskurse verfügt.',
    'pref_convert_primary_help'                 => 'Beträge in Landeswährung anzeigen',
    'pref_custom_fiscal_year'                   => 'Einstellungen zum Geschäftsjahr',
    'pref_custom_fiscal_year_label'             => 'Aktiviert',
    'pref_custom_fiscal_year_help'              => 'In Ländern, in denen ein Geschäftsjahr nicht vom 1. Januar bis 31. Dezember dauert, können Sie diese Option ändern und Start / Ende des Geschäftsjahres angeben',
    'pref_fiscal_year_start_label'              => 'Startdatum des Geschäftsjahres',
    'pref_two_factor_auth'                      => 'Multifaktor-Authentifizierung',
    'pref_two_factor_auth_help'                 => 'Wenn Sie die Multifaktor-Authentifizierung (auch bekannt als Zwei-Faktor-Authentifizierung) aktivieren, fügen Sie Ihrem Konto eine zusätzliche Sicherheitsebene hinzu. Sie melden sich mit etwas an, das Sie kennen (Ihr Passwort) und etwas, das Sie haben (einen Bestätigungscode). Die Bestätigungscodes werden von einer Anwendung auf Ihrem Telefon generiert, z. B. Authy oder Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Multifaktor-Authentifizierung aktivieren',
    'pref_two_factor_auth_disabled'             => 'Bestätigungscode für die Multifaktor-Authentifizierung entfernt und deaktiviert',
    'pref_two_factor_auth_remove_it'            => 'Vergessen Sie nicht ihr Benutzerkonto aus ihrer Authentifizierungsapp zu entfernen!',
    'pref_two_factor_auth_code'                 => 'Code überprüfen',
    'pref_two_factor_auth_code_help'            => 'Erfassen Sie den QR-Code mit einer Anwendung auf Ihrem Telefon, z. B. Authy oder Google Authenticator, und geben Sie den generierten Code ein. Der QR-Code ändert sich jedes Mal, wenn Sie diese Seite besuchen. Stellen Sie sicher, dass Sie den neuesten Code verwenden.',
    'pref_two_factor_auth_reset_code'           => 'Verifizierungscode zurücksetzen',
    'pref_two_factor_auth_disable_2fa'          => 'MFA deaktivieren',
    '2fa_use_secret_instead'                    => 'Wenn Sie den QR-Code nicht einlesen können, können Sie stattdessen das Geheimnis verwenden: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Speichern Sie diese Sicherungsschlüssel für den Zugriff, falls Sie Ihr Gerät verlieren sollten.',
    '2fa_already_enabled'                       => 'Die Verifizierung der Multifaktor-Authentifizierung wurde bereits aktiviert.',
    'wrong_mfa_code'                            => 'Dieser MFA-Code ist ungültig.',
    'pref_save_settings'                        => 'Einstellungen speichern',
    'saved_preferences'                         => 'Einstellungen gespeichert!',
    'preferences_general'                       => 'Allgemein',
    'preferences_frontpage'                     => 'Startbildschirm',
    'preferences_security'                      => 'Sicherheit',
    'preferences_layout'                        => 'Anordnung',
    'preferences_notifications'                 => 'Benachrichtigungen',
    'pref_home_show_deposits'                   => 'Einnahmen auf dem Startbildschirm anzeigen',
    'pref_home_show_deposits_info'              => 'Der Startbildschirm zeigt schon Ihre Ausgabekonten an. Sollen zusätzlich Ihre Einnahmekonten angezeigt werden?',
    'pref_home_do_show_deposits'                => 'Ja, zeige sie an',
    'successful_count'                          => 'davon :count erfolgreich',
    'list_page_size_title'                      => 'Einträge pro Seite',
    'list_page_size_help'                       => 'Jede Liste von Elementen (Konten, Buchungen, usw.) zeigt höchstens so viele Elemente je Seite.',
    'list_page_size_label'                      => 'Einträge pro Seite',
    'between_dates'                             => '(:start und :end)',
    'pref_optional_fields_transaction'          => 'Optionale Felder für Buchungen',
    'pref_optional_fields_transaction_help'     => 'Wenn Sie eine Buchung anlegen sind standardmäßig nicht alle vorhandenen Felder aktiviert. Hier können Sie alle Felder aktivieren, die Sie gerne nutzen möchten. Alle Felder die deaktiviert sind, aber bereits ausgefüllt sind, werden unabhängig von ihren Einstellungen sichtbar sein.',
    'optional_tj_date_fields'                   => 'Datumsfelder',
    'optional_tj_other_fields'                  => 'Andere Felder',
    'optional_tj_attachment_fields'             => 'Anlage Felder',
    'pref_optional_tj_interest_date'            => 'Zinstermin',
    'pref_optional_tj_book_date'                => 'Buchungsdatum',
    'pref_optional_tj_process_date'             => 'Wertstellungsdatum',
    'pref_optional_tj_due_date'                 => 'Fälligkeitstermin',
    'pref_optional_tj_payment_date'             => 'Zahlungsdatum',
    'pref_optional_tj_invoice_date'             => 'Rechnungsdatum',
    'pref_optional_tj_internal_reference'       => 'Interne Referenz',
    'pref_optional_tj_notes'                    => 'Notizen',
    'pref_optional_tj_attachments'              => 'Anhänge',
    'pref_optional_tj_external_url'             => 'Externe URL',
    'pref_optional_tj_location'                 => 'Herkunft',
    'pref_optional_tj_links'                    => 'Buchungsverknüpfungen',
    'optional_field_meta_dates'                 => 'Daten',
    'optional_field_meta_business'              => 'Geschäftlich',
    'optional_field_attachments'                => 'Anhänge',
    'optional_field_meta_data'                  => 'Optionale Metadaten',
    'external_url'                              => 'Externe URL',
    'pref_notification_login_failure'           => 'Anmeldung fehlgeschlagen',
    'pref_notification_bill_reminder'           => 'Erinnerung an fällige Abonnements',
    'pref_notification_new_access_token'        => 'Warnen, wenn ein neues API-Zugangs-Token erstellt wird',
    'pref_notification_transaction_creation'    => 'Warnen, wenn eine Buchung automatisch erstellt wird',
    'pref_notification_user_login'              => 'Warnen, wenn Sie sich von einem neuen Standort aus anmelden',
    'pref_notification_rule_action_failures'    => 'Warnen, wenn Regelaktionen nicht ausgeführt werden können (nicht als E-Mail)',
    'pref_notification_new_password'            => 'Ihr Passwort wurde geändert',
    'pref_notification_enabled_mfa'             => 'Multi-Faktor-Authentifizierung ist aktiviert',
    'pref_notification_disabled_mfa'            => 'Multi-Faktor-Authentifizierung ist deaktiviert',
    'pref_notification_few_left_mfa'            => 'Es sind nur noch ein wenige Sicherungscodes vorhanden',
    'pref_notification_no_left_mfa'             => 'Es sind keine Sicherheitscodes mehr vorhanden',
    'pref_notification_many_failed_mfa'         => 'Die Prüfung der Mehrfaktor-Authentifizierung schlägt immer wieder fehl',
    'pref_notification_new_backup_codes'        => 'Es wurden neue Sicherungscodes generiert',
    'pref_notifications'                        => 'Benachrichtigungen',
    'pref_notifications_help'                   => 'Geben Sie an, ob Sie diese Mitteilungen erhalten möchten. Einige Mitteilungen können sensible Finanzinformationen enthalten.',
    'pref_notifications_settings'               => 'Benachrichtigungseinstellungen',
    'pref_notifications_settings_help'          => 'Verwenden Sie diese Einstellungen, um Ihre Benachrichtigungskanäle zu konfigurieren. Bitte beachten Sie, dass die Benachrichtigungen an ALLE Kanäle gesendet werden. Bitte speichern Sie ERST Ihre Einstellungen.',
    'slack_url_label'                           => 'Slack "eingehender Webhook" URL',
    'discord_url_label'                         => 'Discord-Webhook-URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Wechselkurse',
    'header_exchange_rates'                     => 'Wechselkurse',
    'exchange_rates_intro'                      => 'Firefly III unterstützt das Herunterladen und Verwenden von Wechselkursen. Lesen Sie mehr darüber in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/"> der Dokumentation</a>.',
    'exchange_rates_from_to'                    => 'Zwischen {from} und {to} (und umgekehrt)',
    'header_exchange_rates_rates'               => 'Wechselkurse',
    'exchange_rates_intro_rates'                => 'Firefly III verwendet die folgenden Wechselkurse. Der Kehrwert wird automatisch berechnet, wenn er nicht angegeben wurde. Wenn für das Datum der Transaktion kein Wechselkurs vorhanden ist, sucht Firefly III in der Vergangenheit nach einem Kurs. Wenn keine vorhanden sind, wird der Kurs „1“ verwendet.',
    'header_exchange_rates_table'               => 'Tabelle mit Wechselkursen',
    'help_rate_form'                            => 'An diesem Tag, wie viel {to} werden Sie für {from} bekommen?',
    'save_new_rate'                             => 'Neuen Kurs speichern',
    'add_new_rate'                              => 'Neuen Wechselkurs hinzufügen',
    'not_enough_currencies'                     => 'Nicht genügend Währungen',
    'not_enough_currencies_enabled'             => 'Wenn Sie nur eine Währung aktiviert haben, ist es nicht erforderlich, Wechselkurse hinzuzufügen.',

    // Financial administrations
    'administration_index'                      => 'Finanzverwaltung',
    'administrations_breadcrumb'                => 'Finanzverwaltungen',
    'administrations_page_title'                => 'Finanzverwaltungen',
    'administrations_index_menu'                => 'Finanzverwaltung',
    'administrations_page_sub_title'            => 'Übersicht',
    'create_administration'                     => 'Neue Verwaltung anlegen',
    'administration_owner'                      => 'Verwaltungseigentümer: {{email}}',
    'administration_you'                        => 'Ihre Funktion: {{role}}',
    'other_users_in_admin'                      => 'Andere Benutzer in dieser Verwaltung',
    'administrations_create_breadcrumb'         => 'Neue Finanzverwaltung erstellen',
    'administrations_page_create_sub_title'     => 'Neue Finanzverwaltung erstellen',
    'basic_administration_information'          => 'Allgemeine Verwaltungsinformationen',
    'new_administration_created'                => 'Neue Finanzverwaltung „{{title}}” wurde erstellt',
    'edit_administration_breadcrumb'            => 'Finanzverwaltung „:title” bearbeiten',
    'administrations_page_edit_sub_title'       => 'Finanzverwaltung „:title” bearbeiten',
    'administrations_page_edit_sub_title_js'    => 'Finanzverwaltung „{title}“ bearbeiten',
    'temp_administrations_introduction'         => 'Firefly III erhält in Kürze die Möglichkeit, mehrere Finanzverwaltungen zu verwalten. Derzeit ist nur eine einzige verfügbar. Sie können den Titel dieser Verwaltung und ihre Landeswährung festlegen. Dies ersetzt die bisherige Einstellung, bei der Sie Ihre „Standardwährung“ festlegen mussten. Diese Einstellung ist nun an die Finanzverwaltung gebunden und kann je nach Verwaltung unterschiedlich sein.',
    'temp_administrations_introduction_edit'    => 'Derzeit können Sie nur die „Landeswährung“ der Standard-Finanzverwaltung festlegen. Diese ersetzt die Einstellung „Standardwährung“. Diese Einstellung ist nun an die Finanzverwaltung gebunden und kann je nach Verwaltung unterschiedlich sein.',
    'administration_currency_form_help'         => 'Das Laden der Seite kann lange dauern, wenn Sie die Hauptwährung ändern, da Buchungen möglicherweise in Ihre (neue) Hauptwährung umgerechnet werden müssen.',
    'flash_administration_updated'              => 'Die Verwaltung „:title“ wurde aktualisiert',
    'flash_administration_created'              => 'Die Verwaltung „:title“ wurde erstellt',
    'flash_administration_deleted'              => 'Die Verwaltung „:title“ wurde gelöscht',

    // roles
    'administration_role_owner'                 => 'Inhaber',
    'administration_role_ro'                    => 'Schreibgeschützt',
    'administration_role_mng_trx'               => 'Buchungen verwalten',
    'administration_role_mng_meta'              => 'Klassifizierungs- und Metadaten verwalten',
    'administration_role_mng_budgets'           => 'Budgets verwalten',
    'administration_role_mng_piggies'           => 'Sparschweine verwalten',
    'administration_role_mng_subscriptions'     => 'Abonnements verwalten',
    'administration_role_mng_rules'             => 'Regeln verwalten',
    'administration_role_mng_recurring'         => 'Daueraufträge verwalten',
    'administration_role_mng_webhooks'          => 'Webhooks verwalten',
    'administration_role_mng_currencies'        => 'Währungen verwalten',
    'administration_role_view_reports'          => 'Berichte anzeigen',
    'administration_role_full'                  => 'Vollständiger Zugriff',

    // mfa
    'enable_mfa'                                => 'Multifaktor-Authentifizierung aktivieren',
    'mfa_index_title'                           => 'Multifaktor-Authentifizierung',
    'mfa_index_intro'                           => 'Firefly III unterstützt Multifaktor-Authentifizierung (MFA). Sie können MFA für Ihr Konto aktivieren, um eine zusätzliche Sicherheitsebene zu schaffen. Anwendungen wie Authy, Google Authenticator und FreeOTP können verwendet werden, um die Codes zu generieren, die Sie zum Anmelden benötigen. Sicherheitsschlüssel werden von Firefly III nicht unterstützt, aber Sie können einen Sicherheitsschlüssel als Speichermedium für Ihr MFA-Geheimnis verwenden.',
    'mfa_index_enabled'                         => 'Die Multifaktor-Authentifizierung ist für Ihr Konto aktiviert.',
    'mfa_index_disabled'                        => 'Die Multifaktor-Authentifizierung ist für Ihr Konto nicht aktiviert.',
    'mfa_index_owner'                           => 'Der Besitzer dieser Instanz kann jederzeit die Multifaktor-Authentifizierung für Ihr Konto deaktivieren.',
    'current_password_confirm_mfa'              => 'Aktuelles Passwort eingeben',
    'mfa_warning_code_changes'                  => 'Möglicherweise wird ein MFA-Dialog angezeigt, nachdem Sie Ihr Passwort und einen MFA-Code eingegeben haben. In diesem Fall warten Sie bitte, bis Ihre Anwendung einen neuen MFA-Code generiert, und verwenden Sie nicht den, den Sie gerade verwendet haben.',
    'mfa_already_disabled'                      => 'Die Multifaktor-Authentifizierung ist nicht aktiviert, Sie kann also nicht deaktiviert werden.',
    'disable_mfa_page'                          => 'Multifaktor-Authentifizierung deaktivieren',
    'disable_mfa_intro'                         => 'Sie können die Multifaktor-Authentifizierung deaktivieren. Geben Sie dazu bitte Ihr Passwort und einen Code für die Multifaktor-Authentifizierung ein. Wenn Sie die Multifaktor-Authentifizierung deaktivieren möchten, weil Sie den Zugang zu Ihrem Code-Generator verloren haben, <a href=„https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working“>beziehen Sie sich bitte stattdessen auf die Dokumentation</a>.',
    'pref_disable_mfa'                          => 'Multifaktor-Authentifizierung deaktivieren',
    'mfa_not_enabled'                           => 'Die Multifaktor-Authentifizierung ist nicht aktiviert.',
    'mfa_backup_codes_intro'                    => 'Firefly III kann Wiederherstellungs-Codes für Sie generieren. Diese Codes können zum Anmelden verwendet werden, wenn Sie Ihren Codegenerator nicht verwenden können. Sie können jederzeit einen neuen Satz von Codes erzeugen. Wenn Sie einen neuen Satz erzeugen, wird der alte Satz ungültig.',
    'mfa_backup_codes_quick'                    => 'Wenn Sie sehr schnell von der Einrichtungsseite der Multifaktor-Authentifizierung kommen, hat Ihre App möglicherweise noch keinen neuen Code generiert. Bitte beachten Sie, dass MFA-Codes nur einmal verwendet werden können. Stellen Sie sicher, dass Sie einen anderen Code als den vorherigen verwenden.',
    'mfa_backup_codes_title'                    => 'Wiederherstellungscodes für die Multifaktor-Authentifizierung',
    'mfa_backup_codes_post_title'               => 'Wiederherstellungscodes für die Multifaktor-Authentifizierung',

    // profile:
    'manage_mfa_settings'                       => 'Einstellungen für die Multifaktor-Authentifizierung verwalten',
    'purge_data_title'                          => 'Daten aus Firefly III vernichten',
    'purge_data_expl'                           => '„Endgültiges Löschen” bedeutet „Löschen, was bereits gelöscht wurde”. Unter normalen Umständen löscht Firefly III nichts dauerhaft. Es verbirgt es nur. Die Schaltfläche unten löscht alle diese zuvor "gelöschten" Datensätze DAUERHAFT.',
    'delete_stuff_header'                       => 'Daten löschen und vernichten',
    'purge_all_data'                            => 'Alle gelöschten Datensätze vernichten',
    'purge_data'                                => 'Daten vernichten',
    'purged_all_records'                        => 'Alle gelöschten Datensätze wurden vernichtet.',
    'delete_data_title'                         => 'Daten aus Firefly III löschen',
    'permanent_delete_stuff'                    => 'Sie können Dinge aus Firefly III löschen. Mit den Buttons unten werden Ihre Gegenstände entfernt und ausgeblendet. Es keine Möglichkeit dies rückgängig zu machen, aber die Elemente können in der Datenbank verbleiben, wo sie gegebenenfalls wiederhergestellt werden können.',
    'other_sessions_logged_out'                 => 'Alle Ihre anderen Sitzungen wurden abgemeldet.',
    'delete_unused_accounts'                    => 'Durch das Löschen ungenutzter Konten werden Ihre Listen für die automatische Vervollständigung bereinigt.',
    'delete_all_unused_accounts'                => 'Unbenutzte Konten löschen',
    'deleted_all_unused_accounts'               => 'Alle ungenutzten Konten wurden gelöscht',
    'delete_all_budgets'                        => 'ALLE Ihre Budgets löschen',
    'delete_all_categories'                     => 'Alle Ihre Kategorien löschen',
    'delete_all_tags'                           => 'Alle Ihre Stichwörter löschen',
    'delete_all_bills'                          => 'ALLE Abonnements löschen',
    'delete_all_piggy_banks'                    => 'ALLE Ihre Sparschweine löschen',
    'delete_all_rules'                          => 'ALLE Ihre Regeln löschen',
    'delete_all_recurring'                      => 'ALLE Daueraufträge löschen',
    'delete_all_object_groups'                  => 'ALLE Objektgruppen löschen',
    'delete_all_accounts'                       => 'ALLE Konten löschen',
    'delete_all_asset_accounts'                 => 'ALLE Bestandskonten löschen',
    'delete_all_expense_accounts'               => 'ALLE Ausgabekonten löschen',
    'delete_all_revenue_accounts'               => 'ALLE Einnahmekonten löschen',
    'delete_all_liabilities'                    => 'ALLE Verbindlichkeiten löschen',
    'delete_all_transactions'                   => 'ALLE Buchungen löschen',
    'delete_all_withdrawals'                    => 'ALLE Ausgaben löschen',
    'delete_all_deposits'                       => 'ALLE Einnahmen löschen',
    'delete_all_transfers'                      => 'ALLE Umbuchungen löschen',
    'also_delete_transactions'                  => 'Beim Löschen von Konten werden auch ALLE damit verbundenen Ausgaben, Einnahmen und Überweisungen gelöscht!',
    'deleted_all_budgets'                       => 'Alle Budgets wurden gelöscht',
    'deleted_all_categories'                    => 'Alle Kategorien wurden gelöscht',
    'deleted_all_tags'                          => 'Alle Schlagwörter wurden gelöscht',
    'deleted_all_bills'                         => 'Alle Abonnements wurden gelöscht',
    'deleted_all_piggy_banks'                   => 'Alle Sparschweine wurden gelöscht',
    'deleted_all_rules'                         => 'Alle Regeln und Regelgruppen wurden gelöscht',
    'deleted_all_object_groups'                 => 'Alle Gruppen wurden gelöscht',
    'deleted_all_accounts'                      => 'Alle Konten wurden gelöscht',
    'deleted_all_asset_accounts'                => 'Alle Bestandskonten wurden gelöscht',
    'deleted_all_expense_accounts'              => 'Alle Ausgabenkonten wurden gelöscht',
    'deleted_all_revenue_accounts'              => 'Alle Einnahmenkonten wurden gelöscht',
    'deleted_all_liabilities'                   => 'Alle Verbindlichkeiten wurden gelöscht',
    'deleted_all_transactions'                  => 'Alle Buchungen wurden gelöscht',
    'deleted_all_withdrawals'                   => 'Alle Ausgaben wurden gelöscht',
    'deleted_all_deposits'                      => 'Alle Einnahmen wurden gelöscht',
    'deleted_all_transfers'                     => 'Alle Umbuchungen wurden gelöscht',
    'deleted_all_recurring'                     => 'Alle Daueraufträge wurden gelöscht',
    'change_your_password'                      => 'Passwort ändern',
    'delete_account'                            => 'Konto löschen',
    'current_password'                          => 'Aktuelles Passwort',
    'new_password'                              => 'Neues Passwort',
    'new_password_again'                        => 'Neues Passwort (wiederholen)',
    'delete_your_account'                       => 'Ihren Account löschen',
    'delete_your_account_help'                  => 'Das Löschen ihres Benutzerkontos wird ebenfalls alle Konten, Buchungen, etc., also <em>alles</em> was Sie in Firefly gespeichert haben, löschen. Alles geht verloren und kann nicht wiederhergestellt werden.',
    'delete_your_account_password'              => 'Geben Sie Ihr Kennwort ein um fortzufahren.',
    'password'                                  => 'Passwort',
    'are_you_sure'                              => 'Sind Sie sich sicher? Sie können diesen Schritt nicht rückgängig machen.',
    'are_you_sure_confirm'                      => 'Sind Sie sicher?',
    'delete_account_button'                     => 'LÖSCHEN Sie ihr Benutzerkonto',
    'invalid_current_password'                  => 'Aktuelles Passwort ist ungültig!',
    'password_changed'                          => 'Passwort geändert!',
    'should_change'                             => 'Ziel ist es, ihr Passwort zu ändern.',
    'invalid_password'                          => 'Ungültiges Passwort!',
    'what_is_pw_security'                       => 'Was ist "Passwortsicherheit überprüfen"?',
    'secure_pw_title'                           => 'So wählen Sie ein sicheres Passwort aus',
    'forgot_password_response'                  => 'Vielen Dank. Falls ein Account mit dieser E-Mail-Adresse existiert, finden Sie im Posteingang weitere Anweisungen.',
    'secure_pw_history'                         => 'Keine Woche vergeht, dass Sie in den Nachrichten über eine Website lesen, die die Passwörter ihrer Benutzer verliert. Hacker und Diebe verwenden diese Passwörter, um zu versuchen, Ihre persönlichen Daten zu stehlen. Diese Informationen sind wertvoll.',
    'secure_pw_ff'                              => 'Verwenden Sie im gesamten Internet das gleiche Passwort? Wenn eine Website Ihr Passwort verliert, haben Hacker Zugriff auf alle Ihre Daten. Firefly III verlässt sich darauf, dass Sie ein sicheres und einzigartiges Passwort wählen, um Ihre Finanzdaten zu schützen.',
    'secure_pw_check_box'                       => 'Um Ihnen dabei zu helfen, kann Firefly III überprüfen, ob das von Ihnen gewünschte Passwort in der Vergangenheit gestohlen wurde. Wenn dies der Fall ist, rät Firefly III Ihnen, dieses Passwort NICHT zu verwenden.',
    'secure_pw_working_title'                   => 'Wie funktioniert es?',
    'secure_pw_working'                         => 'Wenn Sie das Kontrollkästchen aktivieren, wird Firefly III den SHA1-Hash der ersten 5 Zeichen Ihres Passworts an <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">die Website von Troy Hunt</a> senden, um zu sehen, ob es auf der Liste steht. Dies verhindert, dass Sie unsichere Passwörter verwenden, was in der aktuellen <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST-Sonderveröffentlichung</a> zu diesem Thema empfohlen wird.',
    'secure_pw_should'                          => 'Soll ich die Box ankreuzen?',
    'secure_pw_long_password'                   => 'Ja. Damit vergewissern Sie sich immer, dass ihr Passwort sicher ist.',
    'command_line_token'                        => 'Kommandozeilen-Authentifizierungsschlüssel',
    'explain_command_line_token'                => 'Sie benötigen dieses Token, um Kommandozeilenoptionen auszuführen, wie z. B. den Export von Daten. Ohne diese werden solche sensiblen Befehle nicht funktionieren. Teilen Sie Ihren Kommandozeilen-Authentifizierungsschlüssel nicht mit anderen. Niemand wird Sie um diesen Schlüssel bitten, nicht einmal ich. Wenn Sie befürchten, dass Sie diesen verloren haben, erneuern Sie den Schlüssel mit der Schaltfläche.',
    'regenerate_command_line_token'             => 'Kommandozeilen-Authentifizierungsschlüssel erneut generieren',
    'token_regenerated'                         => 'Ein neuer Kommandozeilen-Authentifizierungsschlüssel wurde generiert',
    'change_your_email'                         => 'E-Mail Adresse ändern',
    'email_verification'                        => 'Eine Nachricht wird an Ihre alte UND Ihre neue E-Mail-Adresse gesendet. Aus Sicherheitsgründen können Sie sich erst anmelden, wenn Sie Ihre neue E-Mail-Adresse verifiziert haben. Wenn Sie nicht sicher sind, ob Ihre Firefly III-Installation in der Lage ist, E-Mails zu versenden, verwenden Sie diese Funktion bitte nicht. Wenn Sie ein Administrator sind, können Sie dies in den <a href=" settings">Einstellungen</a> testen.',
    'email_changed_logout'                      => 'Sie müssen Ihre E-Mail-Adresse bestätigen, um sich anmelden zu können.',
    'login_with_new_email'                      => 'Sie können sich jetzt mit Ihrer neuen E-Mail-Adresse anmelden.',
    'login_with_old_email'                      => 'Sie können sich jetzt wieder mit Ihrer alten E-Mail-Adresse anmelden.',
    'login_provider_local_only'                 => 'Diese Aktion ist bei der Authentifizierung durch ":login_provider" nicht verfügbar.',
    'external_user_mgt_disabled'                => 'Diese Aktion ist nicht verfügbar, wenn Firefly III nicht für die Benutzerverwaltung oder die Authentifizierungsbehandlung zuständig ist.',
    'external_auth_disabled'                    => 'Diese Aktion ist nicht verfügbar, wenn Firefly III nicht für die Bearbeitung der Authentifizierung zuständig ist.',
    'delete_local_info_only'                    => "Da Firefly III nicht für die Benutzerverwaltung oder die Authentifizierungsbehandlung zuständig ist, löscht diese Funktion nur lokale Firefly III-Informationen.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth-Clients',
    'profile_oauth_no_clients'                  => 'Sie haben noch keine OAuth-Clients erstellt.',
    'profile_oauth_clients_external_auth'       => 'Wenn Sie einen externen Authentifizierungsanbieter wie Authelia verwenden, funktionieren OAuth Clients nicht. Sie können ausschließlich persönliche Zugriffstoken verwenden.',
    'profile_oauth_clients_header'              => 'Clients',
    'profile_oauth_client_id'                   => 'Client-ID',
    'profile_oauth_client_name'                 => 'Name',
    'profile_oauth_client_secret'               => 'Geheimnis',
    'profile_oauth_create_new_client'           => 'Neuen Client erstellen',
    'profile_oauth_create_client'               => 'Client erstellen',
    'profile_oauth_edit_client'                 => 'Client bearbeiten',
    'profile_oauth_name_help'                   => 'Etwas das Ihre Nutzer erkennen und dem sie vertrauen.',
    'profile_oauth_redirect_url'                => 'Weiterleitungs-URL',
    'profile_oauth_redirect_url_help'           => 'Die Authorisierungs-Callback-URL Ihrer Anwendung.',
    'profile_authorized_apps'                   => 'Autorisierte Anwendungen',
    'profile_authorized_clients'                => 'Autorisierte Clients',
    'profile_scopes'                            => 'Bereiche',
    'profile_revoke'                            => 'Widerrufen',
    'profile_oauth_client_secret_title'         => 'Client Secret',
    'profile_oauth_client_secret_expl'          => 'Hier ist Ihr neuer persönlicher Zugangsschlüssel. Dies ist das einzige Mal, dass er angezeigt wird, also verlieren Sie ihn nicht! Sie können diesen Token jetzt verwenden, um API-Anfragen zu stellen.',
    'profile_personal_access_tokens'            => 'Persönliche Zugangs-Tokens',
    'profile_personal_access_token'             => 'Persönlicher Zugangs-Token',
    'profile_oauth_confidential'                => 'Vertraulich',
    'profile_oauth_confidential_help'           => 'Verlangen Sie vom Client, sich mit einem Geheimnis zu authentifizieren. Vertrauliche Clients können Anmeldedaten auf sichere Weise speichern, ohne sie Unbefugten zugänglich zu machen. Öffentliche Anwendungen, wie native Desktop- oder JavaScript-SPA-Anwendungen, sind nicht fähig, Geheimnisse sicher zu speichern.',
    'profile_personal_access_token_explanation' => 'Hier ist Ihr neuer persönlicher Zugangsschlüssel. Dies ist das einzige Mal, dass er angezeigt wird, also verlieren Sie ihn nicht! Sie können diesen Token jetzt verwenden, um API-Anfragen zu stellen.',
    'profile_no_personal_access_token'          => 'Sie haben keine persönlichen Zugangsschlüssel erstellt.',
    'profile_create_new_token'                  => 'Neuen Schlüssel erstellen',
    'profile_create_token'                      => 'Schlüssel erstellen',
    'profile_create'                            => 'Erstellen',
    'profile_save_changes'                      => 'Änderungen speichern',
    'profile_whoops'                            => 'Huch!',
    'profile_something_wrong'                   => 'Ein Problem ist aufgetreten!',
    'profile_try_again'                         => 'Ein Problem ist aufgetreten. Bitte versuchen Sie es erneut.',
    'amounts'                                   => 'Beträge',
    'multi_account_warning_unknown'             => 'Abhängig von der Art der Buchung, die Sie anlegen, kann das Quell- und/oder Zielkonto nachfolgender Aufteilungen durch das überschrieben werden, was in der ersten Aufteilung der Buchung definiert wurde.',
    'multi_account_warning_withdrawal'          => 'Bedenken Sie, dass das Quellkonto nachfolgender Aufteilungen von dem, was in der ersten Aufteilung der Abhebung definiert ist, außer Kraft gesetzt wird.',
    'multi_account_warning_deposit'             => 'Bedenken Sie, dass das Zielkonto nachfolgender Aufteilungen von dem, was in der ersten Aufteilung der Einnahmen definiert ist, außer Kraft gesetzt wird.',
    'multi_account_warning_transfer'            => 'Bedenken Sie, dass das Quell- und Zielkonto nachfolgender Aufteilungen durch das, was in der ersten Aufteilung der Übertragung definiert ist, außer Kraft gesetzt wird.',


    // export data:
    'export_data_title'                         => 'Daten aus Firefly III exportieren',
    'export_data_menu'                          => 'Daten exportieren',
    'export_data_bc'                            => 'Daten aus Firefly III exportieren',
    'export_data_main_title'                    => 'Daten aus Firefly III exportieren',
    'export_data_expl'                          => 'Dieser Link ermöglicht es Ihnen, alle Transaktionen und deren Metadaten aus Firefly III zu exportieren. Weitere Informationen zur Vorgehensweise entnehmen Sie bitte der Hilfe (oben rechts das (?)-Symbol).',
    'export_data_all_transactions'              => 'Alle Buchungen exportieren',
    'export_data_advanced_expl'                 => 'Wenn Sie eine erweiterte oder spezifische Art des Exports benötigen, lesen Sie die Hilfe zur Verwendung des Konsolenbefehls <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Ein Anhang |:count Anhänge',
    'attachments'                               => 'Anhänge',
    'edit_attachment'                           => 'Anhang „:name” bearbeiten',
    'update_attachment'                         => 'Anhang aktualisieren',
    'delete_attachment'                         => 'Anhang „:name” löschen',
    'attachment_deleted'                        => 'Anhang „:name” gelöscht',
    'liabilities_deleted'                       => 'Verbindlichkeit „:name” gelöscht',
    'attachment_updated'                        => 'Anhang „:name” aktualisiert',
    'upload_max_file_size'                      => 'Maximale Dateigröße: :size',
    'list_all_attachments'                      => 'Liste aller Anhänge',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Da diese Buchung abgestimmt ist, können Sie weder die Konten noch den/die Betrag/Beträge aktualisieren, es sei denn, Sie entfernen das Abstimmungskennzeichen.',
    'is_reconciled'                             => 'Ist abgestimmt',
    'title_expenses'                            => 'Ausgaben',
    'title_withdrawal'                          => 'Ausgaben',
    'title_revenue'                             => 'Einnahmen / Einkommen',
    'title_deposit'                             => 'Einnahmen / Einkommen',
    'title_transfer'                            => 'Umbuchungen',
    'title_transfers'                           => 'Umbuchungen',
    'submission_options'                        => 'Übermittlungsoptionen',
    'apply_rules_checkbox'                      => 'Regeln anwenden',
    'fire_webhooks_checkbox'                    => 'Webhooks abfeuern',
    'select_source_account'                     => 'Bitte einen gültigen Quellkontonamen auswählen oder eingeben',
    'select_dest_account'                       => 'Bitte einen gültigen Zielkontonamen auswählen oder eingeben',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Diese Buchung ist bereits eine Ausgabe',
    'convert_is_already_type_Deposit'           => 'Diese Buchung ist bereits eine Einnahme',
    'convert_is_already_type_Transfer'          => 'Diese Buchung ist bereits eine Umbuchung',
    'convert_to_Withdrawal'                     => '":description" zu einer Ausgabe konvertieren',
    'convert_to_Deposit'                        => '":description" zu einer Einnahme konvertieren',
    'convert_to_Transfer'                       => '":description" zu einer Umbuchung konvertieren',
    'convert_options_WithdrawalDeposit'         => 'Konvertieren Sie eine Ausgabe in eine Einnahme',
    'convert_options_WithdrawalTransfer'        => 'Konvertieren Sie eine Ausgabe in eine Umbuchung',
    'convert_options_DepositTransfer'           => 'Konvertieren Sie eine Einnahme in eine Umbuchung',
    'convert_options_DepositWithdrawal'         => 'Konvertieren Sie eine Einnahme in eine Ausgabe',
    'convert_options_TransferWithdrawal'        => 'Konvertieren Sie eine Umbuchung in eine Ausgabe',
    'convert_options_TransferDeposit'           => 'Konvertieren Sie eine Umbuchung in eine Einnahme',
    'convert_Withdrawal_to_deposit'             => 'Konvertieren Sie diese Ausgabe zu einer Einnahme',
    'convert_Withdrawal_to_transfer'            => 'Konvertieren Sie diese Ausgabe in eine Umbuchung',
    'convert_Deposit_to_withdrawal'             => 'Konvertieren Sie diese Einnahme zu einer Ausgabe',
    'convert_Deposit_to_transfer'               => 'Konvertieren Sie diese Einnahme in eine Umbuchung',
    'convert_Transfer_to_deposit'               => 'Konvertieren Sie diese Umbuchung in eine Einnahme',
    'convert_Transfer_to_withdrawal'            => 'Konvertieren Sie diese Umbuchung in eine Ausgabe',
    'convert_please_set_revenue_source'         => 'Bitte das Einnahmenkonto wählen, von welchem das Geld kommen wird.',
    'convert_please_set_asset_destination'      => 'Bitte wählen Sie das Bestandskonto, auf das das Geld überwiesen werden soll.',
    'convert_please_set_expense_destination'    => 'Bitte wählen Sie das Ausgabenkonto, an das das Geld gehen soll.',
    'convert_please_set_asset_source'           => 'Bitte das Bestandskonto wählen, von dem das Geld kommt.',
    'convert_expl_w_d'                          => 'Bei der Umwandlung von einer Ausgabe in eine Einnahme wird das Geld auf das angezeigte Zielkonto eingezahlt, anstatt davon abgebucht zu werden.|Bei der Umwandlung von einer Ausgabe in eine Einnahme wird das Geld auf die angezeigten Zielkonten eingezahlt, anstatt von diesem abgebucht zu werden.',
    'convert_expl_w_t'                          => 'Bei der Umwandlung einer Ausgabe in eine Überweisung wird das Geld vom Quellkonto auf ein anderes Vermögens- oder Verbindlichkeitskonto überwiesen, anstatt auf das ursprüngliche Ausgabenkonto gebucht zu werden.|Bei der Umwandlung einer Ausgabe in eine Überweisung, wird das Geld von den Quellkonten auf andere Vermögens- oder Verbindlichkeitskonten überwiesen, anstatt auf die ursprünglichen Ausgabenkonten gebucht zu werden.',
    'convert_expl_d_w'                          => 'Wenn eine Einnahme in eine Ausgabe umgewandelt wird, wird das Geld von den angezeigten Quellkonten abgehoben, anstatt auf diese eingezahlt zu werden.|Wenn eine Einnahme in eine Ausgabe umgewandelt wird, wird das Geld von den angezeigten Quellkonten abgehoben, anstatt auf diese eingezahlt zu werden.',
    'convert_expl_d_t'                          => 'Wenn Sie eine Einnahme in einen Ümbuchung umwandeln, wird das Geld von einem Ihrer Aktiv- oder Passivkonten auf das aufgelistete Zielkonto eingezahlt.| Wenn Sie eine Einnahme in einen Umbuchung umwandeln, wird das Geld von einem Ihrer Aktiv- oder Passivkonten auf das aufgelistete Zielkonto eingezahlt.',
    'convert_expl_t_w'                          => 'Wenn Sie eine Überweisung in eine Abhebung umwandeln, wird das Geld auf dem hier angegebenen Zielkonto ausgegeben, anstatt überwiesen zu werden.| Wenn Sie eine Überweisung in eine Abhebung umwandeln, wird das Geld auf dem hier angegebenen Zielkonto ausgegeben, anstatt überwiesen zu werden.',
    'convert_expl_t_d'                          => 'Wenn Sie eine Umbuchung in eine Einnahme umwandeln, wird das Geld auf das hier angegebene Zielkonto eingezahlt und nicht auf dieses überwiesen.| Wenn Sie eine Umbuchung in eine Einnahme umwandeln, wird das Geld auf das hier angegebene Zielkonto eingezahlt und nicht auf dieses überwiesen.',
    'convert_select_sources'                    => 'Um die Umwandlung abzuschließen, wählen Sie bitte unten das neue Quellkonto aus.|Um die Umwandlung abzuschließen, wählen Sie bitte die neuen Quellkonten aus.',
    'convert_select_destinations'               => 'Um die Umwandlung abzuschließen, wählen Sie bitte unten das neue Zielkonto aus.|Um die Umwandlung abzuschließen, wählen Sie bitte die neuen Zielkonten aus.',
    'converted_to_Withdrawal'                   => 'Die Buchung wurde in eine Ausgabe konvertiert',
    'converted_to_Deposit'                      => 'Die Buchung wurde in eine Einnahme konvertiert',
    'converted_to_Transfer'                     => 'Die Buchung wurde in eine Umbuchung konvertiert',
    'invalid_convert_selection'                 => 'Das von Ihnen ausgewählte Konto wird für diese Buchung bereits verwendet oder ist nicht vorhanden.',
    'source_or_dest_invalid'                    => 'Die korrekten Buchungsdetails konnten nicht gefunden werden. Eine Konvertierung ist nicht möglich.',
    'convert_to_withdrawal'                     => 'In eine Ausgabe umwandeln',
    'convert_to_deposit'                        => 'In eine Einnahme umwandeln',
    'convert_to_transfer'                       => 'In eine Umbuchung umwandeln',

    // create new stuff:
    'create_new_withdrawal'                     => 'Neue Ausgabe erstellen',
    'create_new_deposit'                        => 'Neue Einnahme erstellen',
    'create_new_transfer'                       => 'Neue Umbuchung erstellen',
    'create_new_asset'                          => 'Neues Bestandskonto erstellen',
    'create_new_liabilities'                    => 'Neue Verbindlichkeit anlegen',
    'create_new_expense'                        => 'Neues Ausgabenkonto erstellen',
    'create_new_revenue'                        => 'Neues Einnahmenkonto erstellen',
    'create_new_piggy_bank'                     => 'Ein neues Sparschwein erstellen',
    'create_new_bill'                           => 'Neues Abonnement erstellen',
    'create_new_subscription'                   => 'Neues Abonnement erstellen',
    'create_new_rule'                           => 'Neue Regel erstellen',

    // currencies:
    'create_currency'                           => 'Eine neue Währung erstellen',
    'store_currency'                            => 'Neue Währung speichern',
    'update_currency'                           => 'Währung aktualisieren',
    'new_default_currency'                      => '„:name” ist jetzt die Standardwährung.',
    'default_currency_failed'                   => '„:name” konnte nicht als Standardwährung festgelegt werden. Bitte prüfen Sie die Protokolle.',
    'cannot_delete_currency'                    => '„:name” konnte nicht gelöscht werden, da diese noch verwendet wird.',
    'cannot_delete_fallback_currency'           => ':name ist die Standardwährung des Systems und kann daher nicht gelöscht werden.',
    'cannot_disable_currency_journals'          => '„:name” konnte nicht deaktiviert werden, da dieser noch von Buchungen verwendet wird.',
    'cannot_disable_currency_last_left'         => '„:name” kann nicht deaktiviert werden, da es sich um die einzige aktivierte Währung handelt.',
    'cannot_disable_currency_account_meta'      => ':name konnte nicht deaktiviert werden, da dieser noch in Bestandskonten verwendet wird.',
    'cannot_disable_currency_bills'             => ':name konnte nicht deaktiviert werden, da es in Abonnements verwendet wird.',
    'cannot_disable_currency_recurring'         => '„:name” kann nicht deaktiviert werden, da dieser noch bei Daueraufträgen verwendet wird.',
    'cannot_disable_currency_available_budgets' => '„:name” kann nicht deaktiviert werden, da dieser noch in verfügbaren Kostenrahmen verwendet wird.',
    'cannot_disable_currency_budget_limits'     => '„:name” konnte nicht deaktiviert werden, da dieser noch in Kostenrahmenbeschränkungen verwendet wird.',
    'cannot_disable_currency_current_default'   => '„:name” konnte nicht deaktiviert werden, da es sich um die aktuelle Standardwährung handelt.',
    'cannot_disable_currency_system_fallback'   => '„:name” konnte nicht deaktiviert werden, da es sich um die Standardwährung des Systems handelt.',
    'disable_EUR_side_effects'                  => 'Der Euro ist die Notfall-Rückfallwährung des Systems. Die Deaktivierung kann unbeabsichtigte Nebenwirkungen haben und den Verlust Ihrer Garantie zur Folge haben.',
    'deleted_currency'                          => 'Währung :name gelöscht',
    'created_currency'                          => 'Währung :name erstellt',
    'could_not_store_currency'                  => 'Die neue Währung konnte nicht gespeichert werden.',
    'updated_currency'                          => 'Währung :name aktualisiert',
    'ask_site_owner'                            => 'Bitte fragen sie :owner zum Hinzufügen, Entfernen oder Bearbeiten von Währungen.',
    'currencies_intro'                          => 'Firefly III unterstützt verschiedene Währungen, welche hier eingestellt und aktiviert werden können.',
    'currencies_switch_default'                 => 'Sie können die Hauptwährung für Ihre aktuelle Verwaltung auf der Seite „Finanzverwaltung“ ändern.',
    'make_default_currency'                     => 'Als Standard festlegen',
    'default_currency'                          => 'Standard',
    'primary_currency_button'                   => 'Standard',
    'currency_is_disabled'                      => 'Deaktiviert',
    'enable_currency'                           => 'Aktivieren',
    'disable_currency'                          => 'Deaktivieren',
    'currencies_default_disabled'               => 'Die meisten dieser Währungen sind standardmäßig deaktiviert. Um sie zu verwenden, müssen Sie diese zuerst aktivieren.',
    'currency_is_now_enabled'                   => 'Währung „:name” wurde aktiviert',
    'could_not_enable_currency'                 => 'Die Währung „:name” konnte nicht aktiviert werden. Bitte überprüfen Sie die Protokolle.',
    'currency_is_now_disabled'                  => 'Währung „:name” wurde deaktiviert',
    'could_not_disable_currency'                => 'Die Währung „:name” konnte nicht deaktiviert werden. Vielleicht wird sie noch verwendet?',

    // forms:
    'mandatoryFields'                           => 'Pflichtfelder',
    'optionalFields'                            => 'Optionale Felder',
    'options'                                   => 'Einstellungen',

    // budgets:
    'daily_budgets'                             => 'Tagesbudgets',
    'weekly_budgets'                            => 'Wochenbudgets',
    'monthly_budgets'                           => 'Monatsbudgets',
    'quarterly_budgets'                         => 'Quartalsbudgets',
    'half_year_budgets'                         => 'Halbjahresbudgets',
    'yearly_budgets'                            => 'Jahresbudgets',
    'other_budgets'                             => 'Zeitlich befristete Budgets',
    'budget_limit_not_in_range'                 => 'Dieser Betrag gilt von :start to :end:',
    'total_available_budget'                    => 'Verfügbares Gesamtbudget (zwischen :start und :end)',
    'total_available_budget_in_currency'        => 'Verfügbares Gesamtbudget in :currency',
    'see_below'                                 => 'Siehe unten',
    'create_new_budget'                         => 'Neues Budget erstellen',
    'store_new_budget'                          => 'Neues Budget speichern',
    'stored_new_budget'                         => 'Neues Budget „:name” gespeichert',
    'available_between'                         => 'Verfügbar zwischen :start und :end',
    'transactionsWithoutBudget'                 => 'Ausgaben ohne Budget',
    'transactions_no_budget'                    => 'Ausgaben ohne Budget zwischen :start und :end',
    'spent_between'                             => 'Bereits zwischen :start und :end ausgegeben',
    'spent_between_left'                        => ':spent zwischen :start und :end ausgegeben, :left verbleiben.',
    'set_available_amount'                      => 'Verfügbaren Betrag festlegen',
    'update_available_amount'                   => 'Verfügbaren Betrag aktualisieren',
    'ab_basic_modal_explain'                    => 'Verwenden Sie dieses Formular, um anzugeben, wie viel Sie erwarten, dass Sie im angegebenen Zeitraum vorsehen (insgesamt, in :currency) können.',
    'createBudget'                              => 'Neues Budget',
    'invalid_currency'                          => 'Ungültige Währung angegeben',
    'invalid_amount'                            => 'Bitte einen Betrag eingeben',
    'set_ab'                                    => 'Der verfügbare Budgetbetrag wurde festgelegt',
    'updated_ab'                                => 'Der verfügbare Budgetbetrag wurde aktualisiert',
    'deleted_ab'                                => 'Der verfügbare Budgetbetrag wurde gelöscht',
    'deleted_bl'                                => 'Der eingeplante Betrag wurde entfernt',
    'alt_currency_ab_create'                    => 'Verfügbare Budget in einer anderen Währung angeben',
    'bl_create_btn'                             => 'Budget in einer anderen Währung angeben',
    'inactiveBudgets'                           => 'Inaktive Budgets',
    'without_budget_between'                    => 'Buchungen ohne Budget zwischen :start und :end',
    'delete_budget'                             => 'Budget „:name” löschen',
    'deleted_budget'                            => 'Budget „:name” gelöscht',
    'edit_budget'                               => 'Budget „:name” bearbeiten',
    'updated_budget'                            => 'Budget „:name” aktualisiert',
    'update_amount'                             => 'Betrag aktualisieren',
    'update_budget'                             => 'Budget aktualisieren',
    'update_budget_amount_range'                => '(Erwarteten) Verfügbaren Betrag zwischen :start und :end aktualisieren',
    'set_budget_limit_title'                    => 'Eingeplanten Betrag für das Budget :budget zwischen :start und :end festlegen',
    'set_budget_limit'                          => 'Eingeplanten Betrag angeben',
    'budget_period_navigator'                   => 'Zeitraum-Navigator',
    'info_on_available_amount'                  => 'Wieviel ist verfügbar?',
    'available_amount_indication'               => 'Verwenden Sie diese Angaben, um einen Anhaltspunkt darüber zu erhalten, wie hoch Ihr komplettes Budget sein könnte.',
    'suggested'                                 => 'Vorgeschlagen',
    'average_between'                           => 'Durchschnitt zwischen :start und :end',
    'transferred_in'                            => 'Übertragen (eingehend)',
    'transferred_away'                          => 'Übertragen (ausgehend)',
    'auto_budget_none'                          => 'Kein Auto-Budget',
    'auto_budget_reset'                         => 'Festbetrag für jeden Zeitraum festlegen',
    'auto_budget_rollover'                      => 'Betrag pro Zeitraum hinzufügen',
    'auto_budget_adjusted'                      => 'Fügen Sie für jeden Zeitraum einen Betrag hinzu und korrigieren Sie die Mehrausgaben',
    'auto_budget_period_daily'                  => 'Täglich',
    'auto_budget_period_weekly'                 => 'Wöchentlich',
    'auto_budget_period_monthly'                => 'Monatlich',
    'auto_budget_period_quarterly'              => 'Quartalsweise',
    'auto_budget_period_half_year'              => 'Halbjährlich',
    'auto_budget_period_yearly'                 => 'Jährlich',
    'auto_budget_help'                          => 'Mehr über diese Funktion können Sie in der Hilfe nachlesen. Klicken Sie oben rechts auf das ❓-Symbol.',
    'auto_budget_reset_icon'                    => 'Dieses Budget wird regelmäßig festgelegt',
    'auto_budget_rollover_icon'                 => 'Der Budgetbetrag wird regelmäßig erhöht',
    'auto_budget_adjusted_icon'                 => 'Der Budget-Betrag wird regelmäßig erhöht und wird bei Mehrausgaben korrigiert',
    'remove_budgeted_amount'                    => 'Budgetbetrag in :currency entfernen',

    // bills:
    'left_to_pay_active_bills'                  => 'Aktive, erwartete und noch nicht bezahlte Abonnements',
    'left_to_pay_lc'                            => 'Noch zu zahlen',
    'less_than_expected'                        => 'weniger als erwartet',
    'more_than_expected'                        => 'mehr als erwartet',
    'skip_help_text'                            => 'Verwenden Sie das Feld „Überspringen“, um zweimonatliche (Überspringen = 1) oder andere benutzerdefinierte Intervalle zu erstellen.',
    'subscription'                              => 'Abonnement',
    'not_expected_period'                       => 'In diesem Zeitraum nicht erwartet',
    'subscriptions_in_group'                    => 'Abonnements in der Gruppe „{{title}}“',
    'subscr_expected_x_times'                   => 'Die Zahlung von {{amount}} wird in diesem Zeitraum {{times}}-mal erwartet',
    'not_or_not_yet'                            => '(Noch) nicht',
    'visit_bill'                                => 'Abonnement „:name“ in Firefly III aufrufen',
    'visit_bills'                               => 'Abonnements bei Firefly III aufrufen',
    'match_between_amounts'                     => 'Abonnement entspricht Buchungen zwischen :low und :high.',
    'running_again_loss'                        => 'Zuvor mit diesem Abonnement verknüpfte Buchungen können ihre Verknüpfung verlieren, wenn sie nicht (mehr) der/den Regel(n) entsprechen.',
    'bill_related_rules'                        => 'Regeln in Bezug auf dieses Abonnement',
    'repeats'                                   => 'Wiederholungen',
    'bill_end_date_help'                        => 'Optionales Feld. Das Abonnement wird voraussichtlich an diesem Datum enden.',
    'bill_extension_date_help'                  => 'Optionales Feld. Das Abonnement muss an oder vor diesem Datum verlängert (oder gekündigt) werden.',
    'bill_end_index_line'                       => 'Dieses Abonnement endet am :date',
    'bill_extension_index_line'                 => 'Dieses Abonnement muss am :date verlängert oder gekündigt werden',
    'connected_journals'                        => 'Verknüpfte Buchungen',
    'auto_match_on'                             => 'Automatisch von Firefly III zugeordnet',
    'auto_match_off'                            => 'Nicht automatisch von Firefly III zugeordnet',
    'next_expected_match'                       => 'Nächste erwartete Übereinstimmung',
    'delete_bill'                               => 'Abonnement „:name“ löschen',
    'deleted_bill'                              => 'Abonnement „:name“ gelöscht',
    'edit_bill'                                 => 'Abonnement „:name“ bearbeiten',
    'more'                                      => 'Weitere',
    'rescan_old'                                => 'Regeln für alle Buchungen erneut ausführen',
    'update_bill'                               => 'Abonnement aktualisieren',
    'updated_bill'                              => 'Abonnement „:name“ aktualisiert',
    'store_new_bill'                            => 'Neues Abonnement speichern',
    'stored_new_bill'                           => 'Neues Abonnement „:name“ gespeichert',
    'cannot_scan_inactive_bill'                 => 'Inaktive Abonnements können nicht eingelesen werden.',
    'rescanned_bill'                            => 'Alles neu eingelesen und :count Buchung mit dem Abonnement verknüpft.|Alles neu eingelesen und :count Buchungen mit dem Abonnement verknüpft.',
    'average_bill_amount_year'                  => 'Durchschnittlicher Abonnementbetrag (:year)',
    'average_bill_amount_overall'               => 'Durchschnittlicher Abonnementbetrag (insgesamt)',
    'bill_is_active'                            => 'Abonnement ist aktiv',
    'bill_expected_between'                     => 'Erwartet zwischen :start und :end',
    'bill_will_automatch'                       => 'Das Abonnement wird automatisch mit den entsprechenden Transaktionen verknüpft',
    'skips_over'                                => 'überschreitet',
    'bill_store_error'                          => 'Beim Speichern Ihres neuen Abonnements ist ein unerwarteter Fehler aufgetreten. Bitte überprüfen Sie die Protokolldateien',
    'list_inactive_rule'                        => 'Inaktive Regeln',
    'bill_edit_rules'                           => 'Firefly III wird versuchen, die Regel, die sich auf dieses Abonnement bezieht, ebenfalls zu bearbeiten. Wenn Sie diese Regel jedoch selbst bearbeitet haben, wird Firefly III nichts ändern.|Firefly III wird versuchen, die :count Regeln, die mit diesem Abonnement verbunden sind, ebenfalls zu bearbeiten. Wenn Sie diese Regeln jedoch selbst bearbeitet haben, wird Firefly III nichts ändern.',
    'bill_expected_date'                        => 'Voraussichtlich :date',
    'bill_expected_date_js'                     => 'Erwartet {date}',
    'expected_amount'                           => '(Erwarteter) Betrag',
    'bill_paid_on'                              => 'Bezahlt am {date}',
    'bill_repeats_weekly'                       => 'Wiederholt sich wöchentlich',
    'bill_repeats_monthly'                      => 'Wiederholt sich monatlich',
    'bill_repeats_quarterly'                    => 'Wiederholt sich vierteljährlich',
    'bill_repeats_half-year'                    => 'Wiederholt sich halbjährlich',
    'bill_repeats_yearly'                       => 'Wiederholt sich jährlich',
    'bill_repeats_weekly_other'                 => 'Wiederholt sich jede zweite Woche',
    'bill_repeats_monthly_other'                => 'Wiederholt sich jeden zweiten Monat',
    'bill_repeats_quarterly_other'              => 'Wiederholt sich jedes zweite Vierteljahr',
    'bill_repeats_half-year_other'              => 'Wiederholt sich jährlich',
    'bill_repeats_yearly_other'                 => 'Wiederholt sich jedes zweite Jahr',
    'bill_repeats_weekly_skip'                  => 'Wiederholt sich alle {skip} Wochen',
    'bill_repeats_monthly_skip'                 => 'Wiederholt sich alle {skip} Monate',
    'bill_repeats_quarterly_skip'               => 'Wiederholt sich alle {skip} Vierteljahre',
    'bill_repeats_half-year_skip'               => 'Wiederholt sich alle {skip} Halbjahre',
    'bill_repeats_yearly_skip'                  => 'Wiederholt sich alle {skip} Jahre',
    'subscriptions'                             => 'Abonnements',
    'go_to_subscriptions'                       => 'Zu Abonnements gehen',
    'forever'                                   => 'Dauerhaft',
    'extension_date_is'                         => 'Zeitpunkt der Verlängerung ist {date}',

    // accounts:
    'account_locked_currency'                   => 'Die Währung dieses Kontos muss :name bleiben, solange Sparschweine damit verknüpft sind.',
    'i_am_owed_amount'                          => 'Mir wird Betrag geschuldet',
    'i_owe_amount'                              => 'Ich schulde Betrag',
    'inactive_account_link'                     => 'Sie haben :count inaktives (archiviertes) Konto, das Sie auf dieser separaten Seite sehen können.|Sie haben :count inaktive (archivierte) Konten, die Sie auf dieser separaten Seite anzeigen können.',
    'all_accounts_inactive'                     => 'Dies sind Ihre inaktiven Konten.',
    'active_account_link'                       => 'Diese Verknüpfung führt zurück zu Ihren aktiven Konten.',
    'account_missing_transaction'               => 'Konto #:id („:name”) kann nicht direkt angezeigt werden, da Firefly III Weiterleitungsinformationen fehlen.',
    'cc_monthly_payment_date_help'              => 'Wählen Sie ein beliebiges Jahr und einen beliebigen Monat, da diese Angaben ohnehin ignoriert werden. Nur der Tag des Monats ist relevant.',
    'details_for_asset'                         => 'Details zum Bestandskonto „:name”',
    'details_for_expense'                       => 'Details zum Ausgabenkonto „:name”',
    'details_for_revenue'                       => 'Details zum Einnahmenkonto „:name”',
    'details_for_cash'                          => 'Details zur Geldbörse „:name”',
    'store_new_asset_account'                   => 'Neues Bestandskonto speichern',
    'store_new_expense_account'                 => 'Neues Ausgabenkonto speichern',
    'store_new_revenue_account'                 => 'Neues Einnahmenkonto speichern',
    'edit_asset_account'                        => 'Bestandskonto „:name” bearbeiten',
    'edit_expense_account'                      => 'Ausgabenkonto „:name” bearbeiten',
    'edit_revenue_account'                      => 'Einnahmenkonto „:name” bearbeiten',
    'delete_asset_account'                      => 'Bestandskonto „:name” löschen',
    'delete_expense_account'                    => 'Ausgabenkonto „:name” löschen',
    'delete_revenue_account'                    => 'Einnahmenkonto „:name” löschen',
    'delete_liabilities_account'                => 'Verbindlichkeit „:name” löschen',
    'asset_deleted'                             => 'Bestandskonto „:name” erfolgreich gelöscht',
    'account_deleted'                           => 'Konto „:name” erfolgreich gelöscht',
    'expense_deleted'                           => 'Ausgabenkonto „:name” erfolgreich gelöscht',
    'revenue_deleted'                           => 'Einnahmenkonto „:name” erfolgreich gelöscht',
    'update_asset_account'                      => 'Bestandskonto aktualisieren',
    'update_undefined_account'                  => 'Konto aktualisieren',
    'update_liabilities_account'                => 'Verbindlichkeit aktualisieren',
    'update_expense_account'                    => 'Ausgabenkonto aktualisieren',
    'update_revenue_account'                    => 'Einnahmenkonto aktualisieren',
    'make_new_asset_account'                    => 'Neues Bestandskonto anlegen',
    'make_new_expense_account'                  => 'Neues Ausgabenkonto anlegen',
    'make_new_revenue_account'                  => 'Neues Einnahmenkonto anlegen',
    'make_new_liabilities_account'              => 'Neue Verbindlichkeit anlegen',
    'asset_accounts'                            => 'Bestandskonten',
    'undefined_accounts'                        => 'Konten',
    'asset_accounts_inactive'                   => 'Bestandskonten (inaktiv)',
    'expense_account'                           => 'Ausgabenkonto',
    'expense_accounts'                          => 'Ausgabekonten',
    'expense_accounts_inactive'                 => 'Ausgabekonten (inaktiv)',
    'revenue_account'                           => 'Einnahmekonto',
    'revenue_accounts'                          => 'Einnahmekonten',
    'revenue_accounts_inactive'                 => 'Einnahmekonten (inaktiv)',
    'cash_accounts'                             => 'Geldbörsen',
    'Cash account'                              => 'Geldbörse',
    'liabilities_accounts'                      => 'Verbindlichkeiten',
    'liabilities_accounts_inactive'             => 'Verbindlichkeiten (inaktiv)',
    'reconcile_account'                         => 'Konto „:account” abgleichen',
    'overview_of_reconcile_modal'               => 'Überblick über den Kontenabgleich',
    'delete_reconciliation'                     => 'Kontenabgleich löschen',
    'update_reconciliation'                     => 'Kontenabgleich aktualisieren',
    'amount_cannot_be_zero'                     => 'Der Betrag darf nicht null sein',
    'end_of_reconcile_period'                   => 'Ende des Abgleichzeitraums: :period',
    'start_of_reconcile_period'                 => 'Beginn des Abgleichzeitraums: :period',
    'start_balance'                             => 'Startguthaben',
    'end_balance'                               => 'Endguthaben',
    'update_balance_dates_instruction'          => 'Ordnen Sie die oben genannten Beträge und Daten Ihrem Kontoauszug zu und klicken Sie auf „Jetzt ausgleichen”',
    'select_transactions_instruction'           => 'Wählen Sie die Buchungen aus, die auf Ihrem Kontoauszug angezeigt werden.',
    'select_range_and_balance'                  => 'Überprüfen Sie zunächst den Datumsbereich und das Guthaben. Anschließend drücken Sie auf „Jetzt abgleichen”',
    'date_change_instruction'                   => 'Wenn Sie den Datumsbereich jetzt ändern, geht der gesamte Verlauf verloren.',
    'update_selection'                          => 'Auswahl aktualisieren',
    'store_reconcile'                           => 'Kontenabgleich speichern',
    'reconciliation_transaction'                => 'Ausgleichsbuchung',
    'Reconciliation'                            => 'Kontenabgleich',
    'reconciliation'                            => 'Kontenabgleich',
    'reconcile_options'                         => 'Kontenabgleich Optionen',
    'reconcile_range'                           => 'Kontenabgleich-Bereich',
    'start_reconcile'                           => 'Jetzt abgleichen',
    'cash_account_type'                         => 'Barzahlung',
    'cash'                                      => 'Bar',
    'cant_find_redirect_account'                => 'Firefly III hat vergeblich versucht, Sie umzuleiten. Zum Index zurückkehren.',
    'account_type'                              => 'Kontotyp',
    'save_transactions_by_moving'               => 'Speichern Sie diese Transaktion, indem Sie sie auf ein anderes Konto verschieben:|Speichern Sie diese Transaktionen, indem Sie sie auf ein anderes Konto verschieben:',
    'save_transactions_by_moving_js'            => 'Keine Buchungen|Speichern Sie diese Buchung, indem Sie sie auf ein anderes Konto verschieben. |Speichern Sie diese Buchungen, indem Sie sie auf ein anderes Konto verschieben.',
    'stored_new_account'                        => 'Neues Konto „:name” gespeichert!',
    'stored_new_account_js'                     => 'Neues Konto "<a href="accounts/show/{ID}">„{name}”</a>" gespeichert!',
    'updated_account'                           => 'Konto „:name” aktualisiert',
    'updated_account_js'                        => 'Konto "<a href="accounts/show/{ID}">{title}</a>" aktualisiert.',
    'credit_card_options'                       => 'Kreditkartenoptionen',
    'no_transactions_account'                   => 'Es liegen (in diesem Zeitraum) keine Buchungen für das Bestandskonto „:name” vor.',
    'no_transactions_period'                    => 'Keine Buchungen (in diesem Zeitraum) vorhanden.',
    'no_data_for_chart'                         => 'Es gibt derzeit (noch) nicht genügend Informationen, um dieses Diagramm zu generieren.',
    'select_at_least_one_account'               => 'Bitte mindestens ein Bestandskonto auswählen',
    'select_at_least_one_category'              => 'Bitte mindestens eine Kategorie auswählen',
    'select_at_least_one_budget'                => 'Bitte mindestens ein Budget auswählen',
    'select_at_least_one_tag'                   => 'Bitte mindestens eine Schlagwort auswählen',
    'select_at_least_one_expense'               => 'Bitte wählen Sie mindestens eine Kombination aus Ausgabe- und Einnahmekonten aus. Wenn Sie keine besitzen (die Liste ist leer), ist dieser Bericht nicht verfügbar.',
    'account_default_currency'                  => 'Dies ist die Standardwährung für dieses Konto.',
    'piggy_default_currency'                    => 'Sparschweine können Geld nur in einer einzigen Währung sparen.',
    'piggy_account_currency_match'              => 'Es werden nur Konten akzeptiert, die die zuvor ausgewählte Währung verwenden.',
    'reconcile_has_more'                        => 'Ihr Firefly III-Konto verfügt über mehr Geld, als Ihre Bank behauptet. Es gibt mehrere Möglichkeiten. Bitte wählen Sie aus, was Sie tun möchten. Drücken Sie anschließend auf „Abgleich bestätigen”.',
    'reconcile_has_less'                        => 'Ihr Firefly III-Konto verfügt über weniger Geld, als Ihre Bank behauptet. Es gibt mehrere Möglichkeiten. Bitte wählen Sie aus, was Sie tun möchten. Drücken Sie dann auf „Abgleich bestätigen”.',
    'reconcile_is_equal'                        => 'Ihr Firefly III-Konto und Ihre Kontoauszüge stimmen überein. Es gibt nichts zu tun. Bitte drücken Sie auf „Abgleich bestätigen”, um Ihre Eingaben zu bestätigen.',
    'create_pos_reconcile_transaction'          => 'Ausgewählte Umsätze bereinigen und einen Korrekturbetrag in Höhe von :amount auf dieses Bestandskonto überweisen.',
    'create_neg_reconcile_transaction'          => 'Ausgewählte Umsätze bereinigen und einen Korrekturbetrag in Höhe von :amount von diesem Anlagenkonto zurücküberweisen.',
    'reconcile_do_nothing'                      => 'Ausgewählte Umsätze bereinigen, aber nicht korrigieren.',
    'reconcile_go_back'                         => 'Sie können dies jederzeit später bearbeiten oder löschen.',
    'must_be_asset_account'                     => 'Sie können nur Bestandskonten abgleichen',
    'reconciliation_stored'                     => 'Kontenabgleich gespeichert',
    'reconciliation_error'                      => 'Aufgrund eines Fehlers wurden die Buchungen als „Ausgeglichen” gekennzeichnet, aber die Korrektur wurde nicht gespeichert: :error.',
    'reconciliation_transaction_title'          => 'Ausgleich (:from zu :to)',
    'sum_of_reconciliation'                     => 'Summe der Überleitungsrechnung',
    'reconcile_this_account'                    => 'Dieses Konto abgleichen',
    'reconcile'                                 => 'Abgleichen',
    'show'                                      => 'Anzeigen',
    'confirm_reconciliation'                    => 'Kontenabgleich bestätigen',
    'submitted_start_balance'                   => 'Übermitteltes Startguthaben',
    'selected_transactions'                     => 'Ausgewählte Umsätze (:count)',
    'already_cleared_transactions'              => 'Bereits ausgeglichene Umsätze (:count)',
    'submitted_end_balance'                     => 'Übermittelter Abschlussguthaben',
    'initial_balance_description'               => 'Anfangsguthaben für „:account”',
    'liability_credit_description'              => 'Verbindlichkeitsguthaben für ":account"',
    'interest_calc_'                            => 'Unbekannt',
    'interest_calc_daily'                       => 'Täglich',
    'interest_calc_monthly'                     => 'Monatlich',
    'interest_calc_yearly'                      => 'Jährlich',
    'interest_calc_weekly'                      => 'Pro Woche',
    'interest_calc_half-year'                   => 'Halbjährlich',
    'interest_calc_quarterly'                   => 'Vierteljährlich',
    'initial_balance_account'                   => 'Anfangsguthaben von „:account”',
    'list_options'                              => 'Listenoptionen',
    'account_column_opt_drag_and_drop'          => 'Ziehen und Ablegen',
    'account_column_opt_active'                 => 'Aktiv',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Typ',
    'account_column_opt_liability_type'         => 'Haftungsart',
    'account_column_opt_liability_direction'    => 'Haftungsrichtung',
    'account_column_opt_liability_interest'     => 'Haftungszinsen',
    'account_column_opt_number'                 => 'Kontonummer',
    'account_column_opt_current_balance'        => 'Aktueller Kontostand',
    'account_column_opt_amount_due'             => 'Fälliger Betrag',
    'account_column_opt_last_activity'          => 'Letzte Aktivität',
    'account_column_opt_balance_difference'     => 'Saldendifferenz',
    'account_column_opt_menu'                   => 'Menü',

    // categories:
    'new_category'                              => 'Neue Kategorie',
    'create_new_category'                       => 'Eine neue Kategorie erstellen',
    'without_category'                          => 'Ohne Kategorie',
    'update_category'                           => 'Kategorie aktualisieren',
    'updated_category'                          => 'Kategorie „:name” aktualisiert',
    'categories'                                => 'Kategorien',
    'edit_category'                             => 'Kategorie „:name” bearbeiten',
    'no_category'                               => '(keine Kategorie)',
    'unknown_category_plain'                    => 'Keine Kategorie',
    'category'                                  => 'Kategorie',
    'delete_category'                           => 'Kategorie „:name” löschen',
    'deleted_category'                          => 'Kategorie „:name” gelöscht',
    'store_category'                            => 'Speichere neue Kategorie',
    'stored_category'                           => 'Neue Kategorie „:name” gespeichert',
    'without_category_between'                  => 'Ohne Kategorie zwischen :start und :end',


    // transactions:
    'wait_loading_transaction'                  => 'Bitte warten Sie, bis das Formular geladen wurde',
    'wait_loading_data'                         => 'Bitte warten Sie, bis Ihre Informationen geladen wurden …',
    'wait_attachments'                          => 'Bitte warten Sie, bis die Anhänge hochgeladen sind.',
    'errors_upload'                             => 'Das Hochladen ist fehlgeschlagen. Bitte überprüfen Sie Ihre Browserkonsole auf den Fehler.',
    'amount_foreign_if'                         => 'Betrag in Fremdwährung, falls vorhanden',
    'amount_destination_account'                => 'Betrag in der Währung des Zielkontos',
    'edit_transaction_title'                    => 'Buchung „:description” bearbeiten',
    'unreconcile'                               => 'Kontenabgleich widerrufen',
    'update_withdrawal'                         => 'Ausgaben aktualisieren',
    'update_deposit'                            => 'Einnahmen aktualisieren',
    'update_transaction'                        => 'Buchung aktualisieren',
    'update_transfer'                           => 'Umbuchung aktualisieren',
    'updated_withdrawal'                        => 'Ausgabe ":description" aktualisiert',
    'updated_deposit'                           => 'Einnahme ":description" aktualisiert',
    'updated_transfer'                          => 'Umbuchung ":description" aktualisiert',
    'no_changes_withdrawal'                     => 'Die Ausgabe „:description” wurde nicht geändert.',
    'no_changes_deposit'                        => 'Die Einnahme ":description" wurde nicht geändert.',
    'no_changes_transfer'                       => 'Die Umbuchung ":description" wurde nicht geändert.',
    'delete_withdrawal'                         => 'Ausgabe ":description" löschen',
    'delete_deposit'                            => 'Einnahme ":description" löschen',
    'delete_transfer'                           => 'Umbuchung ":description" löschen',
    'deleted_withdrawal'                        => 'Ausgabe ":description" erfolgreich gelöscht',
    'deleted_deposit'                           => 'Einnahme ":description" erfolgreich gelöscht',
    'deleted_transfer'                          => 'Umbuchung ":description" erfolgreich gelöscht',
    'deleted_reconciliation'                    => 'Ausgleichsbuchung „:description” erfolgreich gelöscht',
    'stored_journal'                            => 'Neue Überweisung ":description" erfolgreich erstellt',
    'stored_journal_js'                         => 'Neue Buchung „{{description}}” erfolgreich erstellt',
    'stored_journal_no_descr'                   => 'Ihre neue Buchung wurde erfolgreich erstellt',
    'updated_journal_no_descr'                  => 'Ihre Buchung wurde erfolgreich aktualisiert',
    'select_transactions'                       => 'Buchungen auswählen',
    'rule_group_select_transactions'            => '„:title” auf Buchungen anwenden',
    'rule_select_transactions'                  => '„:title” auf Buchungen anwenden',
    'stop_selection'                            => 'Auswählen von Buchungen anhalten',
    'reconcile_selected'                        => 'Abgleichen',
    'mass_delete_journals'                      => 'Anzahl von Buchungen löschen',
    'mass_edit_journals'                        => 'Anzahl von Buchungen bearbeiten',
    'mass_bulk_journals'                        => 'Massenbearbeitung mehrerer Buchungen',
    'mass_bulk_journals_explain'                => 'Mit diesem Formular können Sie die Eigenschaften der unten aufgeführten Buchungen in einer einzigen umfassenden Aktualisierung ändern. Alle Buchungen in der Tabelle werden aktualisiert, wenn Sie die hier angezeigten Parameter ändern.',
    'part_of_split'                             => 'Diese Buchung ist Teil einer Splitbuchung. Wenn Sie nicht alle Aufteilungen ausgewählt haben, können Sie am Ende nur die Hälfte der Buchung ändern.',
    'bulk_set_new_values'                       => 'Verwenden Sie die folgenden Felder, um neue Werte einzustellen. Wenn Sie sie leer lassen, werden sie für alle geleert. Beachten Sie auch, dass nur Ausgaben mit einem Budget versehen werden.',
    'no_bulk_category'                          => 'Kategorie nicht aktualisieren',
    'no_bulk_budget'                            => 'Budget nicht aktualisieren',
    'no_bulk_tags'                              => 'Schlagwörter nicht aktualisieren',
    'replace_with_these_tags'                   => 'Durch diese Schlagwörter ersetzen',
    'append_these_tags'                         => 'Diese Schlagwörter hinzufügen',
    'mass_edit'                                 => 'Ausgewählte einzeln bearbeiten',
    'bulk_edit'                                 => 'Ausgewählte als Block bearbeiten',
    'mass_delete'                               => 'Ausgewählte löschen',
    'cannot_edit_other_fields'                  => 'Andere Felder als die hier gezeigten können Sie nicht gleichzeitig bearbeitet werden, da es keinen Platz gibt, diese anzuzeigen. Bitte folgen Sie dem Link und bearbeiten Sie die Felder einzeln, wenn Sie diese bearbeiten möchten.',
    'cannot_change_amount_reconciled'           => 'Sie können den Betrag oder das Konto/die Konten der bestätigten Buchungen nicht ändern.',
    'no_budget'                                 => '(kein Budget)',
    'no_bill'                                   => '(kein Abonnement)',
    'account_per_budget'                        => 'Konto je Budget',
    'account_per_category'                      => 'Konto je Kategorie',
    'create_new_object'                         => 'Erstellen',
    'empty'                                     => '(leer)',
    'all_other_budgets'                         => '(alle anderen Budgets)',
    'all_other_accounts'                        => '(alle anderen Konten)',
    'expense_per_source_account'                => 'Ausgaben je Quellkonto',
    'expense_per_destination_account'           => 'Ausgaben je Zielkonto',
    'income_per_destination_account'            => 'Einnahmen je Zielkonto',
    'spent_in_specific_category'                => 'Ausgaben in der Kategorie „:category”',
    'earned_in_specific_category'               => 'Einnahmen in der Kategorie „:category”',
    'spent_in_specific_tag'                     => 'Ausgaben im Schlagwort „:tag”',
    'earned_in_specific_tag'                    => 'Einnahmen im Schlagwort „:tag”',
    'income_per_source_account'                 => 'Einnahmen je Quellkonto',
    'average_spending_per_destination'          => 'Durchschnittliche Kosten je Zielkonto',
    'average_spending_per_source'               => 'Durchschnittliche Ausgaben je Quellkonto',
    'average_earning_per_source'                => 'Durchschnittlicher Erlös je Quellkonto',
    'average_earning_per_destination'           => 'Durchschnittlicher Einnahmen je Zielkonto',
    'account_per_tag'                           => 'Konto je Schlagwort',
    'tag_report_expenses_listed_once'           => 'Ausgaben und Einnahmen werden nie doppelt ausgewiesen. Wenn einer Buchung mehrere Schagwörter zugeordnet sind, darf diese nur unter einem ihrer Schagwörter angezeigt werden. Diese Liste könnte fehlende Daten enthalten, aber die Beträge werden korrekt sein.',
    'double_report_expenses_charted_once'       => 'Ausgaben und Einnahmen werden nie doppelt ausgewiesen. Wenn einer Buchung mehrer Schlagwörter zugeordnet wurden, darf diese nur unter einem ihrer Schlagwörter angezeigt werden. In diesem Diagramm fehlen möglicherweise Daten, aber die Beträge sind korrekt.',
    'tag_report_chart_single_tag'               => 'Dieses Diagramm gilt für ein einzelnes Schlagwort. Wenn einer Buchung mehrere Schlagwörter zugeordnet sind, kann sich das, was Sie hier sehen, auch in den Diagrammen anderer Schlagwörter widerspiegeln.',
    'tag'                                       => 'Schlagwort',
    'no_budget_squared'                         => '(kein Budget)',
    'perm-delete-many'                          => 'Das Löschen vieler Elemente auf einmal kann sehr problematisch sein. Bitte seien Sie vorsichtig. Sie können einen Teil einer Splitbuchung auf dieser Seite löschen, also seien Sie vorsichtig.',
    'mass_deleted_transactions_success'         => ':count Transaktion gelöscht.|:count Transaktionen gelöscht.',
    'mass_edited_transactions_success'          => ':count Transaktion aktualisiert.|:count Transaktionen aktualisiert.',
    'opt_group_'                                => '(kein Kontotyp)',
    'opt_group_no_account_type'                 => '(kein Kontotyp)',
    'opt_group_defaultAsset'                    => 'Standard-Anlagekonto',
    'opt_group_savingAsset'                     => 'Sparkonten',
    'opt_group_sharedAsset'                     => 'Gemeinsame Bestandskonten',
    'opt_group_ccAsset'                         => 'Kreditkarten',
    'opt_group_cashWalletAsset'                 => 'Geldbörsen',
    'opt_group_expense_account'                 => 'Ausgabekonten',
    'opt_group_revenue_account'                 => 'Einnahmekonten',
    'opt_group_l_Loan'                          => 'Verbindlichkeit: Darlehen',
    'opt_group_cash_account'                    => 'Geldkonto',
    'opt_group_l_Debt'                          => 'Verbindlichkeit: Forderung',
    'opt_group_l_Mortgage'                      => 'Verbindlichkeit: Hypothek',
    'opt_group_l_Credit card'                   => 'Verbindlichkeit: Kreditkarte',
    'notes'                                     => 'Notizen',
    'view_notes'                                => 'Anmerkungen anzeigen',
    'set_budget_limit_notes'                    => 'Hinweise zu diesem Betrag anzeigen',
    'edit_bl_notes'                             => 'Kommentare bearbeiten',
    'update_bl_notes'                           => 'Kommentare aktualisieren',
    'unknown_journal_error'                     => 'Die Buchung konnte nicht gespeichert werden. Bitte überprüfen Sie die Protokolldateien.',
    'attachment_not_found'                      => 'Der Anhang konnte nicht gefunden werden.',
    'journal_link_bill'                         => 'Diese Transaktion ist mit dem Abonnement <a href=„:route“>:name</a> verbunden. Um die Verbindung zu lösen, deaktivieren Sie das Kontrollkästchen. Verwenden Sie Regeln, um es mit einem anderen Abonnement zu verknüpfen.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Buchung #{ID} ("{title}")</a> wurde gespeichert.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Buchung #{ID}</a> wurde gespeichert.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Die Buchung #{ID}</a> ("{title}") wurde aktualisiert.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Die Buchung #{ID}</a> ("{title}") wurde nicht verändert.',
    'first_split_decides'                       => 'Die erste Aufteilung bestimmt den Wert dieses Feldes',
    'first_split_overrules_source'              => 'Die erste Aufteilung könnte das Quellkonto überschreiben',
    'first_split_overrules_destination'         => 'Die erste Aufteilung könnte das Zielkonto überschreiben',
    'spent_x_of_y'                              => '{amount} von {total} ausgegeben',

    // new user:
    'welcome'                                   => 'Willkommen bei Firefly III!',
    'submit'                                    => 'Absenden',
    'submission'                                => 'Übermittlung',
    'submit_yes_really'                         => 'Senden (Ich weiß, was ich tue)',
    'getting_started'                           => 'Erste Schritte',
    'to_get_started'                            => 'Es ist schön, dass Sie Firefly III erfolgreich installiert haben. Um mit diesem Tool zu beginnen, geben Sie bitte den Namen Ihrer Bank und das Guthaben Ihres Hauptkontos ein. Machen Sie sich keine Sorgen, wenn Sie mehrere Konten haben. Sie können diese später hinzufügen. Dies ist nur der Anfang.',
    'savings_balance_text'                      => 'Firefly III erstellt automatisch ein Sparkonto für Sie. Standardmäßig befindet sich kein Geld auf Ihrem Sparkonto, aber wenn Sie Firefly III das Guthaben mitteilen, wird es als solches gespeichert.',
    'finish_up_new_user'                        => 'Das war\'s! Sie können fortfahren, indem Sie <strong>Absenden</strong> drücken. Sie werden zur Startseite von Firefly III gebracht.',
    'stored_new_accounts_new_user'              => 'Yay! Ihre neuen Konten wurden gespeichert.',
    'set_preferred_language'                    => 'Wenn Sie Firefly III in einer anderen Sprache verwenden möchten, geben Sie dies bitte hier an.',
    'language'                                  => 'Sprache',
    'new_savings_account'                       => ':bank_name-Sparkonto',
    'cash_wallet'                               => 'Geldbörse',
    'currency_not_present'                      => 'Wenn die Währung, die Sie normalerweise verwenden, nicht aufgeführt ist, machen Sie sich keine Sorgen. Unter Optionen ➜ Währungen können Sie eigene Währungen anlegen.',

    // home page:
    'transaction_table_description'             => 'Eine Tabelle mit Ihren Buchungen',
    'opposing_account'                          => 'Gegenkonto',
    'yourAccounts'                              => 'Deine Konten',
    'your_accounts'                             => 'Kontenübersicht',
    'category_overview'                         => 'Kategorieübersicht',
    'expense_overview'                          => 'Übersicht der Ausgabekonten',
    'revenue_overview'                          => 'Übersicht der Einnahmekonten',
    'budgetsAndSpending'                        => 'Budgets und Ausgaben',
    'budgets_and_spending'                      => 'Budgets und Ausgaben',
    'go_to_budget'                              => 'Zu Budget „{budget}” wechseln',
    'go_to_deposits'                            => 'Einnahmen anzeigen',
    'go_to_expenses'                            => 'Ausgaben anzeigen',
    'savings'                                   => 'Erspartes',
    'newWithdrawal'                             => 'Neue Ausgabe',
    'newDeposit'                                => 'Neue Einnahme',
    'newTransfer'                               => 'Neue Umbuchung',
    'bills_to_pay'                              => 'Zu zahlende Abonnements',
    'per_day'                                   => 'Pro Tag',
    'left_to_spend_per_day'                     => 'Verbleibend zum Ausgeben je Tag',
    'bills_paid'                                => 'Bezahlte Abonnements',
    'custom_period'                             => 'Benutzerdefinierter Zeitraum',
    'reset_to_current'                          => 'Auf aktuellen Zeitraum zurücksetzen',
    'select_period'                             => 'Zeitraum auswählen',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Währung',
    'preferences'                               => 'Einstellungen',
    'logout'                                    => 'Abmelden',
    'logout_other_sessions'                     => 'Alle anderen Sitzungen abmelden',
    'toggleNavigation'                          => 'Navigation umschalten',
    'toggle_dropdown'                           => 'Auswahlmenü anzeigen/ausblenden',
    'searchPlaceholder'                         => 'Suchen...',
    'version'                                   => 'Version',
    'dashboard'                                 => 'Übersicht',
    'income_and_expense'                        => 'Einnahmen und Ausgaben',
    'all_money'                                 => 'All Ihr Geld',
    'unknown_source_plain'                      => 'Unbekanntes Quellkonto',
    'unknown_dest_plain'                        => 'Unbekanntes Zielkonto',
    'unknown_any_plain'                         => 'Unbekanntes Konto',
    'unknown_budget_plain'                      => 'Kein Budget',
    'available_budget'                          => 'Verfügbares Budget ({currency})',
    'currencies'                                => 'Währungen',
    'activity'                                  => 'Aktivität',
    'usage'                                     => 'Verwendung',
    'accounts'                                  => 'Konten',
    'Asset account'                             => 'Bestandskonto',
    'Default account'                           => 'Bestandskonto',
    'Expense account'                           => 'Ausgabenkonto',
    'Revenue account'                           => 'Einnahmenkonto',
    'Initial balance account'                   => 'Eröffnungssaldo',
    'account_type_Asset account'                => 'Bestandskonto',
    'account_type_Expense account'              => 'Ausgabenkonto',
    'account_type_Revenue account'              => 'Einnahmenkonto',
    'account_type_Debt'                         => 'Schuld',
    'account_type_Loan'                         => 'Darlehen',
    'account_type_Mortgage'                     => 'Hypothek',
    'account_type_debt'                         => 'Schulden',
    'account_type_loan'                         => 'Darlehen',
    'account_type_mortgage'                     => 'Hypothek',
    'account_type_Credit card'                  => 'Kreditkarte',
    'credit_card_type_monthlyFull'              => 'Vollständige Zahlung jeden Monat',
    'liability_direction_credit'                => 'Mir wird dies geschuldet',
    'liability_direction_debit'                 => 'Ich schulde dies jemandem',
    'liability_direction_credit_short'          => 'Geschuldeter Betrag',
    'liability_direction_debit_short'           => 'Schuldiger Betrag',
    'liability_direction__short'                => 'Unbekannt',
    'liability_direction_null_short'            => 'Unbekannt',
    'Liability credit'                          => 'Verbindlichkeitsguthaben',
    'budgets'                                   => 'Budgets',
    'tags'                                      => 'Schlagwörter',
    'reports'                                   => 'Berichte',
    'transactions'                              => 'Buchungen',
    'expenses'                                  => 'Ausgaben',
    'income'                                    => 'Einnahmen / Einkommen',
    'transfers'                                 => 'Umbuchungen',
    'moneyManagement'                           => 'Geldverwaltung',
    'money_management'                          => 'Finanzverwaltung',
    'tools'                                     => 'Extras',
    'piggyBanks'                                => 'Sparschweine',
    'piggy_banks'                               => 'Sparschweine',
    'amount_x_of_y'                             => '{current} von {total}',
    'bills'                                     => 'Abonnements',
    'withdrawal'                                => 'Ausgabe',
    'opening_balance'                           => 'Eröffnungsbilanz',
    'deposit'                                   => 'Einnahme',
    'account'                                   => 'Konto',
    'transfer'                                  => 'Umbuchung',
    'Withdrawal'                                => 'Ausgabe',
    'Deposit'                                   => 'Einnahme',
    'Transfer'                                  => 'Umbuchung',
    'bill'                                      => 'Abonnement',
    'yes'                                       => 'Ja',
    'no'                                        => 'Nein',
    'amount'                                    => 'Betrag',
    'overview'                                  => 'Übersicht',
    'saveOnAccount'                             => 'Rücklagen für Konto',
    'saveOnAccounts'                            => 'Rücklagen für Kont(o/en)',
    'unknown'                                   => 'Unbekannt',
    'monthly'                                   => 'Monatlich',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Fehler',
    'debt_start_date'                           => 'Startdatum der Verschuldung',
    'debt_start_amount'                         => 'Startbetrag der Verschuldung',
    'debt_start_amount_help'                    => 'Es wird empfohlen, diesen Wert auf einen negativen Betrag festzulegen. Lesen Sie die Hilfeseiten (oben rechts ❓-Symbol) für weitere Informationen.',
    'interest_period_help'                      => 'Dieses Feld ist rein kosmetisch und wird für Sie nicht berechnet. Wie sich herausstellt, sind Banken sehr hinterhältig, so dass Firefly III es nie richtig macht.',
    'store_new_liabilities_account'             => 'Neue Verbindlichkeit speichern',
    'edit_liabilities_account'                  => 'Verbindlichkeit „:name” bearbeiten',
    'financial_control'                         => 'Finanzkontrolle',
    'accounting'                                => 'Buchhaltung',
    'automation'                                => 'Automatisierungen',
    'others'                                    => 'Weitere',
    'classification'                            => 'Klassifizierung',
    'store_transaction'                         => 'Buchung speichern',


    // reports:
    'quick_link_needs_accounts'                 => 'Um Berichte erstellen zu können, müssen Sie mindestens ein Bestandskonto zu Firefly III hinzufügen.',
    'report_default'                            => 'Standardfinanzbericht zwischen :start und :end',
    'report_audit'                              => 'Übersicht des Buchungsverlaufs zwischen :start und :end',
    'report_category'                           => 'Kategoriebericht zwischen :start und :end',
    'report_double'                             => 'Ausgaben-/Einnahmenabrechnung zwischen :start and :end',
    'report_budget'                             => 'Finanzbericht zwischen :start and :end',
    'report_tag'                                => 'Schlagwortbericht zwischen :start und :end',
    'quick_link_reports'                        => 'Schnellzugriff',
    'quick_link_examples'                       => 'Dies sind nur einige Beispiel-Links, um Ihnen den Einstieg zu erleichtern. Auf den Hilfeseiten unter der Schaltfläche „(?)” finden Sie Informationen zu allen Berichten und den Zauberworten, die Sie verwenden können.',
    'quick_link_default_report'                 => 'Standard Finanzbericht',
    'quick_link_audit_report'                   => 'Transaktionshistorie',
    'report_this_month_quick'                   => 'Aktueller Monat, alle Konten',
    'report_last_month_quick'                   => 'Letzter Monat, alle Konten',
    'report_this_year_quick'                    => 'Aktuelles Jahr, alle Konten',
    'report_this_fiscal_year_quick'             => 'Aktuelles Geschäftsjahr, alle Konten',
    'report_all_time_quick'                     => 'Gesamte Zeit, alle Konten',
    'reports_can_bookmark'                      => 'Berichte können als Lesezeichen gespeichert werden.',
    'incomeVsExpenses'                          => 'Einkommen vs Ausgaben',
    'accountBalances'                           => 'Kontostände',
    'balanceStart'                              => 'Bilanz zum Beginn der Periode',
    'balanceEnd'                                => 'Bilanz zum Ende der Periode',
    'splitByAccount'                            => 'Nach Konten aufgeteilt',
    'coveredWithTags'                           => 'Mit Schlagwörtern versehen',
    'leftInBudget'                              => 'Verblieben im Budget',
    'left_in_debt'                              => 'Fälliger Betrag',
    'sumOfSums'                                 => 'Summe der Summen',
    'noCategory'                                => '(keine Kategorie)',
    'notCharged'                                => '(Noch) nicht belastet',
    'inactive'                                  => 'Inaktiv',
    'active'                                    => 'Aktiv',
    'difference'                                => 'Unterschied',
    'money_flowing_in'                          => 'Eingehend',
    'money_flowing_out'                         => 'Ausgehend',
    'topX'                                      => 'Topnummer :number',
    'show_full_list'                            => 'Zeige die gesamte Liste',
    'show_only_top'                             => 'Nur die Top :number anzeigen',
    'report_type'                               => 'Typ des Berichts',
    'report_type_default'                       => 'Standard-Finanzbericht',
    'report_type_audit'                         => 'Übersicht der Transaktionen (Prüfung)',
    'report_type_category'                      => 'Kategorie-Bericht',
    'report_type_budget'                        => 'Finanzbericht',
    'report_type_tag'                           => 'Schlagwortbericht',
    'report_type_double'                        => 'Ausgaben-/Einnahmenabrechnung',
    'more_info_help'                            => 'Weitere Informationen über diese Art von Berichten finden Sie in der Hilfe. Drücken Sie hierfür das (?)-Symbol in der oberen rechten Ecke.',
    'report_included_accounts'                  => 'Einbezogene Konten',
    'report_date_range'                         => 'Zeitraum',
    'report_preset_ranges'                      => 'Voreingestellte Bereiche',
    'shared'                                    => 'Geteilt',
    'fiscal_year'                               => 'Geschäftsjahr',
    'income_entry'                              => 'Einnahmen aus dem Konto „:name” zwischen :start und :end',
    'expense_entry'                             => 'Ausgaben für das Konto „:name” zwischen :start und :end',
    'category_entry'                            => 'Ausgaben und Einnahmen in der Kategorie „:name” zwischen :start und :end',
    'budget_spent_amount'                       => 'Ausgaben im Haushalt „:budget” zwischen :start und :end',
    'balance_amount'                            => 'Ausgaben im Budget „:budget” bezahlt von Konto „:account” zwischen :start und :end',
    'no_audit_activity'                         => 'Zwischen :start und :end wurde keine Aktivität auf dem Konto <a href=":url" title=":account_name">:account_name</a> festgestellt.',
    'audit_end_balance'                         => 'Kontostand von <a href=":url" title=":account_name">:account_name</a> war am Ende vom :end: :balance',
    'reports_extra_options'                     => 'Zusatzoptionen',
    'report_has_no_extra_options'               => 'Dieser Bericht hat keine zusätzliche Optionen',
    'reports_submit'                            => 'Zeige Bericht',
    'end_after_start_date'                      => 'Enddatum des Berichts muss nach dem Startdatum liegen.',
    'select_category'                           => 'Kategorie(n) auswählen',
    'select_budget'                             => 'Budget(s) auswählen.',
    'select_tag'                                => 'Schlagworte wählen.',
    'income_per_category'                       => 'Einnahmen pro Kategorie',
    'expense_per_category'                      => 'Ausgaben pro Kategorie',
    'expense_per_budget'                        => 'Ausgaben je Budget',
    'income_per_account'                        => 'Einnahmen pro Konto',
    'expense_per_account'                       => 'Ausgaben pro Konto',
    'expense_per_tag'                           => 'Ausgaben je Schlagwort',
    'income_per_tag'                            => 'Einnahmen je Schlagwort',
    'include_expense_not_in_budget'             => 'Enthaltene Ausgaben, die nicht in dem/den ausgewählten Finanzrahmen enthalten sind',
    'include_expense_not_in_account'            => 'Enthaltene Ausgaben, die nicht in den ausgewählten Konten enthalten sind',
    'include_expense_not_in_category'           => 'Enthaltene Ausgaben, die nicht in die ausgewählte(n) Kategorie(n) fallen',
    'include_income_not_in_category'            => 'Enthaltene Erträge, die nicht in die ausgewählte(n) Kategorie(n) fallen',
    'include_income_not_in_account'             => 'Enthaltene Erträge, die nicht in dem/den ausgewählten Konto(en) enthalten sind',
    'include_income_not_in_tags'                => 'Enthaltene Erträge, die nicht in den ausgewählten Schlagwörtern enthalten sind',
    'include_expense_not_in_tags'               => 'Enthaltene Ausgaben, die nicht in den ausgewählten Schlagwörtern enthalten sind',
    'everything_else'                           => 'Der Rest',
    'income_and_expenses'                       => 'Einkommen und Ausgaben',
    'spent_average'                             => 'Ausgaben (Durchschnitt)',
    'income_average'                            => 'Einkommen (Durchschnitt)',
    'transaction_count'                         => 'Überweisungen',
    'average_spending_per_account'              => 'Durchschnittsausgaben pro Konto',
    'average_income_per_account'                => 'Durchschnittseinkommen pro Konto',
    'total'                                     => 'Gesamt',
    'description'                               => 'Beschreibung',
    'sum_of_period'                             => 'Summe des Zeitraums',
    'average_in_period'                         => 'Durchschnitt im Zeitraum',
    'no_account_role'                           => '(keine Rolle)',
    'account_role_defaultAsset'                 => 'Standard-Bestandskonto',
    'account_role_sharedAsset'                  => 'Gemeinsames Bestandskonto',
    'account_role_savingAsset'                  => 'Sparkonto',
    'account_role_ccAsset'                      => 'Kreditkarte',
    'account_role_cashWalletAsset'              => 'Geldbörse',
    'budget_chart_click'                        => 'Klicken Sie auf einen Namen des Budgets in der obigen Tabelle, um ein Diagramm anzuzeigen.',
    'category_chart_click'                      => 'Klicken Sie auf einen Kategorienamen in der obigen Tabelle, um ein Diagramm zu sehen.',
    'in_out_accounts'                           => 'Einnahmen und Ausgaben je Kombination',
    'in_out_accounts_per_asset'                 => 'Einnahmen und Ausgaben (je Anlagenkonto)',
    'in_out_per_category'                       => 'Einnahmen und Ausgaben je Kategorie',
    'out_per_budget'                            => 'Ausgaben je Budget',
    'select_expense_revenue'                    => 'Ausgaben-/Einnahmenkonto auswählen',
    'multi_currency_report_sum'                 => 'Da diese Liste Konten mit mehreren Währungen enthält, ergeben die Summe(n), die angezeigt werden, möglicherweise keinen Sinn. Der Bericht wird immer auf Ihre Standardwährung zurückgesetzt.',
    'sum_in_default_currency'                   => 'Der Betrag wird immer in Ihrer Standardwährung angegeben.',
    'net_filtered_prefs'                        => 'Dieses Diagramm wird niemals Konten einbeziehen, die die Option "Im Eigenkapital enthalten" deaktiviert haben.',


    // charts:
    'chart'                                     => 'Diagram',
    'month'                                     => 'Monat',
    'budget'                                    => 'Budget',
    'spent'                                     => 'Ausgegeben',
    'spent_capped'                              => 'Ausgegeben (gedeckelt)',
    'spent_in_budget'                           => 'Ausgegeben im Budget',
    'left_to_spend'                             => 'Verbleibend zum Ausgeben',
    'earned'                                    => 'Eingenommen',
    'overspent'                                 => 'Zuviel ausgegeben',
    'left'                                      => 'Übrig',
    'max-amount'                                => 'Höchstbetrag',
    'min-amount'                                => 'Mindestbetrag',
    'journal-amount'                            => 'Aktueller Eintrag im Abonnement',
    'name'                                      => 'Name',
    'expires_at'                                => 'Gültig bis',
    'date'                                      => 'Datum',
    'date_and_time'                             => 'Datum und Uhrzeit',
    'time'                                      => 'Uhrzeit',
    'paid'                                      => 'Bezahlt',
    'unpaid'                                    => 'Unbezahlt',
    'day'                                       => 'Tag',
    'budgeted'                                  => 'Vorgesehen',
    'period'                                    => 'Zeitraum',
    'balance'                                   => 'Kontostand',
    'in_out_period'                             => 'Ein- + Ausgaben im Zeitraum',
    'sum'                                       => 'Summe',
    'summary'                                   => 'Zusammenfasssung',
    'average'                                   => 'Durchschnitt',
    'balanceFor'                                => 'Kontostand für „:name”',
    'no_tags'                                   => '(keine Schlagwörter)',
    'nothing_found'                             => '(nichts gefunden)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Seiteneinstellungen',
    'visible_columns'               => 'Sichtbare Spalten',
    'accounts_to_show'              => 'Anzuzeigende Konten',
    'active_accounts_only'          => 'Nur aktive Konten',
    'in_active_accounts_only'       => 'Nur inaktive Konten',
    'show_all_accounts'             => 'Alle Konten anzeigen',
    'group_accounts'                => 'Konten gruppieren',

    // piggy banks:
    'event_history'                 => 'Ereignisverlauf',
    'add_money_to_piggy'            => 'Geld zum Sparschwein „:name” übertragen',
    'piggy_bank'                    => 'Sparschwein',
    'new_piggy_bank'                => 'Neues Sparschwein',
    'store_piggy_bank'              => 'Speichere neues Sparschwein',
    'stored_piggy_bank'             => 'Neues Sparschwein „:name” speichern',
    'account_status'                => 'Kontostatus',
    'left_for_piggy_banks'          => 'Übrig für Sparschweine',
    'sum_of_piggy_banks'            => 'Summe der Sparschweine',
    'saved_so_far'                  => 'Gespart',
    'saved_so_far_total'            => 'Bisher insgesamt gespeichert',
    'reset_history'                 => 'Verlauf zurücksetzen',
    'reset_history_confirm'         => 'Möchten Sie den Verlauf dieses Sparschweins wirklich zurücksetzen? Dadurch wird die Darstellung wieder mit dem Betrag des Sparschweins übereinstimmen.',
    'piggy_history_reset'           => 'Der Verlauf des Sparschweins wurde zurückgesetzt',
    'left_to_save'                  => 'Zu Sparen',
    'suggested_amount'              => 'Empfohlener monatliche Sparbetrag',
    'add_money_to_piggy_title'      => 'Geld dem Sparschwein „:name” hinzufügen',
    'remove_money_from_piggy_title' => 'Geld dem Sparschwein „:name” entnehmen',
    'add'                           => 'Hinzufügen',
    'no_money_for_piggy'            => 'Sie haben kein Geld, welches Sie in dieses Sparschwein geben können.',
    'suggested_savings_per_month'   => 'Monatlich empfohlen',

    'remove'                    => 'Entfernen',
    'max_amount_add'            => 'Der maximale Betrag, den Sie hinzufügen können ist',
    'max_amount_remove'         => 'Der maximale Betrag, den Sie entnehmen können ist',
    'update_piggy_button'       => 'Sparschwein aktualisieren',
    'update_piggy_title'        => 'Sparschwein „:name” aktualisieren',
    'updated_piggy_bank'        => 'Sparschwein „:name” aktualisiert',
    'details'                   => 'Details',
    'events'                    => 'Ereignisse',
    'target_amount'             => 'Zielbetrag',
    'start_date'                => 'Startdatum',
    'no_start_date'             => 'Kein Startzeitpunkt',
    'target_date'               => 'Zieldatum',
    'no_target_date'            => 'Kein Zieldatum',
    'table'                     => 'Tabelle',
    'delete_piggy_bank'         => 'Sparschwein „:name” löschen',
    'cannot_add_amount_piggy'   => ':amount konnte nicht zu „:name” hinzugefügt werden.',
    'cannot_remove_from_piggy'  => ':amount konnte nicht aus „:name” entfernt werden',
    'deleted_piggy_bank'        => 'Sparschwein „:name” gelöscht',
    'added_amount_to_piggy'     => ':amount zu „:name” hinzugefügt',
    'removed_amount_from_piggy' => ':amount aus „:name” entfernt',
    'piggy_events'              => 'Zugehörige Sparschweine',

    // tags
    'delete_tag'                => 'Schlagwort „:tag” entfernen',
    'deleted_tag'               => 'Schlagwort „:tag” entfernt',
    'new_tag'                   => 'Neues Schlagwort erstellen',
    'edit_tag'                  => 'Schlagwort „:tag” bearbeiten',
    'updated_tag'               => 'Schlagwort „:tag” aktualisiertern',
    'created_tag'               => 'Schlagwort „:tag” wurde angelegt!',

    'transaction_journal_information'               => 'Transaktionsinformationen',
    'transaction_journal_amount'                    => 'Betraginformation',
    'transaction_journal_meta'                      => 'Metainformationen',
    'transaction_journal_more'                      => 'Weitere Informationen',
    'basic_journal_information'                     => 'Allgemeine Buchungsinformationen',
    'transaction_journal_extra'                     => 'Zusätzliche Informationen',
    'att_part_of_journal'                           => 'Unter „:journal” gespeichert',
    'total_amount'                                  => 'Gesamtbetrag',
    'number_of_decimals'                            => 'Anzahl der Nachkommastellen',


    // administration
    'invite_is_already_redeemed'                    => 'Die Einladung zu „:address“ wurde bereits eingelöst.',
    'invite_is_deleted'                             => 'Die Einladung zu „:address“ wurde gelöscht.',
    'invite_new_user_title'                         => 'Neuen Nutzer einladen',
    'invite_new_user_text'                          => 'Als Administrator können Sie Benutzer einladen, sich bei Ihrer Firefly III-Installation zu registrieren. Über den direkten Link, den Sie ihnen mitteilen können, können sie ein Konto registrieren. Der eingeladene Benutzer und sein Einladungslink werden in der Tabelle unten angezeigt. Es steht Ihnen frei, den Einladungslink mit diesen Personen zu teilen.',
    'invited_user_mail'                             => 'E-Mail Adresse',
    'invite_user'                                   => 'Nutzer einladen',
    'user_is_invited'                               => 'E-Mail Adresse ":address" wurde zu Firefly III eingeladen',
    'administration'                                => 'Verwaltung',
    'system_settings'                               => 'Systemeinstellungen',
    'code_already_used'                             => 'Einladungscode wurde bereits verwendet',
    'user_administration'                           => 'Nutzerinformation',
    'list_all_users'                                => 'Alle Benutzer',
    'all_users'                                     => 'Alle Benutzer',
    'instance_configuration'                        => 'Konfiguration',
    'firefly_instance_configuration'                => 'Firefly III Konfiguration',
    'setting_single_user_mode'                      => 'Einzelnutzermodus',
    'setting_single_user_mode_explain'              => 'Dies ist eine sehr fortschrittliche Funktion, welche aber sehr nützlich sein kann. Stellen Sie sicher, dass Sie die Dokumentation (❓-Symbol in der oberen rechten Ecke) lesen, bevor Sie fortfahren.',
    'store_configuration'                           => 'Konfiguration speichern',
    'single_user_administration'                    => 'Benutzerverwaltung für :email',
    'edit_user'                                     => 'Benutzer :email bearbeiten',
    'hidden_fields_preferences'                     => 'Sie können weitere Buchungsoptionen in Ihren <a href="preferences">Einstellungen</a> aktivieren.',
    'user_data_information'                         => 'Nutzerdaten',
    'user_information'                              => 'Benutzerinformationen',
    'total_size'                                    => 'Gesamtgröße',
    'budget_or_budgets'                             => ':count Budget|:count Budgets',
    'budgets_with_limits'                           => ':count Budget mit konfiguriertem Betrag|:count Budgets mit konfiguriertem Betrag',
    'nr_of_rules_in_total_groups'                   => ':count_rules Regel(n) in :count_groups Gruppenregel(n)',
    'tag_or_tags'                                   => ':count Schlagwort|:count Schlagwörter',
    'configuration_updated'                         => 'Die Konfiguration wurde aktualisiert',
    'setting_is_demo_site'                          => 'Demonstrationsseite',
    'setting_is_demo_site_explain'                  => 'Wenn sie diese Option auswählen, wird sich diese Installation wie eine Demonstrationsseite verhalten, was ungewollte Auswirkungen haben kann.',
    'block_code_bounced'                            => 'E-Mail-Nachricht(en) wurden abgewiesen',
    'block_code_expired'                            => 'Demo-Konto abgelaufen',
    'no_block_code'                                 => 'Kein Grund für Block oder Benutzer nicht blockiert',
    'demo_user_export'                              => 'Der Demo-Benutzer kann keine Daten exportieren',
    'block_code_email_changed'                      => 'Der Benutzer hat die neue E-Mail-Adresse noch nicht bestätigt',
    'admin_update_email'                            => 'Im Gegensatz zur Profilseite wird der Benutzer NICHT benachrichtigt, dass seine E-Mail-Adresse geändert wurde!',
    'update_user'                                   => 'Benutzer aktualisieren',
    'updated_user'                                  => 'Nutzerdaten wurden geändert.',
    'delete_user'                                   => 'Benutzer :email löschen',
    'user_deleted'                                  => 'Der Nutzer wurde gelöscht',
    'send_test_email'                               => 'Test-E-Mail senden',
    'send_test_email_text'                          => 'Um zu sehen, ob Ihre Installation in der Lage ist, eine Benachrichtigung zu senden, drücken Sie bitte diese Schaltfläche. Es werden hier keine Fehler angezeigt (wenn überhaupt), <strong>die Protokolldateien enthalten alle Fehler</strong>. Sie können diese Taste so oft drücken, wie Sie möchten. Es findet keine Spam-Kontrolle statt. Die Nachricht wird an <code>:email</code> gesendet und sollte in Kürze eintreffen.',
    'send_message'                                  => 'Nachricht senden',
    'send_test_triggered'                           => 'Der Test wurde ausgelöst. Überprüfen Sie Ihren Posteingang und die Protokolldateien.',
    'give_admin_careful'                            => 'Benutzer mit Admin-Rechten können Ihnen Ihre Rechte entziehen. Seien Sie vorsichtig.',
    'admin_maintanance_title'                       => 'Wartungsarbeiten',
    'admin_maintanance_expl'                        => 'Einige praktische Schaltflächen für die Wartung von Firefly III',
    'admin_maintenance_clear_cache'                 => 'Cache leeren',
    'owner_notifications'                           => 'Admin-Benachrichtigungen',
    'owner_notifications_expl'                      => 'Die folgenden Benachrichtigungen können durch den Administrator aktiviert oder deaktiviert werden. Sie werden über ALLE konfigurierten Kanäle gesendet. Einige Kanäle werden in Ihren Umgebungsvariablen konfiguriert, andere können hier eingestellt werden.',
    'channel_settings'                              => 'Einstellungen für Benachrichtigungskanäle',
    'notification_test_failed'                      => 'Der Benachrichtigungstest für den Kanal „:channel“ ist fehlgeschlagen. Die Protokolle enthalten weitere Details.',
    'notification_test_executed'                    => 'Benachrichtigungstest für Kanal „:channel“ ausgeführt. Prüfen Sie Ihre Protokolle auf Details.',
    'settings_notifications'                        => 'Benachrichtigungseinstellungen',
    'title_owner_notifications'                     => 'Eigentümer-Benachrichtigungen',
    'owner_notification_check_user_new_reg'         => 'Benutzer erhält nach der Registrierung eine Willkommensnachricht',
    'owner_notification_check_admin_new_reg'        => 'Administrator(en) erhalten Benachrichtigung über die Registrierung neuer Benutzer',
    'owner_notification_check_new_version'          => 'Eine neue Version ist verfügbar',
    'owner_notification_check_invite_created'       => 'Ein Benutzer wurde zu Firefly III eingeladen',
    'owner_notification_check_invite_redeemed'      => 'Eine Benutzereinladung wurde eingelöst',
    'owner_notification_check_unknown_user_attempt' => 'Ein unbekannter Benutzer versucht, sich anzumelden',
    'all_invited_users'                             => 'Alle eingeladenen Benutzer',
    'save_notification_settings'                    => 'Einstellungen speichern',
    'notification_settings'                         => 'Einstellungen für Benachrichtigungen',
    'notification_settings_saved'                   => 'Die Benachrichtigungseinstellungen wurden gespeichert',
    'available_channels_title'                      => 'Verfügbare Kanäle',
    'available_channels_expl'                       => 'Über diese Kanäle können Sie Benachrichtigungen senden. Um Ihre Konfiguration zu testen, verwenden Sie die Schaltflächen unten. Bitte beachten Sie, dass die Schaltflächen keine Spam-Kontrolle bieten.',
    'notification_channel_name_email'               => 'E-Mail-Adresse',
    'slack_discord_double'                          => 'Der Slack-Benachrichtigungskanal kann auch Benachrichtigungen an Discord senden.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'nicht verfügbar',
    'configure_channel_in_env'                      => 'benötigt Umgebungsvariablen',
    'test_notification_channel_name_email'          => 'E-Mail testen',
    'test_notification_channel_name_slack'          => 'Slack testen',
    'test_notification_channel_name_ntfy'           => 'Ntfy.sh testen',
    'test_notification_channel_name_pushover'       => 'Pushover testen',
    'test_notification_channel_name_gotify'         => 'Gotify testen',
    'test_notification_channel_name_pushbullet'     => 'Pushbullet testen',

    'split_transaction_title'               => 'Beschreibung der Splittbuchung',
    'split_transaction_title_help'          => 'Wenn Sie eine Splittbuchung anlegen, muss es eine eindeutige Beschreibung für alle Aufteilungen der Buchung geben.',
    'split_title_help'                      => 'Wenn Sie eine Splittbuchung anlegen, muss es eine eindeutige Beschreibung für alle Aufteilungen der Buchhaltung geben.',
    'you_create_transfer'                   => 'Sie erstellen eine Umbuchung.',
    'you_create_withdrawal'                 => 'Sie haben eine Ausgabe erstellt.',
    'you_create_deposit'                    => 'Sie haben eine Einnahme erstellt.',

    // links
    'journal_link_configuration'            => 'Konfiguration der Buchungsverknüpfungen',
    'create_new_link_type'                  => 'Neuen Verknüpfungstyp erstellen',
    'store_new_link_type'                   => 'Neuen Verknüpfungstyp speichern',
    'update_link_type'                      => 'Verknüpfungstyp aktualisieren',
    'edit_link_type'                        => 'Verknüpfungstyp „:name” bearbeiten',
    'updated_link_type'                     => 'Verknüpfungstyp „:name” aktualisiert',
    'delete_link_type'                      => 'Verknüpfungstyp „:name” löschen',
    'deleted_link_type'                     => 'Verknüpfungstyp „:name” gelöscht',
    'stored_new_link_type'                  => 'Neuen Verknüpfungstyp „:name” speichern',
    'cannot_edit_link_type'                 => 'Verknüpfungstyp „:name” konnte nicht bearbeite werden',
    'link_type_help_name'                   => 'd.h. „Kopien”',
    'link_type_help_inward'                 => 'd.h. „Kopien”',
    'link_type_help_outward'                => 'd.h. „wird kopiert durch”',
    'save_connections_by_moving'            => 'Speichern Sie die Verknüpfung zwischen diesen Transaktionen, indem Sie sie in einen anderen Verknüpfungstyp verschieben:',
    'do_not_save_connection'                => '(Verbindung nicht speichern)',
    'link_transaction'                      => 'Überweisung verknüpfen',
    'link_to_other_transaction'             => 'Diese Buchung mit einer anderen Zahlung verknüpfen',
    'select_transaction_to_link'            => 'Wählen Sie eine Buchung aus, mit der Sie diese Buchung verknüpfen möchten. Die Links werden derzeit in Firefly III nicht verwendet (außer dass sie angezeigt werden), aber es ist geplant, dies in Zukunft zu ändern. Verwenden Sie das Suchfeld, um eine Buchung entweder nach Titel oder nach ID auszuwählen. Wenn Sie benutzerdefinierte Link-Typen hinzufügen möchten, schauen Sie sich die Einstellungen an.',
    'this_transaction'                      => 'Diese Transaktion',
    'transaction'                           => 'Überweisung',
    'comments'                              => 'Kommentare',
    'link_notes'                            => 'Alle Notizen, die Sie über den Link speichern möchten.',
    'invalid_link_selection'                => 'Diese Buchungen konnten nicht verknüpft werden',
    'selected_transaction'                  => 'Ausgewählte Buchung',
    'journals_linked'                       => 'Buchungen wurden verknüpft.',
    'journals_error_linked'                 => 'Diese Buchungen sind bereits verknüpft.',
    'journals_link_to_self'                 => 'Sie können eine Buchung nicht mit sich selbst verknüpfen.',
    'journal_links'                         => 'Buchungsverknüpfungen',
    'this_withdrawal'                       => 'Diese Ausgabe',
    'this_deposit'                          => 'Diese Einnahme',
    'this_transfer'                         => 'Diese Umbuchung',
    'overview_for_link'                     => 'Übersicht für den Verknüpfungstyp „:name”',
    'source_transaction'                    => 'Ursprungsüberweisung',
    'link_description'                      => 'Linkbeschreibung',
    'destination_transaction'               => 'Zielüberweisung',
    'delete_journal_link'                   => 'Löscht die Verknüpfung zwischen <a href=":source_link">:source</a> und <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Verknüpfung löschen',

    // link translations:
    'Paid_name'                             => 'Bezahlt',
    'Refund_name'                           => 'Rückzahlung',
    'Reimbursement_name'                    => 'Rückzahlung',
    'Related_name'                          => 'Zugehörig',
    'relates to_inward'                     => 'bezieht sich auf',
    'is (partially) refunded by_inward'     => 'wird (teilweise) erstattet durch',
    'is (partially) paid for by_inward'     => 'wird (teilweise) bezahlt durch',
    'is (partially) reimbursed by_inward'   => 'wird (teilweise) beglichen durch',
    'inward_transaction'                    => 'Eingehende Zahlung',
    'outward_transaction'                   => 'Ausgehende Zahlung',
    'relates to_outward'                    => 'bezieht sich auf',
    '(partially) refunds_outward'           => 'erstattet (teilweise)',
    '(partially) pays for_outward'          => 'zahlt (teilweise) für',
    '(partially) reimburses_outward'        => 'begleicht (teilweise)',
    'is (partially) refunded by'            => 'wird (teilweise) erstattet durch',
    'is (partially) paid for by'            => 'wird (teilweise) bezahlt durch',
    'is (partially) reimbursed by'          => 'wird (teilweise) beglichen durch',
    'relates to'                            => 'bezieht sich auf',
    '(partially) refunds'                   => 'erstattet (teilweise)',
    '(partially) pays for'                  => 'zahlt (teilweise) für',
    '(partially) reimburses'                => 'begleicht (teilweise)',

    // split a transaction:
    'splits'                                => 'Teile',
    'add_another_split'                     => 'Eine weitere Aufteilung hinzufügen',
    'cannot_edit_opening_balance'           => 'Sie können die Eröffnungsbilanz eines Kontos nicht bearbeiten.',
    'no_edit_multiple_left'                 => 'Sie haben keine gültigen Buchungen zur Bearbeitung ausgewählt.',
    'breadcrumb_convert_group'              => 'Buchung umwandeln',
    'convert_invalid_source'                => 'Die Quellinformationen sind für Buchung #%d ungültig.',
    'convert_invalid_destination'           => 'Die Zielinformationen sind für Buchung „#%d” ungültig.',
    'create_another'                        => 'Nach dem Speichern hierher zurückkehren, um ein weiteres zu erstellen.',
    'after_update_create_another'           => 'Nach dem Aktualisieren hierher zurückkehren, um weiter zu bearbeiten.',
    'store_as_new'                          => 'Als neue Buchung speichern statt zu aktualisieren.',
    'reset_after'                           => 'Formular nach der Übermittlung zurücksetzen',
    'errors_submission'                     => 'Bei Ihren Eingaben stimmt etwas nicht. Bitte überprüfen Sie die unten stehenden Fehler.',
    'errors_submission_v2'                  => 'Bei Ihrer Übermittlung ist ein Fehler aufgetreten. Bitte überprüfen Sie die unten stehenden Fehler: {{errorMessage}}',
    'transaction_expand_split'              => 'Aufteilung erweitern',
    'transaction_remove_split'              => 'Teilung entfernen',
    'transaction_collapse_split'            => 'Aufteilung reduzieren',

    // object groups
    'default_group_title_name'              => '(ohne Gruppierung)',
    'default_group_title_name_plain'        => 'ungruppiert',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Lassen Sie uns jetzt ein Bestandskonto anlegen!',
    'no_accounts_intro_asset'               => 'Sie verfügen noch über keine Bestandskonten. Bestandskonten sind Ihre Hauptkonten: Ihr Girokonto, Sparkonto, Gemeinschaftskonto oder sogar Ihre Kreditkarte.',
    'no_accounts_imperative_asset'          => 'Um Firefly III nutzen zu können, müssen Sie mindestens ein Bestandskonto anlegen. Lassen Sie uns das jetzt tun:',
    'no_accounts_create_asset'              => 'Bestandskonto anlegen',
    'no_accounts_title_expense'             => 'Lassen Sie uns jetzt ein Ausgabenkonto anlegen!',
    'no_accounts_intro_expense'             => 'Sie besitzen noch keine Ausgabenkonten. Ausgabenkonten sind die Orte, an denen Sie Geld ausgeben, wie z.B. in Geschäften und Supermärkten.',
    'no_accounts_imperative_expense'        => 'Ausgabenkonten werden beim Anlegen von Buchungen automatisch angelegt, können aber auch manuell angelegt werden. Lassen Sie uns jetzt eines erstellen:',
    'no_accounts_create_expense'            => 'Ein Ausgabenkonto anlegen',
    'no_accounts_title_revenue'             => 'Lassen Sie uns jetzt ein Einnahmenkonto anlegen!',
    'no_accounts_intro_revenue'             => 'Sie verfügen noch über keine Einnahmekonten. Einnahmekonten sind die Einrichtungen, von denen Sie Geld erhalten, wie z.B. von Ihrem Arbeitgeber.',
    'no_accounts_imperative_revenue'        => 'Einnahmekonten werden beim Anlegen von Buchungen automatisch angelegt, können aber auch manuell angelegt werden. Lassen Sie uns jetzt eines erstellen:',
    'no_accounts_create_revenue'            => 'Neues Einnahmenkonto erstellen',
    'no_accounts_title_liabilities'         => 'Lassen Sie uns eine Verbindlichkeit einrichten!',
    'no_accounts_intro_liabilities'         => 'Sie verfügen noch über keine Verbindlichkeiten. Verbindlichkeiten sind die Konten, die Ihre (Studenten-)Darlehen und andere Forderungen verwalten.',
    'no_accounts_imperative_liabilities'    => 'Sie müssen diese Funktion nicht verwenden, aber sie kann nützlich sein, wenn Sie diese Dinge im Auge behalten möchten.',
    'no_accounts_create_liabilities'        => 'Verbindlichkeit erstellen',
    'no_budgets_title_default'              => 'Lassen Sie uns jetzt ein Budget erstellen',
    'no_rules_title_default'                => 'Lassen Sie uns eine Regel erstellen',
    'no_budgets_intro_default'              => 'Sie verfügen noch über keinen Budgets. Budgets werden verwendet, um Ihre Ausgaben in logische Gruppen zu gliedern, die Sie mit einem weichen Limit versehen können, um Ihre Ausgaben zu begrenzen.',
    'no_rules_intro_default'                => 'Sie haben noch keine Regeln. Regeln sind mächtige Automatisierungen, die Transaktionen für Sie verarbeiten können.',
    'no_rules_imperative_default'           => 'Regeln können sehr nützlich sein, wenn Sie Transaktionen verwalten. Lassen Sie uns jetzt eine erstellen:',
    'no_budgets_imperative_default'         => 'Budgets sind die grundlegenden Instrumente des Finanzmanagements. Lassen Sie uns jetzt eines erstellen:',
    'no_budgets_create_default'             => 'Budget erstellen',
    'no_rules_create_default'               => 'Eine Regel erstellen',
    'no_categories_title_default'           => 'Erstellen wir eine Kategorie!',
    'no_categories_intro_default'           => 'Sie verfügen noch über keine Kategorien. Kategorien werden verwendet, um Ihre Buchungen zu verfeinern und mit der entsprechenden Kategorie zu kennzeichnen.',
    'no_categories_imperative_default'      => 'Kategorien werden automatisch angelegt, wenn Sie Buchungen anlegen, können aber auch manuell angelegt werden. Lassen Sie uns jetzt eine erstellen:',
    'no_categories_create_default'          => 'Eine Kategorie erstellen',
    'no_tags_title_default'                 => 'Lassen Sie uns jetzt ein Schlagwort anlegen!',
    'no_tags_intro_default'                 => 'Sie haben noch keine Schlagwörter angelegt. Schlagwörter werden verwendet, um Ihre Umsätze zu verfeinern und mit bestimmten Schlüsselwörtern zu versehen.',
    'no_tags_imperative_default'            => 'Schlagwörter werden automatisch erstellt, wenn Sie Buchungen anlegen, aber Sie können sie auch manuell erstellen. Lassen Sie uns jetzt eines erstellen:',
    'no_tags_create_default'                => 'Neues Schlagwort erstellen',
    'no_transactions_title_withdrawal'      => 'Lassen Sie uns jetzt eine Auslage erstellen!',
    'no_transactions_intro_withdrawal'      => 'Sie haben noch keine Ausgaben verbucht. Sie sollten Ausgabenseinträge erstellen, um Ihre Finanzen zu verwalten.',
    'no_transactions_imperative_withdrawal' => 'Haben Sie Geld ausgegeben? Dann sollten Sie es aufschreiben:',
    'no_transactions_create_withdrawal'     => 'Eine neue Ausgabe erstellen',
    'no_transactions_title_deposit'         => 'Lassen Sie uns nun einige Einnahmen erstellen!',
    'no_transactions_intro_deposit'         => 'Sie haben noch keine Einnahmen verbucht. Sie sollten Einkommenseinträge erstellen, um Ihre Finanzen zu verwalten.',
    'no_transactions_imperative_deposit'    => 'Haben Sie Geld erhalten? Dann sollten Sie es aufschreiben:',
    'no_transactions_create_deposit'        => 'Eine Einnahme erstellen',
    'no_transactions_title_transfers'       => 'Erstellen wir eine Umbuchung!',
    'no_transactions_intro_transfers'       => 'Sie verfügen noch über keine Umbuchungen. Wenn Sie Geld zwischen Bestandskonten verschieben, wird es als Umbuchung erfasst.',
    'no_transactions_imperative_transfers'  => 'Haben Sie Geld umgebucht? Dann sollten Sie es eintragen:',
    'no_transactions_create_transfers'      => 'Eine Umbuchung erstellen',
    'no_piggies_title_default'              => 'Lassen Sie uns nun ein Sparschwein erstellen!',
    'no_piggies_intro_default'              => 'Sie haben noch keine Sparschweine. Sie können Sparschweine erstellen, um Ihre Ersparnisse zu teilen und den Überblick darüber zu behalten, wofür Sie sparen.',
    'no_piggies_imperative_default'         => 'Haben Sie Dinge, auf die Sie sparen? Erstellen Sie ein Sparschwein und behalten Sie den Überblick:',
    'no_piggies_create_default'             => 'Ein neues Sparschwein erstellen',
    'no_bills_title_default'                => 'Lassen Sie uns ein Abonnement einrichten!',
    'no_bills_intro_default'                => 'Es wurden noch keine Abonnements eingerichtet. Sie können Abonnements erstellen, um regelmäßige Ausgaben wie Ihre Miete oder Versicherung im Blick zu behalten.',
    'no_bills_imperative_default'           => 'Sie haben solche regelmäßigen Abonnements? Erstellen Sie ein Abonnement und behalten Sie den Überblick über Ihre Zahlungen:',
    'no_bills_create_default'               => 'Abonnement erstellen',

    // recurring transactions
    'recurrence_max_count'                  => 'Diese wiederkehrenden Buchungen werden höchstens :max mal erstellt, und wurden bereits :count mal erstellt.',
    'create_right_now'                      => 'Jetzt erstellen',
    'no_new_transaction_in_recurrence'      => 'Es wurde keine neue Buchung erstellt. Vielleicht wurde sie für dieses Datum bereits ausgelöst?',
    'recurrences'                           => 'Daueraufträge',
    'repeat_until_in_past'                  => 'Diese wiederkehrende Buchung wiederholte ab dem :date nicht mehr.',
    'recurring_calendar_view'               => 'Kalender',
    'no_recurring_title_default'            => 'Lassen Sie uns einen Dauerauftrag erstellen!',
    'no_recurring_intro_default'            => 'Sie haben noch keine Daueraufträge erstellt. Diese können Sie nutzen, um automatisch Buchungen von Firefly III erstellen zu lassen.',
    'no_recurring_imperative_default'       => 'Dies ist eine sehr fortschrittliche Funktion, welche aber sehr nützlich sein kann. Stellen Sie sicher, dass Sie die Dokumentation (❓-Symbol in der oberen rechten Ecke) lesen, bevor Sie fortfahren.',
    'no_recurring_create_default'           => 'Dauerauftrag erstellen',
    'make_new_recurring'                    => 'Dauerauftrag erstellen',
    'recurring_daily'                       => 'Täglich',
    'recurring_weekly'                      => 'Wöchentlich am :weekday',
    'recurring_weekly_skip'                 => 'Jede :skip(./././.) Woche am :weekday',
    'recurring_monthly'                     => 'An jedem :dayOfMonth. Tag des Monats',
    'recurring_monthly_skip'                => 'Jeden :skip(./././.) Monat am :dayOfMonth(./././.) Tag',
    'recurring_ndom'                        => 'An jedem :dayOfMonth. :weekday',
    'recurring_ndom_skip'                   => 'Jeden :skip(st/nd/rd/th) Monat am :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Jährlich am :date',
    'overview_for_recurrence'               => 'Übersicht der Daueraufträge „:title”',
    'warning_duplicates_repetitions'        => 'In seltenen Fällen werden die Daten zweimal in dieser Liste angezeigt. Dies kann passieren, wenn mehrere Wiederholungen aufeinandertreffen. Firefly III erzeugt immer eine Transaktion pro Tag.',
    'created_transactions'                  => 'Ähnliche Buchungen',
    'expected_withdrawals'                  => 'Erwartete Rückzahlungen',
    'expected_deposits'                     => 'Erwartete Einnahmen',
    'expected_transfers'                    => 'Erwartete Überweisungen',
    'created_withdrawals'                   => 'Erstellte Rückzahlungen',
    'created_deposits'                      => 'Erstellte Einnahmen',
    'created_transfers'                     => 'Erstellte Überweisungen',
    'recurring_info'                        => 'Dauerauftrag :count/:total',
    'created_from_recurrence'               => 'Erstellt aus Dauerauftrag „:title” (#:id)',
    'recurring_never_cron'                  => 'Es scheint, dass der Cron-Job, der notwendig ist, um Daueraufträge zu unterstützen, nie ausgeführt wurde. Das ist natürlich normal, wenn Sie gerade Firefly III installiert haben, aber dies sollte so schnell wie möglich eingerichtet werden. Bitte besuchen Sie die Hilfeseiten über das ❓-Symbol in der oberen rechten Ecke der Seite.',
    'recurring_cron_long_ago'               => 'Es sieht so aus, als wäre es mehr als 36 Stunden her, dass der Cron-Job zur Unterstützung von Daueraufträgen zum letzten Mal ausgeführt wurde. Sind Sie sicher, dass es richtig eingestellt ist? Bitte schauen Sie sich die Hilfeseiten über dem ❓-Symbol oben rechts auf der Seite an.',

    'create_new_recurrence'              => 'Neuen Dauerauftrag erstellen',
    'help_first_date'                    => 'Geben Sie die erste erwartete Wiederholung an. Zeitpunkt muss in der Zukunft liegen.',
    'help_first_date_no_past'            => 'Geben Sie die erste erwartete Wiederholung an. Firefly III erzeugt keine Buchungen die in der Vergangenheit liegen.',
    'no_currency'                        => '(ohne Währung)',
    'mandatory_for_recurring'            => 'Erforderliche Wiederholungsinformationen',
    'mandatory_for_transaction'          => 'Erforderliche Buchungsinformationen',
    'optional_for_recurring'             => 'Optionale Wiederholungsinformationen',
    'optional_for_transaction'           => 'Optionale Buchungsinformationen',
    'change_date_other_options'          => 'Ändern Sie das „erste Datum”, um weitere Optionen anzuzeigen.',
    'mandatory_fields_for_tranaction'    => 'Diese Werte enden in der/den zu erstellenden Buchung(en)',
    'click_for_calendar'                 => 'Klicken Sie hier für einen Kalender, der Ihnen anzeigt, wann sich die Buchung wiederholen würde.',
    'repeat_forever'                     => 'Wiederholt sich für immer',
    'repeat_until_date'                  => 'Wiederholen bis Datum',
    'repeat_times'                       => 'Wiederholen Sie mehrmals',
    'recurring_skips_one'                => 'Alle anderen',
    'recurring_skips_more'               => 'Überspringt :count Vorgänge',
    'store_new_recurrence'               => 'Dauerauftrag speichern',
    'stored_new_recurrence'              => 'Dauerauftrag „:title” erfolgreich gespeichert.',
    'edit_recurrence'                    => 'Dauerauftrag „:title” bearbeiten',
    'recurring_repeats_until'            => 'Wiederholt sich bis :date',
    'recurring_repeats_forever'          => 'Wiederholt sich für immer',
    'recurring_repeats_x_times'          => 'Wiederholt :count mal|Wiederholt :count mal',
    'update_recurrence'                  => 'Dauerauftrag aktualisieren',
    'updated_recurrence'                 => 'Dauerauftrag ":title" aktualisiert',
    'recurrence_is_inactive'             => 'Dieser Dauerauftrag ist nicht aktiv und erzeugt keine neuen Buchungen.',
    'delete_recurring'                   => 'Dauerauftrag „:title” löschen',
    'new_recurring_transaction'          => 'Neuer Dauerauftrag',
    'help_weekend'                       => 'Was sollte Firefly III tun, wenn der Dauerauftrag auf einen Samstag oder Sonntag fällt?',
    'do_nothing'                         => 'Einfach die Buchung anlegen',
    'skip_transaction'                   => 'Ereignis überspringen',
    'jump_to_friday'                     => 'Die Buchung stattdessen am vorhergehenden Freitag ausführen',
    'jump_to_monday'                     => 'Die Buchung stattdessen am darauffolgenden Montag ausführen',
    'will_jump_friday'                   => 'Wird am Freitag statt am Wochenende ausgeführt.',
    'will_jump_monday'                   => 'Wird am Montag statt am Wochenende ausgeführt.',
    'except_weekends'                    => 'Außer an Wochenenden',
    'recurrence_deleted'                 => 'Dauerauftrag „:title” gelöscht',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Guthaben (:currency)',
    'box_spent_in_currency'              => 'Ausgaben (:currency)',
    'box_earned_in_currency'             => 'Einnahmen (:currency)',
    'box_budgeted_in_currency'           => 'Eingeplant (:currency)',
    'box_bill_paid_in_currency'          => 'Bezahlte Abonnements (:currency)',
    'box_bill_unpaid_in_currency'        => 'Unbezahlte Abonnements (:currency)',
    'box_left_to_spend_in_currency'      => 'Verbleibend zum Ausgeben (:currency)',
    'box_net_worth_in_currency'          => 'Eigenkapital (:currency)',
    'box_spend_per_day'                  => 'Pro Tag verbleibend zum Ausgeben: :amount',

    // debug page
    'debug_page'                         => 'Fehlersuche-Seite',
    'debug_submit_instructions'          => 'Wenn Sie auf Probleme stoßen, können Sie die Informationen in diesem Feld als Fehlerbehebungsinformationen verwenden. Bitte kopieren Sie die Informationen per Kopieren und Einfügen in ein neues oder bestehendes <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. Dadurch wird eine übersichtliche Tabelle erzeugt, die zur schnellen Diagnose Ihres Problems verwendet werden kann.',
    'debug_pretty_table'                 => 'Wenn Sie das Feld unten in eine GitHub-Ausgabe kopieren/einfügen, wird eine Tabelle generiert. Bitte diesen Text nicht in Backticks oder Anführungszeichen setzen.',
    'debug_additional_data'              => 'Sie können auch den Inhalt des Feldes unten freigeben. Sie können ihn auch durch Kopieren und Einfügen in eine neue oder bestehende <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub-Ausgabe</a> einfügen. Der Inhalt dieses Feldes kann jedoch private Informationen wie Kontonamen, Transaktionsdetails oder E-Mail-Adressen enthalten.',

    // object groups
    'object_groups_menu_bar'             => 'Gruppen',
    'object_groups_page_title'           => 'Gruppen',
    'object_groups_breadcrumb'           => 'Gruppen',
    'object_groups_index'                => 'Übersicht',
    'object_groups'                      => 'Gruppen',
    'object_groups_empty_explain'        => 'Einige Dinge in Firefly III lassen sich in Gruppen einteilen. Sparschweine zum Beispiel verfügen über ein Feld "Gruppe" in den Bearbeitungs- und Erstellungsmasken. Wenn Sie dieses Feld einstellen, können Sie die Namen und die Reihenfolge der Gruppen auf dieser Seite bearbeiten. Weitere Informationen finden Sie auf den Hilfeseiten oben rechts unter dem ❓-Symbol.',
    'object_group_title'                 => 'Titel',
    'edit_object_group'                  => 'Gruppe „:title” bearbeiten',
    'delete_object_group'                => 'Gruppe „:title” löschen',
    'update_object_group'                => 'Gruppe aktualisieren',
    'updated_object_group'               => 'Gruppe „:title” erfolgreich aktualisiert',
    'deleted_object_group'               => 'Gruppe „:title” erfolgreich entfernt',
    'object_group'                       => 'Gruppe',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audit-Logeinträge',
    'ale_action_log_add'                 => ':amount zum Sparschwein ":name" hinzugefügt',
    'ale_action_log_remove'              => ':amount aus Sparschwein ":name " entfernt',
    'ale_action_clear_budget'            => 'Aus Budget entfernt',
    'ale_action_update_group_title'      => 'Titel der Buchungsgruppe aktualisiert',
    'ale_action_update_date'             => 'Buchungsdatum aktualisiert',
    'ale_action_update_order'            => 'Buchungsreihenfolge aktualisiert',
    'ale_action_clear_category'          => 'Aus Kategorie entfernt',
    'ale_action_clear_notes'             => 'Notiz entfernt',
    'ale_action_clear_tag'               => 'Schlagwort geleert',
    'ale_action_clear_all_tags'          => 'Alle Schlagwörter geleert',
    'ale_action_set_bill'                => 'Verbunden mit einem Abonnement',
    'ale_action_switch_accounts'         => 'Quell- und Zielkonto getauscht',
    'ale_action_set_budget'              => 'Budget festlegen',
    'ale_action_set_category'            => 'Kategorie festlegen',
    'ale_action_set_source'              => 'Quellkonto festlegen',
    'ale_action_set_destination'         => 'Zielkonto festlegen',
    'ale_action_update_transaction_type' => 'Buchungstyp geändert',
    'ale_action_update_notes'            => 'Notizen aktualisiert',
    'ale_action_update_description'      => 'Beschreibung geändert',
    'ale_action_add_to_piggy'            => 'Sparschwein',
    'ale_action_remove_from_piggy'       => 'Sparschwein',
    'ale_action_add_tag'                 => 'Schlagwort hinzugefügt',
    'ale_action_update_amount'           => 'Betrag aktualisiert',

    // dashboard
    'enable_auto_convert'                => 'Währungsumrechnung aktivieren',
    'disable_auto_convert'               => 'Währungsumrechnung deaktivieren',
];
