<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Închide',
    'actions'                                   => 'Acțiuni',
    'edit'                                      => 'Editează',
    'loading'                                   => 'Se încarcă',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Șterge',
    'split'                                     => 'Împarte',
    'single_split'                              => 'Împarte',
    'clone'                                     => 'Clonă',
    'clone_and_edit'                            => 'Clonează și editează',
    'confirm_action'                            => 'Confirmare acțiune',
    'last_seven_days'                           => 'Ultimele 7 zile',
    'last_thirty_days'                          => 'Ultimele 30 de zile',
    'last_180_days'                             => 'Ultimele 180 de zile',
    'month_to_date'                             => 'Luna aceasta',
    'year_to_date'                              => 'De la începutul anului',
    'YTD'                                       => 'YTD',
    'welcome_back'                              => 'Ce se redă?',
    'main_dashboard_page_title'                 => 'Acasă',
    'everything'                                => 'Tot',
    'today'                                     => 'Azi',
    'customRange'                               => 'Intervalul personalizat',
    'date_range'                                => 'Interval de date',
    'apply'                                     => 'Aplică',
    'select_date'                               => 'Selectează data..',
    'cancel'                                    => 'Anulare',
    'from'                                      => 'De la',
    'to'                                        => 'Către',
    'structure'                                 => 'Structură',
    'help_translating'                          => 'Acest text de ajutor nu este încă disponibil în limba dvs.',
    'showEverything'                            => 'Afișați totul',
    'never'                                     => 'Niciodată',
    'no_results_for_empty_search'               => 'Căutarea dvs. a fost goală, deci nu a fost găsit nimic.',
    'removed_amount'                            => ':amount eliminată',
    'added_amount'                              => ':amount adaugată',
    'asset_account_role_help'                   => 'Opțiunile suplimentare rezultate din alegerea dvs. pot fi setate mai târziu.',
    'Opening balance'                           => 'Soldul de deschidere',
    'create_new_stuff'                          => 'Creați lucruri noi',
    'new_withdrawal'                            => 'Tranzacție nouă',
    'create_new_transaction'                    => 'Creați o tranzacție nouă',
    'sidebar_frontpage_create'                  => 'Crează',
    'new_transaction'                           => 'Tranzacţie nouă',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Vizualizați conturile de active',
    'go_to_budgets'                             => 'Mergi la bugete',
    'go_to_withdrawals'                         => 'Mergi la retragerile tale',
    'clones_journal_x'                          => 'Această tranzacție este o clonă a ":description" (#:id)',
    'go_to_categories'                          => 'Mergi la categorii',
    'go_to_bills'                               => 'Go to your subscriptions',
    'go_to_expense_accounts'                    => 'Vezi cheltuielile contabile',
    'go_to_revenue_accounts'                    => 'Vezi contul de venituris',
    'go_to_piggies'                             => 'Mergi la pușculiță',
    'new_deposit'                               => 'Depunere nouă',
    'new_transfer'                              => 'Transfer nou',
    'new_transfers'                             => 'Transferuri noi',
    'new_asset_account'                         => 'Cont nou de activ',
    'new_expense_account'                       => 'Cont nou de cheltuieli',
    'new_revenue_account'                       => 'Cont nou pentru venituri',
    'new_liabilities_account'                   => 'Provizion nou',
    'new_budget'                                => 'Buget nou',
    'new_bill'                                  => 'Abonament nou',
    'block_account_logout'                      => 'Ai fost deconectat. Conturile blocate nu pot utiliza acest site. Ați înregistrat o adresă de e-mail validă?',
    'flash_success'                             => 'Succes!',
    'flash_info'                                => 'Mesaj',
    'flash_warning'                             => 'Avertizare!',
    'flash_error'                               => 'Eroare!',
    'flash_danger'                              => 'Pericol!',
    'flash_info_multiple'                       => 'Există un mesaj | Există :count mesaje',
    'flash_error_multiple'                      => 'Există o singură eroare | Există :count erori',
    'net_worth'                                 => 'Valoarea netă',
    'help_for_this_page'                        => 'Ajutor pentru această pagină',
    'help_for_this_page_body'                   => 'Mai multe informații despre această pagină <a href="https://docs.firefly-iii.org/">în documentația</a>.',
    'two_factor_welcome'                        => 'Bună ziua!',
    'two_factor_enter_code'                     => 'Pentru a continua, introduceți codul dvs. de autentificare cu doi factori. Aplicația dvs. o poate genera pentru dvs.',
    'two_factor_code_here'                      => 'Introdu codul aici',
    'two_factor_title'                          => 'Autentificare cu doi factori',
    'authenticate'                              => 'Autentificare',
    'two_factor_forgot_title'                   => 'S-a pierdut autentificarea cu doi factori',
    'two_factor_forgot'                         => 'Am uitat autentificarea cu doi factori.',
    'two_factor_lost_header'                    => 'Ai uitat autentificarea cu doi factori?',
    'two_factor_lost_intro'                     => 'Dacă ați pierdut și codurile de rezervă, aveți ghinion. Nu este un lucru pe care îl puteți remedia din interfața web. Aveți două opțiuni.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'În caz contrar, trimiteți prin e-mail proprietarului site-ului <a href="mailto::site_owner">: proprietarul site-ului </a> și solicitați-i să reseteze autentificarea cu doi factori.',
    'mfa_backup_code'                           => 'You have used a backup code to login to Firefly III. It can\'t be used again, so cross it from your list.',
    'pref_two_factor_new_backup_codes'          => 'Obțineți noi coduri de rezervă',
    'pref_two_factor_backup_code_count'         => 'Aveți :count cod valid pentru copia de rezervă. Aveți :count coduri de rezervă valide.',
    '2fa_i_have_them'                           => 'Le-am depozitat!',
    'warning_much_data'                         => ':days zilele de date pot dura o perioadă până încărcare.',
    'registered'                                => 'Te-ai înregistrat cu succes!',
    'Default asset account'                     => 'Cont de active implicit',
    'no_budget_pointer'                         => 'Se pare că nu aveți încă bugete. Ar trebui să creați câteva pe pagina <a href="/budgets">bugete</a>. Bugetele vă pot ajuta să țineți evidența cheltuielilor.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Cont de economii',
    'Credit card'                               => 'Card de credit',
    'source_accounts'                           => 'Contul sursă | Conturi sursă',
    'destination_accounts'                      => 'Contul destinației | Conturile de destinație',
    'user_id_is'                                => 'ID-ul dvs. de utilizator este <strong>:user</strong>',
    'field_supports_markdown'                   => 'Acest câmp acceptă <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown HTML</a>.',
    'need_more_help'                            => 'Dacă aveți nevoie de ajutor suplimentar, deschideți <a href="https://github.com/firefly-iii/firefly-iii/issues">un tichet pe Github</a>.',
    'reenable_intro_text'                       => 'De asemenea, puteți să activați din nou <a href="#" id="reenableGuidance"> ghidul de introducere </a>.',
    'intro_boxes_after_refresh'                 => 'Cutiile de introducere vor apărea din nou atunci când actualizați pagina.',
    'show_all_no_filter'                        => 'Afișați toate tranzacțiile fără a le grupa după dată.',
    'expenses_by_category'                      => 'Cheltuieli pe categorii',
    'expenses_by_budget'                        => 'Cheltuieli pe buget',
    'income_by_category'                        => 'Venituri pe categorii',
    'expenses_by_asset_account'                 => 'Cheltuieli pe cont de activ',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Nu vă putem redirecționa către pagina corectă. Scuze.',
    'sum_of_expenses'                           => 'Suma cheltuielilor',
    'sum_of_income'                             => 'Suma veniturilor',
    'liabilities'                               => 'Provizioane',
    'spent_in_specific_budget'                  => 'Cheltuit în bugetul ":budget"',
    'spent_in_specific_double'                  => 'Cheltuit în contul ":account"',
    'earned_in_specific_double'                 => 'Câștigat în contul ":account"',
    'source_account'                            => 'Contul sursă',
    'source_account_reconciliation'             => 'Nu puteți edita contul sursă al unei tranzacții de reconciliere.',
    'destination_account'                       => 'Contul de destinație',
    'destination_account_reconciliation'        => 'Nu puteți edita contul de destinație al unei tranzacții de reconciliere.',
    'sum_of_expenses_in_budget'                 => 'Cheltuielile totale în bugetul ":budget"',
    'left_in_budget_limit'                      => 'Rest de chetuit ăn funcție de buget',
    'current_period'                            => 'Perioada curentă',
    'show_the_current_period_and_overview'      => 'Afișați perioada curentă și prezentarea generală',
    'pref_languages_locale'                     => 'Pentru ca o altă limbă decât limba engleză să funcționeze corect, sistemul dvs. de operare trebuie să fie dotat cu informațiile de localizare corecte. Dacă acestea nu sunt prezente, datele valutare, datele și sumele pot fi formatate greșit.',
    'budget_in_period'                          => 'Toate tranzacțiile pentru bugetul ":name" între :start și :end în :currency',
    'chart_budget_in_period'                    => 'Graficul cu toate tranzacțiile pentru bugetul ":name" între :start și :end în :currency',
    'chart_budget_in_period_only_currency'      => 'Suma bugetată a fost în :currency, astfel încât acest grafic va afișa numai tranzacții în :currency.',
    'chart_account_in_period'                   => 'Graficul cu toate tranzacțiile pentru contul ":name" (:balance) între :start și :end',
    'chart_category_in_period'                  => 'Graficul cu toate tranzacțiile pentru categoria ":name" între :start și :end',
    'chart_category_all'                        => 'Graficul cu toate tranzacțiile pentru categoria ":name"',
    'clone_withdrawal'                          => 'Clonați această retragere',
    'clone_deposit'                             => 'Clonați această depozit',
    'clone_transfer'                            => 'Clonați această transfer',
    'multi_select_no_selection'                 => 'Nimic selectat',
    'multi_select_select_all'                   => 'Selectează tot',
    'multi_select_n_selected'                   => 'selectat',
    'multi_select_all_selected'                 => 'Toate selectate',
    'multi_select_filter_placeholder'           => 'Gasește..',
    'intro_next_label'                          => 'Următor',
    'intro_prev_label'                          => 'Anterior',
    'intro_skip_label'                          => 'Treci peste',
    'intro_done_label'                          => 'Finalizat',
    'between_dates_breadcrumb'                  => 'între :start și :end',
    'all_journals_without_budget'               => 'Toate tranzacțiile fără un buget',
    'journals_without_budget'                   => 'Tranzacții fără un buget',
    'all_journals_without_category'             => 'Toate tranzacțiile fără o categorie',
    'journals_without_category'                 => 'Tranzacții fără o categorie',
    'all_journals_for_account'                  => 'Toate tranzacțiile pentru contul :name',
    'chart_all_journals_for_account'            => 'Graficul tuturor tranzacțiilor pentru contul :name',
    'journals_in_period_for_account'            => 'Toate tranzacțiile pentru contul :name între :start și :end',
    'journals_in_period_for_account_js'         => 'Toate tranzacțiile pentru contul {title} între {start} și {end}',
    'transferred'                               => 'Transferat',
    'all_withdrawal'                            => 'Toate cheltuielile',
    'all_transactions'                          => 'Toate tranzacțiile',
    'title_withdrawal_between'                  => 'Toate cheltuielile între :start și :end',
    'all_deposit'                               => 'Toate veniturile',
    'title_deposit_between'                     => 'Toate veniturile între :start și :end',
    'all_transfers'                             => 'Toate transferurile',
    'title_transfers_between'                   => 'Toate transferurile între :start și :end',
    'all_transfer'                              => 'Toate transferurile',
    'all_journals_for_tag'                      => 'Toate tranzacțiile pentru eticheta ":tag"',
    'title_transfer_between'                    => 'Toate transferurile între :start și :end',
    'all_journals_for_category'                 => 'Toate tranzacțiile pentru categoria :name',
    'all_journals_for_budget'                   => 'Toate tranzacțiile pentru bugetul :name',
    'chart_all_journals_for_budget'             => 'Graficul cu toate tranzacțiile pentru bugetul :name',
    'journals_in_period_for_category'           => 'Toate tranzacțiile pentru categoria :name între :start și :end',
    'journals_in_period_for_tag'                => 'Toate tranzacțiile pentru eticheta :tag între :start și :end',
    'not_available_demo_user'                   => 'Funcția pe care încercați să o accesați nu este disponibilă pentru demo.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Sursa contului de active "@source_name" acceptă numai tranzacțiile în @source_currency. Destinația contului de active "@dest_name" acceptă numai tranzacțiile în @dest_currency. Trebuie să furnizați corect suma transferată în ambele valute.',
    'transaction_data'                          => 'Datele tranzacției',
    'invalid_server_configuration'              => 'Configurația serverului este nevalidă',
    'invalid_locale_settings'                   => 'Firefly III nu poate formata sumele deoarece serverului dumneavoastră îi lipsesc pachetele necesare. Există instrucțiuni <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">cum să faci acest lucru</a>.',
    'quickswitch'                               => 'Schimbare rapida',
    'sign_in_to_start'                          => 'Logați-vă pentru a începe sesiunea',
    'sign_in'                                   => 'Logare',
    'register_new_account'                      => 'Înregistrați un nou cont',
    'forgot_my_password'                        => 'Am uitat parola',
    'problems_with_input'                       => 'Sunt probleme cu input-ul dvs.',
    'reset_password'                            => 'Reseteaza parola',
    'button_reset_password'                     => 'Reseteaza parola',
    'reset_button'                              => 'Reseteaza',
    'want_to_login'                             => 'Vreau sa mă loghez',
    'login_page_title'                          => 'Logare',
    'register_page_title'                       => 'Înregistrare',
    'forgot_pw_page_title'                      => 'Am uitat parola',
    'reset_pw_page_title'                       => 'Reseteaza parola',
    'cannot_reset_demo_user'                    => 'Nu puteți reseta parola utilizatorului demo.',
    'no_att_demo_user'                          => 'Utilizatorul demo nu poate încărca atașamente.',
    'button_register'                           => 'Înregistrare',
    'authorization'                             => 'Autorizare',
    'active_bills_only'                         => 'doar abonamentele active',
    'active_bills_only_total'                   => 'toate abonamentele active',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Costurile zilnice preconizate',
    'per_period_sum_1W'                         => 'Costurile săptămânale preconizate',
    'per_period_sum_1M'                         => 'Costuri lunare estimate',
    'per_period_sum_3M'                         => 'Costuri trimestriale preconizate',
    'per_period_sum_6M'                         => 'Costuri semestriale preconizate',
    'per_period_sum_1Y'                         => 'Costuri anuale preconizate',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'total așteptat',
    'reconciliation_account_name'               => ':name reconciliere (:currency)',
    'saved'                                     => 'Salvat',
    'advanced_options'                          => 'Opțiuni avansate',
    'advanced_options_explain'                  => 'Unele pagini din Firefly III au opțiuni avansate ascunse în spatele acestui buton. Această pagină nu are nimic extravagant aici, dar verifică celelalte!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',

    // Webhooks
    'webhooks'                                  => 'Webhook-uri',
    'webhooks_breadcrumb'                       => 'Webhook-uri',
    'webhooks_menu_disabled'                    => 'dezactivat',
    'no_webhook_messages'                       => 'Nu există mesaje webhook',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'După crearea tranzacției',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'După actualizarea tranzacției',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'După ștergerea tranzacției',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Detaliile tranzacției',
    'webhook_response_ACCOUNTS'                 => 'Detalii cont',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspectați',
    'create_new_webhook'                        => 'Creare webhook nou',
    'webhooks_create_breadcrumb'                => 'Creare webhook nou',
    'webhook_trigger_form_help'                 => 'Indicați despre ce eveniment va declanșa webhook',
    'webhook_response_form_help'                => 'Indicați ce trebuie să trimită webhook la URL.',
    'webhook_delivery_form_help'                => 'Care format trebuie să furnizeze datele webhook.',
    'webhook_active_form_help'                  => 'Webhook-ul trebuie să fie activ sau nu va fi apelat.',
    'stored_new_webhook'                        => 'Webhook-ul nou a fost stocat ":title"',
    'delete_webhook'                            => 'Șterge webhook',
    'deleted_webhook'                           => 'Webhook șters ":title"',
    'edit_webhook'                              => 'Editare webhook ":title"',
    'updated_webhook'                           => 'Webhook actualizat ":title"',
    'edit_webhook_js'                           => 'Editare webhook"{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'Webhook-ul a fost declanșat pe tranzacția indicată. Așteptați ca rezultatele să apară.',
    'webhook_messages'                          => 'Mesaj Webhook',
    'view_message'                              => 'Vizualizați mesajul',
    'view_attempts'                             => 'Vizualizare încercări eșuate',
    'message_content_title'                     => 'Conținutul mesajului Webhook',
    'message_content_help'                      => 'Acesta este conținutul mesajului care a fost trimis (sau a încercat) folosind acest webhook.',
    'attempt_content_title'                     => 'Încercări Webhook',
    'attempt_content_help'                      => 'Acestea sunt toate încercările nereușite ale acestui mesaj webhook de a remite la adresa URL configurată. După un anumit timp, Firefly III va înceta să mai încerce.',
    'no_attempts'                               => 'Nu există încercări nereușite. E un lucru bun!',
    'webhook_attempt_at'                        => 'Încercare la {moment}',
    'logs'                                      => 'Jurnale',
    'response'                                  => 'Răspuns',
    'visit_webhook_url'                         => 'Vizitaţi URL-ul webhook',
    'reset_webhook_secret'                      => 'Resetare secret webhook',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> a fost stocat.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") a fost actualizat.',

    // API access
    'authorization_request'                     => 'v: Solicitare de autorizare',
    'authorization_request_intro'               => 'Aplicația "<strong>:client</strong>solicită permisiunea de a accesa administrația financiară. Doriţi să autorizaţi <strong>:client</strong> pentru a accesa aceste înregistrări?',
    'authorization_request_site'                => 'Veți fi redirecționat către <code>:url</code> care va putea accesa datele dvs. Firefly III.',
    'authorization_request_invalid'             => 'Această cerere de acces nu este validă. Vă rugăm să nu mai urmați acest link din nou.',
    'scopes_will_be_able'                       => 'Această aplicație va fi capabilă să to:',
    'button_authorize'                          => 'Autorizează',
    'none_in_select_list'                       => '(nici unul)',
    'no_piggy_bank'                             => '(nicio pușculiță)',
    'name_in_currency'                          => ':name în :currency',
    'paid_in_currency'                          => 'Plătit în :currency',
    'unpaid_in_currency'                        => 'Neplătit în :currency',
    'is_alpha_warning'                          => 'Executaţi o versiune ALPHA. Fiţi atenţi la erori şi probleme.',
    'is_beta_warning'                           => 'Executaţi o versiune BETA. Fiţi atenţi la erori şi probleme.',
    'all_destination_accounts'                  => 'Conturi de destinație',
    'all_source_accounts'                       => 'Conturi sursă',
    'back_to_index'                             => 'Înapoi la index',
    'cant_logout_guard'                         => 'Firefly III nu vă poate deconecta.',
    'internal_reference'                        => 'Referință internă',

    // check for updates:
    'update_check_title'                        => 'Verifică actualizări',
    'admin_update_check_title'                  => 'Verificați automat actualizarea',
    'admin_update_check_explain'                => 'Firefly III poate căuta actualizări automat. Când activați această setare, acesta va contacta serverul de actualizare Firefly III pentru a vedea dacă este disponibilă o nouă versiune de Firefly III. Când este, veți primi o notificare. Puteți testa această notificare folosind butonul din dreapta. Vă rugăm să indicați mai jos dacă doriți ca Firefly III să verifice actualizările.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Intreabă-mă mai târziu',
    'updates_do_not_check'                      => 'Nu verificați actualizările',
    'updates_enable_check'                      => 'Activați verificarea pentru actualizări',
    'admin_update_check_now_title'              => 'Verificați actualizările acum',
    'admin_update_check_now_explain'            => 'Dacă apăsați butonul, Firefly III va vedea dacă versiunea curentă este cea mai recentă.',
    'check_for_updates_button'                  => 'Verifică acum!',
    'update_new_version_alert'                  => 'O nouă versiune de Firefly III este disponibilă. Dvs. aveți :your_version, ultima versiune este :new_version lansată în data de :date.',
    'update_version_beta'                       => 'Această versiune este o versiune BETA. Este posibil să aveți probleme.',
    'update_version_alpha'                      => 'Această versiune este o versiune ALFA. Este posibil să aveți probleme.',
    'update_current_dev_older'                  => 'Executați versiunea de dezvoltare ":version", care este mai veche decât ultima versiune :new_version. Vă rugăm să actualizați!',
    'update_current_dev_newer'                  => 'Executați versiunea de dezvoltare ":version", care este mai nouă decât cea mai recentă versiune :new_version.',
    'update_current_version_alert'              => 'Aveți versiunea :version, care este ultima disponibilă.',
    'update_newer_version_alert'                => 'Aveți versiunea :your_version, care este mai nouă decât cea mai recentă versiune, :new_version.',
    'update_check_error'                        => 'A apărut o eroare la verificarea actualizărilor: :error',
    'unknown_error'                             => 'Eroare necunoscută. Ne pare rău pentru asta.',
    'disabled_but_check'                        => 'Ai dezactivat verificarea actualizării. Așa că nu uita să verifici singur actualizările din când în când. Mulțumim!',
    'admin_update_channel_title'                => 'Actualizare canal',
    'admin_update_channel_explain'              => 'Firefly III are trei "canale" de actualizare, care determină cât de avansați sunteți în termeni de caracteristici, îmbunătățiri și bug-uri. Folosiți canalul „beta” dacă sunteți aventuroși și „alfa” atunci când vă place să trăiți periculos viața.',
    'update_channel_stable'                     => 'Stabil. Totul ar trebui să funcționeze așa cum este de așteptat.',
    'update_channel_beta'                       => 'Beta. Caracteristici noi, dar lucrurile pot fi stricate.',
    'update_channel_alpha'                      => 'Alfa. Aruncăm chestii și folosiți orice.',

    // search
    'search'                                    => 'Caută',
    'search_query'                              => 'Interogare',
    'search_found_transactions'                 => 'Firefly III a găsit :count tranzacție în :time secunde.| Firefly III a găsit :count tranzacții în :time secunde.',
    'search_found_more_transactions'            => 'Firefly III a găsit mai mult de :count tranzacții în :time secunde.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Acești parametri de căutare nu sunt valabili și au fost ignorați.',

    // old


    'search_modifier_date_on'                             => 'Data tranzacției este ":value"',
    'search_modifier_not_date_on'                         => 'Data tranzacției nu este ":value"',
    'search_modifier_reconciled'                          => 'Tranzacția este reconciliată',
    'search_modifier_not_reconciled'                      => 'Tranzacția nu este reconciliată',
    'search_modifier_id'                                  => 'ID-ul tranzacţiei este ":value"',
    'search_modifier_not_id'                              => 'ID-ul tranzacţiei nu este ":value"',
    'search_modifier_date_before'                         => 'Data tranzacției este înainte sau pe ":value"',
    'search_modifier_date_after'                          => 'Data tranzacției este după sau pe ":value"',
    'search_modifier_external_id_is'                      => 'ID extern este ":value"',
    'search_modifier_not_external_id_is'                  => 'ID extern nu este ":value"',
    'search_modifier_no_external_url'                     => 'Tranzacția nu are niciun URL extern',
    'search_modifier_no_external_id'                      => 'Tranzacția nu are un ID extern',
    'search_modifier_not_any_external_url'                => 'Tranzacția nu are niciun URL extern',
    'search_modifier_not_any_external_id'                 => 'Tranzacția nu are un ID extern',
    'search_modifier_any_external_url'                    => 'Tranzacția trebuie să aibă un (orice) URL extern',
    'search_modifier_any_external_id'                     => 'Tranzacția trebuie să aibă un (orice) ID extern',
    'search_modifier_not_no_external_url'                 => 'Tranzacția trebuie să aibă un (orice) URL extern',
    'search_modifier_not_no_external_id'                  => 'Tranzacția trebuie să aibă un (orice) ID extern',
    'search_modifier_internal_reference_is'               => 'Referința internă este ":value"',
    'search_modifier_not_internal_reference_is'           => 'Referința internă nu este ":value"',
    'search_modifier_description_starts'                  => 'Descrierea începe cu ":value"',
    'search_modifier_not_description_starts'              => 'Descrierea nu începe cu ":value"',
    'search_modifier_description_ends'                    => 'Descrierea se termină pe ":value"',
    'search_modifier_not_description_ends'                => 'Descrierea nu se termină pe ":value"',
    'search_modifier_description_contains'                => 'Descrierea conține ":value"',
    'search_modifier_not_description_contains'            => 'Descrierea nu conține ":value"',
    'search_modifier_description_is'                      => 'Descrierea este exact ":value"',
    'search_modifier_not_description_is'                  => 'Descrierea nu este exact ":value"',
    'search_modifier_currency_is'                         => 'Moneda tranzacției (străină) este ":value"',
    'search_modifier_not_currency_is'                     => 'Moneda tranzacţiei (străină) nu este ":value"',
    'search_modifier_foreign_currency_is'                 => 'Moneda străină a tranzacției este ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Moneda străină nu este ":value"',
    'search_modifier_has_attachments'                     => 'Tranzacția trebuie să aibă un atașament',
    'search_modifier_has_no_category'                     => 'Tranzacția nu trebuie să aibă nicio categorie',
    'search_modifier_not_has_no_category'                 => 'Tranzacția trebuie să aibă o (orice) categorie',
    'search_modifier_not_has_any_category'                => 'Tranzacția nu trebuie să aibă nicio categorie',
    'search_modifier_has_any_category'                    => 'Tranzacția trebuie să aibă o (orice) categorie',
    'search_modifier_has_no_budget'                       => 'Tranzacția nu trebuie să aibă un buget',
    'search_modifier_not_has_any_budget'                  => 'Tranzacția nu trebuie să aibă un buget',
    'search_modifier_has_any_budget'                      => 'Tranzacția trebuie să aibă un (orice) buget',
    'search_modifier_not_has_no_budget'                   => 'Tranzacția trebuie să aibă un (orice) buget',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'Tranzacția nu trebuie să aibă etichete',
    'search_modifier_not_has_any_tag'                     => 'Tranzacția nu trebuie să aibă etichete',
    'search_modifier_not_has_no_tag'                      => 'Tranzacția trebuie să aibă o (orice) etichetă',
    'search_modifier_has_any_tag'                         => 'Tranzacția trebuie să aibă o (orice) etichetă',
    'search_modifier_notes_contains'                      => 'Notele de tranzacție conțin ":value"',
    'search_modifier_not_notes_contains'                  => 'Notele de tranzacție nu conțin ":value"',
    'search_modifier_notes_starts'                        => 'Notele de tranzacție încep cu ":value"',
    'search_modifier_not_notes_starts'                    => 'Notele de tranzacție nu încep cu ":value"',
    'search_modifier_notes_ends'                          => 'Notele de tranzacție se termină cu ":value"',
    'search_modifier_not_notes_ends'                      => 'Notele de tranzacție nu se termină cu ":value"',
    'search_modifier_notes_is'                            => 'Notele de tranzacție sunt exact ":value"',
    'search_modifier_not_notes_is'                        => 'Notele de tranzacție nu sunt exact ":value"',
    'search_modifier_no_notes'                            => 'Tranzacția nu are note',
    'search_modifier_not_no_notes'                        => 'Tranzacția trebuie să aibă note',
    'search_modifier_any_notes'                           => 'Tranzacția trebuie să aibă note',
    'search_modifier_not_any_notes'                       => 'Tranzacția nu are note',
    'search_modifier_amount_is'                           => 'Suma este exact :value',
    'search_modifier_not_amount_is'                       => 'Suma nu este :value',
    'search_modifier_amount_less'                         => 'Suma este mai mică sau egală cu :value',
    'search_modifier_not_amount_more'                     => 'Suma este mai mică sau egală cu :value',
    'search_modifier_amount_more'                         => 'Suma este mai mare sau egală cu :value',
    'search_modifier_not_amount_less'                     => 'Suma este mai mare sau egală cu :value',
    'search_modifier_source_account_is'                   => 'Numele contului sursă este exact ":value"',
    'search_modifier_not_source_account_is'               => 'Numele contului sursă nu este ":value"',
    'search_modifier_source_account_contains'             => 'Numele contului sursă conține ":value"',
    'search_modifier_not_source_account_contains'         => 'Numele contului sursă nu conține ":value"',
    'search_modifier_source_account_starts'               => 'Numele contului sursă începe cu ":value"',
    'search_modifier_not_source_account_starts'           => 'Numele contului sursă nu începe cu ":value"',
    'search_modifier_source_account_ends'                 => 'Numele contului sursă se termină cu ":value"',
    'search_modifier_not_source_account_ends'             => 'Numele contului sursă nu se termină cu ":value"',
    'search_modifier_source_account_id'                   => 'ID-ul contului sursă este :value',
    'search_modifier_not_source_account_id'               => 'ID-ul contului sursă nu este :value',
    'search_modifier_source_account_nr_is'                => 'Numărul contului sursă (IBAN) este ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Numărul contului sursă (IBAN) nu este ":value"',
    'search_modifier_source_account_nr_contains'          => 'Numărul contului sursă (IBAN) conține ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Numărul contului sursă (IBAN) nu conține ":value"',
    'search_modifier_source_account_nr_starts'            => 'Numărul contului sursă (IBAN) începe cu ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Numărul contului sursă (IBAN) nu începe cu ":value"',
    'search_modifier_source_account_nr_ends'              => 'Numărul contului sursă (IBAN) se termină pe ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Numărul contului sursă (IBAN) nu se termină pe ":value"',
    'search_modifier_destination_account_is'              => 'Numele contului destinației este exact ":value"',
    'search_modifier_not_destination_account_is'          => 'Numele contului destinaţiei nu este ":value"',
    'search_modifier_destination_account_contains'        => 'Numele contului destinației conține ":value"',
    'search_modifier_not_destination_account_contains'    => 'Numele contului destinaţiei nu conţine ":value"',
    'search_modifier_destination_account_starts'          => 'Numele contului destinației începe cu ":value"',
    'search_modifier_not_destination_account_starts'      => 'Numele contului destinației nu începe cu ":value"',
    'search_modifier_destination_account_ends'            => 'Numele contului destinaţiei se termină pe ":value"',
    'search_modifier_not_destination_account_ends'        => 'Numele contului destinației nu se termină pe ":value"',
    'search_modifier_destination_account_id'              => 'ID-ul contului destinației este :value',
    'search_modifier_not_destination_account_id'          => 'ID-ul contului destinaţie nu este :value',
    'search_modifier_destination_is_cash'                 => 'Contul destinație este contul "(numerar)"',
    'search_modifier_not_destination_is_cash'             => 'Contul de destinație nu este un cont de numerar "(cash)"',
    'search_modifier_source_is_cash'                      => 'Contul sursă este contul "(cash)"',
    'search_modifier_not_source_is_cash'                  => 'Contul sursă este contul "(cash)"',
    'search_modifier_destination_account_nr_is'           => 'Numărul contului destinației (IBAN) este ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Numărul contului destinației (IBAN) este ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Numărul contului destinației (IBAN) conține ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Numărul contului destinației (IBAN) nu conține ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Numărul contului destinației (IBAN) începe cu ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Numărul contului destinației (IBAN) nu începe cu ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Numărul contului destinației (IBAN) se termină cu ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Numărul contului destinației (IBAN) nu se termină cu ":value"',
    'search_modifier_account_id'                          => 'ID-ul contului sursă sau destinație este/sunt: :value',
    'search_modifier_not_account_id'                      => 'ID-ul contului sursă sau destinație este/nu: :value',
    'search_modifier_category_is'                         => 'Categoria este ":value"',
    'search_modifier_not_category_is'                     => 'Categoria nu este ":value"',
    'search_modifier_budget_is'                           => 'Bugetul este ":value"',
    'search_modifier_not_budget_is'                       => 'Bugetul nu este ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Tipul tranzacției este ":value"',
    'search_modifier_not_transaction_type'                => 'Tipul de tranzacție nu este ":value"',
    'search_modifier_tag_is'                              => 'Eticheta este ":value"',
    'search_modifier_tag_contains'                        => 'Eticheta conţine ":value"',
    'search_modifier_not_tag_contains'                    => 'Eticheta nu conține ":value"',
    'search_modifier_tag_ends'                            => 'Eticheta se termină cu ":value"',
    'search_modifier_tag_starts'                          => 'Eticheta începe cu ":value"',
    'search_modifier_not_tag_is'                          => 'Nicio etichetă nu este ":value"',
    'search_modifier_date_on_year'                        => 'Tranzacția este în anul ":value"',
    'search_modifier_not_date_on_year'                    => 'Tranzacția nu este în anul ":value"',
    'search_modifier_date_on_month'                       => 'Tranzacția este în luna ":value"',
    'search_modifier_not_date_on_month'                   => 'Tranzacția nu este în luna ":value"',
    'search_modifier_date_on_day'                         => 'Tranzacția este în ziua lunii ":value"',
    'search_modifier_not_date_on_day'                     => 'Tranzacția nu este în ziua lunii ":value"',
    'search_modifier_date_before_year'                    => 'Tranzacția este înainte sau în anul ":value"',
    'search_modifier_date_before_month'                   => 'Tranzacția este înainte sau în luna ":value"',
    'search_modifier_date_before_day'                     => 'Tranzacția este înainte sau în ziua din luna ":value"',
    'search_modifier_date_after_year'                     => 'Tranzacția este în sau după anul ":value"',
    'search_modifier_date_after_month'                    => 'Tranzacția este în sau după luna ":value"',
    'search_modifier_date_after_day'                      => 'Tranzacția este după sau în ziua lunii ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Nicio etichetă nu este ":value"',
    'search_modifier_not_tag_is_not'                      => 'Eticheta este ":value"',
    'search_modifier_account_is'                          => 'Oricare cont este ":value"',
    'search_modifier_not_account_is'                      => 'Niciun cont nu este ":value"',
    'search_modifier_account_contains'                    => 'Fiecare cont conține ":value"',
    'search_modifier_not_account_contains'                => 'Nici unul dintre conturi nu conține ":value"',
    'search_modifier_account_ends'                        => 'Oricare cont se termină cu ":value"',
    'search_modifier_not_account_ends'                    => 'Nici unul dintre conturi nu se termină cu ":value"',
    'search_modifier_account_starts'                      => 'Oricare cont începe cu ":value"',
    'search_modifier_not_account_starts'                  => 'Nici un cont nu începe cu ":value"',
    'search_modifier_account_nr_is'                       => 'Fie numărul de cont/IBAN este ":value"',
    'search_modifier_not_account_nr_is'                   => 'Nici numărul de cont / IBAN nu este ":value"',
    'search_modifier_account_nr_contains'                 => 'Fie numărul de cont/IBAN conține ":value"',
    'search_modifier_not_account_nr_contains'             => 'Nici numărul de cont / IBAN nu conține ":value"',
    'search_modifier_account_nr_ends'                     => 'Fie numărul de cont/IBAN se termină cu ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Nici numărul de cont / IBAN nu se termină cu ":value"',
    'search_modifier_account_nr_starts'                   => 'Fie numărul de cont/IBAN începe cu ":value"',
    'search_modifier_not_account_nr_starts'               => 'Nici numărul de cont / IBAN nu începe cu ":value"',
    'search_modifier_category_contains'                   => 'Categoria conține ":value"',
    'search_modifier_not_category_contains'               => 'Categoria nu conține ":value"',
    'search_modifier_category_ends'                       => 'Categoria se termină pe ":value"',
    'search_modifier_not_category_ends'                   => 'Categoria nu se termină pe ":value"',
    'search_modifier_category_starts'                     => 'Categoria începe cu ":value"',
    'search_modifier_not_category_starts'                 => 'Categoria nu începe cu ":value"',
    'search_modifier_budget_contains'                     => 'Bugetul conține „:value”',
    'search_modifier_not_budget_contains'                 => 'Bugetul nu conține „:value”',
    'search_modifier_budget_ends'                         => 'Bugetul se termină cu ":value"',
    'search_modifier_not_budget_ends'                     => 'Bugetul nu se termină pe „:value”',
    'search_modifier_budget_starts'                       => 'Bugetul începe cu ":value"',
    'search_modifier_not_budget_starts'                   => 'Bugetul nu începe cu ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'ID extern conține ":value"',
    'search_modifier_not_external_id_contains'            => 'ID extern nu conține ":value"',
    'search_modifier_external_id_ends'                    => 'ID extern se termină cu ":value"',
    'search_modifier_not_external_id_ends'                => 'ID extern nu se termină cu ":value"',
    'search_modifier_external_id_starts'                  => 'ID extern începe cu ":value"',
    'search_modifier_not_external_id_starts'              => 'ID extern nu începe cu ":value"',
    'search_modifier_internal_reference_contains'         => 'Referinţa internă conţine ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Referința internă nu conține ":value"',
    'search_modifier_internal_reference_ends'             => 'Referința internă se termină cu ":value"',
    'search_modifier_internal_reference_starts'           => 'Referința internă începe cu ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Referința internă nu se termină cu ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Referința internă nu începe cu ":value"',
    'search_modifier_external_url_is'                     => 'URL-ul extern este ":value"',
    'search_modifier_not_external_url_is'                 => 'URL-ul extern nu este ":value"',
    'search_modifier_external_url_contains'               => 'URL-ul extern conține ":value"',
    'search_modifier_not_external_url_contains'           => 'URL-ul extern nu conține ":value"',
    'search_modifier_external_url_ends'                   => 'URL-ul extern se termină cu ":value"',
    'search_modifier_not_external_url_ends'               => 'URL-ul extern nu se termină cu ":value"',
    'search_modifier_external_url_starts'                 => 'URL-ul extern începe cu ":value"',
    'search_modifier_not_external_url_starts'             => 'URL-ul extern nu începe cu ":value"',
    'search_modifier_has_no_attachments'                  => 'Tranzacția nu are atașamente',
    'search_modifier_not_has_no_attachments'              => 'Tranzacția are atașamente',
    'search_modifier_not_has_attachments'                 => 'Tranzacția nu are atașamente',
    'search_modifier_account_is_cash'                     => 'Orice cont este cont de "(numerar)".',
    'search_modifier_not_account_is_cash'                 => 'Nici contul nu este cont de "(numerar)".',
    'search_modifier_journal_id'                          => 'ID-ul jurnalului este ":value"',
    'search_modifier_not_journal_id'                      => 'ID-ul jurnalului nu este ":value"',
    'search_modifier_recurrence_id'                       => 'ID-ul tranzacției recurente este ":value"',
    'search_modifier_not_recurrence_id'                   => 'ID-ul tranzacției recurente nu este ":value"',
    'search_modifier_foreign_amount_is'                   => 'Suma in moneda străină este ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Suma in moneda străină nu este ":value"',
    'search_modifier_foreign_amount_less'                 => 'Suma în valută este mai mică decât ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Suma în valută este mai mică decât ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Suma în valută este mai mare decât ":value"',
    'search_modifier_foreign_amount_more'                 => 'Suma în valută este mai mare decât ":value"',
    'search_modifier_exists'                              => 'Tranzacția există (orice tranzacție)',
    'search_modifier_not_exists'                          => 'Tranzacția nu există (fără tranzacție)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Data dobânzii tranzacţiei este ":value"',
    'search_modifier_not_interest_date_on'                => 'Data dobânzii tranzacției nu este ":value"',
    'search_modifier_interest_date_on_year'               => 'Data dobânzii tranzacției este în anul ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Data dobânzii tranzacției nu este în anul ":value"',
    'search_modifier_interest_date_on_month'              => 'Data dobânzii tranzacției este în luna ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Data dobânzii tranzacției nu este în luna ":value"',
    'search_modifier_interest_date_on_day'                => 'Data dobânzii tranzacției este în ziua lunii ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Data dobânzii tranzacției nu este în ziua lunii ":value"',
    'search_modifier_interest_date_before_year'           => 'Data dobânzii tranzacției este înainte sau în anul ":value"',
    'search_modifier_interest_date_before_month'          => 'Data dobânzii tranzacției este înainte sau în luna ":value"',
    'search_modifier_interest_date_before_day'            => 'Data dobânzii tranzacției este înainte sau în ziua lunii ":value"',
    'search_modifier_interest_date_after_year'            => 'Data dobânzii tranzacției este după sau în anul ":value"',
    'search_modifier_interest_date_after_month'           => 'Data dobânzii tranzacției este după sau în luna ":value"',
    'search_modifier_interest_date_after_day'             => 'Data dobânzii tranzacției este după sau în ziua lunii ":value"',
    'search_modifier_book_date_on_year'                   => 'Data tranzacției este în anul ":value"',
    'search_modifier_book_date_on_month'                  => 'Data tranzacţiei este în luna ":value"',
    'search_modifier_book_date_on_day'                    => 'Data registrului de tranzacţii este în ziua lunii ":value"',
    'search_modifier_not_book_date_on_year'               => 'Data portofoliului de tranzacții nu este în anul ":value"',
    'search_modifier_not_book_date_on_month'              => 'Data tranzacţiei nu este în luna ":value"',
    'search_modifier_not_book_date_on_day'                => 'Data tranzacției nu este în ziua lunii ":value"',
    'search_modifier_book_date_before_year'               => 'Data registrului tranzacțiilor este anterioară sau în anul ":value"',
    'search_modifier_book_date_before_month'              => 'Data registrului tranzacțiilor este anterioară sau în luna ":value"',
    'search_modifier_book_date_before_day'                => 'Data registrului tranzacțiilor este anterioară sau în iziua din luna ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Transaction due date is in year ":value"',
    'search_modifier_due_date_on_month'                   => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Transaction due date is after or in year ":value"',
    'search_modifier_due_date_after_month'                => 'Transaction due date is after or in month ":value"',
    'search_modifier_due_date_after_day'                  => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                => 'Transaction payment date is in year ":value"',
    'search_modifier_payment_date_on_month'               => 'Transaction payment date is in month ":value"',
    'search_modifier_payment_date_on_day'                 => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'             => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'               => 'Data tranzacţiei este în luna ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Data facturării tranzacției este în ziua lunii ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Data facturării tranzacției nu este în anul ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Data facturării tranzacției nu este în luna ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Data facturării tranzacției nu este în ziua lunii ":value"',
    'search_modifier_invoice_date_before_year'            => 'Data facturării tranzacției este înainte sau în anul ":value"',
    'search_modifier_invoice_date_before_month'           => 'Data facturării tranzacției este înainte sau în luna ":value"',
    'search_modifier_invoice_date_before_day'             => 'Data facturii este înainte sau în ziua lunii ":value"',
    'search_modifier_invoice_date_after_year'             => 'Data facturării tranzacției este după sau în anul ":value"',
    'search_modifier_invoice_date_after_month'            => 'Data facturării tranzacției este după sau în luna ":value"',
    'search_modifier_invoice_date_after_day'              => 'Data facturării tranzacției este după sau în ziua lunii ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Tranzacția a fost actualizată ultima dată în anul ":value"',
    'search_modifier_updated_at_on_month'                 => 'Tranzacția a fost actualizată ultima dată în luna ":value"',
    'search_modifier_updated_at_on_day'                   => 'Tranzacția a fost actualizată ultima dată în ziua lunii ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Tranzacția nu a fost actualizată ultima dată în anul ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Tranzacția nu a fost actualizată ultima dată în luna ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Tranzacția nu a fost actualizată ultima dată în ziua lunii ":value"',
    'search_modifier_updated_at_before_year'              => 'Tranzacția a fost actualizată ultima dată în sau înainte de anul ":value"',
    'search_modifier_updated_at_before_month'             => 'Tranzacția a fost actualizată ultima dată în sau înainte de luna ":value"',
    'search_modifier_updated_at_before_day'               => 'Tranzacția a fost actualizată ultima dată în sau înainte de ziua din luna ":value"',
    'search_modifier_updated_at_after_year'               => 'Tranzacția a fost actualizată ultima dată în sau după anul ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                  => 'Transaction was created in year ":value"',
    'search_modifier_created_at_on_month'                 => 'Transaction was created in month ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'             => 'Transaction was created in or before month ":value"',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'              => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                    => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                       => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                    => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'            => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'      => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'        => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'          => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'          => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'     => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'       => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'         => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'        => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT este ":value"',
    'update_rule_from_query'                        => 'Actualizați regula ":rule" din interogarea de căutare',
    'create_rule_from_query'                        => 'Creați o nouă regulă din interogarea de căutare',
    'rule_from_search_words'                        => 'Motorul regulii are dificultăți în manipularea ":string". Regula sugerată care se potrivește interogării dvs. poate da rezultate diferite. Vă rugăm să verificați declanșatorii regulii cu atenție.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'A apărut o eroare în timpul căutării. Verificați log-urile pentru mai multe informații.',
    'search_box'                                          => 'Caută',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Eroare la căutare',
    'search_searching'                                    => 'Căutare ...',
    'search_results'                                      => 'Rezultatele căutarii',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'anual',
    'repeat_freq_half-year'                               => 'fiecare jumătate de an',
    'repeat_freq_quarterly'                               => 'trimestrial',
    'repeat_freq_monthly'                                 => 'lunar',
    'repeat_freq_weekly'                                  => 'săptămânal',
    'repeat_freq_daily'                                   => 'zilnic',
    'daily'                                               => 'zilnic',
    'weekly'                                              => 'săptămânal',
    'quarterly'                                           => 'trimestrial',
    'half-year'                                           => 'fiecare jumătate de an',
    'yearly'                                              => 'anual',

    // rules
    'is_not_rule_trigger'                                 => 'Nu',
    'cannot_fire_inactive_rules'                          => 'Nu se pot executa reguli inactive.',
    'show_triggers'                                       => 'Arată declanșatoare',
    'show_actions'                                        => 'Afișare acțiuni',
    'rules'                                               => 'Reguli',
    'rule_name'                                           => 'Denumirea regulii',
    'rule_triggers'                                       => 'Regulă se va declanșa când',
    'rule_actions'                                        => 'Regulă va',
    'new_rule'                                            => 'O nouă regulă',
    'new_rule_group'                                      => 'Un nou grup de reguli',
    'rule_priority_up'                                    => 'Acordați prioritate regulii',
    'rule_priority_down'                                  => 'Acordați mai putină prioritate regulii',
    'make_new_rule_group'                                 => 'Faceți un nou grup de reguli',
    'store_new_rule_group'                                => 'Păstrați un nou grup de reguli',
    'created_new_rule_group'                              => 'Grup nou de reguli ":title" stocat!',
    'updated_rule_group'                                  => 'Grup de reguli actualizat cu succes ":title".',
    'edit_rule_group'                                     => 'Editați grupul de reguli ":title"',
    'duplicate_rule'                                      => 'Duplicați regula ":title"',
    'rule_copy_of'                                        => 'Copie a ":title"',
    'duplicated_rule'                                     => 'Regulă ":title" duplicată în ":newTitle"',
    'delete_rule_group'                                   => 'Ștergeți  grupul de reguli ":title"',
    'deleted_rule_group'                                  => 'Grupul de reguli ":title" a fost șters',
    'update_rule_group'                                   => 'Actualizați grupul de reguli',
    'no_rules_in_group'                                   => 'Nu există reguli în acest grup',
    'move_rule_group_up'                                  => 'Mutare grupul de reguli mai sus',
    'move_rule_group_down'                                => 'Mutare grupul de reguli mai jos',
    'save_rules_by_moving'                                => 'Salvați această regulă mutând-o la un alt grup de reguli: Salvați aceste reguli mutându-le în alt grup de reguli:',
    'make_new_rule'                                       => 'Creați o nouă regulă în grupul de reguli ":title"',
    'make_new_rule_no_group'                              => 'Creați o nouă regulă',
    'instructions_rule_from_bill'                         => 'Pentru a potrivi tranzacțiile cu noul abonament ":name", Firefly III poate crea o regulă care va fi automat verificată împotriva oricăror tranzacții pe care le stocați. Vă rugăm să verificați detaliile de mai jos și să stocați regula pentru ca Firefly III să se potrivească automat tranzacțiile cu noul abonament.',
    'instructions_rule_from_journal'                      => 'Creați o regulă bazată pe una dintre tranzacțiile dvs. Completați sau trimiteți formularul de mai jos.',
    'rule_is_strict'                                      => 'regulă strictă',
    'rule_is_not_strict'                                  => 'regulă nestrictă',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'În regulile stricte, toți declanșatorii trebuie să declanșeze acțiunea (acțiunile) care trebuie executate. În reguli nestricte, orice declanșator este suficient pentru acțiunea (acțiunile) care trebuie executată.',
    'rule_help_active'                                    => 'Regulile noi nu vor fi niciodată declanșate.',
    'stored_new_rule'                                     => 'S-a salvat o nouă regulă cu titlu ":title"',
    'deleted_rule'                                        => 'S-a șters o regulă cu titlul ":title"',
    'store_new_rule'                                      => 'Salvati regulă nouă',
    'updated_rule'                                        => 'S-a actualizat o regulă cu titlul ":title"',
    'default_rule_group_name'                             => 'Reguli standard',
    'default_rule_group_description'                      => 'Toate regulile - nu sunt într-un anumit grup.',
    'trigger'                                             => 'Declanșator',
    'trigger_value'                                       => 'Declanșare la valoarea',
    'stop_processing_other_triggers'                      => 'Opriți procesarea altor declanșatoare',
    'add_rule_trigger'                                    => 'Adăugați un nou declanșator',
    'action'                                              => 'Acțiune',
    'action_value'                                        => 'Valoarea acțiunii',
    'stop_executing_other_actions'                        => 'Opriți executarea altor acțiuni',
    'add_rule_action'                                     => 'Adăugați o acțiune nouă',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Stergeți regula ":title"',
    'update_rule'                                         => 'Actualizați regula',
    'test_rule_triggers'                                  => 'Consultați tranzacțiile potrivite',
    'warning_no_matching_transactions'                    => 'Nicio tranzacție găsită.',
    'warning_no_valid_triggers'                           => 'Nu au fost furnizate declanșatoare valide.',
    'apply_rule_selection'                                => 'Aplicați regula ":title" la o selecție a tranzacțiilor dvs.',
    'apply_rule_selection_intro'                          => 'Reguli de genul ":title" se aplică, în mod normal, tranzacțiilor noi sau actualizate, dar puteți să-i spuneți aplicației să o ruleze pe o selecție a tranzacțiilor existente. Acest lucru poate fi util atunci când ați actualizat o regulă și aveți nevoie de modificările care vor fi aplicate tuturor celorlalte tranzacții.',
    'include_transactions_from_accounts'                  => 'Includeți tranzacții din aceste conturi',
    'include'                                             => 'Include?',
    'applied_rule_selection'                              => '{0} Nicio tranzacție în selecția dvs. nu a fost modificată prin regula ":title".[1] O tranzacție din selecția dvs. a fost modificată prin regula ":title".<unk> [2,*] :count tranzacții în selecție au fost modificate prin regula ":title".',
    'execute'                                             => 'Execută',
    'apply_rule_group_selection'                          => 'Aplicați grupul de reguli ":title" la o selecție a tranzacțiilor dvs.',
    'apply_rule_group_selection_intro'                    => 'Grupul de reguli precum ":title" se aplică, în mod normal, tranzacțiilor noi sau actualizate, însă puteți spune aplicației că rulează toate regulile din acest grup cu privire la o selecție a tranzacțiilor existente. Acest lucru poate fi util atunci când ați actualizat un grup de reguli și aveți nevoie de modificările care vor fi aplicate tuturor celorlalte tranzacții.',
    'applied_rule_group_selection'                        => 'Grupul de reguli ":title" a fost aplicat selecției dvs..',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Când este o tranzacție creată',
    'rule_trigger_update_journal'                         => 'Când este o tranzacție actualizată',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'Acțiunea utilizatorului este ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Numele contului sursă începe cu..',
    'rule_trigger_source_account_starts'                  => 'Numele contului sursă începe cu ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Numele contului sursă se termină cu..',
    'rule_trigger_source_account_ends'                    => 'Numele contului sursă se termină cu ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Numele contului sursă este..',
    'rule_trigger_source_account_is'                      => 'Numele contului sursă este ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Numele contului sursă conține..',
    'rule_trigger_source_account_contains'                => 'Numele contului sursă conține ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Fie ID-ul contului este exact..',
    'rule_trigger_account_id'                             => 'Fie ID-ul contului este exact :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'ID-ul contului sursă este exact..',
    'rule_trigger_source_account_id'                      => 'ID-ul contului sursă este exact :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'ID-ul contului destinației este exact..',
    'rule_trigger_destination_account_id'                 => 'ID-ul contului destinației este exact :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Oricare cont este numerar',
    'rule_trigger_account_is_cash'                        => 'Oricare cont este numerar',
    'rule_trigger_source_is_cash_choice'                  => 'Contul sursă este (numerar)',
    'rule_trigger_source_is_cash'                         => 'Contul sursă este (numerar)',
    'rule_trigger_destination_is_cash_choice'             => 'Contul destinației este (numerar)',
    'rule_trigger_destination_is_cash'                    => 'Contul destinației este (numerar)',
    'rule_trigger_source_account_nr_starts_choice'        => 'Numărul contului sursă/IBAN începe cu..',
    'rule_trigger_source_account_nr_starts'               => 'Numărul contului sursă/IBAN începe cu ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Numărul contului sursă/ IBAN se încheie cu..',
    'rule_trigger_source_account_nr_ends'                 => 'Numărul contului sursă/ IBAN se termină cu ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Numărul contului sursă/ IBAN este..',
    'rule_trigger_source_account_nr_is'                   => 'Numărul contului sursă/ IBAN este ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Numărul contului sursă/ IBAN conține..',
    'rule_trigger_source_account_nr_contains'             => 'Numărul contului sursă/ IBAN conține ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Numele contului de destinație începe cu..',
    'rule_trigger_destination_account_starts'             => 'Numele contului de destinație începe cu ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Numele contului de destinație se încheie cu..',
    'rule_trigger_destination_account_ends'               => 'Numele contului de destinație se termină cu ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Numele contului destinație este..',
    'rule_trigger_destination_account_is'                 => 'Numele contului destinației este ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Numele contului destinației conține..',
    'rule_trigger_destination_account_contains'           => 'Numele contului destinației conține ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Numărul contului destinației/IBAN începe cu..',
    'rule_trigger_destination_account_nr_starts'          => 'Numărul contului destinației / IBAN începe cu ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Numărul contului de destinație/IBAN se încheie cu..',
    'rule_trigger_destination_account_nr_ends'            => 'Numărul contului destinației / IBAN se termină cu ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Numărul contului destinației/IBAN este..',
    'rule_trigger_destination_account_nr_is'              => 'Numărul contului destinației / IBAN este ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Numărul contului de destinație/IBAN conține..',
    'rule_trigger_destination_account_nr_contains'        => 'Numărul contului destinației/IBAN conține ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Tranzacția este de tip..',
    'rule_trigger_transaction_type'                       => 'Tranzacția este de tip ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Categoria este..',
    'rule_trigger_category_is'                            => 'Categoria este ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Suma este mai mică sau egală cu ..',
    'rule_trigger_amount_less'                            => 'Suma este mai mică sau egală cu :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Suma este..',
    'rule_trigger_amount_is'                              => 'Suma este :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Suma este mai mare sau egală cu..',
    'rule_trigger_amount_more'                            => 'Suma este mai mare sau egală cu :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Descrierea începe cu..',
    'rule_trigger_description_starts'                     => 'Descrierea începe cu ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Descrierea se termină cu..',
    'rule_trigger_description_ends'                       => 'Descrierea se termină cu ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Descrierea conține..',
    'rule_trigger_description_contains'                   => 'Descrierea conține ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Descrierea este..',
    'rule_trigger_description_is'                         => 'Descrierea este ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Data tranzacției este..',
    'rule_trigger_date_on'                                => 'Data tranzacției este ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Data tranzacției este dinainte..',
    'rule_trigger_date_before'                            => 'Data tranzacției este înainte de ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Data tranzacției este după..',
    'rule_trigger_date_after'                             => 'Data tranzacției este după ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Tranzacția a fost făcută pe..',
    'rule_trigger_created_at_on'                          => 'Tranzacția a fost făcută pe ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Tranzacția a fost editată ultima dată pe..',
    'rule_trigger_updated_at_on'                          => 'Tranzacția a fost editată ultima dată pe ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Bugetul este..',
    'rule_trigger_budget_is'                              => 'Bugetul este ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Orice etichetă este..',
    'rule_trigger_tag_is'                                 => 'Orice etichetă este ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Orice etichetă conține..',
    'rule_trigger_tag_contains'                           => 'Orice etichetă conține ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Orice etichetă se termină cu..',
    'rule_trigger_tag_ends'                               => 'Orice etichetă se termină cu ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Orice etichetă începe cu..',
    'rule_trigger_tag_starts'                             => 'Orice etichetă începe cu ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Moneda tranzacției este..',
    'rule_trigger_currency_is'                            => 'Moneda tranzacției este ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Tranzacția valutară este..',
    'rule_trigger_foreign_currency_is'                    => 'Moneda străină este ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Nu are nici o categorie',
    'rule_trigger_has_no_category'                        => 'Tranzacția nu are nici o categorie',
    'rule_trigger_has_any_category_choice'                => 'Are o (orice) categorie',
    'rule_trigger_has_any_category'                       => 'Tranzacția are o (orice) categorie',
    'rule_trigger_has_no_budget_choice'                   => 'Nu are niciun buget',
    'rule_trigger_has_no_budget'                          => 'Tranzacția nu are niciun buget',
    'rule_trigger_has_any_budget_choice'                  => 'Are un (orice) buget',
    'rule_trigger_has_any_budget'                         => 'Tranzacția are un (orice) buget',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Nu are etichetă (e)',
    'rule_trigger_has_no_tag'                             => 'Tranzacția nu are etichetă (e)',
    'rule_trigger_has_any_tag_choice'                     => 'Are una sau mai multe etichete',
    'rule_trigger_has_any_tag'                            => 'Tranzacția are una sau mai multe etichete',
    'rule_trigger_any_notes_choice'                       => 'Are (orice) notițe',
    'rule_trigger_any_notes'                              => 'Tranzacția are (orice) notițe',
    'rule_trigger_no_notes_choice'                        => 'Nu are notițe',
    'rule_trigger_no_notes'                               => 'Tranzacția nu are notițe',
    'rule_trigger_notes_is_choice'                        => 'Notele sunt..',
    'rule_trigger_notes_is'                               => 'Notele sunt ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notele conțin..',
    'rule_trigger_notes_contains'                         => 'Notele conţin ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notele încep cu..',
    'rule_trigger_notes_starts'                           => 'Notele încep cu ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notele se termină cu..',
    'rule_trigger_notes_ends'                             => 'Notele se termină cu ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'ID extern este..',
    'rule_trigger_external_id_is'                         => 'ID extern este ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Referința internă este..',
    'rule_trigger_internal_reference_is'                  => 'Referința internă este ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'ID-ul jurnalului de tranzacție este..',
    'rule_trigger_journal_id'                             => 'ID-ul jurnalului de tranzacții este ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Tranzacția are un (orice) URL extern',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Tranzacția are un (orice) ID extern',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Tranzacția nu are niciun URL extern',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Tranzacția nu are nici un ID extern',
    'rule_trigger_id_choice'                              => 'ID-ul tranzacției este..',
    'rule_trigger_id'                                     => 'ID-ul tranzacţiei este ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT este..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT este ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Acțiunea utilizatorului este ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Nicio etichetă este..',
    'rule_trigger_tag_is_not'                             => 'Nicio etichetă nu este ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Oricare cont este exact..',
    'rule_trigger_account_is'                             => 'Orice cont este exact ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Either account contains..',
    'rule_trigger_account_contains'                       => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Either account ends with..',
    'rule_trigger_account_ends'                           => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Either account starts with..',
    'rule_trigger_account_starts'                         => 'Either account starts with ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                    => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                        => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                      => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Categoria conţine..',
    'rule_trigger_category_contains'                      => 'Categoria conține ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Categoria se termină cu..',
    'rule_trigger_category_ends'                          => 'Categoria se termină cu ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Categoria începe cu..',
    'rule_trigger_category_starts'                        => 'Categoria începe cu ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Bugetul conține..',
    'rule_trigger_budget_contains'                        => 'Bugetul conține „:trigger_value”',
    'rule_trigger_budget_ends_choice'                     => 'Bugetul se încheie cu..',
    'rule_trigger_budget_ends'                            => 'Bugetul se termină cu ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Bugetul începe cu..',
    'rule_trigger_budget_starts'                          => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'ID extern conține..',
    'rule_trigger_external_id_contains'                   => 'ID extern conține ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'ID-ul extern se termină cu..',
    'rule_trigger_external_id_ends'                       => 'ID extern se termină cu ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'ID extern începe cu..',
    'rule_trigger_external_id_starts'                     => 'ID extern începe cu ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Referința internă conține..',
    'rule_trigger_internal_reference_contains'            => 'Referinţa internă conţine ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Referința internă se încheie cu..',
    'rule_trigger_internal_reference_ends'                => 'Referința internă se termină cu ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Referința internă începe cu..',
    'rule_trigger_internal_reference_starts'              => 'Referința internă începe cu ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'URL-ul extern este..',
    'rule_trigger_external_url_is'                        => 'URL-ul extern este ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'URL-ul extern conţine..',
    'rule_trigger_external_url_contains'                  => 'URL-ul extern conține ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'Adresa URL externă se termină cu..',
    'rule_trigger_external_url_ends'                      => 'URL-ul extern se termină cu ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'URL-ul extern începe cu..',
    'rule_trigger_external_url_starts'                    => 'URL-ul extern începe cu ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Has no attachments',
    'rule_trigger_has_no_attachments'                     => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                   => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                          => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Interest date is on..',
    'rule_trigger_interest_date_on'                       => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Interest date is before..',
    'rule_trigger_interest_date_before'                   => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Interest date is after..',
    'rule_trigger_interest_date_after'                    => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Book date is before..',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Process date is on..',
    'rule_trigger_process_date_on'                        => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Process date is before..',
    'rule_trigger_process_date_before'                    => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Process date is after..',
    'rule_trigger_process_date_after'                     => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Data scadentă este pe..',
    'rule_trigger_due_date_on'                            => 'Data scadentă este pe ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Data scadentă este înainte..',
    'rule_trigger_due_date_before'                        => 'Data scadentă este înainte de ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Data scadentă este după..',
    'rule_trigger_due_date_after'                         => 'Data scadentă este după ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Data scadentă este pe..',
    'rule_trigger_payment_date_on'                        => 'Data plății este pe ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Data scadentă este înainte..',
    'rule_trigger_payment_date_before'                    => 'Data plății este înainte de ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Data scadentă este după..',
    'rule_trigger_payment_date_after'                     => 'Data scadentă este după ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Data facturii este pe..',
    'rule_trigger_invoice_date_on'                        => 'Data facturii este pe ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Data facturii este înainte..',
    'rule_trigger_invoice_date_before'                    => 'Data facturii este înainte de ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Data facturii este după..',
    'rule_trigger_invoice_date_after'                     => 'Data facturii este după ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Tranzacția a fost creată înainte..',
    'rule_trigger_created_at_before'                      => 'Tranzacția a fost creată înainte de ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Tranzacția a fost creată după..',
    'rule_trigger_created_at_after'                       => 'Tranzacția a fost creată după ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Tranzacția a fost actualizată ultima dată înainte de..',
    'rule_trigger_updated_at_before'                      => 'Tranzacția a fost actualizată ultima dată înainte de ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Tranzacția a fost actualizată ultima dată după..',
    'rule_trigger_updated_at_after'                       => 'Tranzacția a fost actualizată ultima dată după ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Suma în valuta este exact..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                     => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'               => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                 => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                   => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Orice note ale atașamentului sunt..',
    'rule_trigger_attachment_notes_are'                   => 'Orice note ale atașamentului sunt ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Orice notă a ataşamentului conţine..',
    'rule_trigger_attachment_notes_contains'              => 'Orice note ale atașamentului conțin ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Notele atașate încep cu..',
    'rule_trigger_attachment_notes_starts'                => 'Orice notițe atașate încep cu ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Notele atașate se termină cu..',
    'rule_trigger_attachment_notes_ends'                  => 'Orice notițe atașate se termina cu ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Tranzacția este reconciliată',
    'rule_trigger_reconciled'                             => 'Tranzacția este reconciliată',
    'rule_trigger_exists_choice'                          => 'Orice tranzacție se potrivește(!)',
    'rule_trigger_exists'                                 => 'Orice tranzacție se potrivește',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'ID-ul contului nu este ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'ID-ul contului sursă nu este ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'ID-ul contului destinaţiei nu este ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Tipul de tranzacție nu este ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Eticheta nu este ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Eticheta este ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Descrierea nu este ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Tranzacția nu este reconciliată',
    'rule_trigger_not_exists'                             => 'Tranzacția nu există',
    'rule_trigger_not_has_attachments'                    => 'Tranzacția nu are atașamente',
    'rule_trigger_not_has_any_category'                   => 'Tranzacția nu are nicio categorie',
    'rule_trigger_not_has_any_budget'                     => 'Tranzacția nu are buget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Tranzacția nu are tag-uri',
    'rule_trigger_not_any_notes'                          => 'Tranzacția nu are note',
    'rule_trigger_not_any_external_url'                   => 'Tranzacția nu are niciun URL extern',
    'rule_trigger_not_has_no_attachments'                 => 'Tranzacția are un (orice) atașament(e)',
    'rule_trigger_not_has_no_category'                    => 'Tranzacția are o (orice) categorie',
    'rule_trigger_not_has_no_budget'                      => 'Tranzacția are un (orice) buget',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Tranzacția are o (orice) etichetă',
    'rule_trigger_not_no_notes'                           => 'Tranzacția are orice notă',
    'rule_trigger_not_no_external_url'                    => 'Tranzacția are un URL extern',
    'rule_trigger_not_source_is_cash'                     => 'Contul sursă nu este un cont de numerar',
    'rule_trigger_not_destination_is_cash'                => 'Contul de destinație nu este un cont de numerar',
    'rule_trigger_not_account_is_cash'                    => 'Nici un cont nu este un cont de numerar',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'Șterge tranzacția (!)',
    'rule_action_delete_transaction'             => 'Șterge tranzacția (!)',
    'rule_action_set_category'                   => 'Setați categoria la ":action_value"',
    'rule_action_clear_category'                 => 'Șterge categorie',
    'rule_action_set_budget'                     => 'Setați bugetul la ":action_value"',
    'rule_action_clear_budget'                   => 'Ștergeți bugetul',
    'rule_action_add_tag'                        => 'Adaugă etichetă ":action_value"',
    'rule_action_remove_tag'                     => 'Eliminați eticheta ":action_value"',
    'rule_action_remove_all_tags'                => 'Eliminați toate etichetele',
    'rule_action_set_description'                => 'Setați descrierea la ":action_value"',
    'rule_action_append_description'             => 'Adăugați descrierea cu ":action_value"',
    'rule_action_prepend_description'            => 'Prefixați descrierea cu ":action_value"',
    'rule_action_set_category_choice'            => 'Setați categoria la..',
    'rule_action_clear_category_choice'          => 'Ștergeți any category',
    'rule_action_set_budget_choice'              => 'Setați bugetul la..',
    'rule_action_clear_budget_choice'            => 'Ștergeți any budget',
    'rule_action_add_tag_choice'                 => 'Adaugă etichetă..',
    'rule_action_remove_tag_choice'              => 'Eliminați eticheta..',
    'rule_action_remove_all_tags_choice'         => 'Eliminați toate etichetele',
    'rule_action_set_description_choice'         => 'Setați descrierea la..',
    'rule_action_update_piggy_choice'            => 'Adaugă / șterge suma tranzacției în pușculiță ..',
    'rule_action_update_piggy'                   => 'Adaugă/elimină suma tranzacției în pușculița ":action_value"',
    'rule_action_append_description_choice'      => 'Adăugați descrierea cu ..',
    'rule_action_prepend_description_choice'     => 'Prefixați descrierea cu ..',
    'rule_action_set_source_account_choice'      => 'Setează contul sursă la ..',
    'rule_action_set_source_account'             => 'Setați contul sursă la :action_value',
    'rule_action_set_destination_account_choice' => 'Setează contul de destinație la ..',
    'rule_action_set_destination_account'        => 'Setați contul de destinație la :action_value',
    'rule_action_append_notes_choice'            => 'Adăugați notițe cu ..',
    'rule_action_append_notes'                   => 'Adăugați notițe cu ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Prefixați notițele cu ..',
    'rule_action_prepend_notes'                  => 'Prefixați notițele cu ":action_value"',
    'rule_action_clear_notes_choice'             => 'Eliminați orice notiță',
    'rule_action_clear_notes'                    => 'Eliminați orice notiță',
    'rule_action_set_notes_choice'               => 'Setează notele la ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Schimbă conturile sursă și de destinație (doar transferuri!)',
    'rule_action_switch_accounts'                => 'Schimbă sursa și destinația',
    'rule_action_set_notes'                      => 'Setați notițele la ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Transformați tranzacția într-un depozit',
    'rule_action_convert_deposit'                => 'Transformați tranzacția într-un depozit de la ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Transformați tranzacția într-o retragere',
    'rule_action_convert_withdrawal'             => 'Transformați tranzacția într-o retragere la ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Transformați tranzacția într-un transfer',
    'rule_action_convert_transfer'               => 'Transformați tranzacția într-un transfer cu ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Adaugă descrierea la notele tranzacției',
    'rule_action_append_notes_to_descr_choice'   => 'Adaugă notele tranzacției la descriere',
    'rule_action_move_descr_to_notes_choice'     => 'Înlocuiți notele curente ale tranzacției cu descrierea',
    'rule_action_move_notes_to_descr_choice'     => 'Înlocuiți descrierea curentă cu notele de tranzacție',
    'rule_action_append_descr_to_notes'          => 'Adaugă descriere la note',
    'rule_action_append_notes_to_descr'          => 'Adaugă note la descriere',
    'rule_action_move_descr_to_notes'            => 'Înlocuiți notițele cu descriere',
    'rule_action_move_notes_to_descr'            => 'Înlocuiți descrierea cu note',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Setează contul de destinație la (numerar)',
    'rule_action_set_source_to_cash_choice'      => 'Setează contul sursă la (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Regulă bazată pe tranzacția ":description"',
    'new_rule_for_journal_description'          => 'Această regulă este bazată pe tranzacția ":description". Se va potrivi cu tranzacțiile care sunt exact la fel.',

    // tags
    'store_new_tag'                             => 'Salvați o nouă etichetă',
    'update_tag'                                => 'Actualizați eticheta',
    'no_location_set'                           => 'Nu a fost setată nicio locație.',
    'meta_data'                                 => 'Date meta',
    'location'                                  => 'Locație',
    'location_first_split'                      => 'Locația pentru această tranzacție poate fi setată pe prima împărțire a acestei tranzacții.',
    'without_date'                              => 'Fără data',
    'result'                                    => 'Rezultat',
    'sums_apply_to_range'                       => 'Toate sumele se aplică gamei selectate',
    'mapbox_api_key'                            => 'Pentru a utiliza harta, obțineți o cheie API din <a href="https://www.mapbox.com/"> Mapbox </a>. Deschideți fișierul <code> .env </ code> și introduceți acest cod după <code> MAPBOX_API_KEY = </ code>.',
    'press_object_location'                     => 'Faceți clic dreapta sau apăsați lung pentru a seta locația obiectului.',
    'click_tap_location'                        => 'Faceți clic sau atingeți harta pentru a adăuga o locație',
    'clear_location'                            => 'Ștergeți locația',
    'delete_all_selected_tags'                  => 'Şterge toate etichetele selectate',
    'select_tags_to_delete'                     => 'Nu uitați să selectați unele etichete.',
    'deleted_x_tags'                            => 'S-a șters :count tag.| :count tags șterse.',
    'create_rule_from_transaction'              => 'Creați o regulă bazată pe tranzacție',
    'create_recurring_from_transaction'         => 'Creați o tranzacție recurentă bazată pe tranzacție',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Lăsați browserul să decidă',
    'dark_mode_option_light'                    => 'Întotdeauna luminos',
    'dark_mode_option_dark'                     => 'Întotdeauna întunecat',
    'equal_to_language'                         => '(egal cu limba)',
    'dark_mode_preference'                      => 'Mod întunecat',
    'dark_mode_preference_help'                 => 'Spuneți Firefly III când să utilizeze modul întunecat.',
    'pref_home_screen_accounts'                 => 'Ecranul de start al conturilor',
    'pref_home_screen_accounts_help'            => 'Ce conturi ar trebui afișate pe pagina de pornire?',
    'pref_view_range'                           => 'Vedeți intervalul',
    'pref_view_range_help'                      => 'Anumite grafice sunt grupate automat în perioade. Bugeturile dvs. vor fi, de asemenea, grupate în perioade. Ce perioadă ați prefera?',
    'pref_1D'                                   => 'O zi',
    'pref_1W'                                   => 'O saptamână',
    'pref_1M'                                   => 'O lună',
    'pref_3M'                                   => 'Trei luni (trimestru)',
    'pref_6M'                                   => 'Șase luni',
    'pref_1Y'                                   => 'Un an',
    'pref_last365'                              => 'Anul trecut',
    'pref_last90'                               => 'Ultimele 90 de zile',
    'pref_last30'                               => 'Ultimele 30 de zile',
    'pref_last7'                                => 'Ultimele 7 zile',
    'pref_YTD'                                  => 'De la începutul anului',
    'pref_QTD'                                  => 'Trimestru până în prezent',
    'pref_MTD'                                  => 'Luna aceasta',
    'pref_languages'                            => 'Limbi',
    'pref_locale'                               => 'Setările locale',
    'pref_languages_help'                       => 'Firefly III acceptă mai multe limbi. Pe care o preferați?',
    'pref_locale_help'                          => 'Firefly III vă permite să setați alte setări locale, cum ar fi modul în care valutele, numerele și datele sunt formatate. Este posibil ca intrările din această listă să nu fie acceptate de sistemul dumneavoastră. Firefly III nu are setările de date corecte pentru fiecare local; contactați-mă pentru îmbunătățiri.',
    'pref_locale_no_demo'                       => 'Această funcție nu va funcționa pentru utilizatorul demo.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Setări an fiscal',
    'pref_custom_fiscal_year_label'             => 'Activat',
    'pref_custom_fiscal_year_help'              => 'În țările care utilizează un exercițiu financiar, altul decât 1 ianuarie până la 31 decembrie, puteți să le activați și să specificați zilele de începere / sfârșit ale anului fiscal',
    'pref_fiscal_year_start_label'              => 'Data de începere a anului fiscal',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Nu uitați să eliminați contul din aplicația dvs. de autentificare!',
    'pref_two_factor_auth_code'                 => 'Verificați codul',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Resetați codul de verificare',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'Dacă nu puteți scana codul QR, nu ezitați să utilizați codul secret: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Stocați aceste coduri de rezervă pentru acces în cazul în care pierdeți dispozitivul.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Codul MFA nu este valid.',
    'pref_save_settings'                        => 'Salvează setările',
    'saved_preferences'                         => 'Preferințele sunt salvate!',
    'preferences_general'                       => 'Generale',
    'preferences_frontpage'                     => 'Ecranul de start',
    'preferences_security'                      => 'Securitate',
    'preferences_layout'                        => 'Schemă',
    'preferences_notifications'                 => 'Notificări',
    'pref_home_show_deposits'                   => 'Afișați depozitele pe ecranul de pornire',
    'pref_home_show_deposits_info'              => 'Ecranul de pornire vă arată deja cont de cheltuieli. Ar trebui să afișeze și conturile dvs. de venit?',
    'pref_home_do_show_deposits'                => 'Da, arată-le',
    'successful_count'                          => 'din care :count au reușit',
    'list_page_size_title'                      => 'Mărimea paginii',
    'list_page_size_help'                       => 'Orice listă de lucruri (conturi, tranzacții etc.) arată cel mult atât de multe pe pagină.',
    'list_page_size_label'                      => 'Mărimea paginii',
    'between_dates'                             => '(:start și :end)',
    'pref_optional_fields_transaction'          => 'Câmpuri opționale pentru tranzacții',
    'pref_optional_fields_transaction_help'     => 'În mod prestabilit, toate câmpurile nu sunt activate atunci când creați o nouă tranzacție (din cauza aglomerării). Mai jos, puteți activa aceste câmpuri dacă credeți că acestea ar putea fi utile pentru dvs. Desigur, orice câmp care este dezactivat, dar deja completat, va fi vizibil indiferent de setare.',
    'optional_tj_date_fields'                   => 'Câmpurile de date',
    'optional_tj_other_fields'                  => 'Alte câmpuri',
    'optional_tj_attachment_fields'             => 'Câmpuri de atașament',
    'pref_optional_tj_interest_date'            => 'Data de interes',
    'pref_optional_tj_book_date'                => 'Data revervării',
    'pref_optional_tj_process_date'             => 'Data procesării',
    'pref_optional_tj_due_date'                 => 'Data scadentă',
    'pref_optional_tj_payment_date'             => 'Data plății',
    'pref_optional_tj_invoice_date'             => 'Data facturii',
    'pref_optional_tj_internal_reference'       => 'Referință internă',
    'pref_optional_tj_notes'                    => 'Notițe',
    'pref_optional_tj_attachments'              => 'Ataşamente',
    'pref_optional_tj_external_url'             => 'URL extern',
    'pref_optional_tj_location'                 => 'Locaţie',
    'pref_optional_tj_links'                    => 'Link-uri de tranzacție',
    'optional_field_meta_dates'                 => 'Date',
    'optional_field_meta_business'              => 'Afaceri',
    'optional_field_attachments'                => 'Ataşamente',
    'optional_field_meta_data'                  => 'Meta date opționale',
    'external_url'                              => 'URL extern',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Alertă atunci când un nou token de acces API este creat',
    'pref_notification_transaction_creation'    => 'Alertă atunci când o tranzacție este creată automat',
    'pref_notification_user_login'              => 'Alertă când te loghezi dintr-o locație nouă',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Notificări',
    'pref_notifications_help'                   => 'Indicați dacă acestea sunt notificări pe care doriți să le primiți. Unele notificări pot conține informații financiare sensibile.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Administrația financiară',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Curăță datele din Firefly III',
    'purge_data_expl'                           => '„Purging” înseamnă „ștergerea celui care este deja șters”. În circumstanțe normale, Firefly III nu șterge nimic permanent. Doar o ascunde. Butonul de mai jos șterge toate aceste înregistrări anterior "șterse" FOREVER.',
    'delete_stuff_header'                       => 'Delete and purge data',
    'purge_all_data'                            => 'Şterge toate înregistrările şterse',
    'purge_data'                                => 'Şterge datele',
    'purged_all_records'                        => 'All deleted records have been purged.',
    'delete_data_title'                         => 'Delete data from Firefly III',
    'permanent_delete_stuff'                    => 'You can delete stuff from Firefly III. Using the buttons below means that your items will be removed from view and hidden. There is no undo-button for this, but the items may remain in the database where you can salvage them if necessary.',
    'other_sessions_logged_out'                 => 'Toate celelalte sesiuni au fost deconectate.',
    'delete_unused_accounts'                    => 'Deleting unused accounts will clean your auto-complete lists.',
    'delete_all_unused_accounts'                => 'Șterge conturile neutilizate',
    'deleted_all_unused_accounts'               => 'Toate conturile neutilizate sunt șterse',
    'delete_all_budgets'                        => 'Șterge toate bugetele',
    'delete_all_categories'                     => 'Șterge toate categoriile',
    'delete_all_tags'                           => 'Șterge toate tag-urile',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Șterge TOATE pușculițele tale',
    'delete_all_rules'                          => 'Șterge TOATE regulile',
    'delete_all_recurring'                      => 'Șterge TOATE tranzacțiile dvs. recurente',
    'delete_all_object_groups'                  => 'Șterge TOATE grupurile de obiecte',
    'delete_all_accounts'                       => 'Șterge TOATE conturile tale',
    'delete_all_asset_accounts'                 => 'Șterge TOATE conturile de active',
    'delete_all_expense_accounts'               => 'Ștergeți TOATE conturile de cheltuieli',
    'delete_all_revenue_accounts'               => 'Șterge TOATE conturile de venituri',
    'delete_all_liabilities'                    => 'Șterge TOATE datoriile tale',
    'delete_all_transactions'                   => 'Ștergeți TOATE tranzacțiile dvs',
    'delete_all_withdrawals'                    => 'Șterge TOATE retragerile',
    'delete_all_deposits'                       => 'Șterge TOATE depozitele tale',
    'delete_all_transfers'                      => 'Șterge TOATE transferurile tale',
    'also_delete_transactions'                  => 'Ștergerea conturilor va șterge și toate retragerile asociate, depozitele și transferurile!',
    'deleted_all_budgets'                       => 'Toate bugetele au fost şterse',
    'deleted_all_categories'                    => 'Toate categoriile au fost şterse',
    'deleted_all_tags'                          => 'Toate tag-urile au fost şterse',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Toate pușculițele au fost șterse',
    'deleted_all_rules'                         => 'Toate regulile și grupurile de reguli au fost șterse',
    'deleted_all_object_groups'                 => 'Toate grupurile au fost șterse',
    'deleted_all_accounts'                      => 'Toate conturile au fost șterse',
    'deleted_all_asset_accounts'                => 'Toate conturile de active au fost șterse',
    'deleted_all_expense_accounts'              => 'Toate conturile de cheltuieli au fost șterse',
    'deleted_all_revenue_accounts'              => 'Toate conturile de venituri au fost șterse',
    'deleted_all_liabilities'                   => 'Toate datoriile au fost șterse',
    'deleted_all_transactions'                  => 'Toate tranzacțiile au fost șterse',
    'deleted_all_withdrawals'                   => 'Toate retragerile au fost șterse',
    'deleted_all_deposits'                      => 'Toate depozitele au fost șterse',
    'deleted_all_transfers'                     => 'Toate transferurile au fost șterse',
    'deleted_all_recurring'                     => 'Toate tranzacțiile recurente au fost șterse',
    'change_your_password'                      => 'Schimbați-vă parola',
    'delete_account'                            => 'Șterge account',
    'current_password'                          => 'Parola actuală',
    'new_password'                              => 'Parola nouă',
    'new_password_again'                        => 'Parola nouă (din nou)',
    'delete_your_account'                       => 'Ștergeți contul dvs',
    'delete_your_account_help'                  => 'Ștergerea contului dvs. va șterge, de asemenea, orice cont, tranzacție, <em> orice </ em> ați salvat în aplicație. Acestea vor dispărea.',
    'delete_your_account_password'              => 'Introduceți parola pentru a continua.',
    'password'                                  => 'Parola',
    'are_you_sure'                              => 'Esti sigur? Nu poți anula acest lucru.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'Ștergeți contul dvs',
    'invalid_current_password'                  => 'Parola curentă nevalidă!',
    'password_changed'                          => 'Parolă schimbată!',
    'should_change'                             => 'Ideea este să vă schimbați parola.',
    'invalid_password'                          => 'Parolă nevalidă!',
    'what_is_pw_security'                       => 'Ce este "verificarea securității parolei"?',
    'secure_pw_title'                           => 'Cum alegeți o parolă sigură',
    'forgot_password_response'                  => 'Vă mulţumim. Dacă există un cont cu această adresă de e-mail, veţi găsi instrucţiuni în căsuţa poştală.',
    'secure_pw_history'                         => 'Nu trece nici săptămână și citiți în știri despre un site care pierde parolele utilizatorilor săi. Hackerii și hoții utilizează aceste parole pentru a încerca să vă fure informațiile private. Aceste informații sunt valoroase.',
    'secure_pw_ff'                              => 'Utilizați aceeași parolă pe tot internetul? Dacă un site pierde parola, hackerii au acces la toate datele. Firefly III se bazează pe dvs. pentru a alege o parolă puternică și unică pentru a vă proteja înregistrările financiare.',
    'secure_pw_check_box'                       => 'Pentru a vă ajuta să faceți acest lucru Firefly III poate verifica dacă parola pe care doriți să o utilizați a fost furată în trecut. Dacă este cazul, Firefly III vă sfătuiește NU să utilizați parola respectivă.',
    'secure_pw_working_title'                   => 'Cum funcționează?',
    'secure_pw_working'                         => 'Dacă bifați caseta, Firefly III va trimite primele cinci caractere ale hash-ului SHA1 al parolei dvs. la <a href = "https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/ "> site-ul Troy Hunt </a> pentru a vedea dacă este în listă. Acest lucru vă va împiedica să utilizați parole nesigure, așa cum se recomandă în cele mai recente<a href="https://pages.nist.gov/800-63-3/sp800-63b.html"> articole de specialitate pe NIST </a> pe acest subiect.',
    'secure_pw_should'                          => 'Ar trebui să bifez caseta??',
    'secure_pw_long_password'                   => 'Da. Verificați întotdeauna că parola este sigură.',
    'command_line_token'                        => 'Token-ul liniei de comandă',
    'explain_command_line_token'                => 'Aveți nevoie de acest token pentru a efectua opțiunile prin linie de comandă, cum ar fi exportul de date. Fără el, acea comandă sensibilă nu va funcționa. Nu distribui token-ul pentru linia de comandă. Nimeni nu vă va cere acest token, nici măcar eu. Dacă te temi că ai pierdut asta, sau când ești paranoic, regenerează acest token folosind butonul.',
    'regenerate_command_line_token'             => 'Regenerați token-ul liniei de comandă',
    'token_regenerated'                         => 'A fost generat un nou token de linie de comandă',
    'change_your_email'                         => 'Schimbați adresa dvs. de e-mail',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Până când nu vă confirmați adresa de e-mail, nu vă puteți conecta.',
    'login_with_new_email'                      => 'Acum vă puteți conecta cu noua dvs. adresă de e-mail.',
    'login_with_old_email'                      => 'Acum puteți să vă conectați din nou cu vechea adresă de e-mail.',
    'login_provider_local_only'                 => 'Această acțiune nu este disponibilă când vă autentificați prin ":login_provider".',
    'external_user_mgt_disabled'                => 'Această acțiune nu este disponibilă atunci când Firefly III nu este responsabil de gestionarea utilizatorului sau de manipularea autentificării.',
    'external_auth_disabled'                    => 'Această acțiune nu este disponibilă atunci când Firefly III nu este responsabil pentru manipularea autentificării.',
    'delete_local_info_only'                    => "Deoarece Firefly III nu este responsabil de gestionarea utilizatorului sau de manipularea autentificării, această funcție va șterge doar informațiile locale Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Clienți OAuth',
    'profile_oauth_no_clients'                  => 'Nu ați creat niciun client OAuth.',
    'profile_oauth_clients_external_auth'       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'              => 'Clienți',
    'profile_oauth_client_id'                   => 'ID Client',
    'profile_oauth_client_name'                 => 'Nume',
    'profile_oauth_client_secret'               => 'Secret',
    'profile_oauth_create_new_client'           => 'Creare client nou',
    'profile_oauth_create_client'               => 'Creare client',
    'profile_oauth_edit_client'                 => 'Editare client',
    'profile_oauth_name_help'                   => 'Ceva ce utilizatorii vor recunoaște și vor avea încredere.',
    'profile_oauth_redirect_url'                => 'Redirectioneaza URL',
    'profile_oauth_redirect_url_help'           => 'URL-ul de retroapelare al aplicației dvs.',
    'profile_authorized_apps'                   => 'Aplicațiile dvs autorizate',
    'profile_authorized_clients'                => 'Clienți autorizați',
    'profile_scopes'                            => 'Domenii',
    'profile_revoke'                            => 'Revocați',
    'profile_oauth_client_secret_title'         => 'Secret client',
    'profile_oauth_client_secret_expl'          => 'Aici este noul tău cod secret de client. Este singura dată când va fi afișat așa că nu îl pierzi! Acum poți folosi acest cod pentru a face cereri API.',
    'profile_personal_access_tokens'            => 'Token de acces personal',
    'profile_personal_access_token'             => 'Token de acces personal',
    'profile_oauth_confidential'                => 'Confidenţial',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Aici este noul dvs. token de acces personal. Este singura dată când va fi afișat așa că nu îl pierde! Acum poți folosi acest token pentru a face cereri API.',
    'profile_no_personal_access_token'          => 'Nu aţi creat nici un token personal de acces.',
    'profile_create_new_token'                  => 'Crează un nou token',
    'profile_create_token'                      => 'Crează token',
    'profile_create'                            => 'Crează',
    'profile_save_changes'                      => 'Salvează modificările',
    'profile_whoops'                            => 'Hopaa!',
    'profile_something_wrong'                   => 'A apărut o eroare!',
    'profile_try_again'                         => 'A apărut o problemă. Încercați din nou.',
    'amounts'                                   => 'Sume',
    'multi_account_warning_unknown'             => 'În funcție de tipul de tranzacție pe care o creați, contul sursei și/sau destinației fracționărilor ulterioare poate fi depășit cu orice se definește în prima împărțire a tranzacției.',
    'multi_account_warning_withdrawal'          => 'Reţineţi faptul că sursa scindărilor ulterioare va fi anulată de orice altceva definit în prima împărţire a retragerii.',
    'multi_account_warning_deposit'             => 'Țineți cont de faptul că destinația scindărilor ulterioare va fi depășită cu orice se definește la prima împărțire a depozitului.',
    'multi_account_warning_transfer'            => 'Reţineţi faptul că contul sursei + destinaţia fracţionărilor ulterioare va fi anulat de orice se defineşte în prima împărţire a transferului.',


    // export data:
    'export_data_title'                         => 'Exportă date din Firefly III',
    'export_data_menu'                          => 'Exportă datele',
    'export_data_bc'                            => 'Exportă date din Firefly III',
    'export_data_main_title'                    => 'Exportă date din Firefly III',
    'export_data_expl'                          => 'Acest link vă permite să exportați toate tranzacțiile + datele meta de la Firefly III. Vă rugăm să consultați ajutorul (pictograma din dreapta sus (?)) pentru mai multe informații despre proces.',
    'export_data_all_transactions'              => 'Exportă toate tranzacțiile',
    'export_data_advanced_expl'                 => 'Dacă aveți nevoie de un tip de export mai avansat sau specific, citiți despre modul de utilizare a comenzii în consolă <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Un atașament|:count atașamente',
    'attachments'                               => 'Atașamente',
    'edit_attachment'                           => 'Editați attachment ":name"',
    'update_attachment'                         => 'Actualizați atașament',
    'delete_attachment'                         => 'Șterge atașament ":name"',
    'attachment_deleted'                        => 'Atașament ":name" șters',
    'liabilities_deleted'                       => 'Provizionul ":name" a fost șters',
    'attachment_updated'                        => 'Atașament ":name" actualizat',
    'upload_max_file_size'                      => 'Dimensiunea maximă a fișierului: :size',
    'list_all_attachments'                      => 'Lista tuturor atașamentelor',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Cheltuieli',
    'title_withdrawal'                          => 'Cheltuieli',
    'title_revenue'                             => 'Venituri',
    'title_deposit'                             => 'Venituri',
    'title_transfer'                            => 'Transferuri',
    'title_transfers'                           => 'Transferuri',
    'submission_options'                        => 'Opţiuni de depunere',
    'apply_rules_checkbox'                      => 'Aplică regulile',
    'fire_webhooks_checkbox'                    => 'Webhook-uri de incendiu',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Această tranzacție este deja o retragere',
    'convert_is_already_type_Deposit'           => 'Această tranzacție este deja un depozit',
    'convert_is_already_type_Transfer'          => 'Această tranzacție este deja un transfer',
    'convert_to_Withdrawal'                     => 'Convertește ":description" la o retragere',
    'convert_to_Deposit'                        => 'Convertește ":description" la un depozit',
    'convert_to_Transfer'                       => 'Convertește ":description" la un transfer',
    'convert_options_WithdrawalDeposit'         => 'Convertește o retragere intr-un depozit',
    'convert_options_WithdrawalTransfer'        => 'Convertește o retragere intr-un transfer',
    'convert_options_DepositTransfer'           => 'Convertește un depozit intr-un transfer',
    'convert_options_DepositWithdrawal'         => 'Convertește un depozit intr-o retragere',
    'convert_options_TransferWithdrawal'        => 'Convertește un transfer intr-o retragere',
    'convert_options_TransferDeposit'           => 'Convertește un transfer intr-un depozit',
    'convert_Withdrawal_to_deposit'             => 'Convertește această retragere la un depozit',
    'convert_Withdrawal_to_transfer'            => 'Convertește această retragere la un transfer',
    'convert_Deposit_to_withdrawal'             => 'Convertește aceast depozit la o retragere',
    'convert_Deposit_to_transfer'               => 'Convertește această depozit la un transfer',
    'convert_Transfer_to_deposit'               => 'Convertește aceast transfer la un depozit',
    'convert_Transfer_to_withdrawal'            => 'Convertește aceast transfer la o retragere',
    'convert_please_set_revenue_source'         => 'Alegeți un cont de venituri din care vor proveni banii.',
    'convert_please_set_asset_destination'      => 'Alegeți un cont de active unde vor merge banii.',
    'convert_please_set_expense_destination'    => 'Alegeți un cont de cheltuieli unde vor merge banii.',
    'convert_please_set_asset_source'           => 'Alegeți un cont de active unde vor veni banii.',
    'convert_expl_w_d'                          => 'La conversia de la o retragere la un depozit, banii vor fi depozitați în contul de destinație afișat, în loc să fie retrași din acesta. La conversia de la o retragere la un depozit, banii vor fi depozitați în conturile de destinație afișate, în loc să fie retrași din acestea.',
    'convert_expl_w_t'                          => 'Când convertești o retragere într-un transfer, banii vor fi transferați departe de contul sursă în alt cont de activ sau de pasiv în loc să fie cheltuiți pe contul de cheltuieli inițial. Când convertești o retragere într-un transfer, banii vor fi transferați departe de conturile sursă în alte conturi de active sau de pasiv în loc să fie cheltuiți pe conturile inițiale de cheltuieli.',
    'convert_expl_d_w'                          => 'Atunci când convertești un depozit într-o retragere, banii vor fi retrași din contul sursă afișat, în loc să fie depozitați în acesta. Atunci când convertești un depozit într-o retragere, banii vor fi retrași din conturile sursă afișate, în loc să fie depozitați în acestea.',
    'convert_expl_d_t'                          => 'Când convertești un depozit într-un transfer, banii vor fi depozitați în contul de destinație listat din orice cont de active sau pasive. Când convertești un depozit într-un transfer, banii vor fi depozitați în conturile de destinație listate din oricare dintre conturile de active sau de pasiv ale dumneavoastră.',
    'convert_expl_t_w'                          => 'Când convertești un transfer într-o retragere, banii vor fi cheltuiți pe contul de destinație pe care îl setezi aici, în loc să fie transferați înapoi. Când convertești un transfer într-o retragere, banii vor fi cheltuiți pe conturile de destinație pe care le setezi aici, în loc să fie transferați la distanță.',
    'convert_expl_t_d'                          => 'Când convertești un transfer într-un depozit, banii vor fi depozitați în contul de destinație pe care îl vedeți aici, în loc să fie transferați în acesta. Când convertești un transfer într-un depozit, banii vor fi depozitați în conturile de destinație pe care le vedeți aici, în loc să fie transferați în ele.',
    'convert_select_sources'                    => 'Pentru a finaliza conversia, vă rugăm să setați noul cont sursă mai jos. Pentru a finaliza conversia, vă rugăm să setați mai jos conturile sursă noi.',
    'convert_select_destinations'               => 'Pentru a finaliza conversia, vă rugăm să selectaţi noul cont de destinaţie de mai jos. Pentru a finaliza conversia, selectaţi noul cont de destinaţie de mai jos.',
    'converted_to_Withdrawal'                   => 'Tranzacția a fost transformată în retragere',
    'converted_to_Deposit'                      => 'Tranzacția a fost transformată în depozit',
    'converted_to_Transfer'                     => 'Tranzacția a fost transformată în transfer',
    'invalid_convert_selection'                 => 'Contul pe care l-ați selectat este deja utilizat în această tranzacție sau nu există.',
    'source_or_dest_invalid'                    => 'Nu se pot găsi detaliile corecte ale tranzacției. Conversia nu este posibilă.',
    'convert_to_withdrawal'                     => 'Convertește la retragere',
    'convert_to_deposit'                        => 'Convertește la depozit',
    'convert_to_transfer'                       => 'Convertește la transfer',

    // create new stuff:
    'create_new_withdrawal'                     => 'Creați o nouă retragere',
    'create_new_deposit'                        => 'Creați un nou depozit',
    'create_new_transfer'                       => 'Creați un nou transfer',
    'create_new_asset'                          => 'Creați un nou cont de active',
    'create_new_liabilities'                    => 'Creare provizion nou',
    'create_new_expense'                        => 'Creați un nou cont de cheltuieli',
    'create_new_revenue'                        => 'Creați un nou cont de venituri',
    'create_new_piggy_bank'                     => 'Creați o nouă pușculiță',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Creați un abonament nou',
    'create_new_rule'                           => 'Creați o regulă nouă',

    // currencies:
    'create_currency'                           => 'Creați o nouă monedă',
    'store_currency'                            => 'Salvați o nouă monedă',
    'update_currency'                           => 'Actualizați monedă',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => 'Nu se poate șterge :nume deoarece este încă în uz.',
    'cannot_delete_fallback_currency'           => ':name este moneda de rezervă a sistemului și nu poate fi ștearsă.',
    'cannot_disable_currency_journals'          => 'Nu se poate dezactiva :name, deoarece tranzacțiile încă îl utilizează.',
    'cannot_disable_currency_last_left'         => 'Nu se poate dezactiva :name, deoarece este ultima monedă activată.',
    'cannot_disable_currency_account_meta'      => 'Nu se poate dezactiva :name deoarece este utilizat în conturile de active.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Nu se poate dezactiva :name deoareceeste utilizat în tranzacții recurente.',
    'cannot_disable_currency_available_budgets' => 'Nu se poate dezactiva :name deoarece este folosit în bugetele disponibile.',
    'cannot_disable_currency_budget_limits'     => 'Nu se poate dezactiva :name deoarece este utilizat în limite bugetare.',
    'cannot_disable_currency_current_default'   => 'Nu se poate dezactiva :name deoarece este moneda implicită curentă.',
    'cannot_disable_currency_system_fallback'   => 'Nu se poate dezactiva :name deoarece este moneda implicită a sistemului.',
    'disable_EUR_side_effects'                  => 'Euro este moneda de recuperare de urgență a sistemului. Dezactivarea acestuia poate avea efecte secundare nedorite și vă poate anula garanția.',
    'deleted_currency'                          => 'Moneda :name stearsă',
    'created_currency'                          => 'Moneda :name creată',
    'could_not_store_currency'                  => 'Nu am putut stoca o nouă monedă.',
    'updated_currency'                          => 'Moneda :name actualizată',
    'ask_site_owner'                            => 'Vă rugăm să întrebați :owner să adăuge, elimine sau editeze valute.',
    'currencies_intro'                          => 'Firefly III acceptă diferite valute pe care le puteți seta și activa aici.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Faceți implicit',
    'default_currency'                          => 'implicit',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Dezactivat',
    'enable_currency'                           => 'Activează',
    'disable_currency'                          => 'Dezactivează',
    'currencies_default_disabled'               => 'Cele mai multe dintre aceste monede sunt dezactivate în mod prestabilit. Pentru a le folosi, trebuie să le activați mai întâi.',
    'currency_is_now_enabled'                   => 'Moneda ":name" a fost activată',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Moneda ":name" a fost dezactivată',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Câmpuri obligatorii',
    'optionalFields'                            => 'Câmpuri opționale',
    'options'                                   => 'Opțiuni',

    // budgets:
    'daily_budgets'                             => 'Bugete zilnice',
    'weekly_budgets'                            => 'Bugete săptămânale',
    'monthly_budgets'                           => 'Bugete lunare',
    'quarterly_budgets'                         => 'Bugete trimestriale',
    'half_year_budgets'                         => 'Bugete semestriale',
    'yearly_budgets'                            => 'Bugete anuale',
    'other_budgets'                             => 'Bugete personalizate temporale',
    'budget_limit_not_in_range'                 => 'Această sumă se aplică de la :start la :end:',
    'total_available_budget'                    => 'Buget total disponibil (între :start și :end)',
    'total_available_budget_in_currency'        => 'Buget total disponibil în :currency',
    'see_below'                                 => 'vezi mai jos',
    'create_new_budget'                         => 'Creați un nou budget',
    'store_new_budget'                          => 'Salvați un nou budget',
    'stored_new_budget'                         => 'Bugetul ":name" a fost salvat',
    'available_between'                         => 'Disponibil între :start și :end',
    'transactionsWithoutBudget'                 => 'Cheltuieli fără buget',
    'transactions_no_budget'                    => 'Cheltuieli fără buget între :start și :end',
    'spent_between'                             => 'Cheltuit între :start și :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Setați suma disponibilă',
    'update_available_amount'                   => 'Actualizați suma disponibilă',
    'ab_basic_modal_explain'                    => 'Utilizați acest formular pentru a indica cât de mult doriți să bugeți (în total, în :currency) în perioada indicată.',
    'createBudget'                              => 'Buget nou',
    'invalid_currency'                          => 'Aceasta este o monedă nevalidă',
    'invalid_amount'                            => 'Vă rugăm să introduceţi o sumă',
    'set_ab'                                    => 'Suma disponibilă a bugetului a fost stabilită',
    'updated_ab'                                => 'Suma disponibilă a bugetului a fost actualizată',
    'deleted_ab'                                => 'Suma disponibilă a bugetului a fost ștearsă',
    'deleted_bl'                                => 'Suma disponibilă a bugetului a fost îndepărtat',
    'alt_currency_ab_create'                    => 'Setați bugetul disponibil într-o altă monedă',
    'bl_create_btn'                             => 'Setați bugetul într-o altă monedă',
    'inactiveBudgets'                           => 'Bugete inactive',
    'without_budget_between'                    => 'Tranzacții fără un buget între :start și :end',
    'delete_budget'                             => 'Șterge buget ":name"',
    'deleted_budget'                            => 'Buget ":name" șters',
    'edit_budget'                               => 'Editați buget ":name"',
    'updated_budget'                            => 'Buget ":name" actualizat',
    'update_amount'                             => 'Actualizați suma',
    'update_budget'                             => 'Actualizați bugetul',
    'update_budget_amount_range'                => 'Actualizați suma disponibilă între :start și :end',
    'set_budget_limit_title'                    => 'Setați suma bugetată pentru bugetul :budget între :start și :end',
    'set_budget_limit'                          => 'Setați suma bugetată',
    'budget_period_navigator'                   => 'Navigator pe perioada',
    'info_on_available_amount'                  => 'Ce am disponibil?',
    'available_amount_indication'               => 'Utilizați aceste sume pentru a obține o indicație cu privire la bugetul dvs. total.',
    'suggested'                                 => 'Sugerat',
    'average_between'                           => 'Media între :start și :end',
    'transferred_in'                            => 'Transferat (în)',
    'transferred_away'                          => 'Transferat (departe)',
    'auto_budget_none'                          => 'Fără auto-buget',
    'auto_budget_reset'                         => 'Stabiliți o sumă fixă pentru fiecare perioadă',
    'auto_budget_rollover'                      => 'Adaugă o sumă în fiecare perioadă',
    'auto_budget_adjusted'                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                  => 'Zilnic',
    'auto_budget_period_weekly'                 => 'Săptămânal',
    'auto_budget_period_monthly'                => 'Lunar',
    'auto_budget_period_quarterly'              => 'Trimestrial',
    'auto_budget_period_half_year'              => 'Fiecare jumătate de an',
    'auto_budget_period_yearly'                 => 'Anual',
    'auto_budget_help'                          => 'Poți citi mai multe despre această caracteristică din ajutor. Apasă pe icoana din dreapta sus (?).',
    'auto_budget_reset_icon'                    => 'Acest buget va fi stabilit periodic',
    'auto_budget_rollover_icon'                 => 'Suma bugetului va crește periodic',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Șterge suma înscrisă în :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Abonament',
    'not_expected_period'                       => 'Nu se aşteaptă această perioadă',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Nu (încă)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Repetă',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Tranzacții conectate',
    'auto_match_on'                             => 'Potrivire automată făcută de Firefly III',
    'auto_match_off'                            => 'Potrivirea nu este făcută automat de Firefly III',
    'next_expected_match'                       => 'Următoarea potrivire asteptată',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Mai mult',
    'rescan_old'                                => 'Rulează din nou regulile pentru toate tranzacțiile',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Abonamentul ":name" a fost salvat',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Așteptat între :start și :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'sari peste',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'regulă inactivă',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Se așteaptă :date',
    'bill_expected_date_js'                     => 'Așteptat {date}',
    'expected_amount'                           => 'Sumă (așteptată)',
    'bill_paid_on'                              => 'Plătit pe {date}',
    'bill_repeats_weekly'                       => 'Se repetă săptămânal',
    'bill_repeats_monthly'                      => 'Se repetă lunar',
    'bill_repeats_quarterly'                    => 'Repetă trimestrial',
    'bill_repeats_half-year'                    => 'Se repetă la fiecare jumătate de an',
    'bill_repeats_yearly'                       => 'Se repetă anual',
    'bill_repeats_weekly_other'                 => 'Se repetă in fiecare săptămâna',
    'bill_repeats_monthly_other'                => 'Se repetă la fiecare altă lună',
    'bill_repeats_quarterly_other'              => 'Se repetă in fiecare trimestru',
    'bill_repeats_half-year_other'              => 'Se repetă anual',
    'bill_repeats_yearly_other'                 => 'Se repetă la fiecare doi ani',
    'bill_repeats_weekly_skip'                  => 'Repeats every {skip} weeks',
    'bill_repeats_monthly_skip'                 => 'Repeats every {skip} months',
    'bill_repeats_quarterly_skip'               => 'Repeats every {skip} quarters',
    'bill_repeats_half-year_skip'               => 'Repeats every {skip} half years',
    'bill_repeats_yearly_skip'                  => 'Repeats every {skip} years',
    'subscriptions'                             => 'Subscripții',
    'go_to_subscriptions'                       => 'Mergi la abonamentele tale',
    'forever'                                   => 'Întotdeauna',
    'extension_date_is'                         => 'Extension date is {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'Suma datorata',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'Aveți un cont :count inactiv (arhivat), pe care îl puteți vizualiza pe această pagină separată. Aveți :count inactive (arhivate), pe care le puteți vizualiza pe această pagină separată.',
    'all_accounts_inactive'                     => 'Acestea sunt conturile dvs. inactive.',
    'active_account_link'                       => 'Acest link revine la conturile dvs. active.',
    'account_missing_transaction'               => 'Contul #:id (":name") nu pot fi vizualizate direct.',
    'cc_monthly_payment_date_help'              => 'Selectați în orice an și în orice lună, acesta va fi ignorat oricum. Numai ziua lunii este relevantă.',
    'details_for_asset'                         => 'Detalii pentru contul de active ":name"',
    'details_for_expense'                       => 'Detalii pentru contul de cheltuieli ":name"',
    'details_for_revenue'                       => 'Detalii pentru contul de venituri ":name"',
    'details_for_cash'                          => 'Detalii pentru contul de numerar ":name"',
    'store_new_asset_account'                   => 'Salvați un nou cont de active',
    'store_new_expense_account'                 => 'Salvați un nou cont de cheltuieli',
    'store_new_revenue_account'                 => 'Salvați un nou cont de venituri',
    'edit_asset_account'                        => 'Editați contul de active ":name"',
    'edit_expense_account'                      => 'Editați contul de cheltuieli ":name"',
    'edit_revenue_account'                      => 'Editați contul de venituri ":name"',
    'delete_asset_account'                      => 'Șterge contul de active ":name"',
    'delete_expense_account'                    => 'Șterge contul de cheltuieli ":name"',
    'delete_revenue_account'                    => 'Șterge contul de venituri ":name"',
    'delete_liabilities_account'                => 'Șterge provizionul ":name"',
    'asset_deleted'                             => 'Contul de active ":name" a fost șters cu succes',
    'account_deleted'                           => 'Cont ":name" șters cu succes',
    'expense_deleted'                           => 'Contul de cheltuieli ":name" a fost șters cu succes',
    'revenue_deleted'                           => 'Contul de venituri ":name" a fost șters cu succes',
    'update_asset_account'                      => 'Actualizați contul de active',
    'update_undefined_account'                  => 'Update account',
    'update_liabilities_account'                => 'Actualizați provizionul',
    'update_expense_account'                    => 'Actualizați cont de cheltuieli',
    'update_revenue_account'                    => 'Actualizați cont de venituri',
    'make_new_asset_account'                    => 'Creați un nou cont de active',
    'make_new_expense_account'                  => 'Creați un nou cont de cheltuieli',
    'make_new_revenue_account'                  => 'Creați un nou cont de venituri',
    'make_new_liabilities_account'              => 'Creați un nou provizion',
    'asset_accounts'                            => 'Conturile de active',
    'undefined_accounts'                        => 'Accounts',
    'asset_accounts_inactive'                   => 'Conturi de active (inactive)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Conturi de cheltuieli',
    'expense_accounts_inactive'                 => 'Conturi de cheltuieli (inactive)',
    'revenue_account'                           => 'Cont de venituri',
    'revenue_accounts'                          => 'Conturi de venituri',
    'revenue_accounts_inactive'                 => 'Conturi de venituri (inactive)',
    'cash_accounts'                             => 'Conturi de numerar',
    'Cash account'                              => 'Cont de numerar',
    'liabilities_accounts'                      => 'Provizioane',
    'liabilities_accounts_inactive'             => 'Pasive (inactive)',
    'reconcile_account'                         => 'Reconciliază/Potrivește contul ":account"',
    'overview_of_reconcile_modal'               => 'Privire de ansamblu asupra reconcilierii',
    'delete_reconciliation'                     => 'Șterge reconcilierea',
    'update_reconciliation'                     => 'Actualizați reconcilierea',
    'amount_cannot_be_zero'                     => 'Suma nu poate fi zero',
    'end_of_reconcile_period'                   => 'Sfârșitul perioadei de reconciliere: :period',
    'start_of_reconcile_period'                 => 'Începutul perioadei de reconciliere: :period',
    'start_balance'                             => 'Sold de început',
    'end_balance'                               => 'Sold final',
    'update_balance_dates_instruction'          => 'Potriviți sumele și datele de mai sus la extrasul de cont bancar și apăsați pe "Porniți reconcilierea"',
    'select_transactions_instruction'           => 'Selectați tranzacțiile care apar în extrasul dvs. bancar.',
    'select_range_and_balance'                  => 'Mai întâi verificați intervalul de date și balanțele. Apoi apăsați "Porniți reconcilierea"',
    'date_change_instruction'                   => 'Dacă schimbați acum intervalul de date, orice progres va fi pierdut.',
    'update_selection'                          => 'Actualizați selectaia',
    'store_reconcile'                           => 'Salvați reconcilierea',
    'reconciliation_transaction'                => 'Tranzacție de reconciliere',
    'Reconciliation'                            => 'Reconciliere',
    'reconciliation'                            => 'Reconciliere',
    'reconcile_options'                         => 'Optiuni reconciliere',
    'reconcile_range'                           => 'Domeniu de reconciliere',
    'start_reconcile'                           => 'Porniți reconcilierea',
    'cash_account_type'                         => 'Numerar',
    'cash'                                      => 'numerar',
    'cant_find_redirect_account'                => 'Firefly III a încercat să vă redirecționeze, dar nu a putut. Îmi pare rău pentru asta. Înapoi la index.',
    'account_type'                              => 'Tip cont',
    'save_transactions_by_moving'               => 'Salvați această tranzacție mutând-o într-un alt cont: | Salvați aceste tranzacții prin mutarea lor într-un alt cont:',
    'save_transactions_by_moving_js'            => 'Fără tranzacții* Salvați această tranzacție mutând-o în alt cont. | Salvați aceste tranzacții mutându-le într-un alt cont.',
    'stored_new_account'                        => 'Cont nou ":name" salvat!',
    'stored_new_account_js'                     => 'Cont nou "<a href="accounts/show/{ID}">{name}</a>" stocat!',
    'updated_account'                           => 'Contul ":name" actualizat',
    'updated_account_js'                        => 'Cont actualizat "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Opțiuni pentru carduri de credit',
    'no_transactions_account'                   => 'Nu există tranzacții (în această perioadă) pentru contul de activ ":name".',
    'no_transactions_period'                    => 'Nu există nicio tranzacție (in această perioadă).',
    'no_data_for_chart'                         => 'Nu există suficiente informații (încă) pentru a genera acest grafic.',
    'select_at_least_one_account'               => 'Selectați cel puțin un cont de active',
    'select_at_least_one_category'              => 'Selectați cel puțin o categorie',
    'select_at_least_one_budget'                => 'Selectați cel puțin un buget',
    'select_at_least_one_tag'                   => 'Selectați cel puțin o eticheta',
    'select_at_least_one_expense'               => 'Selectați cel puțin o combinație cont de cheltuieli/venituri. Dacă nu ai încă nici una (lista este goală) acest raport nu este disponibil.',
    'account_default_currency'                  => 'Aceasta va fi moneda implicită asociată acestui cont.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Registrul dvs are mai mulți bani în ea decât banca dvs. susține că ar trebui să aveți. Există mai multe opțiuni. Alegeți ce să faceți. Apoi, apăsați "Confirmați reconcilierea".',
    'reconcile_has_less'                        => 'Registrul dvs are mai puțini bani în ea decât banca dvs. susține că ar trebui să aveți. Există mai multe opțiuni. Alegeți ce să faceți. Apoi, apăsați "Confirmați reconcilierea".',
    'reconcile_is_equal'                        => 'Registrul si declarațiile dvs. de cont se potrivesc. Nu e nimic de facut. Te rog apasă "Confirmați reconcilierea" to confirm your input.',
    'create_pos_reconcile_transaction'          => 'Goliți tranzacțiile selectate și creați o corecție adăugând :amount la acest cont de active.',
    'create_neg_reconcile_transaction'          => 'Goliți tranzacțiile selectate și creați o corecție ștergând :amount din acest cont de active.',
    'reconcile_do_nothing'                      => 'Goliți tranzacțiile selectate, dar nu corectați.',
    'reconcile_go_back'                         => 'Puteți modifica sau șterge întotdeauna o corecție mai târziu.',
    'must_be_asset_account'                     => 'Puteți reconcilia numai contul de active',
    'reconciliation_stored'                     => 'Reconciliere salvată',
    'reconciliation_error'                      => 'Din cauza unei erori tranzacțiile au fost marcate ca reconciliate, dar corectarea nu a fost stocată: :error.',
    'reconciliation_transaction_title'          => 'Reconciliere (:from la :to)',
    'sum_of_reconciliation'                     => 'Suma împăcărilor',
    'reconcile_this_account'                    => 'Reconciliați acest cont',
    'reconcile'                                 => 'Reconcilia',
    'show'                                      => 'Afișează',
    'confirm_reconciliation'                    => 'Confirmați reconcilierea',
    'submitted_start_balance'                   => 'Balanța inițială afișată',
    'selected_transactions'                     => 'Tranzacții selectate (:count)',
    'already_cleared_transactions'              => 'Au fost deja tranzacții eliminate (:count)',
    'submitted_end_balance'                     => 'Sold final afițat',
    'initial_balance_description'               => 'Sold inițial pentru ":account"',
    'liability_credit_description'              => 'Liability credit for ":account"',
    'interest_calc_'                            => 'necunoscut',
    'interest_calc_daily'                       => 'Pe zi',
    'interest_calc_monthly'                     => 'Pe lună',
    'interest_calc_yearly'                      => 'Pe an',
    'interest_calc_weekly'                      => 'Pe săptămână',
    'interest_calc_half-year'                   => 'Pe jumătate de an',
    'interest_calc_quarterly'                   => 'Pe trimestru',
    'initial_balance_account'                   => 'Bilanțul inițial al contului :account',
    'list_options'                              => 'Opțiuni listă',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Categorie nouă',
    'create_new_category'                       => 'Creați o nouă categorie',
    'without_category'                          => 'Fară o categorie',
    'update_category'                           => 'Actualizați categoria',
    'updated_category'                          => 'Categorie ":name" actualizată',
    'categories'                                => 'Categorii',
    'edit_category'                             => 'Editați categoria ":name"',
    'no_category'                               => '(nici o categorie)',
    'unknown_category_plain'                    => 'Nici o categorie',
    'category'                                  => 'Categorie',
    'delete_category'                           => 'Șterge categoria ":name"',
    'deleted_category'                          => 'Categorie ":name" ștearsă',
    'store_category'                            => 'Salvați o nouă categorie',
    'stored_category'                           => 'Categorie nouă ":name" salvată',
    'without_category_between'                  => 'Fără categorie între :start și :end',


    // transactions:
    'wait_loading_transaction'                  => 'Vă rugăm să aşteptaţi ca formularul să se încarce',
    'wait_loading_data'                         => 'Vă rugăm să așteptați ca informațiile dvs. să se încarce...',
    'wait_attachments'                          => 'Așteptați ca atașamentele să fie încărcate.',
    'errors_upload'                             => 'Incarcarea a esuat. Te rugam sa verifici consola browser-ului pentru eroare.',
    'amount_foreign_if'                         => 'Suma în valută, dacă este cazul',
    'amount_destination_account'                => 'Suma în moneda contului de destinaţie',
    'edit_transaction_title'                    => 'Editare tranzacţie ":description"',
    'unreconcile'                               => 'Anulează reconcilierea',
    'update_withdrawal'                         => 'Actualizați retragere',
    'update_deposit'                            => 'Actualizați depozit',
    'update_transaction'                        => 'Actualizați tranzacția',
    'update_transfer'                           => 'Actualizați transfer',
    'updated_withdrawal'                        => 'Retragerea ":description" actualizată',
    'updated_deposit'                           => 'Depozitul ":description" actualizat',
    'updated_transfer'                          => 'Transferul ":description" actualizat',
    'no_changes_withdrawal'                     => 'Retragerea ":description" nu a fost modificată.',
    'no_changes_deposit'                        => 'Depozitul ":description" nu a fost modificat.',
    'no_changes_transfer'                       => 'Transferul ":description" nu a fost modificat.',
    'delete_withdrawal'                         => 'Șterge retragere ":description"',
    'delete_deposit'                            => 'Șterge depozit ":description"',
    'delete_transfer'                           => 'Șterge transfer ":description"',
    'deleted_withdrawal'                        => 'Retragerea ":description" ștearsă cu succes',
    'deleted_deposit'                           => 'Depozitul ":description" șters cu succes',
    'deleted_transfer'                          => 'Transferul ":description" șters cu succes',
    'deleted_reconciliation'                    => 'Tranzacție de reconciliere ":description" a fost ștearsă cu succes',
    'stored_journal'                            => 'A fost creată cu succes o tranzacție nouă ":description"',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Tranzacția s-a creat cu succes',
    'updated_journal_no_descr'                  => 'Tranzacția s-a actualizat cu succes',
    'select_transactions'                       => 'Selectați tranzacțiile',
    'rule_group_select_transactions'            => 'Aplică ":title" la tranzacții',
    'rule_select_transactions'                  => 'Aplică ":title" la tranzacții',
    'stop_selection'                            => 'Opriți selectarea tranzacțiilor',
    'reconcile_selected'                        => 'Reconcilia',
    'mass_delete_journals'                      => 'Ștergeți un număr de tranzacții',
    'mass_edit_journals'                        => 'Editați un număr de tranzacții',
    'mass_bulk_journals'                        => 'Editarea în bloc un număr de tranzacții',
    'mass_bulk_journals_explain'                => 'Acest formular vă permite să modificați proprietățile tranzacțiilor enumerate mai jos într-o actualizare completă. Toate tranzacțiile din tabel vor fi actualizate atunci când modificați parametrii pe care îi vedeți aici.',
    'part_of_split'                             => 'Această tranzacție face parte dintr-o tranzacție divizată. Dacă nu ați selectat toate divizările, puteți ajunge să schimbați doar jumătate din tranzacție.',
    'bulk_set_new_values'                       => 'Utilizați input-urile de mai jos pentru a seta noi valori. Dacă le lăsați goale, vor fi goale toate. De asemenea, rețineți că doar bugetele vor primi un buget.',
    'no_bulk_category'                          => 'Nu actualizați categoria',
    'no_bulk_budget'                            => 'Nu actualizați budgetul',
    'no_bulk_tags'                              => 'Nu actualizați etichetă(e) ',
    'replace_with_these_tags'                   => 'Înlocuiește cu aceste etichete',
    'append_these_tags'                         => 'Adaugă aceste etichete',
    'mass_edit'                                 => 'Editează individual',
    'bulk_edit'                                 => 'Editează cele selectate in masă (bulk)',
    'mass_delete'                               => 'Șterge elementele selectate',
    'cannot_edit_other_fields'                  => 'Nu poți edita alte câmpuri decât cele de aici, pentru că nu există loc pentru a le arăta. Urmați linkul și editați-l câte unul, dacă aveți nevoie să editați aceste câmpuri.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(nici un buget)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Cont pe buget',
    'account_per_category'                      => 'Cont pe categorie',
    'create_new_object'                         => 'Creează',
    'empty'                                     => '(gol)',
    'all_other_budgets'                         => '(toate celelalte bugete)',
    'all_other_accounts'                        => '(toate celelalte conturi)',
    'expense_per_source_account'                => 'Cheltuieli pe contul sursă',
    'expense_per_destination_account'           => 'Cheltuieli pe contul de destinație',
    'income_per_destination_account'            => 'Venit pe contul de destinație',
    'spent_in_specific_category'                => 'Cheltuit în categoria ":category"',
    'earned_in_specific_category'               => 'Câștigat în categoria ":category"',
    'spent_in_specific_tag'                     => 'Cheltuit in eticheta ":tag"',
    'earned_in_specific_tag'                    => 'Câștigat in eticheta ":tag"',
    'income_per_source_account'                 => 'Venit pe cont sursă',
    'average_spending_per_destination'          => 'Cheltuieli medii pe contul de destinație',
    'average_spending_per_source'               => 'Cheltuieli medii pe contul sursă',
    'average_earning_per_source'                => 'Venitul mediu pe cont sursă',
    'average_earning_per_destination'           => 'Venitul mediu pe cont de destinație',
    'account_per_tag'                           => 'Cont pe etichetă',
    'tag_report_expenses_listed_once'           => 'Cheltuielile și veniturile nu sunt listate niciodată de două ori. Dacă o tranzacție are mai multe etichete, poate apărea doar sub una dintre etichetele sale. Această listă poate părea că lipsesc date, dar sumele vor fi corecte.',
    'double_report_expenses_charted_once'       => 'Cheltuielile și veniturile nu sunt afișate niciodată de două ori. Dacă o tranzacție are mai multe etichete, poate apărea doar sub una dintre etichetele sale. Acest grafic poate părea că lipsesc date, dar sumele vor fi corecte.',
    'tag_report_chart_single_tag'               => 'Acest grafic se aplică unei singure etichete. Dacă o tranzacție are mai multe etichete, ceea ce vedeți aici poate fi reflectat și în graficele altor etichete.',
    'tag'                                       => 'Etichetă',
    'no_budget_squared'                         => '(nici un buget)',
    'perm-delete-many'                          => 'Ștergerea multor articole dintr-o dată poate fi foarte perturbatoare. Vă rugăm să fiți precaut. Puteți șterge o parte dintr-o tranzacție divizată din această pagină, așa că aveți grijă.',
    'mass_deleted_transactions_success'         => 'S-a șters :count tranzacție.<unk> :count tranzacții.',
    'mass_edited_transactions_success'          => 'Actualizat :count tranzacție. | Actualizat :count tranzacții.',
    'opt_group_'                                => '(niciun tip de cont)',
    'opt_group_no_account_type'                 => '(niciun tip de cont)',
    'opt_group_defaultAsset'                    => 'Ccont de active implicit',
    'opt_group_savingAsset'                     => 'Cont de economii',
    'opt_group_sharedAsset'                     => 'Cont de active partajat',
    'opt_group_ccAsset'                         => 'Carduri de credit',
    'opt_group_cashWalletAsset'                 => 'Cash - Numerar',
    'opt_group_expense_account'                 => 'Conturi de cheltuieli',
    'opt_group_revenue_account'                 => 'Conturi de venituri',
    'opt_group_l_Loan'                          => 'Provizion: Împrumut',
    'opt_group_cash_account'                    => 'Cont de numerar',
    'opt_group_l_Debt'                          => 'Provizion: Datorie',
    'opt_group_l_Mortgage'                      => 'Provizion: Credit ipotecar',
    'opt_group_l_Credit card'                   => 'Provizion: Card de credit',
    'notes'                                     => 'Notițe',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Nu a putut fi stocată tranzacția. Te rog verifică log-urile.',
    'attachment_not_found'                      => 'Acest atașament nu a putut fi găsit.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Tranzacția #{ID} ("{title}")</a> a fost stocată.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Tranzacția #{ID}</a> a fost stocată.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Tranzacția #{ID}</a> ("{title}") a fost actualizată.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Tranzacția #{ID}</a> ("{title}") nu a primit nicio modificare.',
    'first_split_decides'                       => 'Prima împărțire determină valoarea acestui câmp',
    'first_split_overrules_source'              => 'Prima împărțire poate suprascrie contul sursă',
    'first_split_overrules_destination'         => 'Prima împărțire poate suprascrie contul de destinație',
    'spent_x_of_y'                              => 'Cheltuit {amount} din {total}',

    // new user:
    'welcome'                                   => 'Bine ați venit!',
    'submit'                                    => 'Trimite',
    'submission'                                => 'Transmitere',
    'submit_yes_really'                         => 'Trimite (Știu ce fac)',
    'getting_started'                           => 'Introducere',
    'to_get_started'                            => 'Este bine să vedeți că ați instalat cu succes Firefly III. Pentru a începe cu acest instrument, introduceți numele băncii dvs. și soldul contului de control principal. Nu vă faceți griji încă dacă aveți mai multe conturi. Puteți să le adăugați mai târziu. Firefly III are nevoie de ceva de început.',
    'savings_balance_text'                      => 'Firefly III va crea automat un cont de economii pentru dvs. În mod implicit, în contul dvs. de economii nu vor mai fi bani, dar dacă scrii balanța, acesta va fi salvat.',
    'finish_up_new_user'                        => 'Asta e! Puteți continua apăsând pe <strong> Trimiteți </ strong>. Veți fi duși la indexul Firefly III.',
    'stored_new_accounts_new_user'              => 'Ura! Conturile dvs. noi au fost salvate.',
    'set_preferred_language'                    => 'Dacă preferați să utilizați Firefly III într-o altă limbă, vă rugăm să indicați aici.',
    'language'                                  => 'Limbă',
    'new_savings_account'                       => ':bank_name cont de economii',
    'cash_wallet'                               => 'Portofel în numerar',
    'currency_not_present'                      => 'Dacă moneda pe care o utilizați în mod normal nu este listată, nu vă faceți griji. Puteți crea propriile valute în Opțiuni> Monede.',

    // home page:
    'transaction_table_description'             => 'Un tabel care conține tranzacțiile tale',
    'opposing_account'                          => 'Cont opus',
    'yourAccounts'                              => 'Conturile dvs.',
    'your_accounts'                             => 'Prezentarea generală a contului',
    'category_overview'                         => 'Categorie - prezentare generală',
    'expense_overview'                          => 'Prezentare generală cont cheltuială',
    'revenue_overview'                          => 'Prezentare generală cont venituri',
    'budgetsAndSpending'                        => 'Bugetele și cheltuielile',
    'budgets_and_spending'                      => 'Bugete și cheltuieli',
    'go_to_budget'                              => 'Mergi la buget "{budget}"',
    'go_to_deposits'                            => 'Du-te la depozite',
    'go_to_expenses'                            => 'Mergi la cheltuieli',
    'savings'                                   => 'Economii',
    'newWithdrawal'                             => 'Cheltuieli noi',
    'newDeposit'                                => 'Depozit nou',
    'newTransfer'                               => 'Transfer nou',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Pe zi',
    'left_to_spend_per_day'                     => 'Rămas de cheltui pe zi',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Perioadă personalizată',
    'reset_to_current'                          => 'Resetare la perioada curentă',
    'select_period'                             => 'Selectați o perioadă',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Monedă',
    'preferences'                               => 'Preferințe',
    'logout'                                    => 'Ieșire',
    'logout_other_sessions'                     => 'Deconectează toate celelalte sesiuni',
    'toggleNavigation'                          => 'Navigare',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Cautare...',
    'version'                                   => 'Versiunea',
    'dashboard'                                 => 'Panou de control',
    'income_and_expense'                        => 'Venituri și cheltuieli',
    'all_money'                                 => 'Toți banii tăi',
    'unknown_source_plain'                      => 'Cont sursă necunoscut',
    'unknown_dest_plain'                        => 'Cont de destinație necunoscut',
    'unknown_any_plain'                         => 'Cont necunoscut',
    'unknown_budget_plain'                      => 'Fără buget',
    'available_budget'                          => 'Buget disponibil ({currency})',
    'currencies'                                => 'Monede',
    'activity'                                  => 'Activitate',
    'usage'                                     => 'Utilizare',
    'accounts'                                  => 'Conturi',
    'Asset account'                             => 'Cont de active',
    'Default account'                           => 'Cont activ principal',
    'Expense account'                           => 'Cont de cheltuieli',
    'Revenue account'                           => 'Contul de venituri',
    'Initial balance account'                   => 'Sold cont inițial',
    'account_type_Asset account'                => 'Cont de activ',
    'account_type_Expense account'              => 'Cont de cheltuieli',
    'account_type_Revenue account'              => 'Cont de venituri',
    'account_type_Debt'                         => 'Datorie',
    'account_type_Loan'                         => 'Împrumut',
    'account_type_Mortgage'                     => 'Credit ipotecar',
    'account_type_debt'                         => 'Datorie',
    'account_type_loan'                         => 'Împrumut',
    'account_type_mortgage'                     => 'Credit ipotecar',
    'account_type_Credit card'                  => 'Card de credit',
    'credit_card_type_monthlyFull'              => 'Plata integrală în fiecare lună',
    'liability_direction_credit'                => 'Sunt datorat acestei datorii',
    'liability_direction_debit'                 => 'Datorăm această datorie altcuiva',
    'liability_direction_credit_short'          => 'Îndatorat',
    'liability_direction_debit_short'           => 'Creditor',
    'liability_direction__short'                => 'Necunoscut',
    'liability_direction_null_short'            => 'Necunoscut',
    'Liability credit'                          => 'Credit de răspundere',
    'budgets'                                   => 'Buget',
    'tags'                                      => 'Etichete',
    'reports'                                   => 'Rapoarte',
    'transactions'                              => 'Tranzacții',
    'expenses'                                  => 'Cheltuieli',
    'income'                                    => 'Venituri',
    'transfers'                                 => 'Transferuri',
    'moneyManagement'                           => 'Gestionarea banilor',
    'money_management'                          => 'Gestionarea banilor',
    'tools'                                     => 'Instrumente',
    'piggyBanks'                                => 'Pușculiță',
    'piggy_banks'                               => 'Pușculiță',
    'amount_x_of_y'                             => '{current} din {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Retragere',
    'opening_balance'                           => 'Soldul de deschidere',
    'deposit'                                   => 'Depozit',
    'account'                                   => 'Cont',
    'transfer'                                  => 'Transfer',
    'Withdrawal'                                => 'Retragere',
    'Deposit'                                   => 'Depozit',
    'Transfer'                                  => 'Transfer',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Da',
    'no'                                        => 'Nu',
    'amount'                                    => 'Sumă',
    'overview'                                  => 'Imagine de ansamblu',
    'saveOnAccount'                             => 'Salvați în cont',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Necunoscut',
    'monthly'                                   => 'Lunar',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Erori',
    'debt_start_date'                           => 'Data de începere a datoriilor',
    'debt_start_amount'                         => 'Valoarea inițială a datoriei',
    'debt_start_amount_help'                    => 'Este întotdeauna cel mai bine să setezi această valoare la o valoare negativă. Citește paginile de ajutor [iconița din dreapta sus (?)] pentru mai multe informații.',
    'interest_period_help'                      => 'Acest câmp este pur cosmetic și nu va fi calculat pentru tine. Se pare că băncile sunt foarte deranjante așa că Firefly III nu reușește niciodată.',
    'store_new_liabilities_account'             => 'Salvați provizion nou',
    'edit_liabilities_account'                  => 'Editați provizion ":name"',
    'financial_control'                         => 'Controlul financiar',
    'accounting'                                => 'Contabilitate',
    'automation'                                => 'Automatizare',
    'others'                                    => 'Altele',
    'classification'                            => 'Clasificare',
    'store_transaction'                         => 'Tranzacție magazin',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Raportul financiar prestabilit între :start și :end',
    'report_audit'                              => 'Afișarea istoricului tranzacțiilor între :start și :end',
    'report_category'                           => 'Raport privind categoria între :start și :end',
    'report_double'                             => 'Raport privind cheltuielile / veniturile între :start și :end',
    'report_budget'                             => 'Raport privind bugetul între :start și :end',
    'report_tag'                                => 'Raport privind etichetele între :start și :end',
    'quick_link_reports'                        => 'Link-uri rapide',
    'quick_link_examples'                       => 'Acestea sunt doar câteva exemple de linkuri pentru a începe. Consultați paginile de ajutor de la butonul (?) pentru informații despre toate rapoartele și cuvintele magice pe care le puteți utiliza.',
    'quick_link_default_report'                 => 'Raportul financiar prestabilit',
    'quick_link_audit_report'                   => 'Afișarea istoricului tranzacțiilor',
    'report_this_month_quick'                   => 'Luna curentă, toate conturile',
    'report_last_month_quick'                   => 'Luna curentă, toate conturile',
    'report_this_year_quick'                    => 'Anul curent, toate conturile',
    'report_this_fiscal_year_quick'             => 'Anul fiscal curent, toate conturile',
    'report_all_time_quick'                     => 'Tot timpul, toate conturile',
    'reports_can_bookmark'                      => 'Rețineți că rapoartele pot fi marcate ca favorite.',
    'incomeVsExpenses'                          => 'Venituri vs. cheltuieli',
    'accountBalances'                           => 'Solduri de cont',
    'balanceStart'                              => 'Sold la începutul perioadei',
    'balanceEnd'                                => 'Sold la sfârșitul perioadei',
    'splitByAccount'                            => 'Împărțire după cont',
    'coveredWithTags'                           => 'Acoperite cu etichete',
    'leftInBudget'                              => 'Rămasă în bugetul',
    'left_in_debt'                              => 'Suma datorată',
    'sumOfSums'                                 => 'Suma sumelor',
    'noCategory'                                => '(nici o categorie)',
    'notCharged'                                => 'Nu este taxat (încă)',
    'inactive'                                  => 'Inactiv',
    'active'                                    => 'Activ',
    'difference'                                => 'Diferență',
    'money_flowing_in'                          => 'În',
    'money_flowing_out'                         => 'Afară',
    'topX'                                      => 'top :number',
    'show_full_list'                            => 'Afișați întreaga listă',
    'show_only_top'                             => 'Afișează numai topul :number',
    'report_type'                               => 'Tip de raport',
    'report_type_default'                       => 'Raportul financiar prestabilit',
    'report_type_audit'                         => 'Afișarea istoricului tranzacțiilor (audit)',
    'report_type_category'                      => 'Raport privind categoria',
    'report_type_budget'                        => 'Raport privind bugetul',
    'report_type_tag'                           => 'Raport privind etichetele',
    'report_type_double'                        => 'Raport privind contul de cheltuieli / venituri',
    'more_info_help'                            => 'Mai multe informații despre aceste tipuri de rapoarte pot fi găsite în paginile de ajutor. Apăsați pictograma (?) Din colțul din dreapta sus.',
    'report_included_accounts'                  => 'Conturi incluse',
    'report_date_range'                         => 'Interval de date',
    'report_preset_ranges'                      => 'Valori prestabilite',
    'shared'                                    => 'Partajate',
    'fiscal_year'                               => 'An fiscal',
    'income_entry'                              => 'Venituri din cont ":name" între :start și :end',
    'expense_entry'                             => 'Cheltuieli în cont ":name" între :start și :end',
    'category_entry'                            => 'Cheltuieli și venituri în categoria ":name" între :start și :end',
    'budget_spent_amount'                       => 'Cheltuieli în bugetul ":budget" între :start și :end',
    'balance_amount'                            => 'Cheltuieli în bugetul ":budget" plătit din cont ":account" între :start și :end',
    'no_audit_activity'                         => 'Nu a fost înregistrată nici o activitate în contul <a href=":url" title=":account_name">:account_name</a> între :start și :end.',
    'audit_end_balance'                         => 'Soldul contului <a href=":url" title=":account_name">:account_name</a> la sfârșitul :end a fost: :balance',
    'reports_extra_options'                     => 'Opțiuni suplimentare',
    'report_has_no_extra_options'               => 'Acest raport nu are opțiuni suplimentare',
    'reports_submit'                            => 'Vizualizează raportul',
    'end_after_start_date'                      => 'Data de încheiere a raportului trebuie să fie după data de începere.',
    'select_category'                           => 'Selectați categoria (categoriile)',
    'select_budget'                             => 'Selectați bugetul (bugetele).',
    'select_tag'                                => 'Selectați eticheta (-urile).',
    'income_per_category'                       => 'Venituri pe categorie',
    'expense_per_category'                      => 'Cheltuială pe categorie',
    'expense_per_budget'                        => 'Cheltuială pe buget',
    'income_per_account'                        => 'Venituri pe cont',
    'expense_per_account'                       => 'Cheltuială pe cont',
    'expense_per_tag'                           => 'Cheltuială pe eticheta',
    'income_per_tag'                            => 'Venituri pe eticheta',
    'include_expense_not_in_budget'             => 'Cheltuielile incluse nu sunt în bugetul (bugetele) selectat (e)',
    'include_expense_not_in_account'            => 'Cheltuielile incluse nu sunt în contul (conturile) selectat (e)',
    'include_expense_not_in_category'           => 'Cheltuielile incluse nu sunt în categoria (categoriile) selectat (e)',
    'include_income_not_in_category'            => 'Veniturile incluse nu sunt în categoria (categoriile) selectat (e)',
    'include_income_not_in_account'             => 'Veniturile incluse nu sunt în contul (conturile) selectat (e)',
    'include_income_not_in_tags'                => 'Veniturile incluse nu sunt în etichetă(e) selectat (e)',
    'include_expense_not_in_tags'               => 'Cheltuielile incluse nu sunt în etichete',
    'everything_else'                           => 'Orice altceva',
    'income_and_expenses'                       => 'Venituri și cheltuieli',
    'spent_average'                             => 'Cheltuit (in medie)',
    'income_average'                            => 'Venituri (in medie)',
    'transaction_count'                         => 'Numărul de tranzacții',
    'average_spending_per_account'              => 'Cheltuielile medii pe cont',
    'average_income_per_account'                => 'Venitul mediu pe cont',
    'total'                                     => 'Total',
    'description'                               => 'Descriere',
    'sum_of_period'                             => 'Suma perioadei',
    'average_in_period'                         => 'Media în perioada',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Contul implicit activ',
    'account_role_sharedAsset'                  => 'Contul de active partajat',
    'account_role_savingAsset'                  => 'Cont de economii',
    'account_role_ccAsset'                      => 'Card de credit',
    'account_role_cashWalletAsset'              => 'Cash - Numerar',
    'budget_chart_click'                        => 'Faceți clic pe un nume de buget din tabelul de mai sus pentru a vedea o grafic.',
    'category_chart_click'                      => 'Clic pe numele unei categorii din tabelul de mai sus pentru a vedea un grafic.',
    'in_out_accounts'                           => 'Câștigat și cheltuit pe combinație',
    'in_out_accounts_per_asset'                 => 'Câștigat și cheltuit (pe cont de activ)',
    'in_out_per_category'                       => 'Câștigat și cheltuit pe categorie',
    'out_per_budget'                            => 'Cheltuit pe buget',
    'select_expense_revenue'                    => 'Selectați contul de cheltuieli / venituri',
    'multi_currency_report_sum'                 => 'Deoarece această listă conține conturi cu mai multe valute, suma (sumele) pe care o vedeți este posibil să nu aibă sens. Raportul va reveni întotdeauna la moneda dvs. prestabilită.',
    'sum_in_default_currency'                   => 'Suma va fi întotdeauna în moneda dvs. prestabilită.',
    'net_filtered_prefs'                        => 'Acest grafic nu va include niciodată conturi care nu au selectat opțiunea "Include în valoare netă".',


    // charts:
    'chart'                                     => 'Grafic',
    'month'                                     => 'Lună',
    'budget'                                    => 'Buget',
    'spent'                                     => 'Cheltuit',
    'spent_capped'                              => 'Cheltuit (plafonat)',
    'spent_in_budget'                           => 'Cheltuit în budget',
    'left_to_spend'                             => 'Ramas de cheltuit',
    'earned'                                    => 'Câștigat',
    'overspent'                                 => 'Depășire de buget',
    'left'                                      => 'Rămas',
    'max-amount'                                => 'Sumă maximă',
    'min-amount'                                => 'Valoare minimă',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Nume',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Dată',
    'date_and_time'                             => 'Data și ora',
    'time'                                      => 'Timp',
    'paid'                                      => 'Plătit',
    'unpaid'                                    => 'Neplătit',
    'day'                                       => 'Zi',
    'budgeted'                                  => 'Bugetat',
    'period'                                    => 'Perioada',
    'balance'                                   => 'Balantă',
    'in_out_period'                             => 'În + afară această perioadă',
    'sum'                                       => 'Sumă',
    'summary'                                   => 'Rezumat',
    'average'                                   => 'In medie',
    'balanceFor'                                => 'Balanta pentru :name',
    'no_tags'                                   => '(fără etichete)',
    'nothing_found'                             => 'nu a fost găsit nimic',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Istoric evenimente',
    'add_money_to_piggy'            => 'Adăugați bani la pușculiță ":name"',
    'piggy_bank'                    => 'Pușculiță',
    'new_piggy_bank'                => 'Pușculiță nouă',
    'store_piggy_bank'              => 'Salvați pușculița',
    'stored_piggy_bank'             => 'Pușculița ":name" a fost salvată',
    'account_status'                => 'Starea contului',
    'left_for_piggy_banks'          => 'Rămas pentru pușculiță',
    'sum_of_piggy_banks'            => 'Suma pușculiței',
    'saved_so_far'                  => 'Salvat până acum',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Rămas de salvat',
    'suggested_amount'              => 'Sumă lunară sugerată pentru salvare',
    'add_money_to_piggy_title'      => 'Adăugați bani la pușculița ":name"',
    'remove_money_from_piggy_title' => 'Scoateți bani de la pușculița ":name"',
    'add'                           => 'Adaugă',
    'no_money_for_piggy'            => 'Nu ai încă bani de pus în această pușculiță.',
    'suggested_savings_per_month'   => 'Sugerat pe lună',

    'remove'                    => 'Elimină',
    'max_amount_add'            => 'Suma maximă pe care o puteți adăuga este',
    'max_amount_remove'         => 'Suma maximă pe care o puteți elimina este',
    'update_piggy_button'       => 'Actualizați pușculiță',
    'update_piggy_title'        => 'Actualizați pușculița ":name"',
    'updated_piggy_bank'        => 'Pușculiță ":name" a fost actualizată',
    'details'                   => 'Detalii',
    'events'                    => 'Evenimente',
    'target_amount'             => 'Sumă țintă',
    'start_date'                => 'Data de început',
    'no_start_date'             => 'Nu există o dată de începere',
    'target_date'               => 'Data țintă',
    'no_target_date'            => 'Nu există o dată vizată',
    'table'                     => 'Tabel',
    'delete_piggy_bank'         => 'Șterge pușculița ":name"',
    'cannot_add_amount_piggy'   => 'Nu s-a putut adăuga :amount la ":name".',
    'cannot_remove_from_piggy'  => 'Nu s-a putut elimina :amount din ":name".',
    'deleted_piggy_bank'        => 'Pușculița ":name" a fost ștearsă',
    'added_amount_to_piggy'     => 'Adăugat :amount la ":name"',
    'removed_amount_from_piggy' => 'Eliminat :amount din ":name"',
    'piggy_events'              => 'Pușculițe asociate',

    // tags
    'delete_tag'                => 'Șterge eticheta ":tag"',
    'deleted_tag'               => 'Eticheta ":tag" a fost ștearsă',
    'new_tag'                   => 'Faceți o nouă eticheta',
    'edit_tag'                  => 'Editați eticheta ":tag"',
    'updated_tag'               => 'Eticheta ":tag" a fost actualizat',
    'created_tag'               => 'Eticheta ":tag" a fost creat!',

    'transaction_journal_information'               => 'Informații despre tranzacții',
    'transaction_journal_amount'                    => 'Informații sumă',
    'transaction_journal_meta'                      => 'Informații meta',
    'transaction_journal_more'                      => 'Mai multe informaţii',
    'basic_journal_information'                     => 'Informații de bază despre tranzacție',
    'transaction_journal_extra'                     => 'Informații suplimentare',
    'att_part_of_journal'                           => 'Salvat în ":journal"',
    'total_amount'                                  => 'Valoare totală',
    'number_of_decimals'                            => 'Număr de zecimale',


    // administration
    'invite_is_already_redeemed'                    => 'Invitația către ":address" a fost deja revendicată.',
    'invite_is_deleted'                             => 'Invitația către ":address" a fost ștearsă.',
    'invite_new_user_title'                         => 'Invită utilizator nou',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Adresă de e-mail',
    'invite_user'                                   => 'Invită utilizator',
    'user_is_invited'                               => 'Adresa de e-mail ":address" a fost invitată la Firefly III',
    'administration'                                => 'Administrare',
    'system_settings'                               => 'Setări de sistem',
    'code_already_used'                             => 'Codul de invitație a fost utilizat',
    'user_administration'                           => 'Administrarea utilizatorilor',
    'list_all_users'                                => 'Toți utilizatorii',
    'all_users'                                     => 'Toți utilizatorii',
    'instance_configuration'                        => 'Configurare',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'setting_single_user_mode'                      => 'Mod de utilizator unic',
    'setting_single_user_mode_explain'              => 'În mod implicit, Firefly III acceptă numai o înregistrare: dvs. Aceasta este o măsură de securitate, împiedicând pe alții să vă folosească instanța dacă nu le permiteți. Inregistrările viitoare sunt blocate. Când debifați această casetă, alții vă pot folosi și instanța, presupunând că pot ajunge la ea (când este conectată la internet).',
    'store_configuration'                           => 'Salvați configurarea',
    'single_user_administration'                    => 'Administrare utilizator pentru :email',
    'edit_user'                                     => 'Editați user :email',
    'hidden_fields_preferences'                     => 'Puteți activa mai multe opțiuni de tranzacție în <a href="preferences">preferințele</a> dvs.',
    'user_data_information'                         => 'Datele utilizatorului',
    'user_information'                              => 'Informații utilizator',
    'total_size'                                    => 'marimea totală',
    'budget_or_budgets'                             => ':count buget |:count bugete',
    'budgets_with_limits'                           => ':count buget cu suma configurată | :count bugete cu suma configurată',
    'nr_of_rules_in_total_groups'                   => ':count_rules regulă(reguli) în :count_groups grup (uri) de reguli',
    'tag_or_tags'                                   => ':count tag |  :count tag-uri',
    'configuration_updated'                         => 'Configurația a fost actualizată',
    'setting_is_demo_site'                          => 'Site-ul demo',
    'setting_is_demo_site_explain'                  => 'Dacă bifați această casetă, această instalare se va comporta ca și cum ar fi site-ul demo, care poate avea efecte secundare ciudate.',
    'block_code_bounced'                            => 'Mesaje e-mail (uri) returnate',
    'block_code_expired'                            => 'Contul Demo a expirat',
    'no_block_code'                                 => 'Nu există motive pentru blocarea sau blocarea utilizatorului',
    'demo_user_export'                              => 'Utilizatorul demo nu poate exporta date',
    'block_code_email_changed'                      => 'Utilizatorul nu a confirmat încă nicio adresă de e-mail nouă',
    'admin_update_email'                            => 'Contrar paginii de profil, utilizatorul NU va fi anunțat că adresa sa de email a fost modificată!',
    'update_user'                                   => 'Actualizați user',
    'updated_user'                                  => 'Datele utilizatorilor au fost modificate.',
    'delete_user'                                   => 'Șterge user :email',
    'user_deleted'                                  => 'Utilizatorul a fost șters',
    'send_test_email'                               => 'Trimiteți mesajul de e-mail test',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Trimite mesaj',
    'send_test_triggered'                           => 'Testul a fost declanșat. Verificați mesajele primite și log-urile.',
    'give_admin_careful'                            => 'Utilizatorii cărora li se acordă drepturi de administrator pot lua drepturile dvs. Fiți atenți.',
    'admin_maintanance_title'                       => 'Mentenanţă',
    'admin_maintanance_expl'                        => 'Ceva butoane grozave pentru mentenanța Firefly III',
    'admin_maintenance_clear_cache'                 => 'Golește memoria cache',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'All invited users',
    'save_notification_settings'                    => 'Save settings',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'The notification settings have been saved',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Descrierea tranzacției divizate',
    'split_transaction_title_help'          => 'Dacă creați o tranzacție divizată, trebuie să existe o descriere globală pentru toate diviziunile tranzacției.',
    'split_title_help'                      => 'Dacă creați o tranzacție divizată, trebuie să existe o descriere globală pentru toate diviziunile tranzacției.',
    'you_create_transfer'                   => 'Creezi un transfer.',
    'you_create_withdrawal'                 => 'Creezi o retragere.',
    'you_create_deposit'                    => 'Creezi un depozit.',

    // links
    'journal_link_configuration'            => 'Configurare link-uri de tranzacție',
    'create_new_link_type'                  => 'Creați un nou tip de legătură',
    'store_new_link_type'                   => 'Salvați un nou tip de legătură',
    'update_link_type'                      => 'Actualizați tip de legătură',
    'edit_link_type'                        => 'Editați tip de legătură ":name"',
    'updated_link_type'                     => 'Tip de legătură ":name" actualizat',
    'delete_link_type'                      => 'Șterge tip de legătură ":name"',
    'deleted_link_type'                     => 'Tip de legătură ":name" șters',
    'stored_new_link_type'                  => 'Salvați new tip de legătură ":name"',
    'cannot_edit_link_type'                 => 'Nu se poate edita tipul de legătură ":name"',
    'link_type_help_name'                   => 'Ex. "Dubluri"',
    'link_type_help_inward'                 => 'Ex. "dubluri"',
    'link_type_help_outward'                => 'Ex. "este duplicat de către"',
    'save_connections_by_moving'            => 'Salvați legătura dintre aceste tranzacții prin mutarea lor la un alt tip de legătură:',
    'do_not_save_connection'                => '(nu salvați conexiunea)',
    'link_transaction'                      => 'Link tranzacție',
    'link_to_other_transaction'             => 'Conectați această tranzacție la o altă tranzacție',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Această tranzacție',
    'transaction'                           => 'Tranzacţie',
    'comments'                              => 'Comentarii',
    'link_notes'                            => 'Orice notă pe care doriți să o păstrați cu linkul.',
    'invalid_link_selection'                => 'Nu se poate lega aceste tranzacții',
    'selected_transaction'                  => 'Tranzacție selectată',
    'journals_linked'                       => 'Tranzacțiile sunt legate.',
    'journals_error_linked'                 => 'Aceste tranzacții sunt deja legate.',
    'journals_link_to_self'                 => 'Nu puteți conecta o tranzacție la sine',
    'journal_links'                         => 'Link-uri de tranzacții',
    'this_withdrawal'                       => 'Această retragere',
    'this_deposit'                          => 'Acest depozit',
    'this_transfer'                         => 'Acest transfer',
    'overview_for_link'                     => 'Prezentare generală pentru tipul de legătură ":name"',
    'source_transaction'                    => 'Tranzacție sursă',
    'link_description'                      => 'Descrierea legăturii',
    'destination_transaction'               => 'Tranzacție de destinație',
    'delete_journal_link'                   => 'Șterge legătura dintre <a href=":source_link">:source</a> și <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Link șters',

    // link translations:
    'Paid_name'                             => 'Plătit',
    'Refund_name'                           => 'Restituire',
    'Reimbursement_name'                    => 'Rambursare',
    'Related_name'                          => 'Legate de',
    'relates to_inward'                     => 'se referă la',
    'is (partially) refunded by_inward'     => 'este rambursat (parțial) de către',
    'is (partially) paid for by_inward'     => 'este (parțial) plătit de către',
    'is (partially) reimbursed by_inward'   => 'este (parțial) rambursat de către',
    'inward_transaction'                    => 'Tranzacție internă',
    'outward_transaction'                   => 'Tranzacție externă',
    'relates to_outward'                    => 'se referă la',
    '(partially) refunds_outward'           => '(parțial) restituiri',
    '(partially) pays for_outward'          => '(parțial) plătește pentru',
    '(partially) reimburses_outward'        => '(parțial) ramburseaza',
    'is (partially) refunded by'            => 'este (parțial) rambursat de către',
    'is (partially) paid for by'            => 'este (parțial) plătit de către',
    'is (partially) reimbursed by'          => 'este (parțial) rambursat de către',
    'relates to'                            => 'asociat cu',
    '(partially) refunds'                   => '(parțial) restituiri',
    '(partially) pays for'                  => '(parțial) plătește pentru',
    '(partially) reimburses'                => '(parțial) ramburseaza',

    // split a transaction:
    'splits'                                => 'Desparte',
    'add_another_split'                     => 'Adăugați o divizare',
    'cannot_edit_opening_balance'           => 'Nu puteți edita soldul de deschidere al unui cont.',
    'no_edit_multiple_left'                 => 'Nu ați selectat niciun fel de tranzacții valide pentru a le edita.',
    'breadcrumb_convert_group'              => 'Tranzacție convertită',
    'convert_invalid_source'                => 'Informațiile sursă sunt nevalide pentru tranzacția #%d.',
    'convert_invalid_destination'           => 'Informațiile de destinație sunt nevalide pentru tranzacția #%d.',
    'create_another'                        => 'După stocare, reveniți aici pentru a crea alta.',
    'after_update_create_another'           => 'După actualizare, reveniți aici pentru a continua editarea.',
    'store_as_new'                          => 'Stocați ca o tranzacție nouă în loc să actualizați.',
    'reset_after'                           => 'Resetați formularul după trimitere',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Expand split',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Collapse split',

    // object groups
    'default_group_title_name'              => '(negrupat)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Să cream un cont de active!',
    'no_accounts_intro_asset'               => 'Nu ai încă nici un cont de active. Contul de active sunt conturile principale: contul dvs. de verificare, contul de economii, contul partajat sau chiar cardul dvs. de credit.',
    'no_accounts_imperative_asset'          => 'Pentru a începe să utilizați Firefly III, trebuie să creați cel puțin un cont de active. Să o facem acum:',
    'no_accounts_create_asset'              => 'Creați un cont de active',
    'no_accounts_title_expense'             => 'Să cream un cont de cheltuieli!',
    'no_accounts_intro_expense'             => 'Nu ai încă nici un cont de cheltuieli. Cont de cheltuieli sunt locurile unde cheltuiți bani, cum ar fi magazinele și supermarketurile.',
    'no_accounts_imperative_expense'        => 'Cont de cheltuieli sunt create automat când creați tranzacții, dar puteți crea și una manuală, dacă doriți. Să creăm unul acum:',
    'no_accounts_create_expense'            => 'Creați un cont de cheltuieli',
    'no_accounts_title_revenue'             => 'Să cream un cont de venituri!',
    'no_accounts_intro_revenue'             => 'Nu ai încă nici un cont de venituri.Conturile de venituri sunt locurile de unde primiți bani, cum ar fi angajatorul dvs.',
    'no_accounts_imperative_revenue'        => 'Conturile de venituri sunt create automat când creați tranzacții, dar puteți crea și una manuală, dacă doriți. Să creăm unul acum:',
    'no_accounts_create_revenue'            => 'Creați un cont de venituri',
    'no_accounts_title_liabilities'         => 'Să cream un provizion!',
    'no_accounts_intro_liabilities'         => 'Nu ai încă nici un provizion. Provizioanele sunt conturile care vă înregistrează cardurile de credit, împrumuturile și alte datorii.',
    'no_accounts_imperative_liabilities'    => 'Nu trebuie să utilizați această funcție, dar poate fi utilă dacă doriți să urmăriți aceste lucruri.',
    'no_accounts_create_liabilities'        => 'Creați un provizion',
    'no_budgets_title_default'              => 'Să cream un provizion',
    'no_rules_title_default'                => 'Let\'s create a rule',
    'no_budgets_intro_default'              => 'Nu ai încă nici un buget. Bugetele sunt folosite pentru a vă organiza cheltuielile în grupuri logice, pe care le puteți supune unei limite de cheltuieli.',
    'no_rules_intro_default'                => 'You have no rules yet. Rules are powerful automations that can handle transactions for you.',
    'no_rules_imperative_default'           => 'Rules can be very useful when you\'re managing transactions. Let\'s create one now:',
    'no_budgets_imperative_default'         => 'Bugetele sunt instrumentele de bază ale gestiunii financiare. Să creăm unul acum:',
    'no_budgets_create_default'             => 'Creați un buget',
    'no_rules_create_default'               => 'Create a rule',
    'no_categories_title_default'           => 'Să cream o categorie!',
    'no_categories_intro_default'           => 'Nu ai încă nici o categorie. Categoriile sunt utilizate pentru a regla tranzacțiile și a le eticheta cu categoria lor desemnată.',
    'no_categories_imperative_default'      => 'Categoriile sunt create automat atunci când creați tranzacții, dar puteți crea și una manuală. Să creăm una acum:',
    'no_categories_create_default'          => 'Creați o categorie',
    'no_tags_title_default'                 => 'Să cream o eticheta!',
    'no_tags_intro_default'                 => 'Nu ai încă nici o eticheta. Etichetele sunt utilizate pentru etichetarea tranzacțiilor cu cuvinte cheie specifice.',
    'no_tags_imperative_default'            => 'Etichetele sunt create automat atunci când creați tranzacții, dar puteți crea și una manuală. Să creăm una acum:',
    'no_tags_create_default'                => 'Creați o etichetă',
    'no_transactions_title_withdrawal'      => 'Să cream o cheltuială!',
    'no_transactions_intro_withdrawal'      => 'Nu ai încă nici o cheltuială. Trebuie să creați cheltuieli pentru a începe să vă gestionați finanțele.',
    'no_transactions_imperative_withdrawal' => 'Ai cheltuit niște bani? Atunci ar trebui să o scrieți:',
    'no_transactions_create_withdrawal'     => 'Creați o cheltuială',
    'no_transactions_title_deposit'         => 'Să creăm niște venituri!',
    'no_transactions_intro_deposit'         => 'Nu ai încă nici un venit înregistrat. Ar trebui să creați intrări de venituri pentru a începe să vă gestionați finanțele.',
    'no_transactions_imperative_deposit'    => 'Ai primit niște bani? Atunci ar trebui să o scrieți:',
    'no_transactions_create_deposit'        => 'Creați un depozit',
    'no_transactions_title_transfers'       => 'Să cream un transfer!',
    'no_transactions_intro_transfers'       => 'Nu ai încă nici o transfer. Când transferați bani între contul de active, acesta este înregistrat ca transfer.',
    'no_transactions_imperative_transfers'  => 'Ai mutat niște bani? Atunci ar trebui să o scrieți:',
    'no_transactions_create_transfers'      => 'Creați un transfer',
    'no_piggies_title_default'              => 'Să cream o pușculiță!',
    'no_piggies_intro_default'              => 'Nu ai încă nici o pușculiță. Puteți crea pușculita pentru a vă împărți economiile și pentru a urmări ceea ce economisiți.',
    'no_piggies_imperative_default'         => 'Aveți lucruri pentru care economisiți bani? Creați o pușculiță și urmăriți-o:',
    'no_piggies_create_default'             => 'Creați o nouă pușculiță',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Create right now',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Tranzacții recurente',
    'repeat_until_in_past'                  => 'Această tranzacție recurentă a încetat să se mai repete la :date.',
    'recurring_calendar_view'               => 'Calendar',
    'no_recurring_title_default'            => 'Să cream o tranzacție recurentă!',
    'no_recurring_intro_default'            => 'Nu ai încă nici o tranzacție recurentă. Puteți utiliza aceste pentru a face Firefly III să creeze automat tranzacții pentru dvs..',
    'no_recurring_imperative_default'       => 'Aceasta este o caracteristică destul de avansată, dar poate fi extrem de utilă. Asigurați-vă că ați citit documentația (?) - pictograma din colțul din dreapta sus) înainte de a continua.',
    'no_recurring_create_default'           => 'Creați o tranzacție recurentă',
    'make_new_recurring'                    => 'Creați o tranzacție recurentă',
    'recurring_daily'                       => 'Zilnic',
    'recurring_weekly'                      => 'În fiecare săptămână :weekday',
    'recurring_weekly_skip'                 => 'Fiecare :skip(st/nd/rd/th) săptămână în :weekday',
    'recurring_monthly'                     => 'În fiecare lună in ziua de :dayOfMonth(st/nd/rd/th)',
    'recurring_monthly_skip'                => 'În fiecare :skip(st/nd/rd/th) lună in ziua de :dayOfMonth(st/nd/rd/th)',
    'recurring_ndom'                        => 'În fiecare lună pe :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'În fiecare an :date',
    'overview_for_recurrence'               => 'Prezentare generală a tranzacției recurente ":title"',
    'warning_duplicates_repetitions'        => 'În cazuri rare, datele apar de două ori în această listă. Acest lucru se poate întâmpla când mai multe repetări se ciocnesc. Firefly III va genera întotdeauna o tranzacție pe zi.',
    'created_transactions'                  => 'Operațiuni înrudite',
    'expected_withdrawals'                  => 'Retragerile preconizate',
    'expected_deposits'                     => 'Depozitele preconizate',
    'expected_transfers'                    => 'Transferurile preconizate',
    'created_withdrawals'                   => 'Retragerile create',
    'created_deposits'                      => 'Depozitele create',
    'created_transfers'                     => 'Transferurile create',
    'recurring_info'                        => 'Tranzacție recurentă :count / :total',
    'created_from_recurrence'               => 'Creat din tranzacții recurente ":title" (#:id)',
    'recurring_never_cron'                  => 'Se pare că cron-job-ul necesar pentru a susține tranzacțiile recurente nu a avut loc niciodată. Acest lucru este, desigur, normal când ați instalat Firefly III, dar acest lucru ar trebui să fie ceva de instalat cât mai curând posibil. Consultați paginile de ajutor utilizând pictograma (?) - în colțul din dreapta sus al paginii.',
    'recurring_cron_long_ago'               => 'Se pare că au trecut mai mult de 36 de ore de când cron-job-ul pentru susținerea tranzacțiilor recurente a fost utilizat. Sunteți sigur că a fost configurat corect? Consultați paginile de ajutor utilizând pictograma (?) - în colțul din dreapta sus al paginii.',

    'create_new_recurrence'              => 'Creați o nouă tranzacție recurentă',
    'help_first_date'                    => 'Indicați prima recurență așteptată. Aceasta trebuie să fie în viitor.',
    'help_first_date_no_past'            => 'Indicați prima recurență așteptată. Firefly III nu va crea tranzacții în trecut.',
    'no_currency'                        => '(nici o monedă)',
    'mandatory_for_recurring'            => 'Informații obligatorii despre recurență',
    'mandatory_for_transaction'          => 'Informații obligatorii despre tranzacții',
    'optional_for_recurring'             => 'Informații opționale despre recurență',
    'optional_for_transaction'           => 'Informații opționale despre tranzacții',
    'change_date_other_options'          => 'Modificați "prima dată" pentru a vedea mai multe opțiuni.',
    'mandatory_fields_for_tranaction'    => 'Valorile de aici vor rezulta în tranzacția (tranzacțiile) care se creează',
    'click_for_calendar'                 => 'Dați clic aici pentru un calendar care vă arată când tranzacția se va repeta.',
    'repeat_forever'                     => 'Repetați pentru totdeauna',
    'repeat_until_date'                  => 'Repetați până la data',
    'repeat_times'                       => 'Repetați de mai multe ori',
    'recurring_skips_one'                => 'Toate celelalte',
    'recurring_skips_more'               => 'Sari peste  :count apariții',
    'store_new_recurrence'               => 'Salvați tranzacție recurentă',
    'stored_new_recurrence'              => 'tranzacție recurentă ":title" salvată cu succes.',
    'edit_recurrence'                    => 'Editați tranzacția recurentă ":title"',
    'recurring_repeats_until'            => 'Se repetă până la :date',
    'recurring_repeats_forever'          => 'Se repetă pentru totdeauna',
    'recurring_repeats_x_times'          => 'Repetă :count time | Repetă de :count ori',
    'update_recurrence'                  => 'Actualizați tranzacția recurentă',
    'updated_recurrence'                 => 'Tranzacție recurentă ":title" a fost actualizată',
    'recurrence_is_inactive'             => 'Această tranzacție recurentă nu este activă și nu va genera noi tranzacții.',
    'delete_recurring'                   => 'Șterge tranzacția recurentă ":title"',
    'new_recurring_transaction'          => 'Tranzacție recurentă nouă',
    'help_weekend'                       => 'Ce ar trebui să facă Firefly III atunci când tranzacția recurentă cade într-o sâmbătă sau duminică?',
    'do_nothing'                         => 'Doar creați tranzacția',
    'skip_transaction'                   => 'Omiteți apariția',
    'jump_to_friday'                     => 'Creați tranzacția din vineri precedentă',
    'jump_to_monday'                     => 'Creați tranzacția de luni viitoare',
    'will_jump_friday'                   => 'Va fi creat vineri în loc de weekend.',
    'will_jump_monday'                   => 'Va fi creat luni, în loc de weekend.',
    'except_weekends'                    => 'Cu excepția weekend-urilor',
    'recurrence_deleted'                 => 'tranzacție recurentă ":title" ștearsă',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Balanța (:currency)',
    'box_spent_in_currency'              => 'Cheltuit (:currency)',
    'box_earned_in_currency'             => 'Câștigat (:currency)',
    'box_budgeted_in_currency'           => 'Bugetat (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Rămas de cheltuit (:currency)',
    'box_net_worth_in_currency'          => 'Valoarea netă (:currency)',
    'box_spend_per_day'                  => 'Rămas de cheltui pe zi: :amount',

    // debug page
    'debug_page'                         => 'Pagina de depanare',
    'debug_submit_instructions'          => 'Dacă întâmpini probleme, poți folosi informațiile din această casetă ca informație de depanare. Vă rugăm să copiați și lipiți într-o problemă nouă sau existentă <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub</a>. Va genera un tabel care poate fi folosit pentru a vă diagnostica rapid problema.',
    'debug_pretty_table'                 => 'Dacă copiați/lipiți căsuța de mai jos într-o problemă GitHub, aceasta va genera un tabel. Vă rugăm să nu înconjurați acest text cu backticks sau ghilimele.',
    'debug_additional_data'              => 'De asemenea, poți distribui conținutul casetei de mai jos. Poți deasemenea să copiezi și să lipești asta într-un <a href="https://github.com/firefly-iii/firefly-iii/issues">subiect GitHub nou sau existent</a>. Cu toate acestea, conținutul acestei rubrici poate conține informații private, cum ar fi numele contului, detaliile tranzacției sau adresele de e-mail.',

    // object groups
    'object_groups_menu_bar'             => 'Grupuri',
    'object_groups_page_title'           => 'Grupuri',
    'object_groups_breadcrumb'           => 'Grupuri',
    'object_groups_index'                => 'Prezentare generală',
    'object_groups'                      => 'Grupuri',
    'object_groups_empty_explain'        => 'Unele lucruri din Firefly III pot fi împărțite în grupuri. Pușculițele, de exemplu, prezintă un câmp "Group" în editare și creează ecrane. Când setați acest câmp, puteți edita numele și ordinea grupurilor de pe această pagină. Pentru mai multe informații, vedeți paginile de ajutor din colțul din dreapta sus, sub pictograma (?).',
    'object_group_title'                 => 'Titlu',
    'edit_object_group'                  => 'Editați grupul ":title"',
    'delete_object_group'                => 'Șterge grupul ":title"',
    'update_object_group'                => 'Actualizați grupul',
    'updated_object_group'               => 'Grup actualizat cu succes ":title"',
    'deleted_object_group'               => 'Grup ":title" șters cu succes',
    'object_group'                       => 'Grup',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'Added :amount to piggy bank ":name"',
    'ale_action_log_remove'              => 'Scoateți :amount din pușculița ":name"',
    'ale_action_clear_budget'            => 'Eliminat din buget',
    'ale_action_update_group_title'      => 'Titlul grupului de tranzacții actualizat',
    'ale_action_update_date'             => 'Data actualizată a tranzacției',
    'ale_action_update_order'            => 'Comandă tranzacție actualizată',
    'ale_action_clear_category'          => 'Eliminat din categorie',
    'ale_action_clear_notes'             => 'Note șterse',
    'ale_action_clear_tag'               => 'Etichetă ștearsă',
    'ale_action_clear_all_tags'          => 'Toate etichetele au fost șterse',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Cont sursă și destinație schimbat',
    'ale_action_set_budget'              => 'Setare buget',
    'ale_action_set_category'            => 'Setează categoria',
    'ale_action_set_source'              => 'Setează contul sursă',
    'ale_action_set_destination'         => 'Setează contul de destinație',
    'ale_action_update_transaction_type' => 'Tip tranzacție schimbată',
    'ale_action_update_notes'            => 'Note schimbate',
    'ale_action_update_description'      => 'Descriere modificată',
    'ale_action_add_to_piggy'            => 'Pușculită',
    'ale_action_remove_from_piggy'       => 'Pușculită',
    'ale_action_add_tag'                 => 'Etichetă adăugată',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Activează conversia monetară',
    'disable_auto_convert'               => 'Dezactivează conversia monetară',
];
