<?php

/**
 * validation.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


declare(strict_types=1);

return [
    'limit_exists'                   => 'There is already a budget limit (amount) for this budget and currency in the given period.',
    'invalid_sort_instruction'       => 'The sort instruction is invalid for an object of type ":object".',
    'invalid_sort_instruction_index' => 'The sort instruction at index #:index is invalid for an object of type ":object".',
    'no_sort_instructions'           => 'There are no sort instructions defined for an object of type ":object".',
    'webhook_budget_info'            => 'Cannot deliver budget information for transaction related webhooks.',
    'webhook_account_info'           => 'Cannot deliver account information for budget related webhooks.',
    'webhook_transaction_info'       => 'Cannot deliver transaction information for budget related webhooks.',
    'invalid_account_type'           => 'Копилка может быть связана только со счетами активов и пассивов',
    'invalid_account_currency'       => 'Эта учетная запись не использует выбранную валюту',
    'current_amount_too_much'        => 'Совокупная сумма в "current_amount" не может превышать "target_amount".',
    'filter_must_be_in'              => 'Фильтр ":filter" должен быть одним из :values',
    'filter_not_string'              => 'Фильтр ":filter" должен быть строкой текста',
    'bad_api_filter'                 => 'Конечная точка API не поддерживает ":filter" в качестве фильтра.',
    'nog_logged_in'                  => 'Вы не вошли в систему.',
    'prohibited'                     => 'You must not submit anything in field.',
    'bad_webhook_combination'        => 'Webhook trigger ":trigger" cannot be combined with webhook response ":response".',
    'unknown_webhook_trigger'        => 'Unknown webhook trigger ":trigger".',
    'only_any_trigger'               => 'If you select the "Any event"-trigger, you may not select any other triggers.',
    'bad_type_source'                => 'Firefly III не может определить тип транзакции на основе этого исходного счета.',
    'bad_type_destination'           => 'Firefly III не может определить тип транзакции на основе этого счета.',
    'missing_where'                  => 'В массиве отсутствует связка "where" ("где")',
    'missing_update'                 => 'В массиве отсутствует связка "update" ("обновить")',
    'invalid_where_key'              => 'JSON содержит недопустимый ключ для связки "where" ("где")',
    'invalid_update_key'             => 'JSON содержит недопустимый ключ для связки "update" ("обновить")',
    'invalid_query_data'             => 'В поле %s:%s вашего запроса содержатся неверные данные.',
    'invalid_query_account_type'     => 'Ваш запрос содержит счета разных типов, что недопустимо.',
    'invalid_query_currency'         => 'Ваш запрос содержит счета с разными валютами, что недопустимо.',
    'iban'                           => 'Это некорректный IBAN.',
    'zero_or_more'                   => 'Это значение не может быть отрицательным.',
    'more_than_zero'                 => 'Значение должно быть больше нуля.',
    'more_than_zero_correct'         => 'Значение должно быть ноль или больше.',
    'no_asset_account'               => 'Это не счет активов.',
    'date_or_time'                   => 'Значение должно быть корректной датой или временем (ISO 8601).',
    'source_equals_destination'      => 'Счёт источник и счёт назначения совпадают.',
    'unique_account_number_for_user' => 'Этот номер счёта уже используется.',
    'unique_user_group_for_user'     => 'Похоже, это название администрирования уже используется.',
    'unique_iban_for_user'           => 'Этот IBAN уже используется.',
    'reconciled_forbidden_field'     => 'Эта транзакция уже сверена, вы не можете изменить ":field"',
    'deleted_user'                   => 'По соображениям безопасности, вы не можете зарегистрироваться, используя этот адрес электронной почты.',
    'rule_trigger_value'             => 'Это значение является недопустимым для выбранного триггера.',
    'rule_action_expression'         => 'Недопустимое выражение. :error',
    'rule_action_value'              => 'Это значение является недопустимым для выбранного действия.',
    'file_already_attached'          => 'Загруженный файл ":name" уже прикреплён к этому объекту.',
    'file_attached'                  => 'Файл ":name". успешно загружен.',
    'file_zero'                      => 'Размер файла в байтах равен нулю.',
    'must_exist'                     => 'ID в поле field :attribute не существует в базе данных.',
    'all_accounts_equal'             => 'Все счета в данном поле должны совпадать.',
    'group_title_mandatory'          => 'Название группы является обязательным, если транзакций несколько.',
    'transaction_types_equal'        => 'Все части транзакции должны быть одного типа.',
    'invalid_transaction_type'       => 'Недопустимый тип транзакции.',
    'invalid_selection'              => 'Вы сделали неправильный выбор.',
    'belongs_user'                   => 'Это значение связано с объектом, который не существует.',
    'belongs_user_or_user_group'     => 'Это значение связано с объектом, который не существует в Вашем текущем финансовом администрировании.',
    'no_access_group'                => 'Пользователь не имеет прав для настройки этого.',
    'no_accepted_roles_defined'      => 'Нет ролей доступа для этой конечной точки, доступ запрещен.',
    'at_least_one_transaction'       => 'Необходима как минимум одна транзакция.',
    'recurring_transaction_id'       => 'Необходима минимум одна транзакция.',
    'need_id_to_match'               => 'Вы должны отправить эту запись с ID для того, чтобы API мог сопоставить её.',
    'too_many_unmatched'             => 'Слишком много отправленных транзакций не могут быть сопоставлены с соответствующими записями в базе данных. Убедитесь, что существующие записи имеют правильный ID.',
    'id_does_not_match'              => 'Отправленный ID #:id не соответствует ожидаемому ID. Убедитесь, что он совпадает или не соответствует поле.',
    'at_least_one_repetition'        => 'Необходима как минимум одна транзакция.',
    'require_repeat_until'           => 'Требуется либо несколько повторений, либо конечная дата (repeat_until). Но не оба параметра разом.',
    'require_currency_info'          => 'Содержимое этого поля недействительно без информации о валюте.',
    'require_currency_id_code'       => 'Пожалуйста, установите "transaction_currency_id" или "transaction_currency_code".',
    'not_transfer_account'           => 'Этот счёт нельзя использовать для перевода.',
    'require_currency_amount'        => 'Содержимое этого поля недействительно без информации о валюте.',
    'require_foreign_currency'       => 'Это поле требует число',
    'require_foreign_dest'           => 'Это значение поля должно совпадать с валютой счета назначения.',
    'require_foreign_src'            => 'Это поле должно совпадать с валютой исходного счета.',
    'equal_description'              => 'Описание транзакции не должно совпадать с глобальным описанием.',
    'file_invalid_mime'              => 'Файл ":name" имеет тип ":mime". Загрузка файлов такого типа невозможна.',
    'file_too_large'                 => 'Файл ":name" слишком большой.',
    'belongs_to_user'                => 'Значение :attribute неизвестно.',
    'accepted'                       => 'Необходимо принять :attribute.',
    'bic'                            => 'Это некорректный BIC.',
    'at_least_one_trigger'           => 'Правило должно иметь хотя бы одно условие.',
    'at_least_one_active_trigger'    => 'Правило должно иметь хотя бы один активный триггер.',
    'at_least_one_action'            => 'Правило должно иметь хотя бы одно действие.',
    'at_least_one_active_action'     => 'Правило должно иметь по крайней мере одно активное действие.',
    'base64'                         => 'Это некорректный формат для данных, зашифрованных с помощью base64.',
    'model_id_invalid'               => 'Данный ID кажется недопустимым для этой модели.',
    'less'                           => ':attribute должен быть меньше 10,000,000',
    'active_url'                     => ':attribute не является допустимым URL-адресом.',
    'after'                          => ':attribute должна быть позже :date.',
    'date_after'                     => 'Дата начала должна быть до даты окончания.',
    'alpha'                          => ':attribute может содержать только буквы.',
    'alpha_dash'                     => ':attribute может содержать только буквы, числа и дефис.',
    'alpha_num'                      => ':attribute может содержать только буквы и числа.',
    'array'                          => ':attribute должен быть массивом.',
    'unique_for_user'                => 'Уже существует запись с этим :attribute.',
    'before'                         => ':attribute должна быть раньше :date.',
    'unique_object_for_user'         => 'Это название уже используется.',
    'unique_account_for_user'        => 'Такое название счёта уже используется.',


    'between.numeric'            => ':attribute должен быть больше :min и меньше :max.',
    'between.file'               => ':attribute должен быть размером :min - :max килобайт.',
    'between.string'             => ':attribute должен содержать :min - :max символов.',
    'between.array'              => ':attribute должен содержать :min - :max элементов.',
    'between_date'               => 'The date must be between the given start and end date.',
    'boolean'                    => 'Поле :attribute должно быть истинным или ложным.',
    'confirmed'                  => ':attribute не совпадает с подтверждением.',
    'date'                       => ':attribute не является верной датой.',
    'date_format'                => ':attribute не совпадает с форматом :format.',
    'different'                  => ':attribute и :other не должны совпадать.',
    'digits'                     => ':attribute должно содержать :digits цифр.',
    'digits_between'             => ':attribute должен содержать :min - :max цифр.',
    'email'                      => ':attribute не является верным email адресом.',
    'filled'                     => 'Поле :attribute должно быть заполнено.',
    'exists'                     => 'Выбран неверный :attribute.',
    'image'                      => ':attribute должен быть изображением.',
    'in'                         => 'Выбранный :attribute не верный.',
    'integer'                    => ':attribute должно быть целым числом.',
    'ip'                         => ':attribute должен быть верным IP-адресом.',
    'json'                       => ':attribute должно быть верной JSON строкой.',
    'max.numeric'                => 'Значение :attribute не может быть больше :max.',
    'max.file'                   => 'Значение :attribute не может быть больше :max килобайт.',
    'max.string'                 => 'Значение :attribute не может быть больше :max символов.',
    'max.array'                  => 'Значение :attribute не может содержать более :max элементов.',
    'mimes'                      => ':attribute должен быть файлом типа :values.',
    'min.numeric'                => ':attribute должен быть минимум :min.',
    'lte.numeric'                => ':attribute должен быть меньше или равен :value.',
    'min.file'                   => ':attribute должен быть минимум :min килобайт.',
    'min.string'                 => 'Значение :attribute должно быть не меньше :min символов.',
    'min.array'                  => 'Значение :attribute должно содержать не меньше :min элементов.',
    'not_in'                     => 'Выбранный :attribute не верный.',
    'numeric'                    => ':attribute должен быть числом.',
    'convert_to_itself'          => 'Cannot store currency exchange rate for ":code", because from and to currency are the same.',
    'invalid_currency_code'      => 'Currency code ":code" is invalid',
    'scientific_notation'        => ':attribute не может использовать научную обозначение.',
    'numeric_primary'            => 'The primary currency amount must be a number.',
    'numeric_destination'        => 'Сумма назначения должна быть числом.',
    'numeric_source'             => 'Исходная сумма должна быть числом.',
    'generic_invalid'            => 'Указано недопустимое значение.',
    'transaction_type_changed'   => 'Если вы измените тип транзакции, убедитесь, что установлены правильные счета источника/назначения.',
    'regex'                      => 'Формат :attribute некорректен.',
    'required'                   => 'Поле :attribute является обязательным.',
    'required_if'                => 'Значение :attribute является обязательным, когда :other равное :value.',
    'required_unless'            => 'Поле :attribute является обязательным, если :other не входит в список :values.',
    'required_with'              => 'Поле :attribute является обязательным, когда есть :values.',
    'required_with_all'          => 'Поле :attribute является обязательным, когда есть :values.',
    'required_without'           => 'Поле :attribute является обязательным, когда отсутствует :values.',
    'required_without_all'       => ':attribute поле обязательно для заполнения, так как ни одно из :values не существует.',
    'same'                       => ':attribute и :other должны совпадать.',
    'size.numeric'               => ':attribute должен быть размером :size.',
    'amount_min_over_max'        => 'Минимальная сумма не может быть больше максимальной суммы.',
    'size.file'                  => ':attribute должен быть размером :size килобайт.',
    'size.string'                => ':attribute должен состоять из :size символов.',
    'size.array'                 => ':attribute должен содержать :size элементов.',
    'unique'                     => ':attribute уже занят.',
    'string'                     => 'Значение :attribute должно быть строкой.',
    'url'                        => 'Неверный формат ввода :attribute.',
    'timezone'                   => ':attribute должен быть в допустимом диапазоне.',
    '2fa_code'                   => ':attribute введен неверно.',
    'dimensions'                 => 'Недопустимые размеры изображения :attribute.',
    'distinct'                   => 'Поле :attribute содержит повторяющееся значение.',
    'file'                       => ':attribute должен быть файлом.',
    'in_array'                   => 'Поле :attribute не существует в :other.',
    'present'                    => 'Поле :attribute должно быть заполнено.',
    'amount_zero'                => 'Сумма не может быть равна нулю.',
    'current_target_amount'      => 'Текущая сумма должна быть меньше целевой суммы.',
    'unique_piggy_bank_for_user' => 'Название копилки должно быть уникальным.',
    'unique_object_group'        => 'Название группы должно быть уникальным',
    'starts_with'                => 'Значение должно начинаться с :values.',
    'unique_webhook'             => 'У вас уже есть вебхук с этим сочетанием URL, триггер, ответа и доставки.',
    'unique_existing_webhook'    => 'У вас уже есть другой вебхук с этим сочетанием URL, триггер, ответа и доставки.',
    'same_account_type'          => 'Оба счета должны иметь один тип счета',
    'same_account_currency'      => 'Оба счета должны иметь одну и ту же валюту',
    'piggy_no_change_currency'   => 'К этому счету привязаны копилки, вы не можете изменить валюту счета.',


    'secure_password'             => 'Это небезопасный пароль. Попробуйте еще раз! Подробнее: https://bit.ly/FF3-password',
    'valid_recurrence_rep_type'   => 'Недопустимый тип для повторяющихся транзакций.',
    'valid_recurrence_rep_moment' => 'Неверный период повторения для данного типа повторений.',
    'invalid_account_info'        => 'Неверные данные о счёте.',
    'attributes'                  => [
        'email'                   => '"Адрес электронной почты"',
        'description'             => '"Описание"',
        'amount'                  => 'Сумма',
        'transactions.*.amount'   => 'сумма транзакции',
        'name'                    => '"Название"',
        'piggy_bank_id'           => 'ID копилки',
        'targetamount'            => '"Целевая сумма"',
        'opening_balance_date'    => 'дата начального баланса',
        'opening_balance'         => 'начальный баланс',
        'match'                   => '"Ключи для связи"',
        'amount_min'              => '"Минимальная сумма"',
        'amount_max'              => '"Максимальная сумма"',
        'title'                   => '"Заголовок"',
        'tag'                     => '"Метка"',
        'transaction_description' => 'описание транзакции',
        'rule-action-value.1'     => '"Значение действия #1"',
        'rule-action-value.2'     => '"Значение действия #2"',
        'rule-action-value.3'     => '"Значение действия #3"',
        'rule-action-value.4'     => '"Значение действия #4"',
        'rule-action-value.5'     => '"Значение действия #5"',
        'rule-action.1'           => '"Действие #1"',
        'rule-action.2'           => '"Действие #2"',
        'rule-action.3'           => '"Действие #3"',
        'rule-action.4'           => '"Действие #4"',
        'rule-action.5'           => '"Действие #5"',
        'rule-trigger-value.1'    => '"Значение условия #1"',
        'rule-trigger-value.2'    => '"Значение условия #2"',
        'rule-trigger-value.3'    => '"Значение условия #3"',
        'rule-trigger-value.4'    => '"Значение условия #4"',
        'rule-trigger-value.5'    => '"Значение условия #5"',
        'rule-trigger.1'          => '"Условие #1"',
        'rule-trigger.2'          => '"Условие #2"',
        'rule-trigger.3'          => '"Условие #3"',
        'rule-trigger.4'          => '"Условие #4"',
        'rule-trigger.5'          => '"Условие #5"',
    ],

    // validation of accounts:
    'withdrawal_source_need_data' => 'Для продолжения необходим действительный ID счёта-источника и/или действительное имя счёта.',
    'withdrawal_source_bad_data'  => '[a] Не удалось найти учетную запись источника при поиске ID ":id" или имени ":name".',
    'withdrawal_dest_need_data'   => '[a] Для продолжения необходимо получить правильный идентификатор счета назначения и/или действительное имя счета назначения.',
    'withdrawal_dest_bad_data'    => 'Не удалось найти действительный счёт назначения при поиске ID ":id" или имени ":name".',

    'withdrawal_dest_iban_exists' => 'Этот IBAN счета назначения уже используется счетом актива или обязательства и не может быть использован в качестве назначения для снятия средств.',
    'deposit_src_iban_exists'     => 'Этот IBAN счета-источника уже используется счетом актива или обязательства и не может быть использован в качестве источника депозита.',

    'reconciliation_source_bad_data' => 'Не удалось найти действующую учетную запись сверки при поиске ID ":id" или имя ":name".',

    'generic_source_bad_data' => '[e] Не удалось найти корректный счёт-источник при поиске ID ":id" или имени ":name".',

    'deposit_source_need_data' => 'Для продолжения необходим действительный ID счёта-источника и/или действительное имя счёта.',
    'deposit_source_bad_data'  => '[b] Не удалось найти корректный счёт-источник при поиске ID ":id" или имени ":name".',
    'deposit_dest_need_data'   => '[b] Для продолжения необходим действительный ID счёта назначения и/или действительное имя счёта.',
    'deposit_dest_bad_data'    => 'Не удалось найти действительный счёт назначения при поиске ID ":id" или имени ":name".',
    'deposit_dest_wrong_type'  => 'Сохраняемый счёт назначения - некорректный.',


    'transfer_source_need_data' => 'Для продолжения необходим действительный ID счёта-источника и/или действительное имя счёта.',
    'transfer_source_bad_data'  => '[c] Не удалось найти учетную запись источника при поиске ID ":id" или имени ":name".',
    'transfer_dest_need_data'   => '[a] Для продолжения необходимо получить правильный идентификатор счета назначения и/или действительное имя счета назначения.',
    'transfer_dest_bad_data'    => 'Не удалось найти действительный счёт назначения при поиске ID ":id" или имени ":name".',
    'need_id_in_edit'           => 'Каждая разделённая транзакция должна иметь transaction_journal_id (либо действительный ID, либо 0).',

    'ob_source_need_data'           => 'Для продолжения необходим действительный ID счёта-источника и/или действительное имя счёта.',
    'lc_source_need_data'           => 'Для продолжения необходимо получить идентификатор учетной записи исходного кода.',
    'ob_dest_need_data'             => '[a] Для продолжения необходимо получить правильный идентификатор счета назначения и/или действительное имя счета назначения.',
    'ob_dest_bad_data'              => 'Не удалось найти действительный счёт назначения при поиске ID ":id" или имени ":name".',
    'reconciliation_either_account' => 'Чтобы отправить сверку, вы должны отправить либо исходный код, либо целевой счет. Не обоих, а не ничтожные.',

    'generic_invalid_source'      => 'Вы не можете использовать этот счёт в качестве счёта-источника.',
    'generic_invalid_destination' => 'Вы не можете использовать этот счёт в качестве счёта назначения.',

    'generic_no_source'      => 'Вы должны представить информацию о счете источнике или идентификатор из журнала транзакции.',
    'generic_no_destination' => 'Вы должны представить исходную информацию об учетной записи или представить идентификатор журнала транзакций.',

    'gte.numeric'  => 'Значение :attribute должно быть больше или равно :value.',
    'gt.numeric'   => 'Значение :attribute должно быть больше :value.',
    'gte.file'     => 'Размер файла в поле :attribute должен быть больше или равен :value Килобайт(а).',
    'gte.string'   => 'Значение :attribute должно быть больше или равно :value символам.',
    'gte.array'    => 'Значения поля :attribute должно включать :value элементов или больше.',
    'missing_with' => ':attribute не может быть комбинирован с другим полем.',

    'amount_required_for_auto_budget' => 'Нужно указать сумму.',
    'auto_budget_amount_positive'     => 'Сумма должна быть больше 0.',

    'auto_budget_period_mandatory' => 'Период авто-бюджета - это обязательно поле.',

    // no access to administration:
    'no_auth_user_group'           => 'Необходимо войти для доступа к административной части.',
    'no_access_user_group'         => 'У вас нет необходимых прав доступа для данного административного действия.',
    'administration_owner_rename'  => 'Вы не можете переименовать ваше стандартное управление.',
    'existing_mfa_code'            => 'Пожалуйста, введите правильный код',
];
