<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Затвори',
    'actions'                                   => 'Действия',
    'edit'                                      => 'Промени',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Изтрий',
    'split'                                     => 'Раздели',
    'single_split'                              => 'Раздел',
    'clone'                                     => 'Дублирай',
    'clone_and_edit'                            => 'Clone and edit',
    'confirm_action'                            => 'Confirm action',
    'last_seven_days'                           => 'Последните седем дни',
    'last_thirty_days'                          => 'Последните трийсет дни',
    'last_180_days'                             => 'Последните 180 дни',
    'month_to_date'                             => 'От началото на месеца',
    'year_to_date'                              => 'От началото на годината',
    'YTD'                                       => 'YTD',
    'welcome_back'                              => 'Какво се случва?',
    'main_dashboard_page_title'                 => 'Home',
    'everything'                                => 'Всичко',
    'today'                                     => 'Днес',
    'customRange'                               => 'Потребителски диапазон',
    'date_range'                                => 'Период',
    'apply'                                     => 'Приложи',
    'select_date'                               => 'Изберете дата..',
    'cancel'                                    => 'Отказ',
    'from'                                      => 'От',
    'to'                                        => 'До',
    'structure'                                 => 'Структура',
    'help_translating'                          => 'Този помощен текст още не е наличен на Вашия език. <a href="https://crowdin.com/project/firefly-iii-help">Ще помогнете ли с превода?</a>',
    'showEverything'                            => 'Покажи всичко',
    'never'                                     => 'Никога',
    'no_results_for_empty_search'               => 'Вашето търсене беше празно и нищо не беше намерено.',
    'removed_amount'                            => 'Изтрито :amount',
    'added_amount'                              => 'Добавено :amount',
    'asset_account_role_help'                   => 'Всички допълнителни опции, получени от вашия избор, могат да бъдат зададени по-късно.',
    'Opening balance'                           => 'Начално салдо',
    'create_new_stuff'                          => 'Създайте нови неща',
    'new_withdrawal'                            => 'Ново теглене',
    'create_new_transaction'                    => 'Създай нова трансакция',
    'sidebar_frontpage_create'                  => 'Създай',
    'new_transaction'                           => 'Нова транзакция',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Вижте активите си',
    'go_to_budgets'                             => 'Вижте бюджетите си',
    'go_to_withdrawals'                         => 'Вижте тегленията си',
    'clones_journal_x'                          => 'Тази транзакция е копирана от ":description" (#:id)',
    'go_to_categories'                          => 'Виж категориите си',
    'go_to_bills'                               => 'Go to your subscriptions',
    'go_to_expense_accounts'                    => 'Виж разходните си сметки',
    'go_to_revenue_accounts'                    => 'Виж приходните си сметки',
    'go_to_piggies'                             => 'Виж касичките си',
    'new_deposit'                               => 'Нов депозит',
    'new_transfer'                              => 'Ново прехвърляне',
    'new_transfers'                             => 'Ново прехвърляне',
    'new_asset_account'                         => 'Нова сметка за активи',
    'new_expense_account'                       => 'Нова сметка за разходи',
    'new_revenue_account'                       => 'Нова сметка за приходи',
    'new_liabilities_account'                   => 'Ново задължение',
    'new_budget'                                => 'Нов бюджет',
    'new_bill'                                  => 'New subscription',
    'block_account_logout'                      => 'Излезли сте от системата. Блокираните акаунти не могат да използват този сайт. Регистрирахте ли се с валиден имейл адрес?',
    'flash_success'                             => 'Успех!',
    'flash_info'                                => 'Съобщение',
    'flash_warning'                             => 'Внимание!',
    'flash_error'                               => 'Грешка!',
    'flash_danger'                              => 'Опасност!',
    'flash_info_multiple'                       => 'Има ново съобщение| Има :count нови съобщения',
    'flash_error_multiple'                      => 'Има нова грешка| Има :count нови грешки',
    'net_worth'                                 => 'Нетна стойност',
    'help_for_this_page'                        => 'Помощ за тази страница',
    'help_for_this_page_body'                   => 'You can find more information about this page <a href="https://docs.firefly-iii.org/">in the documentation</a>.',
    'two_factor_welcome'                        => 'Здравейте!',
    'two_factor_enter_code'                     => 'За да продължите, моля въведете вашия двуфакторен код за удостоверяване. Вашето приложение може да го генерира за вас.',
    'two_factor_code_here'                      => 'Въведете кода тук',
    'two_factor_title'                          => 'Двуфакторно удостоверяване',
    'authenticate'                              => 'Удостоверяване',
    'two_factor_forgot_title'                   => 'Загубена двуфакторната идентификация',
    'two_factor_forgot'                         => 'Забравих своето двуфакторно нещо.',
    'two_factor_lost_header'                    => 'Загубихте вашата двуфакторната идентификация?',
    'two_factor_lost_intro'                     => 'Ако сте загубили и резервните си кодове, имате лош късмет. Това не е нещо, което можете да поправите от уеб интерфейса. Имате два варианта.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'В противен случай изпратете имейл на собственика на сайта,<a href="mailto::site_owner">:site_owner</a> и ги помолете да нулират вашето двуфакторно удостоверяване.',
    'mfa_backup_code'                           => 'Използвали сте резервен код, за да влезете в Firefly III. Не може да се използва отново, затова го зачеркнете от списъка си.',
    'pref_two_factor_new_backup_codes'          => 'Вземете нови резервни кодове',
    'pref_two_factor_backup_code_count'         => 'Имате :count валиден резервен код.|Имате :count валидни резервни кодове.',
    '2fa_i_have_them'                           => 'Съхраних ги!',
    'warning_much_data'                         => ':days дни с данни може да отнеме известно време.',
    'registered'                                => 'Регистрирахте се успешно!',
    'Default asset account'                     => 'Сметка за активи по подразбиране',
    'no_budget_pointer'                         => 'Изглежда все още нямате бюджети. Трябва да създадете някои на страницата <a href="budgets"> Бюджети </a>. Бюджетите могат да ви помогнат да следите разходите си.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Спестовна сметка',
    'Credit card'                               => 'Кредитна карта',
    'source_accounts'                           => 'Разходна сметка|Разходни сметки',
    'destination_accounts'                      => 'Приходна сметка|Приходни сметки',
    'user_id_is'                                => 'Вашето потребителско ID е <strong>:user</strong>',
    'field_supports_markdown'                   => 'Това поле поддържа <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Ако имате нужда от още помощ за използването на Firefly III, моля <a href="https://github.com/firefly-iii/firefly-iii/issues">отворете билет на Github</a>.',
    'reenable_intro_text'                       => 'Може също да активирате отново <a href="#" id="reenableGuidance">въведението</a>.',
    'intro_boxes_after_refresh'                 => 'Полетата на въведението ще се появят отново, когато опресните страницата.',
    'show_all_no_filter'                        => 'Покажи всички транзакции без групиране по дата.',
    'expenses_by_category'                      => 'Разходи по категории',
    'expenses_by_budget'                        => 'Разходи по бюджети',
    'income_by_category'                        => 'Приходи по категория',
    'expenses_by_asset_account'                 => 'Разходи по сметка за активи',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III не може да ви пренасочи към правилната страница. Извиняваме се.',
    'sum_of_expenses'                           => 'Сума на разходите',
    'sum_of_income'                             => 'Сума на приходите',
    'liabilities'                               => 'Задължения',
    'spent_in_specific_budget'                  => 'Похарчено в бюджет ":budget"',
    'spent_in_specific_double'                  => 'Похарчено от сметка ":account"',
    'earned_in_specific_double'                 => 'Получено в сметка ":account"',
    'source_account'                            => 'Разходна сметка',
    'source_account_reconciliation'             => 'Не може да редактирате разходната сметка на транзакция за съгласуване.',
    'destination_account'                       => 'Приходна сметка',
    'destination_account_reconciliation'        => 'Не може да редактирате приходната сметка на транзакция за съгласуване.',
    'sum_of_expenses_in_budget'                 => 'Общо похарчено в бюджет ":budget"',
    'left_in_budget_limit'                      => 'Остави да харчи според бюджета',
    'current_period'                            => 'Текущ период',
    'show_the_current_period_and_overview'      => 'Покажи текущия период и обобщение',
    'pref_languages_locale'                     => 'За да работи език, различен от английския, вашата операционна система трябва да е снабдена с правилната локална информация. Ако няма такава, валутните данни, дати и суми могат да бъдат форматирани погрешно.',
    'budget_in_period'                          => 'Всички транзакции за бюджет ":name" между :start и :end в :currency',
    'chart_budget_in_period'                    => 'Графика на всички транзакции за бюджет ":name" между :start и :end в :currency',
    'chart_budget_in_period_only_currency'      => 'Сумата, която бюджетирахте беше в :currency, така че тази графика ще показва само транзакции в :currency.',
    'chart_account_in_period'                   => 'Графика на всички транзакции за сметка ":name" (:balance) между :start и :end',
    'chart_category_in_period'                  => 'Графика на всички транзакции за категория ":name" между :start и :end',
    'chart_category_all'                        => 'Графика на всички транзакции за категория ":name"',
    'clone_withdrawal'                          => 'Копирай това теглене',
    'clone_deposit'                             => 'Копирай този депозит',
    'clone_transfer'                            => 'Копирай този трансфер',
    'multi_select_no_selection'                 => 'Нищо не е избрано',
    'multi_select_select_all'                   => 'Избери всички',
    'multi_select_n_selected'                   => 'избрани',
    'multi_select_all_selected'                 => 'Всички избрани',
    'multi_select_filter_placeholder'           => 'Търси..',
    'intro_next_label'                          => 'Следващ',
    'intro_prev_label'                          => 'Предишен',
    'intro_skip_label'                          => 'Пропусни',
    'intro_done_label'                          => 'Готово',
    'between_dates_breadcrumb'                  => 'Между :start и :end',
    'all_journals_without_budget'               => 'Всички транзакции без бюджет',
    'journals_without_budget'                   => 'Транзакции без бюджет',
    'all_journals_without_category'             => 'Всички транзакции без категория',
    'journals_without_category'                 => 'Транзакции без категория',
    'all_journals_for_account'                  => 'Всички транзакции за сметка :name',
    'chart_all_journals_for_account'            => 'Графика на всички транзакции за сметка :name',
    'journals_in_period_for_account'            => 'Всички транзакции за сметка :name между :start и :end',
    'journals_in_period_for_account_js'         => 'All transactions for account {title} between {start} and {end}',
    'transferred'                               => 'Прехвърлени',
    'all_withdrawal'                            => 'Всички разходи',
    'all_transactions'                          => 'Всички транзакции',
    'title_withdrawal_between'                  => 'Всички разходи между :start и :end',
    'all_deposit'                               => 'Всички приходи',
    'title_deposit_between'                     => 'Всички приходи между :start и :end',
    'all_transfers'                             => 'Всички трансфери',
    'title_transfers_between'                   => 'Всички трансфери между :start и :end',
    'all_transfer'                              => 'Всички трансфери',
    'all_journals_for_tag'                      => 'Всички транзакции за етикет ":tag"',
    'title_transfer_between'                    => 'Всички трансфери между :start и :end',
    'all_journals_for_category'                 => 'Всички транзакции за категория :name',
    'all_journals_for_budget'                   => 'Всички транзакции за бюджет :name',
    'chart_all_journals_for_budget'             => 'Графика на всички транзакции за бюджет :name',
    'journals_in_period_for_category'           => 'Всички транзакции за категория :name между :start и :end',
    'journals_in_period_for_tag'                => 'Всички транзакции за етикет :tag между :start и :end',
    'not_available_demo_user'                   => 'Функцията, до която се опитвате да получите достъп, не е достъпна за демо потребители.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Разходната сметка „@source_name“ приема само транзакции в @source_currency. Приходната сметка „@dest_name“ приема само транзакции в @dest_currency. Трябва да предоставите трансферираната сума точно и в двете валути.',
    'transaction_data'                          => 'Данни на транзакцията',
    'invalid_server_configuration'              => 'Грешна конфигурация на сървъра',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'Бърз ключ',
    'sign_in_to_start'                          => 'Влезте, за да започнете сесията си',
    'sign_in'                                   => 'Вход',
    'register_new_account'                      => 'Регистриране на нов профил',
    'forgot_my_password'                        => 'Забравена парола',
    'problems_with_input'                       => 'Имаше някои проблеми с вашите данни.',
    'reset_password'                            => 'Промяна на паролата ви',
    'button_reset_password'                     => 'Нулиране на паролата',
    'reset_button'                              => 'Изчисти',
    'want_to_login'                             => 'Искам да вляза',
    'login_page_title'                          => 'Влезте в Firefly III',
    'register_page_title'                       => 'Регистрирайте се в Firefly III',
    'forgot_pw_page_title'                      => 'Забравихте паролата си за Firefly III',
    'reset_pw_page_title'                       => 'Нулирайте паролата си за Firefly III',
    'cannot_reset_demo_user'                    => 'Не можете да нулирате паролата на демо потребителя.',
    'no_att_demo_user'                          => 'Демо потребителят не може да прикачва документи.',
    'button_register'                           => 'Регистриране',
    'authorization'                             => 'Позволение',
    'active_bills_only'                         => 'active subscription only',
    'active_bills_only_total'                   => 'all active subscriptions',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Очаквани дневни разходи',
    'per_period_sum_1W'                         => 'Очаквани седмични разходи',
    'per_period_sum_1M'                         => 'Очаквани месечни разходи',
    'per_period_sum_3M'                         => 'Очаквани тримесечни разходи',
    'per_period_sum_6M'                         => 'Очаквани разходи за полугодие',
    'per_period_sum_1Y'                         => 'Очаквани годишни разходи',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'общо очаквано',
    'reconciliation_account_name'               => ':name съгласуване (:currency)',
    'saved'                                     => 'Записан',
    'advanced_options'                          => 'Разширени настройки',
    'advanced_options_explain'                  => 'Някои страници в Firefly III имат разширени опции, скрити зад този бутон. Тази страница няма нищо интересно тук, но проверете останалите!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'disabled',
    'no_webhook_messages'                       => 'There are no webhook messages',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'After transaction creation',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'After transaction update',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'After transaction delete',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Transaction details',
    'webhook_response_ACCOUNTS'                 => 'Account details',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspect',
    'create_new_webhook'                        => 'Create new webhook',
    'webhooks_create_breadcrumb'                => 'Create new webhook',
    'webhook_trigger_form_help'                 => 'Indicate on what event the webhook will trigger',
    'webhook_response_form_help'                => 'Indicate what the webhook must submit to the URL.',
    'webhook_delivery_form_help'                => 'Which format the webhook must deliver data in.',
    'webhook_active_form_help'                  => 'The webhook must be active or it won\'t be called.',
    'stored_new_webhook'                        => 'Stored new webhook ":title"',
    'delete_webhook'                            => 'Delete webhook',
    'deleted_webhook'                           => 'Deleted webhook ":title"',
    'edit_webhook'                              => 'Edit webhook ":title"',
    'updated_webhook'                           => 'Updated webhook ":title"',
    'edit_webhook_js'                           => 'Edit webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'The webhook was triggered on the indicated transaction. Please wait for results to appear.',
    'webhook_messages'                          => 'Webhook message',
    'view_message'                              => 'View message',
    'view_attempts'                             => 'View failed attempts',
    'message_content_title'                     => 'Webhook message content',
    'message_content_help'                      => 'This is the content of the message that was sent (or tried) using this webhook.',
    'attempt_content_title'                     => 'Webhook attempts',
    'attempt_content_help'                      => 'These are all the unsuccessful attempts of this webhook message to submit to the configured URL. After some time, Firefly III will stop trying.',
    'no_attempts'                               => 'There are no unsuccessful attempts. That\'s a good thing!',
    'webhook_attempt_at'                        => 'Attempt at {moment}',
    'logs'                                      => 'Logs',
    'response'                                  => 'Response',
    'visit_webhook_url'                         => 'Visit webhook URL',
    'reset_webhook_secret'                      => 'Reset webhook secret',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> has been stored.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") has been updated.',

    // API access
    'authorization_request'                     => 'Firefly III v:version заявка за потвърждение',
    'authorization_request_intro'               => 'Апликацията "<strong>:client</strong>" иска разрешение за достъп до вашето финансово управление. Искате ли да упълномощите <strong>:client</strong> за достъп до тези записи?',
    'authorization_request_site'                => 'You will be redirected to <code>:url</code> which will then be able to access your Firefly III data.',
    'authorization_request_invalid'             => 'This access request is invalid. Please never follow this link again.',
    'scopes_will_be_able'                       => 'Това приложение ще има право да:',
    'button_authorize'                          => 'Разреши',
    'none_in_select_list'                       => '(нищо)',
    'no_piggy_bank'                             => '(без касичка)',
    'name_in_currency'                          => ':name в :currency',
    'paid_in_currency'                          => 'Платено в :currency',
    'unpaid_in_currency'                        => 'Неплатено в :currency',
    'is_alpha_warning'                          => 'Изпълнявате ALPHA версия. Внимавайте за грешки и проблеми.',
    'is_beta_warning'                           => 'Изпълнявате BETA версия. Внимавайте за грешки и проблеми.',
    'all_destination_accounts'                  => 'Приходни сметки',
    'all_source_accounts'                       => 'Разходни сметки',
    'back_to_index'                             => 'Обратно към списъка',
    'cant_logout_guard'                         => 'Firefly III не може да ви отпише.',
    'internal_reference'                        => 'Вътрешна референция',

    // check for updates:
    'update_check_title'                        => 'Проверка за обновления',
    'admin_update_check_title'                  => 'Автоматично проверявай за обновяване',
    'admin_update_check_explain'                => 'Firefly III може да проверява за актуализации автоматично. Когато активирате тази настройка, тя ще се свърже със сървъра за актуализиране на Firefly III, за да провери дали е налична нова версия на Firefly III. Когато е налична, ще получите известие. Можете да тествате това известие с помощта на бутона вдясно. Моля, посочете по-долу, ако искате Firefly III да провери за актуализации.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Попитай ме по-късно',
    'updates_do_not_check'                      => 'Не проверявай за обновления',
    'updates_enable_check'                      => 'Активирай проверката за обновления',
    'admin_update_check_now_title'              => 'Провери за обновления сега',
    'admin_update_check_now_explain'            => 'Ако натиснете бутона, Firefly III ще провери дали текущата ви версия е най-новата.',
    'check_for_updates_button'                  => 'Провери сега!',
    'update_new_version_alert'                  => 'Налична е нова версия на Firefly III. Вие изпълнявате :your_version, последната версия е :new_version, която беше пусната на :date.',
    'update_version_beta'                       => 'Това е BETA версия. Може да се натъкнете на проблеми.',
    'update_version_alpha'                      => 'Това е ALPHA версия. Може да се натъкнете на проблеми.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'Изпълнявате :version, която е най-новата налична версия.',
    'update_newer_version_alert'                => 'Изпълнявате: :your_version, която е по-нова от последната налична версия: :new_version.',
    'update_check_error'                        => 'Възникна грешка при проверка за актуализации: :error',
    'unknown_error'                             => 'Неизвестна грешка. Съжаляваме за това.',
    'disabled_but_check'                        => 'Деактивирахте проверката за обновления. Затова не забравяйте периодично да проверявате ръчно за актуализации. Благодарим Ви!',
    'admin_update_channel_title'                => 'Канал за обновления',
    'admin_update_channel_explain'              => 'Firefly III има три "канала" за обновления, които определят искате да доближите кривата на функции, подобрения и грешки. Използвайте "beta" канала, ако сте авантюристични и "alpha", когато обичате да живеете опасно живота.',
    'update_channel_stable'                     => 'Стабилна. Всичко трябва да работи както се очаква.',
    'update_channel_beta'                       => 'Beta. Нови функции, но някои нещата могат да бъдат "счупени".',
    'update_channel_alpha'                      => 'Alpha. Нахвърляме неща тук и използваме каквито "прилепне".',

    // search
    'search'                                    => 'Търсене',
    'search_query'                              => 'Заявка',
    'search_found_transactions'                 => 'Firefly III намери :count транзакция за :time секунди.|Firefly III намери :count транзакции за :time секунди.',
    'search_found_more_transactions'            => 'Firefly III намери повече от :count транзакции за :time секунди.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Дадените параметрите за търсене не са валидни и ще бъдат пренебрегнати.',

    // old


    'search_modifier_date_on'                             => 'Transaction date is ":value"',
    'search_modifier_not_date_on'                         => 'Transaction date is not ":value"',
    'search_modifier_reconciled'                          => 'Transaction is reconciled',
    'search_modifier_not_reconciled'                      => 'Transaction is not reconciled',
    'search_modifier_id'                                  => 'Индентификатор на транзакцията е ":value"',
    'search_modifier_not_id'                              => 'Transaction ID is not ":value"',
    'search_modifier_date_before'                         => 'Датата на транзакцията е преди или на ":value"',
    'search_modifier_date_after'                          => 'Датата на транзакцията е след или на ":value"',
    'search_modifier_external_id_is'                      => 'External ID is ":value"',
    'search_modifier_not_external_id_is'                  => 'External ID is not ":value"',
    'search_modifier_no_external_url'                     => 'The transaction has no external URL',
    'search_modifier_no_external_id'                      => 'The transaction has no external ID',
    'search_modifier_not_any_external_url'                => 'The transaction has no external URL',
    'search_modifier_not_any_external_id'                 => 'The transaction has no external ID',
    'search_modifier_any_external_url'                    => 'The transaction must have a (any) external URL',
    'search_modifier_any_external_id'                     => 'The transaction must have a (any) external ID',
    'search_modifier_not_no_external_url'                 => 'The transaction must have a (any) external URL',
    'search_modifier_not_no_external_id'                  => 'The transaction must have a (any) external ID',
    'search_modifier_internal_reference_is'               => 'Internal reference is ":value"',
    'search_modifier_not_internal_reference_is'           => 'Internal reference is not ":value"',
    'search_modifier_description_starts'                  => 'Description starts with ":value"',
    'search_modifier_not_description_starts'              => 'Description does not start with ":value"',
    'search_modifier_description_ends'                    => 'Description ends on ":value"',
    'search_modifier_not_description_ends'                => 'Description does not end on ":value"',
    'search_modifier_description_contains'                => 'Описанието съдържа ":value"',
    'search_modifier_not_description_contains'            => 'Description does not contain ":value"',
    'search_modifier_description_is'                      => 'Описанието е точно ":value"',
    'search_modifier_not_description_is'                  => 'Description is exactly not ":value"',
    'search_modifier_currency_is'                         => '(Чуждата) валута на транзакцията е ":value"',
    'search_modifier_not_currency_is'                     => 'Transaction (foreign) currency is not ":value"',
    'search_modifier_foreign_currency_is'                 => 'Чуждата валута на транзакцията е ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Transaction foreign currency is not ":value"',
    'search_modifier_has_attachments'                     => 'Транзакцията трябва да има прикачен файл',
    'search_modifier_has_no_category'                     => 'Транзакцията трябва да няма категория',
    'search_modifier_not_has_no_category'                 => 'The transaction must have a (any) category',
    'search_modifier_not_has_any_category'                => 'The transaction must have no category',
    'search_modifier_has_any_category'                    => 'Транзакцията трябва да има (някаква) категория',
    'search_modifier_has_no_budget'                       => 'Транзакцията трябва да няма бюджет',
    'search_modifier_not_has_any_budget'                  => 'The transaction must have no budget',
    'search_modifier_has_any_budget'                      => 'Транзакцията трябва да има (някакъв) бюджет',
    'search_modifier_not_has_no_budget'                   => 'The transaction must have a (any) budget',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'Транзакцията трябва да няма етикет',
    'search_modifier_not_has_any_tag'                     => 'The transaction must have no tags',
    'search_modifier_not_has_no_tag'                      => 'The transaction must have a (any) tag',
    'search_modifier_has_any_tag'                         => 'Транзакцията трябва да има (някакъв) етикет',
    'search_modifier_notes_contains'                      => 'The transaction notes contain ":value"',
    'search_modifier_not_notes_contains'                  => 'The transaction notes do not contain ":value"',
    'search_modifier_notes_starts'                        => 'The transaction notes start with ":value"',
    'search_modifier_not_notes_starts'                    => 'The transaction notes do not start with ":value"',
    'search_modifier_notes_ends'                          => 'The transaction notes end with ":value"',
    'search_modifier_not_notes_ends'                      => 'The transaction notes do not end with ":value"',
    'search_modifier_notes_is'                            => 'The transaction notes are exactly ":value"',
    'search_modifier_not_notes_is'                        => 'The transaction notes are exactly not ":value"',
    'search_modifier_no_notes'                            => 'Транзакцията няма бележки',
    'search_modifier_not_no_notes'                        => 'The transaction must have notes',
    'search_modifier_any_notes'                           => 'Транзакцията трябва да има бележки',
    'search_modifier_not_any_notes'                       => 'The transaction has no notes',
    'search_modifier_amount_is'                           => 'Amount is exactly :value',
    'search_modifier_not_amount_is'                       => 'Amount is not :value',
    'search_modifier_amount_less'                         => 'Сумата е по-малко или равно на :value',
    'search_modifier_not_amount_more'                     => 'Amount is less than or equal to :value',
    'search_modifier_amount_more'                         => 'Сумата е по-голяма или равна на :value',
    'search_modifier_not_amount_less'                     => 'Amount is more than or equal to :value',
    'search_modifier_source_account_is'                   => 'Името на разходната сметка е точно ":value"',
    'search_modifier_not_source_account_is'               => 'Source account name is not ":value"',
    'search_modifier_source_account_contains'             => 'Името на разходната сметка съдържа ":value"',
    'search_modifier_not_source_account_contains'         => 'Source account name does not contain ":value"',
    'search_modifier_source_account_starts'               => 'Името на разходната сметка започва с ":value"',
    'search_modifier_not_source_account_starts'           => 'Source account name does not start with ":value"',
    'search_modifier_source_account_ends'                 => 'Името на разходната сметка завършва с ":value"',
    'search_modifier_not_source_account_ends'             => 'Source account name does not end with ":value"',
    'search_modifier_source_account_id'                   => 'ID на разходната сметка е :value',
    'search_modifier_not_source_account_id'               => 'Source account ID is not :value',
    'search_modifier_source_account_nr_is'                => 'Номерът на разходната сметка (IBAN) е ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Source account number (IBAN) is not ":value"',
    'search_modifier_source_account_nr_contains'          => 'Номерът на разходната сметка (IBAN) съдържа ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Source account number (IBAN) does not contain ":value"',
    'search_modifier_source_account_nr_starts'            => 'Номерът на разходната сметка (IBAN) започва с ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Source account number (IBAN) does not start with ":value"',
    'search_modifier_source_account_nr_ends'              => 'Source account number (IBAN) ends on ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Source account number (IBAN) does not end on ":value"',
    'search_modifier_destination_account_is'              => 'Името на приходната сметка е точно ":value"',
    'search_modifier_not_destination_account_is'          => 'Destination account name is not ":value"',
    'search_modifier_destination_account_contains'        => 'Името на приходната сметка съдържа ":value"',
    'search_modifier_not_destination_account_contains'    => 'Destination account name does not contain ":value"',
    'search_modifier_destination_account_starts'          => 'Името на приходната сметка започва с ":value"',
    'search_modifier_not_destination_account_starts'      => 'Destination account name does not start with ":value"',
    'search_modifier_destination_account_ends'            => 'Destination account name ends on ":value"',
    'search_modifier_not_destination_account_ends'        => 'Destination account name does not end on ":value"',
    'search_modifier_destination_account_id'              => 'ID на приходната сметка е :value',
    'search_modifier_not_destination_account_id'          => 'Destination account ID is not :value',
    'search_modifier_destination_is_cash'                 => 'Destination account is the "(cash)" account',
    'search_modifier_not_destination_is_cash'             => 'Destination account is not the "(cash)" account',
    'search_modifier_source_is_cash'                      => 'Source account is the "(cash)" account',
    'search_modifier_not_source_is_cash'                  => 'Source account is not the "(cash)" account',
    'search_modifier_destination_account_nr_is'           => 'Номерът на приходната сметка (IBAN) е ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Destination account number (IBAN) is ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Номерът на приходната сметка (IBAN) съдържа ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Destination account number (IBAN) does not contain ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Номерът на приходната сметка (IBAN) започва с ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Destination account number (IBAN) does not start with ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Номерът на приходната сметка (IBAN) завършва с ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Destination account number (IBAN) does not end with ":value"',
    'search_modifier_account_id'                          => 'ID на разходната или приходната сметка е: :value',
    'search_modifier_not_account_id'                      => 'Source or destination account ID\'s is/are not: :value',
    'search_modifier_category_is'                         => 'Категорията е ":value"',
    'search_modifier_not_category_is'                     => 'Category is not ":value"',
    'search_modifier_budget_is'                           => 'Бюджетът е ":value"',
    'search_modifier_not_budget_is'                       => 'Budget is not ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Видът на транзакцията е ":value"',
    'search_modifier_not_transaction_type'                => 'Transaction type is not ":value"',
    'search_modifier_tag_is'                              => 'Етикетът е ":value"',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'No tag is ":value"',
    'search_modifier_date_on_year'                        => 'Transaction is in year ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaction is not in year ":value"',
    'search_modifier_date_on_month'                       => 'Transaction is in month ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaction is not in month ":value"',
    'search_modifier_date_on_day'                         => 'Transaction is on day of month ":value"',
    'search_modifier_not_date_on_day'                     => 'Transaction is not on day of month ":value"',
    'search_modifier_date_before_year'                    => 'Транзацията е преди или през ":value" година',
    'search_modifier_date_before_month'                   => 'Транзацията е преди или през ":value" месец',
    'search_modifier_date_before_day'                     => 'Транзацията е преди или на ":value" число от месеца',
    'search_modifier_date_after_year'                     => 'Транзацията е през ":value" година или след нея',
    'search_modifier_date_after_month'                    => 'Транзацията е през ":value" месец или след него',
    'search_modifier_date_after_day'                      => 'Транзацията е на ":value" число от месеца или след него',

    // new
    'search_modifier_tag_is_not'                          => 'No tag is ":value"',
    'search_modifier_not_tag_is_not'                      => 'Tag is ":value"',
    'search_modifier_account_is'                          => 'Either account is ":value"',
    'search_modifier_not_account_is'                      => 'Neither account is ":value"',
    'search_modifier_account_contains'                    => 'Either account contains ":value"',
    'search_modifier_not_account_contains'                => 'Neither account contains ":value"',
    'search_modifier_account_ends'                        => 'Either account ends with ":value"',
    'search_modifier_not_account_ends'                    => 'Neither account ends with ":value"',
    'search_modifier_account_starts'                      => 'Either account starts with ":value"',
    'search_modifier_not_account_starts'                  => 'Neither account starts with ":value"',
    'search_modifier_account_nr_is'                       => 'Either account number / IBAN is ":value"',
    'search_modifier_not_account_nr_is'                   => 'Neither account number / IBAN is ":value"',
    'search_modifier_account_nr_contains'                 => 'Either account number / IBAN contains ":value"',
    'search_modifier_not_account_nr_contains'             => 'Neither account number / IBAN contains ":value"',
    'search_modifier_account_nr_ends'                     => 'Either account number / IBAN ends with ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Neither account number / IBAN ends with ":value"',
    'search_modifier_account_nr_starts'                   => 'Either account number / IBAN starts with ":value"',
    'search_modifier_not_account_nr_starts'               => 'Neither account number / IBAN starts with ":value"',
    'search_modifier_category_contains'                   => 'Category contains ":value"',
    'search_modifier_not_category_contains'               => 'Category does not contain ":value"',
    'search_modifier_category_ends'                       => 'Category ends on ":value"',
    'search_modifier_not_category_ends'                   => 'Category does not end on ":value"',
    'search_modifier_category_starts'                     => 'Category starts with ":value"',
    'search_modifier_not_category_starts'                 => 'Category does not start with ":value"',
    'search_modifier_budget_contains'                     => 'Budget contains ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget does not contain ":value"',
    'search_modifier_budget_ends'                         => 'Budget ends with ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget does not end on ":value"',
    'search_modifier_budget_starts'                       => 'Budget starts with ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget does not start with ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'External ID contains ":value"',
    'search_modifier_not_external_id_contains'            => 'External ID does not contain ":value"',
    'search_modifier_external_id_ends'                    => 'External ID ends with ":value"',
    'search_modifier_not_external_id_ends'                => 'External ID does not end with ":value"',
    'search_modifier_external_id_starts'                  => 'External ID starts with ":value"',
    'search_modifier_not_external_id_starts'              => 'External ID does not start with ":value"',
    'search_modifier_internal_reference_contains'         => 'Internal reference contains ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Internal reference does not contain ":value"',
    'search_modifier_internal_reference_ends'             => 'Internal reference ends with ":value"',
    'search_modifier_internal_reference_starts'           => 'Internal reference starts with ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Internal reference does not end with ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Internal reference does not start with ":value"',
    'search_modifier_external_url_is'                     => 'External URL is ":value"',
    'search_modifier_not_external_url_is'                 => 'External URL is not ":value"',
    'search_modifier_external_url_contains'               => 'External URL contains ":value"',
    'search_modifier_not_external_url_contains'           => 'External URL does not contain ":value"',
    'search_modifier_external_url_ends'                   => 'External URL ends with ":value"',
    'search_modifier_not_external_url_ends'               => 'External URL does not end with ":value"',
    'search_modifier_external_url_starts'                 => 'External URL starts with ":value"',
    'search_modifier_not_external_url_starts'             => 'External URL does not start with ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaction has no attachments',
    'search_modifier_not_has_no_attachments'              => 'Transaction has attachments',
    'search_modifier_not_has_attachments'                 => 'Transaction has no attachments',
    'search_modifier_account_is_cash'                     => 'Either account is the "(cash)" account.',
    'search_modifier_not_account_is_cash'                 => 'Neither account is the "(cash)" account.',
    'search_modifier_journal_id'                          => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                      => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                       => 'The recurring transaction ID is ":value"',
    'search_modifier_not_recurrence_id'                   => 'The recurring transaction ID is not ":value"',
    'search_modifier_foreign_amount_is'                   => 'The foreign amount is ":value"',
    'search_modifier_not_foreign_amount_is'               => 'The foreign amount is not ":value"',
    'search_modifier_foreign_amount_less'                 => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_more'             => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_less'             => 'The foreign amount is more than ":value"',
    'search_modifier_foreign_amount_more'                 => 'The foreign amount is more than ":value"',
    'search_modifier_exists'                              => 'Transaction exists (any transaction)',
    'search_modifier_not_exists'                          => 'Transaction does not exist (no transaction)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaction interest date is ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaction interest date is not ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaction interest date is in year ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaction interest date is in month ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaction interest date is on day of month ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaction interest date is before or in year ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                   => 'Transaction book date is in year ":value"',
    'search_modifier_book_date_on_month'                  => 'Transaction book date is in month ":value"',
    'search_modifier_book_date_on_day'                    => 'Transaction book date is on day of month ":value"',
    'search_modifier_not_book_date_on_year'               => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'              => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'               => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'              => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Transaction due date is in year ":value"',
    'search_modifier_due_date_on_month'                   => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Transaction due date is after or in year ":value"',
    'search_modifier_due_date_after_month'                => 'Transaction due date is after or in month ":value"',
    'search_modifier_due_date_after_day'                  => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                => 'Transaction payment date is in year ":value"',
    'search_modifier_payment_date_on_month'               => 'Transaction payment date is in month ":value"',
    'search_modifier_payment_date_on_day'                 => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'             => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaction invoice date is in month ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaction invoice date is on day of month ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaction invoice date is before or in year ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaction invoice date is before or in month ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaction invoice date is before or on day of month ":value"',
    'search_modifier_invoice_date_after_year'             => 'Transaction invoice date is after or in year ":value"',
    'search_modifier_invoice_date_after_month'            => 'Transaction invoice date is after or in month ":value"',
    'search_modifier_invoice_date_after_day'              => 'Transaction invoice date is after or on day of month ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaction was last updated in year ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaction was last updated in month ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaction was last updated on day of month ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaction was last updated in or before year ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaction was last updated in or before month ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaction was last updated on or before day of month ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaction was last updated in or after year ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                  => 'Transaction was created in year ":value"',
    'search_modifier_created_at_on_month'                 => 'Transaction was created in month ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'             => 'Transaction was created in or before month ":value"',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'              => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                    => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                       => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                    => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'            => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'      => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'        => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'          => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'          => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'     => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'       => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'         => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'        => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => 'Обновяване на правило ":rule" от низа за търсене',
    'create_rule_from_query'                        => 'Създай ново правило от низа за търсене',
    'rule_from_search_words'                        => 'Механизмът за правила има затруднения с обработката на ":string". Предложеното правило, което отговаря на низа ви за търсене, може да даде различни резултати. Моля проверете внимателно задействанията на правилото.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'При търсенето възникна грешка. Моля, проверете лог файловете за повече информация.',
    'search_box'                                          => 'Търсене',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Грешка при търсене',
    'search_searching'                                    => 'Търсене ...',
    'search_results'                                      => 'Резултати от търсенето',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'ежегодно',
    'repeat_freq_half-year'                               => 'на всеки 6 месеца',
    'repeat_freq_quarterly'                               => 'тримесечно',
    'repeat_freq_monthly'                                 => 'месечно',
    'repeat_freq_weekly'                                  => 'ежеседмично',
    'repeat_freq_daily'                                   => 'daily',
    'daily'                                               => 'daily',
    'weekly'                                              => 'седмично',
    'quarterly'                                           => 'тримесечно',
    'half-year'                                           => 'на полугодие',
    'yearly'                                              => 'годишно',

    // rules
    'is_not_rule_trigger'                                 => 'Not',
    'cannot_fire_inactive_rules'                          => 'Не можете да изпълнявате неактивни правила.',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'Правила',
    'rule_name'                                           => 'Име на правилото',
    'rule_triggers'                                       => 'Правилото се задейства, когато',
    'rule_actions'                                        => 'Правилото ще',
    'new_rule'                                            => 'Ново правило',
    'new_rule_group'                                      => 'Нова група правила',
    'rule_priority_up'                                    => 'Дайте повече приоритет на правилото',
    'rule_priority_down'                                  => 'Дайте по-малко приоритет на правилото',
    'make_new_rule_group'                                 => 'Направете нова група правила',
    'store_new_rule_group'                                => 'Запаметете новата група правила',
    'created_new_rule_group'                              => 'Новата група правила ":title" е запаметена!',
    'updated_rule_group'                                  => 'Успешно обновена група правила ":title".',
    'edit_rule_group'                                     => 'Редактирай група правила ":title"',
    'duplicate_rule'                                      => 'Копирайте правило ":title"',
    'rule_copy_of'                                        => 'Копие на ":title"',
    'duplicated_rule'                                     => 'Копирано правило ":title" в ":newTitle"',
    'delete_rule_group'                                   => 'Изтрий група правила ":title"',
    'deleted_rule_group'                                  => 'Изтрита група правила ":title"',
    'update_rule_group'                                   => 'Обнови група правила',
    'no_rules_in_group'                                   => 'Няма правила в тази група',
    'move_rule_group_up'                                  => 'Премести групата правила нагоре',
    'move_rule_group_down'                                => 'Премести групата правила надолу',
    'save_rules_by_moving'                                => 'Запазете това правило, като го преместите в друга група правила:|Запазете тези правила, като ги преместите в друга група правила:',
    'make_new_rule'                                       => 'Създайте ново правило в групата правила ":title"',
    'make_new_rule_no_group'                              => 'Създайте ново правило',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Създайте правило въз основа на една от транзакциите си. Попълнете или потвърдете формата по-долу.',
    'rule_is_strict'                                      => 'строго правило',
    'rule_is_not_strict'                                  => 'не строго правило',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'В строги правила ВСИЧКИ задействания трябва да се случат, за да се изпълни действието. В не строги правила, НЯКОЕ задействане е достатъчно за изпълнението на действията.',
    'rule_help_active'                                    => 'Неактивните правила никога няма да се задействат.',
    'stored_new_rule'                                     => 'Запаметено ново правило с име ":title"',
    'deleted_rule'                                        => 'Изтрито правило с име ":title"',
    'store_new_rule'                                      => 'Запаметете ново правило',
    'updated_rule'                                        => 'Обновено правило с име ":title"',
    'default_rule_group_name'                             => 'Правила по подразбиране',
    'default_rule_group_description'                      => 'Всички ваши правила не са в определена група.',
    'trigger'                                             => 'Задействане',
    'trigger_value'                                       => 'Задействане при стойност',
    'stop_processing_other_triggers'                      => 'Спри да обработваш другите задействания',
    'add_rule_trigger'                                    => 'Добави задействане',
    'action'                                              => 'Действие',
    'action_value'                                        => 'Стойност на действие',
    'stop_executing_other_actions'                        => 'Спри да изпълняваш другите действия',
    'add_rule_action'                                     => 'Добави ново действие',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Изтрии правило ":title"',
    'update_rule'                                         => 'Обнови правило',
    'test_rule_triggers'                                  => 'Вижте съвпадащи транзакции',
    'warning_no_matching_transactions'                    => 'Няма намерени транзакции.',
    'warning_no_valid_triggers'                           => 'Не са предоставени валидни задействания.',
    'apply_rule_selection'                                => 'Приложете правило ":title" към селекция от вашите транзакции',
    'apply_rule_selection_intro'                          => 'Правила като ":title" обикновено се прилагат само за нови или актуализирани транзакции, но можете да кажете на Firefly III да го стартира върху селекция от вашите съществуващи транзакции. Това може да бъде полезно, когато сте актуализирали правило и се нуждаете промените, да се отразят на всички останали транзакции.',
    'include_transactions_from_accounts'                  => 'Включете транзакции от тези сметки',
    'include'                                             => 'Включи?',
    'applied_rule_selection'                              => '{0} Няма транзакции в селекцията ти променени от правило ":title".|[1] Една транзакция в селекцията ти променени от правило ":title".|[2,*] :count транзакции в селекцията ти променени от правило ":title".',
    'execute'                                             => 'Изпълни',
    'apply_rule_group_selection'                          => 'Приложете групата правила ":title" към селекция от вашите транзакции',
    'apply_rule_group_selection_intro'                    => 'Групи правила като ":title" обикновено се прилагат само за нови или актуализирани транзакции, но можете да кажете на Firefly III да го стартира върху селекция от вашите съществуващи транзакции. Това може да бъде полезно, когато сте актуализирали група правила и се нуждаете промените, да се отразят на всички останали транзакции.',
    'applied_rule_group_selection'                        => 'Групата правила ":title" е приложена към вашия избор.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Когато се създава транзакция',
    'rule_trigger_update_journal'                         => 'Когато се обновява транзакция',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'Действието на потребителя е „:trigger_value“',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Името на разходната сметка започва с..',
    'rule_trigger_source_account_starts'                  => 'Името на разходната сметка започва с ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Името на разходната сметка завършва с..',
    'rule_trigger_source_account_ends'                    => 'Името на разходната сметка завършва с ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Името на разходната сметка е..',
    'rule_trigger_source_account_is'                      => 'Името на разходната сметка е ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Името на разходната сметка съдържа..',
    'rule_trigger_source_account_contains'                => 'Името на разходната сметка съдържа ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Either account ID is exactly..',
    'rule_trigger_account_id'                             => 'Either account ID is exactly :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'ID на разходната сметка е точно..',
    'rule_trigger_source_account_id'                      => 'ID на разходната сметка е точно :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'ID на приходната сметка е точно..',
    'rule_trigger_destination_account_id'                 => 'ID на приходната сметка е точно :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Either account is cash',
    'rule_trigger_account_is_cash'                        => 'Either account is cash',
    'rule_trigger_source_is_cash_choice'                  => 'Разходната сметка е сметка (в брой)',
    'rule_trigger_source_is_cash'                         => 'Разходната сметка е сметка (в брой)',
    'rule_trigger_destination_is_cash_choice'             => 'Приходната сметка е сметка (в брой)',
    'rule_trigger_destination_is_cash'                    => 'Приходната сметка е сметка (в брой)',
    'rule_trigger_source_account_nr_starts_choice'        => 'Номерът на разходната сметка / IBAN започва с..',
    'rule_trigger_source_account_nr_starts'               => 'Номерът на разходната сметка / IBAN започва с ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Номерът на разходната сметка / IBAN завършва с..',
    'rule_trigger_source_account_nr_ends'                 => 'Номерът на разходната сметка / IBAN завършва с ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Номерът на разходната сметка / IBAN е..',
    'rule_trigger_source_account_nr_is'                   => 'Номерът на разходната сметка / IBAN е ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Номерът на разходната сметка / IBAN съдържа..',
    'rule_trigger_source_account_nr_contains'             => 'Номерът на разходната сметка / IBAN съдържа ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Името на приходната сметка започва с..',
    'rule_trigger_destination_account_starts'             => 'Името на приходната сметка започва с ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Името на приходната сметка завършва с..',
    'rule_trigger_destination_account_ends'               => 'Името на приходната сметка завършва с ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Името на приходната сметка е..',
    'rule_trigger_destination_account_is'                 => 'Името на приходната сметка е ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Името на приходната сметка съдържа..',
    'rule_trigger_destination_account_contains'           => 'Името на приходната сметка съдържа ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Номерът на приходната сметка / IBAN започва с..',
    'rule_trigger_destination_account_nr_starts'          => 'Номерът на приходната сметка / IBAN започва с ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Името на приходната сметка завършва с..',
    'rule_trigger_destination_account_nr_ends'            => 'Името на приходната сметка завършва с ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Номерът на приходната сметка / IBAN е..',
    'rule_trigger_destination_account_nr_is'              => 'Номерът на приходната сметка / IBAN е ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Номерът на приходната сметка / IBAN съдържа..',
    'rule_trigger_destination_account_nr_contains'        => 'Номерът на приходната сметка / IBAN съдържа ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Транзакцията е от тип..',
    'rule_trigger_transaction_type'                       => 'Транзакцията е от тип ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Категорията е..',
    'rule_trigger_category_is'                            => 'Категорията е ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Amount is less than or equal to ..',
    'rule_trigger_amount_less'                            => 'Amount is less than or equal to :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Amount is..',
    'rule_trigger_amount_is'                              => 'Amount is :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Amount is more than or equal to..',
    'rule_trigger_amount_more'                            => 'Amount is more than or equal to :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Описанието започва с..',
    'rule_trigger_description_starts'                     => 'Описанието започва с ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Описанието завършва с..',
    'rule_trigger_description_ends'                       => 'Описанието завършва с ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Описанието съдържа..',
    'rule_trigger_description_contains'                   => 'Описанието съдържа ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Описанието е..',
    'rule_trigger_description_is'                         => 'Описанието е ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Transaction date is..',
    'rule_trigger_date_on'                                => 'Transaction date is ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Датата на транзакцията е преди..',
    'rule_trigger_date_before'                            => 'Датата на транзакцията е преди ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Датата на транзакцията е след..',
    'rule_trigger_date_after'                             => 'Датата на транзакцията е след ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transaction was made on..',
    'rule_trigger_created_at_on'                          => 'Transaction was made on ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaction was last edited on..',
    'rule_trigger_updated_at_on'                          => 'Transaction was last edited on ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Бюджетът е..',
    'rule_trigger_budget_is'                              => 'Бюджетът е ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Any tag is..',
    'rule_trigger_tag_is'                                 => 'Any tag is ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Валутата на транзакцията е..',
    'rule_trigger_currency_is'                            => 'Валутата на транзакцията е ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Чуждата валута на транзакцията е..',
    'rule_trigger_foreign_currency_is'                    => 'Чуждата валута на транзакцията е ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Няма категория',
    'rule_trigger_has_no_category'                        => 'Транзакцията няма категория',
    'rule_trigger_has_any_category_choice'                => 'Има (някаква) категория',
    'rule_trigger_has_any_category'                       => 'Транзакцията има (някаква) категория',
    'rule_trigger_has_no_budget_choice'                   => 'Няма бюджет',
    'rule_trigger_has_no_budget'                          => 'Транзакцията няма бюджет',
    'rule_trigger_has_any_budget_choice'                  => 'Има (някакъв) бюджет',
    'rule_trigger_has_any_budget'                         => 'Транзакцията има (някакъв) бюджет',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Няма етикет(и)',
    'rule_trigger_has_no_tag'                             => 'Транзакцията няма етикет(и)',
    'rule_trigger_has_any_tag_choice'                     => 'Има един или повече (някакви) етикети',
    'rule_trigger_has_any_tag'                            => 'Транзакцията има един или повече (някакви) етикети',
    'rule_trigger_any_notes_choice'                       => 'Има (някакви) бележки',
    'rule_trigger_any_notes'                              => 'Транзакцията има (някакви) бележки',
    'rule_trigger_no_notes_choice'                        => 'Няма бележки',
    'rule_trigger_no_notes'                               => 'Транзакцията няма бележки',
    'rule_trigger_notes_is_choice'                        => 'Notes are..',
    'rule_trigger_notes_is'                               => 'Notes are ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notes contain..',
    'rule_trigger_notes_contains'                         => 'Notes contain ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notes start with..',
    'rule_trigger_notes_starts'                           => 'Notes start with ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notes end with..',
    'rule_trigger_notes_ends'                             => 'Notes end with ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'External ID is..',
    'rule_trigger_external_id_is'                         => 'External ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                  => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'ID на транзакцията е..',
    'rule_trigger_journal_id'                             => 'ID на транзакцията е ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Transaction has no external URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaction has no external ID',
    'rule_trigger_id_choice'                              => 'Transaction ID is..',
    'rule_trigger_id'                                     => 'Transaction ID is ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'User action is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'No tag is..',
    'rule_trigger_tag_is_not'                             => 'No tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Either account is exactly..',
    'rule_trigger_account_is'                             => 'Either account is exactly ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Either account contains..',
    'rule_trigger_account_contains'                       => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Either account ends with..',
    'rule_trigger_account_ends'                           => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Either account starts with..',
    'rule_trigger_account_starts'                         => 'Either account starts with ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                    => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                        => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                      => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Category contains..',
    'rule_trigger_category_contains'                      => 'Category contains ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Category ends with..',
    'rule_trigger_category_ends'                          => 'Category ends with ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Category starts with..',
    'rule_trigger_category_starts'                        => 'Category starts with ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget contains..',
    'rule_trigger_budget_contains'                        => 'Budget contains ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget ends with..',
    'rule_trigger_budget_ends'                            => 'Budget ends with ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget starts with..',
    'rule_trigger_budget_starts'                          => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'External ID contains..',
    'rule_trigger_external_id_contains'                   => 'External ID contains ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'External ID ends with..',
    'rule_trigger_external_id_ends'                       => 'External ID ends with ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'External ID starts with..',
    'rule_trigger_external_id_starts'                     => 'External ID starts with ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'            => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'              => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'External URL is..',
    'rule_trigger_external_url_is'                        => 'External URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'External URL contains..',
    'rule_trigger_external_url_contains'                  => 'External URL contains ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'External URL ends with..',
    'rule_trigger_external_url_ends'                      => 'External URL ends with ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'External URL starts with..',
    'rule_trigger_external_url_starts'                    => 'External URL starts with ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Has no attachments',
    'rule_trigger_has_no_attachments'                     => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                   => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                          => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Interest date is on..',
    'rule_trigger_interest_date_on'                       => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Interest date is before..',
    'rule_trigger_interest_date_before'                   => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Interest date is after..',
    'rule_trigger_interest_date_after'                    => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Book date is before..',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Process date is on..',
    'rule_trigger_process_date_on'                        => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Process date is before..',
    'rule_trigger_process_date_before'                    => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Process date is after..',
    'rule_trigger_process_date_after'                     => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Due date is on..',
    'rule_trigger_due_date_on'                            => 'Due date is on ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Due date is before..',
    'rule_trigger_due_date_before'                        => 'Due date is before ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Due date is after..',
    'rule_trigger_due_date_after'                         => 'Due date is after ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Payment date is on..',
    'rule_trigger_payment_date_on'                        => 'Payment date is on ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Payment date is before..',
    'rule_trigger_payment_date_before'                    => 'Payment date is before ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Payment date is after..',
    'rule_trigger_payment_date_after'                     => 'Payment date is after ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                        => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                    => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                     => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaction was created before..',
    'rule_trigger_created_at_before'                      => 'Transaction was created before ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaction was created after..',
    'rule_trigger_created_at_after'                       => 'Transaction was created after ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaction was last updated before..',
    'rule_trigger_updated_at_before'                      => 'Transaction was last updated before ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaction was last updated after..',
    'rule_trigger_updated_at_after'                       => 'Transaction was last updated after ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                     => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'               => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                 => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                   => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Any attachment\'s notes are..',
    'rule_trigger_attachment_notes_are'                   => 'Any attachment\'s notes are ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Any attachment\'s notes contain..',
    'rule_trigger_attachment_notes_contains'              => 'Any attachment\'s notes contain ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Any attachment\'s notes start with..',
    'rule_trigger_attachment_notes_starts'                => 'Any attachment\'s notes start with ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Any attachment\'s notes end with..',
    'rule_trigger_attachment_notes_ends'                  => 'Any attachment\'s notes end with ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaction is reconciled',
    'rule_trigger_reconciled'                             => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                          => 'Any transaction matches(!)',
    'rule_trigger_exists'                                 => 'Any transaction matches',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Destination account ID is not ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag is not ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                             => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                    => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                   => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaction has no tags',
    'rule_trigger_not_any_notes'                          => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                   => 'Transaction has no external URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaction has a (any) attachment(s)',
    'rule_trigger_not_has_no_category'                    => 'Transaction has a (any) category',
    'rule_trigger_not_has_no_budget'                      => 'Transaction has a (any) budget',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaction has a (any) tag',
    'rule_trigger_not_no_notes'                           => 'Transaction has any notes',
    'rule_trigger_not_no_external_url'                    => 'Transaction has an external URL',
    'rule_trigger_not_source_is_cash'                     => 'Source account is not a cash account',
    'rule_trigger_not_destination_is_cash'                => 'Destination account is not a cash account',
    'rule_trigger_not_account_is_cash'                    => 'Neither account is a cash account',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'DELETE transaction(!)',
    'rule_action_delete_transaction'             => 'DELETE transaction(!)',
    'rule_action_set_category'                   => 'Задайте категория на ":action_value"',
    'rule_action_clear_category'                 => 'Изчисти категорията',
    'rule_action_set_budget'                     => 'Задайте бюджета на ":action_value"',
    'rule_action_clear_budget'                   => 'Изчисти бюджета',
    'rule_action_add_tag'                        => 'Добави етикет ":action_value"',
    'rule_action_remove_tag'                     => 'Премахни етикет ":action_value"',
    'rule_action_remove_all_tags'                => 'Премахни всички етикети',
    'rule_action_set_description'                => 'Задайте описание ":action_value"',
    'rule_action_append_description'             => 'Допълнете описанието с ":action_value"',
    'rule_action_prepend_description'            => 'Започнете описанието с ":action_value"',
    'rule_action_set_category_choice'            => 'Set category to ..',
    'rule_action_clear_category_choice'          => 'Изчисти всички категории',
    'rule_action_set_budget_choice'              => 'Set budget to ..',
    'rule_action_clear_budget_choice'            => 'Изчисти всички бюджети',
    'rule_action_add_tag_choice'                 => 'Add tag ..',
    'rule_action_remove_tag_choice'              => 'Remove tag ..',
    'rule_action_remove_all_tags_choice'         => 'Премахни всички етикети',
    'rule_action_set_description_choice'         => 'Set description to ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Append description with ..',
    'rule_action_prepend_description_choice'     => 'Prepend description with ..',
    'rule_action_set_source_account_choice'      => 'Set source account to ..',
    'rule_action_set_source_account'             => 'Задай разходната сметка на ":action_value"',
    'rule_action_set_destination_account_choice' => 'Set destination account to ..',
    'rule_action_set_destination_account'        => 'Задай приходната сметка на :action_value',
    'rule_action_append_notes_choice'            => 'Append notes with ..',
    'rule_action_append_notes'                   => 'Добави в бележките ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Prepend notes with ..',
    'rule_action_prepend_notes'                  => 'Започни бележките с ":action_value"',
    'rule_action_clear_notes_choice'             => 'Изчисти всички бележки',
    'rule_action_clear_notes'                    => 'Изчисти всички бележки',
    'rule_action_set_notes_choice'               => 'Set notes to ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                => 'Switch source and destination',
    'rule_action_set_notes'                      => 'Задай бележките на ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Преобразувайте транзакцията в депозит',
    'rule_action_convert_deposit'                => 'Преобразувайте транзакцията в депозит в ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Преобразувайте транзакцията в теглене',
    'rule_action_convert_withdrawal'             => 'Преобразувайте транзакцията в теглене от ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Преобразувайте транзакцията в трансфер',
    'rule_action_convert_transfer'               => 'Преобразувайте транзакцията в трансфер към ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'     => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'          => 'Append description to notes',
    'rule_action_append_notes_to_descr'          => 'Append notes to description',
    'rule_action_move_descr_to_notes'            => 'Replace notes with description',
    'rule_action_move_notes_to_descr'            => 'Replace description with notes',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Правило базирано на транзакция ":description"',
    'new_rule_for_journal_description'          => 'Това правило е базирано на транзакция ":description". То ще открива транзакции, които са идентични.',

    // tags
    'store_new_tag'                             => 'Запаметете нов етикет',
    'update_tag'                                => 'Обновяване на етикет',
    'no_location_set'                           => 'Не е зададено местоположение.',
    'meta_data'                                 => 'Мета данни',
    'location'                                  => 'Местоположение',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Без дата',
    'result'                                    => 'Резултат',
    'sums_apply_to_range'                       => 'Всички суми се отнасят към избрания диапазон',
    'mapbox_api_key'                            => 'За да използвате карта, вземете API ключ от <a href="https://www.mapbox.com/"> Mapbox </a>. Отворете вашия <code>.env </code> файл и въведете този код след <code> MAPBOX_API_KEY = </code>.',
    'press_object_location'                     => 'Щракнете с десния бутон или натиснете дълго, за да зададете местоположението на обекта.',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Изчисти местоположението',
    'delete_all_selected_tags'                  => 'Изтрий всички избрани етикети',
    'select_tags_to_delete'                     => 'Не забравяйте да изберете някои етикети.',
    'deleted_x_tags'                            => 'Изтрит :count етикет.|Изтрити :count етикети.',
    'create_rule_from_transaction'              => 'Създайте правило въз основа на транзакцията',
    'create_recurring_from_transaction'         => 'Създай повтаряща се транзакция базирана на транзакция',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Let your browser decide',
    'dark_mode_option_light'                    => 'Always light',
    'dark_mode_option_dark'                     => 'Always dark',
    'equal_to_language'                         => '(равно на език)',
    'dark_mode_preference'                      => 'Dark mode',
    'dark_mode_preference_help'                 => 'Tell Firefly III when to use dark mode.',
    'pref_home_screen_accounts'                 => 'Сметки на началния екран',
    'pref_home_screen_accounts_help'            => 'Кои сметки трябва да се виждат на началната страница?',
    'pref_view_range'                           => 'Виж диапазон',
    'pref_view_range_help'                      => 'Някои графики се групират автоматично по периоди. Вашите бюджети също ще бъдат групирани по периоди. Какъв период бихте предпочели?',
    'pref_1D'                                   => 'Един ден',
    'pref_1W'                                   => 'Една седмица',
    'pref_1M'                                   => 'Един месец',
    'pref_3M'                                   => 'Три месеца (тримесечие)',
    'pref_6M'                                   => 'Шест месеца',
    'pref_1Y'                                   => 'Една година',
    'pref_last365'                              => 'Last year',
    'pref_last90'                               => 'Last 90 days',
    'pref_last30'                               => 'Last 30 days',
    'pref_last7'                                => 'Last 7 days',
    'pref_YTD'                                  => 'Year to date',
    'pref_QTD'                                  => 'Quarter to date',
    'pref_MTD'                                  => 'Month to date',
    'pref_languages'                            => 'Езици',
    'pref_locale'                               => 'Локални настройки',
    'pref_languages_help'                       => 'Firefly III поддържа няколко езика. Кой предпочиташ?',
    'pref_locale_help'                          => 'Firefly III ви позволява да задавате други локални настройки, например как се форматират валути, числа и дати. Записите в този списък може да не се поддържат от вашата система. Firefly III няма правилните настройки за дата за всеки локал; свържете се с мен за подобрения.',
    'pref_locale_no_demo'                       => 'Тази функция няма да работи за демо потребителя.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Настройки за фискалната година',
    'pref_custom_fiscal_year_label'             => 'Включено',
    'pref_custom_fiscal_year_help'              => 'В страни, които използват финансова година различна от 1 януари до 31 декември, можете да го включите и да определите началните / крайните дати на фискалната година',
    'pref_fiscal_year_start_label'              => 'Начална дата на фискалната година',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Не забравяйте да премахнете профила от приложението си за удостоверяване!',
    'pref_two_factor_auth_code'                 => 'Код за потвърждение',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Нулирайте кода за потвърждение',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'Ако не можете да сканирате QR кода, не се колебайте да използвате вместо това тайната:<code>:secret </code>.',
    '2fa_backup_codes'                          => 'Съхранявайте тези резервни кодове за достъп в случай, че загубите устройството си.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Този MFA код е невалиден.',
    'pref_save_settings'                        => 'Запис на настройките',
    'saved_preferences'                         => 'Настройките са запазени!',
    'preferences_general'                       => 'Основни',
    'preferences_frontpage'                     => 'Начален екран',
    'preferences_security'                      => 'Сигурност',
    'preferences_layout'                        => 'Оформление',
    'preferences_notifications'                 => 'Notifications',
    'pref_home_show_deposits'                   => 'Покажи депозитите на началния екран',
    'pref_home_show_deposits_info'              => 'Началният екран вече показва вашите сметки за разходи. Трябва ли да показва и вашите сметки за приходи?',
    'pref_home_do_show_deposits'                => 'Да, покажете ги',
    'successful_count'                          => 'от които :count успешни',
    'list_page_size_title'                      => 'Размер на страницата',
    'list_page_size_help'                       => 'Всеки списък от неща (сметки, транзакции и т.н.) показва най-много толкова на страница.',
    'list_page_size_label'                      => 'Размер на страницата',
    'between_dates'                             => '(:start и :end)',
    'pref_optional_fields_transaction'          => 'Незадължителни полета за транзакции',
    'pref_optional_fields_transaction_help'     => 'По подразбиране не всички полета са активирани при създаване на нова транзакция (поради претрупването). По-долу можете да активирате тези полета, ако смятате че биха могли да бъдат полезни за вас. Разбира се, всяко поле, което е деактивирано но вече попълнено, ще бъде видимо независимо от настройката.',
    'optional_tj_date_fields'                   => 'Полета за дати',
    'optional_tj_other_fields'                  => 'Other fields',
    'optional_tj_attachment_fields'             => 'Полета за прикачени файлове',
    'pref_optional_tj_interest_date'            => 'Полета за лихви',
    'pref_optional_tj_book_date'                => 'Дата на осчетоводяване',
    'pref_optional_tj_process_date'             => 'Дата на обработка',
    'pref_optional_tj_due_date'                 => 'Дата на падеж',
    'pref_optional_tj_payment_date'             => 'Дата на плащане',
    'pref_optional_tj_invoice_date'             => 'Дата на фактура',
    'pref_optional_tj_internal_reference'       => 'Вътрешна референция',
    'pref_optional_tj_notes'                    => 'Бележки',
    'pref_optional_tj_attachments'              => 'Прикачени файлове',
    'pref_optional_tj_external_url'             => 'External URL',
    'pref_optional_tj_location'                 => 'Location',
    'pref_optional_tj_links'                    => 'Transaction links',
    'optional_field_meta_dates'                 => 'Дати',
    'optional_field_meta_business'              => 'Бизнес',
    'optional_field_attachments'                => 'Прикачени файлове',
    'optional_field_meta_data'                  => 'Незадължителни мета данни',
    'external_url'                              => 'Външен URL адрес',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Alert when a new API access token is created',
    'pref_notification_transaction_creation'    => 'Alert when a transaction is created automatically',
    'pref_notification_user_login'              => 'Alert when you login from a new location',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Notifications',
    'pref_notifications_help'                   => 'Indicate if these are notifications you would like to get. Some notifications may contain sensitive financial information.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Financial administration',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Purge data from Firefly III',
    'purge_data_expl'                           => '"Purging" means "deleting that which is already deleted". In normal circumstances, Firefly III deletes nothing permanently. It just hides it. The button below deletes all of these previously "deleted" records FOREVER.',
    'delete_stuff_header'                       => 'Delete and purge data',
    'purge_all_data'                            => 'Purge all deleted records',
    'purge_data'                                => 'Purge data',
    'purged_all_records'                        => 'All deleted records have been purged.',
    'delete_data_title'                         => 'Delete data from Firefly III',
    'permanent_delete_stuff'                    => 'You can delete stuff from Firefly III. Using the buttons below means that your items will be removed from view and hidden. There is no undo-button for this, but the items may remain in the database where you can salvage them if necessary.',
    'other_sessions_logged_out'                 => 'Всички други ваши сесии бяха затворени.',
    'delete_unused_accounts'                    => 'Deleting unused accounts will clean your auto-complete lists.',
    'delete_all_unused_accounts'                => 'Delete unused accounts',
    'deleted_all_unused_accounts'               => 'All unused accounts are deleted',
    'delete_all_budgets'                        => 'Изтрийте ВСИЧКИ ваши бюджети',
    'delete_all_categories'                     => 'Изтрийте ВСИЧКИ ваши категории',
    'delete_all_tags'                           => 'Изтрийте ВСИЧКИ ваши етикети',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Изтрийте ВСИЧКИ ваши касички',
    'delete_all_rules'                          => 'Изтрийте ВСИЧКИ ваши правила',
    'delete_all_recurring'                      => 'Изтрийте ВСИЧКИ ваши повтарящи се транзакции',
    'delete_all_object_groups'                  => 'Изтрийте ВСИЧКИ ваши групи обекти',
    'delete_all_accounts'                       => 'Изтрийте ВСИЧКИ ваши сметки',
    'delete_all_asset_accounts'                 => 'Изтрийте ВСИЧКИ ваши сметки за активи',
    'delete_all_expense_accounts'               => 'Изтрийте ВСИЧКИ ваши сметки за разходи',
    'delete_all_revenue_accounts'               => 'Изтрийте ВСИЧКИ ваши сметки за приходи',
    'delete_all_liabilities'                    => 'Изтрийте ВСИЧКИ ваши задължения',
    'delete_all_transactions'                   => 'Изтрийте ВСИЧКИ ваши транзакции',
    'delete_all_withdrawals'                    => 'Изтрийте ВСИЧКИ ваши тегления',
    'delete_all_deposits'                       => 'Изтрийте ВСИЧКИ ваши депозити',
    'delete_all_transfers'                      => 'Изтрийте ВСИЧКИ ваши прехвърляния',
    'also_delete_transactions'                  => 'Изтриването на сметки ще изтрие също така и ВСИЧКИ свързани тегления, депозити и прехвърляния!',
    'deleted_all_budgets'                       => 'Всички бюджети бяха изтрити',
    'deleted_all_categories'                    => 'Всички категории бяха изтрити',
    'deleted_all_tags'                          => 'Всички етикети бяха изтрити',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Всички касички бяха изтрити',
    'deleted_all_rules'                         => 'Всички правила и групи правила бяха изтрити',
    'deleted_all_object_groups'                 => 'Всички групи бяха изтрити',
    'deleted_all_accounts'                      => 'Всички сметки бяха изтрити',
    'deleted_all_asset_accounts'                => 'Всички сметки за активи бяха изтрити',
    'deleted_all_expense_accounts'              => 'Всички сметки за разходи бяха изтрити',
    'deleted_all_revenue_accounts'              => 'Всички сметки за приходи бяха изтрити',
    'deleted_all_liabilities'                   => 'Всички задължения бяха изтрити',
    'deleted_all_transactions'                  => 'Всички транзакции бяха изтрити',
    'deleted_all_withdrawals'                   => 'Всички тегления бяха изтрити',
    'deleted_all_deposits'                      => 'Всички депозити бяха изтрити',
    'deleted_all_transfers'                     => 'Всички прехвърляния бяха изтрити',
    'deleted_all_recurring'                     => 'Всички повтарящи се транзакции бяха изтрити',
    'change_your_password'                      => 'Смяна на парола',
    'delete_account'                            => 'Изтриване на профил',
    'current_password'                          => 'Текуща парола',
    'new_password'                              => 'Нова парола',
    'new_password_again'                        => 'Нова парола (повтори)',
    'delete_your_account'                       => 'Изтриване на вашият профил',
    'delete_your_account_help'                  => 'Изтриването на профила ви също ще изтрие всички сметки, транзакции, <em> всичко </em>, което може да сте запазили в Firefly III. Ще бъде МИНАЛО.',
    'delete_your_account_password'              => 'Въведете паролата си, за да продължите.',
    'password'                                  => 'Парола',
    'are_you_sure'                              => 'Сигурен ли сте? Не можете да отмените това.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'ИЗТРИВАНЕ на вашият профил',
    'invalid_current_password'                  => 'Невалидна текуща парола!',
    'password_changed'                          => 'Паролата е променена!',
    'should_change'                             => 'Идеята е да СМЕНИТЕ паролата си.',
    'invalid_password'                          => 'Невалидна парола!',
    'what_is_pw_security'                       => 'Какво е "проверете сигурността на паролата"?',
    'secure_pw_title'                           => 'Как да изберем сигурна парола',
    'forgot_password_response'                  => 'Thank you. If an account exists with this email address, you will find instructions in your inbox.',
    'secure_pw_history'                         => 'Не минава и седмица без да прочетете в новините за сайт, който губи паролите на своите потребители. Хакерите и крадците използват тези пароли, за да се опитат да откраднат вашата лична информация. Тази информация е ценна.',
    'secure_pw_ff'                              => 'Използвате ли една и съща парола в Интернет? Ако един сайт загуби паролата ви, хакерите имат достъп до всичките ви данни. Firefly III разчита на вас да изберете силна и уникална парола, за да защитите финансовите си записи.',
    'secure_pw_check_box'                       => 'За да ви помогне да направите това Firefly III може да провери дали паролата, която искате да използвате, е била открадната в миналото. В такъв случай Firefly III ви съветва да НЕ използвате тази парола.',
    'secure_pw_working_title'                   => 'Как работи това?',
    'secure_pw_working'                         => 'Като поставите отметка в квадратчето, Firefly III ще изпрати първите пет знака от хеша на SHA1 на вашата парола до <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/"> уебсайтът на Troy Hunt </a>, за да се види дали е в списъка. Това ще ви попречи да използвате опасни пароли, както се препоръчва в последната <a href="https://pages.nist.gov/800-63-3/sp800-63b.html"> Специална публикация на NIST </a> на тази тема.',
    'secure_pw_should'                          => 'Трябва ли да маркирам квадратчето?',
    'secure_pw_long_password'                   => 'Да. Винаги проверявайте дали вашата парола е безопасна.',
    'command_line_token'                        => 'Маркер за командният ред',
    'explain_command_line_token'                => 'Този маркер ще ви е необходим, за да изпълнявате опции на командния ред, като например експортиране на данни. Без него тази чувствителна команда няма да работи. Не споделяйте маркера на вашия команден ред. Никой няма да ви поиска този знак, дори аз. Ако се страхувате, че сте загубили този маркер или ако сте параноик, регенерирайте този маркер с помощта на бутона.',
    'regenerate_command_line_token'             => 'Регенерирайте маркера на командния ред',
    'token_regenerated'                         => 'Беше генериран нов маркер за команден ред',
    'change_your_email'                         => 'Смяна на имейл адрес',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Докато не потвърдите своя имейл адрес, не можете да влезете.',
    'login_with_new_email'                      => 'Вече можете да влезете с новия си имейл адрес.',
    'login_with_old_email'                      => 'Вече можете да влезете отново със стария си имейл адрес.',
    'login_provider_local_only'                 => 'Това действие не е достъпно при удостоверяване чрез ":login_provider".',
    'external_user_mgt_disabled'                => 'Това действие не е достъпно, когато Firefly III не е отговорен за управлението на потребителите или обработката на удостоверяването.',
    'external_auth_disabled'                    => 'Това действие не е достъпно, когато Firefly III не е отговорен обработката на удостоверяването.',
    'delete_local_info_only'                    => "Тъй като Firefly III не е отговорен за управлението на потребителите или обработката на удостоверяването, тази функция ще изтрие само локална информация на Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth клиенти',
    'profile_oauth_no_clients'                  => 'Не сте създали клиенти на OAuth.',
    'profile_oauth_clients_external_auth'       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'              => 'Клиенти',
    'profile_oauth_client_id'                   => 'ИД (ID) на клиент',
    'profile_oauth_client_name'                 => 'Име',
    'profile_oauth_client_secret'               => 'Тайна',
    'profile_oauth_create_new_client'           => 'Създай нов клиент',
    'profile_oauth_create_client'               => 'Създай клиент',
    'profile_oauth_edit_client'                 => 'Редактирай клиент',
    'profile_oauth_name_help'                   => 'Нещо, което вашите потребители ще разпознаят и ще се доверят.',
    'profile_oauth_redirect_url'                => 'Линк на препратката',
    'profile_oauth_redirect_url_help'           => 'URL адрес за обратно извикване на оторизацията на вашето приложение.',
    'profile_authorized_apps'                   => 'Удостоверени приложения',
    'profile_authorized_clients'                => 'Удостоверени клиенти',
    'profile_scopes'                            => 'Сфери',
    'profile_revoke'                            => 'Анулирай',
    'profile_oauth_client_secret_title'         => 'Тайна на клиента',
    'profile_oauth_client_secret_expl'          => 'Това е новата ви "тайна на клиента". Това е единственият път, когато ще бъде показана, така че не го губете! Вече можете да използвате този маркер, за да отправяте заявки към API.',
    'profile_personal_access_tokens'            => 'Персонални маркери за достъп',
    'profile_personal_access_token'             => 'Персонален маркер за достъп',
    'profile_oauth_confidential'                => 'Поверително',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Това е новия ви персонален маркер за достъп. Това е единственият път, когато ще бъде показан, така че не го губете! Вече можете да използвате този маркер, за да отправяте заявки към API.',
    'profile_no_personal_access_token'          => 'Не сте създали никакви лични маркери за достъп.',
    'profile_create_new_token'                  => 'Създай нов маркер',
    'profile_create_token'                      => 'Създай маркер',
    'profile_create'                            => 'Създай',
    'profile_save_changes'                      => 'Запазване на промените',
    'profile_whoops'                            => 'Опаааа!',
    'profile_something_wrong'                   => 'Нещо се обърка!',
    'profile_try_again'                         => 'Нещо се обърка. Моля, опитайте отново.',
    'amounts'                                   => 'Суми',
    'multi_account_warning_unknown'             => 'В зависимост от вида на транзакцията която създавате, източникът и / или целевата сметка на следващите разделяния може да бъде променена от това което е дефинирано в първото разделение на транзакцията.',
    'multi_account_warning_withdrawal'          => 'Имайте предвид, че разходна сметка на следващите разделяния ще бъде тази която е дефинирана в първия раздел на тегленето.',
    'multi_account_warning_deposit'             => 'Имайте предвид, че приходната сметка на следващите разделяния ще бъде тази която е дефинирана в първия раздел на депозита.',
    'multi_account_warning_transfer'            => 'Имайте предвид, че приходната + разходната сметка на следващите разделяния ще бъде тази която е дефинирана в първия раздел на прехвърлянето.',


    // export data:
    'export_data_title'                         => 'Експортирайте данни от Firefly III',
    'export_data_menu'                          => 'Експортирай данни',
    'export_data_bc'                            => 'Експортирайте данни от Firefly III',
    'export_data_main_title'                    => 'Експортирайте данни от Firefly III',
    'export_data_expl'                          => 'Тази връзка ви позволява да експортирате всички транзакции + мета данни от Firefly III. Моля, обърнете се към помощника (горе вдясно (?) - икона) за повече информация за процеса.',
    'export_data_all_transactions'              => 'Експортирай всички транзакции',
    'export_data_advanced_expl'                 => 'Ако имате нужда от по-усъвършенстван или специфичен тип експорт, прочетете помощта за това как да използвате командата на конзолата <code> php artisan help firefly-iii:export-data </code>.',

    // attachments
    'nr_of_attachments'                         => 'Един прикачен файл|:count прикачени файла',
    'attachments'                               => 'Прикачени файлове',
    'edit_attachment'                           => 'Редактирай прикачен файл ":name"',
    'update_attachment'                         => 'Обнови прикачения файл',
    'delete_attachment'                         => 'Изтрий прикачен файл ":name"',
    'attachment_deleted'                        => 'Изтрит прикачен файл ":name"',
    'liabilities_deleted'                       => 'Изтрито задължение ":name"',
    'attachment_updated'                        => 'Обновен прикачен файл ":name"',
    'upload_max_file_size'                      => 'Максимален размер на файла: :size',
    'list_all_attachments'                      => 'Списък на всички прикачени файлове',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Разходи',
    'title_withdrawal'                          => 'Тегления',
    'title_revenue'                             => 'Приходи',
    'title_deposit'                             => 'Депозити',
    'title_transfer'                            => 'Прехвърляния',
    'title_transfers'                           => 'Прехвърляния',
    'submission_options'                        => 'Submission options',
    'apply_rules_checkbox'                      => 'Apply rules',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Тази транзакция вече е теглене',
    'convert_is_already_type_Deposit'           => 'Тази транзакция вече е депозит',
    'convert_is_already_type_Transfer'          => 'Тази транзакция вече е прехвърляне',
    'convert_to_Withdrawal'                     => 'Преобразувайте ":description" в теглене',
    'convert_to_Deposit'                        => 'Преобразувайте ":description" в депозит',
    'convert_to_Transfer'                       => 'Преобразувайте ":description" в прехвърляне',
    'convert_options_WithdrawalDeposit'         => 'Преобразувайте теглене в депозит',
    'convert_options_WithdrawalTransfer'        => 'Преобразувайте теглене в прехвърляне',
    'convert_options_DepositTransfer'           => 'Преобразувайте депозит в прехвърляне',
    'convert_options_DepositWithdrawal'         => 'Преобразувайте депозит в теглене',
    'convert_options_TransferWithdrawal'        => 'Преобразувайте прехвърляне в теглене',
    'convert_options_TransferDeposit'           => 'Преобразувайте прехвърляне в депозит',
    'convert_Withdrawal_to_deposit'             => 'Преобразувайте това теглене в депозит',
    'convert_Withdrawal_to_transfer'            => 'Преобразувайте това теглене в прехвърляне',
    'convert_Deposit_to_withdrawal'             => 'Преобразувайте този депозит в теглене',
    'convert_Deposit_to_transfer'               => 'Преобразувайте този депозит в прехвърляне',
    'convert_Transfer_to_deposit'               => 'Преобразувайте това прехвърляне в депозит',
    'convert_Transfer_to_withdrawal'            => 'Преобразувайте това прехвърляне в теглене',
    'convert_please_set_revenue_source'         => 'Моля, изберете приходната сметка, откъде ще дойдат парите.',
    'convert_please_set_asset_destination'      => 'Моля, изберете сметката за активи, където ще отидат парите.',
    'convert_please_set_expense_destination'    => 'Моля изберете разходната сметка, където ще отидат парите.',
    'convert_please_set_asset_source'           => 'Моля изберете сметката за активи, откъде ще дойдат парите.',
    'convert_expl_w_d'                          => 'При конвертиране от теглене в депозит парите ще бъдат депозирани в показаната сметка за активи, вместо да бъдат изтеглени от нея.|При конвертиране от теглене в депозит парите ще бъдат внесени в показаните сметки за активи, вместо да бъдат изтеглени от тях.',
    'convert_expl_w_t'                          => 'При конвертиране на теглене в трансфер парите ще бъдат прехвърлени от изходната сметка в друга сметка за активи или сметка за задължения, вместо да бъдат изразходвани по първоначалната сметка за разходи.|При конвертиране на теглене в трансфер парите ще бъдат прехвърлени от изходните сметки в други сметки за активи или задължения, вместо да бъдат изразходвани по първоначалните сметки за разходи.',
    'convert_expl_d_w'                          => 'При конвертиране на депозит в теглене парите ще бъдат изтеглени от показаната изходна сметка, вместо да бъдат внесени в нея.|При конвертиране на депозит в теглене, парите ще бъдат изтеглени от показаните изходни сметки, вместо да бъдат депозирани в тях.',
    'convert_expl_d_t'                          => 'Когато конвертирате депозит в прехвърляне, парите ще бъдат депозирани в посочената целева сметка от който и да е от вашите активи или пасиви.|Когато конвертирате депозит в прехвърляне, парите ще бъдат депозирани в посочените целеви сметки от която и да е от вашите сметки за активи или пасиви.',
    'convert_expl_t_w'                          => 'Когато конвертирате трансфер в теглене, парите ще бъдат изразходвани за целевата сметка, която сте задали тук, вместо да бъдат прехвърлени.|Когато конвертирате трансфер в теглене, парите ще бъдат изразходвани за целевите сметки, които сте задали тук, вместо да бъдат прехвърлени.',
    'convert_expl_t_d'                          => 'Когато преобразувате прехвърляне в депозит, парите ще бъдат депозирани в целевата сметка, която виждате тук, вместо да бъдат прехвърлени.|Когато конвертирате прехвърляне в депозит, парите ще бъдат внесени в целевите сметки, които виждате тук, вместо да бъде прехвърлени в тях.',
    'convert_select_sources'                    => 'За да завършите преобразуването, моля задайте нова сметка източник по-долу.|За да завършите преобразуването, моля задайте новите сметки източници по-долу.',
    'convert_select_destinations'               => 'За да завършите преобразуването, моля изберете новата целева сметка по-долу.|За да завършите преобразуването, моля изберете новите целеви сметки по-долу.',
    'converted_to_Withdrawal'                   => 'Транзакцията беше преобразувана в теглене',
    'converted_to_Deposit'                      => 'Транзакцията беше преобразувана в депозит',
    'converted_to_Transfer'                     => 'Транзакцията беше преобразувана в прехвърляне',
    'invalid_convert_selection'                 => 'Избраната от Вас сметка вече се използва в тази транзакция или не съществува.',
    'source_or_dest_invalid'                    => 'Не могат да се намерят правилните данни за транзакцията. Преобразуването не е възможно.',
    'convert_to_withdrawal'                     => 'Преобразуване в теглене',
    'convert_to_deposit'                        => 'Преобразуване в депозит',
    'convert_to_transfer'                       => 'Преобразуване в прехвърляне',

    // create new stuff:
    'create_new_withdrawal'                     => 'Създай ново теглене',
    'create_new_deposit'                        => 'Създай нов депозит',
    'create_new_transfer'                       => 'Създай ново прехвърляне',
    'create_new_asset'                          => 'Създай нова сметка за активи',
    'create_new_liabilities'                    => 'Create new liability',
    'create_new_expense'                        => 'Създай нова сметка за разходи',
    'create_new_revenue'                        => 'Създай нова сметка за приходи',
    'create_new_piggy_bank'                     => 'Създай нова касичка',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Create new subscription',
    'create_new_rule'                           => 'Create new rule',

    // currencies:
    'create_currency'                           => 'Създай нова валута',
    'store_currency'                            => 'Запази нова валута',
    'update_currency'                           => 'Обнови нова валута',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => 'Не може да се изтрие :name, защото все още се използва.',
    'cannot_delete_fallback_currency'           => ':name е резервната валута на системата и не може да бъде изтрита.',
    'cannot_disable_currency_journals'          => 'Не може да се деактивира :name, защото транзакции все още я използват.',
    'cannot_disable_currency_last_left'         => 'Не може да се деактивира :name, защото това е последната активна валута.',
    'cannot_disable_currency_account_meta'      => 'Не може да се деактивира :name, защото се използва в сметки за активи.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Не може да се деактивира :name, защото се използва в повтарящи се транзакции.',
    'cannot_disable_currency_available_budgets' => 'Не може да се деактивира :name, защото се използва в налични бюджети.',
    'cannot_disable_currency_budget_limits'     => 'Не може да се деактивира :name, защото се използва в лимити по бюджети.',
    'cannot_disable_currency_current_default'   => 'Не може да се деактивира :name, защото е текущата валута по подразбиране.',
    'cannot_disable_currency_system_fallback'   => 'Не може да се деактивира :name, защото е валута по подразбиране за системата.',
    'disable_EUR_side_effects'                  => 'Еврото е аварийната резервна валутата на системата. Деактивирането му може да има нежелани странични ефекти и може да анулира вашата гаранция.',
    'deleted_currency'                          => 'Валута :name е изтрита',
    'created_currency'                          => 'Валута :name е създадена',
    'could_not_store_currency'                  => 'Новата валута не можа да се запази.',
    'updated_currency'                          => 'Валута :name е обновена',
    'ask_site_owner'                            => 'Моля помолете :owner да добави, премахне или редактира валути.',
    'currencies_intro'                          => 'Firefly III поддържа различни валути, които можете да зададете и активирате тук.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Направи по подразбиране',
    'default_currency'                          => 'по подразбиране',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Изключено',
    'enable_currency'                           => 'Включено',
    'disable_currency'                          => 'Деактивиране',
    'currencies_default_disabled'               => 'Повечето от тези валути са деактивирани по подразбиране. За да ги използвате, първо трябва да ги активирате.',
    'currency_is_now_enabled'                   => 'Валута ":name" беше активирана',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Валута ":name" беше деактивирана',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Задължителни полета',
    'optionalFields'                            => 'Незадължителни полета',
    'options'                                   => 'Настройки',

    // budgets:
    'daily_budgets'                             => 'Дневни бюджети',
    'weekly_budgets'                            => 'Седмични бюджети',
    'monthly_budgets'                           => 'Месечни бюджети',
    'quarterly_budgets'                         => 'Тримесечни бюджети',
    'half_year_budgets'                         => 'Шестмесечни бюджети',
    'yearly_budgets'                            => 'Годишни бюджети',
    'other_budgets'                             => 'Времево персонализирани бюджети',
    'budget_limit_not_in_range'                 => 'Тази сума се отнася за периода от :start до :end:',
    'total_available_budget'                    => 'Общ наличен бюджет (между :start и :end)',
    'total_available_budget_in_currency'        => 'Общ наличен бюджет в :currency',
    'see_below'                                 => 'виж по-долу',
    'create_new_budget'                         => 'Създай нов бюджет',
    'store_new_budget'                          => 'Запази новия бюджет',
    'stored_new_budget'                         => 'Новия бюджет ":name" е запазен',
    'available_between'                         => 'Разполагаеми между :start и :end',
    'transactionsWithoutBudget'                 => 'Разходи без бюджет',
    'transactions_no_budget'                    => 'Разходи без бюджет между :start и :end',
    'spent_between'                             => 'Вече похарчени между :start и :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Задайте наличната сума',
    'update_available_amount'                   => 'Обновете наличната сума',
    'ab_basic_modal_explain'                    => 'Използвайте тази форма, за да посочите колко очаквате да можете да бюджетирате (общо, във :currency) за посочения период.',
    'createBudget'                              => 'Нов бюджет',
    'invalid_currency'                          => 'Това е невалидна валута',
    'invalid_amount'                            => 'Моля въведете сума',
    'set_ab'                                    => 'Наличната сума на бюджета бе зададена',
    'updated_ab'                                => 'Наличната сума на бюджета бе обновена',
    'deleted_ab'                                => 'Наличната сума на бюджета бе изтрита',
    'deleted_bl'                                => 'Бюджетната сума бе премахната',
    'alt_currency_ab_create'                    => 'Задайте наличния бюджет в друга валута',
    'bl_create_btn'                             => 'Задайте бюджет в друга валута',
    'inactiveBudgets'                           => 'Неактивни бюджети',
    'without_budget_between'                    => 'Транзакции без бюджет между :start и :end',
    'delete_budget'                             => 'Изтрий бюджет ":name"',
    'deleted_budget'                            => 'Бюджет ":name" бе изтрит',
    'edit_budget'                               => 'Редактирай бюджет ":name"',
    'updated_budget'                            => 'Бюджет ":name" бе обновен',
    'update_amount'                             => 'Обнови сумата',
    'update_budget'                             => 'Обнови бюджет',
    'update_budget_amount_range'                => 'Обнови (очакваната) налична сума между :start и :end',
    'set_budget_limit_title'                    => 'Задайте сума за бюджет :budget между :start и :end',
    'set_budget_limit'                          => 'Задайте сума за бюджет',
    'budget_period_navigator'                   => 'Указател за периода',
    'info_on_available_amount'                  => 'Какво имам на разположение?',
    'available_amount_indication'               => 'Използвайте тези суми, за да получите насока какъв може да бъде общият ви бюджет.',
    'suggested'                                 => 'Предложен',
    'average_between'                           => 'Средно между :start и :end',
    'transferred_in'                            => 'Прехвърлени (към)',
    'transferred_away'                          => 'Прехвърлени (от)',
    'auto_budget_none'                          => 'Няма автоматичен бюджет',
    'auto_budget_reset'                         => 'Задайте фиксирана сума за всеки период',
    'auto_budget_rollover'                      => 'Добавете сума за всеки период',
    'auto_budget_adjusted'                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                  => 'На ден',
    'auto_budget_period_weekly'                 => 'На седмица',
    'auto_budget_period_monthly'                => 'Месечно',
    'auto_budget_period_quarterly'              => 'Тримесечно',
    'auto_budget_period_half_year'              => 'На полугодие',
    'auto_budget_period_yearly'                 => 'Годишно',
    'auto_budget_help'                          => 'Можете да прочетете повече за тази функция в помощта. Кликнете върху иконата (?) горе вдясно.',
    'auto_budget_reset_icon'                    => 'Този бюджет ще бъде зададен периодично',
    'auto_budget_rollover_icon'                 => 'Размерът на бюджета ще се увеличава периодично',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Премахнете сумата на бюджета в :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Suscripción',
    'not_expected_period'                       => 'Не се очаква този период',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => '(Все още) не',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Повторения',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Свързани транзакции',
    'auto_match_on'                             => 'Автоматично свързани от Firefly III',
    'auto_match_off'                            => 'Не автоматично свързани от Firefly III',
    'next_expected_match'                       => 'Следващо очаквано съвпадение',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Още',
    'rescan_old'                                => 'Изпълнете отново правилата за всички транзакции',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Очаквано между :start и :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'прескача',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'неактивно правило',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Очаквано :date',
    'bill_expected_date_js'                     => 'Expected {date}',
    'expected_amount'                           => 'Importe (Previsto)',
    'bill_paid_on'                              => 'Paid on {date}',
    'bill_repeats_weekly'                       => 'Повтаря се седмично',
    'bill_repeats_monthly'                      => 'Повтаря се месечно',
    'bill_repeats_quarterly'                    => 'Повтаря се тримесечно',
    'bill_repeats_half-year'                    => 'Повтаря се на половин година',
    'bill_repeats_yearly'                       => 'Повтаря се годишно',
    'bill_repeats_weekly_other'                 => 'Повтаря се през седмица',
    'bill_repeats_monthly_other'                => 'Повтаря се през месец',
    'bill_repeats_quarterly_other'              => 'Повтаря се през тримесечие',
    'bill_repeats_half-year_other'              => 'Повтаря се годишно',
    'bill_repeats_yearly_other'                 => 'Повтаря се през година',
    'bill_repeats_weekly_skip'                  => 'Повтаря се през {skip} седмици',
    'bill_repeats_monthly_skip'                 => 'Повтаря се през {skip} месеца',
    'bill_repeats_quarterly_skip'               => 'Повтаря се през {skip} тримесечия',
    'bill_repeats_half-year_skip'               => 'Повтаря се през {skip} половин години',
    'bill_repeats_yearly_skip'                  => 'Повтаря се през {skip} години',
    'subscriptions'                             => 'Абонаменти',
    'go_to_subscriptions'                       => 'Go to your subscriptions',
    'forever'                                   => 'Завинаги',
    'extension_date_is'                         => 'Extension date is {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'I am owed amount',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'Имате :count неактивна (архивирана) сметка, която можете да видите на тази отделна страница.|Имате :count неактивни (архивирани) сметки, които можете да видите на тази отделна страница.',
    'all_accounts_inactive'                     => 'Това са вашите неактивни сметки.',
    'active_account_link'                       => 'Тази връзка ви връща към активните ви сметки.',
    'account_missing_transaction'               => 'Сметка #:id (":name") не може да се вижда директно, но в Firefly липсва информация за пренасочване.',
    'cc_monthly_payment_date_help'              => 'Изберете която и да е година и месец, те ще бъдат игнорирани. От значение е само денят от месеца.',
    'details_for_asset'                         => 'Подробности за сметката за активи ":name"',
    'details_for_expense'                       => 'Подробности за сметката за разходи ":name"',
    'details_for_revenue'                       => 'Подробности за сметката за приходи ":name"',
    'details_for_cash'                          => 'Подробности за касова сметка ":name"',
    'store_new_asset_account'                   => 'Запамети нова сметка за активи',
    'store_new_expense_account'                 => 'Запамети нова сметка за разходи',
    'store_new_revenue_account'                 => 'Запамети нова сметка за приходи',
    'edit_asset_account'                        => 'Редактирай сметка за активи ":name"',
    'edit_expense_account'                      => 'Редактирай сметка за разходи ":name"',
    'edit_revenue_account'                      => 'Редактирай сметка за приходи ":name"',
    'delete_asset_account'                      => 'Изтрий сметка за активи ":name"',
    'delete_expense_account'                    => 'Изтрий сметка за разходи ":name"',
    'delete_revenue_account'                    => 'Изтрий сметка за приходи ":name"',
    'delete_liabilities_account'                => 'Изтрий задължение ":name"',
    'asset_deleted'                             => 'Сметка за активи ":name" е успешно изтрита',
    'account_deleted'                           => 'Сметка ":name" е успешно изтрита',
    'expense_deleted'                           => 'Сметка за разходи ":name" е успешно изтрита',
    'revenue_deleted'                           => 'Сметка за приходи ":name" е успешно изтрита',
    'update_asset_account'                      => 'Редактирай сметка за активи',
    'update_undefined_account'                  => 'Актуализиране на сметката',
    'update_liabilities_account'                => 'Редактирай задължение',
    'update_expense_account'                    => 'Редактирай сметка за разходи',
    'update_revenue_account'                    => 'Редактирай сметка за приходи',
    'make_new_asset_account'                    => 'Създай нова сметка за активи',
    'make_new_expense_account'                  => 'Създай нова сметка за разходи',
    'make_new_revenue_account'                  => 'Създай нова сметка за приходи',
    'make_new_liabilities_account'              => 'Създай ново задължение',
    'asset_accounts'                            => 'Сметки за активи',
    'undefined_accounts'                        => 'Accounts',
    'asset_accounts_inactive'                   => 'Сметки за активи (деактивирани)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Сметки за разходи',
    'expense_accounts_inactive'                 => 'Сметки за разходи (деактивирани)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Сметки за приходи',
    'revenue_accounts_inactive'                 => 'Сметки за приходи (деактивирани)',
    'cash_accounts'                             => 'Касови сметки',
    'Cash account'                              => 'Касова сметка',
    'liabilities_accounts'                      => 'Задължения',
    'liabilities_accounts_inactive'             => 'Задължения (деактивирани)',
    'reconcile_account'                         => 'Съгласувай сметка ":account"',
    'overview_of_reconcile_modal'               => 'Преглед на съгласуването',
    'delete_reconciliation'                     => 'Изтрий съгласуването',
    'update_reconciliation'                     => 'Обнови съгласуването',
    'amount_cannot_be_zero'                     => 'Сумата не може да е нула',
    'end_of_reconcile_period'                   => 'Край на периода на съгласуване: :period',
    'start_of_reconcile_period'                 => 'Начало на периода на съгласуване: :period',
    'start_balance'                             => 'Начално салдо',
    'end_balance'                               => 'Крайно салдо',
    'update_balance_dates_instruction'          => 'Съпоставете сумите и датите по-горе с банковото си извлечение и натиснете „Започнете съгласуване“',
    'select_transactions_instruction'           => 'Изберете транзакциите, които се виждат в банковото ви извлечение.',
    'select_range_and_balance'                  => 'Първо проверете периода от време и балансите. След това натиснете "Започнете съгласуване"',
    'date_change_instruction'                   => 'Ако промените периода от време сега, целия напредък ще бъде загубен.',
    'update_selection'                          => 'Обновяване на избраните',
    'store_reconcile'                           => 'Запази съгласуването',
    'reconciliation_transaction'                => 'Транзакция за съгласуване',
    'Reconciliation'                            => 'Съгласуване',
    'reconciliation'                            => 'Съгласуване',
    'reconcile_options'                         => 'Настройки за съгласуване',
    'reconcile_range'                           => 'Период за съгласуване',
    'start_reconcile'                           => 'Започнете съгласуване',
    'cash_account_type'                         => 'Касова сметка (В брой)',
    'cash'                                      => 'в брой',
    'cant_find_redirect_account'                => 'Firefly III се опита да ви пренасочи, но не успя. Съжалявам за това. Обратно към началото.',
    'account_type'                              => 'Вид на сметка',
    'save_transactions_by_moving'               => 'Запазете тази транзакция, като я преместите в друг акаунт:|Запазете тези транзакции, като ги преместите в друг акаунт:',
    'save_transactions_by_moving_js'            => 'Няма транзакции|Запазете тази транзакция, като я преместите в друг акаунт. |Запазете тези транзакции, като ги преместите в друг акаунт.',
    'stored_new_account'                        => 'Новата сметка ":name" бе запаметена!',
    'stored_new_account_js'                     => 'Нова сметка "<a href="accounts/show/{ID}">{name}</a>" запазена!',
    'updated_account'                           => 'Сметка ":name" бе обновена',
    'updated_account_js'                        => 'Актуализирана сметка "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Настройки за кредитни карти',
    'no_transactions_account'                   => 'Няма транзакции (в този период) за сметка за активи ":name".',
    'no_transactions_period'                    => 'Няма транзакции (в този период).',
    'no_data_for_chart'                         => 'Няма достатъчно информация (все още) за генериране на тази графика.',
    'select_at_least_one_account'               => 'Моля изберете поне една сметка за активи',
    'select_at_least_one_category'              => 'Моля изберете поне една категория',
    'select_at_least_one_budget'                => 'Моля изберете поне един бюджет',
    'select_at_least_one_tag'                   => 'Моля изберете поне един етикет',
    'select_at_least_one_expense'               => 'Моля изберете поне една комбинация от сметки за разходи / приходи. Ако нямате такива (списъкът е празен), този отчет не е наличен.',
    'account_default_currency'                  => 'Това ще бъде валутата по подразбиране за тази сметка.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Вашата книга в Firefly III има повече пари, отколкото вашата банка твърди, че трябва да имате. Има няколко варианта. Моля изберете какво да правите. След това натиснете „Потвърждаване на съгласуването“.',
    'reconcile_has_less'                        => 'Вашата книга в Firefly III има по-малко пари, отколкото вашата банка твърди, че трябва да имате. Има няколко варианта. Моля изберете какво да правите. След това натиснете „Потвърждаване на съгласуването“.',
    'reconcile_is_equal'                        => 'Вашата книга в Firefly III и вашите банкови извлечения съвпадат. Няма какво да се прави. Моля натиснете „Потвърждаване на съгласуването“, за да потвърдите вашите данни.',
    'create_pos_reconcile_transaction'          => 'Изчистете избраните транзакции и създайте корекция, като добавите :amount към тази сметка за активи.',
    'create_neg_reconcile_transaction'          => 'Изчистете избраните транзакции и създайте корекция, като извадите :amount от тази сметка за активи.',
    'reconcile_do_nothing'                      => 'Изчистете избраните транзакции, но не коригирайте.',
    'reconcile_go_back'                         => 'Винаги можете да редактирате или изтриете корекцията по-късно.',
    'must_be_asset_account'                     => 'Може да съгласувате само сметки за активи',
    'reconciliation_stored'                     => 'Съгласуването е запаметено',
    'reconciliation_error'                      => 'Поради грешка транзакциите бяха маркирани като съгласувани, но корекцията не е запазена: :error.',
    'reconciliation_transaction_title'          => 'Съгласуване (:from до :to)',
    'sum_of_reconciliation'                     => 'Сума на съгласуването',
    'reconcile_this_account'                    => 'Съгласувай тази сметка',
    'reconcile'                                 => 'Съгласувай',
    'show'                                      => 'Покажи',
    'confirm_reconciliation'                    => 'Потвърждаване на съгласуването',
    'submitted_start_balance'                   => 'Въведено начално салдо',
    'selected_transactions'                     => 'Избрани транзакции (:count)',
    'already_cleared_transactions'              => 'Вече приключени транзакции (:count)',
    'submitted_end_balance'                     => 'Въведено крайно салдо',
    'initial_balance_description'               => 'Първоначално салдо за ":account"',
    'liability_credit_description'              => 'Liability credit for ":account"',
    'interest_calc_'                            => 'неизвестна',
    'interest_calc_daily'                       => 'На ден',
    'interest_calc_monthly'                     => 'На месец',
    'interest_calc_yearly'                      => 'Годишно',
    'interest_calc_weekly'                      => 'Седмично',
    'interest_calc_half-year'                   => 'За половин година',
    'interest_calc_quarterly'                   => 'За тримесечие',
    'initial_balance_account'                   => 'Първоначално салдо на сметка ":account"',
    'list_options'                              => 'Списък на опциите',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Нова категория',
    'create_new_category'                       => 'Създай нова категория',
    'without_category'                          => 'Без категория',
    'update_category'                           => 'Обновяване на категория',
    'updated_category'                          => 'Обновяване на категория ":name"',
    'categories'                                => 'Категории',
    'edit_category'                             => 'Обнови категория ":name"',
    'no_category'                               => '(без категория)',
    'unknown_category_plain'                    => 'No category',
    'category'                                  => 'Категория',
    'delete_category'                           => 'Изтрий категория ":name"',
    'deleted_category'                          => 'Категория ":name" бе изтрита',
    'store_category'                            => 'Запази нова категория',
    'stored_category'                           => 'Новата категория ":name" бе запазена',
    'without_category_between'                  => 'Без категория между :start и :end',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Обнови тегленето',
    'update_deposit'                            => 'Обнови депозита',
    'update_transaction'                        => 'Обнови транзакцията',
    'update_transfer'                           => 'Обнови прехвърлянето',
    'updated_withdrawal'                        => 'Тегленето ":description" бе обновено',
    'updated_deposit'                           => 'Депозитът ":description" бе обновен',
    'updated_transfer'                          => 'Прехвърлянето ":description" бе обновено',
    'no_changes_withdrawal'                     => 'Теглене ":description" не беше променено.',
    'no_changes_deposit'                        => 'Депозит ":description" не беше променен.',
    'no_changes_transfer'                       => 'Прехвърляне ":description" не беше променено.',
    'delete_withdrawal'                         => 'Изтрий тегленето ":description"',
    'delete_deposit'                            => 'Изтрий депозита ":description"',
    'delete_transfer'                           => 'Изтрий прехвърлянето ":description"',
    'deleted_withdrawal'                        => 'Тегленето ":description" бе успешно изтрито',
    'deleted_deposit'                           => 'Депозитът ":description" бе успешно изтрит',
    'deleted_transfer'                          => 'Прехвърлянето ":description" бе успешно изтрито',
    'deleted_reconciliation'                    => 'Транзакцията за съгласуване ":description" бе успешно изтрита',
    'stored_journal'                            => 'Успешно създадена нова транзакция ":description"',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Новата ви транзакция бе успешно създадена',
    'updated_journal_no_descr'                  => 'Транзакция бе успешно обновена',
    'select_transactions'                       => 'Избери транзакции',
    'rule_group_select_transactions'            => 'Прилагайте ":title" към транзакции',
    'rule_select_transactions'                  => 'Прилагайте ":title" към транзакции',
    'stop_selection'                            => 'Спрете да избирате транзакции',
    'reconcile_selected'                        => 'Съгласувай',
    'mass_delete_journals'                      => 'Изтрийте няколко транзакции',
    'mass_edit_journals'                        => 'Обновете няколко транзакции',
    'mass_bulk_journals'                        => 'Групова редакция на няколко транзакции',
    'mass_bulk_journals_explain'                => 'Тази форма ви позволява да промените свойствата на транзакциите по-долу, в една бърза актуализация. Всички транзакции в таблицата ще се обновят, когато промените параметрите, които виждате тук.',
    'part_of_split'                             => 'Тази транзакция е част от разделена транзакция. Ако не сте избрали всички разделяния, може да завършите с промяна само на половината транзакция.',
    'bulk_set_new_values'                       => 'Използвайте полетата по-долу за да зададете нови стойности. Ако ги оставите празни, то всички ще станат празни. Също така имайте предвид, че ще бъде зададен бюджет само за тегленията.',
    'no_bulk_category'                          => 'Не обновявай категорията',
    'no_bulk_budget'                            => 'Не обновявай бюджета',
    'no_bulk_tags'                              => 'Не обновявай етикетите',
    'replace_with_these_tags'                   => 'Замести с тези етикети',
    'append_these_tags'                         => 'Допълни тези етикети',
    'mass_edit'                                 => 'Редактирай избраното самостоятелно',
    'bulk_edit'                                 => 'Редактирай избраното групово',
    'mass_delete'                               => 'Изтрий избраното',
    'cannot_edit_other_fields'                  => 'Не можете да редактирате групово други полета освен следните, защото няма място за показването им. Моля последвайте връзката и ги редактирайте едно по едно, ако трябва да редактирате тези полета.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(без бюджет)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Сметка по бюджет',
    'account_per_category'                      => 'Сметка по категория',
    'create_new_object'                         => 'Създай',
    'empty'                                     => '(празно)',
    'all_other_budgets'                         => '(всички други бюджети)',
    'all_other_accounts'                        => '(всички други сметки)',
    'expense_per_source_account'                => 'Разходи по разходна сметка',
    'expense_per_destination_account'           => 'Разходи по приходна сметка',
    'income_per_destination_account'            => 'Приходи по приходна сметка',
    'spent_in_specific_category'                => 'Похарчени в категория ":category"',
    'earned_in_specific_category'               => 'Получени в категория ":category"',
    'spent_in_specific_tag'                     => 'Похарчени с етикет ":tag"',
    'earned_in_specific_tag'                    => 'Получени с етикет ":tag"',
    'income_per_source_account'                 => 'Приходи по разходна сметка',
    'average_spending_per_destination'          => 'Среден разход по приходна сметка',
    'average_spending_per_source'               => 'Среден разход по разходна сметка',
    'average_earning_per_source'                => 'Среден приход по разходна сметка',
    'average_earning_per_destination'           => 'Среден приход по разходна сметка',
    'account_per_tag'                           => 'Сметка по етикет',
    'tag_report_expenses_listed_once'           => 'Разходите и доходите никога не са посочени два пъти. Ако транзакцията има множество етикети, тя може да се показва само под един от нейните етикети. В този списък може да изглежда че липсват данни, но сумите ще бъдат правилни.',
    'double_report_expenses_charted_once'       => 'Разходите и доходите никога не са посочени два пъти. Ако транзакцията има множество етикети, тя може да се показва само под един от нейните етикети. В тази графика може да изглежда че липсват данни, но сумите ще бъдат правилни.',
    'tag_report_chart_single_tag'               => 'Тази графика се отнася за един етикет. Ако транзакция има множество етикети, това което виждате тук, може да бъде отразено и в графиките на други етикети.',
    'tag'                                       => 'Етикет',
    'no_budget_squared'                         => '(без бюджет)',
    'perm-delete-many'                          => 'Изтриването на много елементи с едно действие може да бъде много разрушително. Моля бъдете внимателни. Възможно е да изтриете част от разделена транзакция на тази страница, така че внимавайте.',
    'mass_deleted_transactions_success'         => 'Изтрита :count транзакция.|Изтрити :count транзакции.',
    'mass_edited_transactions_success'          => 'Обновена :count транзакция.|Обновени :count транзакции.',
    'opt_group_'                                => '(без тип сметка)',
    'opt_group_no_account_type'                 => '(без тип сметка)',
    'opt_group_defaultAsset'                    => 'Сметки за активи по подразбиране',
    'opt_group_savingAsset'                     => 'Спестовни сметки',
    'opt_group_sharedAsset'                     => 'Сметки за споделени активи',
    'opt_group_ccAsset'                         => 'Кредитни карти',
    'opt_group_cashWalletAsset'                 => 'Парични портфейли',
    'opt_group_expense_account'                 => 'Сметки за разходи',
    'opt_group_revenue_account'                 => 'Сметки за приходи',
    'opt_group_l_Loan'                          => 'Задължение: Заем',
    'opt_group_cash_account'                    => 'Касова сметка',
    'opt_group_l_Debt'                          => 'Задължение: Дълг',
    'opt_group_l_Mortgage'                      => 'Задължение: Ипотека',
    'opt_group_l_Credit card'                   => 'Задължение: Кредитна карта',
    'notes'                                     => 'Бележки',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Транзакцията не можа да се запази. Моля проверете лог файловете.',
    'attachment_not_found'                      => 'Този прикачен файл не можа да бъде намерен.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Транзакция #{ID}("{title}")</a> беше записана.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Транзакция #{ID}</a> беше записана.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Транзакция #{ID}</a> ("{title}") беше обновена.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Транзакция #{ID}</a> ("{title}") не е получила промени.',
    'first_split_decides'                       => 'Първия раздел определя стойността на това поле',
    'first_split_overrules_source'              => 'Първия раздел може да отмени разходната сметка',
    'first_split_overrules_destination'         => 'Първия раздел може да отмени приходната сметка',
    'spent_x_of_y'                              => 'Похарчено е {amount} от {total}',

    // new user:
    'welcome'                                   => 'Добре дошли в Firefly III!',
    'submit'                                    => 'Потвърди',
    'submission'                                => 'Изпращане',
    'submit_yes_really'                         => 'Потвърди (знам какво правя)',
    'getting_started'                           => 'Начални стъпки',
    'to_get_started'                            => 'Хубаво е да видите, че успешно сте инсталирали Firefly III. За да започнете с този инструмент, моля въведете името на вашата банка и салдото на основната си сметка. Не се притеснявайте, ако имате няколко сметки. Можете да ги добавите по-късно. Просто Firefly III се нуждае от нещо, с което да започне.',
    'savings_balance_text'                      => 'Firefly III автоматично ще ви създаде спестовна сметка. По подразбиране няма да има пари в спестовната ви сметка, но ако кажете на Firefly III салдото, то ще се съхрани като начално.',
    'finish_up_new_user'                        => 'Това е! Можете да продължите, като натиснете <strong> Потвърди</strong>. Ще бъдете отведени до индекса на Firefly III.',
    'stored_new_accounts_new_user'              => 'Супер! Вашите нови сметки са съхранени.',
    'set_preferred_language'                    => 'Ако предпочитате да използвате Firefly III на друг език, моля посочете го тук.',
    'language'                                  => 'Език',
    'new_savings_account'                       => ':bank_name спестовна сметка',
    'cash_wallet'                               => 'Паричен портфейл',
    'currency_not_present'                      => 'Не се притеснявайте, ако валутата която обикновено използвате не е посочена. Можете да създадете свои собствени валути в Опции> Валути.',

    // home page:
    'transaction_table_description'             => 'Таблица съдържаща вашите транзакции',
    'opposing_account'                          => 'Противоположна сметка',
    'yourAccounts'                              => 'Вашите сметки',
    'your_accounts'                             => 'Общ преглед на вашата сметка',
    'category_overview'                         => 'Общ преглед на категория',
    'expense_overview'                          => 'Общ преглед на разходна сметка',
    'revenue_overview'                          => 'Общ преглед на приходна сметка',
    'budgetsAndSpending'                        => 'Бюджети и разходи',
    'budgets_and_spending'                      => 'Бюджети и разходи',
    'go_to_budget'                              => 'Отиди на бюджет "{budget}"',
    'go_to_deposits'                            => 'Отиди в депозити',
    'go_to_expenses'                            => 'Отиди в Разходи ',
    'savings'                                   => 'Спестявания',
    'newWithdrawal'                             => 'Нов разход',
    'newDeposit'                                => 'Нов депозит',
    'newTransfer'                               => 'Ново прехвърляне',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'На ден',
    'left_to_spend_per_day'                     => 'Остава за разходи на ден',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Период по избор',
    'reset_to_current'                          => 'Reset to current period',
    'select_period'                             => 'Избор на период',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Валута',
    'preferences'                               => 'Настройки',
    'logout'                                    => 'Изход',
    'logout_other_sessions'                     => 'Изход от всички други сесии',
    'toggleNavigation'                          => 'Превключване на навигацията',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Търсене...',
    'version'                                   => 'Версия',
    'dashboard'                                 => 'Основно табло',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'No budget',
    'available_budget'                          => 'Наличен бюджет ({currency})',
    'currencies'                                => 'Валути',
    'activity'                                  => 'Дейност',
    'usage'                                     => 'Използване',
    'accounts'                                  => 'Сметки',
    'Asset account'                             => 'Сметка за активи',
    'Default account'                           => 'Сметка за активи',
    'Expense account'                           => 'Сметка за разходи',
    'Revenue account'                           => 'Сметка за приходи',
    'Initial balance account'                   => 'Първоначално салдо на сметка',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Дълг',
    'account_type_Loan'                         => 'Заем',
    'account_type_Mortgage'                     => 'Ипотека',
    'account_type_debt'                         => 'Дълг',
    'account_type_loan'                         => 'Заем',
    'account_type_mortgage'                     => 'Ипотека',
    'account_type_Credit card'                  => 'Кредитна карта',
    'credit_card_type_monthlyFull'              => 'Пълно плащане всеки месец',
    'liability_direction_credit'                => 'Дължът ми този дълг',
    'liability_direction_debit'                 => 'Дължа този дълг на някого',
    'liability_direction_credit_short'          => 'Дължът ми дълг',
    'liability_direction_debit_short'           => 'Дължа дълг',
    'liability_direction__short'                => 'Неизвестно',
    'liability_direction_null_short'            => 'Неизвестно',
    'Liability credit'                          => 'Liability credit',
    'budgets'                                   => 'Бюджети',
    'tags'                                      => 'Етикети',
    'reports'                                   => 'Отчети',
    'transactions'                              => 'Транзакции',
    'expenses'                                  => 'Разходи',
    'income'                                    => 'Приходи',
    'transfers'                                 => 'Прехвърляния',
    'moneyManagement'                           => 'Управление на финансите',
    'money_management'                          => 'Управление на финансите',
    'tools'                                     => 'Инструменти',
    'piggyBanks'                                => 'Касички',
    'piggy_banks'                               => 'Касички',
    'amount_x_of_y'                             => '{current} от {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Теглене',
    'opening_balance'                           => 'Начално салдо',
    'deposit'                                   => 'Депозит',
    'account'                                   => 'Сметка',
    'transfer'                                  => 'Прехвърляне',
    'Withdrawal'                                => 'Теглене',
    'Deposit'                                   => 'Депозит',
    'Transfer'                                  => 'Прехвърляне',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Да',
    'no'                                        => 'Не',
    'amount'                                    => 'Сума',
    'overview'                                  => 'Общ преглед',
    'saveOnAccount'                             => 'Спести в сметка',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Неизвестно',
    'monthly'                                   => 'Месечно',
    'profile'                                   => 'Профил',
    'errors'                                    => 'Грешки',
    'debt_start_date'                           => 'Начална дата на дълга',
    'debt_start_amount'                         => 'Начална сума на дълга',
    'debt_start_amount_help'                    => 'Винаги е най-добре да зададете тази стойност на отрицателна сума. Прочетете страниците за помощ (горе вдясно (?) - икона) за повече информация.',
    'interest_period_help'                      => 'Това поле е чисто козметично и няма да бъде изчислено за вас. Както се оказва, банките са много подъл, така че Firefly III никога не се оправя.',
    'store_new_liabilities_account'             => 'Запамети ново задължение',
    'edit_liabilities_account'                  => 'Редактирай задължение ":name"',
    'financial_control'                         => 'Финансов контрол',
    'accounting'                                => 'Счетоводство',
    'automation'                                => 'Автоматизация',
    'others'                                    => 'Други',
    'classification'                            => 'Класификация',
    'store_transaction'                         => 'Запазете транзакция',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Финансов отчет по подразбиране между :start и :end',
    'report_audit'                              => 'Преглед на историята на транзакциите между :start и :end',
    'report_category'                           => 'Отчет по категория между :start и :end',
    'report_double'                             => 'Отчет Разходи / Сметка за приходи между :start и :end',
    'report_budget'                             => 'Отчет по бюджет между :start и :end',
    'report_tag'                                => 'Отчет по етикет между :start и :end',
    'quick_link_reports'                        => 'Бързи връзки',
    'quick_link_examples'                       => 'Това са само някои примерни връзки, за да започнете. Разгледайте страниците за помощ под бутона (?) за информация относно всички отчети и "вълшебните" думи, които можете да използвате.',
    'quick_link_default_report'                 => 'Финансов отчет по подразбиране',
    'quick_link_audit_report'                   => 'Преглед на историята на транзакциите',
    'report_this_month_quick'                   => 'Текущ месец, всички сметки',
    'report_last_month_quick'                   => 'Миналия месец, всички сметки',
    'report_this_year_quick'                    => 'Текуща година, всички сметки',
    'report_this_fiscal_year_quick'             => 'Текуща финансова година, всички сметки',
    'report_all_time_quick'                     => 'За цялото време, всички сметки',
    'reports_can_bookmark'                      => 'Не забравяйте, че на отчетите могат да бъдат поставени отметки.',
    'incomeVsExpenses'                          => 'Приход срещу разходи',
    'accountBalances'                           => 'Салда по сметки',
    'balanceStart'                              => 'Салдо в началото на периода',
    'balanceEnd'                                => 'Салдо в края на периода',
    'splitByAccount'                            => 'Раздели по сметка',
    'coveredWithTags'                           => 'Покрити с етикети',
    'leftInBudget'                              => 'Останало в бюджета',
    'left_in_debt'                              => 'Дължима сума',
    'sumOfSums'                                 => 'Сума от суми',
    'noCategory'                                => '(без категория)',
    'notCharged'                                => 'Не е таксувано (все още)',
    'inactive'                                  => 'Неактивно',
    'active'                                    => 'Активно',
    'difference'                                => 'Разлика',
    'money_flowing_in'                          => 'Входящи',
    'money_flowing_out'                         => 'Изходящи',
    'topX'                                      => 'топ :number',
    'show_full_list'                            => 'Показване на целия списък',
    'show_only_top'                             => 'Покажи само топ :number',
    'report_type'                               => 'Тип на отчета',
    'report_type_default'                       => 'Финансов отчет по подразбиране',
    'report_type_audit'                         => 'Преглед на историята на транзакциите (проверка)',
    'report_type_category'                      => 'Отчет по категория',
    'report_type_budget'                        => 'Отчет по бюджет',
    'report_type_tag'                           => 'Отчет по етикет',
    'report_type_double'                        => 'Отчет по сметка за разходи / приходи',
    'more_info_help'                            => 'Повече информация за тези видове отчети можете да намерите в помощните страници. Натиснете иконата (?) в горния десен ъгъл.',
    'report_included_accounts'                  => 'Включени сметки',
    'report_date_range'                         => 'Период',
    'report_preset_ranges'                      => 'Предварително зададени периоди',
    'shared'                                    => 'Споделени',
    'fiscal_year'                               => 'Фискална година',
    'income_entry'                              => 'Приход от сметка ":name" между :start и :end',
    'expense_entry'                             => 'Разход по сметка ":name" между :start и :end',
    'category_entry'                            => 'Разходи и приходи в категория ":name" между :start и :end',
    'budget_spent_amount'                       => 'Разходи в бюджет ":budget" между :start и :end',
    'balance_amount'                            => 'Разходи в бюджет ":budget" платени от сметка ":account" между :start и :end',
    'no_audit_activity'                         => 'Няма регистрирана активност в сметка <a href=":url" title=":account_name">:account_name</a> между :start и :end.',
    'audit_end_balance'                         => 'Салдото по сметка <a href=":url" title=":account_name">:account_name</a>в края на :end беше :balance',
    'reports_extra_options'                     => 'Допълнителни опции',
    'report_has_no_extra_options'               => 'Този отчет няма допълнителни опции',
    'reports_submit'                            => 'Виж отчета',
    'end_after_start_date'                      => 'Крайната дата на отчета трябва да бъде след началната дата.',
    'select_category'                           => 'Изберете категория(и)',
    'select_budget'                             => 'Изберете бюджет(и).',
    'select_tag'                                => 'Изберете етикет(и).',
    'income_per_category'                       => 'Приходи по категория',
    'expense_per_category'                      => 'Разходи по категория',
    'expense_per_budget'                        => 'Разходи по бюджет',
    'income_per_account'                        => 'Приходи по сметка',
    'expense_per_account'                       => 'Разходи по сметка',
    'expense_per_tag'                           => 'Разходи по етикет',
    'income_per_tag'                            => 'Приход по етикет',
    'include_expense_not_in_budget'             => 'Включени разходи, които не са в избрания(те) бюджет(и)',
    'include_expense_not_in_account'            => 'Включени разходи, които не са в избраната(ите) сметка(и)',
    'include_expense_not_in_category'           => 'Включени разходи, които не са в избраната(ите) категория(и)',
    'include_income_not_in_category'            => 'Включени приходи, които не са в избраната(ите) категория(и)',
    'include_income_not_in_account'             => 'Включени приходи, които не са в избраната(ите) сметка(и)',
    'include_income_not_in_tags'                => 'Включени приходи, които не са с избрания(те) етикет(и)',
    'include_expense_not_in_tags'               => 'Включени разходи, които не са с избрания(те) етикет(и)',
    'everything_else'                           => 'Други',
    'income_and_expenses'                       => 'Приходи и разходи',
    'spent_average'                             => 'Похарчени (средно)',
    'income_average'                            => 'Доход (средно)',
    'transaction_count'                         => 'Брой транзакции',
    'average_spending_per_account'              => 'Средни разходи по сметка',
    'average_income_per_account'                => 'Средни приходи по сметка',
    'total'                                     => 'Общо',
    'description'                               => 'Описание',
    'sum_of_period'                             => 'Сума за периода',
    'average_in_period'                         => 'Средно за периода',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Сметка за активи по подразбиране',
    'account_role_sharedAsset'                  => 'Сметка за споделени активи',
    'account_role_savingAsset'                  => 'Спестовна сметка',
    'account_role_ccAsset'                      => 'Кредитна карта',
    'account_role_cashWalletAsset'              => 'Паричен портфейл',
    'budget_chart_click'                        => 'Моля кликнете върху име на бюджет в таблицата по-горе, за да видите графика.',
    'category_chart_click'                      => 'Моля кликнете върху име на категория в таблицата по-горе, за да видите графика.',
    'in_out_accounts'                           => 'Спечелени и похарчени по комбинация',
    'in_out_accounts_per_asset'                 => 'Спечелени и похарчени (по сметка за активи)',
    'in_out_per_category'                       => 'Спечелени и похарчени по категория',
    'out_per_budget'                            => 'Похарчени по бюджет',
    'select_expense_revenue'                    => 'Изберете сметка за Разходи / Приходи',
    'multi_currency_report_sum'                 => 'Тъй като този списък съдържа сметки с няколко валути, сумата (ите) която виждате може да няма смисъл. Отчетът винаги ще се връща към вашата валута по подразбиране.',
    'sum_in_default_currency'                   => 'Сумата винаги ще бъде във вашата валута по подразбиране.',
    'net_filtered_prefs'                        => 'Тази графика никога няма да включва сметки, при които в опцията „Включи в нетната стойност“ не е поставена отметка.',


    // charts:
    'chart'                                     => 'Графика',
    'month'                                     => 'Месец',
    'budget'                                    => 'Бюджет',
    'spent'                                     => 'Похарчени',
    'spent_capped'                              => 'Похарчени (ограничени)',
    'spent_in_budget'                           => 'Похарчени в бюджет',
    'left_to_spend'                             => 'Останали за харчене',
    'earned'                                    => 'Спечелени',
    'overspent'                                 => 'Преразход',
    'left'                                      => 'Останали',
    'max-amount'                                => 'Максимална сума',
    'min-amount'                                => 'Минимална сума',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Име',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Дата',
    'date_and_time'                             => 'Дата и час',
    'time'                                      => 'Време',
    'paid'                                      => 'Платени',
    'unpaid'                                    => 'Неплатени',
    'day'                                       => 'Ден',
    'budgeted'                                  => 'Бюджетирани',
    'period'                                    => 'Период',
    'balance'                                   => 'Салдо',
    'in_out_period'                             => 'In + out this period',
    'sum'                                       => 'Сума',
    'summary'                                   => 'Обобщение',
    'average'                                   => 'Средно',
    'balanceFor'                                => 'Салдо за :name',
    'no_tags'                                   => '(без етикети)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Event history',
    'add_money_to_piggy'            => 'Добавете пари към касичка ":name"',
    'piggy_bank'                    => 'Касичка',
    'new_piggy_bank'                => 'Нова касичка',
    'store_piggy_bank'              => 'Запази новата касичка',
    'stored_piggy_bank'             => 'Запази новата касичка ":name"',
    'account_status'                => 'Състояние на сметка',
    'left_for_piggy_banks'          => 'Остава за касичките',
    'sum_of_piggy_banks'            => 'Сума на касичките',
    'saved_so_far'                  => 'Спестени до сега',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Остава да се спестят',
    'suggested_amount'              => 'Предложена месечна сума за спестяване',
    'add_money_to_piggy_title'      => 'Добавете пари към касичка ":name"',
    'remove_money_from_piggy_title' => 'Извадете пари от касичка ":name"',
    'add'                           => 'Добави',
    'no_money_for_piggy'            => 'Нямате пари да добавите в тази касичка.',
    'suggested_savings_per_month'   => 'Предложено на месец',

    'remove'                    => 'Премахни',
    'max_amount_add'            => 'Максималната сума, която можете да добавите е',
    'max_amount_remove'         => 'Максималната сума, която можете да извадите е',
    'update_piggy_button'       => 'Редактирай касичка',
    'update_piggy_title'        => 'Редактирай касичка ":name"',
    'updated_piggy_bank'        => 'Редактирана касичка ":name"',
    'details'                   => 'Подробности',
    'events'                    => 'Събития',
    'target_amount'             => 'Планирана сума',
    'start_date'                => 'Начална дата',
    'no_start_date'             => 'Няма начална дата',
    'target_date'               => 'Целева дата',
    'no_target_date'            => 'Няма целева дата',
    'table'                     => 'Таблица',
    'delete_piggy_bank'         => 'Изтрий касичка ":name"',
    'cannot_add_amount_piggy'   => 'Не можа да се добави :amount към ":name".',
    'cannot_remove_from_piggy'  => 'Не можа да се извади :amount от ":name".',
    'deleted_piggy_bank'        => 'Изтрита касичка ":name"',
    'added_amount_to_piggy'     => 'Добавени :amount към ":name"',
    'removed_amount_from_piggy' => 'Извадени :amount към ":name"',
    'piggy_events'              => 'Сродни касички',

    // tags
    'delete_tag'                => 'Изтрий етикет ":tag"',
    'deleted_tag'               => 'Изтрит етикет ":tag"',
    'new_tag'                   => 'Създай нов етикет',
    'edit_tag'                  => 'Редактирай етикет ":tag"',
    'updated_tag'               => 'Редактиран етикет ":tag"',
    'created_tag'               => 'Етикет ":tag" беше създаден!',

    'transaction_journal_information'               => 'Информация за транзакция',
    'transaction_journal_amount'                    => 'Amount information',
    'transaction_journal_meta'                      => 'Мета информация',
    'transaction_journal_more'                      => 'Повече информация',
    'basic_journal_information'                     => 'Основна информация за транзакция',
    'transaction_journal_extra'                     => 'Допълнителна информация',
    'att_part_of_journal'                           => 'Запазено като ":journal"',
    'total_amount'                                  => 'Обща сума',
    'number_of_decimals'                            => 'Брой десетични знаци',


    // administration
    'invite_is_already_redeemed'                    => 'The invite to ":address" has already been redeemed.',
    'invite_is_deleted'                             => 'The invite to ":address" has been deleted.',
    'invite_new_user_title'                         => 'Invite new user',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Email address',
    'invite_user'                                   => 'Invite user',
    'user_is_invited'                               => 'Email address ":address" was invited to Firefly III',
    'administration'                                => 'Управление',
    'system_settings'                               => 'System settings',
    'code_already_used'                             => 'Invite code has been used',
    'user_administration'                           => 'Управление на потребители',
    'list_all_users'                                => 'Всички потребители',
    'all_users'                                     => 'Всички потребители',
    'instance_configuration'                        => 'Конфигурация',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'setting_single_user_mode'                      => 'Режим за един потребител',
    'setting_single_user_mode_explain'              => 'По подразбиране Firefly III приема само една (1) регистрация: Вие. Това е мярка за сигурност предотвратяваща други да използват вашата инсталация, освен ако не им разрешите. Бъдещите регистрации са блокирани. Когато премахнете отметката от това поле и други ще могат да използват вашия инсталация, ако приемем че могат да я достигнат (когато е свързана с Интернет).',
    'store_configuration'                           => 'Запази конфигурацията',
    'single_user_administration'                    => 'Управление на потребителя за :email',
    'edit_user'                                     => 'Редактиране на потребител :email',
    'hidden_fields_preferences'                     => 'Можете да активирате повече опции за транзакции във вашите <a href="preferences">настройки</a>.',
    'user_data_information'                         => 'Данни на потребителя',
    'user_information'                              => 'Информация за потребителя',
    'total_size'                                    => 'общ размер',
    'budget_or_budgets'                             => ':count бюджет|:count бюджети',
    'budgets_with_limits'                           => ':count бюджет с дефинирана сума|:count бюджети с дефинирани суми',
    'nr_of_rules_in_total_groups'                   => ':count_rules правило(а) и :count_groups група(и) правила',
    'tag_or_tags'                                   => ':count етикет|:count етикети',
    'configuration_updated'                         => 'Настройките са обновени',
    'setting_is_demo_site'                          => 'Демо страница',
    'setting_is_demo_site_explain'                  => 'Ако поставите отметка в това поле, тази инсталация ще се държи така, сякаш това е демонстрационният сайт, което може да има странни странични ефекти.',
    'block_code_bounced'                            => 'Имейл съобщение(я) отскочиха',
    'block_code_expired'                            => 'Демо профилът изтече',
    'no_block_code'                                 => 'Няма причина за блокиране или потребителят не е блокиран',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'Потребителят все още не е потвърдил новия имейл адрес',
    'admin_update_email'                            => 'Противно на страницата на потребителския профил, потребителят НЯМА да бъде уведомен, че имейл адресът им е променен!',
    'update_user'                                   => 'Редактиране на потребител',
    'updated_user'                                  => 'Данните на потребителя бяха променени.',
    'delete_user'                                   => 'Изтрий потребител :email',
    'user_deleted'                                  => 'Този потребител беше изтрит',
    'send_test_email'                               => 'Изпращане на тестово имейл съобщение',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Изпрати съобщение',
    'send_test_triggered'                           => 'Тестът се задейства. Проверете входящата си поща и лог файловете.',
    'give_admin_careful'                            => 'Потребителите, на които са предоставени администраторски права, могат да отнемат вашите права. Бъдете внимателен.',
    'admin_maintanance_title'                       => 'Поддръжка',
    'admin_maintanance_expl'                        => 'Няколко изящни бутона за поддръжка на Firefly III',
    'admin_maintenance_clear_cache'                 => 'Изчисти кеша',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'All invited users',
    'save_notification_settings'                    => 'Save settings',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'The notification settings have been saved',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Описание на разделена транзакция',
    'split_transaction_title_help'          => 'Ако създадете разделена транзакция, трябва да има глобално описание за всички раздели на транзакцията.',
    'split_title_help'                      => 'Ако създадете разделена транзакция, трябва да има глобално описание за всички раздели на транзакцията.',
    'you_create_transfer'                   => 'Създавате прехвърляне.',
    'you_create_withdrawal'                 => 'Създавате теглене.',
    'you_create_deposit'                    => 'Създавате депозит.',

    // links
    'journal_link_configuration'            => 'Конфигурация на връзки за транзакции',
    'create_new_link_type'                  => 'Създаване на нов тип връзка',
    'store_new_link_type'                   => 'Запамети нов тип връзка',
    'update_link_type'                      => 'Редактирай тип връзка',
    'edit_link_type'                        => 'Редактирай тип връзка ":name"',
    'updated_link_type'                     => 'Редактирана тип връзка ":name"',
    'delete_link_type'                      => 'Изтрий тип връзка ":name"',
    'deleted_link_type'                     => 'Изтрита тип връзка ":name"',
    'stored_new_link_type'                  => 'Запамети нов тип връзка ":name"',
    'cannot_edit_link_type'                 => 'Невъзможна редакцията на тип връзка ":name"',
    'link_type_help_name'                   => 'Т.е. "Дубликати"',
    'link_type_help_inward'                 => 'Т.е. "дубликати"',
    'link_type_help_outward'                => 'Т.е. "е дублирана от"',
    'save_connections_by_moving'            => 'Запишете връзката между тези транзакции, като ги преместите в друг тип връзка:',
    'do_not_save_connection'                => '(не запазвайте връзката)',
    'link_transaction'                      => 'Свържи транзакция',
    'link_to_other_transaction'             => 'Свържете тази транзакция с друга транзакция',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Тази транзакция',
    'transaction'                           => 'Транзакция',
    'comments'                              => 'Коментари',
    'link_notes'                            => 'Бележки, които искате да запазите с връзката.',
    'invalid_link_selection'                => 'Тези транзакции не могат да се свържат',
    'selected_transaction'                  => 'Избрани транзакции',
    'journals_linked'                       => 'Транзакциите са свързани.',
    'journals_error_linked'                 => 'Тези транзакции са вече свързани.',
    'journals_link_to_self'                 => 'Не може да свържете транзакция към самата нея',
    'journal_links'                         => 'Връзки на транзакция',
    'this_withdrawal'                       => 'Това теглене',
    'this_deposit'                          => 'Този депозит',
    'this_transfer'                         => 'Това прехвърляне',
    'overview_for_link'                     => 'Общ преглед за тип връзка ":name"',
    'source_transaction'                    => 'Източник транзакция',
    'link_description'                      => 'Описание на връзка',
    'destination_transaction'               => 'Дестинация на транзакция',
    'delete_journal_link'                   => 'Изтрий връзката между <a href=":source_link">:source</a> и <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Изтрита връзка',

    // link translations:
    'Paid_name'                             => 'Платени',
    'Refund_name'                           => 'Кеш бек',
    'Reimbursement_name'                    => 'Възстановяване',
    'Related_name'                          => 'Сродни',
    'relates to_inward'                     => 'свързано с',
    'is (partially) refunded by_inward'     => 'е (частично) възстановено от',
    'is (partially) paid for by_inward'     => 'е (частично) платено от',
    'is (partially) reimbursed by_inward'   => 'е (частично) възстановено от',
    'inward_transaction'                    => 'Входяща транзакция',
    'outward_transaction'                   => 'Изходяща транзакция',
    'relates to_outward'                    => 'свързано с',
    '(partially) refunds_outward'           => '(частично) възстановява',
    '(partially) pays for_outward'          => '(частично) плаща за',
    '(partially) reimburses_outward'        => '(частично) възстановява',
    'is (partially) refunded by'            => 'е (частично) възстановено от',
    'is (partially) paid for by'            => 'е (частично) платено от',
    'is (partially) reimbursed by'          => 'е (частично) възстановено от',
    'relates to'                            => 'свързано с',
    '(partially) refunds'                   => '(частично) възстановява',
    '(partially) pays for'                  => '(частично) плаща за',
    '(partially) reimburses'                => '(частично) възстановява',

    // split a transaction:
    'splits'                                => 'Раздели',
    'add_another_split'                     => 'Добавяне на друг раздел',
    'cannot_edit_opening_balance'           => 'Не можете да редактирате началния баланс на сметката.',
    'no_edit_multiple_left'                 => 'Не сте избрали валидни транзакции, които да редактирате.',
    'breadcrumb_convert_group'              => 'Преобразувай транзакция',
    'convert_invalid_source'                => 'Информацията за източника е невалидна за транзакция #%d.',
    'convert_invalid_destination'           => 'Информацията за дестинацията е невалидна за транзакция #%d.',
    'create_another'                        => 'След съхраняването се върнете тук, за да създадете нова.',
    'after_update_create_another'           => 'След обновяването се върнете тук, за да продължите с редакцията.',
    'store_as_new'                          => 'Съхранете като нова транзакция, вместо да я актуализирате.',
    'reset_after'                           => 'Изчистване на формуляра след изпращане',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Разшири раздел',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Свий раздел',

    // object groups
    'default_group_title_name'              => '(без група)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Нека да създадем сметка за активи!',
    'no_accounts_intro_asset'               => 'Все още нямате сметки за активи. Сметките за активи са вашите основни сметки: вашата разплащателна сметка, спестовна сметка, споделена сметка или дори вашата кредитна карта.',
    'no_accounts_imperative_asset'          => 'За да започнете да използвате Firefly III, трябва да създадете поне една сметка за активи. Нека го направим сега:',
    'no_accounts_create_asset'              => 'Създай сметка за активи',
    'no_accounts_title_expense'             => 'Нека да създадем сметка за разходи!',
    'no_accounts_intro_expense'             => 'Все още нямате сметки за разходи. Сметките за разходи са местата, където харчите пари, като магазини и супермаркети.',
    'no_accounts_imperative_expense'        => 'Сметките за разходи се създават автоматично, когато създавате транзакции, но можете да създадете и ръчно, ако искате. Нека сега създадем такава:',
    'no_accounts_create_expense'            => 'Създай сметка за разходи',
    'no_accounts_title_revenue'             => 'Нека да създадем сметка за приходи!',
    'no_accounts_intro_revenue'             => 'Все още нямате сметки за приходи. Приходните сметки са местата, от които получавате пари, например от вашия работодател.',
    'no_accounts_imperative_revenue'        => 'Приходните сметки се създават автоматично, когато създавате транзакции, но можете да създадете и ръчно, ако искате. Нека сега създадем такава:',
    'no_accounts_create_revenue'            => 'Създай сметка за приходи',
    'no_accounts_title_liabilities'         => 'Нека да създадем задължение!',
    'no_accounts_intro_liabilities'         => 'Все още нямате задължения. Задължения са сметките, които регистрират вашите (студентски) заеми и други дългове.',
    'no_accounts_imperative_liabilities'    => 'Не е необходимо да използвате тази функция, но тя може да бъде полезна, ако искате да следите тези неща.',
    'no_accounts_create_liabilities'        => 'Създай задължение',
    'no_budgets_title_default'              => 'Нека да създадем бюджет',
    'no_rules_title_default'                => 'Нека да създадем правило',
    'no_budgets_intro_default'              => 'Все още нямате бюджети. Бюджетите се използват за организиране на разходите ви в логически групи, на които можете да дадете лимит, за да ограничите разходите си.',
    'no_rules_intro_default'                => 'Все още нямаш правила. Правилата са силни автоматизации, които могат да управляват транзации за теб.',
    'no_rules_imperative_default'           => 'Правилата могат да бъдат много полезни, когато управляваш транзакции. Нека да създадем едно сега:',
    'no_budgets_imperative_default'         => 'Бюджетите са основните инструменти на финансовото управление. Нека сега създадем такъв:',
    'no_budgets_create_default'             => 'Създай бюджет',
    'no_rules_create_default'               => 'Създай правило',
    'no_categories_title_default'           => 'Нека да създадем категория!',
    'no_categories_intro_default'           => 'Все още нямате категории. Категориите се използват за фина настройка на вашите транзакции и етикетиране с тяхната определена категория.',
    'no_categories_imperative_default'      => 'Категориите се създават автоматично, когато създавате транзакции, но можете да създадете и ръчно. Нека сега създадем такава:',
    'no_categories_create_default'          => 'Създай категория',
    'no_tags_title_default'                 => 'Нека да създадем етикет!',
    'no_tags_intro_default'                 => 'Все още нямате етикети. Етикетите се използват за фина настройка на вашите транзакции и маркирането им с конкретни ключови думи.',
    'no_tags_imperative_default'            => 'Етикетите се създават автоматично, когато създавате транзакции, но можете да създадете и ръчно. Нека сега създадем такъв:',
    'no_tags_create_default'                => 'Създай етикет',
    'no_transactions_title_withdrawal'      => 'Нека да създадем разход!',
    'no_transactions_intro_withdrawal'      => 'Все още нямате разходи. Трябва да създадете разходи, за да започнете да управлявате финансите си.',
    'no_transactions_imperative_withdrawal' => 'Похарчихте ли някакви пари? След това трябва да го запишете:',
    'no_transactions_create_withdrawal'     => 'Създай разход',
    'no_transactions_title_deposit'         => 'Нека да създадем приход!',
    'no_transactions_intro_deposit'         => 'Все още нямате записан доход. Трябва да създадете записи за доходи, за да започнете да управлявате финансите си.',
    'no_transactions_imperative_deposit'    => 'Получихте ли някакви пари? След това трябва да го запишете:',
    'no_transactions_create_deposit'        => 'Създай депозит',
    'no_transactions_title_transfers'       => 'Нека да създадем прехвърляне!',
    'no_transactions_intro_transfers'       => 'Все още нямате прехвърляния. Когато премествате пари между сметки за активи те се записват като прехвърляния.',
    'no_transactions_imperative_transfers'  => 'Преместихте ли някакви пари? След това трябва да го запишете:',
    'no_transactions_create_transfers'      => 'Създай прехвърляне',
    'no_piggies_title_default'              => 'Нека да създадем касичка!',
    'no_piggies_intro_default'              => 'Все още нямате касички. Можете да създадете касички, за да разделите спестяванията си и да следите за какво спестявате.',
    'no_piggies_imperative_default'         => 'Имате ли неща, за които спестявате пари? Създайте касичка и следете:',
    'no_piggies_create_default'             => 'Създай нова касичка',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Create right now',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Повтарящи се транзакции',
    'repeat_until_in_past'                  => 'Тази повтаряща се транзакция спря да се повтаря на :date.',
    'recurring_calendar_view'               => 'Календар',
    'no_recurring_title_default'            => 'Нека да създадем повтаряща се транзакция!',
    'no_recurring_intro_default'            => 'Все още нямате повтарящи се транзакции. Можете да ги използвате, за да накарате Firefly III автоматично да създава транзакции за вас.',
    'no_recurring_imperative_default'       => 'Това е доста сложна функция, но може да бъде изключително полезна. Уверете се, че сте прочели документацията (?) - иконата в горния десен ъгъл), преди да продължите.',
    'no_recurring_create_default'           => 'Създай повтаряща се транзакция',
    'make_new_recurring'                    => 'Създай повтаряща се транзакция',
    'recurring_daily'                       => 'Всеки ден',
    'recurring_weekly'                      => 'Всяка седмица в :weekday',
    'recurring_weekly_skip'                 => 'Всяка :skip (-ва/-ра/-та) седмица в :weekday',
    'recurring_monthly'                     => 'Всеки месец на :dayOfMonth -ия ден',
    'recurring_monthly_skip'                => 'Всеки :skip (-ви/-ри/-ти) месец на :dayOfMonth -ия ден',
    'recurring_ndom'                        => 'Всеки месец на :dayOfMonth :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Всяка година на :date',
    'overview_for_recurrence'               => 'Общ преглед на повтаряща се транзакция ":title"',
    'warning_duplicates_repetitions'        => 'В редки случаи датите се появяват два пъти в този списък. Това може да се случи, когато множество повторения се сблъскат. Firefly III винаги ще генерира по една транзакция на ден.',
    'created_transactions'                  => 'Сродни транзакции',
    'expected_withdrawals'                  => 'Очаквани тегления',
    'expected_deposits'                     => 'Очаквани депозити',
    'expected_transfers'                    => 'Очаквани прехвърляния',
    'created_withdrawals'                   => 'Създадени тегления',
    'created_deposits'                      => 'Създадени депозити',
    'created_transfers'                     => 'Създадени прехвърляния',
    'recurring_info'                        => 'Повтарящи се транзакции :count / :total',
    'created_from_recurrence'               => 'Създадено от повтаряща се транзакция ":title" (#:id)',
    'recurring_never_cron'                  => 'Изглежда, че задачата на cron, която е необходима за поддържане на повтарящи се транзакции, никога не се е изпълнявала. Това, разбира се, е нормално, когато току-що сте инсталирали Firefly III, но това трябва да е нещо, което да настроите възможно най-скоро. Моля, разгледайте помощните страници, като използвате иконата (?) в горния десен ъгъл на страницата.',
    'recurring_cron_long_ago'               => 'Изглежда, че са минали повече от 36 часа, откакто задачата на cron за поддръжка на повтарящи се транзакции е задействана за последен път. Сигурни ли сте, че е настроена правилно? Моля, разгледайте помощните страници, като използвате иконата (?) в горния десен ъгъл на страницата.',

    'create_new_recurrence'              => 'Създай нова повтаряща се транзакция',
    'help_first_date'                    => 'Посочете първото очаквано повторение. Това трябва да бъде в бъдещето.',
    'help_first_date_no_past'            => 'Посочете първото очаквано повторение. Firefly III няма да създава транзакции в миналото.',
    'no_currency'                        => '(без валута)',
    'mandatory_for_recurring'            => 'Задължителна информация за повторение',
    'mandatory_for_transaction'          => 'Задължителна информация за транзакция',
    'optional_for_recurring'             => 'Незадължителна информация за повторение',
    'optional_for_transaction'           => 'Незадължителна информация за транзакция',
    'change_date_other_options'          => 'Променете "първа дата", за да видите още опции.',
    'mandatory_fields_for_tranaction'    => 'Стойностите тук ще влязат в създадената транзакция (и)',
    'click_for_calendar'                 => 'Кликнете тук за календар, който ви показва кога транзакцията ще се повтори.',
    'repeat_forever'                     => 'Повтаряй завинаги',
    'repeat_until_date'                  => 'Повтаряй до дата',
    'repeat_times'                       => 'Повтаряй определен брой пъти',
    'recurring_skips_one'                => 'През едно',
    'recurring_skips_more'               => 'Пропусни :count събития',
    'store_new_recurrence'               => 'Запамети повтаряща се транзакция',
    'stored_new_recurrence'              => 'Повтаряща се транзакция ":title" беше успешно запаметена.',
    'edit_recurrence'                    => 'Редактирай повтаряща се транзакция ":title"',
    'recurring_repeats_until'            => 'Повтаряй до :date',
    'recurring_repeats_forever'          => 'Повтаря се завинаги',
    'recurring_repeats_x_times'          => 'Повтаря се :count път|Повтаря се :count пъти',
    'update_recurrence'                  => 'Обнови повтарящата се транзакция',
    'updated_recurrence'                 => 'Обновена е повтарящата се транзакция ":title"',
    'recurrence_is_inactive'             => 'Тази повтаряща се транзакция не е активна и няма да генерира нови транзакции.',
    'delete_recurring'                   => 'Изтрий повтаряща се транзакция ":title"',
    'new_recurring_transaction'          => 'Нова повтаряща се транзакция',
    'help_weekend'                       => 'Какво трябва да направи Firefly III, когато повтарящата се транзакция се падне в събота или неделя?',
    'do_nothing'                         => 'Просто създай транзакцията',
    'skip_transaction'                   => 'Пропусни транзакцията',
    'jump_to_friday'                     => 'Създай транзакцията на предишния петък',
    'jump_to_monday'                     => 'Създай транзакцията на следващия понеделник',
    'will_jump_friday'                   => 'Ще бъде създадена в петък вместо уикендите.',
    'will_jump_monday'                   => 'Ще бъде създадена в понеделник вместо уикендите.',
    'except_weekends'                    => 'Освен уикендите',
    'recurrence_deleted'                 => 'Повтарящата се транзакция ":title" беше изтрита',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Баланс (:currency)',
    'box_spent_in_currency'              => 'Похарчени (:currency)',
    'box_earned_in_currency'             => 'Спечелени (:currency)',
    'box_budgeted_in_currency'           => 'Бюджетирани (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Останали за харчене (:currency)',
    'box_net_worth_in_currency'          => 'Общо богатство (:currency)',
    'box_spend_per_day'                  => 'Останали за харчене на ден: :amount',

    // debug page
    'debug_page'                         => 'Страница за отстраняване на грешки',
    'debug_submit_instructions'          => 'Ако имате проблеми, можете да използвате информацията в това поле като информация за отстраняване на грешки. Моля, копирайте и поставете в нов или съществуващ <a href="https://github.com/firefly-iii/firefly-iii/issues"> GitHub issue </a>. Той ще генерира красива таблица, която може да се използва за бързо диагностициране на проблема ви.',
    'debug_pretty_table'                 => 'Ако копирате / поставите полето по-долу в GitHub issue, той ще генерира таблица. Моля, не обграждайте този текст със кавички.',
    'debug_additional_data'              => 'Можете също да споделите съдържанието на полето по-долу. Можете също да копирате и поставите това в нов или съществуващ <a href="https://github.com/firefly-iii/firefly-iii/issues"> GitHub issue </a>. Съдържанието на това поле обаче може да съдържа лична информация като имена на сметки, данни за транзакции или имейл адреси.',

    // object groups
    'object_groups_menu_bar'             => 'Групи',
    'object_groups_page_title'           => 'Групи',
    'object_groups_breadcrumb'           => 'Групи',
    'object_groups_index'                => 'Общ преглед',
    'object_groups'                      => 'Групи',
    'object_groups_empty_explain'        => 'Някои неща в Firefly III могат да бъдат разделени на групи. Касичките например разполагат с поле „Група“ в екраните за редактиране и създаване. Когато зададете това поле, можете да редактирате имената и реда на групите на тази страница. За повече информация вижте помощните страници в горния десен ъгъл, под иконата (?).',
    'object_group_title'                 => 'Заглавие',
    'edit_object_group'                  => 'Редактирай група ":title"',
    'delete_object_group'                => 'Изтрий група ":title"',
    'update_object_group'                => 'Обнови група',
    'updated_object_group'               => 'Успешно обновена група ":title"',
    'deleted_object_group'               => 'Успешно изтрита група ":title"',
    'object_group'                       => 'Група',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'Added :amount to piggy bank ":name"',
    'ale_action_log_remove'              => 'Removed :amount from piggy bank ":name"',
    'ale_action_clear_budget'            => 'Removed from budget',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Removed from category',
    'ale_action_clear_notes'             => 'Removed notes',
    'ale_action_clear_tag'               => 'Cleared tag',
    'ale_action_clear_all_tags'          => 'Cleared all tags',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Set budget',
    'ale_action_set_category'            => 'Set category',
    'ale_action_set_source'              => 'Set source account',
    'ale_action_set_destination'         => 'Set destination account',
    'ale_action_update_transaction_type' => 'Changed transaction type',
    'ale_action_update_notes'            => 'Changed notes',
    'ale_action_update_description'      => 'Changed description',
    'ale_action_add_to_piggy'            => 'Piggy bank',
    'ale_action_remove_from_piggy'       => 'Piggy bank',
    'ale_action_add_tag'                 => 'Added tag',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Enable currency conversion',
    'disable_auto_convert'               => 'Disable currency conversion',
];
