<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Fechar',
    'actions'                                   => 'Ações',
    'edit'                                      => 'Editar',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Eliminar',
    'split'                                     => 'Dividir',
    'single_split'                              => 'Divisão',
    'clone'                                     => 'Duplicar',
    'clone_and_edit'                            => 'Clonar e editar',
    'confirm_action'                            => 'Confirmar ação',
    'last_seven_days'                           => 'Últimos sete dias',
    'last_thirty_days'                          => 'Últimos trinta dias',
    'last_180_days'                             => 'Últimos 180 dias',
    'month_to_date'                             => 'Mês corrente',
    'year_to_date'                              => 'Ano corrente',
    'YTD'                                       => 'Ano corrente',
    'welcome_back'                              => 'Painel de controlo',
    'main_dashboard_page_title'                 => 'Home',
    'everything'                                => 'Tudo',
    'today'                                     => 'hoje',
    'customRange'                               => 'Intervalo personalizado',
    'date_range'                                => 'Intervalo de datas',
    'apply'                                     => 'Aplicar',
    'select_date'                               => 'Selecionar data..',
    'cancel'                                    => 'Cancelar',
    'from'                                      => 'De',
    'to'                                        => 'Até',
    'structure'                                 => 'Estrutura',
    'help_translating'                          => 'Este texto de ajuda ainda não esta disponível na tua língua. <a href="https://crowdin.com/project/firefly-iii-help">Queres ajudar a traduzir?</a>',
    'showEverything'                            => 'Mostrar tudo',
    'never'                                     => 'Nunca',
    'no_results_for_empty_search'               => 'A sua pesquisa estava vazia, nada foi encontrado.',
    'removed_amount'                            => 'Removido :amount',
    'added_amount'                              => 'Adicionado :amount',
    'asset_account_role_help'                   => 'Quaisquer opções extras resultantes da sua escolha podem ser definidas mais tarde.',
    'Opening balance'                           => 'Saldo inicial',
    'create_new_stuff'                          => 'Criar novo',
    'new_withdrawal'                            => 'Novo levantamento',
    'create_new_transaction'                    => 'Criar uma nova transação',
    'sidebar_frontpage_create'                  => 'Criar',
    'new_transaction'                           => 'Nova transação',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Ver as contas de ativos',
    'go_to_budgets'                             => 'Ir para os seus orçamentos',
    'go_to_withdrawals'                         => 'Ir para os seus levantamentos',
    'clones_journal_x'                          => 'Esta transação é uma cópia de ":description" (#:id)',
    'go_to_categories'                          => 'Ir para categorias',
    'go_to_bills'                               => 'Go to your subscriptions',
    'go_to_expense_accounts'                    => 'Ver as contas de despesa',
    'go_to_revenue_accounts'                    => 'Ver as contas de receitas',
    'go_to_piggies'                             => 'Ir para mealheiros',
    'new_deposit'                               => 'Novo depósito',
    'new_transfer'                              => 'Nova transferência',
    'new_transfers'                             => 'Nova transferência',
    'new_asset_account'                         => 'Nova conta de ativos',
    'new_expense_account'                       => 'Nova conta de gastos',
    'new_revenue_account'                       => 'Nova conta de receitas',
    'new_liabilities_account'                   => 'Novo passivo',
    'new_budget'                                => 'Novo orçamento',
    'new_bill'                                  => 'New subscription',
    'block_account_logout'                      => 'A sua sessão foi terminada. Contas bloqueadas não podem utilizar este site. Já se registou com um email válido?',
    'flash_success'                             => 'Sucesso!',
    'flash_info'                                => 'Mensagem',
    'flash_warning'                             => 'Aviso!',
    'flash_error'                               => 'Erro!',
    'flash_danger'                              => 'Perigo!',
    'flash_info_multiple'                       => 'Tem uma mensagem|Tem :count mensagens',
    'flash_error_multiple'                      => 'Há um erro|Há :count erros',
    'net_worth'                                 => 'Posição global',
    'help_for_this_page'                        => 'Ajuda para esta página',
    'help_for_this_page_body'                   => 'Pode encontrar mais informações sobre esta página <a href="https://docs.firefly-iii.org/">na documentação</a>.',
    'two_factor_welcome'                        => 'Olá!',
    'two_factor_enter_code'                     => 'Para continuar, por favor introduza o código da sua autenticação de 2 passos. A sua aplicação pode gerá-lo para si.',
    'two_factor_code_here'                      => 'Introduza o código aqui',
    'two_factor_title'                          => 'Autenticação de 2 passos',
    'authenticate'                              => 'Autenticar',
    'two_factor_forgot_title'                   => 'Perda da autenticação 2 passos',
    'two_factor_forgot'                         => 'Esqueci-me da minha cena de 2 passos.',
    'two_factor_lost_header'                    => 'Perdeu a sua autenticação de 2 passos?',
    'two_factor_lost_intro'                     => 'Se também perdeu os códigos de backup, está com azar. Não é algo que se possa resolver pela interface web. Têm duas alternativas.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'Caso contrario, envie um email ao dono da plataforma, <a href="mailto::site_owner">:site_owner</a> e peça-lhe para reiniciar a sua autenticação de 2 passos.',
    'mfa_backup_code'                           => 'Utilizou um código de backup para aceder ao Firefly III. Esse código não pode ser utilizado novamente, é melhor riscá-lo da sua lista.',
    'pref_two_factor_new_backup_codes'          => 'Obter novos códigos de backup',
    'pref_two_factor_backup_code_count'         => 'Tem :count código de backup válido.|Tem :count códigos de backup válidos.',
    '2fa_i_have_them'                           => 'Guardei-os!',
    'warning_much_data'                         => ':days dias de dados podem demorar a carregar.',
    'registered'                                => 'Registou-se com sucesso!',
    'Default asset account'                     => 'Conta de ativos principal',
    'no_budget_pointer'                         => 'Parece que ainda não tem orçamentos. Pode criá-los na página de <a href="budgets">orçamentos</a>. Os orçamentos podem ajudá-lo a controlar as despesas.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Conta poupança',
    'Credit card'                               => 'Cartão de crédito',
    'source_accounts'                           => 'Conta de origem|Contas de origem',
    'destination_accounts'                      => 'Conta de destino|Contas de destino',
    'user_id_is'                                => 'O seu id de utilizador: <strong>:user</strong>',
    'field_supports_markdown'                   => 'Este campo suporta <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Se precisar de mais ajuda para usar o Firefly III, por favor <a href="https://github.com/firefly-iii/firefly-iii/issues">abra um ticket no Github</a>.',
    'reenable_intro_text'                       => 'Também pode reativar <a href="#" id="reenableGuidance">o guia de introdução</a>.',
    'intro_boxes_after_refresh'                 => 'Os tutoriais de introdução vão aparecer quando atualizar a página.',
    'show_all_no_filter'                        => 'Mostrar todas as transações sem as agrupar por data.',
    'expenses_by_category'                      => 'Despesas por categoria',
    'expenses_by_budget'                        => 'Despesas por orçamento',
    'income_by_category'                        => 'Receitas por categoria',
    'expenses_by_asset_account'                 => 'Despesas por conta de ativos',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'O Firefly III não consegue redirecioná-lo para a página correta. Lamentamos.',
    'sum_of_expenses'                           => 'Soma das despesas',
    'sum_of_income'                             => 'Soma das receitas',
    'liabilities'                               => 'Passivos',
    'spent_in_specific_budget'                  => 'Gasto no orçamento ":budget"',
    'spent_in_specific_double'                  => 'Gasto na conta ":account"',
    'earned_in_specific_double'                 => 'Ganho na conta ":account"',
    'source_account'                            => 'Conta de origem',
    'source_account_reconciliation'             => 'Não pode editar a conta de origem de uma transação de reconciliação.',
    'destination_account'                       => 'Conta de destino',
    'destination_account_reconciliation'        => 'Não pode editar a conta de destino de uma transação de reconciliação.',
    'sum_of_expenses_in_budget'                 => 'Total gasto no orçamento ":budget"',
    'left_in_budget_limit'                      => 'Restante para gastar com base no orçamentado',
    'current_period'                            => 'Período atual',
    'show_the_current_period_and_overview'      => 'Mostrar o período atual e a visão geral',
    'pref_languages_locale'                     => 'Para que um idioma diferente do inglês funcione corretamente, o sistema operativo deve utilizar as definições locais corretas. Se eles não estiverem presentes, dados de moeda, datas e valores podem estar formatados incorretamente.',
    'budget_in_period'                          => 'Todas as transações para o orçamento ":name" entre :start e :end em :currency',
    'chart_budget_in_period'                    => 'Gráfico para todas as transações do orçamento ":name" entre :start e :end em :currency',
    'chart_budget_in_period_only_currency'      => 'O valor orçamentado foi em :currency, por isso o gráfico apenas irá mostrar transações em :currency.',
    'chart_account_in_period'                   => 'Gráfico para todas as transações da conta ":name" (:balance) entre :start e :end',
    'chart_category_in_period'                  => 'Gráfico para todas as transações da categoria ":name" entre :start e :end',
    'chart_category_all'                        => 'Gráfico para todas as transações da categoria ":name"',
    'clone_withdrawal'                          => 'Clonar este levantamento',
    'clone_deposit'                             => 'Clonar este depósito',
    'clone_transfer'                            => 'Clonar esta transferência',
    'multi_select_no_selection'                 => 'Nenhum selecionado',
    'multi_select_select_all'                   => 'Selecionar todos',
    'multi_select_n_selected'                   => 'selecionados',
    'multi_select_all_selected'                 => 'Todos selecionados',
    'multi_select_filter_placeholder'           => 'Procurar..',
    'intro_next_label'                          => 'Próximo',
    'intro_prev_label'                          => 'Anterior',
    'intro_skip_label'                          => 'Ignorar',
    'intro_done_label'                          => 'Feito',
    'between_dates_breadcrumb'                  => 'Entre :start e :end',
    'all_journals_without_budget'               => 'Todas as transações sem orçamento',
    'journals_without_budget'                   => 'Transações sem orçamento',
    'all_journals_without_category'             => 'Todas as transações sem categoria',
    'journals_without_category'                 => 'Transações sem categoria',
    'all_journals_for_account'                  => 'Todas as transações para a conta :name',
    'chart_all_journals_for_account'            => 'Gráfico de todas as transações para a conta :name',
    'journals_in_period_for_account'            => 'Todas as transações da conta :name entre :start e :end',
    'journals_in_period_for_account_js'         => 'Todas as transações para a conta {title} entre {start} e {end}',
    'transferred'                               => 'Transferido',
    'all_withdrawal'                            => 'Todas as despesas',
    'all_transactions'                          => 'Todas as transações',
    'title_withdrawal_between'                  => 'Todas as despesas entre :start e :end',
    'all_deposit'                               => 'Todas as receitas',
    'title_deposit_between'                     => 'Todas as receitas entre :start e :end',
    'all_transfers'                             => 'Todas as transferências',
    'title_transfers_between'                   => 'Todas as transferências entre :start e :end',
    'all_transfer'                              => 'Todas as transferências',
    'all_journals_for_tag'                      => 'Todas as transações para a etiqueta ":tag"',
    'title_transfer_between'                    => 'Todas as transferências entre :start e :end',
    'all_journals_for_category'                 => 'Todas as transações para a categoria :name',
    'all_journals_for_budget'                   => 'Todas as transações para o orçamento :name',
    'chart_all_journals_for_budget'             => 'Gráfico de todas as transações para o orçamento :name',
    'journals_in_period_for_category'           => 'Todas as transações da categoria :name entre :start e :end',
    'journals_in_period_for_tag'                => 'Todas as transações da etiqueta :tag entre :start e :end',
    'not_available_demo_user'                   => 'A funcionalidade que tentou aceder não está disponível para utilizadores demo.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'A conta de ativos de origem "@source_name" apenas aceita transações em @source_currency. A conta de ativos de destino "@dest_name" apenas aceita transações em @dest_currency. Tem de fornecer o valor transferido corretamente em ambas as moedas.',
    'transaction_data'                          => 'Dados da transação',
    'invalid_server_configuration'              => 'Configuração de servidor inválida',
    'invalid_locale_settings'                   => 'O Firefly III não consegue formatar quantias monetárias porque o seu servidor não tem os pacotes requeridos. Há <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/"> instruções para fazer isto</a>.',
    'quickswitch'                               => 'Troca rápida',
    'sign_in_to_start'                          => 'Registe-se para iniciar sessão',
    'sign_in'                                   => 'Iniciar sessão',
    'register_new_account'                      => 'Registar nova conta',
    'forgot_my_password'                        => 'Esqueci-me da palavra-passe',
    'problems_with_input'                       => 'Existem alguns problemas com o valor introduzido.',
    'reset_password'                            => 'Redefinir a palavra-passe',
    'button_reset_password'                     => 'Redefinir a palavra-passe',
    'reset_button'                              => 'Redefinir',
    'want_to_login'                             => 'Quero iniciar sessão',
    'login_page_title'                          => 'Iniciar sessão no Firefly III',
    'register_page_title'                       => 'Registar no Firefly III',
    'forgot_pw_page_title'                      => 'Esqueceu a palavra-passe do Firefly III',
    'reset_pw_page_title'                       => 'Reiniciar a palavra-passe do Firefly III',
    'cannot_reset_demo_user'                    => 'Não pode reiniciar a palavra-passe do utilizador de demonstração.',
    'no_att_demo_user'                          => 'O utilizador demo não pode enviar anexos.',
    'button_register'                           => 'Registar',
    'authorization'                             => 'Autorização',
    'active_bills_only'                         => 'active subscription only',
    'active_bills_only_total'                   => 'all active subscriptions',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Previsão de custos diários',
    'per_period_sum_1W'                         => 'Previsão de custos semanais',
    'per_period_sum_1M'                         => 'Previsão de custos mensais',
    'per_period_sum_3M'                         => 'Custos trimestrais esperados',
    'per_period_sum_6M'                         => 'Previsão de custos semestrais',
    'per_period_sum_1Y'                         => 'Previsão de custos anuais',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'total esperado',
    'reconciliation_account_name'               => ':name reconciliação (:currency)',
    'saved'                                     => 'Guardado',
    'advanced_options'                          => 'Opções avançadas',
    'advanced_options_explain'                  => 'Algumas páginas no Firefly III têm opções avançadas escondidas atrás deste botão. Esta página não tem nada sofisticado aqui, mas veja as outras!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'desabilitado',
    'no_webhook_messages'                       => 'Não existem mensagens novas',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Após criar transação',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Após atualizar transação',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Após eliminar transação',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Detalhes da transação',
    'webhook_response_ACCOUNTS'                 => 'Detalhes da conta',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspecionar',
    'create_new_webhook'                        => 'Criar um novo webhook',
    'webhooks_create_breadcrumb'                => 'Criar um novo webhook',
    'webhook_trigger_form_help'                 => 'Indicar em que evento o webhook será a acionado',
    'webhook_response_form_help'                => 'Indicar o que o webhook deve submeter para o URL.',
    'webhook_delivery_form_help'                => 'Em que formato deve o webhook entregar os dados.',
    'webhook_active_form_help'                  => 'O webhook deve ser ativado ou não será acionado.',
    'stored_new_webhook'                        => 'Webhook ":title" guardado',
    'delete_webhook'                            => 'Eliminar webhook',
    'deleted_webhook'                           => 'Apagar webhook ":title"',
    'edit_webhook'                              => 'Editar webhook ":title"',
    'updated_webhook'                           => 'Atualizado o webhook ":title"',
    'edit_webhook_js'                           => 'Editar webhook ":title"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'O webhook foi acionado na transação indicada. Por favor, aguarde que os resultados surjam.',
    'webhook_messages'                          => 'Mensagem do webhook',
    'view_message'                              => 'Ver mensagem',
    'view_attempts'                             => 'Ver tentativas falhadas',
    'message_content_title'                     => 'Conteúdo da mensagem do webhook',
    'message_content_help'                      => 'Este é o conteúdo da mensagem que foi enviada (ou se tentou enviar) usando este webhook.',
    'attempt_content_title'                     => 'Tentativas de webhook',
    'attempt_content_help'                      => 'Estas são todas as tentativas falhadas de envio desta mensagem webhook para o URL configurado. Após algum tempo, o Firefly vai deixar de tentar.',
    'no_attempts'                               => 'Não há tentativas falhadas. Isso é bom!',
    'webhook_attempt_at'                        => 'Tentativa em {moment}',
    'logs'                                      => 'Logs',
    'response'                                  => 'Respostas',
    'visit_webhook_url'                         => 'Ir para URL do webhook',
    'reset_webhook_secret'                      => 'Redefinir segredo webhook',
    'webhook_stored_link'                       => '<a href="transactions/show/{ID}">Webhook #{ID} ("{title}")</a> foi guardado.',
    'webhook_updated_link'                      => '<a href="transactions/show/{ID}">Webhook #{ID} ("{title}")</a> foi guardado.',

    // API access
    'authorization_request'                     => 'Firefly III v:version Solicitar Autorização',
    'authorization_request_intro'               => 'A aplicação "<strong>:client</strong>" está a pedir acesso à sua administração financeira. Gostaria de autorizar <strong>:client</strong> a aceder a esses registos?',
    'authorization_request_site'                => 'Será redirecionado para <code>:url</code> o qual será capaz de aceder aos seus dados do Firefly III.',
    'authorization_request_invalid'             => 'Este pedido de acesso é inválido. Por favor, não siga este link novamente.',
    'scopes_will_be_able'                       => 'Esta aplicação será capaz de:',
    'button_authorize'                          => 'Autorizar',
    'none_in_select_list'                       => '(nenhum)',
    'no_piggy_bank'                             => '(nenhum mealheiro)',
    'name_in_currency'                          => ':name em :currency',
    'paid_in_currency'                          => 'Pago em :currency',
    'unpaid_in_currency'                        => 'Por pagar em :currency',
    'is_alpha_warning'                          => 'Está a executar uma versão ALPHA. Cuidado com bugs e problemas.',
    'is_beta_warning'                           => 'Está a executar uma versão BETA. Cuidado com bugs e problemas.',
    'all_destination_accounts'                  => 'Contas de destino',
    'all_source_accounts'                       => 'Contas de origem',
    'back_to_index'                             => 'Voltar para o índice',
    'cant_logout_guard'                         => 'O Firefly III não consegue terminar a sua sessão.',
    'internal_reference'                        => 'Referência interna',

    // check for updates:
    'update_check_title'                        => 'Procurar atualizações',
    'admin_update_check_title'                  => 'Procurar atualizações automaticamente',
    'admin_update_check_explain'                => 'Firefly III pode verificar actualizações automaticamente. Ao activar esta opção, ele entrará em contacto com o servidor de atualização do Firefly III para ver se uma nova versão está disponível. Quando estiver, receberá uma notificação. Pode testar esta notificação utilizando o botão à direita. Indique abaixo se quer que o Firefly III verifique se há atualizações.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Perguntar-me mais tarde',
    'updates_do_not_check'                      => 'Não procurar por atualizações',
    'updates_enable_check'                      => 'Ativar a procura por atualizações',
    'admin_update_check_now_title'              => 'Procurar por atualizações agora',
    'admin_update_check_now_explain'            => 'Se premir o botão, o Firefly III verificará se a versão atual é a mais recente.',
    'check_for_updates_button'                  => 'Verificar agora!',
    'update_new_version_alert'                  => 'Está disponível uma versão nova do Firefly III. Está a usar a versão :your_version, a versão mais recente é :new_version que foi lançada em :date.',
    'update_version_beta'                       => 'Esta versão é BETA. Pode ter problemas.',
    'update_version_alpha'                      => 'Esta versão é ALPHA. Pode ter problemas.',
    'update_current_dev_older'                  => 'Está a executar a versão de desenvolvimento ":version", mais antiga que a última versão lançada :new_version. Por favor, atualize!',
    'update_current_dev_newer'                  => 'Está a executar a versão de desenvolvimento ":version", mais recente do que a última versão lançada :new_version.',
    'update_current_version_alert'              => 'Está a executar :version, que é a última versão disponível.',
    'update_newer_version_alert'                => 'Está a executar :your_version, que é mais recente que a última versão, :new_version.',
    'update_check_error'                        => 'Ocorreu um erro durante a verificação de atualizações: :error',
    'unknown_error'                             => 'Erro desconhecido. Pedimos desculpa.',
    'disabled_but_check'                        => 'Desativou a verificação de atualizações. Mas, não se esqueça de verificar se há atualizações de vez em quando. Obrigado!',
    'admin_update_channel_title'                => 'Atualizar canal',
    'admin_update_channel_explain'              => 'O Firefly III tem três "canais" de atualizações que determinam o quão há frente você está em termos de funcionalidades, melhorias e erros. Utilize o canal "beta" se gostar de aventuras e o "alpha" se gostar de viver a vida ao limite.',
    'update_channel_stable'                     => 'Estável. Deve estar a funcionar como esperado.',
    'update_channel_beta'                       => 'Beta. Novas funcionalidades, mas as algumas coisas podem ter problemas.',
    'update_channel_alpha'                      => 'Alfa. Fazemos o que vier, e o que ficar fica.',

    // search
    'search'                                    => 'Procurar',
    'search_query'                              => 'Pesquisa',
    'search_found_transactions'                 => 'Firefly III encontrou :count transacção em :time segundos.|Firefly III encontrou :count transacções em :time segundos.',
    'search_found_more_transactions'            => 'Firefly III encontrou mais de :count transacções em :time segundos.',
    'search_for_overview'                       => 'Firefly III está procurando por transações que cumpram <b>todas</b> as seguuintes condições:',
    'search_for_query'                          => 'Todas essas palavras precisam estar presentes: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Nenhuma dessas palavras podem estar presentes: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Estes parâmetros de pesquisa não são válidos e foram ignorados.',

    // old


    'search_modifier_date_on'                             => 'A data da transação é ":value"',
    'search_modifier_not_date_on'                         => 'A data da transação não é ":value"',
    'search_modifier_reconciled'                          => 'Transação reconciliada',
    'search_modifier_not_reconciled'                      => 'A transação não está reconciliada',
    'search_modifier_id'                                  => 'O ID da transação é ":value"',
    'search_modifier_not_id'                              => 'O ID da transação não é ":value"',
    'search_modifier_date_before'                         => 'A data da transação é anterior ou igual a ":value"',
    'search_modifier_date_after'                          => 'A data da transação é posterior ou igual a ":value"',
    'search_modifier_external_id_is'                      => 'ID externo é ":value"',
    'search_modifier_not_external_id_is'                  => 'O ID externo não é ":value"',
    'search_modifier_no_external_url'                     => 'A transação não tem nenhum URL externo',
    'search_modifier_no_external_id'                      => 'A transação não tem nenhum ID externo',
    'search_modifier_not_any_external_url'                => 'A transação não tem nenhum URL externo',
    'search_modifier_not_any_external_id'                 => 'A transação não tem nenhum ID externo',
    'search_modifier_any_external_url'                    => 'A transação deve ter (pelo menos) um URL externo',
    'search_modifier_any_external_id'                     => 'A transação deve ter (pelo menos) um URL externo',
    'search_modifier_not_no_external_url'                 => 'A transação deve ter (pelo menos) um URL externo',
    'search_modifier_not_no_external_id'                  => 'A transação deve ter (pelo menos) um URL externo',
    'search_modifier_internal_reference_is'               => 'A referência interna é ":value"',
    'search_modifier_not_internal_reference_is'           => 'A referência interna não é ":value"',
    'search_modifier_description_starts'                  => 'A descrição começa com ":value"',
    'search_modifier_not_description_starts'              => 'A descrição não começa com ":value"',
    'search_modifier_description_ends'                    => 'A descrição termina em ":value"',
    'search_modifier_not_description_ends'                => 'A descrição não termina em ":value"',
    'search_modifier_description_contains'                => 'A descrição contém ":value"',
    'search_modifier_not_description_contains'            => 'A descrição não contém ":value"',
    'search_modifier_description_is'                      => 'A descrição é exatamente ":value"',
    'search_modifier_not_description_is'                  => 'Descrição não é exatamente ":value"',
    'search_modifier_currency_is'                         => 'A moeda (estrangeira) da transação é ":value"',
    'search_modifier_not_currency_is'                     => 'A moeda (estrangeira) da transação não é ":value"',
    'search_modifier_foreign_currency_is'                 => 'A moeda estrangeira da transação é ":value"',
    'search_modifier_not_foreign_currency_is'             => 'A transação em moeda estrangeira não é ":value"',
    'search_modifier_has_attachments'                     => 'A transação tem de ter um anexo',
    'search_modifier_has_no_category'                     => 'A transação não pode ter qualquer categoria',
    'search_modifier_not_has_no_category'                 => 'A transação deve ter (pelo menos) uma categoria',
    'search_modifier_not_has_any_category'                => 'A transação não pode ter qualquer categoria',
    'search_modifier_has_any_category'                    => 'A transação deve ter (pelo menos) uma categoria',
    'search_modifier_has_no_budget'                       => 'A transação não pode ter qualquer orçamento',
    'search_modifier_not_has_any_budget'                  => 'A transação não pode ter qualquer orçamento',
    'search_modifier_has_any_budget'                      => 'A transação deve ter (pelo menos) um orçamento',
    'search_modifier_not_has_no_budget'                   => 'A transação deve ter (pelo menos) um orçamento',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'A transação não pode ter etiquetas',
    'search_modifier_not_has_any_tag'                     => 'A transação não pode ter etiquetas',
    'search_modifier_not_has_no_tag'                      => 'A transação deve ter (pelo menos) uma etiqueta',
    'search_modifier_has_any_tag'                         => 'A transação deve ter (pelo menos) uma etiqueta',
    'search_modifier_notes_contains'                      => 'As notas de transação contêm ":value"',
    'search_modifier_not_notes_contains'                  => 'As notas de transação não contêm ":value"',
    'search_modifier_notes_starts'                        => 'As notas da transação começam com ":value"',
    'search_modifier_not_notes_starts'                    => 'As notas da transação não começam com ":value"',
    'search_modifier_notes_ends'                          => 'As notas da transação acabam com ":value"',
    'search_modifier_not_notes_ends'                      => 'As notas da transação não terminam em ":value"',
    'search_modifier_notes_is'                            => 'As notas da transacção são exactamente ":value"',
    'search_modifier_not_notes_is'                        => 'As notas da transação não são exatamente ":value"',
    'search_modifier_no_notes'                            => 'A transacção não pode tem notas',
    'search_modifier_not_no_notes'                        => 'A transação deve ter notas',
    'search_modifier_any_notes'                           => 'A transacção tem que ter notas',
    'search_modifier_not_any_notes'                       => 'A transação não tem notas',
    'search_modifier_amount_is'                           => 'O valor é exactamente :value',
    'search_modifier_not_amount_is'                       => 'O valor não é :value',
    'search_modifier_amount_less'                         => 'Valor é menor ou igual a :value',
    'search_modifier_not_amount_more'                     => 'O valor é menor ou igual a :value',
    'search_modifier_amount_more'                         => 'Valor é maior ou igual a :value',
    'search_modifier_not_amount_less'                     => 'O valor é maior ou igual a :value',
    'search_modifier_source_account_is'                   => 'O nome da conta de origem é exatamente ":value"',
    'search_modifier_not_source_account_is'               => 'A conta de origem não é ":value"',
    'search_modifier_source_account_contains'             => 'O nome da conta de origem contém ":value"',
    'search_modifier_not_source_account_contains'         => 'A conta de origem não contém ":value"',
    'search_modifier_source_account_starts'               => 'Nome da conta de origem começa com ":value"',
    'search_modifier_not_source_account_starts'           => 'O nome da conta de origem não começa com ":value"',
    'search_modifier_source_account_ends'                 => 'O nome da conta de origem acaba com ":value"',
    'search_modifier_not_source_account_ends'             => 'O nome da conta de origem não termina em ":value"',
    'search_modifier_source_account_id'                   => 'ID da conta de origem é :value',
    'search_modifier_not_source_account_id'               => 'O ID da conta de origem não é :value',
    'search_modifier_source_account_nr_is'                => 'Número da conta de origem (IBAN) é ":value"',
    'search_modifier_not_source_account_nr_is'            => 'O número (IBAN) da conta de origem não é ":value"',
    'search_modifier_source_account_nr_contains'          => 'Número da conta de origem (IBAN) contém ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'O número (IBAN) da conta de origem não contém ":value"',
    'search_modifier_source_account_nr_starts'            => 'Número da conta de origem (IBAN) começa com ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'O número (IBAN) da conta de origem não começa com ":value"',
    'search_modifier_source_account_nr_ends'              => 'O número (IBAN) da conta de origem termina em ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'O número (IBAN) da conta de origem não termina em ":value"',
    'search_modifier_destination_account_is'              => 'O nome da conta de destino é exatamente ":value"',
    'search_modifier_not_destination_account_is'          => 'O nome da conta de destino não é ":value"',
    'search_modifier_destination_account_contains'        => 'Nome da conta de destino contém ":value"',
    'search_modifier_not_destination_account_contains'    => 'O nome da conta de destino não contém ":value"',
    'search_modifier_destination_account_starts'          => 'O nome da conta de destino começa com ":value"',
    'search_modifier_not_destination_account_starts'      => 'O nome da conta de destino não começa com ":value"',
    'search_modifier_destination_account_ends'            => 'O nome da conta de destino termina em ":value"',
    'search_modifier_not_destination_account_ends'        => 'O nome da conta de destino não termina em ":value"',
    'search_modifier_destination_account_id'              => 'ID da conta de destino é :value',
    'search_modifier_not_destination_account_id'          => 'O ID da conta de destino não é :value',
    'search_modifier_destination_is_cash'                 => 'A conta de destino é a conta "(caixa)"',
    'search_modifier_not_destination_is_cash'             => 'A conta de destino não é a conta "(caixa)"',
    'search_modifier_source_is_cash'                      => 'A conta de origem é a conta "(caixa)"',
    'search_modifier_not_source_is_cash'                  => 'A conta de origem não é a conta "(caixa)"',
    'search_modifier_destination_account_nr_is'           => 'Número da conta de destino (IBAN) é ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'O número (IBAN) da conta de destino é ":value"',
    'search_modifier_destination_account_nr_contains'     => 'O número da conta de destino (IBAN) contém ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'O número (IBAN) da conta de destino não contém ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Número da conta de destino (IBAN) começa com ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'O número (IBAN) da conta de destino não começa com ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Número da conta de destino (IBAN) acaba com ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'O número (IBAN) da conta de destino não termina com ":value"',
    'search_modifier_account_id'                          => 'O ID da conta de origem ou destino é/são: :value',
    'search_modifier_not_account_id'                      => 'Os ID\'s das contas de origem ou destino não são: :value',
    'search_modifier_category_is'                         => 'A categoria é ":value"',
    'search_modifier_not_category_is'                     => 'A categoria não é ":value"',
    'search_modifier_budget_is'                           => 'O orçamento é ":value"',
    'search_modifier_not_budget_is'                       => 'O orçamento não é ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Tipo de transacção é ":value"',
    'search_modifier_not_transaction_type'                => 'O tipo de transação não é ":value"',
    'search_modifier_tag_is'                              => 'A etiqueta é ":value"',
    'search_modifier_tag_contains'                        => 'A etiqueta contem ":value"',
    'search_modifier_not_tag_contains'                    => 'A etiqueta não contêm ":value"',
    'search_modifier_tag_ends'                            => 'A etiqueta acaba com ":value"',
    'search_modifier_tag_starts'                          => 'A etiqueta começa com ":value"',
    'search_modifier_not_tag_is'                          => 'Nenhuma etiqueta é ":value"',
    'search_modifier_date_on_year'                        => 'A transação é do ano ":value"',
    'search_modifier_not_date_on_year'                    => 'A transação não é no ano ":value"',
    'search_modifier_date_on_month'                       => 'A transação é do mês ":value"',
    'search_modifier_not_date_on_month'                   => 'A transação não é no mês ":value"',
    'search_modifier_date_on_day'                         => 'A transação é no dia do mês ":value"',
    'search_modifier_not_date_on_day'                     => 'A transação não é no dia do mês ":value"',
    'search_modifier_date_before_year'                    => 'A transação é antes ou no ano ":value"',
    'search_modifier_date_before_month'                   => 'A transação é antes ou no mês ":value"',
    'search_modifier_date_before_day'                     => 'A transação é antes ou no dia do mês ":value"',
    'search_modifier_date_after_year'                     => 'A transação é no ou depois do ano ":value"',
    'search_modifier_date_after_month'                    => 'A transação é no ou depois do mês ":value"',
    'search_modifier_date_after_day'                      => 'A transação é depois ou no dia do mês ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Nenhuma etiqueta é ":value"',
    'search_modifier_not_tag_is_not'                      => 'A etiqueta é ":value"',
    'search_modifier_account_is'                          => 'Qualquer das contas é ":value"',
    'search_modifier_not_account_is'                      => 'Nenhuma das contas é ":value"',
    'search_modifier_account_contains'                    => 'Qualquer das contas contêm ":value"',
    'search_modifier_not_account_contains'                => 'Nenhuma das contas contém ":value"',
    'search_modifier_account_ends'                        => 'Qualquer das contas acaba com ":value"',
    'search_modifier_not_account_ends'                    => 'Nenhuma das contas termina com ":value"',
    'search_modifier_account_starts'                      => 'Qualquer das contas começa com ":value"',
    'search_modifier_not_account_starts'                  => 'Nenhuma das contas começa com ":value"',
    'search_modifier_account_nr_is'                       => 'Qualquer um dos números de conta/IBAN é ":value"',
    'search_modifier_not_account_nr_is'                   => 'Nenhum número / IBAN de conta é ":value"',
    'search_modifier_account_nr_contains'                 => 'Qualquer um dos números de conta/IBAN contêm ":value"',
    'search_modifier_not_account_nr_contains'             => 'Nenhum número / IBAN de conta contém ":value"',
    'search_modifier_account_nr_ends'                     => 'Qualquer um dos números de conta/IBAN acaba em ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Nenhum número / IBAN de conta termina com ":value"',
    'search_modifier_account_nr_starts'                   => 'Qualquer um dos números de conta/IBAN começa com ":value"',
    'search_modifier_not_account_nr_starts'               => 'Nenhum número / IBAN de conta começa com ":value"',
    'search_modifier_category_contains'                   => 'A categoria contém ":value"',
    'search_modifier_not_category_contains'               => 'A categoria não contém ":value"',
    'search_modifier_category_ends'                       => 'A categoria termina em ":value"',
    'search_modifier_not_category_ends'                   => 'A categoria não termina em ":value"',
    'search_modifier_category_starts'                     => 'A categoria começa com ":value"',
    'search_modifier_not_category_starts'                 => 'A categoria não começa com ":value"',
    'search_modifier_budget_contains'                     => 'O orçamento contém ":value"',
    'search_modifier_not_budget_contains'                 => 'O orçamento não contém ":value"',
    'search_modifier_budget_ends'                         => 'O orçamento acaba com ":value"',
    'search_modifier_not_budget_ends'                     => 'O orçamento não termina em ":value"',
    'search_modifier_budget_starts'                       => 'O orçamento começa com ":value"',
    'search_modifier_not_budget_starts'                   => 'O orçamento não começa com ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'O ID Externo contém ":value"',
    'search_modifier_not_external_id_contains'            => 'O ID Externo não contém ":value"',
    'search_modifier_external_id_ends'                    => 'O ID Externo termina com ":value"',
    'search_modifier_not_external_id_ends'                => 'O ID externo não termina em ":value"',
    'search_modifier_external_id_starts'                  => 'O ID Externo começa em ":value"',
    'search_modifier_not_external_id_starts'              => 'O ID externo não começa em ":value"',
    'search_modifier_internal_reference_contains'         => 'A referência interna contêm ":value"',
    'search_modifier_not_internal_reference_contains'     => 'A referência interna não contém :value',
    'search_modifier_internal_reference_ends'             => 'A referência interna termina em ":value"',
    'search_modifier_internal_reference_starts'           => 'A referência interna começa com ":value"',
    'search_modifier_not_internal_reference_ends'         => 'A referência interna não termina em :value',
    'search_modifier_not_internal_reference_starts'       => 'A referência interna não começa com :value',
    'search_modifier_external_url_is'                     => 'O URL externo é ":value"',
    'search_modifier_not_external_url_is'                 => 'O URL externo não é :value',
    'search_modifier_external_url_contains'               => 'O URL externo contém ":value"',
    'search_modifier_not_external_url_contains'           => 'O URL externo não contém :value',
    'search_modifier_external_url_ends'                   => 'O URL externo termina em ":value"',
    'search_modifier_not_external_url_ends'               => 'O URL externo não termina em :value',
    'search_modifier_external_url_starts'                 => 'O URL externo começa com ":value"',
    'search_modifier_not_external_url_starts'             => 'O URL externo não começa com :value',
    'search_modifier_has_no_attachments'                  => 'A transacção não tem anexos',
    'search_modifier_not_has_no_attachments'              => 'A transação tem anexos',
    'search_modifier_not_has_attachments'                 => 'A transação não tem anexos',
    'search_modifier_account_is_cash'                     => 'Qualquer conta é a conta "(caixa)".',
    'search_modifier_not_account_is_cash'                 => 'Nenhuma das contas é a conta "(caixa)".',
    'search_modifier_journal_id'                          => 'O ID do diário é ":value"',
    'search_modifier_not_journal_id'                      => 'O ID do diário não é ":value"',
    'search_modifier_recurrence_id'                       => 'O ID de transação recorrente é ":value"',
    'search_modifier_not_recurrence_id'                   => 'O ID de transação recorrente não é ":value"',
    'search_modifier_foreign_amount_is'                   => 'O montante em estrangeira é ":value"',
    'search_modifier_not_foreign_amount_is'               => 'O montante em moeda estrangeira não é :value',
    'search_modifier_foreign_amount_less'                 => 'O montante em moeda estrangeira é inferior a :value',
    'search_modifier_not_foreign_amount_more'             => 'O montante em moeda estrangeira é inferior a :value',
    'search_modifier_not_foreign_amount_less'             => 'O montante em moeda estrangeira é superior a :value',
    'search_modifier_foreign_amount_more'                 => 'O montante em moeda estrangeira é superior a :value',
    'search_modifier_exists'                              => 'A transação existe (qualquer transação)',
    'search_modifier_not_exists'                          => 'A transação não existe (nenhuma transação)',

    // date fields
    'search_modifier_interest_date_on'                    => 'A transação vence juros em :value',
    'search_modifier_not_interest_date_on'                => 'A transação não vence juros em :value',
    'search_modifier_interest_date_on_year'               => 'A data de juros da transação é no ano :value',
    'search_modifier_not_interest_date_on_year'           => 'A data de juros da transação não é no ano :value',
    'search_modifier_interest_date_on_month'              => 'A data de juros da transação é no mês :value',
    'search_modifier_not_interest_date_on_month'          => 'A data de juros da transação não é no mês :value',
    'search_modifier_interest_date_on_day'                => 'A data de juros da transação é no dia do mês :value',
    'search_modifier_not_interest_date_on_day'            => 'A data de juros da transação não é no dia do mês :value',
    'search_modifier_interest_date_before_year'           => 'A data de juros da transação é anterior ou no ano :value',
    'search_modifier_interest_date_before_month'          => 'A data de juros da transação é anterior ou no mês de :value',
    'search_modifier_interest_date_before_day'            => 'A data de juros da transação é anterior ou no dia do mês :value',
    'search_modifier_interest_date_after_year'            => 'A data de juros da transação é posterior ou no ano :value',
    'search_modifier_interest_date_after_month'           => 'A data de juros da transação é no mês ":value" ou posterior',
    'search_modifier_interest_date_after_day'             => 'A data de juros da transação é no dia do mês ":value" ou posterior',
    'search_modifier_book_date_on_year'                   => 'A data da transação é no ano ":value"',
    'search_modifier_book_date_on_month'                  => 'A data da transação é no mês ":value"',
    'search_modifier_book_date_on_day'                    => 'A data da transação é no dia do mês ":value"',
    'search_modifier_not_book_date_on_year'               => 'A data da transação não é no ano ":value"',
    'search_modifier_not_book_date_on_month'              => 'A data da transação não é no mês ":value"',
    'search_modifier_not_book_date_on_day'                => 'A data da transação não é no dia do mês ":value"',
    'search_modifier_book_date_before_year'               => 'A data da transação é no ano ":value" ou anterior',
    'search_modifier_book_date_before_month'              => 'A data da transação é no mês ":value" ou anterior',
    'search_modifier_book_date_before_day'                => 'A data da transação é no dia do mês ":value" ou anterior',
    'search_modifier_book_date_after_year'                => 'A data da transação é no ano ":value" ou posterior',
    'search_modifier_book_date_after_month'               => 'A data da transação é no mês ":value" ou posterior',
    'search_modifier_book_date_after_day'                 => 'A data da transação é no dia do mês ":value" ou posterior',
    'search_modifier_process_date_on_year'                => 'A data de processamento da transação é no ano ":value"',
    'search_modifier_process_date_on_month'               => 'A data de processamento da transação é no mês ":value"',
    'search_modifier_process_date_on_day'                 => 'A data de processamento da transação é no dia do mês ":value"',
    'search_modifier_not_process_date_on_year'            => 'A data de processamento da transação não é no ano ":value"',
    'search_modifier_not_process_date_on_month'           => 'A data de processamento da transação não é no mês ":value"',
    'search_modifier_not_process_date_on_day'             => 'A data de processamento da transação não é no dia do ":value"',
    'search_modifier_process_date_before_year'            => 'A data de processamento da transação é no ano ":value" ou anterior',
    'search_modifier_process_date_before_month'           => 'A data de processamento da transação é no mês ":value" ou anterior',
    'search_modifier_process_date_before_day'             => 'A data de processamento da transação é no dia do mês ":value" ou anterior',
    'search_modifier_process_date_after_year'             => 'A data de processamento da transação é no ano ":value" ou posterior',
    'search_modifier_process_date_after_month'            => 'A data de processamento da transação é no mês ":value" ou posterior',
    'search_modifier_process_date_after_day'              => 'A data de processamento da transação é no dia do mês ":value" ou posterior',
    'search_modifier_due_date_on_year'                    => 'A data de vencimento da transação é no ano ":value"',
    'search_modifier_due_date_on_month'                   => 'A data de vencimento da transação é no mês ":value"',
    'search_modifier_due_date_on_day'                     => 'A data de vencimento da transação é no dia do mês ":value"',
    'search_modifier_not_due_date_on_year'                => 'A data de vencimento da transação não é no ano ":value"',
    'search_modifier_not_due_date_on_month'               => 'A data de vencimento da transação não é no mês ":value"',
    'search_modifier_not_due_date_on_day'                 => 'A data de vencimento da transação não é no dia do ":value"',
    'search_modifier_due_date_before_year'                => 'A data de vencimento da transação é no ano ":value" ou anterior',
    'search_modifier_due_date_before_month'               => 'A data de vencimento da transação é no mês ":value" ou anterior',
    'search_modifier_due_date_before_day'                 => 'A data de vencimento da transação é no dia do mês ":value" ou anterior',
    'search_modifier_due_date_after_year'                 => 'A data de vencimento da transação é no ano ":value" ou posterior',
    'search_modifier_due_date_after_month'                => 'A data de vencimento da transação é no mês ":value" ou posterior',
    'search_modifier_due_date_after_day'                  => 'A data de vencimento da transação é no dia do mês ":value" ou posterior',
    'search_modifier_payment_date_on_year'                => 'A data de pagamento da transação é no ano ":value"',
    'search_modifier_payment_date_on_month'               => 'A data de pagamento da transação é no mês ":value"',
    'search_modifier_payment_date_on_day'                 => 'A data de pagamento da transação é no dia do mês ":value"',
    'search_modifier_not_payment_date_on_year'            => 'A data de pagamento da transação não é no ano ":value"',
    'search_modifier_not_payment_date_on_month'           => 'A data de pagamento da transação não é no mês ":value"',
    'search_modifier_not_payment_date_on_day'             => 'A data de pagamento da transação não é no dia do mês ":value"',
    'search_modifier_payment_date_before_year'            => 'A data de pagamento da transação é no ano ":value" ou anterior',
    'search_modifier_payment_date_before_month'           => 'A data de pagamento da transação é no mês ":value" ou anterior',
    'search_modifier_payment_date_before_day'             => 'A data de pagamento da transação é no dia do mês ":value" ou anterior',
    'search_modifier_payment_date_after_year'             => 'A data de pagamento da transação é no ano ":value" ou posterior',
    'search_modifier_payment_date_after_month'            => 'A data de pagamento da transação é no mês ":value" ou posterior',
    'search_modifier_payment_date_after_day'              => 'A data de pagamento da transação é no dia do mês ":value" ou posterior',
    'search_modifier_invoice_date_on_year'                => 'A data da fatura da transação é no ano ":value"',
    'search_modifier_invoice_date_on_month'               => 'A data da fatura da transação é no mês ":value"',
    'search_modifier_invoice_date_on_day'                 => 'A data da fatura da transação é no dia do mês ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'A data da fatura da transação não é no ano ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'A data da fatura da transação não é no mês ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'A data da fatura da transação não é no dia do mês ":value"',
    'search_modifier_invoice_date_before_year'            => 'A data da fatura da transação não é anterior ou no ano ":value"',
    'search_modifier_invoice_date_before_month'           => 'A data da fatura da transação não é anterior ou no mês ":value"',
    'search_modifier_invoice_date_before_day'             => 'A data da fatura da transação não é anterior ou no dia do mês ":value"',
    'search_modifier_invoice_date_after_year'             => 'A data da fatura da transação não é posterior ou no ano ":value"',
    'search_modifier_invoice_date_after_month'            => 'A data da fatura da transação não é posterior ou no mês ":value"',
    'search_modifier_invoice_date_after_day'              => 'A data da fatura da transação não é posterior ou no dia do mês ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'A transação foi atualizada pela última vez no ano ":value"',
    'search_modifier_updated_at_on_month'                 => 'A transação foi atualizada pela última vez no mês ":value"',
    'search_modifier_updated_at_on_day'                   => 'A transação foi atualizada pela última vez no dia do mês ":value"',
    'search_modifier_not_updated_at_on_year'              => 'A transação não foi atualizada pela última vez no ano ":value"',
    'search_modifier_not_updated_at_on_month'             => 'A transação não foi atualizada pela última vez no mês ":value"',
    'search_modifier_not_updated_at_on_day'               => 'A transação não foi atualizada pela última vez no dia do mês ":value"',
    'search_modifier_updated_at_before_year'              => 'A transação foi atualizada pela última vez antes de ou no ano ":value"',
    'search_modifier_updated_at_before_month'             => 'A transação foi atualizada pela última vez antes de ou no mês ":value"',
    'search_modifier_updated_at_before_day'               => 'A transação foi atualizada pela última vez antes de ou no dia do mês ":value"',
    'search_modifier_updated_at_after_year'               => 'A transação foi atualizada pela última vez no ano ":value" ou posterior',
    'search_modifier_updated_at_after_month'              => 'A transação foi atualizada pela última vez no mês ":value" ou posterior',
    'search_modifier_updated_at_after_day'                => 'A transação foi atualizada pela última vez no dia do mês ":value" ou posterior',
    'search_modifier_created_at_on_year'                  => 'A transação foi criada no ano ":value"',
    'search_modifier_created_at_on_month'                 => 'A transação foi criada no mês ":value"',
    'search_modifier_created_at_on_day'                   => 'A transação foi criada no dia do mês ":value"',
    'search_modifier_not_created_at_on_year'              => 'A transação não foi criada no ano ":value"',
    'search_modifier_not_created_at_on_month'             => 'A transação não foi criada no mês ":value"',
    'search_modifier_not_created_at_on_day'               => 'A transação não foi criada no dia do mês ":value"',
    'search_modifier_created_at_before_year'              => 'A transação foi criada no ano ":value" ou anterior',
    'search_modifier_created_at_before_month'             => 'A transação foi criada no mês ":value" ou anterior',
    'search_modifier_created_at_before_day'               => 'A transação foi criada no dia do mês ":value" ou anterior',
    'search_modifier_created_at_after_year'               => 'A transação foi criada no ano ":value" ou posterior',
    'search_modifier_created_at_after_month'              => 'A transação foi criada no mês ":value" ou posterior',
    'search_modifier_created_at_after_day'                => 'A transação foi criada no dia do mês ":value" ou posterior',
    'search_modifier_interest_date_before'                => 'A data de juros da transação é no dia ":value" ou anterior',
    'search_modifier_interest_date_after'                 => 'A data de juros da transação é no dia ":value" ou posterior',
    'search_modifier_book_date_on'                        => 'A data da transação é ":value"',
    'search_modifier_not_book_date_on'                    => 'A data da transação não é ":value"',
    'search_modifier_book_date_before'                    => 'A data da transação é o dia ":value" ou anterior',
    'search_modifier_book_date_after'                     => 'A data da transação é o dia ":value" ou posterior',
    'search_modifier_process_date_on'                     => 'A data de processamento da transação é ":value"',
    'search_modifier_not_process_date_on'                 => 'A data de processamento da transação não é ":value"',
    'search_modifier_process_date_before'                 => 'A data de processamento da transação é ":value" ou anterior',
    'search_modifier_process_date_after'                  => 'A data de processamento da transação é ":value" ou posterior',
    'search_modifier_due_date_on'                         => 'A data de vencimento da transação é ":value"',
    'search_modifier_not_due_date_on'                     => 'A data de vencimento da transação não é ":value"',
    'search_modifier_due_date_before'                     => 'A data de vencimento da transação é ":value" ou anterior',
    'search_modifier_due_date_after'                      => 'A data de vencimento da transação é ":value" ou posterior',
    'search_modifier_payment_date_on'                     => 'A data de pagamento da transação é ":value"',
    'search_modifier_not_payment_date_on'                 => 'A data de pagamento da transação não é ":value"',
    'search_modifier_payment_date_before'                 => 'A data de pagamento da transação é no dia ":value" ou anterior',
    'search_modifier_payment_date_after'                  => 'A data de pagamento da transação é no dia ":value" ou posterior',
    'search_modifier_invoice_date_on'                     => 'A data da fatura da transação é ":value"',
    'search_modifier_not_invoice_date_on'                 => 'A data da fatura da transação não é ":value"',
    'search_modifier_invoice_date_before'                 => 'A data da fatura da transação é no dia ":value" ou anterior',
    'search_modifier_invoice_date_after'                  => 'A data da fatura da transação é no dia ":value" ou posterior',
    'search_modifier_created_at_on'                       => 'A transação foi criada em ":value"',
    'search_modifier_not_created_at_on'                   => 'A transação não foi criada em ":value"',
    'search_modifier_created_at_before'                   => 'A transação foi criada no dia ":value" ou anterior',
    'search_modifier_created_at_after'                    => 'A transação foi criada no dia ":value" ou posterior',
    'search_modifier_updated_at_on'                       => 'A transação foi atualizada em ":value"',
    'search_modifier_not_updated_at_on'                   => 'A transação não foi atualizada em ":value"',
    'search_modifier_updated_at_before'                   => 'A transação foi atualizada no dia ":value" ou anterior',
    'search_modifier_updated_at_after'                    => 'A transação foi atualizada no dia ":value" ou posterior',

    'search_modifier_attachment_name_is'            => 'Qualquer nome de anexo é ":value"',
    'search_modifier_attachment_name_contains'      => 'Qualquer nome de anexo contém ":value"',
    'search_modifier_attachment_name_starts'        => 'Qualquer nome de anexo começa com ":value"',
    'search_modifier_attachment_name_ends'          => 'Qualquer nome de anexo termina com ":value"',
    'search_modifier_attachment_notes_are'          => 'Quaisquer notas de anexo são ":value"',
    'search_modifier_attachment_notes_contains'     => 'Quaisquer notas de anexo contêm ":value"',
    'search_modifier_attachment_notes_starts'       => 'Quaisquer notas de anexo começam com ":value"',
    'search_modifier_attachment_notes_ends'         => 'Quaisquer notas de anexo terminam com ":value"',
    'search_modifier_not_attachment_name_is'        => 'Qualquer nome de anexo não é ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Qualquer nome de anexo não contém ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Qualquer nome de anexo não começa com ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Qualquer nome de anexo não termina com ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Quaisquer notas de anexo não são ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Quaisquer notas de anexo não contêm ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Quaisquer notas de anexo não começam com ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Quaisquer notas de anexo não terminam com ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA TC é ":value"',
    'update_rule_from_query'                        => 'Atualizar regra ":rule" da pesquisa',
    'create_rule_from_query'                        => 'Criar nova regra a partir da pesquisa',
    'rule_from_search_words'                        => 'O mecanismo de regras tem dificuldade com ":string". A regra sugerida que se encaixa na pesquisa pode mostrar resultados diferentes. Por favor, verifique os gatilhos das regras cuidadosamente.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'Ocorreu um erro ao procurar. Por favor, verifique os arquivos de log para mais informações.',
    'search_box'                                          => 'Procurar',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Erro durante a pesquisa',
    'search_searching'                                    => 'A pesquisar ...',
    'search_results'                                      => 'Resultados da pesquisa',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'anualmente',
    'repeat_freq_half-year'                               => 'a cada meio ano',
    'repeat_freq_quarterly'                               => 'trimestral',
    'repeat_freq_monthly'                                 => 'mensalmente',
    'repeat_freq_weekly'                                  => 'semanalmente',
    'repeat_freq_daily'                                   => 'diariamente',
    'daily'                                               => 'diariamente',
    'weekly'                                              => 'semanalmente',
    'quarterly'                                           => 'trimestral',
    'half-year'                                           => 'a cada meio ano',
    'yearly'                                              => 'anual',

    // rules
    'is_not_rule_trigger'                                 => 'Não',
    'cannot_fire_inactive_rules'                          => 'Não pode executar regras inativas.',
    'show_triggers'                                       => 'Mostrar gatilhos',
    'show_actions'                                        => 'Mostrar ações',
    'rules'                                               => 'Regras',
    'rule_name'                                           => 'Nome da regra',
    'rule_triggers'                                       => 'Regra dispara quando',
    'rule_actions'                                        => 'Regra vai',
    'new_rule'                                            => 'Nova regra',
    'new_rule_group'                                      => 'Novo grupo de regras',
    'rule_priority_up'                                    => 'Dar mais prioridade a regra',
    'rule_priority_down'                                  => 'Dar menos prioridade a regra',
    'make_new_rule_group'                                 => 'Criar novo grupo de regras',
    'store_new_rule_group'                                => 'Gravar novo grupo de regras',
    'created_new_rule_group'                              => 'Novo grupo de regras ":title" gravado!',
    'updated_rule_group'                                  => 'Grupo de regras atualizado com sucesso ":title".',
    'edit_rule_group'                                     => 'Editar grupo de regras ":title"',
    'duplicate_rule'                                      => 'Duplicar regra ":title"',
    'rule_copy_of'                                        => 'Cópia de ":title"',
    'duplicated_rule'                                     => 'Duplicada regra ":title" para ":newTitle"',
    'delete_rule_group'                                   => 'Apagar grupo de regras ":title"',
    'deleted_rule_group'                                  => 'Grupo de regras ":title" apagado',
    'update_rule_group'                                   => 'Atualizar grupo de regras',
    'no_rules_in_group'                                   => 'Não há regras neste grupo',
    'move_rule_group_up'                                  => 'Mover para cima o grupo de regras',
    'move_rule_group_down'                                => 'Mover para baixo o grupo de regras',
    'save_rules_by_moving'                                => 'Guardar esta regra movendo-a para outro grupo de regras:|Guardar estas regras movendo-as para outro grupo de regras:',
    'make_new_rule'                                       => 'Adicione uma nova regra ao grupo de regras ":title"',
    'make_new_rule_no_group'                              => 'Criar uma nova regra',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Crie uma regra com base numa das suas transacções. Complete ou envie o formulário abaixo.',
    'rule_is_strict'                                      => 'regra restrita',
    'rule_is_not_strict'                                  => 'regra não restrita',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'Nas regras estritas TODOS os disparos devem ser executados para a(s) ação(ões) ocorrerem. Nas regras não estritas QUALQUER disparo é suficiente para executar uma ação.',
    'rule_help_active'                                    => 'Regras inativas nunca dispararão.',
    'stored_new_rule'                                     => 'Guardada nova regra com o título ":title"',
    'deleted_rule'                                        => 'Apagada regra com o título ":title"',
    'store_new_rule'                                      => 'Gravar nova regra',
    'updated_rule'                                        => 'Atualizada a regra com o título ":title"',
    'default_rule_group_name'                             => 'Regras predefinidas',
    'default_rule_group_description'                      => 'Todas as regras que não estão num grupo específico.',
    'trigger'                                             => 'Gatilho',
    'trigger_value'                                       => 'Disparar no valor',
    'stop_processing_other_triggers'                      => 'Parar os outros gatilhos',
    'add_rule_trigger'                                    => 'Adicionar novo gatilho',
    'action'                                              => 'Ação',
    'action_value'                                        => 'Valor da ação',
    'stop_executing_other_actions'                        => 'Parar de executar outras ações',
    'add_rule_action'                                     => 'Adicionar nova ação',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Apagar regra ":title"',
    'update_rule'                                         => 'Atualizar regra',
    'test_rule_triggers'                                  => 'Ver transacções correspondentes',
    'warning_no_matching_transactions'                    => 'Nenhuma transacção correspondente foi encontrada.',
    'warning_no_valid_triggers'                           => 'Nenhum gatilho válido encontrado.',
    'apply_rule_selection'                                => 'Aplicar a regra ":title" a uma selecção de transacções',
    'apply_rule_selection_intro'                          => 'Regras como ":title" são normalmente aplicadas a transações novas ou atualizadas, no entanto pode dizer ao Firefly III para executar as mesmas em transações selecionadas. Isto pode ser útil quando tiver atualizado uma regra e necessite de aplicar as alterações a todas as transações que devem ser afetas.',
    'include_transactions_from_accounts'                  => 'Incluir transações destas contas',
    'include'                                             => 'Incluir?',
    'applied_rule_selection'                              => '{0} Nenhuma transação na sua seleção foi alterada pela regra ":title".[1] Uma transação na sua seleção foi alterada pela regra ":title".├[2,*] :count transações na sua seleção foram alteradas pela regra ":title".',
    'execute'                                             => 'Executar',
    'apply_rule_group_selection'                          => 'Aplicar grupo de regras ":title" a uma seleção de transações',
    'apply_rule_group_selection_intro'                    => 'Grupos de regras como ":title" são normalmente aplicados a transações novas ou atualizadas, no entanto pode dizer ao Firefly III para executar todas as regras deste grupo a uma seleção de transações existentes. Isto pode ser útil quando tiver atualizado um grupo de regras e necessite de aplicar as alterações a todas as outras transações.',
    'applied_rule_group_selection'                        => 'O grupo de regras ":title" foi aplicado à sua seleção.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Quando uma transação é criada',
    'rule_trigger_update_journal'                         => 'Quando uma transação é atualizada',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'A ação de utilizador é ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'O nome da conta de origem começa com..',
    'rule_trigger_source_account_starts'                  => 'O nome da conta de origem começa com ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'O nome da conta de origem acaba com..',
    'rule_trigger_source_account_ends'                    => 'O nome da conta de origem acaba com ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'O nome da conta de origem é..',
    'rule_trigger_source_account_is'                      => 'O nome da conta de origem é ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Nome da conta de origem contém..',
    'rule_trigger_source_account_contains'                => 'Nome da conta de origem contém ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Qualquer ID de conta é exatamente..',
    'rule_trigger_account_id'                             => 'Qualquer ID de conta é exatamente :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'O ID da conta de origem é exatamente..',
    'rule_trigger_source_account_id'                      => 'O ID da conta de origem é exactamente :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'O ID da conta de destino é exatamente..',
    'rule_trigger_destination_account_id'                 => 'O ID da conta de destino é exactamente :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Qualquer uma das contas é de caixa',
    'rule_trigger_account_is_cash'                        => 'Qualquer uma das contas é de caixa',
    'rule_trigger_source_is_cash_choice'                  => 'A conta de origem é uma conta (caixa)',
    'rule_trigger_source_is_cash'                         => 'A conta de origem é uma conta (caixa)',
    'rule_trigger_destination_is_cash_choice'             => 'A conta de destino é uma conta (caixa)',
    'rule_trigger_destination_is_cash'                    => 'A conta de destino é uma conta (caixa)',
    'rule_trigger_source_account_nr_starts_choice'        => 'Número / IBAN da conta de origem começa com..',
    'rule_trigger_source_account_nr_starts'               => 'Número / IBAN da conta de origem começa com ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Número / IBAN da conta de origem acaba com..',
    'rule_trigger_source_account_nr_ends'                 => 'Número / IBAN da conta de origem acaba com ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Número / IBAN da conta de origem é..',
    'rule_trigger_source_account_nr_is'                   => 'O número / IBAN da conta de origem é ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'O número / IBAN da conta de origem contém..',
    'rule_trigger_source_account_nr_contains'             => 'Número / IBAN da conta de origem contém ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Nome da conta de destino começa com..',
    'rule_trigger_destination_account_starts'             => 'O nome da conta de destino começa com ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'O nome da conta de destino acaba com..',
    'rule_trigger_destination_account_ends'               => 'O nome da conta de destino acaba com ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'O nome da conta de destino é..',
    'rule_trigger_destination_account_is'                 => 'O nome da conta de destino é ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'O nome da conta de destino contém..',
    'rule_trigger_destination_account_contains'           => 'O nome da conta de destino contém ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'O número / IBAN da conta de destino começa com..',
    'rule_trigger_destination_account_nr_starts'          => 'O número / IBAN da conta de destino começa com ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'O número / IBAN da conta de destino acaba com..',
    'rule_trigger_destination_account_nr_ends'            => 'O número / IBAN da conta de destino acaba com ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'O número / IBAN da conta de destino é..',
    'rule_trigger_destination_account_nr_is'              => 'O número / IBAN da conta de destino é ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'O número / IBAN da conta de destino contém..',
    'rule_trigger_destination_account_nr_contains'        => 'O número da conta de destino/IBAN contém ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'A transação é do tipo..',
    'rule_trigger_transaction_type'                       => 'Transação é do tipo ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'A categoria é..',
    'rule_trigger_category_is'                            => 'A categoria é ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Quantidade é menor ou igual a ..',
    'rule_trigger_amount_less'                            => 'Quantidade é menor ou igual a :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'O montante é..',
    'rule_trigger_amount_is'                              => 'O montante é :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Quantidade é maior ou igual a..',
    'rule_trigger_amount_more'                            => 'Quantidade é maior ou igual a :trigger_value',
    'rule_trigger_description_starts_choice'              => 'A descrição começa com..',
    'rule_trigger_description_starts'                     => 'A descrição começa com ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'A descrição termina com..',
    'rule_trigger_description_ends'                       => 'A descrição acaba com ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'A descrição contém..',
    'rule_trigger_description_contains'                   => 'A descrição contém ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'A descrição é..',
    'rule_trigger_description_is'                         => 'A descrição é ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'A data da transação é..',
    'rule_trigger_date_on'                                => 'A data da transação é ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'A data da transação é anterior..',
    'rule_trigger_date_before'                            => 'A data da transação é anterior a ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'A data da transação é após..',
    'rule_trigger_date_after'                             => 'A data da transação é após ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'A transação foi realizada em..',
    'rule_trigger_created_at_on'                          => 'A transação foi realizada em ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'A transação foi editada pela última vez em..',
    'rule_trigger_updated_at_on'                          => 'A transação foi editada pela última vez em ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'O orçamento é..',
    'rule_trigger_budget_is'                              => 'O orçamento é ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Uma etiqueta é..',
    'rule_trigger_tag_is'                                 => 'Qualquer etiqueta é ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Qualquer etiqueta contenha..',
    'rule_trigger_tag_contains'                           => 'Qualquer etiqueta contenha ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Qualquer etiqueta termine com..',
    'rule_trigger_tag_ends'                               => 'Qualquer etiqueta termine com ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Qualquer etiqueta comece com..',
    'rule_trigger_tag_starts'                             => 'Qualquer etiqueta comece com ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'A moeda da transação é..',
    'rule_trigger_currency_is'                            => 'A moeda da transação é ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'A moeda estrangeira da transação é..',
    'rule_trigger_foreign_currency_is'                    => 'A moeda estrangeira da transação é ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Não tem categoria',
    'rule_trigger_has_no_category'                        => 'A transação não tem categoria',
    'rule_trigger_has_any_category_choice'                => 'Tem (pelo menos) uma categoria',
    'rule_trigger_has_any_category'                       => 'A transação tem (pelo menos) uma categoria',
    'rule_trigger_has_no_budget_choice'                   => 'Não tem orçamento',
    'rule_trigger_has_no_budget'                          => 'A transacção não tem orçamento',
    'rule_trigger_has_any_budget_choice'                  => 'Tem (pelo menos) um orçamento',
    'rule_trigger_has_any_budget'                         => 'A transação tem (pelo menos) um orçamento',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Não tem etiquetas',
    'rule_trigger_has_no_tag'                             => 'A transação não tem etiqueta(s)',
    'rule_trigger_has_any_tag_choice'                     => 'Tem uma ou mais etiquetas (quaisquer)',
    'rule_trigger_has_any_tag'                            => 'A transação tem uma ou mais etiquetas (quaisquer)',
    'rule_trigger_any_notes_choice'                       => 'Tem notas (quaisquer)',
    'rule_trigger_any_notes'                              => 'A transação tem (pelo menos) uma nota',
    'rule_trigger_no_notes_choice'                        => 'Não tem notas',
    'rule_trigger_no_notes'                               => 'A transação não tem notas',
    'rule_trigger_notes_is_choice'                        => 'As notas são..',
    'rule_trigger_notes_is'                               => 'As notas são ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'As notas contêm..',
    'rule_trigger_notes_contains'                         => 'As notas contêm ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'As notas comecam com..',
    'rule_trigger_notes_starts'                           => 'As notas começam com ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'As notas terminam com..',
    'rule_trigger_notes_ends'                             => 'Notas acabam com ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'O ID Externo é..',
    'rule_trigger_external_id_is'                         => 'O ID externo é ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'A referência interna é..',
    'rule_trigger_internal_reference_is'                  => 'A referência interna é ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'O ID do diário de transações é..',
    'rule_trigger_journal_id'                             => 'O ID do diário de transações é ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'A transação tem um (qualquer) URL externo',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'A transação tem um (qualquer) ID externo',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'A transação não tem nenhum URL externo',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'A transação não tem ID externo',
    'rule_trigger_id_choice'                              => 'ID da transação é..',
    'rule_trigger_id'                                     => 'O ID da transação é ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT é..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA TC é ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'A ação de utilizador é ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Nenhuma etiqueta é..',
    'rule_trigger_tag_is_not'                             => 'Nenhuma etiqueta é ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Qualquer uma das contas é exatamente..',
    'rule_trigger_account_is'                             => 'Qualquer uma das contas é exatamente ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Qualquer uma das contas contém..',
    'rule_trigger_account_contains'                       => 'Qualquer uma das contas contém ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Qualquer uma das contas termina com..',
    'rule_trigger_account_ends'                           => 'Qualquer uma das contas termina com ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Qualquer uma das contas começa com..',
    'rule_trigger_account_starts'                         => 'Qualquer uma das contas começa com ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Qualquer um dos números de conta / IBAN é..',
    'rule_trigger_account_nr_is'                          => 'Qualquer um dos números de conta / IBAN ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Qualquer um dos números de conta / IBAN contém..',
    'rule_trigger_account_nr_contains'                    => 'Qualquer um dos números de conta / IBAN contém ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Qualquer um dos números de conta / IBAN termina com..',
    'rule_trigger_account_nr_ends'                        => 'Qualquer um dos números de conta / IBAN termina com ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Qualquer um dos números de conta / IBAN começa com..',
    'rule_trigger_account_nr_starts'                      => 'Qualquer um dos números de conta / IBAN começa com ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'A categoria contém..',
    'rule_trigger_category_contains'                      => 'A categoria contém ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'A categoria termina com..',
    'rule_trigger_category_ends'                          => 'A categoria termina com ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'A categoria começa com..',
    'rule_trigger_category_starts'                        => 'A categoria começa com ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'O orçamento contém..',
    'rule_trigger_budget_contains'                        => 'O orçamento contém ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'O orçamento termina com..',
    'rule_trigger_budget_ends'                            => 'O orçamento termina com ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'O orçamento começa com..',
    'rule_trigger_budget_starts'                          => 'O orçamento começa com ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'O ID externo contém..',
    'rule_trigger_external_id_contains'                   => 'O ID externo contém ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'O ID externo termina com..',
    'rule_trigger_external_id_ends'                       => 'O ID externo termina com ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'O ID externo começa com..',
    'rule_trigger_external_id_starts'                     => 'O ID externo começa com ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'A referência interna contém..',
    'rule_trigger_internal_reference_contains'            => 'A referência interna contém ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'A referência interna termina com..',
    'rule_trigger_internal_reference_ends'                => 'A referência interna termina com ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'A referência interna começa com..',
    'rule_trigger_internal_reference_starts'              => 'A referência interna começa com ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'O URL externo é..',
    'rule_trigger_external_url_is'                        => 'O URL externo é ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'O URL externo contém..',
    'rule_trigger_external_url_contains'                  => 'O URL externo contém ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'O URL externo termina com..',
    'rule_trigger_external_url_ends'                      => 'O URL externo termina com ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'O URL externo começa com..',
    'rule_trigger_external_url_starts'                    => 'O URL externo começa com ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Não tem anexos',
    'rule_trigger_has_no_attachments'                     => 'A transação não tem anexos',
    'rule_trigger_recurrence_id_choice'                   => 'O ID de transação recorrente é..',
    'rule_trigger_recurrence_id'                          => 'O ID de transação recorrente é ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'A data de juros é..',
    'rule_trigger_interest_date_on'                       => 'A data de juros é ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'A data de juros é antes de..',
    'rule_trigger_interest_date_before'                   => 'A data de juros é antes de ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'A data de juros é após..',
    'rule_trigger_interest_date_after'                    => 'A data de juros é após ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'A data de agendamento é..',
    'rule_trigger_book_date_on'                           => 'A data de agendamento é ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'A data de agendamento é anterior a..',
    'rule_trigger_book_date_before'                       => 'A data de agendamento é anterior a ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'A data de agendamento é posterior a..',
    'rule_trigger_book_date_after'                        => 'A data de agendamento é posterior a ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'A data de processamento é..',
    'rule_trigger_process_date_on'                        => 'A data de processamento é ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'A data de processamento é anterior a..',
    'rule_trigger_process_date_before'                    => 'A data de processamento é anterior a ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'A data de processamento é posterior a..',
    'rule_trigger_process_date_after'                     => 'A data de processamento é posterior a ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'A data de vencimento é..',
    'rule_trigger_due_date_on'                            => 'A data de vencimento é ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'A data de vencimento é anterior a..',
    'rule_trigger_due_date_before'                        => 'A data de vencimento é anterior a ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'A data de vencimento é posterior a..',
    'rule_trigger_due_date_after'                         => 'A data de vencimento é posterior a ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'A data de pagamento é..',
    'rule_trigger_payment_date_on'                        => 'A data de pagamento é ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'A data de pagamento é antes de..',
    'rule_trigger_payment_date_before'                    => 'A data de pagamento é antes de ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'A data de pagamento é posterior a..',
    'rule_trigger_payment_date_after'                     => 'A data de pagamento é posterior a ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'A data da fatura é..',
    'rule_trigger_invoice_date_on'                        => 'A data da fatura é ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'A data da fatura é anterior a..',
    'rule_trigger_invoice_date_before'                    => 'A data da fatura é anterior a ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'A data da fatura é posterior a..',
    'rule_trigger_invoice_date_after'                     => 'A data da fatura é posterior a ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'A transação foi criada antes de..',
    'rule_trigger_created_at_before'                      => 'A transação foi criada antes de ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'A transação foi criada depois de..',
    'rule_trigger_created_at_after'                       => 'A transação foi criada depois de ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'A última atualização da transação foi em..',
    'rule_trigger_updated_at_before'                      => 'A última atualização da transação foi em ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'A última atualização da transação foi depois de..',
    'rule_trigger_updated_at_after'                       => 'A última atualização da transação foi depois de ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'O montante em moeda estrangeira é exatamente..',
    'rule_trigger_foreign_amount_is'                      => 'O montante em moeda estrangeira é exatamente ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'O montante em moeda estrangeira é inferior a..',
    'rule_trigger_foreign_amount_less'                    => 'O montante em moeda estrangeira é inferior a ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'O montante em moeda estrangeira é superior a..',
    'rule_trigger_foreign_amount_more'                    => 'O montante em moeda estrangeira é superior a ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'O nome de qualquer anexo é..',
    'rule_trigger_attachment_name_is'                     => 'O nome de qualquer anexo é ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'O nome de qualquer anexo contém..',
    'rule_trigger_attachment_name_contains'               => 'O nome de qualquer anexo contém ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'O nome de qualquer anexo começa com..',
    'rule_trigger_attachment_name_starts'                 => 'O nome de qualquer anexo começa com ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'O nome de qualquer anexo termina com..',
    'rule_trigger_attachment_name_ends'                   => 'O nome de qualquer anexo termina com ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Quaisquer notas de anexo são..',
    'rule_trigger_attachment_notes_are'                   => 'Quaisquer notas de anexo são ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Quaisquer notas de anexo contêm..',
    'rule_trigger_attachment_notes_contains'              => 'Quaisquer notas de anexo contêm ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Quaisquer notas de anexo começam com..',
    'rule_trigger_attachment_notes_starts'                => 'Quaisquer notas de anexo começam com ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Quaisquer notas de anexo terminam com..',
    'rule_trigger_attachment_notes_ends'                  => 'Quaisquer notas de anexo terminam com ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'A transação está reconciliada',
    'rule_trigger_reconciled'                             => 'A transação está reconciliada',
    'rule_trigger_exists_choice'                          => 'Qualquer transação corresponde(!)',
    'rule_trigger_exists'                                 => 'Qualquer transação corresponde',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'O ID da conta não é ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'O ID da conta de origem não é ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'O ID da conta de destino não é ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'O tipo de transação não é ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'A etiqueta não é ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'A etiqueta é ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'A descrição não é ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'A descrição não termina com ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'A descrição não começa com ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'As notas não são ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'As notas não contêm ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'As notas não terminam em ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'As notas não começam com ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'A conta de origem não é ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'A conta de origem não contém ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'A conta de origem não termina em ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'A conta de origem não começa com ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'O número / IBAN da conta de origem não é ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'O número / IBAN da conta de origem não contém ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'O número / IBAN da conta de origem não termina em ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'O número / IBAN da conta de origem não começa com ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'A conta de destino não é ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'A conta de destino não contém ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'A conta de destino não termina em ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'A conta de destino não começa com ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'O número / IBAN da conta de destino não é ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'O número / IBAN da conta de destino não contém ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'O número / IBAN da conta de destino não termina em ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'O número / IBAN da conta de destino não começa com ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Nenhuma das contas é ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Nenhuma das contas contém ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Nenhuma das contas termina em ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Nenhuma das contas começa com ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Nenhum dos números de conta / IBAN é ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Nenhum dos números de conta / IBAN contém ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Nenhum dos números de conta / IBAN termina em ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Nenhum dos números de conta / IBAN começa com ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'A categoria não é ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'A categoria não contém ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'A categoria não termina em ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'A categoria não começa com ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'O orçamento não é ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'O orçamento não contém ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'O orçamento não termina em ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'O orçamento não começa com ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'O ID externo não é ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'O ID externo não contém ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'O ID externo não termina em ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'O ID externo não começa com ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'A referência interna não é ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'A referência interna não contém ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'A referência interna não termina em ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'A referência interna não começa com ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'O URL externo não é ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'O URL externo não contém ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'O URL externo não termina em ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'O URL externo não começa com ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'A moeda não é ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'A moeda estrangeira não é ":trigger_value"',
    'rule_trigger_not_id'                                 => 'O ID da transação não é ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'O ID do diário de transações não é ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'O ID da recorrência não é ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'A data não é ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'A data é anterior a ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'A data não é posterior a ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'A data de juros não é ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'A data de juros não é anterior a ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'A data de juros não é posterior a ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'A data de registo não é ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'A data de registo não é anterior a ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'A data de registo não é posterior a ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'A data de processamento não é ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'A data de processamento não é anterior a ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'A data de processamento não é posterior a ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'A data de vencimento não é ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'A data de vencimento não é anterior a ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'A data de vencimento não é posterior a ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'A data de pagamento não é ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'A data de pagamento não é anterior a ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'A data de pagamento não é posterior a ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'A data da fatura não é ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'A data da fatura não é anterior a ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'A data da fatura não é posterior a ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'A transação não foi criada em ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'A transação não foi criada antes de ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'A transação não foi criada depois de ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'A transação não foi alterada em ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'A transação não foi alterada antes de ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'A transação não foi alterada depois de ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'O montante da transação não é ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'O montante da transação é superior a ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'O montante da transação é inferior a ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'O montante em moeda estrangeira da transação não é ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'O montante em moeda estrangeira da transação é superior a ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'O montante em moeda estrangeira da transação é inferior a ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Nenhum anexo tem o nome: ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Nenhum anexo tem um nome contendo ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Nenhum anexo tem um nome começado por ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Nenhum anexo tem um nome terminado em ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Nenhuma nota de anexo é ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Nenhuma nota de anexo contém ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Nenhuma nota de anexo começa com ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Nenhuma nota de anexo termina em ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'A transação não está reconciliada',
    'rule_trigger_not_exists'                             => 'A transação não existe',
    'rule_trigger_not_has_attachments'                    => 'A transação não tem anexos',
    'rule_trigger_not_has_any_category'                   => 'A transação não tem categoria',
    'rule_trigger_not_has_any_budget'                     => 'Transação não tem orçamento',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'A transação não tem etiquetas',
    'rule_trigger_not_any_notes'                          => 'A transação não tem notas',
    'rule_trigger_not_any_external_url'                   => 'A transação não tem URL externo',
    'rule_trigger_not_has_no_attachments'                 => 'A transação tem (pelo menos) um anexo',
    'rule_trigger_not_has_no_category'                    => 'A transação tem (pelo menos) uma categoria',
    'rule_trigger_not_has_no_budget'                      => 'A transação tem (pelo menos) um orçamento',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'A transação tem (pelo menos) uma etiqueta',
    'rule_trigger_not_no_notes'                           => 'A transação tem pelo menos uma nota',
    'rule_trigger_not_no_external_url'                    => 'A transação tem um URL externo',
    'rule_trigger_not_source_is_cash'                     => 'A conta de origem não é uma conta de caixa',
    'rule_trigger_not_destination_is_cash'                => 'A conta de destino não é uma conta de caixa',
    'rule_trigger_not_account_is_cash'                    => 'Nenhuma das contas é uma conta de caixa',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'APAGAR transação(!)',
    'rule_action_delete_transaction'             => 'APAGAR transação(!)',
    'rule_action_set_category'                   => 'Definir categoria para ":action_value"',
    'rule_action_clear_category'                 => 'Limpar categoria',
    'rule_action_set_budget'                     => 'Definir o orçamento para ":action_value"',
    'rule_action_clear_budget'                   => 'Limpar orçamento',
    'rule_action_add_tag'                        => 'Adicionar etiqueta ":action_value"',
    'rule_action_remove_tag'                     => 'Remover etiqueta ":action_value"',
    'rule_action_remove_all_tags'                => 'Remover todas as etiquetas',
    'rule_action_set_description'                => 'Definir descrição para ":action_value"',
    'rule_action_append_description'             => 'Acrescentar à descrição com ":action_value"',
    'rule_action_prepend_description'            => 'Preceder a descrição com ":action_value"',
    'rule_action_set_category_choice'            => 'Atribuir a categoria..',
    'rule_action_clear_category_choice'          => 'Limpar qualquer categoria',
    'rule_action_set_budget_choice'              => 'Atribuir o orçamento..',
    'rule_action_clear_budget_choice'            => 'Limpar qualquer orçamento',
    'rule_action_add_tag_choice'                 => 'Adicionar etiqueta..',
    'rule_action_remove_tag_choice'              => 'Remover etiqueta..',
    'rule_action_remove_all_tags_choice'         => 'Remover todas as etiquetas',
    'rule_action_set_description_choice'         => 'Atribuir a descrição..',
    'rule_action_update_piggy_choice'            => 'Adicionar / remover montante da transação ao mealheiro..',
    'rule_action_update_piggy'                   => 'Adicionar / remover montante da transação no mealheiro ":action_value"',
    'rule_action_append_description_choice'      => 'Acrescentar ao final da descrição..',
    'rule_action_prepend_description_choice'     => 'Acrescentar ao início da descrição..',
    'rule_action_set_source_account_choice'      => 'Atribuir a conta de origem..',
    'rule_action_set_source_account'             => 'Definir conta de origem para :action_value',
    'rule_action_set_destination_account_choice' => 'Atribuir a conta de destino..',
    'rule_action_set_destination_account'        => 'Definir a conta de destino para :action_value',
    'rule_action_append_notes_choice'            => 'Acrescentar ao final das notas..',
    'rule_action_append_notes'                   => 'Anexar notas com ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Preceder notas com..',
    'rule_action_prepend_notes'                  => 'Preceder notas com ":action_value"',
    'rule_action_clear_notes_choice'             => 'Remover todas as notas',
    'rule_action_clear_notes'                    => 'Remover todas as notas',
    'rule_action_set_notes_choice'               => 'Atribuir as notas..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Trocar a conta de origem e de destino (apenas para transferências!)',
    'rule_action_switch_accounts'                => 'Trocar origem e destino',
    'rule_action_set_notes'                      => 'Defina notas para ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Converter a transação num depósito',
    'rule_action_convert_deposit'                => 'Converter a transação para um depósito a partir de ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Converter a transação num levantamento',
    'rule_action_convert_withdrawal'             => 'Converter a transação num levantamento de ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Converter a transação numa transferência',
    'rule_action_convert_transfer'               => 'Converter a transação para uma transferência com ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Acrescentar a descrição às notas da transação',
    'rule_action_append_notes_to_descr_choice'   => 'Acrescentar as notas da transação à descrição',
    'rule_action_move_descr_to_notes_choice'     => 'Substituir as atuais notas da transação pela descrição',
    'rule_action_move_notes_to_descr_choice'     => 'Substituir a atual descrição pelas notas da transação',
    'rule_action_append_descr_to_notes'          => 'Acrescentar descrição às notas',
    'rule_action_append_notes_to_descr'          => 'Acrescentar notas à descrição',
    'rule_action_move_descr_to_notes'            => 'Substituir notas por descrição',
    'rule_action_move_notes_to_descr'            => 'Substituir descrição por notas',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Definir a conta de destino para (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Definir a conta de origem para (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Regra baseada na transação ":description"',
    'new_rule_for_journal_description'          => 'A regra é baseada na transação ":description". Ou seja, a regra vai ser aplicada a todas as transações iguais.',

    // tags
    'store_new_tag'                             => 'Gravar nova etiqueta',
    'update_tag'                                => 'Atualizar etiqueta',
    'no_location_set'                           => 'Sem localização definida.',
    'meta_data'                                 => 'Meta dados',
    'location'                                  => 'Localização',
    'location_first_split'                      => 'O local desta transação pode ser definido na primeira divisão desta transação.',
    'without_date'                              => 'Sem data',
    'result'                                    => 'Resultado',
    'sums_apply_to_range'                       => 'Todas as somas aplicam-se ao intervalo selecionado',
    'mapbox_api_key'                            => 'Para usar o mapa, arranje uma chave de API do <a href="https://www.mapbox.com/">Mapbox</a>. Abra o seu ficheiro <code>.env</code> e adicione essa chave a seguir a <code> MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Clique com o botão direito ou pressione longamente para definir o local do objeto.',
    'click_tap_location'                        => 'Carregue ou clique no mapa para adicionar uma localização',
    'clear_location'                            => 'Limpar localização',
    'delete_all_selected_tags'                  => 'Excluir todas as etiquetas selecionadas',
    'select_tags_to_delete'                     => 'Não se esqueça de selecionar algumas etiquetas.',
    'deleted_x_tags'                            => 'Apagada :count etiqueta.|Apagadas :count etiquetas.',
    'create_rule_from_transaction'              => 'Criar regra com base na transação',
    'create_recurring_from_transaction'         => 'Criar transação recorrente com base na transação',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Deixe o seu navegador decidir',
    'dark_mode_option_light'                    => 'Sempre claro',
    'dark_mode_option_dark'                     => 'Sempre escuro',
    'equal_to_language'                         => '(igual ao idioma)',
    'dark_mode_preference'                      => 'Modo escuro',
    'dark_mode_preference_help'                 => 'Diga ao Firefly III quando usar o modo escuro.',
    'pref_home_screen_accounts'                 => 'Contas do ecrã inicial',
    'pref_home_screen_accounts_help'            => 'Que contas devem ser mostradas na página principal?',
    'pref_view_range'                           => 'Ver intervalo',
    'pref_view_range_help'                      => 'Alguns gráficos são automaticamente agrupados por períodos. Os seus orçamentos serão também agrupados em períodos. Que período prefere?',
    'pref_1D'                                   => 'Um dia',
    'pref_1W'                                   => 'Uma semana',
    'pref_1M'                                   => 'Um mês',
    'pref_3M'                                   => 'Três meses (trimestre)',
    'pref_6M'                                   => 'Seis meses',
    'pref_1Y'                                   => 'Um ano',
    'pref_last365'                              => 'No ano passado',
    'pref_last90'                               => 'Últimos 90 dias',
    'pref_last30'                               => 'Últimos 30 dias',
    'pref_last7'                                => 'Últimos 7 dias',
    'pref_YTD'                                  => 'Ano corrente',
    'pref_QTD'                                  => 'Trimestre corrente',
    'pref_MTD'                                  => 'Mês corrente',
    'pref_languages'                            => 'Idiomas',
    'pref_locale'                               => 'Definições regionais',
    'pref_languages_help'                       => 'O Firefly III suporta vários idiomas. Qual prefere?',
    'pref_locale_help'                          => 'O Firefly III permite definir configurações regionais, tais como o formato das moedas, números ou datas. Os elementos nesta lista podem não ser suportados pelo seu sistema. O Firefly III não têm as definições de datas corretas para todos as regiões; contacte-me para melhorias.',
    'pref_locale_no_demo'                       => 'Esta funcionalidade não funciona para o utilizador de demonstração.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Definições do ano fiscal',
    'pref_custom_fiscal_year_label'             => 'Ativado',
    'pref_custom_fiscal_year_help'              => 'Para países que usam ano fiscal diferente de 1 de janeiro a 31 de dezembro, pode alterar estas datas para começarem em acabarem nos dias de início e fim corretos',
    'pref_fiscal_year_start_label'              => 'Data de início do ano fiscal',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Não se esqueça de remover a conta da sua aplicação de autenticação!',
    'pref_two_factor_auth_code'                 => 'Código de verificação',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Repor código de verificação',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'Se não conseguir ler o código QR, sinta-se livre de utilizar um segredo em alternativa: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Guarde estes códigos de backup para acesso, caso perca o seu dispositivo.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Esse código MFA não é válido.',
    'pref_save_settings'                        => 'Guardar definições',
    'saved_preferences'                         => 'Preferências guardadas!',
    'preferences_general'                       => 'Geral',
    'preferences_frontpage'                     => 'Ecrã inicial',
    'preferences_security'                      => 'Segurança',
    'preferences_layout'                        => 'Disposição',
    'preferences_notifications'                 => 'Notificações',
    'pref_home_show_deposits'                   => 'Mostrar depósitos no ecrã inicial',
    'pref_home_show_deposits_info'              => 'O ecrã inicial já mostra as contas de despesas. Deveria também mostrar as receitas?',
    'pref_home_do_show_deposits'                => 'Sim, mostrar',
    'successful_count'                          => 'dos quais :count bem sucedido(s)',
    'list_page_size_title'                      => 'Tamanho da página',
    'list_page_size_help'                       => 'Qualquer lista de coisas (contas, transações, etc.) mostra, no máximo, este número por página.',
    'list_page_size_label'                      => 'Tamanho da página',
    'between_dates'                             => '(:start e :end)',
    'pref_optional_fields_transaction'          => 'Campos opcionais para transacções',
    'pref_optional_fields_transaction_help'     => 'Por defeito, nem todos os campos estão habilitados ao criar uma nova transacção (para não atrapalhar). Abaixo, pode habilitar os campos se achar que eles podem lhe úteis. Claro, qualquer campo que estiver desabilitado, mas já preenchido, será visível independente da configuração.',
    'optional_tj_date_fields'                   => 'Campos de data',
    'optional_tj_other_fields'                  => 'Outros campos',
    'optional_tj_attachment_fields'             => 'Campos de anexo',
    'pref_optional_tj_interest_date'            => 'Data de juros',
    'pref_optional_tj_book_date'                => 'Data do agendamento',
    'pref_optional_tj_process_date'             => 'Data de processamento',
    'pref_optional_tj_due_date'                 => 'Data de vencimento',
    'pref_optional_tj_payment_date'             => 'Data de pagamento',
    'pref_optional_tj_invoice_date'             => 'Data da fatura',
    'pref_optional_tj_internal_reference'       => 'Referência interna',
    'pref_optional_tj_notes'                    => 'Notas',
    'pref_optional_tj_attachments'              => 'Anexos',
    'pref_optional_tj_external_url'             => 'URL externo',
    'pref_optional_tj_location'                 => 'Localização',
    'pref_optional_tj_links'                    => 'Links transacionais',
    'optional_field_meta_dates'                 => 'Datas',
    'optional_field_meta_business'              => 'Empresariais',
    'optional_field_attachments'                => 'Anexos',
    'optional_field_meta_data'                  => 'Meta data opcional',
    'external_url'                              => 'URL Externo',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Alerta quando é criado um token da API',
    'pref_notification_transaction_creation'    => 'Alerta quando é criada uma transação de forma automática',
    'pref_notification_user_login'              => 'Alerta quando inicia sessão a partir de uma nova localização',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Notificações',
    'pref_notifications_help'                   => 'Diga se não quiser receber algumas destas notificações. Algumas notificações podem conter informação financeira sensível.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Administração financeira',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Purgue dados do Firefly III',
    'purge_data_expl'                           => '"Purgar" significa "apagar o que já foi apagado". Em circunstâncias normais, o Firefly III não apaga nada de forma definitiva. Apenas esconde. O botão abaixo apaga todos esses registos anteriormente "apagados" PARA SEMPRE.',
    'delete_stuff_header'                       => 'Apagar e purgar dados',
    'purge_all_data'                            => 'Purgar todos os registos apagados',
    'purge_data'                                => 'Purgar dados',
    'purged_all_records'                        => 'Todos os registos apagados foram purgados.',
    'delete_data_title'                         => 'Apagar dados do Firefly III',
    'permanent_delete_stuff'                    => 'Pode apagar coisas do Firefly III. Usando os botões abaixo fará com que os seus itens sejam removidos da visualização e escondidos. Não há botão de anular para isto, mas os itens permanecem na base de dados e poderá recuperá-los se necessário.',
    'other_sessions_logged_out'                 => 'Todas as outras sessões foram desconectadas.',
    'delete_unused_accounts'                    => 'Apagar contas não utilizadas irá limpar as suas listas de preenchimento automático.',
    'delete_all_unused_accounts'                => 'Apagar contas não utilizadas',
    'deleted_all_unused_accounts'               => 'Todas as contas não usadas foram apagadas',
    'delete_all_budgets'                        => 'Apagar TODOS os orçamentos',
    'delete_all_categories'                     => 'Apagar TODAS as categorias',
    'delete_all_tags'                           => 'Apagar TODAS as etiquetas',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Apagar todos os mealheiros',
    'delete_all_rules'                          => 'Apagar TODAS as regras',
    'delete_all_recurring'                      => 'Apagar TODAS as transacções recorrentes',
    'delete_all_object_groups'                  => 'Apagar TODOS os grupos de objectos',
    'delete_all_accounts'                       => 'Apagar TODAS as contas',
    'delete_all_asset_accounts'                 => 'Apagar TODAS as contas de activos',
    'delete_all_expense_accounts'               => 'Apagar TODAS as contas de despesas',
    'delete_all_revenue_accounts'               => 'Apagar TODOS as contas de receita',
    'delete_all_liabilities'                    => 'Apagar TODOS os passivos',
    'delete_all_transactions'                   => 'Apagar TODAS as suas transacções',
    'delete_all_withdrawals'                    => 'Apagar TODOS os levantamentos',
    'delete_all_deposits'                       => 'Apagar TODOS os depósitos',
    'delete_all_transfers'                      => 'Apagar TODOS as transferências',
    'also_delete_transactions'                  => 'Apagar a conta também apaga TODOS os levantamentos, depósitos e transferências associadas!',
    'deleted_all_budgets'                       => 'Todos os orçamentos foram apagados',
    'deleted_all_categories'                    => 'Todas as categorias foram apagadas',
    'deleted_all_tags'                          => 'Todas as etiquetas foram apagadas',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Todos os mealheiros foram apagados',
    'deleted_all_rules'                         => 'Todas as regras e grupos de regras foram apagadas',
    'deleted_all_object_groups'                 => 'Todos os grupos foram apagados',
    'deleted_all_accounts'                      => 'Todas as contas foram apagadas',
    'deleted_all_asset_accounts'                => 'Todas as contas de ativos foram apagadas',
    'deleted_all_expense_accounts'              => 'Todas as contas de despesas foram apagadas',
    'deleted_all_revenue_accounts'              => 'Todas as contas de receita foram apagadas',
    'deleted_all_liabilities'                   => 'Todos os passivos foram apagados',
    'deleted_all_transactions'                  => 'Todas as transacções foram apagadas',
    'deleted_all_withdrawals'                   => 'Todas os levantamentos foram apagados',
    'deleted_all_deposits'                      => 'Todos os depósitos foram apagados',
    'deleted_all_transfers'                     => 'Todas as transferências foram apagadas',
    'deleted_all_recurring'                     => 'Todas as transacções recorrentes foram apagadas',
    'change_your_password'                      => 'Altere a sua palavra-passe',
    'delete_account'                            => 'Apagar conta de utilizador',
    'current_password'                          => 'Palavra-passe atual',
    'new_password'                              => 'Nova palavra-passe',
    'new_password_again'                        => 'Nova palavra-passe (novamente)',
    'delete_your_account'                       => 'Apagar a conta',
    'delete_your_account_help'                  => 'Apagar a sua conta Firefly III apaga também todas as contas, transações, <em>tudo</em> o que está guardado no Firefly III. Isso será perdido.',
    'delete_your_account_password'              => 'Introduza a sua palavra-passe para continuar.',
    'password'                                  => 'Palavra-passe',
    'are_you_sure'                              => 'Tem a certeza? Não pode anular esta ação.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'APAGAR a sua conta',
    'invalid_current_password'                  => 'Palavra-passe atual inválida!',
    'password_changed'                          => 'Palavra-passe alterada!',
    'should_change'                             => 'A ideia é alterar palavra-passe.',
    'invalid_password'                          => 'Palavra-passe inválida!',
    'what_is_pw_security'                       => 'O que é "verificar segurança da palavra-passe"?',
    'secure_pw_title'                           => 'Como escolher uma palavra-passe segura',
    'forgot_password_response'                  => 'Obrigado. Se existir uma conta com este endereço de email, encontrará as instruções na sua caixa de entrada.',
    'secure_pw_history'                         => 'Não há semana em que não se leia nas notícias sobre sites perderem as palavras-passe dos utilizadores. Hackers e ladrões usam essas palavras-passe para tentar roubar a sua informação pessoal. Essa informação é valiosa.',
    'secure_pw_ff'                              => 'Utiliza a mesma palavra-passe para tudo na Internet? Se um site perder a sua palavra-passe, os hackers ganham acesso a todos os seus dados. O Firefly III depende de uma palavra-passe forte e única para poder proteger toda a sua informação financeira.',
    'secure_pw_check_box'                       => 'Para ajudá-lo o Firefly III pode verificar se a palavra-passe que pretende usar já foi roubada no passado. Se for esse o caso, o Firefly III recomenda que não a utilize.',
    'secure_pw_working_title'                   => 'Como funciona?',
    'secure_pw_working'                         => 'Ao marcar a caixa, o Firefly III enviará os cinco primeiros carateres do hash SHA1 da sua palavra-passe para <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">o website Troy Hunt</a> para confirmar se está na lista. Assim consegue impedi-lo de usar palavras-passe inseguras, como é recomendado na última <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">publicação NIST Special</a> sobre o assunto.',
    'secure_pw_should'                          => 'Devo marcar a caixa?',
    'secure_pw_long_password'                   => 'Sim. Verifique sempre se a sua palavra-passe é segura.',
    'command_line_token'                        => 'Token de linha de comando',
    'explain_command_line_token'                => 'É necessário um token para executar opções de linha de comando, tais como exportar dados. Sem isso, os comandos inseridos não funcionarão. Não partilhe o seu token da linha de comandos com ninguém. Nunca ninguém, nem mesmo eu, alguma vez lhe pediremos esse token. Se sentir que o perdeu, ou se sentir paranoico, pode substituir o mesmo usando o botão.',
    'regenerate_command_line_token'             => 'Recriar token de linha de comando',
    'token_regenerated'                         => 'Um novo token de linha de comando foi criado',
    'change_your_email'                         => 'Alterar o seu email',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Até verificar o seu endereço de e-mail, não poderá iniciar sessão.',
    'login_with_new_email'                      => 'Agora já pode iniciar sessão com o seu novo endereço de e-mail.',
    'login_with_old_email'                      => 'Já pode iniciar sessão com o seu endereço de email antigo.',
    'login_provider_local_only'                 => 'Esta ação não está disponível ao autenticar através de ":login_provider".',
    'external_user_mgt_disabled'                => 'Esta ação não está disponível quando o Firefly III não é responsável pela gestão de utilizadores ou autenticação.',
    'external_auth_disabled'                    => 'Esta ação não está disponível quando o Firefly III não é responsável pela autenticação.',
    'delete_local_info_only'                    => "Como o Firefly III não é responsável pela gestão de utilizadores ou autenticação, esta função apenas apaga informações locais do Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Clientes OAuth',
    'profile_oauth_no_clients'                  => 'Não criou nenhum cliente OAuth.',
    'profile_oauth_clients_external_auth'       => 'Se estivar a usar um provedor de autenticação externo, como o Authelia, os clientes OAuth não funcionarão. Só pode usar Tokens de Acesso Pessoal.',
    'profile_oauth_clients_header'              => 'Clientes',
    'profile_oauth_client_id'                   => 'ID do Cliente',
    'profile_oauth_client_name'                 => 'Nome',
    'profile_oauth_client_secret'               => 'Segredo',
    'profile_oauth_create_new_client'           => 'Criar Novo Cliente',
    'profile_oauth_create_client'               => 'Criar Cliente',
    'profile_oauth_edit_client'                 => 'Editar Cliente',
    'profile_oauth_name_help'                   => 'Algo que os utilizadores reconheçam e confiem.',
    'profile_oauth_redirect_url'                => 'URL de redirecionamento',
    'profile_oauth_redirect_url_help'           => 'URL de callback de autorização da aplicação.',
    'profile_authorized_apps'                   => 'Aplicações autorizadas',
    'profile_authorized_clients'                => 'Clientes autorizados',
    'profile_scopes'                            => 'Contextos',
    'profile_revoke'                            => 'Revogar',
    'profile_oauth_client_secret_title'         => 'Segredo do cliente',
    'profile_oauth_client_secret_expl'          => 'Aqui está o seu segredo de cliente. Apenas estará visível uma vez, portanto não o perca! Pode agora utilizar este segredo para fazer pedidos à API.',
    'profile_personal_access_tokens'            => 'Tokens de acesso pessoal',
    'profile_personal_access_token'             => 'Token de acesso pessoal',
    'profile_oauth_confidential'                => 'Confidencial',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Aqui está o seu novo token de acesso pessoal. Esta é a única vez que será mostrado, portanto, não o perca! Pode usá-lo para fazer pedidos à API.',
    'profile_no_personal_access_token'          => 'Ainda não criou tokens de acesso pessoal.',
    'profile_create_new_token'                  => 'Criar novo token',
    'profile_create_token'                      => 'Criar token',
    'profile_create'                            => 'Criar',
    'profile_save_changes'                      => 'Guardar alterações',
    'profile_whoops'                            => 'Oops!',
    'profile_something_wrong'                   => 'Algo correu mal!',
    'profile_try_again'                         => 'Algo correu mal. Por favor, tente novamente.',
    'amounts'                                   => 'Montantes',
    'multi_account_warning_unknown'             => 'Dependendo do tipo de transação que criar, a conta de origem e/ou destino de subsequentes divisões pode ser sobrescrita pelo que estiver definido na primeira divisão da transação.',
    'multi_account_warning_withdrawal'          => 'Tenha presente que a conta de origem de divisões subsequentes será sobrescrita pelo que estiver definido na primeira divisão do levantamento.',
    'multi_account_warning_deposit'             => 'Tenha presente que a conta de destino de divisões subsequentes será sobrescrita pelo que estiver definida na primeira divisão do depósito.',
    'multi_account_warning_transfer'            => 'Tenha presenta que a conta de origem + destino de divisões subsequentes serão sobrescritas pelo que estiver definido na primeira divisão da transferência.',


    // export data:
    'export_data_title'                         => 'Exportar dados do Firefly III',
    'export_data_menu'                          => 'Exportar dados',
    'export_data_bc'                            => 'Exportar dados do Firefly III',
    'export_data_main_title'                    => 'Exportar dados do Firefly III',
    'export_data_expl'                          => 'Esta hiperligação permite-lhe exportar todas as transações e os meta dados do Firefly III. Por favor, consulte a ajuda (canto superior direito ícone-(?)) para obter mais informações sobre o processo.',
    'export_data_all_transactions'              => 'Exportar todas as transações',
    'export_data_advanced_expl'                 => 'Se precisar de um tipo mais específico ou avançado de exportação, leia a ajuda sobre como usar o comando da consola <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Um anexo|:count anexos',
    'attachments'                               => 'Anexos',
    'edit_attachment'                           => 'Alterar anexo ":name"',
    'update_attachment'                         => 'Atualizar anexo',
    'delete_attachment'                         => 'Apagar anexo ":name"',
    'attachment_deleted'                        => 'Anexo apagado ":name"',
    'liabilities_deleted'                       => 'Passivo apagado ":name"',
    'attachment_updated'                        => 'Anexo alterado ":name"',
    'upload_max_file_size'                      => 'Tamanho maximo do ficheiro: :size',
    'list_all_attachments'                      => 'Lista de todos os anexos',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Despesas',
    'title_withdrawal'                          => 'Despesas',
    'title_revenue'                             => 'Receita / rendimento',
    'title_deposit'                             => 'Receita / rendimento',
    'title_transfer'                            => 'Transferências',
    'title_transfers'                           => 'Transferências',
    'submission_options'                        => 'Opções de submissão',
    'apply_rules_checkbox'                      => 'Aplicar regras',
    'fire_webhooks_checkbox'                    => 'Ativar webhooks',
    'select_source_account'                     => 'Por favor, selecione ou digite um nome de conta válido',
    'select_dest_account'                       => 'Por favor, selecione ou digite um nome de conta destinatária válida',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Esta transação já e um levantamento',
    'convert_is_already_type_Deposit'           => 'Esta transação já e um depósito',
    'convert_is_already_type_Transfer'          => 'Esta transação já é uma transferência',
    'convert_to_Withdrawal'                     => 'Converter ":description" num levantamento',
    'convert_to_Deposit'                        => 'Converter ":description" num depósito',
    'convert_to_Transfer'                       => 'Converter ":description" numa transferência',
    'convert_options_WithdrawalDeposit'         => 'Converter um levantamento num depósito',
    'convert_options_WithdrawalTransfer'        => 'Converter um levantamento numa transferência',
    'convert_options_DepositTransfer'           => 'Converter um depósito numa transferência',
    'convert_options_DepositWithdrawal'         => 'Converter um depósito num levantamento',
    'convert_options_TransferWithdrawal'        => 'Converter uma transferência num levantamento',
    'convert_options_TransferDeposit'           => 'Converter uma transferência num depósito',
    'convert_Withdrawal_to_deposit'             => 'Converter este levantamento num depósito',
    'convert_Withdrawal_to_transfer'            => 'Converter este levantamento numa transferência',
    'convert_Deposit_to_withdrawal'             => 'Converter este depósito num levantamento',
    'convert_Deposit_to_transfer'               => 'Converter este depósito numa transferência',
    'convert_Transfer_to_deposit'               => 'Converter esta transferência num depósito',
    'convert_Transfer_to_withdrawal'            => 'Converter esta transferência num levantamento',
    'convert_please_set_revenue_source'         => 'Por favor, selecione a conta de receitas de onde sairá o dinheiro.',
    'convert_please_set_asset_destination'      => 'Por favor, escolha a conta de ativos para a qual irá o dinheiro.',
    'convert_please_set_expense_destination'    => 'Por favor, escolha a conta de despesas para a qual irá o dinheiro.',
    'convert_please_set_asset_source'           => 'Por favor, escolha a conta de ativos de onde sairá o dinheiro.',
    'convert_expl_w_d'                          => 'Ao converter um levantamento num depósito, o dinheiro será depositado na conta de destino exibida, em vez de ser retirado. Ao converter um levantamento num depósito, o dinheiro será depositado nas contas de destino exibidas, em vez de ser retirado.',
    'convert_expl_w_t'                          => 'Ao converter um levantamento numa transferência, o dinheiro será transferido para fora da conta de origem para outra conta de ativos ou passivos em vez de ser gasto na conta de despesa original.|Ao converter um levantamento numa transferência, o dinheiro será transferido das contas de origem para outras contas de activos ou passivos em vez de ser gasto nas contas de despesas originais.',
    'convert_expl_d_w'                          => 'Quando converter um depósito num levantamento, o dinheiro será retirado da conta de origem exibida, em vez de ser depositado na mesma.|Quando converter um depósito num levantamento, o dinheiro será retirado das contas de origem exibidas, em vez de ser depositado nas mesmas.',
    'convert_expl_d_t'                          => 'Quando converter um depósito numa transferência, o dinheiro será depositado na conta de destino listada, de qualquer uma das suas conta de ativos ou passivos.|Quando converter um depósito numa transferência, o dinheiro será depositado nas contas de destino listadas de qualquer uma das suas contas de ativos ou passivos.',
    'convert_expl_t_w'                          => 'Quando converter uma transferência num levantamento, o dinheiro será gasto na conta de destino que definiu aqui, em vez de ser transferido para fora.|Quando converter uma transferência num levantamento, o dinheiro será gasto nas contas de destino que definiu aqui, em vez de ser transferido para fora.',
    'convert_expl_t_d'                          => 'Ao converter uma transferência num depósito, o dinheiro será depositado na conta de destino que vê aqui, em vez de ser transferido para lá.| Ao converter uma transferência em depósito, o dinheiro será depositado nas contas de destino que vê aqui, em vez de ser transferido para elas.',
    'convert_select_sources'                    => 'Para completar a conversão, por favor defina a nova conta de origem abaixo.|Para completar a conversão, por favor defina as novas contas de origem abaixo.',
    'convert_select_destinations'               => 'Para completar a conversão, por favor selecione a nova conta de destino abaixo.|Para completar a conversão, por favor selecione as novas contas de destino abaixo.',
    'converted_to_Withdrawal'                   => 'A transação foi convertida num levantamento',
    'converted_to_Deposit'                      => 'A transação foi convertida num depósito',
    'converted_to_Transfer'                     => 'A transação foi convertida numa transferência',
    'invalid_convert_selection'                 => 'A conta que selecionou já está em uso nas transações ou não existe.',
    'source_or_dest_invalid'                    => 'Não foi possível encontrar os detalhes corretos da transação. A conversão não é possível.',
    'convert_to_withdrawal'                     => 'Converter para levantamento',
    'convert_to_deposit'                        => 'Converter para depósito',
    'convert_to_transfer'                       => 'Converter para uma transferência',

    // create new stuff:
    'create_new_withdrawal'                     => 'Criar novo levantamento',
    'create_new_deposit'                        => 'Criar novo depósito',
    'create_new_transfer'                       => 'Criar nova transferência',
    'create_new_asset'                          => 'Criar nova conta de activos',
    'create_new_liabilities'                    => 'Criar novo passivo',
    'create_new_expense'                        => 'Criar nova conta de despesas',
    'create_new_revenue'                        => 'Criar nova conta de receitas',
    'create_new_piggy_bank'                     => 'Criar mealheiro',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Criar uma nova subscrição',
    'create_new_rule'                           => 'Criar regra nova',

    // currencies:
    'create_currency'                           => 'Criar uma nova moeda',
    'store_currency'                            => 'Guardar nova moeda',
    'update_currency'                           => 'Atualizar moeda',
    'new_default_currency'                      => '":name" passou a ser a moeda padrão.',
    'default_currency_failed'                   => 'Não foi possível fazer ":name" a moeda padrão. Por favor, verifique os logs de erro.',
    'cannot_delete_currency'                    => 'Não é possível apagar :name porque ainda está em uso.',
    'cannot_delete_fallback_currency'           => ':name é a moeda de reserva do sistema e não pode ser apagada.',
    'cannot_disable_currency_journals'          => 'Não é possível desativar :name porque ainda há transações a usa-la.',
    'cannot_disable_currency_last_left'         => 'Não é possível desativar :name porque é a única moeda ativada.',
    'cannot_disable_currency_account_meta'      => 'Não é possível desactivar :name porque ele é utilizado em contas de activos.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Não é possível desativar :name porque é utilizado em transações recorrentes.',
    'cannot_disable_currency_available_budgets' => 'Não é possível desativar :name porque é utilizado nos orçamentos disponíveis.',
    'cannot_disable_currency_budget_limits'     => 'Não é possível desativar :name porque está a ser usado nos limites de orçamento.',
    'cannot_disable_currency_current_default'   => 'Não é possível desactivar :name porque é a moeda padrão atual.',
    'cannot_disable_currency_system_fallback'   => 'Não é possível desactivar :name porque é a moeda padrão do sistema.',
    'disable_EUR_side_effects'                  => 'O Euro é a moeda de reserva no caso de emergência no sistema. Desativa-la pode trazer efeitos secundários não desejáveis e pode anular a sua garantia.',
    'deleted_currency'                          => 'Moeda :name apagada',
    'created_currency'                          => 'Moeda :name criada',
    'could_not_store_currency'                  => 'Não foi possível guardar a nova moeda.',
    'updated_currency'                          => 'Moeda :name atualizada',
    'ask_site_owner'                            => 'Por favor, peça ao :owner para adicionar, remover ou editar moedas.',
    'currencies_intro'                          => 'O Firefly III suporta várias moedas que pode definir e ativar aqui.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Tornar predefinido',
    'default_currency'                          => 'padrão',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Desativado',
    'enable_currency'                           => 'Ativar',
    'disable_currency'                          => 'Desativar',
    'currencies_default_disabled'               => 'A maioria destas moedas está desativada por defeito. Para poder usá-las, tem de as ativar primeiro.',
    'currency_is_now_enabled'                   => 'A moeda ":name" foi ativada',
    'could_not_enable_currency'                 => 'Não foi possível habilitar a moeda ":name". Por favor, verifique os logs.',
    'currency_is_now_disabled'                  => 'A moeda ":name" foi desativada',
    'could_not_disable_currency'                => 'Não foi possível desativar a moeda ":name". Talvez ainda esteja em uso?',

    // forms:
    'mandatoryFields'                           => 'Campos obrigatórios',
    'optionalFields'                            => 'Campos opcionais',
    'options'                                   => 'Opções',

    // budgets:
    'daily_budgets'                             => 'Orçamentos diários',
    'weekly_budgets'                            => 'Orçamentos semanais',
    'monthly_budgets'                           => 'Orçamentos mensais',
    'quarterly_budgets'                         => 'Orçamentos trimestrais',
    'half_year_budgets'                         => 'Orçamentos semestrais',
    'yearly_budgets'                            => 'Orçamentos anuais',
    'other_budgets'                             => 'Orçamentos de período personalizado',
    'budget_limit_not_in_range'                 => 'Esta montante aplica-se de :start a :end:',
    'total_available_budget'                    => 'Orçamento total disponível (entre :start e :end)',
    'total_available_budget_in_currency'        => 'Orçamento total disponível em :currency',
    'see_below'                                 => 'ver abaixo',
    'create_new_budget'                         => 'Criar um novo orçamento',
    'store_new_budget'                          => 'Guardar novo orçamento',
    'stored_new_budget'                         => 'Novo orçamento ":name" guardado',
    'available_between'                         => 'Disponível entre :start e :end',
    'transactionsWithoutBudget'                 => 'Despesas sem orçamento',
    'transactions_no_budget'                    => 'Despesas sem orçamento entre :start e :end',
    'spent_between'                             => 'Já gasto entre :start e :end',
    'spent_between_left'                        => 'Gastou :spent entre :start e :end, sobrando :left.',
    'set_available_amount'                      => 'Definir montante disponível',
    'update_available_amount'                   => 'Atualizar montante disponível',
    'ab_basic_modal_explain'                    => 'Use este formulário para indicar quanto espera conseguir orçamentar (no total, em :currency) no período indicado.',
    'createBudget'                              => 'Novo orçamento',
    'invalid_currency'                          => 'Esta é uma moeda inválida',
    'invalid_amount'                            => 'Por favor, insira um montante',
    'set_ab'                                    => 'O montante do orçamento disponível foi definido',
    'updated_ab'                                => 'O montante do orçamento disponível foi atualizado',
    'deleted_ab'                                => 'O montante do orçamento disponível foi apagado',
    'deleted_bl'                                => 'O montante orçamentado foi retirado',
    'alt_currency_ab_create'                    => 'Definir o orçamento disponível noutra moeda',
    'bl_create_btn'                             => 'Definir orçamento noutra moeda',
    'inactiveBudgets'                           => 'Orçamentos inativos',
    'without_budget_between'                    => 'Transações sem orçamento entre :start e :end',
    'delete_budget'                             => 'Apagar orçamento ":name"',
    'deleted_budget'                            => 'Orçamento ":name" apagado',
    'edit_budget'                               => 'Editar orçamento ":name"',
    'updated_budget'                            => 'Orçamento ":name" apagado',
    'update_amount'                             => 'Atualizar montante',
    'update_budget'                             => 'Atualizar orçamento',
    'update_budget_amount_range'                => 'Atualizar o valor (esperado) disponível entre :start e :end',
    'set_budget_limit_title'                    => 'Definir montante orçado para o orçamento :budget entre :start e :end',
    'set_budget_limit'                          => 'Definir montante orçamentado',
    'budget_period_navigator'                   => 'Navegador de período',
    'info_on_available_amount'                  => 'O que tenho disponível?',
    'available_amount_indication'               => 'Utilize estes valores para obter uma indicação do que seu orçamento total poderia ser.',
    'suggested'                                 => 'Sugerido',
    'average_between'                           => 'Media entre :start e :end',
    'transferred_in'                            => 'Transferido (para)',
    'transferred_away'                          => 'Transferido (de)',
    'auto_budget_none'                          => 'Sem orçamento automático',
    'auto_budget_reset'                         => 'Defina um valor fixo em cada período',
    'auto_budget_rollover'                      => 'Adicionar um montante a cada período',
    'auto_budget_adjusted'                      => 'Adicionar um montante todos os períodos e corrigir para gastos excessivos',
    'auto_budget_period_daily'                  => 'Diariamente',
    'auto_budget_period_weekly'                 => 'Semanalmente',
    'auto_budget_period_monthly'                => 'Mensalmente',
    'auto_budget_period_quarterly'              => 'Trimestralmente',
    'auto_budget_period_half_year'              => 'Semestralmente',
    'auto_budget_period_yearly'                 => 'Anualmente',
    'auto_budget_help'                          => 'Pode saber mais sobre esta funcionalidade na ajuda. Carregue no ícone(?) no canto superior direito.',
    'auto_budget_reset_icon'                    => 'Este orçamento será definido periodicamente',
    'auto_budget_rollover_icon'                 => 'O montante do orçamento irá aumentar periodicamente',
    'auto_budget_adjusted_icon'                 => 'O montante orçamentado aumentará periodicamente e será corrigido por gastos excessivos',
    'remove_budgeted_amount'                    => 'Remover montante orçamentado em :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Subscrição',
    'not_expected_period'                       => 'Este período não foi previsto',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Não (ainda)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Repete',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Transações ligadas entre si',
    'auto_match_on'                             => 'Correspondido automaticamente pelo Firefly III',
    'auto_match_off'                            => 'Não correspondido automaticamente pelo Firefly III',
    'next_expected_match'                       => 'Próxima correspondência esperada',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Mais',
    'rescan_old'                                => 'Executar regras novamente, em todas as transações',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Previsto entre :start e :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'passar à frente',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'regra inativa',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Esperado :date',
    'bill_expected_date_js'                     => 'Esperado {date}',
    'expected_amount'                           => '(Esperado) montante',
    'bill_paid_on'                              => 'Pago a {date}',
    'bill_repeats_weekly'                       => 'Repete-se semanalmente',
    'bill_repeats_monthly'                      => 'Repete mensalmente',
    'bill_repeats_quarterly'                    => 'Repete trimestralmente',
    'bill_repeats_half-year'                    => 'Repete-se a cada meio ano',
    'bill_repeats_yearly'                       => 'Repete-se anualmente',
    'bill_repeats_weekly_other'                 => 'Repete-se a cada semana',
    'bill_repeats_monthly_other'                => 'Repete-se a cada outro mês',
    'bill_repeats_quarterly_other'              => 'Repete-se a cada trimestre',
    'bill_repeats_half-year_other'              => 'Repete-se anualmente',
    'bill_repeats_yearly_other'                 => 'Repete-se a cada ano',
    'bill_repeats_weekly_skip'                  => 'Repete-se a cada {skip} semanas',
    'bill_repeats_monthly_skip'                 => 'Repete-se a cada {skip} meses',
    'bill_repeats_quarterly_skip'               => 'Repete a cada {skip} trimestres',
    'bill_repeats_half-year_skip'               => 'Repete-se a cada {skip} meio ano',
    'bill_repeats_yearly_skip'                  => 'Repete-se a cada {skip} anos',
    'subscriptions'                             => 'Subscrições',
    'go_to_subscriptions'                       => 'Ir para as suas subscrições',
    'forever'                                   => 'Para sempre',
    'extension_date_is'                         => 'A data de extensão é {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'Devem-me um montante',
    'i_owe_amount'                              => 'Eu devo um montante',
    'inactive_account_link'                     => 'Você tem :count conta inativa (arquivada), que pode visualizar nesta página separada.| Você tem :count contas inativas (arquivadas), que pode visualizar nesta página separada.',
    'all_accounts_inactive'                     => 'Estas são as suas contas inactivas.',
    'active_account_link'                       => 'Este link volta para suas contas activas.',
    'account_missing_transaction'               => 'A conta #:id (":name") não pode ser visualizada diretamente, no entanto, o Firefly está sem informação de redirecionamento.',
    'cc_monthly_payment_date_help'              => 'Selecione qualquer ano e mês, será ignorado de qualquer forma. Apenas o dia do mês é relevante.',
    'details_for_asset'                         => 'Detalhes para a conta de ativos ":name"',
    'details_for_expense'                       => 'Detalhes para a conta de despesas ":name"',
    'details_for_revenue'                       => 'Detalhes para a conta de receitas ":name"',
    'details_for_cash'                          => 'Detalhes de conta caixa ":name"',
    'store_new_asset_account'                   => 'Guardar nova conta de ativos',
    'store_new_expense_account'                 => 'Guardar nova conta de despesas',
    'store_new_revenue_account'                 => 'Guardar nova conta de receitas',
    'edit_asset_account'                        => 'Editar conta de ativos ":name"',
    'edit_expense_account'                      => 'Editar conta de despesas ":name"',
    'edit_revenue_account'                      => 'Editar conta de receitas ":name"',
    'delete_asset_account'                      => 'Apagar conta de ativos ":name"',
    'delete_expense_account'                    => 'Apagar conta de despesas ":name"',
    'delete_revenue_account'                    => 'Apagar conta de receitas ":name"',
    'delete_liabilities_account'                => 'Apagar passivo ":name"',
    'asset_deleted'                             => 'Conta de ativos ":name" apagada com sucesso',
    'account_deleted'                           => 'Conta ":name" eliminada com sucesso',
    'expense_deleted'                           => 'Conta de despesas ":name" apagada com sucesso',
    'revenue_deleted'                           => 'Conta de receitas ":name" apagada com sucesso',
    'update_asset_account'                      => 'Atualizar conta de ativos',
    'update_undefined_account'                  => 'Atualizar conta',
    'update_liabilities_account'                => 'Atualizar conta de passivos',
    'update_expense_account'                    => 'Atualizar conta de despesas',
    'update_revenue_account'                    => 'Atualizar conta de receitas',
    'make_new_asset_account'                    => 'Criar conta de ativos',
    'make_new_expense_account'                  => 'Criar conta de despesas',
    'make_new_revenue_account'                  => 'Criar conta de receitas',
    'make_new_liabilities_account'              => 'Criar nova conta de passivos',
    'asset_accounts'                            => 'Conta de ativos',
    'undefined_accounts'                        => 'Contas',
    'asset_accounts_inactive'                   => 'Contas de ativos (inativas)',
    'expense_account'                           => 'Conta de despesas',
    'expense_accounts'                          => 'Conta de despesas',
    'expense_accounts_inactive'                 => 'Contas de despesas (desativadas)',
    'revenue_account'                           => 'Conta de receitas',
    'revenue_accounts'                          => 'Conta de receitas',
    'revenue_accounts_inactive'                 => 'Contas de receita (desativadas)',
    'cash_accounts'                             => 'Contas de caixa',
    'Cash account'                              => 'Conta de caixa',
    'liabilities_accounts'                      => 'Conta de passivos',
    'liabilities_accounts_inactive'             => 'Contas de passivos (inativas)',
    'reconcile_account'                         => 'Reconciliar conta ":account"',
    'overview_of_reconcile_modal'               => 'Visão geral da reconciliação',
    'delete_reconciliation'                     => 'Apagar reconciliação',
    'update_reconciliation'                     => 'Atualizar reconciliação',
    'amount_cannot_be_zero'                     => 'O valor não pode ser zero',
    'end_of_reconcile_period'                   => 'Fim do período de reconciliação: :period',
    'start_of_reconcile_period'                 => 'Início do período de reconciliação: :period',
    'start_balance'                             => 'Saldo inicial',
    'end_balance'                               => 'Saldo final',
    'update_balance_dates_instruction'          => 'Corresponda os valores e datas acima ao seu extrato bancário e pressione "Começar reconciliação"',
    'select_transactions_instruction'           => 'Selecione as transações que aparecem no seu extrato bancário.',
    'select_range_and_balance'                  => 'Primeiro verifique a data e os saldos. Em seguida, pressione "Iniciar reconciliação"',
    'date_change_instruction'                   => 'Se alterar o intervalo de datas agora, todo o progresso será perdido.',
    'update_selection'                          => 'Atualizar seleção',
    'store_reconcile'                           => 'Guardar reconciliação',
    'reconciliation_transaction'                => 'Transacção de reconciliação',
    'Reconciliation'                            => 'Reconciliação',
    'reconciliation'                            => 'Reconciliação',
    'reconcile_options'                         => 'Opções de reconciliação',
    'reconcile_range'                           => 'Intervalo de reconciliação',
    'start_reconcile'                           => 'Começar a reconciliar',
    'cash_account_type'                         => 'Dinheiro',
    'cash'                                      => 'dinheiro',
    'cant_find_redirect_account'                => 'Firefly III tentou redirecciona-lo mas não conseguiu. Pedimos desculpa. De volta ao inicio.',
    'account_type'                              => 'Tipo de conta',
    'save_transactions_by_moving'               => 'Guarde esta transacção movendo-a para outra conta:|Guarde estas transacções movendo-as para outra conta:',
    'save_transactions_by_moving_js'            => 'Nenhuma transação| Guarde esta transação movendo-a para outra conta| Guarde estas transações movendo-as para outra conta.',
    'stored_new_account'                        => 'Nova conta ":name" gravada!',
    'stored_new_account_js'                     => 'Nova conta "<a href="accounts/show/{ID}">{name}</a>" armazenada!',
    'updated_account'                           => 'Conta ":name" alterada',
    'updated_account_js'                        => 'Conta atualizada "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Opções do cartão de crédito',
    'no_transactions_account'                   => 'Não existem transações (neste período) para a conta de ativos ":name".',
    'no_transactions_period'                    => 'Não há transações (neste período).',
    'no_data_for_chart'                         => 'Não existe informação suficiente (ainda) para gerar este gráfico.',
    'select_at_least_one_account'               => 'Por favor, selecione, pelo menos, uma conta de ativos',
    'select_at_least_one_category'              => 'Por favor, selecione pelo menos uma categoria',
    'select_at_least_one_budget'                => 'Por favor, selecione, pelo menos, um orçamento',
    'select_at_least_one_tag'                   => 'Por favor, selecione, pelo menos, uma etiqueta',
    'select_at_least_one_expense'               => 'Por favor, selecione pelo menos uma combinação de contas de despesas/receita. Se não tiver nenhuma (a lista está vazia), este relatório não fica disponível.',
    'account_default_currency'                  => 'Esta vai ser a moeda predefinida associada a esta conta.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'O seu diário Firefly III tem mais dinheiro do que aquele que o seu banco afirma ter. Existem várias opções. Por favor, escolha o que quer fazer. Depois, pressione "Confirmar reconciliação".',
    'reconcile_has_less'                        => 'O seu diário Firefly III tem menos dinheiro do que aquele que o seu banco afirma ter. Existem várias opções. Por favor, escolha o que quer fazer. Depois, pressione "Confirmar reconciliação".',
    'reconcile_is_equal'                        => 'O seu diário Firefly III e o seu extrato bancário estão iguais. Não existe nada para fazer. Por favor, carregue em "Confirmar reconciliação" para confirmar.',
    'create_pos_reconcile_transaction'          => 'Desmarque as transações selecionadas e crie uma correção adicionando :amount a esta conta de ativos.',
    'create_neg_reconcile_transaction'          => 'Desmarque as transações selecionadas e crie uma correção removendo :amount desta conta de ativos.',
    'reconcile_do_nothing'                      => 'Limpar as transações selecionadas, mas não corrigir.',
    'reconcile_go_back'                         => 'Pode sempre editar ou eliminar uma correção mais tarde.',
    'must_be_asset_account'                     => 'Só pode reconciliar contas de ativos',
    'reconciliation_stored'                     => 'Reconciliação guardada',
    'reconciliation_error'                      => 'Devido a um erro as transações foram marcadas como reconciliadas, mas a correção não foi guardada: :error.',
    'reconciliation_transaction_title'          => 'Reconciliação (:from a :to)',
    'sum_of_reconciliation'                     => 'Soma da reconciliação',
    'reconcile_this_account'                    => 'Reconciliar esta conta',
    'reconcile'                                 => 'Reconciliar',
    'show'                                      => 'Mostrar',
    'confirm_reconciliation'                    => 'Confirmar reconciliação',
    'submitted_start_balance'                   => 'Saldo inicial enviado',
    'selected_transactions'                     => 'Transações selecionadas (:count)',
    'already_cleared_transactions'              => 'Transações já removidas (:count)',
    'submitted_end_balance'                     => 'Saldo final enviado',
    'initial_balance_description'               => 'Saldo inicial para ":account"',
    'liability_credit_description'              => 'Crédito de passivo para ":account"',
    'interest_calc_'                            => 'desconhecido',
    'interest_calc_daily'                       => 'Por dia',
    'interest_calc_monthly'                     => 'Por mês',
    'interest_calc_yearly'                      => 'Por ano',
    'interest_calc_weekly'                      => 'Por semana',
    'interest_calc_half-year'                   => 'Por semestre',
    'interest_calc_quarterly'                   => 'Por trimestre',
    'initial_balance_account'                   => 'Saldo inicial da conta :account',
    'list_options'                              => 'Listar opções',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Nova categoria',
    'create_new_category'                       => 'Criar nova categoria',
    'without_category'                          => 'Sem uma categoria',
    'update_category'                           => 'Atualizar categoria',
    'updated_category'                          => 'Categoria ":name" atualizada',
    'categories'                                => 'Categorias',
    'edit_category'                             => 'Editar categoria ":name"',
    'no_category'                               => '(sem categoria)',
    'unknown_category_plain'                    => 'Sem categoria',
    'category'                                  => 'Categoria',
    'delete_category'                           => 'Apagar categoria ":name"',
    'deleted_category'                          => 'Categoria ":name" apagada',
    'store_category'                            => 'Gravar categoria',
    'stored_category'                           => 'Categoria ":name" gravada',
    'without_category_between'                  => 'Sem categoria entre :start e :end',


    // transactions:
    'wait_loading_transaction'                  => 'Por favor, aguarde o formulário carregar',
    'wait_loading_data'                         => 'Por favor, aguarde enquanto carregamos a sua informação...',
    'wait_attachments'                          => 'Por favor, aguarde os anexos serem carregados.',
    'errors_upload'                             => 'O upload falhou. Por favor, verifique o console do seu navegador para ver o erro.',
    'amount_foreign_if'                         => 'Valor em moeda estrangeira, se houver',
    'amount_destination_account'                => 'Valor na moeda da conta de destino',
    'edit_transaction_title'                    => 'Editar transação ":description"',
    'unreconcile'                               => 'Desfazer reconciliação',
    'update_withdrawal'                         => 'Atualizar levantamento',
    'update_deposit'                            => 'Atualizar depósito',
    'update_transaction'                        => 'Atualizar transação',
    'update_transfer'                           => 'Atualizar transferência',
    'updated_withdrawal'                        => 'Atualizar levantamento ":description"',
    'updated_deposit'                           => 'Atualizar depósito ":description"',
    'updated_transfer'                          => 'Atualizar transferência ":description"',
    'no_changes_withdrawal'                     => 'O levantamento ":description" não foi alterado.',
    'no_changes_deposit'                        => 'O depósito ":description" não foi alterado.',
    'no_changes_transfer'                       => 'A transferência ":description" não foi alterada.',
    'delete_withdrawal'                         => 'Apagar levantamento ":description"',
    'delete_deposit'                            => 'Apagar depósito ":description"',
    'delete_transfer'                           => 'Apagar transferência ":description"',
    'deleted_withdrawal'                        => 'Apagado o levantamento ":description" com sucesso',
    'deleted_deposit'                           => 'Apagado o depósito ":description" com sucesso',
    'deleted_transfer'                          => 'Transferência ":description" apagada com sucesso',
    'deleted_reconciliation'                    => 'Transação de reconciliação ":description" apagada com sucesso',
    'stored_journal'                            => 'Inserida a transação ":description" com sucesso',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Nova transação criada com sucesso',
    'updated_journal_no_descr'                  => 'Transação atualizada com sucesso',
    'select_transactions'                       => 'Selecionar transações',
    'rule_group_select_transactions'            => 'Aplicar ":title" às transações',
    'rule_select_transactions'                  => 'Aplicar ":title" às transações',
    'stop_selection'                            => 'Pare de selecionar transações',
    'reconcile_selected'                        => 'Reconciliar',
    'mass_delete_journals'                      => 'Apagar um número de transações',
    'mass_edit_journals'                        => 'Editar um número de transações',
    'mass_bulk_journals'                        => 'Editar em bloco um número de transações',
    'mass_bulk_journals_explain'                => 'Este formulário permite alterar as propriedades das transações listadas abaixo numa atualização abrangente. Todas as transações na tabela serão atualizadas quando alterar os parâmetros que estão aqui.',
    'part_of_split'                             => 'Esta transação faz parte de uma transação dividida. Se não selecionar todas as partições, pode acabar por mudar apenas uma parte da transação.',
    'bulk_set_new_values'                       => 'Use as entradas abaixo para definir novos valores. Se deixar em branco, serão definidas em branco para todos. Além disso, note que só serão dados orçamentos a levantamentos.',
    'no_bulk_category'                          => 'Não atualizar categoria',
    'no_bulk_budget'                            => 'Não atualizar orçamento',
    'no_bulk_tags'                              => 'Não atualizar etiqueta(s)',
    'replace_with_these_tags'                   => 'Substituir com estas etiquetas',
    'append_these_tags'                         => 'Adicionar estas etiquetas',
    'mass_edit'                                 => 'Editar selecionados individualmente',
    'bulk_edit'                                 => 'Editar selecionados em bloco',
    'mass_delete'                               => 'Apagar selecionados',
    'cannot_edit_other_fields'                  => 'Não pode editar em bloco outros campos para além destes, porque não existe espaço para mostrá-los. Por favor, siga o link para editá-los um-a-um, se tiver necessidade disso.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(sem orçamento)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Conta por orçamento',
    'account_per_category'                      => 'Conta por categoria',
    'create_new_object'                         => 'Criar',
    'empty'                                     => '(vazio)',
    'all_other_budgets'                         => '(todos os outros orçamentos)',
    'all_other_accounts'                        => '(todas as outras contas)',
    'expense_per_source_account'                => 'Despesas por conta de origem',
    'expense_per_destination_account'           => 'Despesas por conta de destino',
    'income_per_destination_account'            => 'Rendimento por conta de destino',
    'spent_in_specific_category'                => 'Gasto na categoria ":category"',
    'earned_in_specific_category'               => 'Ganhos na categoria ":category"',
    'spent_in_specific_tag'                     => 'Gasto na etiqueta ":tag"',
    'earned_in_specific_tag'                    => 'Ganhos na etiqueta ":tag"',
    'income_per_source_account'                 => 'Rendimento por conta de origem',
    'average_spending_per_destination'          => 'Média das despesas por conta de destino',
    'average_spending_per_source'               => 'Média das despesas por conta de origem',
    'average_earning_per_source'                => 'Média dos ganhos por conta de origem',
    'average_earning_per_destination'           => 'Média de ganhos por conta de destino',
    'account_per_tag'                           => 'Conta por etiqueta',
    'tag_report_expenses_listed_once'           => 'Despesas e receitas nunca são listadas duas vezes. Se uma transação tiver múltiplas etiquetas, apenas aparece se estiver debaixo de uma etiqueta selecionada. Esta lista pode parecer que têm dados em falta, no entanto os montantes estarão corretos.',
    'double_report_expenses_charted_once'       => 'Despesas e receitas nunca são listadas duas vezes. Se uma transação tiver múltiplas etiquetas, apenas aparece se estiver debaixo de uma etiqueta selecionada. Este gráfico pode parecer que têm dados em falta, no entanto os montantes estarão corretos.',
    'tag_report_chart_single_tag'               => 'Este gráfico está aplicado a uma única etiqueta. Se a transação tiver múltiplas etiquetas, o que você vê aqui pode ser refletido noutros gráficos de outras etiquetas.',
    'tag'                                       => 'Etiqueta',
    'no_budget_squared'                         => '(sem orçamento)',
    'perm-delete-many'                          => 'Apagar tantos itens de uma vez pode ter efeitos desastrosos. Por favor tenha cuidado. Pode sempre apagar partes de uma transação dividida a partir desta página, por tanto tenha cuidado.',
    'mass_deleted_transactions_success'         => 'Apagada :count transação.|Apagadas :count transações.',
    'mass_edited_transactions_success'          => 'Atualizada :count transação.|Atualizadas :count transações.',
    'opt_group_'                                => '(sem tipo de conta)',
    'opt_group_no_account_type'                 => '(sem tipo de conta)',
    'opt_group_defaultAsset'                    => 'Conta de activos padrão',
    'opt_group_savingAsset'                     => 'Contas poupança',
    'opt_group_sharedAsset'                     => 'Contas de activos partilhados',
    'opt_group_ccAsset'                         => 'Cartões de crédito',
    'opt_group_cashWalletAsset'                 => 'Carteiras de dinheiro',
    'opt_group_expense_account'                 => 'Contas de despesas',
    'opt_group_revenue_account'                 => 'Contas de receitas',
    'opt_group_l_Loan'                          => 'Passivo: Empréstimo',
    'opt_group_cash_account'                    => 'Conta de caixa',
    'opt_group_l_Debt'                          => 'Passivo: dívida',
    'opt_group_l_Mortgage'                      => 'Passivo: hipoteca',
    'opt_group_l_Credit card'                   => 'Passivo: cartão de crédito',
    'notes'                                     => 'Notas',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Não foi possível guardar a transação. Por favor, verifique os ficheiros de log.',
    'attachment_not_found'                      => 'Este anexo não foi encontrado.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">A transação #{ID} ("{title}")</a> foi guardada.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">A transação#{ID}</a> foi guardada.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">A transação #{ID}</a> ("{title}") foi atualizada.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">A transação #{ID}</a> ("{title}") não recebeu nenhuma alteração.',
    'first_split_decides'                       => 'A primeira divisão determina o valor deste campo',
    'first_split_overrules_source'              => 'A primeira divisão pode substituir a conta de origem',
    'first_split_overrules_destination'         => 'A primeira divisão pode substituir a conta de destino',
    'spent_x_of_y'                              => 'Gasto {amount} de {total}',

    // new user:
    'welcome'                                   => 'Bem-vindo ao Firefly III!',
    'submit'                                    => 'Guardar',
    'submission'                                => 'Submissão',
    'submit_yes_really'                         => 'Submeter (sei o que faço)',
    'getting_started'                           => 'Primeiros passos',
    'to_get_started'                            => 'É bom ver que instalou o Firefly III com sucesso. Para começar a utilizar esta ferramenta, por favor insira o nome do seu banco bem como o montante presente na sua conta corrente principal. Não se preocupe por agora se tiver múltiplas contas. Pode sempre adicioná-las depois. É que o Firefly III necessita de alguma coisa para começar.',
    'savings_balance_text'                      => 'O Firefly III criará automaticamente uma conta de poupança. Por defeito, não haverá dinheiro na sua conta poupança, mas se indicar ao Firefly III o saldo ele será armazenado como tal.',
    'finish_up_new_user'                        => 'É isso mesmo! Pode continuar a pressionar <strong>Enviar</strong>. Vai voltar ao índice do Firefly III.',
    'stored_new_accounts_new_user'              => 'Yay! As novas contas foram guardadas.',
    'set_preferred_language'                    => 'Se prefere utilizar o Firefly III noutro idioma, por favor indique-o aqui.',
    'language'                                  => 'Idioma',
    'new_savings_account'                       => 'Conta de poupança :bank_name',
    'cash_wallet'                               => 'Carteira de dinheiro',
    'currency_not_present'                      => 'Não se preocupe se a moeda que utiliza normalmente não está listada. Pode criar as suas próprias moedas em Opções > Moedas.',

    // home page:
    'transaction_table_description'             => 'Uma tabela com as suas transações',
    'opposing_account'                          => 'Conta de contrapartida',
    'yourAccounts'                              => 'As suas contas',
    'your_accounts'                             => 'Resumo da sua conta',
    'category_overview'                         => 'Resumo da categoria',
    'expense_overview'                          => 'Resumo da conta de despesas',
    'revenue_overview'                          => 'Resumo da conta de receitas',
    'budgetsAndSpending'                        => 'Orçamentos e gastos',
    'budgets_and_spending'                      => 'Orçamentos e gastos',
    'go_to_budget'                              => 'Vá para o orçamento "{budget}"',
    'go_to_deposits'                            => 'Ir para depósitos',
    'go_to_expenses'                            => 'Ir para despesas',
    'savings'                                   => 'Poupanças',
    'newWithdrawal'                             => 'Nova despesa',
    'newDeposit'                                => 'Novo depósito',
    'newTransfer'                               => 'Nova transferência',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Por dia',
    'left_to_spend_per_day'                     => 'Restante para gastar por dia',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Período personalizado',
    'reset_to_current'                          => 'Reiniciar o período personalizado',
    'select_period'                             => 'Selecionar um período',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Moeda',
    'preferences'                               => 'Preferências',
    'logout'                                    => 'Terminar Sessão',
    'logout_other_sessions'                     => 'Terminar todas as outras sessões',
    'toggleNavigation'                          => 'Mostrar/esconder navegação',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Pesquisar...',
    'version'                                   => 'Versão',
    'dashboard'                                 => 'Painel de controlo',
    'income_and_expense'                        => 'Receitas e despesas',
    'all_money'                                 => 'Todo o seu dinheiro',
    'unknown_source_plain'                      => 'Conta de origem desconhecida',
    'unknown_dest_plain'                        => 'Conta de destino desconhecida',
    'unknown_any_plain'                         => 'Conta desconhecida',
    'unknown_budget_plain'                      => 'Sem orçamento',
    'available_budget'                          => 'Orçamento disponível ({currency})',
    'currencies'                                => 'Moedas',
    'activity'                                  => 'Atividade',
    'usage'                                     => 'Uso',
    'accounts'                                  => 'Contas',
    'Asset account'                             => 'Conta de ativos',
    'Default account'                           => 'Conta de ativos',
    'Expense account'                           => 'Conta de despesas',
    'Revenue account'                           => 'Conta de receitas',
    'Initial balance account'                   => 'Conta de saldo inicial',
    'account_type_Asset account'                => 'Conta de ativos',
    'account_type_Expense account'              => 'Conta de gastos / passivos',
    'account_type_Revenue account'              => 'Conta de receitas',
    'account_type_Debt'                         => 'Dívida',
    'account_type_Loan'                         => 'Empréstimo',
    'account_type_Mortgage'                     => 'Hipoteca',
    'account_type_debt'                         => 'Dívida',
    'account_type_loan'                         => 'Empréstimo',
    'account_type_mortgage'                     => 'Hipoteca',
    'account_type_Credit card'                  => 'Cartão de crédito',
    'credit_card_type_monthlyFull'              => 'Pagamento total a cada mês',
    'liability_direction_credit'                => 'Esta dívida é-me devida',
    'liability_direction_debit'                 => 'Devo esta dívida a outra pessoa',
    'liability_direction_credit_short'          => 'Devem-me esta dívida',
    'liability_direction_debit_short'           => 'Devo esta dívida',
    'liability_direction__short'                => 'Desconhecido',
    'liability_direction_null_short'            => 'Desconhecido',
    'Liability credit'                          => 'Crédito de passivo',
    'budgets'                                   => 'Orçamentos',
    'tags'                                      => 'Etiquetas',
    'reports'                                   => 'Relatórios',
    'transactions'                              => 'Transações',
    'expenses'                                  => 'Despesas',
    'income'                                    => 'Receita / rendimento',
    'transfers'                                 => 'Transferências',
    'moneyManagement'                           => 'Gestão de dinheiro',
    'money_management'                          => 'Gestão de dinheiro',
    'tools'                                     => 'Ferramentas',
    'piggyBanks'                                => 'Mealheiros',
    'piggy_banks'                               => 'Mealheiros',
    'amount_x_of_y'                             => '{current} de {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Levantamento',
    'opening_balance'                           => 'Saldo de abertura',
    'deposit'                                   => 'Depósito',
    'account'                                   => 'Conta',
    'transfer'                                  => 'Transferência',
    'Withdrawal'                                => 'Levantamento',
    'Deposit'                                   => 'Depósito',
    'Transfer'                                  => 'Transferência',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Sim',
    'no'                                        => 'Não',
    'amount'                                    => 'Montante',
    'overview'                                  => 'Visão geral',
    'saveOnAccount'                             => 'Poupar na conta',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Desconhecido',
    'monthly'                                   => 'Mensalmente',
    'profile'                                   => 'Perfil',
    'errors'                                    => 'Erros',
    'debt_start_date'                           => 'Data inicial da dívida',
    'debt_start_amount'                         => 'Montante inicial da dívida',
    'debt_start_amount_help'                    => 'É sempre melhor definir esse valor como um valor negativo. Leia as páginas de ajuda (canto superior direito (?)) para obter mais informações.',
    'interest_period_help'                      => 'Este campo é puramente cosmético e não será calculado por si. Acontece que os bancos são muito matreiros e por isso o Firefly III nunca acerta.',
    'store_new_liabilities_account'             => 'Guardar novo passivo',
    'edit_liabilities_account'                  => 'Editar passivo ":name"',
    'financial_control'                         => 'Controlo financeiro',
    'accounting'                                => 'Contabilidade',
    'automation'                                => 'Automatização',
    'others'                                    => 'Outros',
    'classification'                            => 'Classificação',
    'store_transaction'                         => 'Guardar transação',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Relatório financeiro predefinido entre :start e :end',
    'report_audit'                              => 'Visão geral do histórico de transações entre :start e :end',
    'report_category'                           => 'Relatório da categoria entre :start e :end',
    'report_double'                             => 'Relatório de despesas/receitas entre :start e :end',
    'report_budget'                             => 'Relatório de orçamento entre :start e :end',
    'report_tag'                                => 'Relatório de etiqueta entre :start e :end',
    'quick_link_reports'                        => 'Links rápidos',
    'quick_link_examples'                       => 'Estes são apenas alguns links de exemplo para o ajudar a começar. Veja as páginas de ajuda presentes no botão-(?) para mais informação sobre todos os relatórios e as palavras mágicas que pode usar.',
    'quick_link_default_report'                 => 'Relatório financeiro predefinido',
    'quick_link_audit_report'                   => 'Visão geral do histórico de transações',
    'report_this_month_quick'                   => 'Mês corrente, todas as contas',
    'report_last_month_quick'                   => 'Mês passado, todas as contas',
    'report_this_year_quick'                    => 'Ano atual, todas as contas',
    'report_this_fiscal_year_quick'             => 'Ano fiscal atual, todas as contas',
    'report_all_time_quick'                     => 'Todas as contas, de sempre',
    'reports_can_bookmark'                      => 'Lembre-se de que os relatórios podem ser guardados.',
    'incomeVsExpenses'                          => 'Receitas vs Despesas',
    'accountBalances'                           => 'Saldos das contas',
    'balanceStart'                              => 'Saldo no início do período',
    'balanceEnd'                                => 'Saldo no final do período',
    'splitByAccount'                            => 'Dividir por conta',
    'coveredWithTags'                           => 'Com etiquetas',
    'leftInBudget'                              => 'Restante no orçamento',
    'left_in_debt'                              => 'Montante em dívida',
    'sumOfSums'                                 => 'Soma das somas',
    'noCategory'                                => '(sem categoria)',
    'notCharged'                                => 'Não cobrado (ainda)',
    'inactive'                                  => 'Inativo',
    'active'                                    => 'Ativo',
    'difference'                                => 'Diferença',
    'money_flowing_in'                          => 'Dentro',
    'money_flowing_out'                         => 'Fora',
    'topX'                                      => 'superior :number',
    'show_full_list'                            => 'Mostrar a lista inteira',
    'show_only_top'                             => 'Mostrar apenas topo :number',
    'report_type'                               => 'Tipo de relatório',
    'report_type_default'                       => 'Relatório financeiro padrão',
    'report_type_audit'                         => 'Visão geral do histórico de transacções (auditoria)',
    'report_type_category'                      => 'Relatório por categoria',
    'report_type_budget'                        => 'Relatório por orçamento',
    'report_type_tag'                           => 'Relatório por etiqueta',
    'report_type_double'                        => 'Relatório de despesas/receitas',
    'more_info_help'                            => 'Mais informação sobre este tipo de relatórios pode ser encontrada nas páginas de ajuda. Por favor carregue no ícone (?) no canto superior direito.',
    'report_included_accounts'                  => 'Contas incluídas',
    'report_date_range'                         => 'Intervalo de datas',
    'report_preset_ranges'                      => 'Intervalos pré-definidos',
    'shared'                                    => 'Partilhado',
    'fiscal_year'                               => 'Ano fiscal',
    'income_entry'                              => 'Rendimento da conta ":name" entre :start e :end',
    'expense_entry'                             => 'Despesas na conta ":name" entre :start e :end',
    'category_entry'                            => 'Despesas e receitas na categoria ":name" entre :start e :end',
    'budget_spent_amount'                       => 'Despesas no orçamento ":budget" entre :start e :end',
    'balance_amount'                            => 'Despesas no orçamento ":budget" pagas com a conta ":account" entre :start e :end',
    'no_audit_activity'                         => 'Sem atividade registada na conta <a href=":url" title=":account_name">:account_name</a> entre :start e :end.',
    'audit_end_balance'                         => 'O saldo da conta <a href=":url" title=":account_name">:account_name</a> no final de :end era :balance',
    'reports_extra_options'                     => 'Opções adicionais',
    'report_has_no_extra_options'               => 'Este relatório não tem opções adicionais',
    'reports_submit'                            => 'Ver relatório',
    'end_after_start_date'                      => 'A data de fim do relatório deve ser superior à da data de início.',
    'select_category'                           => 'Selecionar categoria(s)',
    'select_budget'                             => 'Selecionar orçamento(s).',
    'select_tag'                                => 'Selecionar etiqueta(s).',
    'income_per_category'                       => 'Receita por categoria',
    'expense_per_category'                      => 'Despesa por categoria',
    'expense_per_budget'                        => 'Despesa por orçamento',
    'income_per_account'                        => 'Receita por conta',
    'expense_per_account'                       => 'Despesa por conta',
    'expense_per_tag'                           => 'Despesa por etiqueta',
    'income_per_tag'                            => 'Receita por etiqueta',
    'include_expense_not_in_budget'             => 'Despesas incluídas fora do(s) orçamento(s) selecionado(s)',
    'include_expense_not_in_account'            => 'Despesas incluídas fora da(s) conta(s) selecionada(s)',
    'include_expense_not_in_category'           => 'Despesas incluídas fora da(s) categoria(s) selecionada(s)',
    'include_income_not_in_category'            => 'Rendimento incluído fora da(s) categoria(s) selecionada(s)',
    'include_income_not_in_account'             => 'Rendimento incluído fora da(s) conta(s) selecionada(s)',
    'include_income_not_in_tags'                => 'Rendimento incluído fora da(s) etiqueta(s) selecionada(s)',
    'include_expense_not_in_tags'               => 'Despesas incluídas fora da(s) etiqueta(s) selecionada(s)',
    'everything_else'                           => 'Tudo o restante',
    'income_and_expenses'                       => 'Receitas e despesas',
    'spent_average'                             => 'Gasto (média)',
    'income_average'                            => 'Rendimento (média)',
    'transaction_count'                         => 'Número de transações',
    'average_spending_per_account'              => 'Média de gastos por conta',
    'average_income_per_account'                => 'Rendimento médio por conta',
    'total'                                     => 'Total',
    'description'                               => 'Descrição',
    'sum_of_period'                             => 'Soma do período',
    'average_in_period'                         => 'Média no período',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Conta de ativos predefinida',
    'account_role_sharedAsset'                  => 'Conta de ativos partilhados',
    'account_role_savingAsset'                  => 'Conta poupança',
    'account_role_ccAsset'                      => 'Cartão de crédito',
    'account_role_cashWalletAsset'              => 'Carteira de dinheiro',
    'budget_chart_click'                        => 'Por favor, carregue no nome de um orçamento na tabela acima para visualizar um gráfico.',
    'category_chart_click'                      => 'Por favor, carregue no nome duma categoria na tabela acima para visualizar um gráfico.',
    'in_out_accounts'                           => 'Ganhos e gastos por combinação',
    'in_out_accounts_per_asset'                 => 'Recebido e gasto (por conta de ativos)',
    'in_out_per_category'                       => 'Ganhos e gastos por categoria',
    'out_per_budget'                            => 'Gasto por orçamento',
    'select_expense_revenue'                    => 'Seleccione conta de despesa/receita',
    'multi_currency_report_sum'                 => 'Como esta lista contém contas com várias moedas diferentes, a(s) soma(s) que vê pode não fazer sentido. O relatório vai utilizar sempre a moeda padrão.',
    'sum_in_default_currency'                   => 'A soma estará sempre na moeda padrão.',
    'net_filtered_prefs'                        => 'Esse gráfico nunca incluirá contas que tenham a opção "incluir no património líquido" desmarcada.',


    // charts:
    'chart'                                     => 'Gráfico',
    'month'                                     => 'Mes',
    'budget'                                    => 'Orçamento',
    'spent'                                     => 'Gasto',
    'spent_capped'                              => 'Gasto (limitado)',
    'spent_in_budget'                           => 'Gasto no orçamento',
    'left_to_spend'                             => 'Restante para gastar',
    'earned'                                    => 'Ganho',
    'overspent'                                 => 'Gasto excedido',
    'left'                                      => 'Em falta',
    'max-amount'                                => 'Montante máximo',
    'min-amount'                                => 'Montante mínimo',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Nome',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Data',
    'date_and_time'                             => 'Data e hora',
    'time'                                      => 'Hora',
    'paid'                                      => 'Pago',
    'unpaid'                                    => 'Por pagar',
    'day'                                       => 'Dia',
    'budgeted'                                  => 'Orçamentado',
    'period'                                    => 'Período',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'Dentro + fora este período',
    'sum'                                       => 'Soma',
    'summary'                                   => 'Resumo',
    'average'                                   => 'Média',
    'balanceFor'                                => 'Saldo para :name',
    'no_tags'                                   => '(sem etiquetas)',
    'nothing_found'                             => '(sem resultados)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Histórico de eventos',
    'add_money_to_piggy'            => 'Adicionar dinheiro ao mealheiro ":name"',
    'piggy_bank'                    => 'Mealheiro',
    'new_piggy_bank'                => 'Novo mealheiro',
    'store_piggy_bank'              => 'Guardar novo mealheiro',
    'stored_piggy_bank'             => 'Guardar novo mealheiro ":name"',
    'account_status'                => 'Estado da conta',
    'left_for_piggy_banks'          => 'Sobra para os mealheiros',
    'sum_of_piggy_banks'            => 'Soma dos mealheiros',
    'saved_so_far'                  => 'Poupado até agora',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Restante para poupar',
    'suggested_amount'              => 'Valor de poupança mensal sugerido',
    'add_money_to_piggy_title'      => 'Adicionar dinheiro ao mealheiro ":name"',
    'remove_money_from_piggy_title' => 'Remover dinheiro do mealheiro ":name"',
    'add'                           => 'Adicionar',
    'no_money_for_piggy'            => 'Não tem dinheiro para colocar neste mealheiro.',
    'suggested_savings_per_month'   => 'Sugerido por mês',

    'remove'                    => 'Remover',
    'max_amount_add'            => 'O montante máximo que pode adicionar é',
    'max_amount_remove'         => 'O montante máximo que pode remover é',
    'update_piggy_button'       => 'Atualizar mealheiro',
    'update_piggy_title'        => 'Atualizar o mealheiro ":name"',
    'updated_piggy_bank'        => 'Mealheiro ":name" atualizado',
    'details'                   => 'Detalhes',
    'events'                    => 'Eventos',
    'target_amount'             => 'Montante alvo',
    'start_date'                => 'Data inicial',
    'no_start_date'             => 'Sem data inicial',
    'target_date'               => 'Data alvo',
    'no_target_date'            => 'Sem data alvo',
    'table'                     => 'Tabela',
    'delete_piggy_bank'         => 'Apagar o mealheiro ":name"',
    'cannot_add_amount_piggy'   => 'Nao consigo adicionar :amount a ":name".',
    'cannot_remove_from_piggy'  => 'Nao consigo remover :amount de ":name".',
    'deleted_piggy_bank'        => 'Mealheiro ":name" apagado',
    'added_amount_to_piggy'     => 'Adicionado :amount a ":name"',
    'removed_amount_from_piggy' => 'Removido :amount de ":name"',
    'piggy_events'              => 'Mealheiros relacionados',

    // tags
    'delete_tag'                => 'Apagar etiqueta ":tag"',
    'deleted_tag'               => 'Etiqueta ":tag" apagada',
    'new_tag'                   => 'Nova etiqueta',
    'edit_tag'                  => 'Editar etiqueta ":tag"',
    'updated_tag'               => 'Etiqueta ":tag" alterada',
    'created_tag'               => 'Etiqueta ":tag" criada!',

    'transaction_journal_information'               => 'Informação da transação',
    'transaction_journal_amount'                    => 'Informação da quantidade',
    'transaction_journal_meta'                      => 'Meta informação',
    'transaction_journal_more'                      => 'Mais informações',
    'basic_journal_information'                     => 'Informações básicas de transação',
    'transaction_journal_extra'                     => 'Informações extra',
    'att_part_of_journal'                           => 'Guardado em ":journal"',
    'total_amount'                                  => 'Montante total',
    'number_of_decimals'                            => 'Número de casas decimais',


    // administration
    'invite_is_already_redeemed'                    => 'O convite enviado para ":address" já foi resgatado.',
    'invite_is_deleted'                             => 'O convite enviado para ":address" foi apagado.',
    'invite_new_user_title'                         => 'Convidar novo utilizador',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Endereço de email',
    'invite_user'                                   => 'Convidar utilizador',
    'user_is_invited'                               => 'O endereço de email ":address" recebeu um convite para o Firefly III',
    'administration'                                => 'Administração',
    'system_settings'                               => 'Definições de sistema',
    'code_already_used'                             => 'O código de convite foi usado',
    'user_administration'                           => 'Gestão de utilizadores',
    'list_all_users'                                => 'Todos os utilizadores',
    'all_users'                                     => 'Todos os utilizadores',
    'instance_configuration'                        => 'Configuração',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'setting_single_user_mode'                      => 'Modo de utilizador único',
    'setting_single_user_mode_explain'              => 'Por defeito, o Firefly III só aceita um (1) registo: o seu. Esta é uma medida de segurança, impedindo que outros utilizem a sua plataforma, a menos que permita. Os futuros registos estão bloqueados. Quando desmarcar esta caixa, outros podem utilizar a sua plataforma caso tenham acesso (quando ela estiver conectada à Internet).',
    'store_configuration'                           => 'Gravar configuração',
    'single_user_administration'                    => 'Administração de utilizadores para :email',
    'edit_user'                                     => 'Editar utilizador :email',
    'hidden_fields_preferences'                     => 'Pode ativar mais opções de transações nas suas <a href="preferences">preferências</a>.',
    'user_data_information'                         => 'Dados do utilizador',
    'user_information'                              => 'Informação do utilizador',
    'total_size'                                    => 'tamanho total',
    'budget_or_budgets'                             => ':count orçamento|:count orçamentos',
    'budgets_with_limits'                           => ':count orçamento com montante definido|:count orçamentos com montante definido',
    'nr_of_rules_in_total_groups'                   => ':count_rules regra(s) em :count_groups grupo(s) de regras',
    'tag_or_tags'                                   => ':count etiqueta|:count etiquetas',
    'configuration_updated'                         => 'A configuração foi atualizada',
    'setting_is_demo_site'                          => 'Site de demonstração',
    'setting_is_demo_site_explain'                  => 'Se marcar esta caixa, esta instalação vai funcionar como site de demonstração, o que pode ter efeitos colaterais estranhos.',
    'block_code_bounced'                            => 'Mensagem(s) de email devolvida(s)',
    'block_code_expired'                            => 'Conta de demonstração expirada',
    'no_block_code'                                 => 'Sem razão para bloqueio ou utilizador não bloqueado',
    'demo_user_export'                              => 'O utilizador de demonstração não pode exportar dados',
    'block_code_email_changed'                      => 'O utilizador ainda não confirmou o novo endereço de email',
    'admin_update_email'                            => 'Ao contrário da página de perfil, o utilizador NÃO vai ser notificado sobre a alteração do endereço de email!',
    'update_user'                                   => 'Atualizar utilizador',
    'updated_user'                                  => 'Os dados do utilizador foram alterados.',
    'delete_user'                                   => 'Apagar utilizador ":email"',
    'user_deleted'                                  => 'O utilizador foi apagado',
    'send_test_email'                               => 'Enviar e-mail de teste',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Enviar mensagem',
    'send_test_triggered'                           => 'O teste foi activado. Verifique a caixa de entrada e os arquivos de log.',
    'give_admin_careful'                            => 'Utilizadores que obtiverem direitos de administrador podem remover as suas permissões. Tenha cuidado.',
    'admin_maintanance_title'                       => 'Manutenção',
    'admin_maintanance_expl'                        => 'Alguns botões sofisticados para a manutenção do Firefly III',
    'admin_maintenance_clear_cache'                 => 'Limpar cache',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'Todos os utilizadores convidados',
    'save_notification_settings'                    => 'Gravar definições',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'As definições de notificação foram gravadas',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Descrição da transação dividida',
    'split_transaction_title_help'          => 'Se criar uma transação dividida, deve haver uma descrição global para todas as partes da transação.',
    'split_title_help'                      => 'Se criar uma transação dividida, deve haver uma descrição global para todas as partes da transação.',
    'you_create_transfer'                   => 'Está a criar uma transferência.',
    'you_create_withdrawal'                 => 'Está a criar um levantamento.',
    'you_create_deposit'                    => 'Está a criar um depósito.',

    // links
    'journal_link_configuration'            => 'Configuração de ligações de transação',
    'create_new_link_type'                  => 'Criar novo tipo de ligação',
    'store_new_link_type'                   => 'Guardar novo tipo de ligação',
    'update_link_type'                      => 'Atualizar tipo de ligação',
    'edit_link_type'                        => 'Editar tipo de ligação ":name"',
    'updated_link_type'                     => 'Tipo de ligação ":name" atualizado',
    'delete_link_type'                      => 'Apagar tipo de ligação ":name"',
    'deleted_link_type'                     => 'Tipo de ligação ":name" apagado',
    'stored_new_link_type'                  => 'Guarde novo tipo de ligação ":name"',
    'cannot_edit_link_type'                 => 'Não é possível editar o tipo de ligação ":name"',
    'link_type_help_name'                   => 'E.g. "Duplicados"',
    'link_type_help_inward'                 => 'E.g. "duplicados"',
    'link_type_help_outward'                => 'E.g. "é duplicado por"',
    'save_connections_by_moving'            => 'Grave a ligação entre estas transações ao mover as mesmas para outro tipo de ligação:',
    'do_not_save_connection'                => '(não guardar a ligação)',
    'link_transaction'                      => 'Ligar transação',
    'link_to_other_transaction'             => 'Ligue esta transação a outra transação',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Esta transação',
    'transaction'                           => 'Transação',
    'comments'                              => 'Comentários',
    'link_notes'                            => 'Quaisquer notas que deseje guardar com a ligação.',
    'invalid_link_selection'                => 'Não é possível ligar estas transações',
    'selected_transaction'                  => 'Transação selecionada',
    'journals_linked'                       => 'As transações estão ligadas.',
    'journals_error_linked'                 => 'Estas transações já estão ligadas.',
    'journals_link_to_self'                 => 'Não pode ligar uma transação a ela mesma',
    'journal_links'                         => 'Ligações de transação',
    'this_withdrawal'                       => 'Este levantamento',
    'this_deposit'                          => 'Este depósito',
    'this_transfer'                         => 'Esta transferência',
    'overview_for_link'                     => 'Visão geral do tipo de ligação ":name"',
    'source_transaction'                    => 'Transação de origem',
    'link_description'                      => 'Descrição da ligação',
    'destination_transaction'               => 'Transação de destino',
    'delete_journal_link'                   => 'Apagar a ligação entre <a href=":source_link">:source</a> e <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Link apagado',

    // link translations:
    'Paid_name'                             => 'Pago',
    'Refund_name'                           => 'Reembolso',
    'Reimbursement_name'                    => 'Reembolso',
    'Related_name'                          => 'Relacionado',
    'relates to_inward'                     => 'relacionado com',
    'is (partially) refunded by_inward'     => 'e (parcialmente) reembolsado por',
    'is (partially) paid for by_inward'     => 'e (parcialmente) pago por',
    'is (partially) reimbursed by_inward'   => 'e (parcialmente) reembolsado por',
    'inward_transaction'                    => 'Transacção interna',
    'outward_transaction'                   => 'Transacção externa',
    'relates to_outward'                    => 'refere-se a',
    '(partially) refunds_outward'           => 'reembolsos (parcialmente)',
    '(partially) pays for_outward'          => 'paga por (parcialmente)',
    '(partially) reimburses_outward'        => 'reembolsa (parcialmente)',
    'is (partially) refunded by'            => 'é (parcialmente) reembolsado por',
    'is (partially) paid for by'            => 'é (parcialmente) pago por',
    'is (partially) reimbursed by'          => 'é (parcialmente) reembolsado por',
    'relates to'                            => 'relacionado com',
    '(partially) refunds'                   => 'reembolsos (parcialmente)',
    '(partially) pays for'                  => 'pago por (parcialmente)',
    '(partially) reimburses'                => 'reembolsos (parcialmente)',

    // split a transaction:
    'splits'                                => 'Divisões',
    'add_another_split'                     => 'Adicionar outra divisão',
    'cannot_edit_opening_balance'           => 'Não pode editar o saldo inicial de uma conta.',
    'no_edit_multiple_left'                 => 'Não selecionou nenhuma transação válida para editar.',
    'breadcrumb_convert_group'              => 'Converter transação',
    'convert_invalid_source'                => 'A informação de origem é inválida para a transação #%d.',
    'convert_invalid_destination'           => 'A informação de destino é inválida para a transação #%d.',
    'create_another'                        => 'Depois de guardar, voltar aqui para criar outra.',
    'after_update_create_another'           => 'Após atualizar, regresse aqui para continuar a editar.',
    'store_as_new'                          => 'Guarde como nova transação em vez de atualizar.',
    'reset_after'                           => 'Reiniciar o formulário após o envio',
    'errors_submission'                     => 'Algo correu mal com o envio dos dados. Por favor verifique e corrija os erros abaixo.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Expandir divisão',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Ocultar divisão',

    // object groups
    'default_group_title_name'              => '(não agrupado)',
    'default_group_title_name_plain'        => 'sem grupo',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Vamos criar uma conta de ativos!',
    'no_accounts_intro_asset'               => 'Ainda não tem nenhuma conta de ativos. Contas de ativos são as suas contas principais: a conta à ordem, conta de poupança, conta partilhada ou até o seu cartão de crédito.',
    'no_accounts_imperative_asset'          => 'Para começar a usar o Firefly III, tem de criar pelo menos uma conta de ativos. Vamos criá-la agora:',
    'no_accounts_create_asset'              => 'Criar uma conta de ativos',
    'no_accounts_title_expense'             => 'Vamos criar uma conta de despesas!',
    'no_accounts_intro_expense'             => 'Ainda não tem contas de despesas. As contas de despesas servem para os lugares onde gasta dinheiro, como lojas e supermercados.',
    'no_accounts_imperative_expense'        => 'As contas de despesas são criadas automaticamente quando cria transações, mas também pode criar uma manualmente, se quiser. Vamos criar uma agora:',
    'no_accounts_create_expense'            => 'Criar uma conta de despesas',
    'no_accounts_title_revenue'             => 'Vamos criar uma conta de receitas!',
    'no_accounts_intro_revenue'             => 'Ainda não tem contas de receita. Contas de receita são os locais de onde recebe dinheiro, como, por exemplo, o seu trabalho.',
    'no_accounts_imperative_revenue'        => 'As contas de receita são criadas automaticamente quando cria transações, mas também pode criar uma manualmente, se quiser. Vamos criar uma agora:',
    'no_accounts_create_revenue'            => 'Criar uma conta de receitas',
    'no_accounts_title_liabilities'         => 'Vamos criar um passivo!',
    'no_accounts_intro_liabilities'         => 'Ainda não tem conta de passivos. Contas de passivos é onde se registam dívidas e empréstimos.',
    'no_accounts_imperative_liabilities'    => 'Não precisa de utilizar esta funcionalidade, mas pode ser útil se quiser acompanhar estas coisas.',
    'no_accounts_create_liabilities'        => 'Criar um passivo',
    'no_budgets_title_default'              => 'Vamos criar um orçamento',
    'no_rules_title_default'                => 'Vamos criar uma regra',
    'no_budgets_intro_default'              => 'Ainda não tem orçamentos. Os orçamentos são usados para organizar as suas despesas em grupos lógicos, que pode usar como limiar para ajudar a limitar as suas despesas.',
    'no_rules_intro_default'                => 'Ainda não tem regras. As regras são poderosas automações que podem gerir transações por si.',
    'no_rules_imperative_default'           => 'As regras podem ser muito úteis quando gere transações. Vamos criar uma agora:',
    'no_budgets_imperative_default'         => 'Os orçamentos são as ferramentas básicas da gestão financeira. Vamos criar um agora:',
    'no_budgets_create_default'             => 'Criar um orçamento',
    'no_rules_create_default'               => 'Criar uma regra',
    'no_categories_title_default'           => 'Vamos criar uma categoria!',
    'no_categories_intro_default'           => 'Ainda não tem categorias. As categorias são usadas para ajustar as transacções e rotulá-las para uma categoria especifica.',
    'no_categories_imperative_default'      => 'As categorias são criadas automaticamente quando cria transacções, mas também pode criar uma manualmente. Vamos criar uma agora:',
    'no_categories_create_default'          => 'Criar uma categoria',
    'no_tags_title_default'                 => 'Vamos criar uma etiqueta!',
    'no_tags_intro_default'                 => 'Ainda não tem etiquetas. As etiquetas são usadas para ajustar as transações e rotulá-las com palavras-chave específicas.',
    'no_tags_imperative_default'            => 'As etiquetas são criadas automaticamente quando cria transações, mas também pode criá-las manualmente. Vamos criar uma agora:',
    'no_tags_create_default'                => 'Criar uma etiqueta',
    'no_transactions_title_withdrawal'      => 'Vamos criar uma despesa!',
    'no_transactions_intro_withdrawal'      => 'Ainda não tem despesas. Deve criar despesas para começar a gerir as suas finanças.',
    'no_transactions_imperative_withdrawal' => 'Gastou algum dinheiro? Então deveria anotá-lo:',
    'no_transactions_create_withdrawal'     => 'Criar despesa',
    'no_transactions_title_deposit'         => 'Vamos criar uma receita!',
    'no_transactions_intro_deposit'         => 'Ainda não tem rendimentos registados. Deve criar entradas de rendimentos para começar a gerir as suas finanças.',
    'no_transactions_imperative_deposit'    => 'Recebeu dinheiro? Então é melhor anotá-lo:',
    'no_transactions_create_deposit'        => 'Criar depósito',
    'no_transactions_title_transfers'       => 'Vamos criar uma transferência!',
    'no_transactions_intro_transfers'       => 'Ainda não tem transferências. Quando movimenta dinheiro entre contas de ativos, fica registado como uma transferência.',
    'no_transactions_imperative_transfers'  => 'Movimentou algum dinheiro? Então deve anotá-lo:',
    'no_transactions_create_transfers'      => 'Criar transferência',
    'no_piggies_title_default'              => 'Vamos criar um mealheiro!',
    'no_piggies_intro_default'              => 'Ainda não tem nenhum mealheiro. Pode criar mealheiros para dividir as suas poupanças e acompanhar o objetivo da poupança.',
    'no_piggies_imperative_default'         => 'Tem alguma coisa para a qual está a poupar? Crie um mealheiro e acompanhe:',
    'no_piggies_create_default'             => 'Criar um novo mealheiro',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Criar agora',
    'no_new_transaction_in_recurrence'      => 'Não foi criada nenhuma transação nova. Talvez já tenha sido acionada nesta data?',
    'recurrences'                           => 'Transações recorrentes',
    'repeat_until_in_past'                  => 'Esta transação recorrente parou de ocorrer a :date.',
    'recurring_calendar_view'               => 'Calendário',
    'no_recurring_title_default'            => 'Vamos criar uma transação recorrente!',
    'no_recurring_intro_default'            => 'Ainda não tem nenhuma transação recorrente. Pode usá-las para que o Firefly III crie transações automaticamente.',
    'no_recurring_imperative_default'       => 'Esta é uma funcionalidade avançada, mas pode ser extremamente útil. Certifique-se de que lê a documentação (?)-ícone no canto superior direito) antes de continuar.',
    'no_recurring_create_default'           => 'Criar uma transação recorrente',
    'make_new_recurring'                    => 'Criar transação recorrente',
    'recurring_daily'                       => 'Todos os dias',
    'recurring_weekly'                      => 'Semanalmente à(ao) :weekday',
    'recurring_weekly_skip'                 => 'A cada :skipª semana no :weekday dia',
    'recurring_monthly'                     => 'Todos os meses no dia :dayOfMonth',
    'recurring_monthly_skip'                => 'A cada :skip meses no dia :dayOfMonth',
    'recurring_ndom'                        => 'Todos os meses no dia :dayOfMonth :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Todos os anos em :date',
    'overview_for_recurrence'               => 'Visão geral da transação recorrente ":title"',
    'warning_duplicates_repetitions'        => 'Em raras ocasiões, as datas aparecem duas vezes nesta lista. Isso pode acontecer quando várias repetições colidem. O Firefly III irá gerar sempre uma transação por dia.',
    'created_transactions'                  => 'Transações relacionadas',
    'expected_withdrawals'                  => 'Levantamentos esperados',
    'expected_deposits'                     => 'Depósitos esperados',
    'expected_transfers'                    => 'Transferências esperadas',
    'created_withdrawals'                   => 'Levantamentos criados',
    'created_deposits'                      => 'Depósitos criados',
    'created_transfers'                     => 'Transferência criada',
    'recurring_info'                        => 'Transação recorrente :count / :total',
    'created_from_recurrence'               => 'Criado a partir da transação recorrente ":title" (#:id)',
    'recurring_never_cron'                  => 'Aparentemente o cron job necessário para suportar transações recorrentes nunca foi executado. Isto é algo normal quando acaba de instalar o Firefly III, no entanto isto deve ser configurado o mais rápido possível. Por favor verifique as páginas de ajuda no ícone-(?) no canto superior direito da página.',
    'recurring_cron_long_ago'               => 'Parece que a última vez que o cron job que trata das transações recorrentes correu foi há mais de 36 horas desde a ultima vez. Têm a certeza que está configurado corretamente? Por favor verifique as páginas de ajuda através do ícone-(?) no canto superior direito da página.',

    'create_new_recurrence'              => 'Criar nova transação recorrente',
    'help_first_date'                    => 'Indique a primeira recorrência esperada. Isto deve ser no futuro.',
    'help_first_date_no_past'            => 'Indique a primeira recorrência esperada. O Firefly III não irá criar transações recorrentes no passado.',
    'no_currency'                        => '(sem moeda)',
    'mandatory_for_recurring'            => 'Informações de recorrência obrigatórias',
    'mandatory_for_transaction'          => 'Informações obrigatórias de transação',
    'optional_for_recurring'             => 'Opcional informação recorrente',
    'optional_for_transaction'           => 'Opcional informação de transação',
    'change_date_other_options'          => 'Altere a "primeira data" para ver mais opções.',
    'mandatory_fields_for_tranaction'    => 'Os valores aqui presentes vão acabar na(s) transação(ões) a serem criadas',
    'click_for_calendar'                 => 'Carregue aqui para ver um calendário que mostra quando a transação irá repetir.',
    'repeat_forever'                     => 'Repetir para sempre',
    'repeat_until_date'                  => 'Repetir até uma data',
    'repeat_times'                       => 'Repetir um número de vezes',
    'recurring_skips_one'                => 'Alternado',
    'recurring_skips_more'               => 'Saltar :count ocorrências',
    'store_new_recurrence'               => 'Guardar transação recorrente',
    'stored_new_recurrence'              => 'Transação recorrente ":title" guardada com sucesso.',
    'edit_recurrence'                    => 'Editar transação recorrente ":title"',
    'recurring_repeats_until'            => 'Repete até :date',
    'recurring_repeats_forever'          => 'Repetir para sempre',
    'recurring_repeats_x_times'          => 'Repete :count vez|Repete :count vezes',
    'update_recurrence'                  => 'Atualizar transação recorrente',
    'updated_recurrence'                 => 'Atualizar transação recorrente ":title"',
    'recurrence_is_inactive'             => 'Esta transação recorrente não está ativada e não serão geradas novas transações.',
    'delete_recurring'                   => 'Apagar transação recorrente ":title"',
    'new_recurring_transaction'          => 'Nova transação recorrente',
    'help_weekend'                       => 'O que deve fazer o Firefly III quando uma transação recorrente ocorre num sábado ou domingo?',
    'do_nothing'                         => 'Crie só a transação',
    'skip_transaction'                   => 'Saltar a ocorrência',
    'jump_to_friday'                     => 'Criar antes uma transação na sexta-feira passada',
    'jump_to_monday'                     => 'Criar antes a transação na próxima segunda-feira',
    'will_jump_friday'                   => 'Será criada na sexta-feira em vez de nos fins de semana.',
    'will_jump_monday'                   => 'Será criada na segunda-feira em vez de nos fins de semana.',
    'except_weekends'                    => 'Exceto fins de semana',
    'recurrence_deleted'                 => 'Transação recorrente ":title" apagada',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Saldo (:currency)',
    'box_spent_in_currency'              => 'Gasto (:currency)',
    'box_earned_in_currency'             => 'Ganho (:currency)',
    'box_budgeted_in_currency'           => 'Orçamentado (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Restante para gastar (:currency)',
    'box_net_worth_in_currency'          => 'Valor líquido (:currency)',
    'box_spend_per_day'                  => 'Restante para gastar por dia: :amount',

    // debug page
    'debug_page'                         => 'Página de depuração',
    'debug_submit_instructions'          => 'Se estiver com problemas, pode utilizar a informação desta caixa como informação de depuração. Por favor, copie e cole a mesma numa <a href="https://github.com/firefly-iii/firefly-iii/issues">questão GitHub</a> nova ou existente. Será gerada uma bonita tabela que pode ser usada como diagnóstico rápido do seu problema.',
    'debug_pretty_table'                 => 'Se copiar e colar o conteúdo da caixa abaixo numa questão do GitHub será gerada uma tabela. Por favor, não envolva o texto com acentos ou aspas.',
    'debug_additional_data'              => 'Pode também partilhar o conteúdo da caixa abaixo. Pode copiar e colar a mesma numa <a href="https://github.com/firefly-iii/firefly-iii/issues">questão GitHub</a> novo ou existente. No entanto, o conteúdo da caixa abaixo pode conter informação privada como nomes de contas, detalhes de transações, ou endereços de email.',

    // object groups
    'object_groups_menu_bar'             => 'Grupos',
    'object_groups_page_title'           => 'Grupos',
    'object_groups_breadcrumb'           => 'Grupos',
    'object_groups_index'                => 'Visão geral',
    'object_groups'                      => 'Grupos',
    'object_groups_empty_explain'        => 'Alguns elementos no Firefly III podem ser divididos em grupos. Os mealheiros, por exemplo, têm um campo "Grupo" nos ecrãs de criaçao e edição. Quando esse campo é definido, pode alterar os nomes e a ordem dos grupos nesta página. Para mais informação, veja a ajuda existente no canto superior direito, no botão com ícone-(?).',
    'object_group_title'                 => 'Título',
    'edit_object_group'                  => 'Editar grupo ":title"',
    'delete_object_group'                => 'Apagar grupo ":title"',
    'update_object_group'                => 'Atualizar grupo',
    'updated_object_group'               => 'Grupo ":title" atualizado com sucesso',
    'deleted_object_group'               => 'Grupo ":title" apagado com sucesso',
    'object_group'                       => 'Grupo',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Detalhes do registo (log) de auditoria',
    'ale_action_log_add'                 => 'Adicionado :amount ao mealheiro ":name"',
    'ale_action_log_remove'              => 'Removido :amount do mealheiro ":name"',
    'ale_action_clear_budget'            => 'Removido do orçamento',
    'ale_action_update_group_title'      => 'Título atualizado do grupo de transações',
    'ale_action_update_date'             => 'Data da transação atualizada',
    'ale_action_update_order'            => 'Ordem de transação atualizada',
    'ale_action_clear_category'          => 'Removido da categoria',
    'ale_action_clear_notes'             => 'Notas removidas',
    'ale_action_clear_tag'               => 'Etiqueta limpa',
    'ale_action_clear_all_tags'          => 'Apagadas todas as etiquetas',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Conta de origem e destino alternados',
    'ale_action_set_budget'              => 'Definir orçamento',
    'ale_action_set_category'            => 'Definir categoria',
    'ale_action_set_source'              => 'Definir conta de origem',
    'ale_action_set_destination'         => 'Definir conta de destino',
    'ale_action_update_transaction_type' => 'Tipo de transação alterado',
    'ale_action_update_notes'            => 'Notas alteradas',
    'ale_action_update_description'      => 'Descrição alterada',
    'ale_action_add_to_piggy'            => 'Mealheiro',
    'ale_action_remove_from_piggy'       => 'Mealheiro',
    'ale_action_add_tag'                 => 'Etiqueta adicionada',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Ativar a conversão de moeda',
    'disable_auto_convert'               => 'Destaivar a conversão de moeda',
];
