<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Zavrieť',
    'actions'                                   => 'Akcie',
    'edit'                                      => 'Upraviť',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Odstrániť',
    'split'                                     => 'Rozúčtovať',
    'single_split'                              => 'Rozúčtovať',
    'clone'                                     => 'Klonovať',
    'clone_and_edit'                            => 'Clone and edit',
    'confirm_action'                            => 'Confirm action',
    'last_seven_days'                           => 'Uplynulých 7 dní',
    'last_thirty_days'                          => 'Uplynulých 30 dní',
    'last_180_days'                             => 'Posledných 180 dní',
    'month_to_date'                             => 'Month to date',
    'year_to_date'                              => 'Year to date',
    'YTD'                                       => 'Tento rok',
    'welcome_back'                              => 'Ako to ide?',
    'main_dashboard_page_title'                 => 'Home',
    'everything'                                => 'Všetko',
    'today'                                     => 'dnes',
    'customRange'                               => 'Vlastný rozsah',
    'date_range'                                => 'Časový rozsah',
    'apply'                                     => 'Použiť',
    'select_date'                               => 'Vyberte dátum..',
    'cancel'                                    => 'Storno',
    'from'                                      => 'Od',
    'to'                                        => 'Komu',
    'structure'                                 => 'Štruktúra',
    'help_translating'                          => 'Tento text pomocníka ešte nie je k dispozícii vo vašom jazyku. <a href="https://crowdin.com/project/firefly-iii-help">Pomôžete prekladať?</a>',
    'showEverything'                            => 'Zobraziť všetko',
    'never'                                     => 'Nikdy',
    'no_results_for_empty_search'               => 'Nevyplnili ste žiadny vyhľadávaný pojem, takže sa nič nenašlo.',
    'removed_amount'                            => 'Odobrané :amount',
    'added_amount'                              => 'Pridané :amount',
    'asset_account_role_help'                   => 'Akékoľvek ďalšie možnosti vyplývajúce z vášho výberu je možné nastaviť neskôr.',
    'Opening balance'                           => 'Počiatočný zostatok',
    'create_new_stuff'                          => 'Vytvoriť nový údaj',
    'new_withdrawal'                            => 'Nový výber',
    'create_new_transaction'                    => 'Vytvoriť novú transakciu',
    'sidebar_frontpage_create'                  => 'Vytvoriť',
    'new_transaction'                           => 'Nová transakcia',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Zobraziť účty aktív',
    'go_to_budgets'                             => 'Zobraziť rozpočty',
    'go_to_withdrawals'                         => 'Zobraziť výbery',
    'clones_journal_x'                          => 'Táto transakcia je kópiou „:description“ (#:id)',
    'go_to_categories'                          => 'Zobraziť kategórie',
    'go_to_bills'                               => 'Go to your subscriptions',
    'go_to_expense_accounts'                    => 'Zobraziť výdavkové účty',
    'go_to_revenue_accounts'                    => 'Zobraziť výnosové účty',
    'go_to_piggies'                             => 'Zobraziť pokladničky',
    'new_deposit'                               => 'Nový vklad',
    'new_transfer'                              => 'Nový prevod',
    'new_transfers'                             => 'Nový prevod',
    'new_asset_account'                         => 'Nový účet aktív',
    'new_expense_account'                       => 'Nový výdavkový účet',
    'new_revenue_account'                       => 'Nový výnosový účet',
    'new_liabilities_account'                   => 'Nový záväzok',
    'new_budget'                                => 'Nový rozpočet',
    'new_bill'                                  => 'New subscription',
    'block_account_logout'                      => 'Byli jste odhlásení. Zablokované účty tuto stránku nemôžu používať. Zaregistrovaliste sa pomocou platnej e-mailovej adresy?',
    'flash_success'                             => 'Hotovo!',
    'flash_info'                                => 'Správa',
    'flash_warning'                             => 'Varovanie!',
    'flash_error'                               => 'Chyba!',
    'flash_danger'                              => 'Danger!',
    'flash_info_multiple'                       => 'Jedna správa|:count správ',
    'flash_error_multiple'                      => 'Jedna chyba|:count chýb',
    'net_worth'                                 => 'Čisté imanie',
    'help_for_this_page'                        => 'Pomocník pro túto stránku',
    'help_for_this_page_body'                   => 'You can find more information about this page <a href="https://docs.firefly-iii.org/">in the documentation</a>.',
    'two_factor_welcome'                        => 'Zdravíme!',
    'two_factor_enter_code'                     => 'Pre pokračovanie zadajte kód pre dvojfázové overenie. Vaša aplikácia ho pre vás môže vytvoriť.',
    'two_factor_code_here'                      => 'Sem vložte kód',
    'two_factor_title'                          => 'Dvojfázové overenie',
    'authenticate'                              => 'Overiť',
    'two_factor_forgot_title'                   => 'Stratil(a) som dvojfázové overenie',
    'two_factor_forgot'                         => 'Zabudol(a) som si nástroj pro dvojfázové overenie.',
    'two_factor_lost_header'                    => 'Ztratili ste svoje dvojfázové overenie?',
    'two_factor_lost_intro'                     => 'Ak ste stratili aj svoje záložné kódy, máte smolu. Nie je to niečo, čo by ste mohli opraviť z webového rozhrania. Máte dve možnosti.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'V ostatných prípadoch napíšte prevádzkovateľovi, <a href="mailto::site_owner">:site_owner</a> a požiadajte ho o obnovenie vášho dvojfázového overenia.',
    'mfa_backup_code'                           => 'Použitím záložného kódu, umožňujúceho prihlásenie do Firefly III, platnosť kódu zaniká. Takže kód, ktorým ste sa už prihlásili, už vám je k ničomu (nie je možné ho použiť opakovane) - preto si ho zo zoznamu vyškrtnite.',
    'pref_two_factor_new_backup_codes'          => 'Získať nové záložní kódy',
    'pref_two_factor_backup_code_count'         => 'Máte :count platný záložný kód.|Máte :count platných záložných kódov.',
    '2fa_i_have_them'                           => 'Uložil som si ich!',
    'warning_much_data'                         => 'Načítanie :days dní údajov môže chvíľu trvať.',
    'registered'                                => 'Úspešne ste sa zaregistrovali!',
    'Default asset account'                     => 'Prednastavený účet aktív',
    'no_budget_pointer'                         => 'Zdá sa, že zatiaľ nemáte žiadne rozpočty. Na stránke <a href="/budgets">rozpočty</a> by ste si nejaké mali vytvoriť. Rozpočty môžu pomôcť udržať prehľad vo výdavkoch.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Sporiaci účet',
    'Credit card'                               => 'Kreditná karta',
    'source_accounts'                           => 'Zdrojový účet|Zdrojové účty',
    'destination_accounts'                      => 'Cieľový účet|Cieľové účty',
    'user_id_is'                                => 'Váš identifikátor použivateľa je <strong>:user</strong>',
    'field_supports_markdown'                   => 'Text v tomto políčku je možné formátovať pomocou syntaxe <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Ak potřebujetr ďalšiu pomoc s používaním Firefly III, <a href="https://github.com/firefly-iii/firefly-iii/issues"> založte požiadavku na portáli GitHub</a>.',
    'reenable_intro_text'                       => 'Môžete tiež znova povoliť <a href="#" id="reenableGuidance">úvodné pokyny</a>.',
    'intro_boxes_after_refresh'                 => 'Oblasti s úvodom sa znovu objavia po opätovnom načítaní stránky.',
    'show_all_no_filter'                        => 'Zobraziť všetky transakcie bez zoskupenia podľa dátumu.',
    'expenses_by_category'                      => 'Výdavky podľa kategórie',
    'expenses_by_budget'                        => 'Výdavky podľa rozpočtu',
    'income_by_category'                        => 'Príjmy podľa kategórie',
    'expenses_by_asset_account'                 => 'Výdavky podľa účtu aktív',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III se nedarí presmerovať vás na správnu stránku. Ospravedlňujeme sa.',
    'sum_of_expenses'                           => 'Suma výdavkov',
    'sum_of_income'                             => 'Suma príjmov',
    'liabilities'                               => 'Záväzky',
    'spent_in_specific_budget'                  => 'Utratené v rozpočte „:budget“',
    'spent_in_specific_double'                  => 'Uhradené v účte ":account"',
    'earned_in_specific_double'                 => 'Zarobené na účte ":account"',
    'source_account'                            => 'Zdrojový účet',
    'source_account_reconciliation'             => 'Nemôžete upraviť zdrojový účet zúčtovacej transakcie.',
    'destination_account'                       => 'Cieľový účet',
    'destination_account_reconciliation'        => 'Nemôžete upraviť cieľový účet zúčtovacej transakcie.',
    'sum_of_expenses_in_budget'                 => 'Celkom utratené v rozpočte „:budget“',
    'left_in_budget_limit'                      => 'Ponechané k útrate podľa rozpočtu',
    'current_period'                            => 'Aktuálne obdobie',
    'show_the_current_period_and_overview'      => 'Zobraziť aktuálne obdobie a prehľad',
    'pref_languages_locale'                     => 'Aby mohol iný jazyk ako angličtina správne fungovať, musí byť váš operačný systém vybavený správnymi miestnymi informáciami. Ak nie sú k dispozícii, môžu byť údaje o mene, dátumy a sumy nesprávne naformátované.',
    'budget_in_period'                          => 'Všetky transakcie pre rozpočet ":name" medzi :start a :end v mene :currency',
    'chart_budget_in_period'                    => 'Graf všetkých transakcií pre rozpočet ":name" medzi :start a :end v mene :currency',
    'chart_budget_in_period_only_currency'      => 'Suma rozpočtu je v :currency, takže tento graf zobrazuje len transakcie v :currency.',
    'chart_account_in_period'                   => 'Graf všetkých transakcií pre účet ":name" (:balance) medzi :start a :end',
    'chart_category_in_period'                  => 'Graf všetkých transakcií pre kategóriu „:name“ medzi :start a :end',
    'chart_category_all'                        => 'Graf všetkých transakcií pre kategóriu „:name“',
    'clone_withdrawal'                          => 'Klonovať tento výber',
    'clone_deposit'                             => 'Klonovať tento vklad',
    'clone_transfer'                            => 'Klonovať tento prevod',
    'multi_select_no_selection'                 => 'Žiadny výber',
    'multi_select_select_all'                   => 'Vybrať všetko',
    'multi_select_n_selected'                   => 'vybrané',
    'multi_select_all_selected'                 => 'Všetko vybrané',
    'multi_select_filter_placeholder'           => 'Hľadať…',
    'intro_next_label'                          => 'Nasledujúce',
    'intro_prev_label'                          => 'Predchádzajúce',
    'intro_skip_label'                          => 'Preskočiť',
    'intro_done_label'                          => 'Hotovo',
    'between_dates_breadcrumb'                  => 'Medzi :start a :end',
    'all_journals_without_budget'               => 'Všetky transakcie bez rozpočtu',
    'journals_without_budget'                   => 'Transakcie bez rozpočtu',
    'all_journals_without_category'             => 'Všetky transakcie bez kategórie',
    'journals_without_category'                 => 'Transakcie bez kategórie',
    'all_journals_for_account'                  => 'Všetky transakcie pre účet :name',
    'chart_all_journals_for_account'            => 'Graf všetkých transakcíi pre účet „:name“',
    'journals_in_period_for_account'            => 'Všetky transakcie pre účet „:name“ medzi :start a :end',
    'journals_in_period_for_account_js'         => 'All transactions for account {title} between {start} and {end}',
    'transferred'                               => 'Prenesené',
    'all_withdrawal'                            => 'Všetky výdavky',
    'all_transactions'                          => 'Všetky transakcie',
    'title_withdrawal_between'                  => 'Všetky výdavky medzi :start a :end',
    'all_deposit'                               => 'Všetky výnosy',
    'title_deposit_between'                     => 'Všetky výnosy medzi :start a :end',
    'all_transfers'                             => 'Všetky prevody',
    'title_transfers_between'                   => 'Všetky prevody medzi :start a :end',
    'all_transfer'                              => 'Všetky prevody',
    'all_journals_for_tag'                      => 'Všetky transakcie pre značku „:tag“',
    'title_transfer_between'                    => 'Všetky prevody medzi :start a :end',
    'all_journals_for_category'                 => 'Všetky prevody pre kategóriu :name',
    'all_journals_for_budget'                   => 'Všetky transakcie pre rozpočet :name',
    'chart_all_journals_for_budget'             => 'Graf všetkých transakcií pre rozpočet „:name“',
    'journals_in_period_for_category'           => 'Všetky transakce pre kategóriu „:name“ medzi :start a :end',
    'journals_in_period_for_tag'                => 'Všetky transakcie pre štítok :tag medzi :start a :end',
    'not_available_demo_user'                   => 'Funkcia, ku ktorej sa snažíte získať prístup, nie je používateľom ukážky k dispozícii.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Účet zdrojového majetku "@source_name" prijíma iba transakcie v @source_currency. Cieľový majetkový účet „@dest_name“ prijíma iba transakcie v @dest_currency. Prevedenú čiastku musíte uviesť správne v oboch menách.',
    'transaction_data'                          => 'Údaje o transakcii',
    'invalid_server_configuration'              => 'Neplatné nastavenie serveru',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'Rýchle prepnutie',
    'sign_in_to_start'                          => 'Pre zahájenie sedenia sa prihláste',
    'sign_in'                                   => 'Prihlásiť',
    'register_new_account'                      => 'Zaregistrovať nový účet',
    'forgot_my_password'                        => 'Zabudol(a) som svoje heslo',
    'problems_with_input'                       => 'Vyskytol sa problém s vstupnými údajmi.',
    'reset_password'                            => 'Obnovte si heslo',
    'button_reset_password'                     => 'Obnoviť heslo',
    'reset_button'                              => 'Obnoviť',
    'want_to_login'                             => 'Chcem sa prihlásiť',
    'login_page_title'                          => 'Prihlásenie do Firefly III',
    'register_page_title'                       => 'Registrácia do Firefly III',
    'forgot_pw_page_title'                      => 'Zabudnuté heslo do Firefly III',
    'reset_pw_page_title'                       => 'Obnovte si heslo do Firefly III',
    'cannot_reset_demo_user'                    => 'Heslo použivateľa pre ukážku (demo) nie je možné obnoviť.',
    'no_att_demo_user'                          => 'Demo používateľ nemá povolené nahrávať prílohy.',
    'button_register'                           => 'Registrovať',
    'authorization'                             => 'Autorizácia',
    'active_bills_only'                         => 'active subscription only',
    'active_bills_only_total'                   => 'all active subscriptions',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Očakávané denné výdavky',
    'per_period_sum_1W'                         => 'Očakávané týždenné výdavky',
    'per_period_sum_1M'                         => 'Očakávané mesačné výdavky',
    'per_period_sum_3M'                         => 'Očakávané štvrťročné výdavky',
    'per_period_sum_6M'                         => 'Očakávané polročné výdavky',
    'per_period_sum_1Y'                         => 'Očakávané ročné výdavky',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'očakávaný celkový súčet',
    'reconciliation_account_name'               => ':name zúčtovanie (:currency)',
    'saved'                                     => 'Uložené',
    'advanced_options'                          => 'Pokročilé nastavenia',
    'advanced_options_explain'                  => 'Niektoré stránky Firefly III majú pod týmto tlačítkom skryté pokročilé nastavenia. Táto stránka síce nič také neobsahuje, ale určite to skúste na iných!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',

    // Webhooks
    'webhooks'                                  => 'Webhooky',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'disabled',
    'no_webhook_messages'                       => 'There are no webhook messages',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'After transaction creation',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'After transaction update',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'After transaction delete',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Transaction details',
    'webhook_response_ACCOUNTS'                 => 'Account details',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspect',
    'create_new_webhook'                        => 'Create new webhook',
    'webhooks_create_breadcrumb'                => 'Create new webhook',
    'webhook_trigger_form_help'                 => 'Indicate on what event the webhook will trigger',
    'webhook_response_form_help'                => 'Indicate what the webhook must submit to the URL.',
    'webhook_delivery_form_help'                => 'Which format the webhook must deliver data in.',
    'webhook_active_form_help'                  => 'The webhook must be active or it won\'t be called.',
    'stored_new_webhook'                        => 'Stored new webhook ":title"',
    'delete_webhook'                            => 'Delete webhook',
    'deleted_webhook'                           => 'Deleted webhook ":title"',
    'edit_webhook'                              => 'Edit webhook ":title"',
    'updated_webhook'                           => 'Updated webhook ":title"',
    'edit_webhook_js'                           => 'Edit webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'The webhook was triggered on the indicated transaction. Please wait for results to appear.',
    'webhook_messages'                          => 'Webhook message',
    'view_message'                              => 'View message',
    'view_attempts'                             => 'View failed attempts',
    'message_content_title'                     => 'Webhook message content',
    'message_content_help'                      => 'This is the content of the message that was sent (or tried) using this webhook.',
    'attempt_content_title'                     => 'Webhook attempts',
    'attempt_content_help'                      => 'These are all the unsuccessful attempts of this webhook message to submit to the configured URL. After some time, Firefly III will stop trying.',
    'no_attempts'                               => 'There are no unsuccessful attempts. That\'s a good thing!',
    'webhook_attempt_at'                        => 'Attempt at {moment}',
    'logs'                                      => 'Logs',
    'response'                                  => 'Response',
    'visit_webhook_url'                         => 'Visit webhook URL',
    'reset_webhook_secret'                      => 'Reset webhook secret',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> has been stored.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") has been updated.',

    // API access
    'authorization_request'                     => 'Požiadavka na overenie – Firefly III verzia :version',
    'authorization_request_intro'               => 'Application "<strong>:client</strong>" is requesting permission to access your financial administration. Would you like to authorize <strong>:client</strong> to access these records?',
    'authorization_request_site'                => 'You will be redirected to <code>:url</code> which will then be able to access your Firefly III data.',
    'authorization_request_invalid'             => 'This access request is invalid. Please never follow this link again.',
    'scopes_will_be_able'                       => 'Táto aplikácia bude môcť:',
    'button_authorize'                          => 'Autorizovať',
    'none_in_select_list'                       => '(žiadne)',
    'no_piggy_bank'                             => '(žiadna pokladnička)',
    'name_in_currency'                          => ':name v :currency',
    'paid_in_currency'                          => 'Uhradené v :currency',
    'unpaid_in_currency'                        => 'Neuhradené v :currency',
    'is_alpha_warning'                          => 'Používate ALPHA verziu. Buďte ostražití pred chybami a problémami.',
    'is_beta_warning'                           => 'Používate BETA verziu. Buďte ostražití pred chybami a problémami.',
    'all_destination_accounts'                  => 'Cieľové účty',
    'all_source_accounts'                       => 'Zdrojové účty',
    'back_to_index'                             => 'Späť na zoznam',
    'cant_logout_guard'                         => 'Firefly III sa nepodarilo vás odhlásiť.',
    'internal_reference'                        => 'Interná referencia',

    // check for updates:
    'update_check_title'                        => 'Zistiť dostupnosť aktualizácií',
    'admin_update_check_title'                  => 'Zisťovať dostupnosť aktualizácií automaticky',
    'admin_update_check_explain'                => 'Firefly III môže sám kontrolovať aktualizácie. Ak toto nastavenie aktivujete, bude kontaktovať hlavný server Firefly III, či je dostupná nová verzia Firefly III. Ak áno, dostanete upozornenie. Toto upozornenie si môžete vyskúšať kliknutím na tlačítko napravo. Prosím, vyberte nižšie, či chcete, aby Firefly III kontroloval aktualizácie.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Spýtať sa neskôr',
    'updates_do_not_check'                      => 'Nezisťovať dostupnosť aktualizácií',
    'updates_enable_check'                      => 'Zisťovať dostupnosť aktualizácií',
    'admin_update_check_now_title'              => 'Zistiť dostupnosť aktualizácií teraz',
    'admin_update_check_now_explain'            => 'Ak stlačíte tlačidlo, Firefly III zistí, či je vaša aktuálna verzia najnovšia.',
    'check_for_updates_button'                  => 'Skontrolovať teraz!',
    'update_new_version_alert'                  => 'Je dostupná nová verzia Firefly III. Pracujete s verziou :your_version, najnovšia verzia je :new_version zverejnená :date.',
    'update_version_beta'                       => 'Toto je BETA verzia. Môžu sa vyskytnúť chyby.',
    'update_version_alpha'                      => 'Toto je ALPHA verzia. Môžu sa vyskytnúť chyby.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'Pracujete s verziou :version, čo je najnovšie dostupné vydanie.',
    'update_newer_version_alert'                => 'Pracujete s verziou :your_version, ktorá je novšia, než posledné vydanie, :new_version.',
    'update_check_error'                        => 'Pri kontrole aktualizácii nastala chyba: :error',
    'unknown_error'                             => 'Neznáma chyba. Prepáčte.',
    'disabled_but_check'                        => 'Vypli ste kontrolu aktualizácií. Nezabudnite občas skontrolovať aktualizácie manuálne. Ďakujeme!',
    'admin_update_channel_title'                => 'Aktualizačný kanál',
    'admin_update_channel_explain'              => 'Firefly III má tri "kanály" aktualizácií, ktoré určujú, ako napred ste so svojim systémom, čo sa týka funkcií, vylepšení a chýb. Ak radi skúšate nové veci, použite "beta" kanál a ak vás bavi žiť nebezpečne, vyberte si "alfa".',
    'update_channel_stable'                     => 'Stabilná verzia. Všetko by malo fungovať.',
    'update_channel_beta'                       => 'Beta verzia. Nové funkcie, môžu sa vyskytnúť chyby.',
    'update_channel_alpha'                      => 'Alfa verzia. Hodíme sem, čo nás napadne, a použije sa, čo sa uchytí.',

    // search
    'search'                                    => 'Hľadať',
    'search_query'                              => 'Požiadavka',
    'search_found_transactions'                 => 'Firefly III našiel :count transakciu za :time sekúnd.|Firefly III našiel :count transakcií za :time sekúnd.',
    'search_found_more_transactions'            => 'Firefly III našiel viac než :count transakcií za :time sekúnd.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'These search parameters are not valid and have been ignored.',

    // old


    'search_modifier_date_on'                             => 'Transaction date is ":value"',
    'search_modifier_not_date_on'                         => 'Transaction date is not ":value"',
    'search_modifier_reconciled'                          => 'Transaction is reconciled',
    'search_modifier_not_reconciled'                      => 'Transaction is not reconciled',
    'search_modifier_id'                                  => 'ID transakcie je ":value"',
    'search_modifier_not_id'                              => 'Transaction ID is not ":value"',
    'search_modifier_date_before'                         => 'Dátum transakcie je pred alebo v deň ":value"',
    'search_modifier_date_after'                          => 'Dátum transakcie je po alebo v deň ":value"',
    'search_modifier_external_id_is'                      => 'External ID is ":value"',
    'search_modifier_not_external_id_is'                  => 'External ID is not ":value"',
    'search_modifier_no_external_url'                     => 'The transaction has no external URL',
    'search_modifier_no_external_id'                      => 'The transaction has no external ID',
    'search_modifier_not_any_external_url'                => 'The transaction has no external URL',
    'search_modifier_not_any_external_id'                 => 'The transaction has no external ID',
    'search_modifier_any_external_url'                    => 'The transaction must have a (any) external URL',
    'search_modifier_any_external_id'                     => 'The transaction must have a (any) external ID',
    'search_modifier_not_no_external_url'                 => 'The transaction must have a (any) external URL',
    'search_modifier_not_no_external_id'                  => 'The transaction must have a (any) external ID',
    'search_modifier_internal_reference_is'               => 'Internal reference is ":value"',
    'search_modifier_not_internal_reference_is'           => 'Internal reference is not ":value"',
    'search_modifier_description_starts'                  => 'Description starts with ":value"',
    'search_modifier_not_description_starts'              => 'Description does not start with ":value"',
    'search_modifier_description_ends'                    => 'Description ends on ":value"',
    'search_modifier_not_description_ends'                => 'Description does not end on ":value"',
    'search_modifier_description_contains'                => 'Popis obsahuje ":value“',
    'search_modifier_not_description_contains'            => 'Description does not contain ":value"',
    'search_modifier_description_is'                      => 'Popis je presne ":value"',
    'search_modifier_not_description_is'                  => 'Description is exactly not ":value"',
    'search_modifier_currency_is'                         => '(Cudzia) mena transakcie je ":value"',
    'search_modifier_not_currency_is'                     => 'Transaction (foreign) currency is not ":value"',
    'search_modifier_foreign_currency_is'                 => 'Cudzia mena transakcie je ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Transaction foreign currency is not ":value"',
    'search_modifier_has_attachments'                     => 'Transakcia má prílohu',
    'search_modifier_has_no_category'                     => 'Transakcia nemá žiadnu kategóriu',
    'search_modifier_not_has_no_category'                 => 'The transaction must have a (any) category',
    'search_modifier_not_has_any_category'                => 'The transaction must have no category',
    'search_modifier_has_any_category'                    => 'Transakcia má (ľubovoľnú) kategóriu',
    'search_modifier_has_no_budget'                       => 'Transakcia nesmie mať rozpočet',
    'search_modifier_not_has_any_budget'                  => 'The transaction must have no budget',
    'search_modifier_has_any_budget'                      => 'Transakcia má (ľubovoľný) rozpočet',
    'search_modifier_not_has_no_budget'                   => 'The transaction must have a (any) budget',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'Transakcia nesmie mať štítky',
    'search_modifier_not_has_any_tag'                     => 'The transaction must have no tags',
    'search_modifier_not_has_no_tag'                      => 'The transaction must have a (any) tag',
    'search_modifier_has_any_tag'                         => 'Transakcia má (ľubovoľné) štítky',
    'search_modifier_notes_contains'                      => 'The transaction notes contain ":value"',
    'search_modifier_not_notes_contains'                  => 'The transaction notes do not contain ":value"',
    'search_modifier_notes_starts'                        => 'The transaction notes start with ":value"',
    'search_modifier_not_notes_starts'                    => 'The transaction notes do not start with ":value"',
    'search_modifier_notes_ends'                          => 'The transaction notes end with ":value"',
    'search_modifier_not_notes_ends'                      => 'The transaction notes do not end with ":value"',
    'search_modifier_notes_is'                            => 'The transaction notes are exactly ":value"',
    'search_modifier_not_notes_is'                        => 'The transaction notes are exactly not ":value"',
    'search_modifier_no_notes'                            => 'Transakcia nemá žiadne poznámky',
    'search_modifier_not_no_notes'                        => 'The transaction must have notes',
    'search_modifier_any_notes'                           => 'Transakcia má poznámky',
    'search_modifier_not_any_notes'                       => 'The transaction has no notes',
    'search_modifier_amount_is'                           => 'Amount is exactly :value',
    'search_modifier_not_amount_is'                       => 'Amount is not :value',
    'search_modifier_amount_less'                         => 'Suma je menej alebo presne :value',
    'search_modifier_not_amount_more'                     => 'Amount is less than or equal to :value',
    'search_modifier_amount_more'                         => 'Suma je viac ako alebo presne :value',
    'search_modifier_not_amount_less'                     => 'Amount is more than or equal to :value',
    'search_modifier_source_account_is'                   => 'Názov zdrojového účtu je presne ":value"',
    'search_modifier_not_source_account_is'               => 'Source account name is not ":value"',
    'search_modifier_source_account_contains'             => 'Názov zdrojového účtu obsahuje ":value"',
    'search_modifier_not_source_account_contains'         => 'Source account name does not contain ":value"',
    'search_modifier_source_account_starts'               => 'Názov zdrojového účtu začína ":value"',
    'search_modifier_not_source_account_starts'           => 'Source account name does not start with ":value"',
    'search_modifier_source_account_ends'                 => 'Názov zdrojového účtu končí ":value"',
    'search_modifier_not_source_account_ends'             => 'Source account name does not end with ":value"',
    'search_modifier_source_account_id'                   => 'ID zdrojového účtu je ":value"',
    'search_modifier_not_source_account_id'               => 'Source account ID is not :value',
    'search_modifier_source_account_nr_is'                => 'Číslo zdrojového účtu (IBAN) je ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Source account number (IBAN) is not ":value"',
    'search_modifier_source_account_nr_contains'          => 'Číslo zdrojového účtu (IBAN) obsahuje ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Source account number (IBAN) does not contain ":value"',
    'search_modifier_source_account_nr_starts'            => 'Číslo zdrojového účtu (IBAN) začína ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Source account number (IBAN) does not start with ":value"',
    'search_modifier_source_account_nr_ends'              => 'Source account number (IBAN) ends on ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Source account number (IBAN) does not end on ":value"',
    'search_modifier_destination_account_is'              => 'Názov cieľového účtu je presne ":value"',
    'search_modifier_not_destination_account_is'          => 'Destination account name is not ":value"',
    'search_modifier_destination_account_contains'        => 'Názov cieľového účtu obsahuje ":value"',
    'search_modifier_not_destination_account_contains'    => 'Destination account name does not contain ":value"',
    'search_modifier_destination_account_starts'          => 'Názov cieľového účtu začína ":value"',
    'search_modifier_not_destination_account_starts'      => 'Destination account name does not start with ":value"',
    'search_modifier_destination_account_ends'            => 'Destination account name ends on ":value"',
    'search_modifier_not_destination_account_ends'        => 'Destination account name does not end on ":value"',
    'search_modifier_destination_account_id'              => 'ID cieľového účtu je :value',
    'search_modifier_not_destination_account_id'          => 'Destination account ID is not :value',
    'search_modifier_destination_is_cash'                 => 'Destination account is the "(cash)" account',
    'search_modifier_not_destination_is_cash'             => 'Destination account is not the "(cash)" account',
    'search_modifier_source_is_cash'                      => 'Source account is the "(cash)" account',
    'search_modifier_not_source_is_cash'                  => 'Source account is not the "(cash)" account',
    'search_modifier_destination_account_nr_is'           => 'Číslo cieľového účtu (IBAN) je ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Destination account number (IBAN) is ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Číslo cieľového účtu (IBAN) obsahuje ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Destination account number (IBAN) does not contain ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Číslo cieľového účtu (IBAN) začína ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Destination account number (IBAN) does not start with ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Číslo cieľového účtu (IBAN) končí ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Destination account number (IBAN) does not end with ":value"',
    'search_modifier_account_id'                          => 'ID zdrojového alebo cieľového účtu sú: :value',
    'search_modifier_not_account_id'                      => 'Source or destination account ID\'s is/are not: :value',
    'search_modifier_category_is'                         => 'Kategória je ":value"',
    'search_modifier_not_category_is'                     => 'Category is not ":value"',
    'search_modifier_budget_is'                           => 'Rozpočet je ":value"',
    'search_modifier_not_budget_is'                       => 'Budget is not ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Typ transakcie je ":value"',
    'search_modifier_not_transaction_type'                => 'Transaction type is not ":value"',
    'search_modifier_tag_is'                              => 'Štítok je ":value"',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'No tag is ":value"',
    'search_modifier_date_on_year'                        => 'Transaction is in year ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaction is not in year ":value"',
    'search_modifier_date_on_month'                       => 'Transaction is in month ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaction is not in month ":value"',
    'search_modifier_date_on_day'                         => 'Transaction is on day of month ":value"',
    'search_modifier_not_date_on_day'                     => 'Transaction is not on day of month ":value"',
    'search_modifier_date_before_year'                    => 'Transaction is before or in year ":value"',
    'search_modifier_date_before_month'                   => 'Transaction is before or in month ":value"',
    'search_modifier_date_before_day'                     => 'Transaction is before or on day of month ":value"',
    'search_modifier_date_after_year'                     => 'Transaction is in or after year ":value"',
    'search_modifier_date_after_month'                    => 'Transaction is in or after month ":value"',
    'search_modifier_date_after_day'                      => 'Transaction is after or on day of month ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'No tag is ":value"',
    'search_modifier_not_tag_is_not'                      => 'Tag is ":value"',
    'search_modifier_account_is'                          => 'Either account is ":value"',
    'search_modifier_not_account_is'                      => 'Neither account is ":value"',
    'search_modifier_account_contains'                    => 'Either account contains ":value"',
    'search_modifier_not_account_contains'                => 'Neither account contains ":value"',
    'search_modifier_account_ends'                        => 'Either account ends with ":value"',
    'search_modifier_not_account_ends'                    => 'Neither account ends with ":value"',
    'search_modifier_account_starts'                      => 'Either account starts with ":value"',
    'search_modifier_not_account_starts'                  => 'Neither account starts with ":value"',
    'search_modifier_account_nr_is'                       => 'Either account number / IBAN is ":value"',
    'search_modifier_not_account_nr_is'                   => 'Neither account number / IBAN is ":value"',
    'search_modifier_account_nr_contains'                 => 'Either account number / IBAN contains ":value"',
    'search_modifier_not_account_nr_contains'             => 'Neither account number / IBAN contains ":value"',
    'search_modifier_account_nr_ends'                     => 'Either account number / IBAN ends with ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Neither account number / IBAN ends with ":value"',
    'search_modifier_account_nr_starts'                   => 'Either account number / IBAN starts with ":value"',
    'search_modifier_not_account_nr_starts'               => 'Neither account number / IBAN starts with ":value"',
    'search_modifier_category_contains'                   => 'Category contains ":value"',
    'search_modifier_not_category_contains'               => 'Category does not contain ":value"',
    'search_modifier_category_ends'                       => 'Category ends on ":value"',
    'search_modifier_not_category_ends'                   => 'Category does not end on ":value"',
    'search_modifier_category_starts'                     => 'Category starts with ":value"',
    'search_modifier_not_category_starts'                 => 'Category does not start with ":value"',
    'search_modifier_budget_contains'                     => 'Budget contains ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget does not contain ":value"',
    'search_modifier_budget_ends'                         => 'Budget ends with ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget does not end on ":value"',
    'search_modifier_budget_starts'                       => 'Budget starts with ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget does not start with ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'External ID contains ":value"',
    'search_modifier_not_external_id_contains'            => 'External ID does not contain ":value"',
    'search_modifier_external_id_ends'                    => 'External ID ends with ":value"',
    'search_modifier_not_external_id_ends'                => 'External ID does not end with ":value"',
    'search_modifier_external_id_starts'                  => 'External ID starts with ":value"',
    'search_modifier_not_external_id_starts'              => 'External ID does not start with ":value"',
    'search_modifier_internal_reference_contains'         => 'Internal reference contains ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Internal reference does not contain ":value"',
    'search_modifier_internal_reference_ends'             => 'Internal reference ends with ":value"',
    'search_modifier_internal_reference_starts'           => 'Internal reference starts with ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Internal reference does not end with ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Internal reference does not start with ":value"',
    'search_modifier_external_url_is'                     => 'External URL is ":value"',
    'search_modifier_not_external_url_is'                 => 'External URL is not ":value"',
    'search_modifier_external_url_contains'               => 'External URL contains ":value"',
    'search_modifier_not_external_url_contains'           => 'External URL does not contain ":value"',
    'search_modifier_external_url_ends'                   => 'External URL ends with ":value"',
    'search_modifier_not_external_url_ends'               => 'External URL does not end with ":value"',
    'search_modifier_external_url_starts'                 => 'External URL starts with ":value"',
    'search_modifier_not_external_url_starts'             => 'External URL does not start with ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaction has no attachments',
    'search_modifier_not_has_no_attachments'              => 'Transaction has attachments',
    'search_modifier_not_has_attachments'                 => 'Transaction has no attachments',
    'search_modifier_account_is_cash'                     => 'Either account is the "(cash)" account.',
    'search_modifier_not_account_is_cash'                 => 'Neither account is the "(cash)" account.',
    'search_modifier_journal_id'                          => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                      => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                       => 'The recurring transaction ID is ":value"',
    'search_modifier_not_recurrence_id'                   => 'The recurring transaction ID is not ":value"',
    'search_modifier_foreign_amount_is'                   => 'The foreign amount is ":value"',
    'search_modifier_not_foreign_amount_is'               => 'The foreign amount is not ":value"',
    'search_modifier_foreign_amount_less'                 => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_more'             => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_less'             => 'The foreign amount is more than ":value"',
    'search_modifier_foreign_amount_more'                 => 'The foreign amount is more than ":value"',
    'search_modifier_exists'                              => 'Transaction exists (any transaction)',
    'search_modifier_not_exists'                          => 'Transaction does not exist (no transaction)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaction interest date is ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaction interest date is not ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaction interest date is in year ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaction interest date is in month ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaction interest date is on day of month ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaction interest date is before or in year ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                   => 'Transaction book date is in year ":value"',
    'search_modifier_book_date_on_month'                  => 'Transaction book date is in month ":value"',
    'search_modifier_book_date_on_day'                    => 'Transaction book date is on day of month ":value"',
    'search_modifier_not_book_date_on_year'               => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'              => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'               => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'              => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Transaction due date is in year ":value"',
    'search_modifier_due_date_on_month'                   => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Transaction due date is after or in year ":value"',
    'search_modifier_due_date_after_month'                => 'Transaction due date is after or in month ":value"',
    'search_modifier_due_date_after_day'                  => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                => 'Transaction payment date is in year ":value"',
    'search_modifier_payment_date_on_month'               => 'Transaction payment date is in month ":value"',
    'search_modifier_payment_date_on_day'                 => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'             => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaction invoice date is in month ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaction invoice date is on day of month ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaction invoice date is before or in year ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaction invoice date is before or in month ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaction invoice date is before or on day of month ":value"',
    'search_modifier_invoice_date_after_year'             => 'Transaction invoice date is after or in year ":value"',
    'search_modifier_invoice_date_after_month'            => 'Transaction invoice date is after or in month ":value"',
    'search_modifier_invoice_date_after_day'              => 'Transaction invoice date is after or on day of month ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaction was last updated in year ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaction was last updated in month ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaction was last updated on day of month ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaction was last updated in or before year ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaction was last updated in or before month ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaction was last updated on or before day of month ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaction was last updated in or after year ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                  => 'Transaction was created in year ":value"',
    'search_modifier_created_at_on_month'                 => 'Transaction was created in month ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'             => 'Transaction was created in or before month ":value"',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'              => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                    => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                       => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                    => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'            => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'      => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'        => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'          => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'          => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'     => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'       => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'         => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'        => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => 'Aktualizovať pravidlo ":rule" vyhľadávaným výrazom',
    'create_rule_from_query'                        => 'Vytvoriť z vyhľadávaného výrazu nové pravidlo',
    'rule_from_search_words'                        => 'Pravidlo má ťažkosti so spracovaním „:string“. Navrhované pravidlo, ktoré vyhovuje vášmu vyhľadávaciemu pojmu, môže poskytnúť rôzne výsledky. Dôkladne skontrolujte spúšťače pravidiel.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'Pri hľadaní sa vyskytla chyba. Ďalšie informácie nájdete v súboroch denníka.',
    'search_box'                                          => 'Hľadať',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Chyba pri vyhľadávaní',
    'search_searching'                                    => 'Vyhľadáva sa …',
    'search_results'                                      => 'Výsledky vyhľadávania',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'ročne',
    'repeat_freq_half-year'                               => 'polročne',
    'repeat_freq_quarterly'                               => 'štvrťročne',
    'repeat_freq_monthly'                                 => 'mesačne',
    'repeat_freq_weekly'                                  => 'týždenne',
    'repeat_freq_daily'                                   => 'daily',
    'daily'                                               => 'daily',
    'weekly'                                              => 'týždenne',
    'quarterly'                                           => 'štvrťročne',
    'half-year'                                           => 'polročne',
    'yearly'                                              => 'ročne',

    // rules
    'is_not_rule_trigger'                                 => 'Not',
    'cannot_fire_inactive_rules'                          => 'Neaktívne pravidlá nie je možné spustiť.',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'Pravidlá',
    'rule_name'                                           => 'Názov pravidla',
    'rule_triggers'                                       => 'Pravidlo se uplatní, ak',
    'rule_actions'                                        => 'Pravidlo bude',
    'new_rule'                                            => 'Nové pravidlo',
    'new_rule_group'                                      => 'Nová skupina pravidiel',
    'rule_priority_up'                                    => 'Zvýšiť prioritu pravidla',
    'rule_priority_down'                                  => 'Znížiť prioritu pravidla',
    'make_new_rule_group'                                 => 'Vytvoriť novú skupinu pravidiel',
    'store_new_rule_group'                                => 'Uložiť novú skupinu pravidiel',
    'created_new_rule_group'                              => 'Nová skupina pravidiel „:title“ uložená!',
    'updated_rule_group'                                  => 'Skupina pravidiel „:title“ úspešne aktualizovaná.',
    'edit_rule_group'                                     => 'Upraviť skupinu pravidiel „:title“',
    'duplicate_rule'                                      => 'Duplikovať pravidlo ":title"',
    'rule_copy_of'                                        => 'Kópia ":title"',
    'duplicated_rule'                                     => 'Duplikovať pravidlo ":title" do ":newTitle"',
    'delete_rule_group'                                   => 'Odstrániť skupinu pravidiel „:title“',
    'deleted_rule_group'                                  => 'Skupina pravidel „:title“ bola odstránená',
    'update_rule_group'                                   => 'Aktualizovať skupinu pravidiel',
    'no_rules_in_group'                                   => 'Táto skupina neobsahuje žiadne pravidlá',
    'move_rule_group_up'                                  => 'Posunúť skupinu pravidiel nahor',
    'move_rule_group_down'                                => 'Posunúť skupinu pravidiel nadol',
    'save_rules_by_moving'                                => 'Toto pravidlo uložte presunutím do inej skupiny pravidiel:|Tieto pravidlá uložte presunutím do inej skupiny pravidiel:',
    'make_new_rule'                                       => 'Vytvoriť nové pravidlo v skupine pravidiel „:title“',
    'make_new_rule_no_group'                              => 'Vytvoriť nové pravidlo',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Vytvorte pravidlo na základe jednej z vašich transakcií. Vyplňte alebo odošlite formulár uvedený nižšie.',
    'rule_is_strict'                                      => 'striktné pravidlo',
    'rule_is_not_strict'                                  => 'nestriktné pravidlo',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'V prípade, že sa majú akcie vykonať, musia byť splnené prísne pravidlá VŠETKY spúšťače. V prípade voľnejších pravidiel stačí na vykonanie akcie ľubovoľný spúšťač.',
    'rule_help_active'                                    => 'Neaktívne pravidlá sa nikdy nespustia.',
    'stored_new_rule'                                     => 'Uložené nové pravidlo nazvané „:title“',
    'deleted_rule'                                        => 'Pravidlo nazvané „:title“ bolo odstránené',
    'store_new_rule'                                      => 'Uložiť nové pravidlo',
    'updated_rule'                                        => 'Pravidlo nazvané „:title“ aktualizované',
    'default_rule_group_name'                             => 'Východzie pravidlá',
    'default_rule_group_description'                      => 'Ani jedno vaše pravidlo nepatrí do skupiny.',
    'trigger'                                             => 'Spúšťač',
    'trigger_value'                                       => 'Spustiť pri hodnote',
    'stop_processing_other_triggers'                      => 'Zastaviť spracovávanie ostatných spúšťačov',
    'add_rule_trigger'                                    => 'Pridať nový spúšťač',
    'action'                                              => 'Akcia',
    'action_value'                                        => 'Hodnota akcie',
    'stop_executing_other_actions'                        => 'Zastaviť vykonávanie ostatných akcií',
    'add_rule_action'                                     => 'Pridať novú akciu',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Odstrániť pravidlo „:title“',
    'update_rule'                                         => 'Upraviť pravidlo',
    'test_rule_triggers'                                  => 'Zobraziť zodpovedajúce transakcie',
    'warning_no_matching_transactions'                    => 'Nenašli sa žiadne zodpovedajúce transakcie.',
    'warning_no_valid_triggers'                           => 'Neposkytli ste žiadne platné spúšťače.',
    'apply_rule_selection'                                => 'Uplatniť pravidlo „:title“ na vybrané transakcie',
    'apply_rule_selection_intro'                          => 'Pravidlá ako „:title“ sa zvyčajne uplatňujú iba na nové alebo aktualizované transakcie, môžete však Firefly III povedať, aby ho spustil pri výbere vašich existujúcich transakcií. To môže byť užitočné, keď ste aktualizovali pravidlo a potrebujete zmeny, ktoré sa majú uplatniť na všetky vaše ďalšie transakcie.',
    'include_transactions_from_accounts'                  => 'Zahrnúť transakcie z týchto účtov',
    'include'                                             => 'Zahrnúť?',
    'applied_rule_selection'                              => '{0} Pravidlom ":title" nebola zmenená žiadna transakcia vo výbere.|[1] Pravidlom ":title" bola zmenená jedna transakcia.|[2,*] Pravidlom ":title" bolo zmenených :count transakcií.',
    'execute'                                             => 'Vykonať',
    'apply_rule_group_selection'                          => 'Uplatniť skupinu pravidiel „:title“ na vybrané transakcie',
    'apply_rule_group_selection_intro'                    => 'Skupiny pravidiel ako „:title“ sa zvyčajne používajú iba na nové alebo aktualizované transakcie, ale môžete Firefly III povedať, aby pri výbere vašich existujúcich transakcií spustil všetky pravidlá v tejto skupine. To môže byť užitočné, keď ste aktualizovali skupinu pravidiel a potrebujete zmeny, ktoré sa majú uplatniť na všetky vaše ďalšie transakcie.',
    'applied_rule_group_selection'                        => 'Skupina pravidiel „:title“ bola uplatnená na váš výber.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Kedy bola transakcia vytvorená',
    'rule_trigger_update_journal'                         => 'Kedy bola transakcia aktualizovaná',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'Použivateľská akcia je „:trigger_value“',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Názov zdrojového účtu začína..',
    'rule_trigger_source_account_starts'                  => 'Názov zdrojového účtu začína ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Názov zdrojového účtu končí..',
    'rule_trigger_source_account_ends'                    => 'Názov zdrojového účtu končí ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Názov zdrojového účtu je..',
    'rule_trigger_source_account_is'                      => 'Názov zdrojového účtu je ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Názov zdrojového účtu obsahuje..',
    'rule_trigger_source_account_contains'                => 'Názov zdrojového účtu obsahuje ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Either account ID is exactly..',
    'rule_trigger_account_id'                             => 'Either account ID is exactly :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'ID zdrojového účtu je presne..',
    'rule_trigger_source_account_id'                      => 'ID zdrojového účtu je presne :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Názov cieľového účtu je presne..',
    'rule_trigger_destination_account_id'                 => 'ID cieľového účtu je presne :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Either account is cash',
    'rule_trigger_account_is_cash'                        => 'Either account is cash',
    'rule_trigger_source_is_cash_choice'                  => 'Zdrojový účet je (hotovostný) účet',
    'rule_trigger_source_is_cash'                         => 'Zdrojový účet je (hotovostný) účet',
    'rule_trigger_destination_is_cash_choice'             => 'Cieľový účet je (hotovostný) účet',
    'rule_trigger_destination_is_cash'                    => 'Cieľový účet je (hotovostný) účet',
    'rule_trigger_source_account_nr_starts_choice'        => 'Číslo cieľového účtu / IBAN začína..',
    'rule_trigger_source_account_nr_starts'               => 'Číslo zdrojového účtu / IBAN začína ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Číslo zdrojového účtu / IBAN končí..',
    'rule_trigger_source_account_nr_ends'                 => 'Číslo zdrojového účtu končí ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Číslo zdrojového účtu / IBAN je..',
    'rule_trigger_source_account_nr_is'                   => 'Číslo zdrojového účtu je ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Číslo zdrojového účtu / IBAN obsahuje..',
    'rule_trigger_source_account_nr_contains'             => 'Číslo zdrojového účtu obsahuje ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Názov cieľového účtu začína..',
    'rule_trigger_destination_account_starts'             => 'Názov cieľového účtu začína ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Názov cieľového účtu končí..',
    'rule_trigger_destination_account_ends'               => 'Názov cieľového účtu končí ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Názov cieľového účtu je..',
    'rule_trigger_destination_account_is'                 => 'Názov cieľového účtu je ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Názov cieľového účtu obsahuje..',
    'rule_trigger_destination_account_contains'           => 'Názov cieľového účtu obsahuje ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Číslo cieľového účtu / IBAN začína..',
    'rule_trigger_destination_account_nr_starts'          => 'Číslo cieľového účtu / IBAN začína ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Názov cieľového účtu / IBAN končí..',
    'rule_trigger_destination_account_nr_ends'            => 'Číslo cieľového účtu / IBAN končí ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Názov cieľového účtu / IBAN je..',
    'rule_trigger_destination_account_nr_is'              => 'Číslo cieľového účtu / IBAN je ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Názov cieľového účtu / IBAN obsahuje..',
    'rule_trigger_destination_account_nr_contains'        => 'Číslo cieľového účtu / IBAN obsahuje ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transakcia je typu..',
    'rule_trigger_transaction_type'                       => 'Transakcia je typu ":trigger_value“',
    'rule_trigger_category_is_choice'                     => 'Kategória je..',
    'rule_trigger_category_is'                            => 'Kategória je „:trigger_value“',
    'rule_trigger_amount_less_choice'                     => 'Amount is less than or equal to ..',
    'rule_trigger_amount_less'                            => 'Amount is less than or equal to :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Amount is..',
    'rule_trigger_amount_is'                              => 'Amount is :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Amount is more than or equal to..',
    'rule_trigger_amount_more'                            => 'Amount is more than or equal to :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Popis začína..',
    'rule_trigger_description_starts'                     => 'Popis začína ":trigger_value“',
    'rule_trigger_description_ends_choice'                => 'Popis končí..',
    'rule_trigger_description_ends'                       => 'Popis končí ":trigger_value“',
    'rule_trigger_description_contains_choice'            => 'Popis obsahuje..',
    'rule_trigger_description_contains'                   => 'Popis obsahuje ":trigger_value“',
    'rule_trigger_description_is_choice'                  => 'Popis je..',
    'rule_trigger_description_is'                         => 'Popis je ":trigger_value“',
    'rule_trigger_date_on_choice'                         => 'Transaction date is..',
    'rule_trigger_date_on'                                => 'Transaction date is ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Dátum transakcie je pred..',
    'rule_trigger_date_before'                            => 'Dátum transakcie je pred ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Dátum transakcie je po..',
    'rule_trigger_date_after'                             => 'Dátum transakcie je po ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transaction was made on..',
    'rule_trigger_created_at_on'                          => 'Transaction was made on ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaction was last edited on..',
    'rule_trigger_updated_at_on'                          => 'Transaction was last edited on ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Rozpočet je…',
    'rule_trigger_budget_is'                              => 'Rozpočet je „:trigger_value“',
    'rule_trigger_tag_is_choice'                          => 'Any tag is..',
    'rule_trigger_tag_is'                                 => 'Any tag is ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Mena transakcie je..',
    'rule_trigger_currency_is'                            => 'Mena transakcie je „:trigger_value“',
    'rule_trigger_foreign_currency_is_choice'             => 'Cudzia mena transakcie je..',
    'rule_trigger_foreign_currency_is'                    => 'Cudzia mena transakcie je ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Nemá žiadnu kategóriu',
    'rule_trigger_has_no_category'                        => 'Transakcia nemá žiadnu kategóriu',
    'rule_trigger_has_any_category_choice'                => 'Má (ľubovoľnú) kategóriu',
    'rule_trigger_has_any_category'                       => 'Transakcia má (ľubovoľnú) kategóriu',
    'rule_trigger_has_no_budget_choice'                   => 'Nemá žiadny rozpočet',
    'rule_trigger_has_no_budget'                          => 'Transakcia nemá žiadny rozpočet',
    'rule_trigger_has_any_budget_choice'                  => 'Má (ľubovoľný) rozpočet',
    'rule_trigger_has_any_budget'                         => 'Transakcia má (ľubovoľný) rozpočet',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Nemá žiadne štítky',
    'rule_trigger_has_no_tag'                             => 'Transakcia nemá žiadne štítky',
    'rule_trigger_has_any_tag_choice'                     => 'Má jeden alebo viac štítkov',
    'rule_trigger_has_any_tag'                            => 'Transakcia má jeden alebo viac štítkov',
    'rule_trigger_any_notes_choice'                       => 'Má (akékoľvek) poznámky',
    'rule_trigger_any_notes'                              => 'Transakcia má (akékoľvek) poznámky',
    'rule_trigger_no_notes_choice'                        => 'Nemá žiadne poznámky',
    'rule_trigger_no_notes'                               => 'Transakcia nemá žiadne poznámky',
    'rule_trigger_notes_is_choice'                        => 'Notes are..',
    'rule_trigger_notes_is'                               => 'Notes are ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notes contain..',
    'rule_trigger_notes_contains'                         => 'Notes contain ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notes start with..',
    'rule_trigger_notes_starts'                           => 'Notes start with ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notes end with..',
    'rule_trigger_notes_ends'                             => 'Notes end with ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'External ID is..',
    'rule_trigger_external_id_is'                         => 'External ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                  => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'ID denníka transakcií je..',
    'rule_trigger_journal_id'                             => 'ID denníka transakcií je ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Transaction has no external URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaction has no external ID',
    'rule_trigger_id_choice'                              => 'Transaction ID is..',
    'rule_trigger_id'                                     => 'Transaction ID is ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'User action is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'No tag is..',
    'rule_trigger_tag_is_not'                             => 'No tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Either account is exactly..',
    'rule_trigger_account_is'                             => 'Either account is exactly ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Either account contains..',
    'rule_trigger_account_contains'                       => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Either account ends with..',
    'rule_trigger_account_ends'                           => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Either account starts with..',
    'rule_trigger_account_starts'                         => 'Either account starts with ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                    => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                        => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                      => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Category contains..',
    'rule_trigger_category_contains'                      => 'Category contains ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Category ends with..',
    'rule_trigger_category_ends'                          => 'Category ends with ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Category starts with..',
    'rule_trigger_category_starts'                        => 'Category starts with ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget contains..',
    'rule_trigger_budget_contains'                        => 'Budget contains ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget ends with..',
    'rule_trigger_budget_ends'                            => 'Budget ends with ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget starts with..',
    'rule_trigger_budget_starts'                          => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'External ID contains..',
    'rule_trigger_external_id_contains'                   => 'External ID contains ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'External ID ends with..',
    'rule_trigger_external_id_ends'                       => 'External ID ends with ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'External ID starts with..',
    'rule_trigger_external_id_starts'                     => 'External ID starts with ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'            => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'              => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'External URL is..',
    'rule_trigger_external_url_is'                        => 'External URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'External URL contains..',
    'rule_trigger_external_url_contains'                  => 'External URL contains ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'External URL ends with..',
    'rule_trigger_external_url_ends'                      => 'External URL ends with ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'External URL starts with..',
    'rule_trigger_external_url_starts'                    => 'External URL starts with ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Has no attachments',
    'rule_trigger_has_no_attachments'                     => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                   => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                          => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Interest date is on..',
    'rule_trigger_interest_date_on'                       => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Interest date is before..',
    'rule_trigger_interest_date_before'                   => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Interest date is after..',
    'rule_trigger_interest_date_after'                    => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Book date is before..',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Process date is on..',
    'rule_trigger_process_date_on'                        => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Process date is before..',
    'rule_trigger_process_date_before'                    => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Process date is after..',
    'rule_trigger_process_date_after'                     => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Due date is on..',
    'rule_trigger_due_date_on'                            => 'Due date is on ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Due date is before..',
    'rule_trigger_due_date_before'                        => 'Due date is before ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Due date is after..',
    'rule_trigger_due_date_after'                         => 'Due date is after ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Payment date is on..',
    'rule_trigger_payment_date_on'                        => 'Payment date is on ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Payment date is before..',
    'rule_trigger_payment_date_before'                    => 'Payment date is before ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Payment date is after..',
    'rule_trigger_payment_date_after'                     => 'Payment date is after ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                        => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                    => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                     => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaction was created before..',
    'rule_trigger_created_at_before'                      => 'Transaction was created before ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaction was created after..',
    'rule_trigger_created_at_after'                       => 'Transaction was created after ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaction was last updated before..',
    'rule_trigger_updated_at_before'                      => 'Transaction was last updated before ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaction was last updated after..',
    'rule_trigger_updated_at_after'                       => 'Transaction was last updated after ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                     => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'               => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                 => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                   => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Any attachment\'s notes are..',
    'rule_trigger_attachment_notes_are'                   => 'Any attachment\'s notes are ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Any attachment\'s notes contain..',
    'rule_trigger_attachment_notes_contains'              => 'Any attachment\'s notes contain ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Any attachment\'s notes start with..',
    'rule_trigger_attachment_notes_starts'                => 'Any attachment\'s notes start with ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Any attachment\'s notes end with..',
    'rule_trigger_attachment_notes_ends'                  => 'Any attachment\'s notes end with ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaction is reconciled',
    'rule_trigger_reconciled'                             => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                          => 'Any transaction matches(!)',
    'rule_trigger_exists'                                 => 'Any transaction matches',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Destination account ID is not ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag is not ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                             => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                    => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                   => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaction has no tags',
    'rule_trigger_not_any_notes'                          => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                   => 'Transaction has no external URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaction has a (any) attachment(s)',
    'rule_trigger_not_has_no_category'                    => 'Transaction has a (any) category',
    'rule_trigger_not_has_no_budget'                      => 'Transaction has a (any) budget',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaction has a (any) tag',
    'rule_trigger_not_no_notes'                           => 'Transaction has any notes',
    'rule_trigger_not_no_external_url'                    => 'Transaction has an external URL',
    'rule_trigger_not_source_is_cash'                     => 'Source account is not a cash account',
    'rule_trigger_not_destination_is_cash'                => 'Destination account is not a cash account',
    'rule_trigger_not_account_is_cash'                    => 'Neither account is a cash account',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'DELETE transaction(!)',
    'rule_action_delete_transaction'             => 'DELETE transaction(!)',
    'rule_action_set_category'                   => 'Nastaviť kategóriu na „:action_value“',
    'rule_action_clear_category'                 => 'Odstrániť kategóriu',
    'rule_action_set_budget'                     => 'Nastaviť rozpočet na „:action_value“',
    'rule_action_clear_budget'                   => 'Odstrániť rozpočet',
    'rule_action_add_tag'                        => 'Pridať štítok „:action_value“',
    'rule_action_remove_tag'                     => 'Odsteániť štítok „:action_value“',
    'rule_action_remove_all_tags'                => 'Odstrániť všetky štítky',
    'rule_action_set_description'                => 'Nastaviť popis na „:action_value“',
    'rule_action_append_description'             => 'Pripojiť popis s „:action_value“',
    'rule_action_prepend_description'            => 'Pred popis pridať „:action_value“',
    'rule_action_set_category_choice'            => 'Set category to ..',
    'rule_action_clear_category_choice'          => 'Odstrániť všetky kategórie',
    'rule_action_set_budget_choice'              => 'Set budget to ..',
    'rule_action_clear_budget_choice'            => 'Odsteániť všetky rozpočty',
    'rule_action_add_tag_choice'                 => 'Add tag ..',
    'rule_action_remove_tag_choice'              => 'Remove tag ..',
    'rule_action_remove_all_tags_choice'         => 'Odstrániť všetky štítky',
    'rule_action_set_description_choice'         => 'Set description to ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Append description with ..',
    'rule_action_prepend_description_choice'     => 'Prepend description with ..',
    'rule_action_set_source_account_choice'      => 'Set source account to ..',
    'rule_action_set_source_account'             => 'Nastaviť účet na :action_value',
    'rule_action_set_destination_account_choice' => 'Set destination account to ..',
    'rule_action_set_destination_account'        => 'Nastaviť cieľový účet na :action_value',
    'rule_action_append_notes_choice'            => 'Append notes with ..',
    'rule_action_append_notes'                   => 'Pridať za poznámky „:action_value“',
    'rule_action_prepend_notes_choice'           => 'Prepend notes with ..',
    'rule_action_prepend_notes'                  => 'Pridať pred poznámky „:action_value“',
    'rule_action_clear_notes_choice'             => 'Odstrániť všetky poznámky',
    'rule_action_clear_notes'                    => 'Odstrániť všetky poznámky',
    'rule_action_set_notes_choice'               => 'Set notes to ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                => 'Switch source and destination',
    'rule_action_set_notes'                      => 'Nastavit poznámky na „:action_value“',
    'rule_action_convert_deposit_choice'         => 'Zmeniť túto transakciu na vklad',
    'rule_action_convert_deposit'                => 'Zmeniť túto transakciu z vkladu na „:action_value“',
    'rule_action_convert_withdrawal_choice'      => 'Zmeniť transakciu na výběr',
    'rule_action_convert_withdrawal'             => 'Zmeniť túto transakciu na vklad do „:action_value“',
    'rule_action_convert_transfer_choice'        => 'Zmeniť túto transakciu na prevod',
    'rule_action_convert_transfer'               => 'Zmeniť túto transakciu na prevod s „:action_value“',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'     => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'          => 'Append description to notes',
    'rule_action_append_notes_to_descr'          => 'Append notes to description',
    'rule_action_move_descr_to_notes'            => 'Replace notes with description',
    'rule_action_move_notes_to_descr'            => 'Replace description with notes',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Pravidlo založené na transakcii ":description"',
    'new_rule_for_journal_description'          => 'Toto pravidlo je založené na transakcii ":description". Zachytí transakcie, ktoré sú presne také isté.',

    // tags
    'store_new_tag'                             => 'Uložiť nový štítok',
    'update_tag'                                => 'Upraviť štítok',
    'no_location_set'                           => 'Žiadna poloha.',
    'meta_data'                                 => 'Metadata',
    'location'                                  => 'Poloha',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Bez dátumu',
    'result'                                    => 'Výsledok',
    'sums_apply_to_range'                       => 'Všetky súčty sa vzťahujú na vybraný rozsah',
    'mapbox_api_key'                            => 'Pre použitie mapy získajte API kľúč z <a href="https://www.mapbox.com/">Mapboxu</a>. Otvorte súbor <code>.env</code> a tento kľúč vložte za <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Pre nastavenie pozície objektu kliknite pravým tlačítkom alebo kliknite a podržte.',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Odstrániť pozíciu',
    'delete_all_selected_tags'                  => 'Odstrániť všetky vybraté štítky',
    'select_tags_to_delete'                     => 'Nezabudnite vybrať nejaké štítky.',
    'deleted_x_tags'                            => ':count štítok bol odstránený.|:count štítkov bolo odstránených.',
    'create_rule_from_transaction'              => 'Vytvoriť na základe transakcie štítok',
    'create_recurring_from_transaction'         => 'Vytvoriť na základe transakcie opakovanú transakciu',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Let your browser decide',
    'dark_mode_option_light'                    => 'Always light',
    'dark_mode_option_dark'                     => 'Always dark',
    'equal_to_language'                         => '(rovné jazyku)',
    'dark_mode_preference'                      => 'Dark mode',
    'dark_mode_preference_help'                 => 'Tell Firefly III when to use dark mode.',
    'pref_home_screen_accounts'                 => 'Účty na úvodnej obrazovke',
    'pref_home_screen_accounts_help'            => 'Ktoré účty zobraziť na úvodnej stránke?',
    'pref_view_range'                           => 'Zobraziť rozsah',
    'pref_view_range_help'                      => 'Niektoré grafy sú automaticky zoskupené podľa období. Vaše rozpočty budú tiež zoskupené podľa období. Aké obdobie by ste uprednostnili?',
    'pref_1D'                                   => 'Jeden deň',
    'pref_1W'                                   => 'Jeden týždeň',
    'pref_1M'                                   => 'Jeden mesiac',
    'pref_3M'                                   => 'Tri mesiace (štvrťrok)',
    'pref_6M'                                   => 'Šesť mesiacov',
    'pref_1Y'                                   => 'Jeden rok',
    'pref_last365'                              => 'Last year',
    'pref_last90'                               => 'Last 90 days',
    'pref_last30'                               => 'Last 30 days',
    'pref_last7'                                => 'Last 7 days',
    'pref_YTD'                                  => 'Year to date',
    'pref_QTD'                                  => 'Quarter to date',
    'pref_MTD'                                  => 'Month to date',
    'pref_languages'                            => 'Jazyky',
    'pref_locale'                               => 'Miestne nastavenia',
    'pref_languages_help'                       => 'Firefly III podporuje niekoľko jazykov – v ktorom ho chcete používať?',
    'pref_locale_help'                          => 'Firefly III vám umožňuje nastaviť ďalšie nastavenia, ako napríklad formátovanie mien, čísel a údajov. Položky v tomto zozname nemusia byť podporované vašim systémom. Firefly III nemá správne nastavené správne údaje pre všetky lokalizácie. Pre vylepšenie ma kontaktujte.',
    'pref_locale_no_demo'                       => 'Táto vlastnosť nebude pre demo použivateľa fungovať.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Nastavenie fiškálneho roku',
    'pref_custom_fiscal_year_label'             => 'Zapnuté',
    'pref_custom_fiscal_year_help'              => 'Pre krajiny, v ktorých fiškálny rok nezačína 1. januára a tým pádom ani nekončí 31. decembra, je tu možné nastaviť iný začiatok a koniec',
    'pref_fiscal_year_start_label'              => 'Dátum začiatku fiškálneho roka',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Nezabudnite tento účet odstrániť z overovacej aplikácie!',
    'pref_two_factor_auth_code'                 => 'Overiť kód',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Obnoviť overovací kód',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'Ak nemôžete naskenovať QR kód, použite namiesto neho tajný kľúč: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Tieto záložné kódy si odložte, pre prípad straty vášho zariadenia.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Tento MFA kód nie je platný.',
    'pref_save_settings'                        => 'Uložiť nastavenia',
    'saved_preferences'                         => 'Predvoľby uložené!',
    'preferences_general'                       => 'Všeobecné',
    'preferences_frontpage'                     => 'Úvodná obrazovka',
    'preferences_security'                      => 'Zabezpečenie',
    'preferences_layout'                        => 'Rozvrhnutie',
    'preferences_notifications'                 => 'Notifications',
    'pref_home_show_deposits'                   => 'Zobrazovať vklady na úvodnej obrazovke',
    'pref_home_show_deposits_info'              => 'Úvodná obrazovka už zobrazuje vaše výdavkové účty. Majú sa zobraziť aj príjmové?',
    'pref_home_do_show_deposits'                => 'Áno, zobraziť ich',
    'successful_count'                          => 'z toho :count úspešné',
    'list_page_size_title'                      => 'Počet na stranu',
    'list_page_size_help'                       => 'Akýkoľvek zoznam údajov (účty, transakcie, atď) zobrazuje toto maximum na stránku.',
    'list_page_size_label'                      => 'Veľkosť stránky',
    'between_dates'                             => '(:start a :end)',
    'pref_optional_fields_transaction'          => 'Voliteľné údaje pre transakcie',
    'pref_optional_fields_transaction_help'     => 'Pri vytváraní novej transakcie nie sú predvolene povolené všetky polia (kvôli neprehľadnosti). Nižšie môžete tieto polia povoliť, ak si myslíte, že by mohli byť pre vás užitočné. Samozrejme, každé pole, ktoré je zakázané, ale už je vyplnené, bude viditeľné bez ohľadu na nastavenie.',
    'optional_tj_date_fields'                   => 'Políčka pre dátum',
    'optional_tj_other_fields'                  => 'Iné údaje',
    'optional_tj_attachment_fields'             => 'Políčka pre prílohy',
    'pref_optional_tj_interest_date'            => 'Úrokový dátum',
    'pref_optional_tj_book_date'                => 'Dátum rezervácie',
    'pref_optional_tj_process_date'             => 'Dátum spracovania',
    'pref_optional_tj_due_date'                 => 'Dátum splatnosti',
    'pref_optional_tj_payment_date'             => 'Dátum úhrady',
    'pref_optional_tj_invoice_date'             => 'Dátum vystavenia',
    'pref_optional_tj_internal_reference'       => 'Interná referencia',
    'pref_optional_tj_notes'                    => 'Poznámky',
    'pref_optional_tj_attachments'              => 'Prílohy',
    'pref_optional_tj_external_url'             => 'External URL',
    'pref_optional_tj_location'                 => 'Poloha',
    'pref_optional_tj_links'                    => 'Prepojenia transakcie',
    'optional_field_meta_dates'                 => 'Dátumy',
    'optional_field_meta_business'              => 'Spoločnosť',
    'optional_field_attachments'                => 'Prílohy',
    'optional_field_meta_data'                  => 'Voliteľné metadata',
    'external_url'                              => 'Externá URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Alert when a new API access token is created',
    'pref_notification_transaction_creation'    => 'Alert when a transaction is created automatically',
    'pref_notification_user_login'              => 'Alert when you login from a new location',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Notifications',
    'pref_notifications_help'                   => 'Indicate if these are notifications you would like to get. Some notifications may contain sensitive financial information.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Financial administration',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Purge data from Firefly III',
    'purge_data_expl'                           => '"Purging" means "deleting that which is already deleted". In normal circumstances, Firefly III deletes nothing permanently. It just hides it. The button below deletes all of these previously "deleted" records FOREVER.',
    'delete_stuff_header'                       => 'Delete and purge data',
    'purge_all_data'                            => 'Purge all deleted records',
    'purge_data'                                => 'Purge data',
    'purged_all_records'                        => 'All deleted records have been purged.',
    'delete_data_title'                         => 'Delete data from Firefly III',
    'permanent_delete_stuff'                    => 'You can delete stuff from Firefly III. Using the buttons below means that your items will be removed from view and hidden. There is no undo-button for this, but the items may remain in the database where you can salvage them if necessary.',
    'other_sessions_logged_out'                 => 'Všetky vaše sedenia boli odhlásené.',
    'delete_unused_accounts'                    => 'Deleting unused accounts will clean your auto-complete lists.',
    'delete_all_unused_accounts'                => 'Delete unused accounts',
    'deleted_all_unused_accounts'               => 'All unused accounts are deleted',
    'delete_all_budgets'                        => 'Odstrániť VŠETKY vaše rozpočty',
    'delete_all_categories'                     => 'Odstrániť VŠETKY vaše kategórie',
    'delete_all_tags'                           => 'Odstrániť VŠETKY vaše štítky',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Odstrániť VŠETKY vaše pokladničky',
    'delete_all_rules'                          => 'Odstrániť VŠETKY vaše pravidlá',
    'delete_all_recurring'                      => 'Odstrániť VŠETKY vaše opakujúce sa transakcie',
    'delete_all_object_groups'                  => 'Odstrániť VŠETKY vaše skupiny objektov',
    'delete_all_accounts'                       => 'Odstrániť VŠETKY vaše účty',
    'delete_all_asset_accounts'                 => 'Odstrániť VŠETKY vaše účty aktív',
    'delete_all_expense_accounts'               => 'Odstrániť VŠETKY výdavkové účty',
    'delete_all_revenue_accounts'               => 'Odstrániť VŠETKY vaše výnosové účty',
    'delete_all_liabilities'                    => 'Odstrániť VŠETKY vaše záväzky',
    'delete_all_transactions'                   => 'Odstrániť VŠETKY vaše transakcie',
    'delete_all_withdrawals'                    => 'Odstrániť VŠETKY vaše výbery',
    'delete_all_deposits'                       => 'Odstrániť VŠETKY vaše vklady',
    'delete_all_transfers'                      => 'Odstrániť VŠETKY vaše prevody',
    'also_delete_transactions'                  => 'Odstránením účtov sa tiež odstránia VŠETKY previazané výbery, vklady a prevody!',
    'deleted_all_budgets'                       => 'Všetky rozpočty boli odstránené',
    'deleted_all_categories'                    => 'Všetky kategórie boli odstránené',
    'deleted_all_tags'                          => 'Všetky štítky boli odstránené',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Všetky pokladničky boli odstránené',
    'deleted_all_rules'                         => 'Všetky pravidlá a skupiny pravidiel boli odstránené',
    'deleted_all_object_groups'                 => 'Všetky skupiny boli odstránené',
    'deleted_all_accounts'                      => 'Všetky účty boli odstránené',
    'deleted_all_asset_accounts'                => 'Všetky účty aktív boli odstránené',
    'deleted_all_expense_accounts'              => 'Všetky výdavkové účty boli odstránené',
    'deleted_all_revenue_accounts'              => 'Všetky výnosové účty boli odstránené',
    'deleted_all_liabilities'                   => 'Všetky záväzky boli odstránené',
    'deleted_all_transactions'                  => 'Všetky transakcie boli odstránené',
    'deleted_all_withdrawals'                   => 'Všetky výbery boli odstránené',
    'deleted_all_deposits'                      => 'Všetky vklady boli odstránené',
    'deleted_all_transfers'                     => 'Všetky prevody boli odstránené',
    'deleted_all_recurring'                     => 'Všetky opakované transakcie boli odstránené',
    'change_your_password'                      => 'Zmeňte si heslo',
    'delete_account'                            => 'Odstrániť účet',
    'current_password'                          => 'Aktuálne heslo',
    'new_password'                              => 'Nové heslo',
    'new_password_again'                        => 'Nové heslo (kontrola)',
    'delete_your_account'                       => 'Odstráňte svoj účet',
    'delete_your_account_help'                  => 'Pri odstránení vášho účtu sa zmažú všetky účty, transakcie, <em>všetko</em>, čo ste vo Firefly III uložili. Bude to PREČ.',
    'delete_your_account_password'              => 'Pokračujte zadaním svojho hesla.',
    'password'                                  => 'Heslo',
    'are_you_sure'                              => 'Ste si istí? Túto akciu nie je možné vrátiť späť.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'Odstrániť účet',
    'invalid_current_password'                  => 'Neplatné aktuálne heslo!',
    'password_changed'                          => 'Heslo zmenené!',
    'should_change'                             => 'Cieľom je zmeniť vaše heslo.',
    'invalid_password'                          => 'Neplatné heslo!',
    'what_is_pw_security'                       => 'Čo znamená „overiť bezpečnosť hesla“?',
    'secure_pw_title'                           => 'Ako zvoliť bezpečné heslo',
    'forgot_password_response'                  => 'Thank you. If an account exists with this email address, you will find instructions in your inbox.',
    'secure_pw_history'                         => 'Neprejde týždeň, aby sme nevideli správy o ďalšej stránke, ktorá prišla o databázu hesiel svojich použivateľov. Hackeri a zlodeji tieto heslá používajú pre pokusy o ukradnutie vašich súkromných informácií. Informácie sú cenné.',
    'secure_pw_ff'                              => 'Používate rovnaké heslo na viacerých webových službách? Ak jedna z nich príde o vaše heslo, hackeri získajú prístup k všetkým z nich. Firefly III sa spolieha na to, že si zvolíte silné a inde nepoužívané heslo pre ochranu vašich finančných záznamov.',
    'secure_pw_check_box'                       => 'Firefly III môže pre vás skontrolovať heslo, ktoré chcete použiť, či nebolo v minulosti odcudzené. V takom prípade vám ho NEodporučí použiť.',
    'secure_pw_working_title'                   => 'Ako to funguje?',
    'secure_pw_working'                         => 'Zaškrtnutím tohto políčka Firefly III odošle prvých päť znakov hash vášho hesla SHA1 na <a href = "https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/ ">web Troy Hunt</a> a zistí, či je vaše heslo na zozname. To vám zabráni v používaní nebezpečných hesiel, ako sa odporúča v najnovšej <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">špeciálnej publikácii NIST</a> týkajúcej sa bezpečnosti.',
    'secure_pw_should'                          => 'Mám to zaškrtnúť?',
    'secure_pw_long_password'                   => 'Áno, vždy overiť bezpečnosť hesla.',
    'command_line_token'                        => 'Token pre príkazový riadok',
    'explain_command_line_token'                => 'Tento token potrebujete na vykonávanie možností príkazového riadku, ako je napríklad export údajov. Bez toho tento citlivý príkaz nebude fungovať. Nezdieľajte svoj token príkazového riadku. Nikto od vás nebude žiadať tento token, ani ja. Ak sa bojíte, že ste to stratili, alebo keď ste paranoidní, regenerujte tento token pomocou tlačidla.',
    'regenerate_command_line_token'             => 'Pregenerovať token príkazového riadka',
    'token_regenerated'                         => 'Nový token pre príkazový riadok bol vytvorený',
    'change_your_email'                         => 'Zmena e-mailovej adresy',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Kým neoveríte svoju e-mailovú adresu, nemôžete sa prihlásiť.',
    'login_with_new_email'                      => 'Teraz sa môžete prihlásiť so svojou novou e-mailovou adresou.',
    'login_with_old_email'                      => 'Teraz sa môžete prihlásiť so svojou starou e-mailovou adresou.',
    'login_provider_local_only'                 => 'Táto akcia nie je k dispozícii pri autentifikácii prostredníctvom „:login_provider“.',
    'external_user_mgt_disabled'                => 'Táto akcia nie je k dispozícii, keď Firefly III nie je zodpovedný za správu používateľov alebo manipuláciu s autentifikáciou.',
    'external_auth_disabled'                    => 'Táto akcia nie je dostupná, ak Firefly III nie je zodpovedný za autentifikáciu.',
    'delete_local_info_only'                    => "Pretože Firefly III nie je zodpovedný za správu používateľov alebo manipuláciu s autentifikáciou, táto funkcia vymaže iba miestne informácie Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth klienti',
    'profile_oauth_no_clients'                  => 'Zatiaľ ste nevytvorili žiadneho OAuth klienta.',
    'profile_oauth_clients_external_auth'       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'              => 'Klienti',
    'profile_oauth_client_id'                   => 'ID klienta',
    'profile_oauth_client_name'                 => 'Meno/Názov',
    'profile_oauth_client_secret'               => 'Tajný kľúč',
    'profile_oauth_create_new_client'           => 'Vytvoriť nového klienta',
    'profile_oauth_create_client'               => 'Vytvoriť klienta',
    'profile_oauth_edit_client'                 => 'Upraviť klienta',
    'profile_oauth_name_help'                   => 'Niečo, čo vaši použivatelia poznajú a budú tomu dôverovať.',
    'profile_oauth_redirect_url'                => 'URL presmerovania',
    'profile_oauth_redirect_url_help'           => 'Spätná URL pre overenie autorizácie vašej aplikácie.',
    'profile_authorized_apps'                   => 'Povolené aplikácie',
    'profile_authorized_clients'                => 'Autorizovaní klienti',
    'profile_scopes'                            => 'Rozsahy',
    'profile_revoke'                            => 'Odvolať',
    'profile_oauth_client_secret_title'         => 'Tajný kľúč klienta',
    'profile_oauth_client_secret_expl'          => 'Toto je váš tajný kľúč klienta. Toto je jediný raz, kedy sa zobrazí - nestraťte ho! Odteraz môžete tento tajný kľúč používať pre prístup k API.',
    'profile_personal_access_tokens'            => 'Osobné prístupové tokeny',
    'profile_personal_access_token'             => 'Osobný prístupový token',
    'profile_oauth_confidential'                => 'Dôverné',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Toto je váš nový osobný prístupový token. Toto je jediný raz, kedy sa zobrazí - nestraťte ho! Odteraz ho môžete používať pre prístup k API.',
    'profile_no_personal_access_token'          => 'Ešte ste nevytvorili žiadne osobné prístupové tokeny.',
    'profile_create_new_token'                  => 'Vytvoriť nový token',
    'profile_create_token'                      => 'Vytvoriť token',
    'profile_create'                            => 'Vytvoriť',
    'profile_save_changes'                      => 'Uložiť zmeny',
    'profile_whoops'                            => 'Ajaj!',
    'profile_something_wrong'                   => 'Niečo sa pokazilo!',
    'profile_try_again'                         => 'Niečo sa pokazilo. Prosím, skúste znova.',
    'amounts'                                   => 'Suma',
    'multi_account_warning_unknown'             => 'V závislosti od typu vytvorenej transakcie, môže byť zdrojový a/alebo cieľový účet následných rozúčtovaní prepísaný údajmi v prvom rozdelení transakcie.',
    'multi_account_warning_withdrawal'          => 'Majte na pamäti, že zdrojový bankový účet následných rozúčtovaní bude prepísaný tým, čo je definované v prvom rozdelení výberu.',
    'multi_account_warning_deposit'             => 'Majte na pamäti, že zdrojový bankový účet následných rozúčtovaní bude prepísaný tým, čo je definované v prvom rozúčtovaní vkladu.',
    'multi_account_warning_transfer'            => 'Majte na pamäti, že zdrojový a cieľový bankový účet následných rozúčtovaní bude prepísaný tým, čo je definované v prvom rozúčtovaní prevodu.',


    // export data:
    'export_data_title'                         => 'Export údajov z Firefly III',
    'export_data_menu'                          => 'Export údajov',
    'export_data_bc'                            => 'Export údajov z Firefly III',
    'export_data_main_title'                    => 'Export údajov z Firefly III',
    'export_data_expl'                          => 'Tento odkaz vám umožní exportovať všetky transakcie a metadata z Firefly III. Viac informácií o procese nájdete v pomocníkovi (ikona (?) vpravo hore).',
    'export_data_all_transactions'              => 'Export všetkých transakcií',
    'export_data_advanced_expl'                 => 'Ak potrebujete pokročilejší alebo konkrétnejší typ exportu, prečítajte si pomocníka, ako používať príkaz konzoly <code> php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Jedna príloha|:count príloh',
    'attachments'                               => 'Prílohy',
    'edit_attachment'                           => 'Upraviť prílohu ":name"',
    'update_attachment'                         => 'Upraviť prílohu',
    'delete_attachment'                         => 'Odstrániť prílohu „:name“',
    'attachment_deleted'                        => 'Príloha „:name“ bola odstránená',
    'liabilities_deleted'                       => 'Záväzok „:name“ bol odstránený',
    'attachment_updated'                        => 'Príloha „:name“ upravená',
    'upload_max_file_size'                      => 'Maximálna veľkosť súboru: :size',
    'list_all_attachments'                      => 'Zoznam všetkých príloh',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Výdavky',
    'title_withdrawal'                          => 'Výdavky',
    'title_revenue'                             => 'Zisky / príjmy',
    'title_deposit'                             => 'Zisky / príjmy',
    'title_transfer'                            => 'Prevody',
    'title_transfers'                           => 'Prevody',
    'submission_options'                        => 'Submission options',
    'apply_rules_checkbox'                      => 'Apply rules',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Tato transakcia už je výber',
    'convert_is_already_type_Deposit'           => 'Tato transakcia už je vklad',
    'convert_is_already_type_Transfer'          => 'Tato transakcia už je prevod',
    'convert_to_Withdrawal'                     => 'Zmeniť „:description“ na výber',
    'convert_to_Deposit'                        => 'Zmeniť „:description“ na vklad',
    'convert_to_Transfer'                       => 'Zmeniť „:description“ na prevod',
    'convert_options_WithdrawalDeposit'         => 'Zmeniť výber na vklad',
    'convert_options_WithdrawalTransfer'        => 'Zmeniť výber na prevod',
    'convert_options_DepositTransfer'           => 'Zmeniť vklad na prevod',
    'convert_options_DepositWithdrawal'         => 'Zmeniť vklad na výber',
    'convert_options_TransferWithdrawal'        => 'Zmeniť prevod na výber',
    'convert_options_TransferDeposit'           => 'Zmeniť prevod na vklad',
    'convert_Withdrawal_to_deposit'             => 'Zmeniť tento výber na vklad',
    'convert_Withdrawal_to_transfer'            => 'Zmeniť tento výber na vklad',
    'convert_Deposit_to_withdrawal'             => 'Zmeniť tento vklad na výber',
    'convert_Deposit_to_transfer'               => 'Zmeniť tento vklad na prevod',
    'convert_Transfer_to_deposit'               => 'Zmeniť tento prevod na vklad',
    'convert_Transfer_to_withdrawal'            => 'Zmeniť tento prevod na výber',
    'convert_please_set_revenue_source'         => 'Vyberte účet aktiv, z kterého peniaze prídu.',
    'convert_please_set_asset_destination'      => 'Vyberte účet aktív, na ktorý tieto peniaze odídu.',
    'convert_please_set_expense_destination'    => 'Vyberte výdavkový účet, na ktorý peniaze odídu.',
    'convert_please_set_asset_source'           => 'Vyberte účet aktív, z ktorého peniaze odídu.',
    'convert_expl_w_d'                          => 'Pri zmene výberu na vklad sa peniaze namiesto toho, aby sa zo zobrazeného cieľového účtu vybrali, vložia sa naň.|Pri zmene výberu na vklad sa peniaze namiesto výberu zo zobrazených cieľových účtov na ne vložia.',
    'convert_expl_w_t'                          => 'Pri zmene výberu na prevod sa peniaze prevedú preč zo zdrojového účtu na iný účet aktív alebo pasív namiesto toho, aby sa minuli na pôvodný účet výdavkov.|Pri zmene výberu na prevod sa peniaze prevedú ďalej z zdrojové účty na iné účty aktív alebo pasív namiesto toho, aby sa minuli na pôvodné účty výdavkov.',
    'convert_expl_d_w'                          => 'Pri zmene vkladu na výber sa peniaze namiesto vybratého vkladu vyberú zo zobrazeného zdrojového účtu.|Pri zmene vkladu na výber sa peniaze namiesto vloženia vyberú zo zobrazených zdrojových účtov. do nich.',
    'convert_expl_d_t'                          => 'Keď zmeníte vklad na prevod, peniaze sa vložia na uvedený cieľový účet z ktoréhokoľvek z vašich aktív alebo pasív.|Keď zmeníte vklad na prevod, peniaze sa vložia na uvedené cieľové účty z ľubovoľného účtu vašich aktív alebo pasív.',
    'convert_expl_t_w'                          => 'Keď zmeníte prevod na výber, peniaze sa minú na cieľový účet, ktorý ste tu nastavili, a nie na prevod preč.|Keď zmeníte prevod na výber, peniaze sa minú na cieľové účty, ktoré ste tu nastavili, namiesto toho, aby boli presunuté preč.',
    'convert_expl_t_d'                          => 'Keď zmeníte prevod na vklad, peniaze sa namiesto toho, aby sa na ne presunuli, uložia na cieľový účet, ktorý vidíte tu.|Keď zmeníte prevod na vklad, peniaze sa vložia na cieľové účty, ktoré vidíte tu, namiesto aby sa do nich preniesli.',
    'convert_select_sources'                    => 'Ak chcete dokončiť konverziu, nižšie nastavte nový zdrojový účet.|Na dokončenie konverzie nastavte nižšie nové zdrojové účty.',
    'convert_select_destinations'               => 'Ak chcete dokončiť konverziu, vyberte nový cieľový účet uvedený nižšie.|Na dokončenie konverzie vyberte nižšie nové cieľové účty.',
    'converted_to_Withdrawal'                   => 'Transakcia bola prevedená na výber',
    'converted_to_Deposit'                      => 'Transakcia bola prevedená na vklad',
    'converted_to_Transfer'                     => 'Transakcia bola prevedená na prevod',
    'invalid_convert_selection'                 => 'Účet, ktorý ste vybrali, sa už v tejto transakcii používa alebo neexistuje.',
    'source_or_dest_invalid'                    => 'Nenašli sa správne podrobnosti transakcie. Prevod nie je možný.',
    'convert_to_withdrawal'                     => 'Zmeniť na výber',
    'convert_to_deposit'                        => 'Zmeniť na vklad',
    'convert_to_transfer'                       => 'Zmeniť na prevod',

    // create new stuff:
    'create_new_withdrawal'                     => 'Vytvoriť nový výber',
    'create_new_deposit'                        => 'Vytvoriť nový vklad',
    'create_new_transfer'                       => 'Vytvoriť nový prevod',
    'create_new_asset'                          => 'Vytvoriť nový účet aktív',
    'create_new_liabilities'                    => 'Vytvoriť nový záväzok',
    'create_new_expense'                        => 'Vytvoriť výdavkoý účet',
    'create_new_revenue'                        => 'Vytvoriť nový príjmový účet',
    'create_new_piggy_bank'                     => 'Vytvoriť novú pokladničku',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Create new subscription',
    'create_new_rule'                           => 'Create new rule',

    // currencies:
    'create_currency'                           => 'Vytvoriť novú menu',
    'store_currency'                            => 'Uložiť novú menu',
    'update_currency'                           => 'Upraviť menu',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => ':name nie je možné odstrániť, pretože sa stále v aplikácii používa.',
    'cannot_delete_fallback_currency'           => ':name je predvolená systémová základná mena a nie je možné ju odstrániť.',
    'cannot_disable_currency_journals'          => ':name nie je možné vypnúť, pretože ju používajú niektoré transakcie.',
    'cannot_disable_currency_last_left'         => ':name nie je možné vypnúť, pretože je to posledná aktívna mena.',
    'cannot_disable_currency_account_meta'      => ':name nie je možné vypnúť, pretože je použitý v majetkových účtoch.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => ':name nie je možné vypnúť, pretože je použitý v opakovaných transakciách.',
    'cannot_disable_currency_available_budgets' => ':name nie je možné vypnúť, pretože je použitý v rozpočtoch.',
    'cannot_disable_currency_budget_limits'     => ':name nie je možné vypnúť, pretože je použitý v obmedzeniach rozpočtov.',
    'cannot_disable_currency_current_default'   => ':name nie je možné vypnúť, pretože je to aktuálne predvolená mena.',
    'cannot_disable_currency_system_fallback'   => ':name nie je možné vypnúť, pretože je to systémová predvolená mena.',
    'disable_EUR_side_effects'                  => 'Euro je núdzová záložná mena systému. Jeho deaktivácia môže mať nežiaduce vedľajšie účinky a môže spôsobiť neplatnosť záruky.',
    'deleted_currency'                          => 'Mena :name bola odstránená',
    'created_currency'                          => 'Mena :name vytvorená',
    'could_not_store_currency'                  => 'Novú menu sa nepodarilo uložiť.',
    'updated_currency'                          => 'Mena :name upravená',
    'ask_site_owner'                            => 'O pridanie, odstránenie alebo zmeny v menách požiadajte prosím :owner.',
    'currencies_intro'                          => 'Firefly III podporuje rôzne meny, ktoré tu môžete spravovať.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Nastaviť ako predvolené',
    'default_currency'                          => 'predvolené',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Vypnuté',
    'enable_currency'                           => 'Zapnúť',
    'disable_currency'                          => 'Vypnúť',
    'currencies_default_disabled'               => 'Väčšina týchto mien je v základnom stave vypnutá. Ak ich chcete používať, musíte ich najprv zapnúť.',
    'currency_is_now_enabled'                   => 'Mena „:name“ bola zapnutá',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Mena „:name“ bola vypnutá',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Povinné údaje',
    'optionalFields'                            => 'Voliteľné údaje',
    'options'                                   => 'Možnosti',

    // budgets:
    'daily_budgets'                             => 'Denné rozpočty',
    'weekly_budgets'                            => 'Týždenné rozpočty',
    'monthly_budgets'                           => 'Mesačné rozpočty',
    'quarterly_budgets'                         => 'Štvrťročné rozpočty',
    'half_year_budgets'                         => 'Polročné rozpočty',
    'yearly_budgets'                            => 'Ročné rozpočty',
    'other_budgets'                             => 'Špecifické časované rozpočty',
    'budget_limit_not_in_range'                 => 'Táto suma platí od :start do :end:',
    'total_available_budget'                    => 'Suma dostupného rozpočtu (medzi :start a :end)',
    'total_available_budget_in_currency'        => 'Celkový rozpočet k dispozici v :currency',
    'see_below'                                 => 'viď nižšie',
    'create_new_budget'                         => 'Vytvoriť nový rozpočet',
    'store_new_budget'                          => 'Uložiť nový rozpočet',
    'stored_new_budget'                         => 'Uložený nový rozpočet „:name“',
    'available_between'                         => 'Dostupné medzi :start a :end',
    'transactionsWithoutBudget'                 => 'Výdavky bez rozpočtu',
    'transactions_no_budget'                    => 'Výdavky bez rozpočtu medzi :start a :end',
    'spent_between'                             => 'Už utratené medzi :start a :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Nastaviť sumu k dispozícii',
    'update_available_amount'                   => 'Aktualizovať sumu k dispozícii',
    'ab_basic_modal_explain'                    => 'Pomocou tohto formulára zadajte, koľko očakávate, že budete môcť v uvedenom období zostaviť rozpočet (celkovo v :currency).',
    'createBudget'                              => 'Nový rozpočet',
    'invalid_currency'                          => 'Toto nie je platná mena',
    'invalid_amount'                            => 'Prosím, zadajte sumu',
    'set_ab'                                    => 'Dostupná suma rozpočtu bola nastavená',
    'updated_ab'                                => 'Dostupná suma rozpočtu bola aktualizovaná',
    'deleted_ab'                                => 'Dostupná suma rozpočtu bola odstránená',
    'deleted_bl'                                => 'Rozpočtovaná suma bola odstránená',
    'alt_currency_ab_create'                    => 'Nastaviť dostupný rozpočet v inej mene',
    'bl_create_btn'                             => 'Nastaviť rozpočet v inej mene',
    'inactiveBudgets'                           => 'Neaktívne rozpočty',
    'without_budget_between'                    => 'Transakcia bez rozpočtu medzi :start a :end',
    'delete_budget'                             => 'Odstrániť rozpočet „:name“',
    'deleted_budget'                            => 'Rozpočet „:name“ bol odstránený',
    'edit_budget'                               => 'Upraviť rozpočet „:name“',
    'updated_budget'                            => 'Upravený rozpočet „:name“',
    'update_amount'                             => 'Upraviť sumu',
    'update_budget'                             => 'Upraviť rozpočet',
    'update_budget_amount_range'                => 'Aktualizovať (očakávané) dostupné množstvo medzi :start a :end',
    'set_budget_limit_title'                    => 'Nastaviť rozpočtovanú sumu pre rozpočet :budget medzi :start a :end',
    'set_budget_limit'                          => 'Nastavte sumu rozpočtu',
    'budget_period_navigator'                   => 'Navigátor období',
    'info_on_available_amount'                  => 'Čo mám(e) k dispozícii?',
    'available_amount_indication'               => 'Pomocou týchto súm získate informáciu o tom, aký môže byť váš celkový rozpočet.',
    'suggested'                                 => 'Navrhované',
    'average_between'                           => 'Priemer medzi :start a :end',
    'transferred_in'                            => 'Prevedené (k nám)',
    'transferred_away'                          => 'Prevedené (preč)',
    'auto_budget_none'                          => 'Žiadny automatický rozpočet',
    'auto_budget_reset'                         => 'Nastaviť pevnú sumu pre každé obdobie',
    'auto_budget_rollover'                      => 'Pridať sumu každé obdobie',
    'auto_budget_adjusted'                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                  => 'Denne',
    'auto_budget_period_weekly'                 => 'Týždenne',
    'auto_budget_period_monthly'                => 'Mesačne',
    'auto_budget_period_quarterly'              => 'Štvrťročne',
    'auto_budget_period_half_year'              => 'Polročne',
    'auto_budget_period_yearly'                 => 'Ročne',
    'auto_budget_help'                          => 'Viac o tejto funkcii sa dozviete v pomocníkovi. Kliknite na ikonu (?) vpravo hore.',
    'auto_budget_reset_icon'                    => 'Tento rozpočet bude stanovovaný pravidelne',
    'auto_budget_rollover_icon'                 => 'Táto suma rozpočtu sa bude pravidelne navyšovať',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Odstrániť rozpočtovú sumu v :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Subscription',
    'not_expected_period'                       => 'Neočakávané v tomto období',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => '(Ešte) nie',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Opakuje sa',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Prepojené transakcie',
    'auto_match_on'                             => 'Automaticky spárované Firefly III',
    'auto_match_off'                            => 'Firefly III nedokáže automaticky spárovať',
    'next_expected_match'                       => 'Ďalšia očakávaná zhoda',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Viac',
    'rescan_old'                                => 'Spustiť pravidlá znovu, na všetky transakcie',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Očakávané medzi :start a :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'preskočí cez',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'neaktívne pravidlo',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Očakávané :date',
    'bill_expected_date_js'                     => 'Expected {date}',
    'expected_amount'                           => '(Expected) amount',
    'bill_paid_on'                              => 'Uhradené {date}',
    'bill_repeats_weekly'                       => 'Repeats weekly',
    'bill_repeats_monthly'                      => 'Repeats monthly',
    'bill_repeats_quarterly'                    => 'Repeats quarterly',
    'bill_repeats_half-year'                    => 'Repeats every half year',
    'bill_repeats_yearly'                       => 'Repeats yearly',
    'bill_repeats_weekly_other'                 => 'Repeats every other week',
    'bill_repeats_monthly_other'                => 'Repeats every other month',
    'bill_repeats_quarterly_other'              => 'Repeats every other quarter',
    'bill_repeats_half-year_other'              => 'Repeats yearly',
    'bill_repeats_yearly_other'                 => 'Repeats every other year',
    'bill_repeats_weekly_skip'                  => 'Repeats every {skip} weeks',
    'bill_repeats_monthly_skip'                 => 'Repeats every {skip} months',
    'bill_repeats_quarterly_skip'               => 'Repeats every {skip} quarters',
    'bill_repeats_half-year_skip'               => 'Repeats every {skip} half years',
    'bill_repeats_yearly_skip'                  => 'Repeats every {skip} years',
    'subscriptions'                             => 'Subscriptions',
    'go_to_subscriptions'                       => 'Go to your subscriptions',
    'forever'                                   => 'Forever',
    'extension_date_is'                         => 'Extension date is {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'I am owed amount',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'Máte :count neaktívny (archivovaný) bankový účet, ktorý môžete zobraziť na tejto samostatnej stránke.|Máte :count neaktívnych (archivovaných) bankových účtov, ktoré môžete zobraziť na tejto samostatnej stránke.',
    'all_accounts_inactive'                     => 'Toto sú vaše neaktívne bankové účty.',
    'active_account_link'                       => 'Tento prepojenie smeruje späť na vaše aktívne účty.',
    'account_missing_transaction'               => 'Bankový účet #:id (":name") nie je možné zobraziť priamo, ale Firefly III chýbajú informácie o presmerovaní.',
    'cc_monthly_payment_date_help'              => 'Vyberte akýkoľvek rok alebo mesiac, budú ignorované. Relevantný je len deň v mesiaci.',
    'details_for_asset'                         => 'Podrobnosti o účte aktív „:name“',
    'details_for_expense'                       => 'Podrobnosti o výdavkovom účte „:name“',
    'details_for_revenue'                       => 'Podrobnosti o výnosovom účte „:name“',
    'details_for_cash'                          => 'Podrobnosti o hotovostnom účte „:name“',
    'store_new_asset_account'                   => 'Uložiť nový účet aktív',
    'store_new_expense_account'                 => 'Uložiť nový výdavkový účet',
    'store_new_revenue_account'                 => 'Uložiť nový príjmový účet',
    'edit_asset_account'                        => 'Upraviť účet aktív „:name“',
    'edit_expense_account'                      => 'Upraviť výdavkový účet „:name“',
    'edit_revenue_account'                      => 'Upraviť výnosový účet „:name“',
    'delete_asset_account'                      => 'Odstrániť účet aktív „:name“',
    'delete_expense_account'                    => 'Odstrániť výdavkový účet ":name"',
    'delete_revenue_account'                    => 'Odstrániť výnosový účet ":name"',
    'delete_liabilities_account'                => 'Odstrániť záväzok „:name“',
    'asset_deleted'                             => 'Majetkový účet ":name" bol odstránený',
    'account_deleted'                           => 'Účet ":name" bol odstránený',
    'expense_deleted'                           => 'Výdavkový účet ":name" bol odstránený',
    'revenue_deleted'                           => 'Výnosový účet ":name" bol odstránený',
    'update_asset_account'                      => 'Upraviť výdajový účet',
    'update_undefined_account'                  => 'Update account',
    'update_liabilities_account'                => 'Upraviť záväzok',
    'update_expense_account'                    => 'Upraviť výdavkový účet',
    'update_revenue_account'                    => 'Upraviť príjmový účet',
    'make_new_asset_account'                    => 'Vytvoriť nový účet aktív',
    'make_new_expense_account'                  => 'Vytvoriť výdavkový účet',
    'make_new_revenue_account'                  => 'Vytvoriť nový príjmový účet',
    'make_new_liabilities_account'              => 'Vytvoriť nový záväzok',
    'asset_accounts'                            => 'Účty aktív',
    'undefined_accounts'                        => 'Accounts',
    'asset_accounts_inactive'                   => 'Majetkový účet (neaktívny)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Výdavkové účty',
    'expense_accounts_inactive'                 => 'Výdajový účet (neaktívny)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Výnosové účty',
    'revenue_accounts_inactive'                 => 'Výnosové účty (neaktívne)',
    'cash_accounts'                             => 'Hotovostné účty',
    'Cash account'                              => 'Hotovostný účet',
    'liabilities_accounts'                      => 'Záväzky',
    'liabilities_accounts_inactive'             => 'Záväzky (neaktívne)',
    'reconcile_account'                         => 'Vyúčtovať účet ":account"',
    'overview_of_reconcile_modal'               => 'Prehľad zúčtovania',
    'delete_reconciliation'                     => 'Odstrániť zúčtovanie',
    'update_reconciliation'                     => 'Opraviť zúčtovanie',
    'amount_cannot_be_zero'                     => 'Suma nemôže byť nula',
    'end_of_reconcile_period'                   => 'Koniec zúčtovacieho obdobia: :period',
    'start_of_reconcile_period'                 => 'Začiatok zúčtovacieho obdobia: :period',
    'start_balance'                             => 'Počiatočný zostatok',
    'end_balance'                               => 'Konečný zostatok',
    'update_balance_dates_instruction'          => 'Priraďte vyššie uvedené sumy a dátumy k svojmu bankovému výpisu a stlačte tlačidlo „Začať vyúčtovanie“',
    'select_transactions_instruction'           => 'Vyberte transakcie, ktoré sa zobrazia na vašom bankovom výpise.',
    'select_range_and_balance'                  => 'Najskôr skontrolujte rozsah dátumov a zostatky. Potom stlačte tlačidlo „Spustiť vyúčtovanie“',
    'date_change_instruction'                   => 'Ak teraz zmeníte rozsah dátumov, akýkoľvek pokrok sa stratí.',
    'update_selection'                          => 'Upraviť výber',
    'store_reconcile'                           => 'Uložiť zúčtovanie',
    'reconciliation_transaction'                => 'Zúčtovacia transakcia',
    'Reconciliation'                            => 'Zúčtovanie',
    'reconciliation'                            => 'Zúčtovanie',
    'reconcile_options'                         => 'Možnosti zúčtovania',
    'reconcile_range'                           => 'Rozsah zúčtovania',
    'start_reconcile'                           => 'Spustiť zúčtovanie',
    'cash_account_type'                         => 'Hotovosť',
    'cash'                                      => 'hotovosť',
    'cant_find_redirect_account'                => 'Firefly III sa vás pokúsil presmerovať, ale nepodarilo sa. Prepáčte. Späť na úvod.',
    'account_type'                              => 'Typ účtu',
    'save_transactions_by_moving'               => 'Uložte túto transakciu presunutím do iného účtu:|Uložte tieto transakcie presunutím do iného účtu:',
    'save_transactions_by_moving_js'            => 'Žiadne transakcie|Zachovať túto transakciu presunom pod iný účet.|Zachovať tieto transakcie presunom pod iný účet.',
    'stored_new_account'                        => 'Nový účet „:name“ bol uložený!',
    'stored_new_account_js'                     => 'Nový účet "<a href="accounts/show/{ID}">{name}</a>" vytvorený!',
    'updated_account'                           => 'Účet „:name“ upravený',
    'updated_account_js'                        => 'Updated account "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Možnosti kreditnej karty',
    'no_transactions_account'                   => 'Pre majetkový účet ":name" neexistujú (v tomto období) žiadne transakcie.',
    'no_transactions_period'                    => 'Neexistujú žiadne transakcie (v tomto období).',
    'no_data_for_chart'                         => 'Pre vytvorenie tohto grafu nie je (zatiaľ) dostatok informácií.',
    'select_at_least_one_account'               => 'Vyberte aspoň jeden účet aktív',
    'select_at_least_one_category'              => 'Vyberte aspoň jednu kategóriu',
    'select_at_least_one_budget'                => 'Vyberte aspoň jeden rozpočet',
    'select_at_least_one_tag'                   => 'Vyberte aspoň jeden štítok',
    'select_at_least_one_expense'               => 'Vyberte aspoň jednu kombináciu účtov výdavkov/výnosov. Ak žiadne nemáte (zoznam je prázdny), tento výkaz nie je k dispozícii.',
    'account_default_currency'                  => 'Toto bude predvolená mena previazaná s týmto bankovým účtom.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Vaša účtovná kniha Firefly III obsahuje viac peňazí, než udáva vaša banka. Máte viac možností - vyberte, ako pokračovať. Potom kliknite na "Potvrdiť zúčtovanie".',
    'reconcile_has_less'                        => 'Vaša účtovná kniha Firefly III obsahuje menej peňazí, než udáva vaša banka. Máte viac možností - vyberte, ako pokračovať. Potom kliknite na "Potvrdiť zúčtovanie".',
    'reconcile_is_equal'                        => 'Vaša účtovná kniha Firefly III sa zhoduje s výpismi z vašej banky. Kliknite na "Potvrdiť zúčtovanie" pre potvrdenie.',
    'create_pos_reconcile_transaction'          => 'Vymažte vybrané transakcie a vytvorte opravu pridania :amount k tomuto majetkovému účtu.',
    'create_neg_reconcile_transaction'          => 'Vymažte vybrané transakcie a vytvorte opravu odstránenia :amount z tohto majetkového účtu.',
    'reconcile_do_nothing'                      => 'Vymažte vybraté transakcie, ale neopravujte ich.',
    'reconcile_go_back'                         => 'Opravu môžete kedykoľvek upraviť alebo odstrániť.',
    'must_be_asset_account'                     => 'Môžete zúčtovať len majetkové účty',
    'reconciliation_stored'                     => 'Zúčtovanie uložené',
    'reconciliation_error'                      => 'Transakcie boli označené ako zúčtované, ale kvôli nasledujúcej chybe neboli uložené: :error.',
    'reconciliation_transaction_title'          => 'Zúčtovanie (:from pre :to)',
    'sum_of_reconciliation'                     => 'Sumár zúčtovania',
    'reconcile_this_account'                    => 'Vyúčtovat tento účet',
    'reconcile'                                 => 'Vyúčtovať',
    'show'                                      => 'Zobraziť',
    'confirm_reconciliation'                    => 'Potvrdiť zúčtovanie',
    'submitted_start_balance'                   => 'Vložený počiatočný zostatok',
    'selected_transactions'                     => 'Vybrané transakcie (:count)',
    'already_cleared_transactions'              => 'Už zúčtované transakcie (:count)',
    'submitted_end_balance'                     => 'Vložený konečný zostatok',
    'initial_balance_description'               => 'Počiatočný zostatok pre „:account“',
    'liability_credit_description'              => 'Liability credit for ":account"',
    'interest_calc_'                            => 'neznáme',
    'interest_calc_daily'                       => 'Za deň',
    'interest_calc_monthly'                     => 'Za mesiac',
    'interest_calc_yearly'                      => 'Za rok',
    'interest_calc_weekly'                      => 'Za týždeň',
    'interest_calc_half-year'                   => 'Za polrok',
    'interest_calc_quarterly'                   => 'Za štvrťrok',
    'initial_balance_account'                   => 'Počiatočný zostatok pre :account',
    'list_options'                              => 'Možnosti zoznamu',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Nová kategória',
    'create_new_category'                       => 'Vytvoriť novú kategóriu',
    'without_category'                          => 'Bez kategórie',
    'update_category'                           => 'Aktualizovať kategóriu',
    'updated_category'                          => 'Kategória „:name“ upravená',
    'categories'                                => 'Kategórie',
    'edit_category'                             => 'Upraviť kategóriu „:name“',
    'no_category'                               => '(žiadna kategória)',
    'unknown_category_plain'                    => 'No category',
    'category'                                  => 'Kategória',
    'delete_category'                           => 'Odstrániť kategóriu „:name“',
    'deleted_category'                          => 'Kategorie „:name“ smazána',
    'store_category'                            => 'Uložiť novú kategóriu',
    'stored_category'                           => 'Nová kategória „:name“ bola uložená',
    'without_category_between'                  => 'Bez kategórie medzi :start a :end',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Upraviť výber',
    'update_deposit'                            => 'Upraviť vklad',
    'update_transaction'                        => 'Upraviť transakciu',
    'update_transfer'                           => 'Upraviť prevod',
    'updated_withdrawal'                        => 'Výber „:description“ bol upravený',
    'updated_deposit'                           => 'Vklad „:description“ bol upravený',
    'updated_transfer'                          => 'Prevod „:description“ bol upravený',
    'no_changes_withdrawal'                     => 'Výber ":description" nebol pozmenený.',
    'no_changes_deposit'                        => 'Vklad ":description" nebol pozmenený.',
    'no_changes_transfer'                       => 'Prevod ":description" nebol pozmenený.',
    'delete_withdrawal'                         => 'Výber bol „:description“ upravený',
    'delete_deposit'                            => 'Odstrániť vklad „:description“',
    'delete_transfer'                           => 'Odstrániť prevod „:description“',
    'deleted_withdrawal'                        => 'Výber „:description“ bol odstránený',
    'deleted_deposit'                           => 'Vklad „:description“ bol odstránený',
    'deleted_transfer'                          => 'Prevod „:description“ bol odstránený',
    'deleted_reconciliation'                    => 'Zúčtovacia transakcia ":description" bola odstránená',
    'stored_journal'                            => 'Nová transakcia „:description“ bola vytvorená',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Vaša nová transakcia bola vytvorená',
    'updated_journal_no_descr'                  => 'Vaša transakcia bola upravená',
    'select_transactions'                       => 'Vybrať transakcie',
    'rule_group_select_transactions'            => 'Použiť ":title" na transakcie',
    'rule_select_transactions'                  => 'Použiť ":title" na transakcie',
    'stop_selection'                            => 'Ukončiť označovanie transakcií',
    'reconcile_selected'                        => 'Zúčtovať',
    'mass_delete_journals'                      => 'Odstrániť transakcie',
    'mass_edit_journals'                        => 'Upraviť transakcie',
    'mass_bulk_journals'                        => 'Hromadná úprava transakcií',
    'mass_bulk_journals_explain'                => 'Tento formulár umožňuje meniť vlastnosti transakcií uvedených nižšie v jednej rozsiahlej aktualizácii. Všetky transakcie v tabuľke sa aktualizujú, keď zmeníte parametre, ktoré tu vidíte.',
    'part_of_split'                             => 'Táto transakcia je súčasťou rozúčtovanej transakcie. Ak ste nevybrali všetky rozúčtovania, môžete skončiť iba polovičnou zmenou transakcie.',
    'bulk_set_new_values'                       => 'Nové hodnoty nastavíte pomocí vstupních kolonek níže. Pokud je nevyplníte, budou u všeho vyprázdněny. Také si všimněte, že pouze výběry dostanou rozpočet.',
    'no_bulk_category'                          => 'Neupraviť kategóriu',
    'no_bulk_budget'                            => 'Neupraviť rozpočet',
    'no_bulk_tags'                              => 'Neupraviť štítky',
    'replace_with_these_tags'                   => 'Prepísať týmito štítkami',
    'append_these_tags'                         => 'Pridať tieto štítky',
    'mass_edit'                                 => 'Upraviť označené individuálne',
    'bulk_edit'                                 => 'Hromadná úprava označeného',
    'mass_delete'                               => 'Odstrániť označené',
    'cannot_edit_other_fields'                  => 'Nemôžete hromadne upravovať iné polia ako tie, ktoré sú tu, pretože nie je priestor na ich zobrazenie. Ak potrebujete upraviť tieto polia, kliknite na odkaz a upravte ich jednotlivo.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(žiadny rozpočet)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Účty pre jednotlivé rozpočty',
    'account_per_category'                      => 'Účty pre jednotlivé kategórie',
    'create_new_object'                         => 'Vytvoriť',
    'empty'                                     => '(prázdne)',
    'all_other_budgets'                         => '(všetky ostatné rozpočty)',
    'all_other_accounts'                        => '(všetky ostatné účty)',
    'expense_per_source_account'                => 'Výdavky podľa zdrojového účtu',
    'expense_per_destination_account'           => 'Výdavky podľa cieľového účtu',
    'income_per_destination_account'            => 'Príjmy podľa cieľového účtu',
    'spent_in_specific_category'                => 'Utratené v kategórii „:category“',
    'earned_in_specific_category'               => 'Získané v kategórii „:category“',
    'spent_in_specific_tag'                     => 'Utratené pod štítkom „:tag“',
    'earned_in_specific_tag'                    => 'Získané pod štítkom „:tag“',
    'income_per_source_account'                 => 'Príjem podľa zdrojového účtu',
    'average_spending_per_destination'          => 'Priemerný výdavok podľa cieľového účtu',
    'average_spending_per_source'               => 'Priemerný výdavok podľa zdrojového účtu',
    'average_earning_per_source'                => 'Priemerný príjem v jednotlivých zdrojových účtoch',
    'average_earning_per_destination'           => 'Priemerný príjem v jednotlivých cieľových účtoch',
    'account_per_tag'                           => 'Účty pod jednotlivými štítkami',
    'tag_report_expenses_listed_once'           => 'Výdavky a príjmy nikdy nie sú vypísané dvakrát. Ak má transakcia viacero štítkov, zobrazí se len pod jedným z nich. Môže se zdať, že na zozname chýbajú údaje, ale sumy budú správne.',
    'double_report_expenses_charted_once'       => 'Výdavky a príjmy nikdy nie sú zobrazené dvakrát. Ak má transakcia viacero štítkov, zobrazí sa len pod jedným z nich. Môže sa zdať, že v tomto grafe niektoré údaje chýbajú, ale čiastky budú správne.',
    'tag_report_chart_single_tag'               => 'Tento graf sa vzťahuje na jeden štítok. Ak má transakcia viac štítkov, to, čo tu vidíte, sa môže prejaviť aj v grafoch iných štítkov.',
    'tag'                                       => 'Štítok',
    'no_budget_squared'                         => '(žiadny rozpočet)',
    'perm-delete-many'                          => 'Odstránenie viacerých položiek naraz môže byť veľmi rušivé. Buďte opatrní. Z tejto stránky môžete odstrániť časť rozdelenej transakcie, buďte preto opatrní.',
    'mass_deleted_transactions_success'         => ':count transakcia bola odstránená.|:count transakcií bolo odstránených.',
    'mass_edited_transactions_success'          => 'Upravila sa :count transakcia.|Upravilo sa :count transakcií.',
    'opt_group_'                                => '(žiadny typ účtu)',
    'opt_group_no_account_type'                 => '(žiadny typ účtu)',
    'opt_group_defaultAsset'                    => 'Predvolený majetkový účet',
    'opt_group_savingAsset'                     => 'Sporiace účty',
    'opt_group_sharedAsset'                     => 'Zdieľané účty aktív',
    'opt_group_ccAsset'                         => 'Kreditné karty',
    'opt_group_cashWalletAsset'                 => 'Peňaženky',
    'opt_group_expense_account'                 => 'Výdavkové účty',
    'opt_group_revenue_account'                 => 'Účty pre príjmy',
    'opt_group_l_Loan'                          => 'Záväzok: Pôžička',
    'opt_group_cash_account'                    => 'Hotovostný účet',
    'opt_group_l_Debt'                          => 'Záväzok: Dlh',
    'opt_group_l_Mortgage'                      => 'Záväzok: hypotéka',
    'opt_group_l_Credit card'                   => 'Záväzok: kreditná karta',
    'notes'                                     => 'Poznámky',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Transakciu sa nepodarilo uložiť. Pozrite sa do záznamov denníka udalostí.',
    'attachment_not_found'                      => 'Nepodarilo sa nájsť prílohu.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transakcia #{ID} ("{title}")</a> bola uložená.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transakcia #{ID}</a> bola uložená.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transakcia #{ID}</a> ("{title}") bola upravená.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transakcia #{ID}</a> ("{title}") sa nezmenila.',
    'first_split_decides'                       => 'Hodnotu tohto atribútu určuje prvé rozdelenie',
    'first_split_overrules_source'              => 'Prvé rozdelenie môže pozmeniť zdrojový účet',
    'first_split_overrules_destination'         => 'Prvé rozdelenie môže pozmeniť cieľový účet',
    'spent_x_of_y'                              => 'Utratené {amount} z {total}',

    // new user:
    'welcome'                                   => 'Vitajte ve Firefly III!',
    'submit'                                    => 'Odoslať',
    'submission'                                => 'Odoslanie',
    'submit_yes_really'                         => 'Odoslať (viem, čo robím)',
    'getting_started'                           => 'Začíname',
    'to_get_started'                            => 'Je dobré vidieť, že ste Firefly III úspešne nainštalovali. Ak chcete začať používať tento nástroj, zadajte názov svojej banky a zostatok na vašom hlavnom bežnom účte. Ak máte viac účtov, zatiaľ si nerobte starosti. Môžete ich pridať neskôr. Firefly III jednoducho potrebuje aspoň niečo, s čím môže začať pracovať.',
    'savings_balance_text'                      => 'Firefly III vám automaticky vytvorí sporiaci účet. V predvolenom nastavení nebudú na vašom sporiacom účte žiadne peniaze, ale ak to vo Firefly III určíte, zostatok sa uloží ako taký.',
    'finish_up_new_user'                        => 'To je všetko! Môžete pokračovať stlačením <strong>Odoslať</strong>. Budete presmerovaní na úvodnú stránku Firefly III.',
    'stored_new_accounts_new_user'              => 'Jupí! Vaše nové bankové účty boli uložené.',
    'set_preferred_language'                    => 'Ak chcete radšej používať Firefly III v inom jazyku, uveďte to tu.',
    'language'                                  => 'Jazyk',
    'new_savings_account'                       => ':bank_name šetriaci účet',
    'cash_wallet'                               => 'Peňaženka',
    'currency_not_present'                      => 'Ak mena, ktorú bežne používate, nie je uvedená, nič sa nedeje. Svoje vlastné meny môžete vytvoriť v časti Možnosti > Meny.',

    // home page:
    'transaction_table_description'             => 'Tabuľka obsahujúca vaše transakcie',
    'opposing_account'                          => 'Cieľový účet',
    'yourAccounts'                              => 'Vaše účty',
    'your_accounts'                             => 'Prehľad vášho účtu',
    'category_overview'                         => 'Prehľad kategórie',
    'expense_overview'                          => 'Prehľad výdavkových účtov',
    'revenue_overview'                          => 'Prehľad príjmových účtov',
    'budgetsAndSpending'                        => 'Rozpočty a útraty',
    'budgets_and_spending'                      => 'Rozpočty a útraty',
    'go_to_budget'                              => 'Zobraziť rozpočet „{budget}“',
    'go_to_deposits'                            => 'Zobraziť vklady',
    'go_to_expenses'                            => 'Zobraziť výdavky',
    'savings'                                   => 'Úspory',
    'newWithdrawal'                             => 'Nový výdavok',
    'newDeposit'                                => 'Nový vklad',
    'newTransfer'                               => 'Nový převod',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Za deň',
    'left_to_spend_per_day'                     => 'Zostáva na denné útraty',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Vlastné obdobie',
    'reset_to_current'                          => 'Obnoviť na aktuálne obdobie',
    'select_period'                             => 'Vyberte obdobie',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Mena',
    'preferences'                               => 'Možnosti',
    'logout'                                    => 'Odhlásiť sa',
    'logout_other_sessions'                     => 'Odhlásiť všetky ostatné sedenia',
    'toggleNavigation'                          => 'Vyp/zap. navigáciu',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Vyhľadať...',
    'version'                                   => 'Verzia',
    'dashboard'                                 => 'Prehľad',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'No budget',
    'available_budget'                          => 'Rozpočet k dispozícii ({currency})',
    'currencies'                                => 'Meny',
    'activity'                                  => 'Aktivita',
    'usage'                                     => 'Použitie',
    'accounts'                                  => 'Účty',
    'Asset account'                             => 'Účet aktiv',
    'Default account'                           => 'Účet aktiv',
    'Expense account'                           => 'Výdavkový účet',
    'Revenue account'                           => 'Príjmový účet',
    'Initial balance account'                   => 'Účet počiatočného zostatku',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Dlh',
    'account_type_Loan'                         => 'Pôžička',
    'account_type_Mortgage'                     => 'Hypotéka',
    'account_type_debt'                         => 'Debt',
    'account_type_loan'                         => 'Loan',
    'account_type_mortgage'                     => 'Mortgage',
    'account_type_Credit card'                  => 'Kreditná karta',
    'credit_card_type_monthlyFull'              => 'Full payment every month',
    'liability_direction_credit'                => 'Túto sumu mi dlžia',
    'liability_direction_debit'                 => 'Tento dlh mám voči niekomu inému',
    'liability_direction_credit_short'          => 'Owed this debt',
    'liability_direction_debit_short'           => 'Owe this debt',
    'liability_direction__short'                => 'Unknown',
    'liability_direction_null_short'            => 'Unknown',
    'Liability credit'                          => 'Liability credit',
    'budgets'                                   => 'Rozpočty',
    'tags'                                      => 'Štítky',
    'reports'                                   => 'Výkazy',
    'transactions'                              => 'Transakcie',
    'expenses'                                  => 'Výdavky',
    'income'                                    => 'Zisky / príjmy',
    'transfers'                                 => 'Prevody',
    'moneyManagement'                           => 'Správa peňazí',
    'money_management'                          => 'Správa peňazí',
    'tools'                                     => 'Nástroje',
    'piggyBanks'                                => 'Pokladničky',
    'piggy_banks'                               => 'Pokladničky',
    'amount_x_of_y'                             => '{current} z {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Výber',
    'opening_balance'                           => 'Počiatočný zostatok',
    'deposit'                                   => 'Vklad',
    'account'                                   => 'Účet',
    'transfer'                                  => 'Prevod',
    'Withdrawal'                                => 'Výber',
    'Deposit'                                   => 'Vklad',
    'Transfer'                                  => 'Prevod',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Áno',
    'no'                                        => 'Ne',
    'amount'                                    => 'Suma',
    'overview'                                  => 'Prehľad',
    'saveOnAccount'                             => 'Uložiť na účet',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Neznáme',
    'monthly'                                   => 'Mesačne',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Chyby',
    'debt_start_date'                           => 'Dátum začiatku dlhu',
    'debt_start_amount'                         => 'Počiatočná výška dlhu',
    'debt_start_amount_help'                    => 'Najlepšie je vždy túto hodnotu nastaviť na zápornú hodnotu. Ďalšie informácie nájdete na stránkach pomocníka (ikona (?) vpravo hore).',
    'interest_period_help'                      => 'Toto pole je čisto kozmetické a nebude sa pre vás počítať. Ako sa ukázalo, banky sú veľmi záludné, takže Firefly III to nikdy neurobí správne.',
    'store_new_liabilities_account'             => 'Uložiť nový záväzok',
    'edit_liabilities_account'                  => 'Upraviť záväzok „:name“',
    'financial_control'                         => 'Finančná kontrola',
    'accounting'                                => 'Bankové účty',
    'automation'                                => 'Automatizácia',
    'others'                                    => 'Iné',
    'classification'                            => 'Klasifikácia',
    'store_transaction'                         => 'Uložiť transakciu',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Predvolený finančný výkaz v období :start a :end',
    'report_audit'                              => 'Prehľad histórie transakcií medzi :start a :end',
    'report_category'                           => 'Výkaz kategórie v rozmedzí :start a :end',
    'report_double'                             => 'Výkaz účtov výdavkov/výnosov medzi :start a :end',
    'report_budget'                             => 'Výkaz rozpočtov medzi :start a :end',
    'report_tag'                                => 'Výkaz štítkov medzi :start a :end',
    'quick_link_reports'                        => 'Rýchle odkazy',
    'quick_link_examples'                       => 'Je to len niekoľko príkladov prepojení, ktoré vám pomôžu začať. Na stránkach pomocníka pod tlačidlom (?) Nájdete informácie o všetkých výkazoch a magických slovíčkach, ktoré môžete použiť.',
    'quick_link_default_report'                 => 'Predvolený finančný výkaz',
    'quick_link_audit_report'                   => 'Prehľad histórie transakcií',
    'report_this_month_quick'                   => 'Aktuálny mesiac, všetky účty',
    'report_last_month_quick'                   => 'Minulý mesiac, všetky účty',
    'report_this_year_quick'                    => 'Aktuálny rok, všetky účty',
    'report_this_fiscal_year_quick'             => 'Aktuálny fiškálny rok, všetky účty',
    'report_all_time_quick'                     => 'Kedykoľvek, všetky účty',
    'reports_can_bookmark'                      => 'Pamätajte, že výkazy je možné si ukládať do záložiek.',
    'incomeVsExpenses'                          => 'Príjmy voči výdavkom',
    'accountBalances'                           => 'Zostatky účtov',
    'balanceStart'                              => 'Zostatok na začiatku obdobia',
    'balanceEnd'                                => 'Zostatok na konci obdobia',
    'splitByAccount'                            => 'Rozúčtovanie podľa účtu',
    'coveredWithTags'                           => 'Pokryté štítkami',
    'leftInBudget'                              => 'Zostáva v rozpočte',
    'left_in_debt'                              => 'Amount due',
    'sumOfSums'                                 => 'Súhrn súčtov',
    'noCategory'                                => '(bez kategórie)',
    'notCharged'                                => 'Nestrhnuté (zatiaľ)',
    'inactive'                                  => 'Neaktívne',
    'active'                                    => 'Aktívne',
    'difference'                                => 'Rozdiel',
    'money_flowing_in'                          => 'Prichádzajúce',
    'money_flowing_out'                         => 'Odchádzajúce',
    'topX'                                      => 'naj :number',
    'show_full_list'                            => 'Zobraziť celý zoznam',
    'show_only_top'                             => 'Zobraziť len :number naj',
    'report_type'                               => 'Typ výkazu',
    'report_type_default'                       => 'Predvolený finančný výkaz',
    'report_type_audit'                         => 'Prehlad histórie transakcií (audit)',
    'report_type_category'                      => 'Výkaz kategórií',
    'report_type_budget'                        => 'Výkaz rozpočtu',
    'report_type_tag'                           => 'Výkaz štítkov',
    'report_type_double'                        => 'Výkaz výdajov/výnosov účtu',
    'more_info_help'                            => 'Viac informácií o týchto druhoch výkazov nájdete na stránkach pomocníka. Stlačte ikonu (?) V pravom hornom rohu.',
    'report_included_accounts'                  => 'Zahrnuté účty',
    'report_date_range'                         => 'Obdobie',
    'report_preset_ranges'                      => 'Predvolené rozsahy',
    'shared'                                    => 'Zdieľané',
    'fiscal_year'                               => 'Fiškálny rok',
    'income_entry'                              => 'Príjmy z účtu „:name“ medzi :start a :end',
    'expense_entry'                             => 'Výdavky z účtu „:name“ v období :start a :end',
    'category_entry'                            => 'Výdavky a príjmy na účte „:name“ v období :start a :end',
    'budget_spent_amount'                       => 'Výdavky z rozpočtu „:budget“ v období :start a :end',
    'balance_amount'                            => 'Výdavky z rozpočtu „:budget“ hradené z účtu „:account“ v období :start a :end',
    'no_audit_activity'                         => 'Medzi :start a :end nebola na účte <a href=":url" title=":account_name">:account_name</a> zaznamenaná žiadna aktivita.',
    'audit_end_balance'                         => 'Zostatok na účte <a href=":url" title=":account_name">:account_name</a> na konci :end bol: :balance',
    'reports_extra_options'                     => 'Ďalšie možnosti',
    'report_has_no_extra_options'               => 'Tento výkaz nemá žiadne ďalšie možnosti',
    'reports_submit'                            => 'Zobraziť výkaz',
    'end_after_start_date'                      => 'Konečný dátum výkazu musí nasledovať po počiatočnom dátume.',
    'select_category'                           => 'Vybrať kategórie',
    'select_budget'                             => 'Vybrať rozpočty.',
    'select_tag'                                => 'Vybrať štítky.',
    'income_per_category'                       => 'Príjem podľa kategórie',
    'expense_per_category'                      => 'Výdavky podľa kategórie',
    'expense_per_budget'                        => 'Výdavky podľa rozpočtu',
    'income_per_account'                        => 'Príjem podľa účtu',
    'expense_per_account'                       => 'Výdavky podľa účtu',
    'expense_per_tag'                           => 'Výdavky podľa štítku',
    'income_per_tag'                            => 'Príjmy podľa štítku',
    'include_expense_not_in_budget'             => 'Zahrnuté výdavky nie sú v zvolených rozpočtoch',
    'include_expense_not_in_account'            => 'Zahrnuté výdavky nie sú v zvolených bankových účtoch',
    'include_expense_not_in_category'           => 'Zahrnuté výdavky nie sú v zvolených kategóriách',
    'include_income_not_in_category'            => 'Zahrnuté príjmy nie sú v zvolených kategóriách',
    'include_income_not_in_account'             => 'Zahrnuté príjmy nie sú v zvolených bankových účtoch',
    'include_income_not_in_tags'                => 'Zahrnuté príjmy nie sú v zvolených štítkoch',
    'include_expense_not_in_tags'               => 'Zahrnuté výdavky nie sú v zvolených štítkoch',
    'everything_else'                           => 'Všetko ostatné',
    'income_and_expenses'                       => 'Príjmy a výdavky',
    'spent_average'                             => 'Utratené (priemerne)',
    'income_average'                            => 'Získané (priemerne)',
    'transaction_count'                         => 'Počet transakcií',
    'average_spending_per_account'              => 'Priemerné výdaje na účet',
    'average_income_per_account'                => 'Priemerný príjem v jednotlivých účtoch',
    'total'                                     => 'Spolu',
    'description'                               => 'Popis',
    'sum_of_period'                             => 'Spolu v období',
    'average_in_period'                         => 'Priemer obdobia',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Predvolený účet aktív',
    'account_role_sharedAsset'                  => 'Zdieľaný účet aktív',
    'account_role_savingAsset'                  => 'Šetriaci účet',
    'account_role_ccAsset'                      => 'Kreditná karta',
    'account_role_cashWalletAsset'              => 'Peňaženka',
    'budget_chart_click'                        => 'Graf zobrazíte kliknutím na názov rozpočtu vo vyššie uvedenej tabuľke.',
    'category_chart_click'                      => 'Graf zobrazíte kliknutím na názov kategórie vo vyššie uvedenej tabuľke.',
    'in_out_accounts'                           => 'Získané a utratené v kombináciách',
    'in_out_accounts_per_asset'                 => 'Zarobené a utratené (na majetkový účet)',
    'in_out_per_category'                       => 'Získané a utratené v jednotlivých kategóriách',
    'out_per_budget'                            => 'Utratené v jednotlivých rozpočtoch',
    'select_expense_revenue'                    => 'Vybrať účet výdavkov/ziskov',
    'multi_currency_report_sum'                 => 'Pretože tento zoznam obsahuje účty v rôznych menách, nedávajú zobrazované súčty zmysel. Výkaz v tomto prípade vždy použije predvolenú menu.',
    'sum_in_default_currency'                   => 'Suma vždy bude v mene, ktorú ste nastavili jako predvolenú.',
    'net_filtered_prefs'                        => 'Tento graf nikdy nebude obsahovať účty, ktoré nemajú začiarknuté políčko „Zahrnúť do čistého imania“.',


    // charts:
    'chart'                                     => 'Graf',
    'month'                                     => 'Mesiac',
    'budget'                                    => 'Rozpočet',
    'spent'                                     => 'Utratené',
    'spent_capped'                              => 'Útraty (obmedzené)',
    'spent_in_budget'                           => 'Utratené v rozpočte',
    'left_to_spend'                             => 'Zostáva k útrate',
    'earned'                                    => 'Zarobené',
    'overspent'                                 => 'Prekročené výdaje',
    'left'                                      => 'Zostáva',
    'max-amount'                                => 'Maximálna suma',
    'min-amount'                                => 'Najmenšia možná suma',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Názov',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Dátum',
    'date_and_time'                             => 'Dátum a čas',
    'time'                                      => 'Čas',
    'paid'                                      => 'Uhradené',
    'unpaid'                                    => 'Neuhradené',
    'day'                                       => 'Deň',
    'budgeted'                                  => 'Rozpočtované',
    'period'                                    => 'Obdobie',
    'balance'                                   => 'Zostatok',
    'in_out_period'                             => 'In + out this period',
    'sum'                                       => 'Suma',
    'summary'                                   => 'Sumár',
    'average'                                   => 'Priemer',
    'balanceFor'                                => 'Zostatok pre :name',
    'no_tags'                                   => '(žiadne štítky)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Event history',
    'add_money_to_piggy'            => 'Vložiť peniaze do pokladničky ":name"',
    'piggy_bank'                    => 'Pokladnička',
    'new_piggy_bank'                => 'Nová pokladnička',
    'store_piggy_bank'              => 'Uložiť novú pokladničku',
    'stored_piggy_bank'             => 'Uložiť novú pokladničku „:name“',
    'account_status'                => 'Stav účtu',
    'left_for_piggy_banks'          => 'Zostáva pre pokladničky',
    'sum_of_piggy_banks'            => 'Súčet pokladničiek',
    'saved_so_far'                  => 'Doteraz našetrené',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Zostáva ušetriť',
    'suggested_amount'              => 'Odporúčaná mesačná suma do úspor',
    'add_money_to_piggy_title'      => 'Vložiť peniaze do pokladničky ":name"',
    'remove_money_from_piggy_title' => 'Vybrať peniaze z pokladničky ":name"',
    'add'                           => 'Pridať',
    'no_money_for_piggy'            => 'Nie sú k dispozícii žiadne peniaze, ktoré by se dali vložiť do tejto pokladničky.',
    'suggested_savings_per_month'   => 'Odporúčané na mesiac',

    'remove'                    => 'Odstrániť',
    'max_amount_add'            => 'Najvyššia suma, ktorú je možné pridať je',
    'max_amount_remove'         => 'Najvyššia suma, ktorú je možné odobrať je',
    'update_piggy_button'       => 'Upraviť pokladničku',
    'update_piggy_title'        => 'Upraviť pokladničku ":name"',
    'updated_piggy_bank'        => 'Pokladnička „:name“ bola upravená',
    'details'                   => 'Podrobnosti',
    'events'                    => 'Udalosti',
    'target_amount'             => 'Cieľová suma',
    'start_date'                => 'Dátum zahájenia',
    'no_start_date'             => 'Žiadny dátum zahájenia',
    'target_date'               => 'Cieľový dátum',
    'no_target_date'            => 'Žiadny cieľový dátum',
    'table'                     => 'Tabuľka',
    'delete_piggy_bank'         => 'Odstrániť pokladničku ":name"',
    'cannot_add_amount_piggy'   => 'Nepodarilo sa pridať :amount do „:name“.',
    'cannot_remove_from_piggy'  => 'Nepodarilo sa odstrániť :amount z „:name“.',
    'deleted_piggy_bank'        => 'Pokladnička ":name" bola odstránená',
    'added_amount_to_piggy'     => ':amount pridané do „:name“',
    'removed_amount_from_piggy' => ':amount odobrané z „:name“',
    'piggy_events'              => 'Súvisiace pokladničky',

    // tags
    'delete_tag'                => 'Odstrániť štítok „:tag“',
    'deleted_tag'               => 'Štítok „:tag“ bol odstránený',
    'new_tag'                   => 'Vytvoriť nový štítok',
    'edit_tag'                  => 'Upraviť štítok „:tag“',
    'updated_tag'               => 'Štítok „:tag“ bol upravený',
    'created_tag'               => 'Štítok „:tag“ bol vytvorený!',

    'transaction_journal_information'               => 'Informácie o transakcii',
    'transaction_journal_amount'                    => 'Amount information',
    'transaction_journal_meta'                      => 'Meta informácie',
    'transaction_journal_more'                      => 'Ďalšie informácie',
    'basic_journal_information'                     => 'Základné Informácie o transakcii',
    'transaction_journal_extra'                     => 'Ďalšie informácie',
    'att_part_of_journal'                           => 'Uložené pod „:journal“',
    'total_amount'                                  => 'Celková suma',
    'number_of_decimals'                            => 'Počet desatinných miest',


    // administration
    'invite_is_already_redeemed'                    => 'The invite to ":address" has already been redeemed.',
    'invite_is_deleted'                             => 'The invite to ":address" has been deleted.',
    'invite_new_user_title'                         => 'Invite new user',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Email address',
    'invite_user'                                   => 'Invite user',
    'user_is_invited'                               => 'Email address ":address" was invited to Firefly III',
    'administration'                                => 'Správa',
    'system_settings'                               => 'System settings',
    'code_already_used'                             => 'Invite code has been used',
    'user_administration'                           => 'Správa použivateľov',
    'list_all_users'                                => 'Všetci použivatelia',
    'all_users'                                     => 'Všetci použivatelia',
    'instance_configuration'                        => 'Nastavenia',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'setting_single_user_mode'                      => 'Režim jediného použivateľa',
    'setting_single_user_mode_explain'              => 'V predvolenom režime Firefly III akceptuje len jednu registráciu – Vás. Toto je bezpečnostné opatrenie, brániace ostatným používať vašu inštaláciu, kým im to nepovolíte. Ďalšie registrácie sú blokované. Aj tento prepínač povolíte, budú vašu inštaláciu Firefly III môcť použiť, samozrejme za predpokladu, že je je pre nich dostupná (pripojená k Internetu).',
    'store_configuration'                           => 'Uložiť nastavenia',
    'single_user_administration'                    => 'Správa použivateľa pre :email',
    'edit_user'                                     => 'Upraviť použivateľa :email',
    'hidden_fields_preferences'                     => 'Viac možností transakcií môžete povoliť vo svojich <a href="/preferences">nastaveniach</a>.',
    'user_data_information'                         => 'Použivateľské údaje',
    'user_information'                              => 'Informácie o použivateľovi',
    'total_size'                                    => 'celková veľkosť',
    'budget_or_budgets'                             => ':count rozpočet|:count rozpočtov',
    'budgets_with_limits'                           => ':count rozpočet s rozpočtovou sumou|:count rozpočtov s rozpočtovou sumou',
    'nr_of_rules_in_total_groups'                   => ':count_rules pravidiel v skupine pravidiel :count_groups',
    'tag_or_tags'                                   => ':count štítok|:count štítkov',
    'configuration_updated'                         => 'Nastavenie bolo upravené',
    'setting_is_demo_site'                          => 'Demostránka',
    'setting_is_demo_site_explain'                  => 'Ak začiarknete toto políčko, bude sa táto inštalácia správať, akoby išlo o ukážkovú stránku, čo môže mať zvláštne vedľajšie účinky.',
    'block_code_bounced'                            => 'E-mailové správy boli vrátené',
    'block_code_expired'                            => 'Platnost demoúčtu skončila',
    'no_block_code'                                 => 'Nie je dôvod pre blokovanie, alebo použivateľ nebol zablokovaný',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'Poživateľ ešte nepotvrdil svoju e-mailovú adresu',
    'admin_update_email'                            => 'Na rozdiel od profilovej stránky použivatel NEBUDE upozornený na zmenu svojej e-mailovej adresy!',
    'update_user'                                   => 'Upraviť použivateľa',
    'updated_user'                                  => 'Údaje použivateľa boli zmenené.',
    'delete_user'                                   => 'Odstrániť použivateľa :email',
    'user_deleted'                                  => 'Použivateľ bol odstránený',
    'send_test_email'                               => 'Poslať skúšobný e-mail',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Odoslať správu',
    'send_test_triggered'                           => 'Test bol odoslaný. Skontrolujte svoju doručenú poštu a súbory denníka.',
    'give_admin_careful'                            => 'Používatelia, ktorí majú práva správcu, vám môžu odobrať tie vaše. Buďte opatrní.',
    'admin_maintanance_title'                       => 'Údržba',
    'admin_maintanance_expl'                        => 'Niekoľko šikovných tlačidiel pre údržbu Firefly III',
    'admin_maintenance_clear_cache'                 => 'Vymazať medzipamäť',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'All invited users',
    'save_notification_settings'                    => 'Save settings',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'The notification settings have been saved',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Popis rozúčtovania',
    'split_transaction_title_help'          => 'Ak vytvoríte rozúčtovanú transakciu, musí existovať globálny popis všetkých rozúčtovaní transakcie.',
    'split_title_help'                      => 'Ak vytvoríte rozúčtovanie transakcie, je potrebné, aby ste určili všeobecný popis pre všetky rozúčtovania danej transakcie.',
    'you_create_transfer'                   => 'Vytvárate prevod.',
    'you_create_withdrawal'                 => 'Vytvárate výber.',
    'you_create_deposit'                    => 'Vytvárate vklad.',

    // links
    'journal_link_configuration'            => 'Konfigurácia prepojení transakcií',
    'create_new_link_type'                  => 'Vytvoriť nový typ prepojenia',
    'store_new_link_type'                   => 'Uložiť nový typ prepojenia',
    'update_link_type'                      => 'Upraviť typ prepojenia',
    'edit_link_type'                        => 'Upraviť prepojenie typu „:name“',
    'updated_link_type'                     => 'Prepojenie typu „:name“ bolo upravené',
    'delete_link_type'                      => 'Odstrániť prepojenie typu ":name"',
    'deleted_link_type'                     => 'Prepojenie typu ":name" bolo odstránené',
    'stored_new_link_type'                  => 'Uložiť nové prepojenie typu ":name"',
    'cannot_edit_link_type'                 => 'Nie je možné upraviť prepojenie typu ":name"',
    'link_type_help_name'                   => 'tj. "duplicity"',
    'link_type_help_inward'                 => 'tj. „duplicity“',
    'link_type_help_outward'                => 'tj. "duplikované"',
    'save_connections_by_moving'            => 'Uložiť prepojenie medzi týmito transakciami presunutím do iného typu prepojenia:',
    'do_not_save_connection'                => '(neukladať prepojenie)',
    'link_transaction'                      => 'Prepojiť transakciu',
    'link_to_other_transaction'             => 'Prepojiť túto transakciu s inou',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Táto transakcia',
    'transaction'                           => 'Transakcia',
    'comments'                              => 'Komentáre',
    'link_notes'                            => 'Všetky poznámky, ktoré chcete uložiť s prepojením.',
    'invalid_link_selection'                => 'Tieto transakcie nie je možné prepojiť',
    'selected_transaction'                  => 'Vybraná transakcia',
    'journals_linked'                       => 'Transakcie sú prepojené.',
    'journals_error_linked'                 => 'Tieto transakcie už sú prepojené.',
    'journals_link_to_self'                 => 'Nie je možné prepojiť transakciu so sebou samou',
    'journal_links'                         => 'Prepojenia transakcie',
    'this_withdrawal'                       => 'Tento výber',
    'this_deposit'                          => 'Tento vklad',
    'this_transfer'                         => 'Tento prevod',
    'overview_for_link'                     => 'Prehľad pre prepojenie typu ":name"',
    'source_transaction'                    => 'Zdrojová transakcia',
    'link_description'                      => 'Popis prepojenia',
    'destination_transaction'               => 'Cieľová transakcia',
    'delete_journal_link'                   => 'Odstránenie prepojenia medzi <a href=":source_link">:source</a> a <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Prepojenie bolo odstránené',

    // link translations:
    'Paid_name'                             => 'Uhradené',
    'Refund_name'                           => 'Refundácia',
    'Reimbursement_name'                    => 'Preplatenie',
    'Related_name'                          => 'Súvisiace',
    'relates to_inward'                     => 'súvisí s',
    'is (partially) refunded by_inward'     => 'je (čiastočne) preplatené',
    'is (partially) paid for by_inward'     => 'je (čiastočne) uhradené',
    'is (partially) reimbursed by_inward'   => 'je (čiastočne) preplatené',
    'inward_transaction'                    => 'Príchodzia transakcia',
    'outward_transaction'                   => 'Odchádzajúca transakcia',
    'relates to_outward'                    => 'súvisí s',
    '(partially) refunds_outward'           => '(čiastočne) prepláca',
    '(partially) pays for_outward'          => '(čiastočne) uhrádza',
    '(partially) reimburses_outward'        => '(čiastočne) prepláca',
    'is (partially) refunded by'            => 'je (čiastočne) preplatené',
    'is (partially) paid for by'            => 'je (čiastočne) uhradené',
    'is (partially) reimbursed by'          => 'je (čiastočne) preplatené',
    'relates to'                            => 'súvisí s',
    '(partially) refunds'                   => '(čiastočne) prepláca',
    '(partially) pays for'                  => '(čiastočne) uhrádza',
    '(partially) reimburses'                => '(čiastočne) prepláca',

    // split a transaction:
    'splits'                                => 'Rozúčtovania',
    'add_another_split'                     => 'Pridať ďalšie rozúčtovanie',
    'cannot_edit_opening_balance'           => 'Počiatočný zostatok na účte nemôžete upraviť.',
    'no_edit_multiple_left'                 => 'Nevybrali ste žiadne platné transakcie na úpravu.',
    'breadcrumb_convert_group'              => 'Zmeniť transakciu',
    'convert_invalid_source'                => 'Zdrojové informácie sú pre transakciu #%d neplatné.',
    'convert_invalid_destination'           => 'Cílové informace sú pre transakciu #%d neplatné.',
    'create_another'                        => 'Po uložení sa vrátiť späť sem a vytvoriť ďalší.',
    'after_update_create_another'           => 'Po aktualizácii sa vrátiť späť a pokračovať v úpravách.',
    'store_as_new'                          => 'Namiesto aktualizácie uložiť ako novú transakciu.',
    'reset_after'                           => 'Po odoslaní vynulovať formulár',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Expand split',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Collapse split',

    // object groups
    'default_group_title_name'              => '(nezoskupené)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Vytvorme účet aktív!',
    'no_accounts_intro_asset'               => 'Zatiaľ nemáte žiadne majetkové účty. Majetkové účty sú vaše hlavné účty: bežný účet, sporiaci účet, zdieľaný účet alebo dokonca vaša kreditná karta.',
    'no_accounts_imperative_asset'          => 'Ak chcete začať používať Firefly III, musíte si vytvoriť aspoň jeden majetkový účet. Urobme tak teraz:',
    'no_accounts_create_asset'              => 'Vytvoriť nový účet',
    'no_accounts_title_expense'             => 'Vytvorme výdavkový účet!',
    'no_accounts_intro_expense'             => 'Zatiaľ ste nevytvorili žiadne výdavkové účty. Tieto účty sú určené na útraty, napríklad v obchodoch a supermarketoch.',
    'no_accounts_imperative_expense'        => 'Výdavkové účty sa vytvárajú automaticky pri vytváraní transakcií, ale ak chcete, môžete ich vytvoriť aj manuálne. Vytvorme si jeden teraz:',
    'no_accounts_create_expense'            => 'Vytvoriť výdavkový účet',
    'no_accounts_title_revenue'             => 'Vytvorme príjmový účet!',
    'no_accounts_intro_revenue'             => 'Zatiaľ ste nevytvorili žiadny príjmový účet. Príjmové účty slúžia na príjem peňazí – napríklad od vášho zamestnávateľa.',
    'no_accounts_imperative_revenue'        => 'Účty výnosov sa vytvárajú automaticky pri vytváraní transakcií, ale môžete ich vytvoriť aj manuálne. Vytvorme si jeden teraz:',
    'no_accounts_create_revenue'            => 'Vytvoriť príjmový účet',
    'no_accounts_title_liabilities'         => 'Poďme vytvoriť záväzok!',
    'no_accounts_intro_liabilities'         => 'Zatiaľ ste nevytvorili žiadne záväzky. Sú to účty, ktoré registrujú vaše pôžičky a ostatné dlhy.',
    'no_accounts_imperative_liabilities'    => 'Túto funkciu nemusíte používať, ale hodí sa, ak si chcete v týchto veciach udržať prehľad.',
    'no_accounts_create_liabilities'        => 'Vytvoriť záväzok',
    'no_budgets_title_default'              => 'Poďme vytvoriť rozpočet',
    'no_rules_title_default'                => 'Let\'s create a rule',
    'no_budgets_intro_default'              => 'Zatiaľ nemáte žiadne rozpočty. Rozpočty sa používajú na usporiadanie vašich výdavkov do logických skupín, ktoré môžete obmedziť výdavkom pomocou soft-cap.',
    'no_rules_intro_default'                => 'You have no rules yet. Rules are powerful automations that can handle transactions for you.',
    'no_rules_imperative_default'           => 'Rules can be very useful when you\'re managing transactions. Let\'s create one now:',
    'no_budgets_imperative_default'         => 'Rozpočty sú základné nástroje správy financií. Poďme si taký vytvoriť:',
    'no_budgets_create_default'             => 'Vytvoriť rozpočet',
    'no_rules_create_default'               => 'Create a rule',
    'no_categories_title_default'           => 'Poďme vytvoriť kategóriu!',
    'no_categories_intro_default'           => 'Zatiaľ nemáte žiadne kategórie. Kategórie sa používajú na doladenie vašich transakcií a na označenie príslušnou kategóriou.',
    'no_categories_imperative_default'      => 'Kategórie sa vytvárajú automaticky pri vytváraní transakcií, ale môžete ich vytvoriť aj manuálne. Vytvorme si teraz jednu:',
    'no_categories_create_default'          => 'Vytvoriť kategóriu',
    'no_tags_title_default'                 => 'Poďme vytvoriť štítok!',
    'no_tags_intro_default'                 => 'Ešte ste nevytvorili žiadny štítok. Slúžia na jemné dolaďovanie vašich transakcií a označujú ich konkrétnymi kľúčovými slovami.',
    'no_tags_imperative_default'            => 'Štítky sa vytvárajú automaticky pri vytváraní transakcií, ale môžete ich vytvoriť aj ručne. Vytvorme si teraz jeden:',
    'no_tags_create_default'                => 'Vytvoriť štítok',
    'no_transactions_title_withdrawal'      => 'Poďme vytvoriť výdavok!',
    'no_transactions_intro_withdrawal'      => 'Zatiaľ nemáte žiadne výdaje. Mali by ste si vytvoriť výdavky, aby ste mohli začať spravovať svoje financie.',
    'no_transactions_imperative_withdrawal' => 'Už ste minuli nejaké peniaze? Potom by ste si to mali zapísať:',
    'no_transactions_create_withdrawal'     => 'Vytvoriť výdavok',
    'no_transactions_title_deposit'         => 'Poďme vytvoriť nejaký príjem!',
    'no_transactions_intro_deposit'         => 'Zatiaľ nemáte zaznamenaný žiadny príjem. Mali by ste vytvoriť záznamy o príjmoch, aby ste mohli začať spravovať svoje financie.',
    'no_transactions_imperative_deposit'    => 'Dostali ste nejaké peniaze? Potom by ste si to mali zapísať:',
    'no_transactions_create_deposit'        => 'Vytvoriť vklad',
    'no_transactions_title_transfers'       => 'Poďme vytvoriť prevod!',
    'no_transactions_intro_transfers'       => 'Zatiaľ nemáte žiadne prevody. Keď presúvate peniaze medzi majetkovými účtami, zaznamená sa to ako prevod.',
    'no_transactions_imperative_transfers'  => 'Presunuli ste nejaké peniaze? Potom by ste si to mali zapísať:',
    'no_transactions_create_transfers'      => 'Vytvoriť prevod',
    'no_piggies_title_default'              => 'Poďme vytvoriť pokladničku!',
    'no_piggies_intro_default'              => 'Zatiaľ nemáte žiadne pokladničky. Môžete vytvoriť pokladničky, ktoré vám rozdelia úspory a sledujú, na čo si šetríte.',
    'no_piggies_imperative_default'         => 'Máte veci, na ktoré si šetríte peniaze? Vytvorte si pokladničku a sledujte vývoj:',
    'no_piggies_create_default'             => 'Vytvoriť novú pokladničku',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Create right now',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Opakované transakcie',
    'repeat_until_in_past'                  => 'Táto opakujúca sa transakcia sa prestala opakovať :date.',
    'recurring_calendar_view'               => 'Kalendár',
    'no_recurring_title_default'            => 'Poďme vytvoriť opakujúcu sa transakciu!',
    'no_recurring_intro_default'            => 'Zatiaľ nemáte žiadne opakujúce sa transakcie. Môžete ich použiť na to, aby Firefly III za vás automaticky vytvoril transakcie.',
    'no_recurring_imperative_default'       => 'Toto je dosť pokročilá funkcia, ale môže byť veľmi užitočná. Než budete pokračovať, nezabudnite si prečítať dokumentáciu - ikona (?) v pravom hornom rohu.',
    'no_recurring_create_default'           => 'Vytvoriť opakujúcu sa transakciu',
    'make_new_recurring'                    => 'Vytvoriť opakujúcu sa transakciu',
    'recurring_daily'                       => 'Každý deň',
    'recurring_weekly'                      => 'Každý týždeň v :weekday',
    'recurring_weekly_skip'                 => 'Každý :skip týždeň v :weekday',
    'recurring_monthly'                     => 'Každý mesiac, :dayOfMonthho',
    'recurring_monthly_skip'                => 'Každý :skip mesiac, :dayOfMonthho',
    'recurring_ndom'                        => 'Každý mesiac, :weekday :dayOfMonthho',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Každý rok v :date',
    'overview_for_recurrence'               => 'Prehľad opakujúcej sa transakcie ":title"',
    'warning_duplicates_repetitions'        => 'V zriedkavých prípadoch sa v tomto zozname zobrazia dátumy dvakrát. To sa môže stať, keď sa zrazí viac opakovaní. Firefly III vygeneruje vždy jednu transakciu za deň.',
    'created_transactions'                  => 'Súvisiace transakcie',
    'expected_withdrawals'                  => 'Očakávané výbery',
    'expected_deposits'                     => 'Očakávané vklady',
    'expected_transfers'                    => 'Očakávané prevody',
    'created_withdrawals'                   => 'Vytvorené výbery',
    'created_deposits'                      => 'Vytvorené vklady',
    'created_transfers'                     => 'Vytvorené prevody',
    'recurring_info'                        => 'Opakovaná transakcia :count / :total',
    'created_from_recurrence'               => 'Vytvorené z opakovanej transakcie ":title" (#:id)',
    'recurring_never_cron'                  => 'Zdá sa, že úloha cron, ktorá je nevyhnutná na podporu opakujúcich sa transakcií, sa nikdy nespustila. To je samozrejme normálne, keď ste práve nainštalovali Firefly III, ale toto by mali čo najskôr nastaviť. Skontrolujte stránky pomocníka pomocou ikony (?) v pravom hornom rohu stránky.',
    'recurring_cron_long_ago'               => 'Vyzerá to, že od posledného spustenia úlohy cron na podporu opakujúcich sa transakcií uplynulo viac ako 36 hodín. Ste si istý, že bol nastavený správne? Skontrolujte stránky pomocníka pomocou ikony (?) v pravom hornom rohu stránky.',

    'create_new_recurrence'              => 'Vytvoriť novú opakujúcu sa transakciu',
    'help_first_date'                    => 'Uveďte prvé očakávané opakovanie. Musí byť v budúcnosti.',
    'help_first_date_no_past'            => 'Uveďte prvé očakávané opakovanie. Firefly III nevytvára transakcie v minulosti.',
    'no_currency'                        => '(žiadna mena)',
    'mandatory_for_recurring'            => 'Nezbytné informace k opakovanosti',
    'mandatory_for_transaction'          => 'Povinné informácie o transakcii',
    'optional_for_recurring'             => 'Voliteľné informácie o opakovanosti',
    'optional_for_transaction'           => 'Voliteľné informácie o transakcii',
    'change_date_other_options'          => 'Pre zobrazenie ďalších možností zmeňte „prvý dátum“.',
    'mandatory_fields_for_tranaction'    => 'Tieto hodnoty budú prevedené do vytvorených transakcií',
    'click_for_calendar'                 => 'Kliknite sem pre zobrazenie kalendára, ktorý vám ukáže, kedy sa transakcia bude opakovať.',
    'repeat_forever'                     => 'Opakovat donekonečna',
    'repeat_until_date'                  => 'Opakovat do dátumu',
    'repeat_times'                       => 'Zopakovat -krát',
    'recurring_skips_one'                => 'Každý druhý',
    'recurring_skips_more'               => 'Preskočí :count výskytov',
    'store_new_recurrence'               => 'Uložiť opakovanú transakciu',
    'stored_new_recurrence'              => 'Opakujúca sa transakcia „:title“ bola uložená.',
    'edit_recurrence'                    => 'Upraviť opakovanú transakciu „:title“',
    'recurring_repeats_until'            => 'Opakuje sa do :date',
    'recurring_repeats_forever'          => 'Opakuje sa navždy',
    'recurring_repeats_x_times'          => 'Opakuje sa :count krát|Opakuje sa :count krát',
    'update_recurrence'                  => 'Upraviť opakujúcu sa transakciu',
    'updated_recurrence'                 => 'Opakovaná transakcia ":title" bola upravená',
    'recurrence_is_inactive'             => 'Táto opakujúca sa transakcia nie je aktívna a nebude generovať nové transakcie.',
    'delete_recurring'                   => 'Odstrániť opakovanú transakciu „:title“',
    'new_recurring_transaction'          => 'Nová opakujúca sa transakcia',
    'help_weekend'                       => 'Čo by mal Firefly III spraviť, keď opakovaná transakcia pripadne na sobotu alebo nedeľu?',
    'do_nothing'                         => 'Len vytvoriť transakciu',
    'skip_transaction'                   => 'Preskočit opakovanosť',
    'jump_to_friday'                     => 'Namiesto toho vytvoriť transakciu predchádzajúci piatok',
    'jump_to_monday'                     => 'Namiesto toho vytvoriť transakciu nasledujúci pondelok',
    'will_jump_friday'                   => 'Vytvorí sa v piatok namiesto víkendu.',
    'will_jump_monday'                   => 'Vytvorí sa v pondelok namiesto víkendu.',
    'except_weekends'                    => 'Okrem víkendov',
    'recurrence_deleted'                 => 'Opakovaná transakcia ":title" bola odstránená',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Zostatok (:currency)',
    'box_spent_in_currency'              => 'Utratené (:currency)',
    'box_earned_in_currency'             => 'Zarobené (:currency)',
    'box_budgeted_in_currency'           => 'Rozpočet (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Zostáva k útrate (:currency)',
    'box_net_worth_in_currency'          => 'Čisté imanie (:currency)',
    'box_spend_per_day'                  => 'Zostáva pre dennú útratu: :amount',

    // debug page
    'debug_page'                         => 'Stránka ladenia',
    'debug_submit_instructions'          => 'Ak narazíte na problémy, môžete informácie z tohto poľa použiť ako ladiace informácie. Skopírujte a prilepte do nového alebo existujúceho <a href="https://github.com/firefly-iii/firefly-iii/issues">hlásenia GitHub</a>. Vygeneruje krásnu tabuľku, pomocou ktorej je možné rýchlo diagnostikovať váš problém.',
    'debug_pretty_table'                 => 'Ak skopírujete/prilepíte nižšie uvedené pole do vydania GitHub, vygeneruje sa tabuľka. Nepridávajte okolo tohto textu znaky ` ani úvodzovky.',
    'debug_additional_data'              => 'Môžete tiež zdieľať obsah poľa nižšie. Môžete ich tiež skopírovať a vložiť do nového alebo existujúceho <a href="https://github.com/firefly-iii/firefly-iii/issues">hlásenia GitHub</a>. Obsah tohto poľa však môže obsahovať súkromné informácie, ako sú názvy účtov, podrobnosti transakcií alebo e-mailové adresy.',

    // object groups
    'object_groups_menu_bar'             => 'Skupiny',
    'object_groups_page_title'           => 'Skupiny',
    'object_groups_breadcrumb'           => 'Skupiny',
    'object_groups_index'                => 'Prehľad',
    'object_groups'                      => 'Skupiny',
    'object_groups_empty_explain'        => 'Niektoré veci vo Firefly III sa dajú rozdeliť do skupín. Napríklad pokladničky majú v obrazovkách úprav a vytvárania pole „Skupina“. Keď nastavíte toto pole, môžete na tejto stránke upravovať názvy a poradie skupín. Ďalšie informácie nájdete na stránkach pomocníka v pravom hornom rohu pod ikonou (?).',
    'object_group_title'                 => 'Názov',
    'edit_object_group'                  => 'Upraviť skupinu „:title“',
    'delete_object_group'                => 'Odstrániť skupinu ":title"',
    'update_object_group'                => 'Aktualizovať skupinu',
    'updated_object_group'               => 'Skupina ":title" bola upravená',
    'deleted_object_group'               => 'Skupina ":title" bola odstránená',
    'object_group'                       => 'Skupina',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'Added :amount to piggy bank ":name"',
    'ale_action_log_remove'              => 'Removed :amount from piggy bank ":name"',
    'ale_action_clear_budget'            => 'Removed from budget',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Removed from category',
    'ale_action_clear_notes'             => 'Removed notes',
    'ale_action_clear_tag'               => 'Cleared tag',
    'ale_action_clear_all_tags'          => 'Cleared all tags',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Set budget',
    'ale_action_set_category'            => 'Set category',
    'ale_action_set_source'              => 'Set source account',
    'ale_action_set_destination'         => 'Set destination account',
    'ale_action_update_transaction_type' => 'Changed transaction type',
    'ale_action_update_notes'            => 'Changed notes',
    'ale_action_update_description'      => 'Changed description',
    'ale_action_add_to_piggy'            => 'Piggy bank',
    'ale_action_remove_from_piggy'       => 'Piggy bank',
    'ale_action_add_tag'                 => 'Added tag',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Enable currency conversion',
    'disable_auto_convert'               => 'Disable currency conversion',
];
