<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Zatvori',
    'actions'                                   => 'Akcije',
    'edit'                                      => 'Uredi',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Obriši',
    'split'                                     => 'Razdeli',
    'single_split'                              => 'Razdeli',
    'clone'                                     => 'Kloniraj',
    'clone_and_edit'                            => 'Kloniraj i Uredi',
    'confirm_action'                            => 'Potvrdite akciju',
    'last_seven_days'                           => 'Poslednjih sedam dana',
    'last_thirty_days'                          => 'Poslednjih trideset dana',
    'last_180_days'                             => 'Poslednjih 180 dana',
    'month_to_date'                             => 'Ovaj Mesec',
    'year_to_date'                              => 'Godina do Danas',
    'YTD'                                       => 'Od početka godine',
    'welcome_back'                              => 'Pregled?',
    'main_dashboard_page_title'                 => 'Home',
    'everything'                                => 'Sve',
    'today'                                     => 'danas',
    'customRange'                               => 'Zadajte raspon',
    'date_range'                                => 'Временски период',
    'apply'                                     => 'Primeni',
    'select_date'                               => 'Selektuj datum',
    'cancel'                                    => 'Otkaži',
    'from'                                      => 'Od',
    'to'                                        => 'Do',
    'structure'                                 => 'Struktura',
    'help_translating'                          => 'Ovaj tekst pomoći još uvek nije dostupan na vašem jeziku',
    'showEverything'                            => 'Pokazi sve',
    'never'                                     => 'Nikada',
    'no_results_for_empty_search'               => 'Vaša pretraga je bila prazna, tako da ništa nije pronađeno.',
    'removed_amount'                            => 'Uklonjeno:amount',
    'added_amount'                              => 'Dodano:amount',
    'asset_account_role_help'                   => 'Sve dodatne opcije koje proizilaze iz vašeg izbora mogu se podesiti kasnije.',
    'Opening balance'                           => 'Pocetno stanje otvorenog racuna',
    'create_new_stuff'                          => 'Kreiraj nove stvari',
    'new_withdrawal'                            => 'novo izdanje',
    'create_new_transaction'                    => 'Kreiraj novu transakciju',
    'sidebar_frontpage_create'                  => 'Napravi',
    'new_transaction'                           => 'Nova transakcija',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Pogledajte trenutne racune',
    'go_to_budgets'                             => 'Pokazi budzet',
    'go_to_withdrawals'                         => 'Pogledajte troškove',
    'clones_journal_x'                          => 'Ова transakcija је дупликат ":description" (#:id)',
    'go_to_categories'                          => 'Pokazi kategorije',
    'go_to_bills'                               => 'Go to your subscriptions',
    'go_to_expense_accounts'                    => 'Pogledajte račune troškova',
    'go_to_revenue_accounts'                    => 'Pogledajte račune prihoda',
    'go_to_piggies'                             => 'Покажи касице прасице',
    'new_deposit'                               => 'Novi Depozit',
    'new_transfer'                              => 'New transfer',
    'new_transfers'                             => 'New transfer',
    'new_asset_account'                         => 'New asset account',
    'new_expense_account'                       => 'New expense account',
    'new_revenue_account'                       => 'New revenue account',
    'new_liabilities_account'                   => 'New liability',
    'new_budget'                                => 'New budget',
    'new_bill'                                  => 'New subscription',
    'block_account_logout'                      => 'You have been logged out. Blocked accounts cannot use this site. Did you register with a valid email address?',
    'flash_success'                             => 'Success!',
    'flash_info'                                => 'Message',
    'flash_warning'                             => 'Warning!',
    'flash_error'                               => 'Error!',
    'flash_danger'                              => 'Danger!',
    'flash_info_multiple'                       => 'There is one message|There are :count messages',
    'flash_error_multiple'                      => 'There is one error|There are :count errors',
    'net_worth'                                 => 'Net worth',
    'help_for_this_page'                        => 'Help for this page',
    'help_for_this_page_body'                   => 'You can find more information about this page <a href="https://docs.firefly-iii.org/">in the documentation</a>.',
    'two_factor_welcome'                        => 'Hello!',
    'two_factor_enter_code'                     => 'To continue, please enter your two factor authentication code. Your application can generate it for you.',
    'two_factor_code_here'                      => 'Enter code here',
    'two_factor_title'                          => 'Two factor authentication',
    'authenticate'                              => 'Authenticate',
    'two_factor_forgot_title'                   => 'Lost two factor authentication',
    'two_factor_forgot'                         => 'I forgot my two-factor thing.',
    'two_factor_lost_header'                    => 'Lost your two factor authentication?',
    'two_factor_lost_intro'                     => 'If you lost your backup codes as well, you have bad luck. This is not something you can fix from the web interface. You have two choices.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'Otherwise, email the site owner, <a href="mailto::site_owner">:site_owner</a> and ask them to reset your two factor authentication.',
    'mfa_backup_code'                           => 'You have used a backup code to login to Firefly III. It can\'t be used again, so cross it from your list.',
    'pref_two_factor_new_backup_codes'          => 'Get new backup codes',
    'pref_two_factor_backup_code_count'         => 'You have :count valid backup code.|You have :count valid backup codes.',
    '2fa_i_have_them'                           => 'I stored them!',
    'warning_much_data'                         => ':days days of data may take a while to load.',
    'registered'                                => 'You have registered successfully!',
    'Default asset account'                     => 'Default asset account',
    'no_budget_pointer'                         => 'You seem to have no budgets yet. You should create some on the <a href="budgets">budgets</a>-page. Budgets can help you keep track of expenses.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Savings account',
    'Credit card'                               => 'Credit card',
    'source_accounts'                           => 'Source account|Source accounts',
    'destination_accounts'                      => 'Destination account|Destination accounts',
    'user_id_is'                                => 'Your user id is <strong>:user</strong>',
    'field_supports_markdown'                   => 'This field supports <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'If you need more help using Firefly III, please <a href="https://github.com/firefly-iii/firefly-iii/issues">open a ticket on Github</a>.',
    'reenable_intro_text'                       => 'You can also re-enable <a href="#" id="reenableGuidance">the introduction guidance</a>.',
    'intro_boxes_after_refresh'                 => 'The introduction boxes will reappear when you refresh the page.',
    'show_all_no_filter'                        => 'Show all transactions without grouping them by date.',
    'expenses_by_category'                      => 'Expenses by category',
    'expenses_by_budget'                        => 'Expenses by budget',
    'income_by_category'                        => 'Income by category',
    'expenses_by_asset_account'                 => 'Expenses by asset account',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III cannot redirect you to the correct page. Apologies.',
    'sum_of_expenses'                           => 'Sum of expenses',
    'sum_of_income'                             => 'Sum of income',
    'liabilities'                               => 'Liabilities',
    'spent_in_specific_budget'                  => 'Spent in budget ":budget"',
    'spent_in_specific_double'                  => 'Spent in account ":account"',
    'earned_in_specific_double'                 => 'Earned in account ":account"',
    'source_account'                            => 'Source account',
    'source_account_reconciliation'             => 'You can\'t edit the source account of a reconciliation transaction.',
    'destination_account'                       => 'Destination account',
    'destination_account_reconciliation'        => 'You can\'t edit the destination account of a reconciliation transaction.',
    'sum_of_expenses_in_budget'                 => 'Spent total in budget ":budget"',
    'left_in_budget_limit'                      => 'Left to spend according to budgeting',
    'current_period'                            => 'Current period',
    'show_the_current_period_and_overview'      => 'Show the current period and overview',
    'pref_languages_locale'                     => 'For a language other than English to work properly, your operating system must be equipped with the correct locale-information. If these are not present, currency data, dates and amounts may be formatted wrong.',
    'budget_in_period'                          => 'All transactions for budget ":name" between :start and :end in :currency',
    'chart_budget_in_period'                    => 'Chart for all transactions for budget ":name" between :start and :end in :currency',
    'chart_budget_in_period_only_currency'      => 'The amount you budgeted was in :currency, so this chart will only show transactions in :currency.',
    'chart_account_in_period'                   => 'Chart for all transactions for account ":name" (:balance) between :start and :end',
    'chart_category_in_period'                  => 'Chart for all transactions for category ":name" between :start and :end',
    'chart_category_all'                        => 'Chart for all transactions for category ":name"',
    'clone_withdrawal'                          => 'Clone this withdrawal',
    'clone_deposit'                             => 'Clone this deposit',
    'clone_transfer'                            => 'Clone this transfer',
    'multi_select_no_selection'                 => 'None selected',
    'multi_select_select_all'                   => 'Select all',
    'multi_select_n_selected'                   => 'selected',
    'multi_select_all_selected'                 => 'All selected',
    'multi_select_filter_placeholder'           => 'Find..',
    'intro_next_label'                          => 'Next',
    'intro_prev_label'                          => 'Previous',
    'intro_skip_label'                          => 'Skip',
    'intro_done_label'                          => 'Done',
    'between_dates_breadcrumb'                  => 'Between :start and :end',
    'all_journals_without_budget'               => 'All transactions without a budget',
    'journals_without_budget'                   => 'Transactions without a budget',
    'all_journals_without_category'             => 'All transactions without a category',
    'journals_without_category'                 => 'Transactions without a category',
    'all_journals_for_account'                  => 'All transactions for account :name',
    'chart_all_journals_for_account'            => 'Chart of all transactions for account :name',
    'journals_in_period_for_account'            => 'All transactions for account :name between :start and :end',
    'journals_in_period_for_account_js'         => 'All transactions for account {title} between {start} and {end}',
    'transferred'                               => 'Transferred',
    'all_withdrawal'                            => 'All expenses',
    'all_transactions'                          => 'All transactions',
    'title_withdrawal_between'                  => 'All expenses between :start and :end',
    'all_deposit'                               => 'All revenue',
    'title_deposit_between'                     => 'All revenue between :start and :end',
    'all_transfers'                             => 'All transfers',
    'title_transfers_between'                   => 'All transfers between :start and :end',
    'all_transfer'                              => 'All transfers',
    'all_journals_for_tag'                      => 'All transactions for tag ":tag"',
    'title_transfer_between'                    => 'All transfers between :start and :end',
    'all_journals_for_category'                 => 'All transactions for category :name',
    'all_journals_for_budget'                   => 'All transactions for budget :name',
    'chart_all_journals_for_budget'             => 'Chart of all transactions for budget :name',
    'journals_in_period_for_category'           => 'All transactions for category :name between :start and :end',
    'journals_in_period_for_tag'                => 'All transactions for tag :tag between :start and :end',
    'not_available_demo_user'                   => 'The feature you try to access is not available to demo users.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Source asset account "@source_name" only accepts transactions in @source_currency. Destination asset account "@dest_name" only accepts transactions in @dest_currency. You must provide the transferred amount correctly in both currencies.',
    'transaction_data'                          => 'Transaction data',
    'invalid_server_configuration'              => 'Invalid server configuration',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'Quickswitch',
    'sign_in_to_start'                          => 'Sign in to start your session',
    'sign_in'                                   => 'Sign in',
    'register_new_account'                      => 'Register a new account',
    'forgot_my_password'                        => 'I forgot my password',
    'problems_with_input'                       => 'There were some problems with your input.',
    'reset_password'                            => 'Reset your password',
    'button_reset_password'                     => 'Reset password',
    'reset_button'                              => 'Reset',
    'want_to_login'                             => 'I want to login',
    'login_page_title'                          => 'Login to Firefly III',
    'register_page_title'                       => 'Register at Firefly III',
    'forgot_pw_page_title'                      => 'Forgot your password for Firefly III',
    'reset_pw_page_title'                       => 'Reset your password for Firefly III',
    'cannot_reset_demo_user'                    => 'You cannot reset the password of the demo user.',
    'no_att_demo_user'                          => 'The demo user can\'t upload attachments.',
    'button_register'                           => 'Register',
    'authorization'                             => 'Authorization',
    'active_bills_only'                         => 'active subscription only',
    'active_bills_only_total'                   => 'all active subscriptions',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Expected daily costs',
    'per_period_sum_1W'                         => 'Expected weekly costs',
    'per_period_sum_1M'                         => 'Expected monthly costs',
    'per_period_sum_3M'                         => 'Expected quarterly costs',
    'per_period_sum_6M'                         => 'Expected half-yearly costs',
    'per_period_sum_1Y'                         => 'Expected yearly costs',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'expected total',
    'reconciliation_account_name'               => ':name reconciliation (:currency)',
    'saved'                                     => 'Saved',
    'advanced_options'                          => 'Advanced options',
    'advanced_options_explain'                  => 'Some pages in Firefly III have advanced options hidden behind this button. This page doesn\'t have anything fancy here, but do check out the others!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'disabled',
    'no_webhook_messages'                       => 'There are no webhook messages',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'After transaction creation',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'After transaction update',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'After transaction delete',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Transaction details',
    'webhook_response_ACCOUNTS'                 => 'Account details',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspect',
    'create_new_webhook'                        => 'Create new webhook',
    'webhooks_create_breadcrumb'                => 'Create new webhook',
    'webhook_trigger_form_help'                 => 'Indicate on what event the webhook will trigger',
    'webhook_response_form_help'                => 'Indicate what the webhook must submit to the URL.',
    'webhook_delivery_form_help'                => 'Which format the webhook must deliver data in.',
    'webhook_active_form_help'                  => 'The webhook must be active or it won\'t be called.',
    'stored_new_webhook'                        => 'Stored new webhook ":title"',
    'delete_webhook'                            => 'Delete webhook',
    'deleted_webhook'                           => 'Deleted webhook ":title"',
    'edit_webhook'                              => 'Edit webhook ":title"',
    'updated_webhook'                           => 'Updated webhook ":title"',
    'edit_webhook_js'                           => 'Edit webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'The webhook was triggered on the indicated transaction. Please wait for results to appear.',
    'webhook_messages'                          => 'Webhook message',
    'view_message'                              => 'View message',
    'view_attempts'                             => 'View failed attempts',
    'message_content_title'                     => 'Webhook message content',
    'message_content_help'                      => 'This is the content of the message that was sent (or tried) using this webhook.',
    'attempt_content_title'                     => 'Webhook attempts',
    'attempt_content_help'                      => 'These are all the unsuccessful attempts of this webhook message to submit to the configured URL. After some time, Firefly III will stop trying.',
    'no_attempts'                               => 'There are no unsuccessful attempts. That\'s a good thing!',
    'webhook_attempt_at'                        => 'Attempt at {moment}',
    'logs'                                      => 'Logs',
    'response'                                  => 'Response',
    'visit_webhook_url'                         => 'Visit webhook URL',
    'reset_webhook_secret'                      => 'Reset webhook secret',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> has been stored.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") has been updated.',

    // API access
    'authorization_request'                     => 'Firefly III v:version Authorization Request',
    'authorization_request_intro'               => 'Application "<strong>:client</strong>" is requesting permission to access your financial administration. Would you like to authorize <strong>:client</strong> to access these records?',
    'authorization_request_site'                => 'You will be redirected to <code>:url</code> which will then be able to access your Firefly III data.',
    'authorization_request_invalid'             => 'This access request is invalid. Please never follow this link again.',
    'scopes_will_be_able'                       => 'This application will be able to:',
    'button_authorize'                          => 'Authorize',
    'none_in_select_list'                       => '(none)',
    'no_piggy_bank'                             => '(no piggy bank)',
    'name_in_currency'                          => ':name in :currency',
    'paid_in_currency'                          => 'Paid in :currency',
    'unpaid_in_currency'                        => 'Unpaid in :currency',
    'is_alpha_warning'                          => 'You are running an ALPHA version. Be wary of bugs and issues.',
    'is_beta_warning'                           => 'You are running an BETA version. Be wary of bugs and issues.',
    'all_destination_accounts'                  => 'Destination accounts',
    'all_source_accounts'                       => 'Source accounts',
    'back_to_index'                             => 'Back to the index',
    'cant_logout_guard'                         => 'Firefly III can\'t log you out.',
    'internal_reference'                        => 'Internal reference',

    // check for updates:
    'update_check_title'                        => 'Check for updates',
    'admin_update_check_title'                  => 'Automatically check for update',
    'admin_update_check_explain'                => 'Firefly III can check for updates automatically. When you enable this setting, it will contact the Firefly III update server to see if a new version of Firefly III is available. When it is, you will get a notification. You can test this notification using the button on the right. Please indicate below if you want Firefly III to check for updates.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Ask me later',
    'updates_do_not_check'                      => 'Do not check for updates',
    'updates_enable_check'                      => 'Enable the check for updates',
    'admin_update_check_now_title'              => 'Check for updates now',
    'admin_update_check_now_explain'            => 'If you press the button, Firefly III will see if your current version is the latest.',
    'check_for_updates_button'                  => 'Check now!',
    'update_new_version_alert'                  => 'A new version of Firefly III is available. You are running :your_version, the latest version is :new_version which was released on :date.',
    'update_version_beta'                       => 'This version is a BETA version. You may run into issues.',
    'update_version_alpha'                      => 'This version is a ALPHA version. You may run into issues.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'You are running :version, which is the latest available release.',
    'update_newer_version_alert'                => 'You are running :your_version, which is newer than the latest release, :new_version.',
    'update_check_error'                        => 'An error occurred while checking for updates: :error',
    'unknown_error'                             => 'Unknown error. Sorry about that.',
    'disabled_but_check'                        => 'You disabled update checking. So don\'t forget to check for updates yourself every now and then. Thank you!',
    'admin_update_channel_title'                => 'Update channel',
    'admin_update_channel_explain'              => 'Firefly III has three update "channels" which determine how ahead of the curve you are in terms of features, enhancements and bugs. Use the "beta" channel if you\'re adventurous and the "alpha" when you like to live life dangerously.',
    'update_channel_stable'                     => 'Stable. Everything should work as expected.',
    'update_channel_beta'                       => 'Beta. New features but things may be broken.',
    'update_channel_alpha'                      => 'Alpha. We throw stuff in, and use whatever sticks.',

    // search
    'search'                                    => 'Search',
    'search_query'                              => 'Query',
    'search_found_transactions'                 => 'Firefly III found :count transaction in :time seconds.|Firefly III found :count transactions in :time seconds.',
    'search_found_more_transactions'            => 'Firefly III found more than :count transactions in :time seconds.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'These search parameters are not valid and have been ignored.',

    // old


    'search_modifier_date_on'                             => 'Transaction date is ":value"',
    'search_modifier_not_date_on'                         => 'Transaction date is not ":value"',
    'search_modifier_reconciled'                          => 'Transaction is reconciled',
    'search_modifier_not_reconciled'                      => 'Transaction is not reconciled',
    'search_modifier_id'                                  => 'Transaction ID is ":value"',
    'search_modifier_not_id'                              => 'Transaction ID is not ":value"',
    'search_modifier_date_before'                         => 'Transaction date is before or on ":value"',
    'search_modifier_date_after'                          => 'Transaction date is after or on ":value"',
    'search_modifier_external_id_is'                      => 'External ID is ":value"',
    'search_modifier_not_external_id_is'                  => 'External ID is not ":value"',
    'search_modifier_no_external_url'                     => 'The transaction has no external URL',
    'search_modifier_no_external_id'                      => 'The transaction has no external ID',
    'search_modifier_not_any_external_url'                => 'The transaction has no external URL',
    'search_modifier_not_any_external_id'                 => 'The transaction has no external ID',
    'search_modifier_any_external_url'                    => 'The transaction must have a (any) external URL',
    'search_modifier_any_external_id'                     => 'The transaction must have a (any) external ID',
    'search_modifier_not_no_external_url'                 => 'The transaction must have a (any) external URL',
    'search_modifier_not_no_external_id'                  => 'The transaction must have a (any) external ID',
    'search_modifier_internal_reference_is'               => 'Internal reference is ":value"',
    'search_modifier_not_internal_reference_is'           => 'Internal reference is not ":value"',
    'search_modifier_description_starts'                  => 'Description starts with ":value"',
    'search_modifier_not_description_starts'              => 'Description does not start with ":value"',
    'search_modifier_description_ends'                    => 'Description ends on ":value"',
    'search_modifier_not_description_ends'                => 'Description does not end on ":value"',
    'search_modifier_description_contains'                => 'Description contains ":value"',
    'search_modifier_not_description_contains'            => 'Description does not contain ":value"',
    'search_modifier_description_is'                      => 'Description is exactly ":value"',
    'search_modifier_not_description_is'                  => 'Description is exactly not ":value"',
    'search_modifier_currency_is'                         => 'Transaction (foreign) currency is ":value"',
    'search_modifier_not_currency_is'                     => 'Transaction (foreign) currency is not ":value"',
    'search_modifier_foreign_currency_is'                 => 'Transaction foreign currency is ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Transaction foreign currency is not ":value"',
    'search_modifier_has_attachments'                     => 'The transaction must have an attachment',
    'search_modifier_has_no_category'                     => 'The transaction must have no category',
    'search_modifier_not_has_no_category'                 => 'The transaction must have a (any) category',
    'search_modifier_not_has_any_category'                => 'The transaction must have no category',
    'search_modifier_has_any_category'                    => 'The transaction must have a (any) category',
    'search_modifier_has_no_budget'                       => 'The transaction must have no budget',
    'search_modifier_not_has_any_budget'                  => 'The transaction must have no budget',
    'search_modifier_has_any_budget'                      => 'The transaction must have a (any) budget',
    'search_modifier_not_has_no_budget'                   => 'The transaction must have a (any) budget',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'The transaction must have no tags',
    'search_modifier_not_has_any_tag'                     => 'The transaction must have no tags',
    'search_modifier_not_has_no_tag'                      => 'The transaction must have a (any) tag',
    'search_modifier_has_any_tag'                         => 'The transaction must have a (any) tag',
    'search_modifier_notes_contains'                      => 'The transaction notes contain ":value"',
    'search_modifier_not_notes_contains'                  => 'The transaction notes do not contain ":value"',
    'search_modifier_notes_starts'                        => 'The transaction notes start with ":value"',
    'search_modifier_not_notes_starts'                    => 'The transaction notes do not start with ":value"',
    'search_modifier_notes_ends'                          => 'The transaction notes end with ":value"',
    'search_modifier_not_notes_ends'                      => 'The transaction notes do not end with ":value"',
    'search_modifier_notes_is'                            => 'The transaction notes are exactly ":value"',
    'search_modifier_not_notes_is'                        => 'The transaction notes are exactly not ":value"',
    'search_modifier_no_notes'                            => 'The transaction has no notes',
    'search_modifier_not_no_notes'                        => 'The transaction must have notes',
    'search_modifier_any_notes'                           => 'The transaction must have notes',
    'search_modifier_not_any_notes'                       => 'The transaction has no notes',
    'search_modifier_amount_is'                           => 'Amount is exactly :value',
    'search_modifier_not_amount_is'                       => 'Amount is not :value',
    'search_modifier_amount_less'                         => 'Amount is less than or equal to :value',
    'search_modifier_not_amount_more'                     => 'Amount is less than or equal to :value',
    'search_modifier_amount_more'                         => 'Amount is more than or equal to :value',
    'search_modifier_not_amount_less'                     => 'Amount is more than or equal to :value',
    'search_modifier_source_account_is'                   => 'Source account name is exactly ":value"',
    'search_modifier_not_source_account_is'               => 'Source account name is not ":value"',
    'search_modifier_source_account_contains'             => 'Source account name contains ":value"',
    'search_modifier_not_source_account_contains'         => 'Source account name does not contain ":value"',
    'search_modifier_source_account_starts'               => 'Source account name starts with ":value"',
    'search_modifier_not_source_account_starts'           => 'Source account name does not start with ":value"',
    'search_modifier_source_account_ends'                 => 'Source account name ends with ":value"',
    'search_modifier_not_source_account_ends'             => 'Source account name does not end with ":value"',
    'search_modifier_source_account_id'                   => 'Source account ID is :value',
    'search_modifier_not_source_account_id'               => 'Source account ID is not :value',
    'search_modifier_source_account_nr_is'                => 'Source account number (IBAN) is ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Source account number (IBAN) is not ":value"',
    'search_modifier_source_account_nr_contains'          => 'Source account number (IBAN) contains ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Source account number (IBAN) does not contain ":value"',
    'search_modifier_source_account_nr_starts'            => 'Source account number (IBAN) starts with ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Source account number (IBAN) does not start with ":value"',
    'search_modifier_source_account_nr_ends'              => 'Source account number (IBAN) ends on ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Source account number (IBAN) does not end on ":value"',
    'search_modifier_destination_account_is'              => 'Destination account name is exactly ":value"',
    'search_modifier_not_destination_account_is'          => 'Destination account name is not ":value"',
    'search_modifier_destination_account_contains'        => 'Destination account name contains ":value"',
    'search_modifier_not_destination_account_contains'    => 'Destination account name does not contain ":value"',
    'search_modifier_destination_account_starts'          => 'Destination account name starts with ":value"',
    'search_modifier_not_destination_account_starts'      => 'Destination account name does not start with ":value"',
    'search_modifier_destination_account_ends'            => 'Destination account name ends on ":value"',
    'search_modifier_not_destination_account_ends'        => 'Destination account name does not end on ":value"',
    'search_modifier_destination_account_id'              => 'Destination account ID is :value',
    'search_modifier_not_destination_account_id'          => 'Destination account ID is not :value',
    'search_modifier_destination_is_cash'                 => 'Destination account is the "(cash)" account',
    'search_modifier_not_destination_is_cash'             => 'Destination account is not the "(cash)" account',
    'search_modifier_source_is_cash'                      => 'Source account is the "(cash)" account',
    'search_modifier_not_source_is_cash'                  => 'Source account is not the "(cash)" account',
    'search_modifier_destination_account_nr_is'           => 'Destination account number (IBAN) is ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Destination account number (IBAN) is ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Destination account number (IBAN) contains ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Destination account number (IBAN) does not contain ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Destination account number (IBAN) starts with ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Destination account number (IBAN) does not start with ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Destination account number (IBAN) ends with ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Destination account number (IBAN) does not end with ":value"',
    'search_modifier_account_id'                          => 'Source or destination account ID\'s is/are: :value',
    'search_modifier_not_account_id'                      => 'Source or destination account ID\'s is/are not: :value',
    'search_modifier_category_is'                         => 'Category is ":value"',
    'search_modifier_not_category_is'                     => 'Category is not ":value"',
    'search_modifier_budget_is'                           => 'Budget is ":value"',
    'search_modifier_not_budget_is'                       => 'Budget is not ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Transaction type is ":value"',
    'search_modifier_not_transaction_type'                => 'Transaction type is not ":value"',
    'search_modifier_tag_is'                              => 'Tag is ":value"',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'No tag is ":value"',
    'search_modifier_date_on_year'                        => 'Transaction is in year ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaction is not in year ":value"',
    'search_modifier_date_on_month'                       => 'Transaction is in month ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaction is not in month ":value"',
    'search_modifier_date_on_day'                         => 'Transaction is on day of month ":value"',
    'search_modifier_not_date_on_day'                     => 'Transaction is not on day of month ":value"',
    'search_modifier_date_before_year'                    => 'Transaction is before or in year ":value"',
    'search_modifier_date_before_month'                   => 'Transaction is before or in month ":value"',
    'search_modifier_date_before_day'                     => 'Transaction is before or on day of month ":value"',
    'search_modifier_date_after_year'                     => 'Transaction is in or after year ":value"',
    'search_modifier_date_after_month'                    => 'Transaction is in or after month ":value"',
    'search_modifier_date_after_day'                      => 'Transaction is after or on day of month ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'No tag is ":value"',
    'search_modifier_not_tag_is_not'                      => 'Tag is ":value"',
    'search_modifier_account_is'                          => 'Either account is ":value"',
    'search_modifier_not_account_is'                      => 'Neither account is ":value"',
    'search_modifier_account_contains'                    => 'Either account contains ":value"',
    'search_modifier_not_account_contains'                => 'Neither account contains ":value"',
    'search_modifier_account_ends'                        => 'Either account ends with ":value"',
    'search_modifier_not_account_ends'                    => 'Neither account ends with ":value"',
    'search_modifier_account_starts'                      => 'Either account starts with ":value"',
    'search_modifier_not_account_starts'                  => 'Neither account starts with ":value"',
    'search_modifier_account_nr_is'                       => 'Either account number / IBAN is ":value"',
    'search_modifier_not_account_nr_is'                   => 'Neither account number / IBAN is ":value"',
    'search_modifier_account_nr_contains'                 => 'Either account number / IBAN contains ":value"',
    'search_modifier_not_account_nr_contains'             => 'Neither account number / IBAN contains ":value"',
    'search_modifier_account_nr_ends'                     => 'Either account number / IBAN ends with ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Neither account number / IBAN ends with ":value"',
    'search_modifier_account_nr_starts'                   => 'Either account number / IBAN starts with ":value"',
    'search_modifier_not_account_nr_starts'               => 'Neither account number / IBAN starts with ":value"',
    'search_modifier_category_contains'                   => 'Category contains ":value"',
    'search_modifier_not_category_contains'               => 'Category does not contain ":value"',
    'search_modifier_category_ends'                       => 'Category ends on ":value"',
    'search_modifier_not_category_ends'                   => 'Category does not end on ":value"',
    'search_modifier_category_starts'                     => 'Category starts with ":value"',
    'search_modifier_not_category_starts'                 => 'Category does not start with ":value"',
    'search_modifier_budget_contains'                     => 'Budget contains ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget does not contain ":value"',
    'search_modifier_budget_ends'                         => 'Budget ends with ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget does not end on ":value"',
    'search_modifier_budget_starts'                       => 'Budget starts with ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget does not start with ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'External ID contains ":value"',
    'search_modifier_not_external_id_contains'            => 'External ID does not contain ":value"',
    'search_modifier_external_id_ends'                    => 'External ID ends with ":value"',
    'search_modifier_not_external_id_ends'                => 'External ID does not end with ":value"',
    'search_modifier_external_id_starts'                  => 'External ID starts with ":value"',
    'search_modifier_not_external_id_starts'              => 'External ID does not start with ":value"',
    'search_modifier_internal_reference_contains'         => 'Internal reference contains ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Internal reference does not contain ":value"',
    'search_modifier_internal_reference_ends'             => 'Internal reference ends with ":value"',
    'search_modifier_internal_reference_starts'           => 'Internal reference starts with ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Internal reference does not end with ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Internal reference does not start with ":value"',
    'search_modifier_external_url_is'                     => 'External URL is ":value"',
    'search_modifier_not_external_url_is'                 => 'External URL is not ":value"',
    'search_modifier_external_url_contains'               => 'External URL contains ":value"',
    'search_modifier_not_external_url_contains'           => 'External URL does not contain ":value"',
    'search_modifier_external_url_ends'                   => 'External URL ends with ":value"',
    'search_modifier_not_external_url_ends'               => 'External URL does not end with ":value"',
    'search_modifier_external_url_starts'                 => 'External URL starts with ":value"',
    'search_modifier_not_external_url_starts'             => 'External URL does not start with ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaction has no attachments',
    'search_modifier_not_has_no_attachments'              => 'Transaction has attachments',
    'search_modifier_not_has_attachments'                 => 'Transaction has no attachments',
    'search_modifier_account_is_cash'                     => 'Either account is the "(cash)" account.',
    'search_modifier_not_account_is_cash'                 => 'Neither account is the "(cash)" account.',
    'search_modifier_journal_id'                          => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                      => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                       => 'The recurring transaction ID is ":value"',
    'search_modifier_not_recurrence_id'                   => 'The recurring transaction ID is not ":value"',
    'search_modifier_foreign_amount_is'                   => 'The foreign amount is ":value"',
    'search_modifier_not_foreign_amount_is'               => 'The foreign amount is not ":value"',
    'search_modifier_foreign_amount_less'                 => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_more'             => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_less'             => 'The foreign amount is more than ":value"',
    'search_modifier_foreign_amount_more'                 => 'The foreign amount is more than ":value"',
    'search_modifier_exists'                              => 'Transaction exists (any transaction)',
    'search_modifier_not_exists'                          => 'Transaction does not exist (no transaction)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaction interest date is ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaction interest date is not ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaction interest date is in year ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaction interest date is in month ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaction interest date is on day of month ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaction interest date is before or in year ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                   => 'Transaction book date is in year ":value"',
    'search_modifier_book_date_on_month'                  => 'Transaction book date is in month ":value"',
    'search_modifier_book_date_on_day'                    => 'Transaction book date is on day of month ":value"',
    'search_modifier_not_book_date_on_year'               => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'              => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'               => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'              => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Transaction due date is in year ":value"',
    'search_modifier_due_date_on_month'                   => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Transaction due date is after or in year ":value"',
    'search_modifier_due_date_after_month'                => 'Transaction due date is after or in month ":value"',
    'search_modifier_due_date_after_day'                  => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                => 'Transaction payment date is in year ":value"',
    'search_modifier_payment_date_on_month'               => 'Transaction payment date is in month ":value"',
    'search_modifier_payment_date_on_day'                 => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'             => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaction invoice date is in month ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaction invoice date is on day of month ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaction invoice date is before or in year ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaction invoice date is before or in month ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaction invoice date is before or on day of month ":value"',
    'search_modifier_invoice_date_after_year'             => 'Transaction invoice date is after or in year ":value"',
    'search_modifier_invoice_date_after_month'            => 'Transaction invoice date is after or in month ":value"',
    'search_modifier_invoice_date_after_day'              => 'Transaction invoice date is after or on day of month ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaction was last updated in year ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaction was last updated in month ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaction was last updated on day of month ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaction was last updated in or before year ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaction was last updated in or before month ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaction was last updated on or before day of month ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaction was last updated in or after year ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                  => 'Transaction was created in year ":value"',
    'search_modifier_created_at_on_month'                 => 'Transaction was created in month ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'             => 'Transaction was created in or before month ":value"',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'              => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                    => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                       => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                    => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'            => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'      => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'        => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'          => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'          => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'     => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'       => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'         => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'        => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => 'Update rule ":rule" from search query',
    'create_rule_from_query'                        => 'Create new rule from search query',
    'rule_from_search_words'                        => 'The rule engine has a hard time handling ":string". The suggested rule that fits your search query may give different results. Please verify the rule triggers carefully.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'An error occurred while searching. Please check the log files for more information.',
    'search_box'                                          => 'Search',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Error while searching',
    'search_searching'                                    => 'Searching ...',
    'search_results'                                      => 'Search results',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'yearly',
    'repeat_freq_half-year'                               => 'every half-year',
    'repeat_freq_quarterly'                               => 'quarterly',
    'repeat_freq_monthly'                                 => 'monthly',
    'repeat_freq_weekly'                                  => 'weekly',
    'repeat_freq_daily'                                   => 'daily',
    'daily'                                               => 'daily',
    'weekly'                                              => 'weekly',
    'quarterly'                                           => 'quarterly',
    'half-year'                                           => 'every half year',
    'yearly'                                              => 'yearly',

    // rules
    'is_not_rule_trigger'                                 => 'Not',
    'cannot_fire_inactive_rules'                          => 'You cannot execute inactive rules.',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'Rules',
    'rule_name'                                           => 'Name of rule',
    'rule_triggers'                                       => 'Rule triggers when',
    'rule_actions'                                        => 'Rule will',
    'new_rule'                                            => 'New rule',
    'new_rule_group'                                      => 'New rule group',
    'rule_priority_up'                                    => 'Give rule more priority',
    'rule_priority_down'                                  => 'Give rule less priority',
    'make_new_rule_group'                                 => 'Make new rule group',
    'store_new_rule_group'                                => 'Store new rule group',
    'created_new_rule_group'                              => 'New rule group ":title" stored!',
    'updated_rule_group'                                  => 'Successfully updated rule group ":title".',
    'edit_rule_group'                                     => 'Edit rule group ":title"',
    'duplicate_rule'                                      => 'Duplicate rule ":title"',
    'rule_copy_of'                                        => 'Copy of ":title"',
    'duplicated_rule'                                     => 'Duplicated rule ":title" into ":newTitle"',
    'delete_rule_group'                                   => 'Delete rule group ":title"',
    'deleted_rule_group'                                  => 'Deleted rule group ":title"',
    'update_rule_group'                                   => 'Update rule group',
    'no_rules_in_group'                                   => 'There are no rules in this group',
    'move_rule_group_up'                                  => 'Move rule group up',
    'move_rule_group_down'                                => 'Move rule group down',
    'save_rules_by_moving'                                => 'Save this rule by moving it to another rule group:|Save these rules by moving them to another rule group:',
    'make_new_rule'                                       => 'Make a new rule in rule group ":title"',
    'make_new_rule_no_group'                              => 'Make a new rule',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Create a rule based on one of your transactions. Complement or submit the form below.',
    'rule_is_strict'                                      => 'strict rule',
    'rule_is_not_strict'                                  => 'non-strict rule',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'In strict rules ALL triggers must fire for the action(s) to be executed. In non-strict rules, ANY trigger is enough for the action(s) to be executed.',
    'rule_help_active'                                    => 'Inactive rules will never fire.',
    'stored_new_rule'                                     => 'Stored new rule with title ":title"',
    'deleted_rule'                                        => 'Deleted rule with title ":title"',
    'store_new_rule'                                      => 'Store new rule',
    'updated_rule'                                        => 'Updated rule with title ":title"',
    'default_rule_group_name'                             => 'Default rules',
    'default_rule_group_description'                      => 'All your rules not in a particular group.',
    'trigger'                                             => 'Trigger',
    'trigger_value'                                       => 'Trigger on value',
    'stop_processing_other_triggers'                      => 'Stop processing other triggers',
    'add_rule_trigger'                                    => 'Add new trigger',
    'action'                                              => 'Action',
    'action_value'                                        => 'Action value',
    'stop_executing_other_actions'                        => 'Stop executing other actions',
    'add_rule_action'                                     => 'Add new action',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Delete rule ":title"',
    'update_rule'                                         => 'Update rule',
    'test_rule_triggers'                                  => 'See matching transactions',
    'warning_no_matching_transactions'                    => 'No matching transactions found.',
    'warning_no_valid_triggers'                           => 'No valid triggers provided.',
    'apply_rule_selection'                                => 'Apply rule ":title" to a selection of your transactions',
    'apply_rule_selection_intro'                          => 'Rules like ":title" are normally only applied to new or updated transactions, but you can tell Firefly III to run it on a selection of your existing transactions. This can be useful when you have updated a rule and you need the changes to be applied to all of your other transactions.',
    'include_transactions_from_accounts'                  => 'Include transactions from these accounts',
    'include'                                             => 'Include?',
    'applied_rule_selection'                              => '{0} No transactions in your selection were changed by rule ":title".|[1] One transaction in your selection was changed by rule ":title".|[2,*] :count transactions in your selection were changed by rule ":title".',
    'execute'                                             => 'Execute',
    'apply_rule_group_selection'                          => 'Apply rule group ":title" to a selection of your transactions',
    'apply_rule_group_selection_intro'                    => 'Rule groups like ":title" are normally only applied to new or updated transactions, but you can tell Firefly III to run all the rules in this group on a selection of your existing transactions. This can be useful when you have updated a group of rules and you need the changes to be applied to all of your other transactions.',
    'applied_rule_group_selection'                        => 'Rule group ":title" has been applied to your selection.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'When a transaction is created',
    'rule_trigger_update_journal'                         => 'When a transaction is updated',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'User action is ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Source account name starts with..',
    'rule_trigger_source_account_starts'                  => 'Source account name starts with ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Source account name ends with..',
    'rule_trigger_source_account_ends'                    => 'Source account name ends with ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Source account name is..',
    'rule_trigger_source_account_is'                      => 'Source account name is ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Source account name contains..',
    'rule_trigger_source_account_contains'                => 'Source account name contains ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Either account ID is exactly..',
    'rule_trigger_account_id'                             => 'Either account ID is exactly :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Source account ID is exactly..',
    'rule_trigger_source_account_id'                      => 'Source account ID is exactly :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Destination account ID is exactly..',
    'rule_trigger_destination_account_id'                 => 'Destination account ID is exactly :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Either account is cash',
    'rule_trigger_account_is_cash'                        => 'Either account is cash',
    'rule_trigger_source_is_cash_choice'                  => 'Source account is (cash) account',
    'rule_trigger_source_is_cash'                         => 'Source account is (cash) account',
    'rule_trigger_destination_is_cash_choice'             => 'Destination account is (cash) account',
    'rule_trigger_destination_is_cash'                    => 'Destination account is (cash) account',
    'rule_trigger_source_account_nr_starts_choice'        => 'Source account number / IBAN starts with..',
    'rule_trigger_source_account_nr_starts'               => 'Source account number / IBAN starts with ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Source account number / IBAN ends with..',
    'rule_trigger_source_account_nr_ends'                 => 'Source account number / IBAN ends with ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Source account number / IBAN is..',
    'rule_trigger_source_account_nr_is'                   => 'Source account number / IBAN is ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Source account number / IBAN contains..',
    'rule_trigger_source_account_nr_contains'             => 'Source account number / IBAN contains ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Destination account name starts with..',
    'rule_trigger_destination_account_starts'             => 'Destination account name starts with ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Destination account name ends with..',
    'rule_trigger_destination_account_ends'               => 'Destination account name ends with ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Destination account name is..',
    'rule_trigger_destination_account_is'                 => 'Destination account name is ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Destination account name contains..',
    'rule_trigger_destination_account_contains'           => 'Destination account name contains ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Destination account number / IBAN starts with..',
    'rule_trigger_destination_account_nr_starts'          => 'Destination account number / IBAN starts with ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Destination account number / IBAN ends with..',
    'rule_trigger_destination_account_nr_ends'            => 'Destination account number / IBAN ends with ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Destination account number / IBAN is..',
    'rule_trigger_destination_account_nr_is'              => 'Destination account number / IBAN is ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Destination account number / IBAN contains..',
    'rule_trigger_destination_account_nr_contains'        => 'Destination account number / IBAN contains ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transaction is of type..',
    'rule_trigger_transaction_type'                       => 'Transaction is of type ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Category is..',
    'rule_trigger_category_is'                            => 'Category is ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Amount is less than or equal to ..',
    'rule_trigger_amount_less'                            => 'Amount is less than or equal to :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Amount is..',
    'rule_trigger_amount_is'                              => 'Amount is :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Amount is more than or equal to..',
    'rule_trigger_amount_more'                            => 'Amount is more than or equal to :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Description starts with..',
    'rule_trigger_description_starts'                     => 'Description starts with ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Description ends with..',
    'rule_trigger_description_ends'                       => 'Description ends with ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Description contains..',
    'rule_trigger_description_contains'                   => 'Description contains ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Description is..',
    'rule_trigger_description_is'                         => 'Description is ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Transaction date is..',
    'rule_trigger_date_on'                                => 'Transaction date is ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Transaction date is before..',
    'rule_trigger_date_before'                            => 'Transaction date is before ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Transaction date is after..',
    'rule_trigger_date_after'                             => 'Transaction date is after ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transaction was made on..',
    'rule_trigger_created_at_on'                          => 'Transaction was made on ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaction was last edited on..',
    'rule_trigger_updated_at_on'                          => 'Transaction was last edited on ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Budget is..',
    'rule_trigger_budget_is'                              => 'Budget is ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Any tag is..',
    'rule_trigger_tag_is'                                 => 'Any tag is ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Transaction currency is..',
    'rule_trigger_currency_is'                            => 'Transaction currency is ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Transaction foreign currency is..',
    'rule_trigger_foreign_currency_is'                    => 'Transaction foreign currency is ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Has no category',
    'rule_trigger_has_no_category'                        => 'Transaction has no category',
    'rule_trigger_has_any_category_choice'                => 'Has a (any) category',
    'rule_trigger_has_any_category'                       => 'Transaction has a (any) category',
    'rule_trigger_has_no_budget_choice'                   => 'Has no budget',
    'rule_trigger_has_no_budget'                          => 'Transaction has no budget',
    'rule_trigger_has_any_budget_choice'                  => 'Has a (any) budget',
    'rule_trigger_has_any_budget'                         => 'Transaction has a (any) budget',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Has no tag(s)',
    'rule_trigger_has_no_tag'                             => 'Transaction has no tag(s)',
    'rule_trigger_has_any_tag_choice'                     => 'Has one or more (any) tags',
    'rule_trigger_has_any_tag'                            => 'Transaction has one or more (any) tags',
    'rule_trigger_any_notes_choice'                       => 'Has (any) notes',
    'rule_trigger_any_notes'                              => 'Transaction has (any) notes',
    'rule_trigger_no_notes_choice'                        => 'Has no notes',
    'rule_trigger_no_notes'                               => 'Transaction has no notes',
    'rule_trigger_notes_is_choice'                        => 'Notes are..',
    'rule_trigger_notes_is'                               => 'Notes are ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notes contain..',
    'rule_trigger_notes_contains'                         => 'Notes contain ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notes start with..',
    'rule_trigger_notes_starts'                           => 'Notes start with ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notes end with..',
    'rule_trigger_notes_ends'                             => 'Notes end with ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'External ID is..',
    'rule_trigger_external_id_is'                         => 'External ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                  => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Transaction journal ID is..',
    'rule_trigger_journal_id'                             => 'Transaction journal ID is ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Transaction has no external URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaction has no external ID',
    'rule_trigger_id_choice'                              => 'Transaction ID is..',
    'rule_trigger_id'                                     => 'Transaction ID is ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'User action is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'No tag is..',
    'rule_trigger_tag_is_not'                             => 'No tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Either account is exactly..',
    'rule_trigger_account_is'                             => 'Either account is exactly ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Either account contains..',
    'rule_trigger_account_contains'                       => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Either account ends with..',
    'rule_trigger_account_ends'                           => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Either account starts with..',
    'rule_trigger_account_starts'                         => 'Either account starts with ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                    => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                        => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                      => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Category contains..',
    'rule_trigger_category_contains'                      => 'Category contains ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Category ends with..',
    'rule_trigger_category_ends'                          => 'Category ends with ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Category starts with..',
    'rule_trigger_category_starts'                        => 'Category starts with ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget contains..',
    'rule_trigger_budget_contains'                        => 'Budget contains ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget ends with..',
    'rule_trigger_budget_ends'                            => 'Budget ends with ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget starts with..',
    'rule_trigger_budget_starts'                          => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'External ID contains..',
    'rule_trigger_external_id_contains'                   => 'External ID contains ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'External ID ends with..',
    'rule_trigger_external_id_ends'                       => 'External ID ends with ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'External ID starts with..',
    'rule_trigger_external_id_starts'                     => 'External ID starts with ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'            => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'              => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'External URL is..',
    'rule_trigger_external_url_is'                        => 'External URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'External URL contains..',
    'rule_trigger_external_url_contains'                  => 'External URL contains ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'External URL ends with..',
    'rule_trigger_external_url_ends'                      => 'External URL ends with ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'External URL starts with..',
    'rule_trigger_external_url_starts'                    => 'External URL starts with ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Has no attachments',
    'rule_trigger_has_no_attachments'                     => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                   => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                          => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Interest date is on..',
    'rule_trigger_interest_date_on'                       => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Interest date is before..',
    'rule_trigger_interest_date_before'                   => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Interest date is after..',
    'rule_trigger_interest_date_after'                    => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Book date is before..',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Process date is on..',
    'rule_trigger_process_date_on'                        => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Process date is before..',
    'rule_trigger_process_date_before'                    => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Process date is after..',
    'rule_trigger_process_date_after'                     => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Due date is on..',
    'rule_trigger_due_date_on'                            => 'Due date is on ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Due date is before..',
    'rule_trigger_due_date_before'                        => 'Due date is before ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Due date is after..',
    'rule_trigger_due_date_after'                         => 'Due date is after ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Payment date is on..',
    'rule_trigger_payment_date_on'                        => 'Payment date is on ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Payment date is before..',
    'rule_trigger_payment_date_before'                    => 'Payment date is before ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Payment date is after..',
    'rule_trigger_payment_date_after'                     => 'Payment date is after ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                        => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                    => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                     => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaction was created before..',
    'rule_trigger_created_at_before'                      => 'Transaction was created before ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaction was created after..',
    'rule_trigger_created_at_after'                       => 'Transaction was created after ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaction was last updated before..',
    'rule_trigger_updated_at_before'                      => 'Transaction was last updated before ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaction was last updated after..',
    'rule_trigger_updated_at_after'                       => 'Transaction was last updated after ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                     => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'               => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                 => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                   => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Any attachment\'s notes are..',
    'rule_trigger_attachment_notes_are'                   => 'Any attachment\'s notes are ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Any attachment\'s notes contain..',
    'rule_trigger_attachment_notes_contains'              => 'Any attachment\'s notes contain ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Any attachment\'s notes start with..',
    'rule_trigger_attachment_notes_starts'                => 'Any attachment\'s notes start with ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Any attachment\'s notes end with..',
    'rule_trigger_attachment_notes_ends'                  => 'Any attachment\'s notes end with ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaction is reconciled',
    'rule_trigger_reconciled'                             => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                          => 'Any transaction matches(!)',
    'rule_trigger_exists'                                 => 'Any transaction matches',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Destination account ID is not ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag is not ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                             => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                    => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                   => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaction has no tags',
    'rule_trigger_not_any_notes'                          => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                   => 'Transaction has no external URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaction has a (any) attachment(s)',
    'rule_trigger_not_has_no_category'                    => 'Transaction has a (any) category',
    'rule_trigger_not_has_no_budget'                      => 'Transaction has a (any) budget',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaction has a (any) tag',
    'rule_trigger_not_no_notes'                           => 'Transaction has any notes',
    'rule_trigger_not_no_external_url'                    => 'Transaction has an external URL',
    'rule_trigger_not_source_is_cash'                     => 'Source account is not a cash account',
    'rule_trigger_not_destination_is_cash'                => 'Destination account is not a cash account',
    'rule_trigger_not_account_is_cash'                    => 'Neither account is a cash account',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'DELETE transaction(!)',
    'rule_action_delete_transaction'             => 'DELETE transaction(!)',
    'rule_action_set_category'                   => 'Set category to ":action_value"',
    'rule_action_clear_category'                 => 'Clear category',
    'rule_action_set_budget'                     => 'Set budget to ":action_value"',
    'rule_action_clear_budget'                   => 'Clear budget',
    'rule_action_add_tag'                        => 'Add tag ":action_value"',
    'rule_action_remove_tag'                     => 'Remove tag ":action_value"',
    'rule_action_remove_all_tags'                => 'Remove all tags',
    'rule_action_set_description'                => 'Set description to ":action_value"',
    'rule_action_append_description'             => 'Append description with ":action_value"',
    'rule_action_prepend_description'            => 'Prepend description with ":action_value"',
    'rule_action_set_category_choice'            => 'Set category to ..',
    'rule_action_clear_category_choice'          => 'Clear any category',
    'rule_action_set_budget_choice'              => 'Set budget to ..',
    'rule_action_clear_budget_choice'            => 'Clear any budget',
    'rule_action_add_tag_choice'                 => 'Add tag ..',
    'rule_action_remove_tag_choice'              => 'Remove tag ..',
    'rule_action_remove_all_tags_choice'         => 'Remove all tags',
    'rule_action_set_description_choice'         => 'Set description to ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Append description with ..',
    'rule_action_prepend_description_choice'     => 'Prepend description with ..',
    'rule_action_set_source_account_choice'      => 'Set source account to ..',
    'rule_action_set_source_account'             => 'Set source account to :action_value',
    'rule_action_set_destination_account_choice' => 'Set destination account to ..',
    'rule_action_set_destination_account'        => 'Set destination account to :action_value',
    'rule_action_append_notes_choice'            => 'Append notes with ..',
    'rule_action_append_notes'                   => 'Append notes with ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Prepend notes with ..',
    'rule_action_prepend_notes'                  => 'Prepend notes with ":action_value"',
    'rule_action_clear_notes_choice'             => 'Remove any notes',
    'rule_action_clear_notes'                    => 'Remove any notes',
    'rule_action_set_notes_choice'               => 'Set notes to ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                => 'Switch source and destination',
    'rule_action_set_notes'                      => 'Set notes to ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Convert the transaction to a deposit',
    'rule_action_convert_deposit'                => 'Convert the transaction to a deposit from ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Convert the transaction to a withdrawal',
    'rule_action_convert_withdrawal'             => 'Convert the transaction to a withdrawal to ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Convert the transaction to a transfer',
    'rule_action_convert_transfer'               => 'Convert the transaction to a transfer with ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'     => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'          => 'Append description to notes',
    'rule_action_append_notes_to_descr'          => 'Append notes to description',
    'rule_action_move_descr_to_notes'            => 'Replace notes with description',
    'rule_action_move_notes_to_descr'            => 'Replace description with notes',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Rule based on transaction ":description"',
    'new_rule_for_journal_description'          => 'This rule is based on transaction ":description". It will match transactions that are exactly the same.',

    // tags
    'store_new_tag'                             => 'Store new tag',
    'update_tag'                                => 'Update tag',
    'no_location_set'                           => 'No location set.',
    'meta_data'                                 => 'Meta data',
    'location'                                  => 'Location',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Without date',
    'result'                                    => 'Result',
    'sums_apply_to_range'                       => 'All sums apply to the selected range',
    'mapbox_api_key'                            => 'To use map, get an API key from <a href="https://www.mapbox.com/">Mapbox</a>. Open your <code>.env</code> file and enter this code after <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Right click or long press to set the object\'s location.',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Clear location',
    'delete_all_selected_tags'                  => 'Delete all selected tags',
    'select_tags_to_delete'                     => 'Don\'t forget to select some tags.',
    'deleted_x_tags'                            => 'Deleted :count tag.|Deleted :count tags.',
    'create_rule_from_transaction'              => 'Create rule based on transaction',
    'create_recurring_from_transaction'         => 'Create recurring transaction based on transaction',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Let your browser decide',
    'dark_mode_option_light'                    => 'Always light',
    'dark_mode_option_dark'                     => 'Always dark',
    'equal_to_language'                         => '(equal to language)',
    'dark_mode_preference'                      => 'Dark mode',
    'dark_mode_preference_help'                 => 'Tell Firefly III when to use dark mode.',
    'pref_home_screen_accounts'                 => 'Home screen accounts',
    'pref_home_screen_accounts_help'            => 'Which accounts should be displayed on the home page?',
    'pref_view_range'                           => 'View range',
    'pref_view_range_help'                      => 'Some charts are automatically grouped in periods. Your budgets will also be grouped in periods. What period would you prefer?',
    'pref_1D'                                   => 'One day',
    'pref_1W'                                   => 'One week',
    'pref_1M'                                   => 'One month',
    'pref_3M'                                   => 'Three months (quarter)',
    'pref_6M'                                   => 'Six months',
    'pref_1Y'                                   => 'One year',
    'pref_last365'                              => 'Last year',
    'pref_last90'                               => 'Last 90 days',
    'pref_last30'                               => 'Last 30 days',
    'pref_last7'                                => 'Last 7 days',
    'pref_YTD'                                  => 'Year to date',
    'pref_QTD'                                  => 'Quarter to date',
    'pref_MTD'                                  => 'Month to date',
    'pref_languages'                            => 'Languages',
    'pref_locale'                               => 'Locale settings',
    'pref_languages_help'                       => 'Firefly III supports several languages. Which one do you prefer?',
    'pref_locale_help'                          => 'Firefly III allows you to set other local settings, like how currencies, numbers and dates are formatted. Entries in this list may not be supported by your system. Firefly III doesn\'t have the correct date settings for every locale; contact me for improvements.',
    'pref_locale_no_demo'                       => 'This feature won\'t work for the demo user.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Fiscal year settings',
    'pref_custom_fiscal_year_label'             => 'Enabled',
    'pref_custom_fiscal_year_help'              => 'In countries that use a financial year other than January 1 to December 31, you can switch this on and specify start / end days of the fiscal year',
    'pref_fiscal_year_start_label'              => 'Fiscal year start date',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Don\'t forget to remove the account from your authentication app!',
    'pref_two_factor_auth_code'                 => 'Verify code',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Reset verification code',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'If you cannot scan the QR code, feel free to use the secret instead: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Store these backup codes for access in case you lose your device.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'This MFA code is not valid.',
    'pref_save_settings'                        => 'Save settings',
    'saved_preferences'                         => 'Preferences saved!',
    'preferences_general'                       => 'General',
    'preferences_frontpage'                     => 'Home screen',
    'preferences_security'                      => 'Security',
    'preferences_layout'                        => 'Layout',
    'preferences_notifications'                 => 'Notifications',
    'pref_home_show_deposits'                   => 'Show deposits on the home screen',
    'pref_home_show_deposits_info'              => 'The home screen already shows your expense accounts. Should it also show your revenue accounts?',
    'pref_home_do_show_deposits'                => 'Yes, show them',
    'successful_count'                          => 'of which :count successful',
    'list_page_size_title'                      => 'Page size',
    'list_page_size_help'                       => 'Any list of things (accounts, transactions, etc) shows at most this many per page.',
    'list_page_size_label'                      => 'Page size',
    'between_dates'                             => '(:start and :end)',
    'pref_optional_fields_transaction'          => 'Optional fields for transactions',
    'pref_optional_fields_transaction_help'     => 'By default not all fields are enabled when creating a new transaction (because of the clutter). Below, you can enable these fields if you think they could be useful for you. Of course, any field that is disabled, but already filled in, will be visible regardless of the setting.',
    'optional_tj_date_fields'                   => 'Date fields',
    'optional_tj_other_fields'                  => 'Other fields',
    'optional_tj_attachment_fields'             => 'Attachment fields',
    'pref_optional_tj_interest_date'            => 'Interest date',
    'pref_optional_tj_book_date'                => 'Book date',
    'pref_optional_tj_process_date'             => 'Processing date',
    'pref_optional_tj_due_date'                 => 'Due date',
    'pref_optional_tj_payment_date'             => 'Payment date',
    'pref_optional_tj_invoice_date'             => 'Invoice date',
    'pref_optional_tj_internal_reference'       => 'Internal reference',
    'pref_optional_tj_notes'                    => 'Notes',
    'pref_optional_tj_attachments'              => 'Attachments',
    'pref_optional_tj_external_url'             => 'External URL',
    'pref_optional_tj_location'                 => 'Location',
    'pref_optional_tj_links'                    => 'Transaction links',
    'optional_field_meta_dates'                 => 'Dates',
    'optional_field_meta_business'              => 'Business',
    'optional_field_attachments'                => 'Attachments',
    'optional_field_meta_data'                  => 'Optional meta data',
    'external_url'                              => 'External URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Alert when a new API access token is created',
    'pref_notification_transaction_creation'    => 'Alert when a transaction is created automatically',
    'pref_notification_user_login'              => 'Alert when you login from a new location',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Notifications',
    'pref_notifications_help'                   => 'Indicate if these are notifications you would like to get. Some notifications may contain sensitive financial information.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Financial administration',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Purge data from Firefly III',
    'purge_data_expl'                           => '"Purging" means "deleting that which is already deleted". In normal circumstances, Firefly III deletes nothing permanently. It just hides it. The button below deletes all of these previously "deleted" records FOREVER.',
    'delete_stuff_header'                       => 'Delete and purge data',
    'purge_all_data'                            => 'Purge all deleted records',
    'purge_data'                                => 'Purge data',
    'purged_all_records'                        => 'All deleted records have been purged.',
    'delete_data_title'                         => 'Delete data from Firefly III',
    'permanent_delete_stuff'                    => 'You can delete stuff from Firefly III. Using the buttons below means that your items will be removed from view and hidden. There is no undo-button for this, but the items may remain in the database where you can salvage them if necessary.',
    'other_sessions_logged_out'                 => 'All your other sessions have been logged out.',
    'delete_unused_accounts'                    => 'Deleting unused accounts will clean your auto-complete lists.',
    'delete_all_unused_accounts'                => 'Delete unused accounts',
    'deleted_all_unused_accounts'               => 'All unused accounts are deleted',
    'delete_all_budgets'                        => 'Delete ALL your budgets',
    'delete_all_categories'                     => 'Delete ALL your categories',
    'delete_all_tags'                           => 'Delete ALL your tags',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Delete ALL your piggy banks',
    'delete_all_rules'                          => 'Delete ALL your rules',
    'delete_all_recurring'                      => 'Delete ALL your recurring transactions',
    'delete_all_object_groups'                  => 'Delete ALL your object groups',
    'delete_all_accounts'                       => 'Delete ALL your accounts',
    'delete_all_asset_accounts'                 => 'Delete ALL your asset accounts',
    'delete_all_expense_accounts'               => 'Delete ALL your expense accounts',
    'delete_all_revenue_accounts'               => 'Delete ALL your revenue accounts',
    'delete_all_liabilities'                    => 'Delete ALL your liabilities',
    'delete_all_transactions'                   => 'Delete ALL your transactions',
    'delete_all_withdrawals'                    => 'Delete ALL your withdrawals',
    'delete_all_deposits'                       => 'Delete ALL your deposits',
    'delete_all_transfers'                      => 'Delete ALL your transfers',
    'also_delete_transactions'                  => 'Deleting accounts will also delete ALL associated withdrawals, deposits and transfers!',
    'deleted_all_budgets'                       => 'All budgets have been deleted',
    'deleted_all_categories'                    => 'All categories have been deleted',
    'deleted_all_tags'                          => 'All tags have been deleted',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'All piggy banks have been deleted',
    'deleted_all_rules'                         => 'All rules and rule groups have been deleted',
    'deleted_all_object_groups'                 => 'All groups have been deleted',
    'deleted_all_accounts'                      => 'All accounts have been deleted',
    'deleted_all_asset_accounts'                => 'All asset accounts have been deleted',
    'deleted_all_expense_accounts'              => 'All expense accounts have been deleted',
    'deleted_all_revenue_accounts'              => 'All revenue accounts have been deleted',
    'deleted_all_liabilities'                   => 'All liabilities have been deleted',
    'deleted_all_transactions'                  => 'All transactions have been deleted',
    'deleted_all_withdrawals'                   => 'All withdrawals have been deleted',
    'deleted_all_deposits'                      => 'All deposits have been deleted',
    'deleted_all_transfers'                     => 'All transfers have been deleted',
    'deleted_all_recurring'                     => 'All recurring transactions have been deleted',
    'change_your_password'                      => 'Change your password',
    'delete_account'                            => 'Delete account',
    'current_password'                          => 'Current password',
    'new_password'                              => 'New password',
    'new_password_again'                        => 'New password (again)',
    'delete_your_account'                       => 'Delete your account',
    'delete_your_account_help'                  => 'Deleting your account will also delete any accounts, transactions, <em>anything</em> you might have saved into Firefly III. It\'ll be GONE.',
    'delete_your_account_password'              => 'Enter your password to continue.',
    'password'                                  => 'Password',
    'are_you_sure'                              => 'Are you sure? You cannot undo this.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'DELETE your account',
    'invalid_current_password'                  => 'Invalid current password!',
    'password_changed'                          => 'Password changed!',
    'should_change'                             => 'The idea is to change your password.',
    'invalid_password'                          => 'Invalid password!',
    'what_is_pw_security'                       => 'What is "verify password security"?',
    'secure_pw_title'                           => 'How to choose a secure password',
    'forgot_password_response'                  => 'Thank you. If an account exists with this email address, you will find instructions in your inbox.',
    'secure_pw_history'                         => 'Not a week goes by that you read in the news about a site losing the passwords of its users. Hackers and thieves use these passwords to try to steal your private information. This information is valuable.',
    'secure_pw_ff'                              => 'Do you use the same password all over the internet? If one site loses your password, hackers have access to all your data. Firefly III relies on you to choose a strong and unique password to protect your financial records.',
    'secure_pw_check_box'                       => 'To help you do that Firefly III can check if the password you want to use has been stolen in the past. If this is the case, Firefly III advises you NOT to use that password.',
    'secure_pw_working_title'                   => 'How does it work?',
    'secure_pw_working'                         => 'By checking the box, Firefly III will send the first five characters of the SHA1 hash of your password to <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">the website of Troy Hunt</a> to see if it is on the list. This will stop you from using unsafe passwords as is recommended in the latest <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST Special Publication</a> on this subject.',
    'secure_pw_should'                          => 'Should I check the box?',
    'secure_pw_long_password'                   => 'Yes. Always verify your password is safe.',
    'command_line_token'                        => 'Command line token',
    'explain_command_line_token'                => 'You need this token to perform command line options, such as exporting data. Without it, that sensitive command will not work. Do not share your command line token. Nobody will ask you for this token, not even me. If you fear you lost this, or when you\'re paranoid, regenerate this token using the button.',
    'regenerate_command_line_token'             => 'Regenerate command line token',
    'token_regenerated'                         => 'A new command line token was generated',
    'change_your_email'                         => 'Change your email address',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Until you verify your email address, you cannot login.',
    'login_with_new_email'                      => 'You can now login with your new email address.',
    'login_with_old_email'                      => 'You can now login with your old email address again.',
    'login_provider_local_only'                 => 'This action is not available when authenticating through ":login_provider".',
    'external_user_mgt_disabled'                => 'This action is not available when Firefly III isn\'t responsible for user management or authentication handling.',
    'external_auth_disabled'                    => 'This action is not available when Firefly III isn\'t responsible for authentication handling.',
    'delete_local_info_only'                    => "Because Firefly III isn't responsible for user management or authentication handling, this function will only delete local Firefly III information.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth Clients',
    'profile_oauth_no_clients'                  => 'You have not created any OAuth clients.',
    'profile_oauth_clients_external_auth'       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'              => 'Clients',
    'profile_oauth_client_id'                   => 'Client ID',
    'profile_oauth_client_name'                 => 'Name',
    'profile_oauth_client_secret'               => 'Secret',
    'profile_oauth_create_new_client'           => 'Create New Client',
    'profile_oauth_create_client'               => 'Create Client',
    'profile_oauth_edit_client'                 => 'Edit Client',
    'profile_oauth_name_help'                   => 'Something your users will recognize and trust.',
    'profile_oauth_redirect_url'                => 'Redirect URL',
    'profile_oauth_redirect_url_help'           => 'Your application\'s authorization callback URL.',
    'profile_authorized_apps'                   => 'Authorized applications',
    'profile_authorized_clients'                => 'Authorized clients',
    'profile_scopes'                            => 'Scopes',
    'profile_revoke'                            => 'Revoke',
    'profile_oauth_client_secret_title'         => 'Client Secret',
    'profile_oauth_client_secret_expl'          => 'Here is your new client secret. This is the only time it will be shown so don\'t lose it! You may now use this secret to make API requests.',
    'profile_personal_access_tokens'            => 'Personal Access Tokens',
    'profile_personal_access_token'             => 'Personal Access Token',
    'profile_oauth_confidential'                => 'Confidential',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Here is your new personal access token. This is the only time it will be shown so don\'t lose it! You may now use this token to make API requests.',
    'profile_no_personal_access_token'          => 'You have not created any personal access tokens.',
    'profile_create_new_token'                  => 'Create new token',
    'profile_create_token'                      => 'Create token',
    'profile_create'                            => 'Create',
    'profile_save_changes'                      => 'Save changes',
    'profile_whoops'                            => 'Whoops!',
    'profile_something_wrong'                   => 'Something went wrong!',
    'profile_try_again'                         => 'Something went wrong. Please try again.',
    'amounts'                                   => 'Amounts',
    'multi_account_warning_unknown'             => 'Depending on the type of transaction you create, the source and/or destination account of subsequent splits may be overruled by whatever is defined in the first split of the transaction.',
    'multi_account_warning_withdrawal'          => 'Keep in mind that the source account of subsequent splits will be overruled by whatever is defined in the first split of the withdrawal.',
    'multi_account_warning_deposit'             => 'Keep in mind that the destination account of subsequent splits will be overruled by whatever is defined in the first split of the deposit.',
    'multi_account_warning_transfer'            => 'Keep in mind that the source + destination account of subsequent splits will be overruled by whatever is defined in the first split of the transfer.',


    // export data:
    'export_data_title'                         => 'Export data from Firefly III',
    'export_data_menu'                          => 'Export data',
    'export_data_bc'                            => 'Export data from Firefly III',
    'export_data_main_title'                    => 'Export data from Firefly III',
    'export_data_expl'                          => 'This link allows you to export all transactions + meta data from Firefly III. Please refer to the help (top right (?)-icon) for more information about the process.',
    'export_data_all_transactions'              => 'Export all transactions',
    'export_data_advanced_expl'                 => 'If you need a more advanced or specific type of export, read the help on how to use the console command <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'One attachment|:count attachments',
    'attachments'                               => 'Attachments',
    'edit_attachment'                           => 'Edit attachment ":name"',
    'update_attachment'                         => 'Update attachment',
    'delete_attachment'                         => 'Delete attachment ":name"',
    'attachment_deleted'                        => 'Deleted attachment ":name"',
    'liabilities_deleted'                       => 'Deleted liability ":name"',
    'attachment_updated'                        => 'Updated attachment ":name"',
    'upload_max_file_size'                      => 'Maximum file size: :size',
    'list_all_attachments'                      => 'List of all attachments',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Expenses',
    'title_withdrawal'                          => 'Expenses',
    'title_revenue'                             => 'Revenue / income',
    'title_deposit'                             => 'Revenue / income',
    'title_transfer'                            => 'Transfers',
    'title_transfers'                           => 'Transfers',
    'submission_options'                        => 'Submission options',
    'apply_rules_checkbox'                      => 'Apply rules',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'This transaction is already a withdrawal',
    'convert_is_already_type_Deposit'           => 'This transaction is already a deposit',
    'convert_is_already_type_Transfer'          => 'This transaction is already a transfer',
    'convert_to_Withdrawal'                     => 'Convert ":description" to a withdrawal',
    'convert_to_Deposit'                        => 'Convert ":description" to a deposit',
    'convert_to_Transfer'                       => 'Convert ":description" to a transfer',
    'convert_options_WithdrawalDeposit'         => 'Convert a withdrawal into a deposit',
    'convert_options_WithdrawalTransfer'        => 'Convert a withdrawal into a transfer',
    'convert_options_DepositTransfer'           => 'Convert a deposit into a transfer',
    'convert_options_DepositWithdrawal'         => 'Convert a deposit into a withdrawal',
    'convert_options_TransferWithdrawal'        => 'Convert a transfer into a withdrawal',
    'convert_options_TransferDeposit'           => 'Convert a transfer into a deposit',
    'convert_Withdrawal_to_deposit'             => 'Convert this withdrawal to a deposit',
    'convert_Withdrawal_to_transfer'            => 'Convert this withdrawal to a transfer',
    'convert_Deposit_to_withdrawal'             => 'Convert this deposit to a withdrawal',
    'convert_Deposit_to_transfer'               => 'Convert this deposit to a transfer',
    'convert_Transfer_to_deposit'               => 'Convert this transfer to a deposit',
    'convert_Transfer_to_withdrawal'            => 'Convert this transfer to a withdrawal',
    'convert_please_set_revenue_source'         => 'Please pick the revenue account where the money will come from.',
    'convert_please_set_asset_destination'      => 'Please pick the asset account where the money will go to.',
    'convert_please_set_expense_destination'    => 'Please pick the expense account where the money will go to.',
    'convert_please_set_asset_source'           => 'Please pick the asset account where the money will come from.',
    'convert_expl_w_d'                          => 'When converting from a withdrawal to a deposit, the money will be deposited into the displayed destination account, instead of being withdrawn from it.|When converting from a withdrawal to a deposit, the money will be deposited into the displayed destination accounts, instead of being withdrawn from them.',
    'convert_expl_w_t'                          => 'When converting a withdrawal into a transfer, the money will be transferred away from the source account into other asset or liability account instead of being spent on the original expense account.|When converting a withdrawal into a transfer, the money will be transferred away from the source accounts into other asset or liability accounts instead of being spent on the original expense accounts.',
    'convert_expl_d_w'                          => 'When converting a deposit into a withdrawal, the money will be withdrawn from the displayed source account, instead of being deposited into it.|When converting a deposit into a withdrawal, the money will be withdrawn from the displayed source accounts, instead of being deposited into them.',
    'convert_expl_d_t'                          => 'When you convert a deposit into a transfer, the money will be deposited into the listed destination account from any of your asset or liability account.|When you convert a deposit into a transfer, the money will be deposited into the listed destination accounts from any of your asset or liability accounts.',
    'convert_expl_t_w'                          => 'When you convert a transfer into a withdrawal, the money will be spent on the destination account you set here, instead of being transferred away.|When you convert a transfer into a withdrawal, the money will be spent on the destination accounts you set here, instead of being transferred away.',
    'convert_expl_t_d'                          => 'When you convert a transfer into a deposit, the money will be deposited into the destination account you see here, instead of being transferred into it.|When you convert a transfer into a deposit, the money will be deposited into the destination accounts you see here, instead of being transferred into them.',
    'convert_select_sources'                    => 'To complete the conversion, please set the new source account below.|To complete the conversion, please set the new source accounts below.',
    'convert_select_destinations'               => 'To complete the conversion, please select the new destination account below.|To complete the conversion, please select the new destination accounts below.',
    'converted_to_Withdrawal'                   => 'The transaction has been converted to a withdrawal',
    'converted_to_Deposit'                      => 'The transaction has been converted to a deposit',
    'converted_to_Transfer'                     => 'The transaction has been converted to a transfer',
    'invalid_convert_selection'                 => 'The account you have selected is already used in this transaction or does not exist.',
    'source_or_dest_invalid'                    => 'Cannot find the correct transaction details. Conversion is not possible.',
    'convert_to_withdrawal'                     => 'Convert to a withdrawal',
    'convert_to_deposit'                        => 'Convert to a deposit',
    'convert_to_transfer'                       => 'Convert to a transfer',

    // create new stuff:
    'create_new_withdrawal'                     => 'Create new withdrawal',
    'create_new_deposit'                        => 'Create new deposit',
    'create_new_transfer'                       => 'Create new transfer',
    'create_new_asset'                          => 'Create new asset account',
    'create_new_liabilities'                    => 'Create new liability',
    'create_new_expense'                        => 'Create new expense account',
    'create_new_revenue'                        => 'Create new revenue account',
    'create_new_piggy_bank'                     => 'Create new piggy bank',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Create new subscription',
    'create_new_rule'                           => 'Create new rule',

    // currencies:
    'create_currency'                           => 'Create a new currency',
    'store_currency'                            => 'Store new currency',
    'update_currency'                           => 'Update currency',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => 'Cannot delete :name because it is still in use.',
    'cannot_delete_fallback_currency'           => ':name is the system fallback currency and can\'t be deleted.',
    'cannot_disable_currency_journals'          => 'Cannot disable :name because transactions are still using it.',
    'cannot_disable_currency_last_left'         => 'Cannot disable :name because it is the last enabled currency.',
    'cannot_disable_currency_account_meta'      => 'Cannot disable :name because it is used in asset accounts.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Cannot disable :name because it is used in recurring transactions.',
    'cannot_disable_currency_available_budgets' => 'Cannot disable :name because it is used in available budgets.',
    'cannot_disable_currency_budget_limits'     => 'Cannot disable :name because it is used in budget limits.',
    'cannot_disable_currency_current_default'   => 'Cannot disable :name because it is the current default currency.',
    'cannot_disable_currency_system_fallback'   => 'Cannot disable :name because it is the system default currency.',
    'disable_EUR_side_effects'                  => 'The Euro is the system\'s emergency fallback currency. Disabling it may have unintended side-effects and may void your warranty.',
    'deleted_currency'                          => 'Currency :name deleted',
    'created_currency'                          => 'Currency :name created',
    'could_not_store_currency'                  => 'Could not store the new currency.',
    'updated_currency'                          => 'Currency :name updated',
    'ask_site_owner'                            => 'Please ask :owner to add, remove or edit currencies.',
    'currencies_intro'                          => 'Firefly III supports various currencies which you can set and enable here.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Make default',
    'default_currency'                          => 'default',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Disabled',
    'enable_currency'                           => 'Enable',
    'disable_currency'                          => 'Disable',
    'currencies_default_disabled'               => 'Most of these currencies are disabled by default. To use them, you must enable them first.',
    'currency_is_now_enabled'                   => 'Currency ":name" has been enabled',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Currency ":name" has been disabled',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Mandatory fields',
    'optionalFields'                            => 'Optional fields',
    'options'                                   => 'Options',

    // budgets:
    'daily_budgets'                             => 'Daily budgets',
    'weekly_budgets'                            => 'Weekly budgets',
    'monthly_budgets'                           => 'Monthly budgets',
    'quarterly_budgets'                         => 'Quarterly budgets',
    'half_year_budgets'                         => 'Half-yearly budgets',
    'yearly_budgets'                            => 'Yearly budgets',
    'other_budgets'                             => 'Custom timed budgets',
    'budget_limit_not_in_range'                 => 'This amount applies from :start to :end:',
    'total_available_budget'                    => 'Total available budget (between :start and :end)',
    'total_available_budget_in_currency'        => 'Total available budget in :currency',
    'see_below'                                 => 'see below',
    'create_new_budget'                         => 'Create a new budget',
    'store_new_budget'                          => 'Store new budget',
    'stored_new_budget'                         => 'Stored new budget ":name"',
    'available_between'                         => 'Available between :start and :end',
    'transactionsWithoutBudget'                 => 'Expenses without budget',
    'transactions_no_budget'                    => 'Expenses without budget between :start and :end',
    'spent_between'                             => 'Already spent between :start and :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Set available amount',
    'update_available_amount'                   => 'Update available amount',
    'ab_basic_modal_explain'                    => 'Use this form to indicate how much you expect to be able to budget (in total, in :currency) in the indicated period.',
    'createBudget'                              => 'New budget',
    'invalid_currency'                          => 'This is an invalid currency',
    'invalid_amount'                            => 'Please enter an amount',
    'set_ab'                                    => 'The available budget amount has been set',
    'updated_ab'                                => 'The available budget amount has been updated',
    'deleted_ab'                                => 'The available budget amount has been deleted',
    'deleted_bl'                                => 'The budgeted amount has been removed',
    'alt_currency_ab_create'                    => 'Set the available budget in another currency',
    'bl_create_btn'                             => 'Set budget in another currency',
    'inactiveBudgets'                           => 'Inactive budgets',
    'without_budget_between'                    => 'Transactions without a budget between :start and :end',
    'delete_budget'                             => 'Delete budget ":name"',
    'deleted_budget'                            => 'Deleted budget ":name"',
    'edit_budget'                               => 'Edit budget ":name"',
    'updated_budget'                            => 'Updated budget ":name"',
    'update_amount'                             => 'Update amount',
    'update_budget'                             => 'Update budget',
    'update_budget_amount_range'                => 'Update (expected) available amount between :start and :end',
    'set_budget_limit_title'                    => 'Set budgeted amount for budget :budget between :start and :end',
    'set_budget_limit'                          => 'Set budgeted amount',
    'budget_period_navigator'                   => 'Period navigator',
    'info_on_available_amount'                  => 'What do I have available?',
    'available_amount_indication'               => 'Use these amounts to get an indication of what your total budget could be.',
    'suggested'                                 => 'Suggested',
    'average_between'                           => 'Average between :start and :end',
    'transferred_in'                            => 'Transferred (in)',
    'transferred_away'                          => 'Transferred (away)',
    'auto_budget_none'                          => 'No auto-budget',
    'auto_budget_reset'                         => 'Set a fixed amount every period',
    'auto_budget_rollover'                      => 'Add an amount every period',
    'auto_budget_adjusted'                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                  => 'Daily',
    'auto_budget_period_weekly'                 => 'Weekly',
    'auto_budget_period_monthly'                => 'Monthly',
    'auto_budget_period_quarterly'              => 'Quarterly',
    'auto_budget_period_half_year'              => 'Every half year',
    'auto_budget_period_yearly'                 => 'Yearly',
    'auto_budget_help'                          => 'You can read more about this feature in the help. Click the top-right (?) icon.',
    'auto_budget_reset_icon'                    => 'This budget will be set periodically',
    'auto_budget_rollover_icon'                 => 'The budget amount will increase periodically',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Remove budgeted amount in :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Subscription',
    'not_expected_period'                       => 'Not expected this period',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Not (yet)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Repeats',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Connected transactions',
    'auto_match_on'                             => 'Automatically matched by Firefly III',
    'auto_match_off'                            => 'Not automatically matched by Firefly III',
    'next_expected_match'                       => 'Next expected match',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'More',
    'rescan_old'                                => 'Run rules again, on all transactions',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Expected between :start and :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'skips over',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'inactive rule',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Expected :date',
    'bill_expected_date_js'                     => 'Expected {date}',
    'expected_amount'                           => '(Expected) amount',
    'bill_paid_on'                              => 'Paid on {date}',
    'bill_repeats_weekly'                       => 'Repeats weekly',
    'bill_repeats_monthly'                      => 'Repeats monthly',
    'bill_repeats_quarterly'                    => 'Repeats quarterly',
    'bill_repeats_half-year'                    => 'Repeats every half year',
    'bill_repeats_yearly'                       => 'Repeats yearly',
    'bill_repeats_weekly_other'                 => 'Repeats every other week',
    'bill_repeats_monthly_other'                => 'Repeats every other month',
    'bill_repeats_quarterly_other'              => 'Repeats every other quarter',
    'bill_repeats_half-year_other'              => 'Repeats yearly',
    'bill_repeats_yearly_other'                 => 'Repeats every other year',
    'bill_repeats_weekly_skip'                  => 'Repeats every {skip} weeks',
    'bill_repeats_monthly_skip'                 => 'Repeats every {skip} months',
    'bill_repeats_quarterly_skip'               => 'Repeats every {skip} quarters',
    'bill_repeats_half-year_skip'               => 'Repeats every {skip} half years',
    'bill_repeats_yearly_skip'                  => 'Repeats every {skip} years',
    'subscriptions'                             => 'Subscriptions',
    'go_to_subscriptions'                       => 'Go to your subscriptions',
    'forever'                                   => 'Forever',
    'extension_date_is'                         => 'Extension date is {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'I am owed amount',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'You have :count inactive (archived) account, which you can view on this separate page.|You have :count inactive (archived) accounts, which you can view on this separate page.',
    'all_accounts_inactive'                     => 'These are your inactive accounts.',
    'active_account_link'                       => 'This link goes back to your active accounts.',
    'account_missing_transaction'               => 'Account #:id (":name") cannot be viewed directly, but Firefly is missing redirect information.',
    'cc_monthly_payment_date_help'              => 'Select any year and any month, it will be ignored anyway. Only the day of the month is relevant.',
    'details_for_asset'                         => 'Details for asset account ":name"',
    'details_for_expense'                       => 'Details for expense account ":name"',
    'details_for_revenue'                       => 'Details for revenue account ":name"',
    'details_for_cash'                          => 'Details for cash account ":name"',
    'store_new_asset_account'                   => 'Store new asset account',
    'store_new_expense_account'                 => 'Store new expense account',
    'store_new_revenue_account'                 => 'Store new revenue account',
    'edit_asset_account'                        => 'Edit asset account ":name"',
    'edit_expense_account'                      => 'Edit expense account ":name"',
    'edit_revenue_account'                      => 'Edit revenue account ":name"',
    'delete_asset_account'                      => 'Delete asset account ":name"',
    'delete_expense_account'                    => 'Delete expense account ":name"',
    'delete_revenue_account'                    => 'Delete revenue account ":name"',
    'delete_liabilities_account'                => 'Delete liability ":name"',
    'asset_deleted'                             => 'Successfully deleted asset account ":name"',
    'account_deleted'                           => 'Successfully deleted account ":name"',
    'expense_deleted'                           => 'Successfully deleted expense account ":name"',
    'revenue_deleted'                           => 'Successfully deleted revenue account ":name"',
    'update_asset_account'                      => 'Update asset account',
    'update_undefined_account'                  => 'Update account',
    'update_liabilities_account'                => 'Update liability',
    'update_expense_account'                    => 'Update expense account',
    'update_revenue_account'                    => 'Update revenue account',
    'make_new_asset_account'                    => 'Create a new asset account',
    'make_new_expense_account'                  => 'Create a new expense account',
    'make_new_revenue_account'                  => 'Create a new revenue account',
    'make_new_liabilities_account'              => 'Create a new liability',
    'asset_accounts'                            => 'Asset accounts',
    'undefined_accounts'                        => 'Accounts',
    'asset_accounts_inactive'                   => 'Asset accounts (inactive)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Expense accounts',
    'expense_accounts_inactive'                 => 'Expense accounts (inactive)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Revenue accounts',
    'revenue_accounts_inactive'                 => 'Revenue accounts (inactive)',
    'cash_accounts'                             => 'Cash accounts',
    'Cash account'                              => 'Cash account',
    'liabilities_accounts'                      => 'Liabilities',
    'liabilities_accounts_inactive'             => 'Liabilities (inactive)',
    'reconcile_account'                         => 'Reconcile account ":account"',
    'overview_of_reconcile_modal'               => 'Overview of reconciliation',
    'delete_reconciliation'                     => 'Delete reconciliation',
    'update_reconciliation'                     => 'Update reconciliation',
    'amount_cannot_be_zero'                     => 'The amount cannot be zero',
    'end_of_reconcile_period'                   => 'End of reconcile period: :period',
    'start_of_reconcile_period'                 => 'Start of reconcile period: :period',
    'start_balance'                             => 'Start balance',
    'end_balance'                               => 'End balance',
    'update_balance_dates_instruction'          => 'Match the amounts and dates above to your bank statement, and press "Start reconciling"',
    'select_transactions_instruction'           => 'Select the transactions that appear on your bank statement.',
    'select_range_and_balance'                  => 'First verify the date-range and balances. Then press "Start reconciling"',
    'date_change_instruction'                   => 'If you change the date range now, any progress will be lost.',
    'update_selection'                          => 'Update selection',
    'store_reconcile'                           => 'Store reconciliation',
    'reconciliation_transaction'                => 'Reconciliation transaction',
    'Reconciliation'                            => 'Reconciliation',
    'reconciliation'                            => 'Reconciliation',
    'reconcile_options'                         => 'Reconciliation options',
    'reconcile_range'                           => 'Reconciliation range',
    'start_reconcile'                           => 'Start reconciling',
    'cash_account_type'                         => 'Cash',
    'cash'                                      => 'cash',
    'cant_find_redirect_account'                => 'Firefly III tried to redirect you but couldn\'t. Sorry about that. Back to the index.',
    'account_type'                              => 'Account type',
    'save_transactions_by_moving'               => 'Save this transaction by moving it to another account:|Save these transactions by moving them to another account:',
    'save_transactions_by_moving_js'            => 'No transactions|Save this transaction by moving it to another account. |Save these transactions by moving them to another account.',
    'stored_new_account'                        => 'New account ":name" stored!',
    'stored_new_account_js'                     => 'New account "<a href="accounts/show/{ID}">{name}</a>" stored!',
    'updated_account'                           => 'Updated account ":name"',
    'updated_account_js'                        => 'Updated account "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Credit card options',
    'no_transactions_account'                   => 'There are no transactions (in this period) for asset account ":name".',
    'no_transactions_period'                    => 'There are no transactions (in this period).',
    'no_data_for_chart'                         => 'There is not enough information (yet) to generate this chart.',
    'select_at_least_one_account'               => 'Please select at least one asset account',
    'select_at_least_one_category'              => 'Please select at least one category',
    'select_at_least_one_budget'                => 'Please select at least one budget',
    'select_at_least_one_tag'                   => 'Please select at least one tag',
    'select_at_least_one_expense'               => 'Please select at least one combination of expense/revenue accounts. If you have none (the list is empty) this report is not available.',
    'account_default_currency'                  => 'This will be the default currency associated with this account.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Your Firefly III ledger has more money in it than your bank claims you should have. There are several options. Please choose what to do. Then, press "Confirm reconciliation".',
    'reconcile_has_less'                        => 'Your Firefly III ledger has less money in it than your bank claims you should have. There are several options. Please choose what to do. Then, press "Confirm reconciliation".',
    'reconcile_is_equal'                        => 'Your Firefly III ledger and your bank statements match. There is nothing to do. Please press "Confirm reconciliation" to confirm your input.',
    'create_pos_reconcile_transaction'          => 'Clear the selected transactions, and create a correction adding :amount to this asset account.',
    'create_neg_reconcile_transaction'          => 'Clear the selected transactions, and create a correction removing :amount from this asset account.',
    'reconcile_do_nothing'                      => 'Clear the selected transactions, but do not correct.',
    'reconcile_go_back'                         => 'You can always edit or delete a correction later.',
    'must_be_asset_account'                     => 'You can only reconcile asset accounts',
    'reconciliation_stored'                     => 'Reconciliation stored',
    'reconciliation_error'                      => 'Due to an error the transactions were marked as reconciled but the correction has not been stored: :error.',
    'reconciliation_transaction_title'          => 'Reconciliation (:from to :to)',
    'sum_of_reconciliation'                     => 'Sum of reconciliation',
    'reconcile_this_account'                    => 'Reconcile this account',
    'reconcile'                                 => 'Reconcile',
    'show'                                      => 'Show',
    'confirm_reconciliation'                    => 'Confirm reconciliation',
    'submitted_start_balance'                   => 'Submitted start balance',
    'selected_transactions'                     => 'Selected transactions (:count)',
    'already_cleared_transactions'              => 'Already cleared transactions (:count)',
    'submitted_end_balance'                     => 'Submitted end balance',
    'initial_balance_description'               => 'Initial balance for ":account"',
    'liability_credit_description'              => 'Liability credit for ":account"',
    'interest_calc_'                            => 'unknown',
    'interest_calc_daily'                       => 'Per day',
    'interest_calc_monthly'                     => 'Per month',
    'interest_calc_yearly'                      => 'Per year',
    'interest_calc_weekly'                      => 'Per week',
    'interest_calc_half-year'                   => 'Per half year',
    'interest_calc_quarterly'                   => 'Per quarter',
    'initial_balance_account'                   => 'Initial balance account of :account',
    'list_options'                              => 'List options',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'New category',
    'create_new_category'                       => 'Create a new category',
    'without_category'                          => 'Without a category',
    'update_category'                           => 'Update category',
    'updated_category'                          => 'Updated category ":name"',
    'categories'                                => 'Categories',
    'edit_category'                             => 'Edit category ":name"',
    'no_category'                               => '(no category)',
    'unknown_category_plain'                    => 'No category',
    'category'                                  => 'Category',
    'delete_category'                           => 'Delete category ":name"',
    'deleted_category'                          => 'Deleted category ":name"',
    'store_category'                            => 'Store new category',
    'stored_category'                           => 'Stored new category ":name"',
    'without_category_between'                  => 'Without category between :start and :end',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Update withdrawal',
    'update_deposit'                            => 'Update deposit',
    'update_transaction'                        => 'Update transaction',
    'update_transfer'                           => 'Update transfer',
    'updated_withdrawal'                        => 'Updated withdrawal ":description"',
    'updated_deposit'                           => 'Updated deposit ":description"',
    'updated_transfer'                          => 'Updated transfer ":description"',
    'no_changes_withdrawal'                     => 'Withdrawal ":description" was not changed.',
    'no_changes_deposit'                        => 'Deposit ":description" was not changed.',
    'no_changes_transfer'                       => 'Transfer ":description" was not changed.',
    'delete_withdrawal'                         => 'Delete withdrawal ":description"',
    'delete_deposit'                            => 'Delete deposit ":description"',
    'delete_transfer'                           => 'Delete transfer ":description"',
    'deleted_withdrawal'                        => 'Successfully deleted withdrawal ":description"',
    'deleted_deposit'                           => 'Successfully deleted deposit ":description"',
    'deleted_transfer'                          => 'Successfully deleted transfer ":description"',
    'deleted_reconciliation'                    => 'Successfully deleted reconciliation transaction ":description"',
    'stored_journal'                            => 'Successfully created new transaction ":description"',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Successfully created your new transaction',
    'updated_journal_no_descr'                  => 'Successfully updated your transaction',
    'select_transactions'                       => 'Select transactions',
    'rule_group_select_transactions'            => 'Apply ":title" to transactions',
    'rule_select_transactions'                  => 'Apply ":title" to transactions',
    'stop_selection'                            => 'Stop selecting transactions',
    'reconcile_selected'                        => 'Reconcile',
    'mass_delete_journals'                      => 'Delete a number of transactions',
    'mass_edit_journals'                        => 'Edit a number of transactions',
    'mass_bulk_journals'                        => 'Bulk edit a number of transactions',
    'mass_bulk_journals_explain'                => 'This form allows you to change properties of the transactions listed below in one sweeping update. All the transactions in the table will be updated when you change the parameters you see here.',
    'part_of_split'                             => 'This transaction is part of a split transaction. If you have not selected all the splits, you may end up with changing only half the transaction.',
    'bulk_set_new_values'                       => 'Use the inputs below to set new values. If you leave them empty, they will be made empty for all. Also, note that only withdrawals will be given a budget.',
    'no_bulk_category'                          => 'Don\'t update category',
    'no_bulk_budget'                            => 'Don\'t update budget',
    'no_bulk_tags'                              => 'Don\'t update tag(s)',
    'replace_with_these_tags'                   => 'Replace with these tags',
    'append_these_tags'                         => 'Add these tags',
    'mass_edit'                                 => 'Edit selected individually',
    'bulk_edit'                                 => 'Edit selected in bulk',
    'mass_delete'                               => 'Delete selected',
    'cannot_edit_other_fields'                  => 'You cannot mass-edit other fields than the ones here, because there is no room to show them. Please follow the link and edit them by one-by-one, if you need to edit these fields.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(no budget)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Account per budget',
    'account_per_category'                      => 'Account per category',
    'create_new_object'                         => 'Create',
    'empty'                                     => '(empty)',
    'all_other_budgets'                         => '(all other budgets)',
    'all_other_accounts'                        => '(all other accounts)',
    'expense_per_source_account'                => 'Expenses per source account',
    'expense_per_destination_account'           => 'Expenses per destination account',
    'income_per_destination_account'            => 'Income per destination account',
    'spent_in_specific_category'                => 'Spent in category ":category"',
    'earned_in_specific_category'               => 'Earned in category ":category"',
    'spent_in_specific_tag'                     => 'Spent in tag ":tag"',
    'earned_in_specific_tag'                    => 'Earned in tag ":tag"',
    'income_per_source_account'                 => 'Income per source account',
    'average_spending_per_destination'          => 'Average expense per destination account',
    'average_spending_per_source'               => 'Average expense per source account',
    'average_earning_per_source'                => 'Average earning per source account',
    'average_earning_per_destination'           => 'Average earning per destination account',
    'account_per_tag'                           => 'Account per tag',
    'tag_report_expenses_listed_once'           => 'Expenses and income are never listed twice. If a transaction has multiple tags, it may only show up under one of its tags. This list may appear to be missing data, but the amounts will be correct.',
    'double_report_expenses_charted_once'       => 'Expenses and income are never displayed twice. If a transaction has multiple tags, it may only show up under one of its tags. This chart may appear to be missing data, but the amounts will be correct.',
    'tag_report_chart_single_tag'               => 'This chart applies to a single tag. If a transaction has multiple tags, what you see here may be reflected in the charts of other tags as well.',
    'tag'                                       => 'Tag',
    'no_budget_squared'                         => '(no budget)',
    'perm-delete-many'                          => 'Deleting many items in one go can be very disruptive. Please be cautious. You can delete part of a split transaction from this page, so take care.',
    'mass_deleted_transactions_success'         => 'Deleted :count transaction.|Deleted :count transactions.',
    'mass_edited_transactions_success'          => 'Updated :count transaction.|Updated :count transactions.',
    'opt_group_'                                => '(no account type)',
    'opt_group_no_account_type'                 => '(no account type)',
    'opt_group_defaultAsset'                    => 'Default asset accounts',
    'opt_group_savingAsset'                     => 'Savings accounts',
    'opt_group_sharedAsset'                     => 'Shared asset accounts',
    'opt_group_ccAsset'                         => 'Credit cards',
    'opt_group_cashWalletAsset'                 => 'Cash wallets',
    'opt_group_expense_account'                 => 'Expense accounts',
    'opt_group_revenue_account'                 => 'Revenue accounts',
    'opt_group_l_Loan'                          => 'Liability: Loan',
    'opt_group_cash_account'                    => 'Cash account',
    'opt_group_l_Debt'                          => 'Liability: Debt',
    'opt_group_l_Mortgage'                      => 'Liability: Mortgage',
    'opt_group_l_Credit card'                   => 'Liability: Credit card',
    'notes'                                     => 'Notes',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Could not store the transaction. Please check the log files.',
    'attachment_not_found'                      => 'This attachment could not be found.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transaction #{ID} ("{title}")</a> has been stored.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transaction #{ID}</a> has been stored.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") has been updated.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") did not receive any changes.',
    'first_split_decides'                       => 'The first split determines the value of this field',
    'first_split_overrules_source'              => 'The first split may overrule the source account',
    'first_split_overrules_destination'         => 'The first split may overrule the destination account',
    'spent_x_of_y'                              => 'Spent {amount} of {total}',

    // new user:
    'welcome'                                   => 'Welcome to Firefly III!',
    'submit'                                    => 'Submit',
    'submission'                                => 'Submission',
    'submit_yes_really'                         => 'Submit (I know what I\'m doing)',
    'getting_started'                           => 'Getting started',
    'to_get_started'                            => 'It is good to see you have successfully installed Firefly III. To get started with this tool please enter your bank\'s name and the balance of your main checking account. Do not worry yet if you have multiple accounts. You can add those later. It\'s just that Firefly III needs something to start with.',
    'savings_balance_text'                      => 'Firefly III will automatically create a savings account for you. By default, there will be no money in your savings account, but if you tell Firefly III the balance it will be stored as such.',
    'finish_up_new_user'                        => 'That\'s it! You can continue by pressing <strong>Submit</strong>. You will be taken to the index of Firefly III.',
    'stored_new_accounts_new_user'              => 'Yay! Your new accounts have been stored.',
    'set_preferred_language'                    => 'If you prefer to use Firefly III in another language, please indicate so here.',
    'language'                                  => 'Language',
    'new_savings_account'                       => ':bank_name savings account',
    'cash_wallet'                               => 'Cash wallet',
    'currency_not_present'                      => 'If the currency you normally use is not listed do not worry. You can create your own currencies under Options > Currencies.',

    // home page:
    'transaction_table_description'             => 'A table containing your transactions',
    'opposing_account'                          => 'Opposing account',
    'yourAccounts'                              => 'Your accounts',
    'your_accounts'                             => 'Your account overview',
    'category_overview'                         => 'Category overview',
    'expense_overview'                          => 'Expense account overview',
    'revenue_overview'                          => 'Revenue account overview',
    'budgetsAndSpending'                        => 'Budgets and spending',
    'budgets_and_spending'                      => 'Budgets and spending',
    'go_to_budget'                              => 'Go to budget "{budget}"',
    'go_to_deposits'                            => 'Go to deposits',
    'go_to_expenses'                            => 'Go to expenses',
    'savings'                                   => 'Savings',
    'newWithdrawal'                             => 'New expense',
    'newDeposit'                                => 'New deposit',
    'newTransfer'                               => 'New transfer',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Per day',
    'left_to_spend_per_day'                     => 'Left to spend per day',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Custom period',
    'reset_to_current'                          => 'Reset to current period',
    'select_period'                             => 'Select a period',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Currency',
    'preferences'                               => 'Preferences',
    'logout'                                    => 'Logout',
    'logout_other_sessions'                     => 'Logout all other sessions',
    'toggleNavigation'                          => 'Toggle navigation',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Search...',
    'version'                                   => 'Version',
    'dashboard'                                 => 'Dashboard',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'No budget',
    'available_budget'                          => 'Available budget ({currency})',
    'currencies'                                => 'Currencies',
    'activity'                                  => 'Activity',
    'usage'                                     => 'Usage',
    'accounts'                                  => 'Accounts',
    'Asset account'                             => 'Asset account',
    'Default account'                           => 'Asset account',
    'Expense account'                           => 'Expense account',
    'Revenue account'                           => 'Revenue account',
    'Initial balance account'                   => 'Initial balance account',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Debt',
    'account_type_Loan'                         => 'Loan',
    'account_type_Mortgage'                     => 'Mortgage',
    'account_type_debt'                         => 'Debt',
    'account_type_loan'                         => 'Loan',
    'account_type_mortgage'                     => 'Mortgage',
    'account_type_Credit card'                  => 'Credit card',
    'credit_card_type_monthlyFull'              => 'Full payment every month',
    'liability_direction_credit'                => 'I am owed this debt',
    'liability_direction_debit'                 => 'I owe this debt to somebody else',
    'liability_direction_credit_short'          => 'Owed this debt',
    'liability_direction_debit_short'           => 'Owe this debt',
    'liability_direction__short'                => 'Unknown',
    'liability_direction_null_short'            => 'Unknown',
    'Liability credit'                          => 'Liability credit',
    'budgets'                                   => 'Budgets',
    'tags'                                      => 'Tags',
    'reports'                                   => 'Reports',
    'transactions'                              => 'Transactions',
    'expenses'                                  => 'Expenses',
    'income'                                    => 'Revenue / income',
    'transfers'                                 => 'Transfers',
    'moneyManagement'                           => 'Money management',
    'money_management'                          => 'Money management',
    'tools'                                     => 'Tools',
    'piggyBanks'                                => 'Piggy banks',
    'piggy_banks'                               => 'Piggy banks',
    'amount_x_of_y'                             => '{current} of {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Withdrawal',
    'opening_balance'                           => 'Opening balance',
    'deposit'                                   => 'Deposit',
    'account'                                   => 'Account',
    'transfer'                                  => 'Transfer',
    'Withdrawal'                                => 'Withdrawal',
    'Deposit'                                   => 'Deposit',
    'Transfer'                                  => 'Transfer',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Yes',
    'no'                                        => 'No',
    'amount'                                    => 'Amount',
    'overview'                                  => 'Overview',
    'saveOnAccount'                             => 'Save on account',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Unknown',
    'monthly'                                   => 'Monthly',
    'profile'                                   => 'Profile',
    'errors'                                    => 'Errors',
    'debt_start_date'                           => 'Start date of debt',
    'debt_start_amount'                         => 'Start amount of debt',
    'debt_start_amount_help'                    => 'It\'s always best to set this value to a negative amount. Read the help pages (top right (?)-icon) for more information.',
    'interest_period_help'                      => 'This field is purely cosmetic and won\'t be calculated for you. As it turns out banks are very sneaky so Firefly III never gets it right.',
    'store_new_liabilities_account'             => 'Store new liability',
    'edit_liabilities_account'                  => 'Edit liability ":name"',
    'financial_control'                         => 'Financial control',
    'accounting'                                => 'Accounting',
    'automation'                                => 'Automation',
    'others'                                    => 'Others',
    'classification'                            => 'Classification',
    'store_transaction'                         => 'Store transaction',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Default financial report between :start and :end',
    'report_audit'                              => 'Transaction history overview between :start and :end',
    'report_category'                           => 'Category report between :start and :end',
    'report_double'                             => 'Expense/revenue account report between :start and :end',
    'report_budget'                             => 'Budget report between :start and :end',
    'report_tag'                                => 'Tag report between :start and :end',
    'quick_link_reports'                        => 'Quick links',
    'quick_link_examples'                       => 'These are just some example links to get you started. Check out the help pages under the (?)-button for information on all reports and the magic words you can use.',
    'quick_link_default_report'                 => 'Default financial report',
    'quick_link_audit_report'                   => 'Transaction history overview',
    'report_this_month_quick'                   => 'Current month, all accounts',
    'report_last_month_quick'                   => 'Last month, all accounts',
    'report_this_year_quick'                    => 'Current year, all accounts',
    'report_this_fiscal_year_quick'             => 'Current fiscal year, all accounts',
    'report_all_time_quick'                     => 'All-time, all accounts',
    'reports_can_bookmark'                      => 'Remember that reports can be bookmarked.',
    'incomeVsExpenses'                          => 'Income vs. expenses',
    'accountBalances'                           => 'Account balances',
    'balanceStart'                              => 'Balance at start of period',
    'balanceEnd'                                => 'Balance at end of period',
    'splitByAccount'                            => 'Split by account',
    'coveredWithTags'                           => 'Covered with tags',
    'leftInBudget'                              => 'Left in budget',
    'left_in_debt'                              => 'Amount due',
    'sumOfSums'                                 => 'Sum of sums',
    'noCategory'                                => '(no category)',
    'notCharged'                                => 'Not charged (yet)',
    'inactive'                                  => 'Inactive',
    'active'                                    => 'Active',
    'difference'                                => 'Difference',
    'money_flowing_in'                          => 'In',
    'money_flowing_out'                         => 'Out',
    'topX'                                      => 'top :number',
    'show_full_list'                            => 'Show entire list',
    'show_only_top'                             => 'Show only top :number',
    'report_type'                               => 'Report type',
    'report_type_default'                       => 'Default financial report',
    'report_type_audit'                         => 'Transaction history overview (audit)',
    'report_type_category'                      => 'Category report',
    'report_type_budget'                        => 'Budget report',
    'report_type_tag'                           => 'Tag report',
    'report_type_double'                        => 'Expense/revenue account report',
    'more_info_help'                            => 'More information about these types of reports can be found in the help pages. Press the (?) icon in the top right corner.',
    'report_included_accounts'                  => 'Included accounts',
    'report_date_range'                         => 'Date range',
    'report_preset_ranges'                      => 'Pre-set ranges',
    'shared'                                    => 'Shared',
    'fiscal_year'                               => 'Fiscal year',
    'income_entry'                              => 'Income from account ":name" between :start and :end',
    'expense_entry'                             => 'Expenses to account ":name" between :start and :end',
    'category_entry'                            => 'Expenses and income in category ":name" between :start and :end',
    'budget_spent_amount'                       => 'Expenses in budget ":budget" between :start and :end',
    'balance_amount'                            => 'Expenses in budget ":budget" paid from account ":account" between :start and :end',
    'no_audit_activity'                         => 'No activity was recorded on account <a href=":url" title=":account_name">:account_name</a> between :start and :end.',
    'audit_end_balance'                         => 'Account balance of <a href=":url" title=":account_name">:account_name</a> at the end of :end was: :balance',
    'reports_extra_options'                     => 'Extra options',
    'report_has_no_extra_options'               => 'This report has no extra options',
    'reports_submit'                            => 'View report',
    'end_after_start_date'                      => 'End date of report must be after start date.',
    'select_category'                           => 'Select category(ies)',
    'select_budget'                             => 'Select budget(s).',
    'select_tag'                                => 'Select tag(s).',
    'income_per_category'                       => 'Income per category',
    'expense_per_category'                      => 'Expense per category',
    'expense_per_budget'                        => 'Expense per budget',
    'income_per_account'                        => 'Income per account',
    'expense_per_account'                       => 'Expense per account',
    'expense_per_tag'                           => 'Expense per tag',
    'income_per_tag'                            => 'Income per tag',
    'include_expense_not_in_budget'             => 'Included expenses not in the selected budget(s)',
    'include_expense_not_in_account'            => 'Included expenses not in the selected account(s)',
    'include_expense_not_in_category'           => 'Included expenses not in the selected category(ies)',
    'include_income_not_in_category'            => 'Included income not in the selected category(ies)',
    'include_income_not_in_account'             => 'Included income not in the selected account(s)',
    'include_income_not_in_tags'                => 'Included income not in the selected tag(s)',
    'include_expense_not_in_tags'               => 'Included expenses not in the selected tag(s)',
    'everything_else'                           => 'Everything else',
    'income_and_expenses'                       => 'Income and expenses',
    'spent_average'                             => 'Spent (average)',
    'income_average'                            => 'Income (average)',
    'transaction_count'                         => 'Transaction count',
    'average_spending_per_account'              => 'Average spending per account',
    'average_income_per_account'                => 'Average income per account',
    'total'                                     => 'Total',
    'description'                               => 'Description',
    'sum_of_period'                             => 'Sum of period',
    'average_in_period'                         => 'Average in period',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Default asset account',
    'account_role_sharedAsset'                  => 'Shared asset account',
    'account_role_savingAsset'                  => 'Savings account',
    'account_role_ccAsset'                      => 'Credit card',
    'account_role_cashWalletAsset'              => 'Cash wallet',
    'budget_chart_click'                        => 'Please click on a budget name in the table above to see a chart.',
    'category_chart_click'                      => 'Please click on a category name in the table above to see a chart.',
    'in_out_accounts'                           => 'Earned and spent per combination',
    'in_out_accounts_per_asset'                 => 'Earned and spent (per asset account)',
    'in_out_per_category'                       => 'Earned and spent per category',
    'out_per_budget'                            => 'Spent per budget',
    'select_expense_revenue'                    => 'Select expense/revenue account',
    'multi_currency_report_sum'                 => 'Because this list contains accounts with multiple currencies, the sum(s) you see may not make sense. The report will always fall back to your default currency.',
    'sum_in_default_currency'                   => 'The sum will always be in your default currency.',
    'net_filtered_prefs'                        => 'This chart will never include accounts that have the "Include in net worth"-option unchecked.',


    // charts:
    'chart'                                     => 'Chart',
    'month'                                     => 'Month',
    'budget'                                    => 'Budget',
    'spent'                                     => 'Spent',
    'spent_capped'                              => 'Spent (capped)',
    'spent_in_budget'                           => 'Spent in budget',
    'left_to_spend'                             => 'Left to spend',
    'earned'                                    => 'Earned',
    'overspent'                                 => 'Overspent',
    'left'                                      => 'Left',
    'max-amount'                                => 'Maximum amount',
    'min-amount'                                => 'Minimum amount',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Name',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Date',
    'date_and_time'                             => 'Date and time',
    'time'                                      => 'Time',
    'paid'                                      => 'Paid',
    'unpaid'                                    => 'Unpaid',
    'day'                                       => 'Day',
    'budgeted'                                  => 'Budgeted',
    'period'                                    => 'Period',
    'balance'                                   => 'Balance',
    'in_out_period'                             => 'In + out this period',
    'sum'                                       => 'Sum',
    'summary'                                   => 'Summary',
    'average'                                   => 'Average',
    'balanceFor'                                => 'Balance for :name',
    'no_tags'                                   => '(no tags)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Event history',
    'add_money_to_piggy'            => 'Add money to piggy bank ":name"',
    'piggy_bank'                    => 'Piggy bank',
    'new_piggy_bank'                => 'New piggy bank',
    'store_piggy_bank'              => 'Store new piggy bank',
    'stored_piggy_bank'             => 'Store new piggy bank ":name"',
    'account_status'                => 'Account status',
    'left_for_piggy_banks'          => 'Left for piggy banks',
    'sum_of_piggy_banks'            => 'Sum of piggy banks',
    'saved_so_far'                  => 'Saved so far',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Left to save',
    'suggested_amount'              => 'Suggested monthly amount to save',
    'add_money_to_piggy_title'      => 'Add money to piggy bank ":name"',
    'remove_money_from_piggy_title' => 'Remove money from piggy bank ":name"',
    'add'                           => 'Add',
    'no_money_for_piggy'            => 'You have no money to put in this piggy bank.',
    'suggested_savings_per_month'   => 'Suggested per month',

    'remove'                    => 'Remove',
    'max_amount_add'            => 'The maximum amount you can add is',
    'max_amount_remove'         => 'The maximum amount you can remove is',
    'update_piggy_button'       => 'Update piggy bank',
    'update_piggy_title'        => 'Update piggy bank ":name"',
    'updated_piggy_bank'        => 'Updated piggy bank ":name"',
    'details'                   => 'Details',
    'events'                    => 'Events',
    'target_amount'             => 'Target amount',
    'start_date'                => 'Start date',
    'no_start_date'             => 'No start date',
    'target_date'               => 'Target date',
    'no_target_date'            => 'No target date',
    'table'                     => 'Table',
    'delete_piggy_bank'         => 'Delete piggy bank ":name"',
    'cannot_add_amount_piggy'   => 'Could not add :amount to ":name".',
    'cannot_remove_from_piggy'  => 'Could not remove :amount from ":name".',
    'deleted_piggy_bank'        => 'Deleted piggy bank ":name"',
    'added_amount_to_piggy'     => 'Added :amount to ":name"',
    'removed_amount_from_piggy' => 'Removed :amount from ":name"',
    'piggy_events'              => 'Related piggy banks',

    // tags
    'delete_tag'                => 'Delete tag ":tag"',
    'deleted_tag'               => 'Deleted tag ":tag"',
    'new_tag'                   => 'Make new tag',
    'edit_tag'                  => 'Edit tag ":tag"',
    'updated_tag'               => 'Updated tag ":tag"',
    'created_tag'               => 'Tag ":tag" has been created!',

    'transaction_journal_information'               => 'Transaction information',
    'transaction_journal_amount'                    => 'Amount information',
    'transaction_journal_meta'                      => 'Meta information',
    'transaction_journal_more'                      => 'More information',
    'basic_journal_information'                     => 'Basic transaction information',
    'transaction_journal_extra'                     => 'Extra information',
    'att_part_of_journal'                           => 'Stored under ":journal"',
    'total_amount'                                  => 'Total amount',
    'number_of_decimals'                            => 'Number of decimals',


    // administration
    'invite_is_already_redeemed'                    => 'The invite to ":address" has already been redeemed.',
    'invite_is_deleted'                             => 'The invite to ":address" has been deleted.',
    'invite_new_user_title'                         => 'Invite new user',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Email address',
    'invite_user'                                   => 'Invite user',
    'user_is_invited'                               => 'Email address ":address" was invited to Firefly III',
    'administration'                                => 'Administration',
    'system_settings'                               => 'System settings',
    'code_already_used'                             => 'Invite code has been used',
    'user_administration'                           => 'User administration',
    'list_all_users'                                => 'All users',
    'all_users'                                     => 'All users',
    'instance_configuration'                        => 'Configuration',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'setting_single_user_mode'                      => 'Single user mode',
    'setting_single_user_mode_explain'              => 'By default, Firefly III only accepts one (1) registration: you. This is a security measure, preventing others from using your instance unless you allow them to. Future registrations are blocked. When you uncheck this box, others can use your instance as well, assuming they can reach it (when it is connected to the internet).',
    'store_configuration'                           => 'Store configuration',
    'single_user_administration'                    => 'User administration for :email',
    'edit_user'                                     => 'Edit user :email',
    'hidden_fields_preferences'                     => 'You can enable more transaction options in your <a href="preferences">preferences</a>.',
    'user_data_information'                         => 'User data',
    'user_information'                              => 'User information',
    'total_size'                                    => 'total size',
    'budget_or_budgets'                             => ':count budget|:count budgets',
    'budgets_with_limits'                           => ':count budget with configured amount|:count budgets with configured amount',
    'nr_of_rules_in_total_groups'                   => ':count_rules rule(s) in :count_groups rule group(s)',
    'tag_or_tags'                                   => ':count tag|:count tags',
    'configuration_updated'                         => 'The configuration has been updated',
    'setting_is_demo_site'                          => 'Demo site',
    'setting_is_demo_site_explain'                  => 'If you check this box, this installation will behave as if it is the demo site, which can have weird side effects.',
    'block_code_bounced'                            => 'Email message(s) bounced',
    'block_code_expired'                            => 'Demo account expired',
    'no_block_code'                                 => 'No reason for block or user not blocked',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'User has not yet confirmed new email address',
    'admin_update_email'                            => 'Contrary to the profile page, the user will NOT be notified their email address has changed!',
    'update_user'                                   => 'Update user',
    'updated_user'                                  => 'User data has been changed.',
    'delete_user'                                   => 'Delete user :email',
    'user_deleted'                                  => 'The user has been deleted',
    'send_test_email'                               => 'Send test email message',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Send message',
    'send_test_triggered'                           => 'Test was triggered. Check your inbox and the log files.',
    'give_admin_careful'                            => 'Users who are given admin rights can take away yours. Be careful.',
    'admin_maintanance_title'                       => 'Maintenance',
    'admin_maintanance_expl'                        => 'Some nifty buttons for Firefly III maintenance',
    'admin_maintenance_clear_cache'                 => 'Clear cache',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'All invited users',
    'save_notification_settings'                    => 'Save settings',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'The notification settings have been saved',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Description of the split transaction',
    'split_transaction_title_help'          => 'If you create a split transaction, there must be a global description for all splits of the transaction.',
    'split_title_help'                      => 'If you create a split transaction, there must be a global description for all splits of the transaction.',
    'you_create_transfer'                   => 'You\'re creating a transfer.',
    'you_create_withdrawal'                 => 'You\'re creating a withdrawal.',
    'you_create_deposit'                    => 'You\'re creating a deposit.',

    // links
    'journal_link_configuration'            => 'Transaction links configuration',
    'create_new_link_type'                  => 'Create new link type',
    'store_new_link_type'                   => 'Store new link type',
    'update_link_type'                      => 'Update link type',
    'edit_link_type'                        => 'Edit link type ":name"',
    'updated_link_type'                     => 'Updated link type ":name"',
    'delete_link_type'                      => 'Delete link type ":name"',
    'deleted_link_type'                     => 'Deleted link type ":name"',
    'stored_new_link_type'                  => 'Store new link type ":name"',
    'cannot_edit_link_type'                 => 'Cannot edit link type ":name"',
    'link_type_help_name'                   => 'Ie. "Duplicates"',
    'link_type_help_inward'                 => 'Ie. "duplicates"',
    'link_type_help_outward'                => 'Ie. "is duplicated by"',
    'save_connections_by_moving'            => 'Save the link between these transactions by moving them to another link type:',
    'do_not_save_connection'                => '(do not save connection)',
    'link_transaction'                      => 'Link transaction',
    'link_to_other_transaction'             => 'Link this transaction to another transaction',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'This transaction',
    'transaction'                           => 'Transaction',
    'comments'                              => 'Comments',
    'link_notes'                            => 'Any notes you wish to store with the link.',
    'invalid_link_selection'                => 'Cannot link these transactions',
    'selected_transaction'                  => 'Selected transaction',
    'journals_linked'                       => 'Transactions are linked.',
    'journals_error_linked'                 => 'These transactions are already linked.',
    'journals_link_to_self'                 => 'You cannot link a transaction to itself',
    'journal_links'                         => 'Transaction links',
    'this_withdrawal'                       => 'This withdrawal',
    'this_deposit'                          => 'This deposit',
    'this_transfer'                         => 'This transfer',
    'overview_for_link'                     => 'Overview for link type ":name"',
    'source_transaction'                    => 'Source transaction',
    'link_description'                      => 'Link description',
    'destination_transaction'               => 'Destination transaction',
    'delete_journal_link'                   => 'Delete the link between <a href=":source_link">:source</a> and <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Deleted link',

    // link translations:
    'Paid_name'                             => 'Paid',
    'Refund_name'                           => 'Refund',
    'Reimbursement_name'                    => 'Reimbursement',
    'Related_name'                          => 'Related',
    'relates to_inward'                     => 'relates to',
    'is (partially) refunded by_inward'     => 'is (partially) refunded by',
    'is (partially) paid for by_inward'     => 'is (partially) paid for by',
    'is (partially) reimbursed by_inward'   => 'is (partially) reimbursed by',
    'inward_transaction'                    => 'Inward transaction',
    'outward_transaction'                   => 'Outward transaction',
    'relates to_outward'                    => 'relates to',
    '(partially) refunds_outward'           => '(partially) refunds',
    '(partially) pays for_outward'          => '(partially) pays for',
    '(partially) reimburses_outward'        => '(partially) reimburses',
    'is (partially) refunded by'            => 'is (partially) refunded by',
    'is (partially) paid for by'            => 'is (partially) paid for by',
    'is (partially) reimbursed by'          => 'is (partially) reimbursed by',
    'relates to'                            => 'relates to',
    '(partially) refunds'                   => '(partially) refunds',
    '(partially) pays for'                  => '(partially) pays for',
    '(partially) reimburses'                => '(partially) reimburses',

    // split a transaction:
    'splits'                                => 'Splits',
    'add_another_split'                     => 'Add another split',
    'cannot_edit_opening_balance'           => 'You cannot edit the opening balance of an account.',
    'no_edit_multiple_left'                 => 'You have selected no valid transactions to edit.',
    'breadcrumb_convert_group'              => 'Convert transaction',
    'convert_invalid_source'                => 'Source information is invalid for transaction #%d.',
    'convert_invalid_destination'           => 'Destination information is invalid for transaction #%d.',
    'create_another'                        => 'After storing, return here to create another one.',
    'after_update_create_another'           => 'After updating, return here to continue editing.',
    'store_as_new'                          => 'Store as a new transaction instead of updating.',
    'reset_after'                           => 'Reset form after submission',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Expand split',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Collapse split',

    // object groups
    'default_group_title_name'              => '(ungrouped)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Let\'s create an asset account!',
    'no_accounts_intro_asset'               => 'You have no asset accounts yet. Asset accounts are your main accounts: your checking account, savings account, shared account or even your credit card.',
    'no_accounts_imperative_asset'          => 'To start using Firefly III you must create at least one asset account. Let\'s do so now:',
    'no_accounts_create_asset'              => 'Create an asset account',
    'no_accounts_title_expense'             => 'Let\'s create an expense account!',
    'no_accounts_intro_expense'             => 'You have no expense accounts yet. Expense accounts are the places where you spend money, such as shops and supermarkets.',
    'no_accounts_imperative_expense'        => 'Expense accounts are created automatically when you create transactions, but you can create one manually too, if you want. Let\'s create one now:',
    'no_accounts_create_expense'            => 'Create an expense account',
    'no_accounts_title_revenue'             => 'Let\'s create a revenue account!',
    'no_accounts_intro_revenue'             => 'You have no revenue accounts yet. Revenue accounts are the places where you receive money from, such as your employer.',
    'no_accounts_imperative_revenue'        => 'Revenue accounts are created automatically when you create transactions, but you can create one manually too, if you want. Let\'s create one now:',
    'no_accounts_create_revenue'            => 'Create a revenue account',
    'no_accounts_title_liabilities'         => 'Let\'s create a liability!',
    'no_accounts_intro_liabilities'         => 'You have no liabilities yet. Liabilities are the accounts that register your (student) loans and other debts.',
    'no_accounts_imperative_liabilities'    => 'You don\'t have to use this feature, but it can be useful if you want to keep track of these things.',
    'no_accounts_create_liabilities'        => 'Create a liability',
    'no_budgets_title_default'              => 'Let\'s create a budget',
    'no_rules_title_default'                => 'Let\'s create a rule',
    'no_budgets_intro_default'              => 'You have no budgets yet. Budgets are used to organize your expenses into logical groups, which you can give a soft-cap to limit your expenses.',
    'no_rules_intro_default'                => 'You have no rules yet. Rules are powerful automations that can handle transactions for you.',
    'no_rules_imperative_default'           => 'Rules can be very useful when you\'re managing transactions. Let\'s create one now:',
    'no_budgets_imperative_default'         => 'Budgets are the basic tools of financial management. Let\'s create one now:',
    'no_budgets_create_default'             => 'Create a budget',
    'no_rules_create_default'               => 'Create a rule',
    'no_categories_title_default'           => 'Let\'s create a category!',
    'no_categories_intro_default'           => 'You have no categories yet. Categories are used to fine tune your transactions and label them with their designated category.',
    'no_categories_imperative_default'      => 'Categories are created automatically when you create transactions, but you can create one manually too. Let\'s create one now:',
    'no_categories_create_default'          => 'Create a category',
    'no_tags_title_default'                 => 'Let\'s create a tag!',
    'no_tags_intro_default'                 => 'You have no tags yet. Tags are used to fine tune your transactions and label them with specific keywords.',
    'no_tags_imperative_default'            => 'Tags are created automatically when you create transactions, but you can create one manually too. Let\'s create one now:',
    'no_tags_create_default'                => 'Create a tag',
    'no_transactions_title_withdrawal'      => 'Let\'s create an expense!',
    'no_transactions_intro_withdrawal'      => 'You have no expenses yet. You should create expenses to start managing your finances.',
    'no_transactions_imperative_withdrawal' => 'Have you spent some money? Then you should write it down:',
    'no_transactions_create_withdrawal'     => 'Create an expense',
    'no_transactions_title_deposit'         => 'Let\'s create some income!',
    'no_transactions_intro_deposit'         => 'You have no recorded income yet. You should create income entries to start managing your finances.',
    'no_transactions_imperative_deposit'    => 'Have you received some money? Then you should write it down:',
    'no_transactions_create_deposit'        => 'Create a deposit',
    'no_transactions_title_transfers'       => 'Let\'s create a transfer!',
    'no_transactions_intro_transfers'       => 'You have no transfers yet. When you move money between asset accounts, it is recorded as a transfer.',
    'no_transactions_imperative_transfers'  => 'Have you moved some money around? Then you should write it down:',
    'no_transactions_create_transfers'      => 'Create a transfer',
    'no_piggies_title_default'              => 'Let\'s create a piggy bank!',
    'no_piggies_intro_default'              => 'You have no piggy banks yet. You can create piggy banks to divide your savings and keep track of what you\'re saving up for.',
    'no_piggies_imperative_default'         => 'Do you have things you\'re saving money for? Create a piggy bank and keep track:',
    'no_piggies_create_default'             => 'Create a new piggy bank',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Create right now',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Recurring transactions',
    'repeat_until_in_past'                  => 'This recurring transaction stopped repeating on :date.',
    'recurring_calendar_view'               => 'Calendar',
    'no_recurring_title_default'            => 'Let\'s create a recurring transaction!',
    'no_recurring_intro_default'            => 'You have no recurring transactions yet. You can use these to make Firefly III automatically create transactions for you.',
    'no_recurring_imperative_default'       => 'This is a pretty advanced feature but it can be extremely useful. Make sure you read the documentation (?)-icon in the top right corner) before you continue.',
    'no_recurring_create_default'           => 'Create a recurring transaction',
    'make_new_recurring'                    => 'Create a recurring transaction',
    'recurring_daily'                       => 'Every day',
    'recurring_weekly'                      => 'Every week on :weekday',
    'recurring_weekly_skip'                 => 'Every :skip(st/nd/rd/th) week on :weekday',
    'recurring_monthly'                     => 'Every month on the :dayOfMonth(st/nd/rd/th) day',
    'recurring_monthly_skip'                => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) day',
    'recurring_ndom'                        => 'Every month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Every year on :date',
    'overview_for_recurrence'               => 'Overview for recurring transaction ":title"',
    'warning_duplicates_repetitions'        => 'In rare instances, dates appear twice in this list. This can happen when multiple repetitions collide. Firefly III will always generate one transaction per day.',
    'created_transactions'                  => 'Related transactions',
    'expected_withdrawals'                  => 'Expected withdrawals',
    'expected_deposits'                     => 'Expected deposits',
    'expected_transfers'                    => 'Expected transfers',
    'created_withdrawals'                   => 'Created withdrawals',
    'created_deposits'                      => 'Created deposits',
    'created_transfers'                     => 'Created transfers',
    'recurring_info'                        => 'Recurring transaction :count / :total',
    'created_from_recurrence'               => 'Created from recurring transaction ":title" (#:id)',
    'recurring_never_cron'                  => 'It seems the cron job that is necessary to support recurring transactions has never run. This is of course normal when you have just installed Firefly III, but this should be something to set up as soon as possible. Please check out the help-pages using the (?)-icon in the top right corner of the page.',
    'recurring_cron_long_ago'               => 'It looks like it has been more than 36 hours since the cron job to support recurring transactions has fired for the last time. Are you sure it has been set up correctly? Please check out the help-pages using the (?)-icon in the top right corner of the page.',

    'create_new_recurrence'              => 'Create new recurring transaction',
    'help_first_date'                    => 'Indicate the first expected recurrence. This must be in the future.',
    'help_first_date_no_past'            => 'Indicate the first expected recurrence. Firefly III will not create transactions in the past.',
    'no_currency'                        => '(no currency)',
    'mandatory_for_recurring'            => 'Mandatory recurrence information',
    'mandatory_for_transaction'          => 'Mandatory transaction information',
    'optional_for_recurring'             => 'Optional recurrence information',
    'optional_for_transaction'           => 'Optional transaction information',
    'change_date_other_options'          => 'Change the "first date" to see more options.',
    'mandatory_fields_for_tranaction'    => 'The values here will end up in the transaction(s) being created',
    'click_for_calendar'                 => 'Click here for a calendar that shows you when the transaction would repeat.',
    'repeat_forever'                     => 'Repeat forever',
    'repeat_until_date'                  => 'Repeat until date',
    'repeat_times'                       => 'Repeat a number of times',
    'recurring_skips_one'                => 'Every other',
    'recurring_skips_more'               => 'Skips :count occurrences',
    'store_new_recurrence'               => 'Store recurring transaction',
    'stored_new_recurrence'              => 'Recurring transaction ":title" stored successfully.',
    'edit_recurrence'                    => 'Edit recurring transaction ":title"',
    'recurring_repeats_until'            => 'Repeats until :date',
    'recurring_repeats_forever'          => 'Repeats forever',
    'recurring_repeats_x_times'          => 'Repeats :count time|Repeats :count times',
    'update_recurrence'                  => 'Update recurring transaction',
    'updated_recurrence'                 => 'Updated recurring transaction ":title"',
    'recurrence_is_inactive'             => 'This recurring transaction is not active and will not generate new transactions.',
    'delete_recurring'                   => 'Delete recurring transaction ":title"',
    'new_recurring_transaction'          => 'New recurring transaction',
    'help_weekend'                       => 'What should Firefly III do when the recurring transaction falls on a Saturday or Sunday?',
    'do_nothing'                         => 'Just create the transaction',
    'skip_transaction'                   => 'Skip the occurrence',
    'jump_to_friday'                     => 'Create the transaction on the previous Friday instead',
    'jump_to_monday'                     => 'Create the transaction on the next Monday instead',
    'will_jump_friday'                   => 'Will be created on Friday instead of the weekends.',
    'will_jump_monday'                   => 'Will be created on Monday instead of the weekends.',
    'except_weekends'                    => 'Except weekends',
    'recurrence_deleted'                 => 'Recurring transaction ":title" deleted',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Balance (:currency)',
    'box_spent_in_currency'              => 'Spent (:currency)',
    'box_earned_in_currency'             => 'Earned (:currency)',
    'box_budgeted_in_currency'           => 'Budgeted (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Left to spend (:currency)',
    'box_net_worth_in_currency'          => 'Net worth (:currency)',
    'box_spend_per_day'                  => 'Left to spend per day: :amount',

    // debug page
    'debug_page'                         => 'Debug page',
    'debug_submit_instructions'          => 'If you are running into problems, you can use the information in this box as debug information. Please copy-and-paste into a new or existing <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. It will generate a beautiful table that can be used to quickly diagnose your problem.',
    'debug_pretty_table'                 => 'If you copy/paste the box below into a GitHub issue it will generate a table. Please do not surround this text with backticks or quotes.',
    'debug_additional_data'              => 'You may also share the content of the box below. You can also copy-and-paste this into a new or existing <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. However, the content of this box may contain private information such as account names, transaction details or email addresses.',

    // object groups
    'object_groups_menu_bar'             => 'Groups',
    'object_groups_page_title'           => 'Groups',
    'object_groups_breadcrumb'           => 'Groups',
    'object_groups_index'                => 'Overview',
    'object_groups'                      => 'Groups',
    'object_groups_empty_explain'        => 'Some things in Firefly III can be divided into groups. Piggy banks for example, feature a "Group" field in the edit and create screens. When you set this field, you can edit the names and the order of the groups on this page. For more information, check out the help-pages in the top right corner, under the (?)-icon.',
    'object_group_title'                 => 'Title',
    'edit_object_group'                  => 'Edit group ":title"',
    'delete_object_group'                => 'Delete group ":title"',
    'update_object_group'                => 'Update group',
    'updated_object_group'               => 'Successfully updated group ":title"',
    'deleted_object_group'               => 'Successfully deleted group ":title"',
    'object_group'                       => 'Group',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'Added :amount to piggy bank ":name"',
    'ale_action_log_remove'              => 'Removed :amount from piggy bank ":name"',
    'ale_action_clear_budget'            => 'Removed from budget',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Removed from category',
    'ale_action_clear_notes'             => 'Removed notes',
    'ale_action_clear_tag'               => 'Cleared tag',
    'ale_action_clear_all_tags'          => 'Cleared all tags',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Set budget',
    'ale_action_set_category'            => 'Set category',
    'ale_action_set_source'              => 'Set source account',
    'ale_action_set_destination'         => 'Set destination account',
    'ale_action_update_transaction_type' => 'Changed transaction type',
    'ale_action_update_notes'            => 'Changed notes',
    'ale_action_update_description'      => 'Changed description',
    'ale_action_add_to_piggy'            => 'Piggy bank',
    'ale_action_remove_from_piggy'       => 'Piggy bank',
    'ale_action_add_tag'                 => 'Added tag',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Enable currency conversion',
    'disable_auto_convert'               => 'Disable currency conversion',
];
