/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.browser.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DownloadProgress {
    private final String guid;
    private final Number totalBytes;
    private final Number receivedBytes;
    private final State state;
    private final Optional<String> filePath;

    public DownloadProgress(String guid, Number totalBytes, Number receivedBytes, State state, Optional<String> filePath) {
        this.guid = Objects.requireNonNull(guid, "guid is required");
        this.totalBytes = Objects.requireNonNull(totalBytes, "totalBytes is required");
        this.receivedBytes = Objects.requireNonNull(receivedBytes, "receivedBytes is required");
        this.state = Objects.requireNonNull(state, "state is required");
        this.filePath = filePath;
    }

    public String getGuid() {
        return this.guid;
    }

    public Number getTotalBytes() {
        return this.totalBytes;
    }

    public Number getReceivedBytes() {
        return this.receivedBytes;
    }

    public State getState() {
        return this.state;
    }

    @Beta
    public Optional<String> getFilePath() {
        return this.filePath;
    }

    private static DownloadProgress fromJson(JsonInput input) {
        String guid = null;
        Number totalBytes = 0;
        Number receivedBytes = 0;
        State state = null;
        Optional<String> filePath = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "guid": {
                    guid = input.nextString();
                    continue block14;
                }
                case "totalBytes": {
                    totalBytes = input.nextNumber();
                    continue block14;
                }
                case "receivedBytes": {
                    receivedBytes = input.nextNumber();
                    continue block14;
                }
                case "state": {
                    state = State.fromString(input.nextString());
                    continue block14;
                }
                case "filePath": {
                    filePath = Optional.ofNullable(input.nextString());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DownloadProgress(guid, totalBytes, receivedBytes, state, filePath);
    }

    public static enum State {
        INPROGRESS("inProgress"),
        COMPLETED("completed"),
        CANCELED("canceled");

        private String value;

        private State(String value) {
            this.value = value;
        }

        public static State fromString(String s) {
            return Arrays.stream(State.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within State "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static State fromJson(JsonInput input) {
            return State.fromString(input.nextString());
        }
    }
}

