/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v140.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v140.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v140.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class LoadingFinished {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final Number encodedDataLength;

    public LoadingFinished(RequestId requestId, MonotonicTime timestamp, Number encodedDataLength) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.encodedDataLength = Objects.requireNonNull(encodedDataLength, "encodedDataLength is required");
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Number getEncodedDataLength() {
        return this.encodedDataLength;
    }

    private static LoadingFinished fromJson(JsonInput input) {
        RequestId requestId = null;
        MonotonicTime timestamp = null;
        Number encodedDataLength = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block10;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block10;
                }
                case "encodedDataLength": {
                    encodedDataLength = input.nextNumber();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LoadingFinished(requestId, timestamp, encodedDataLength);
    }
}

