# 修复 API 部分修改功能无法返回菜单的问题

## 问题描述
用户在菜单中选择"修改部分 API 内容"后，完成修改操作无法自动返回到主菜单。

## 根本原因
`modifyApiConfigPartially` 函数内部使用了 while 循环来支持连续修改多个配置项，但这种设计与菜单系统的交互模式不一致，导致函数结束后无法正确返回菜单。

## 解决方案
移除 `modifyApiConfigPartially` 函数中的 while 循环和"是否继续修改"的提示，改为每次只修改一个配置项，修改完成后直接返回，让菜单系统统一处理是否返回菜单的逻辑。

## 实施步骤
1. 修改 `src/utils/config-operations.ts` 中的 `modifyApiConfigPartially` 函数
2. 移除 while 循环结构
3. 移除"是否继续修改"的询问
4. 保持单次修改逻辑不变

## 预期结果
- 用户选择修改部分 API 配置
- 选择要修改的项目（URL/Key/AuthType）
- 完成修改后显示成功信息
- 自动返回到菜单系统的统一确认流程
- 与其他功能保持一致的交互体验