# MCP 配置优化任务

## 任务概述
优化 MCP 配置选择界面：
1. 移除 ALL 选项
2. 在提示中添加 "a全选" 说明
3. 去除重复的描述文字
4. 提取公共方法避免重复实现

## 执行计划
1. ✅ 创建 `mcp-selector.ts` 公共方法文件
2. ✅ 更新 `constants.ts` 添加新的提示文字常量
3. ✅ 修改 `init.ts` 使用新的公共方法
4. ✅ 修改 `features.ts` 使用新的公共方法
5. ✅ 运行类型检查确保代码正确

## 实施结果
- 成功创建了 `mcp-selector.ts` 统一管理 MCP 选择逻辑
- 在常量中添加了清晰的提示文字，包含 "a全选" 说明
- 移除了 ALL 选项，使用 inquirer 原生的全选功能
- 两处 MCP 选择逻辑已统一，代码复用性提高
- 类型检查通过，代码正确性得到验证

## 技术细节
- 利用 inquirer checkbox 的原生全选功能（按 a 键）
- 统一 MCP 选择逻辑到一个公共函数
- 清晰的提示文字，避免重复描述