# ZCF 菜单功能实施计划

## 任务描述

为 npx zcf 增加一个面板功能，可以按数字选择对应功能：

1. 完整初始化（安装 Claude Code + 导入工作流 + 配置 API 或 CCR 代理 + 配置 MCP 服务)
2. 导入工作流
3. 配置 API
4. 配置 MCP（含 Windows MCP 异常修复功能）
5. 配置默认模型（opus,sonnet）
6. 配置 claude 全局记忆（含现在有的 AI 输出语言,再增加一个子选项,配置 AI 输出角色风格:比如猫娘）
   -. 清除 zcf 偏好缓存（偏好语言等）
7. change script language/更改 ZCF 显示语言

## 实施步骤

### 步骤 1：创建菜单命令和结构

- 文件：`src/commands/menu.ts`
- 创建主菜单界面函数 `showMainMenu()`
- 实现菜单循环逻辑

### 步骤 2：提取和重构现有功能

- 文件：`src/utils/features.ts`
- 从现有代码提取独立功能函数

### 步骤 3：实现新功能模块

- 配置默认模型
- 配置 AI 个性化
- 清除缓存功能

### 步骤 4：创建 AI 个性化配置

- 文件：`src/utils/ai-personality.ts`
- 预设角色风格和自定义选项

### 步骤 5：更新 CLI 入口

- 修改默认命令为菜单模式
- 保持向后兼容性

### 步骤 6：更新常量和国际化

- 添加菜单相关文本
- 支持中英文界面

### 步骤 7：更新类型定义

- 添加必要的接口定义

### 步骤 8：实现 Windows MCP 修复

- 增强现有修复功能
