# 修正 src/ 下代码中的硬编码问题改成 i18n (Flat 写法)

## 任务概述

将 ZCF 项目中 src/ 目录下 TypeScript 文件中的硬编码中文字符串替换为 i18n 国际化调用，使用 flat key 写法。

## 执行时间

**开始时间**: 2025-01-09 17:28:00  
**结束时间**: 2025-01-09 17:34:00  
**总耗时**: 约 6 分钟

## 任务完成情况

### ✅ 已完成任务

1. **分析当前代码中的硬编码问题范围**
   - 使用正则表达式扫描识别硬编码中文字符串
   - 发现主要问题位于 `constants.ts:70,95` 和 `prompts.ts:100,122`

2. **检查 language.json 文件结构和 flat key 支持**
   - 验证现有 i18n 系统已完美支持 flat key 格式
   - 确认 `keySeparator: false` 和 `nsSeparator: ':'` 配置正确

3. **修正 constants.ts 中的硬编码中文标签**
   - 移除 `getLangLabel()` 函数中的硬编码 fallback 对象
   - 移除 `getAiOutputLanguageLabel()` 函数中的硬编码 fallback 对象  
   - 依赖 i18next 内置的 `fallbackLng: 'en'` 机制

4. **修正 prompts.ts 中的硬编码双语消息**
   - 提取 `selectScriptLanguage()` 函数中的硬编码双语字符串到常量
   - 添加清晰注释说明为什么需要保留双语显示（i18n 初始化前的语言选择场景）
   - 使用 `LANGUAGE_SELECTION_MESSAGES` 常量提高代码组织性

5. **扫描其他 TypeScript 文件中的潜在硬编码问题**
   - 全面扫描 src/ 目录，确认无其他硬编码中文字符串
   - 保留合理的双语消息（语言选择界面）

6. **验证 i18n flat 写法的正确性**
   - 检查所有 `i18n.t()` 调用都使用正确的 flat key 格式
   - 确认格式如 `'language:labels.zh-CN'` 符合项目规范

7. **运行测试确保修改后功能正常**
   - TypeScript 类型检查通过
   - 所有 877 个测试用例通过
   - Prompts 相关测试 (23个) 全部通过

8. **修正 selectScriptLanguage 函数中的硬编码双语消息**
   - 将硬编码消息提取到 `LANGUAGE_SELECTION_MESSAGES` 常量
   - 添加详细注释说明保留双语的合理性
   - 提高代码可维护性和清晰度

## 技术实现详情

### 修改的文件

1. **src/constants.ts**
   - **行号**: 70-73, 95-99
   - **修改内容**: 移除 fallback 对象中的硬编码中文标签
   - **技术要点**: 依赖 i18next fallbackLng 机制，简化代码逻辑

2. **src/utils/prompts.ts** 
   - **行号**: 68-72, 87, 95, 102
   - **修改内容**: 提取双语消息到常量，添加说明注释
   - **技术要点**: 保留必要的双语显示，提高代码组织性

### 使用的 i18n Flat Key 格式

- **语言标签**: `'language:labels.zh-CN'`、`'language:labels.en'`、`'language:labels.custom'`
- **命名空间分隔符**: `:`
- **键分隔符**: `false` (支持点号作为键名的一部分)

### 设计决策

1. **保留语言选择界面的双语显示**
   - **原因**: 用户还未选择语言，需要双语引导
   - **实现**: 使用常量和注释明确标识特殊场景

2. **移除手动 fallback 逻辑**
   - **原因**: i18next 已配置 `fallbackLng: 'en'`
   - **好处**: 简化代码，减少维护负担

3. **使用 Flat Key 写法**
   - **格式**: `namespace:key.subkey`
   - **符合**: 项目现有 i18n 配置和规范

## 测试结果

- ✅ **TypeScript 编译**: 无错误
- ✅ **ESLint 检查**: 仅有未使用变量警告，无功能影响  
- ✅ **完整测试套件**: 877/877 测试通过
- ✅ **Prompts 专项测试**: 23/23 测试通过
- ✅ **构建验证**: 成功构建 dist/

## 质量保证

### 代码质量
- 遵循 KISS 原则：简化逻辑，移除不必要的复杂性
- 遵循 DRY 原则：提取重复字符串到常量
- 添加清晰的注释说明设计决策

### 兼容性
- 保持现有 API 不变
- 向后兼容现有配置
- 跨平台功能正常

### 可维护性
- 集中管理硬编码消息
- 清晰的注释和文档
- 符合项目编码规范

## 总结

成功完成了 src/ 目录下所有硬编码中文字符串的 i18n 化改造，使用 flat key 写法。主要改进包括：

1. **彻底清理硬编码**: 移除了 constants.ts 中的硬编码中文标签
2. **规范化消息管理**: 将 prompts.ts 中的双语消息提取到常量
3. **简化 fallback 逻辑**: 依赖 i18next 内置机制，减少代码复杂度
4. **保持用户体验**: 合理保留语言选择界面的双语显示
5. **确保质量**: 所有测试通过，功能完全正常

项目现在完全符合 i18n 最佳实践，使用统一的 flat key 格式，代码更加清晰和可维护。