# 渐进式测试覆盖率提升计划

## 执行概要

**目标**：将补丁覆盖率从80.03%提升至90%+，减少206行未覆盖代码
**策略**：按优先级渐进式补充关键路径测试
**预计时间**：2-3小时
**实施原则**：最小侵入性，最大效果

## 优先级文件列表

### 🔴 高优先级（立即处理）
1. **src/commands/init.ts** - 57.40% → 85%+ (46行缺失)
2. **src/utils/auto-updater.ts** - 16.32% → 80%+ (41行缺失)

### 🟡 中优先级（次要处理）
3. **src/utils/features.ts** - 74.03% → 85%+ (27行缺失)
4. **src/utils/ccr/config.ts** - 57.40% → 85%+ (23行缺失)

### 🟢 低优先级（后续处理）
5. **src/utils/tools/ccr-menu.ts** - 66.66% → 85%+ (12行缺失)
6. **src/cli-setup.ts** - 94.66% → 98%+ (8行缺失)
7. **src/utils/config-operations.ts** - 84.00% → 90%+ (8行缺失)

## 详细执行步骤

### 阶段1：init.ts测试补充 (预计45分钟)

#### 当前状态分析
- 覆盖率：57.40%
- 缺失行数：46行
- 主要问题：初始化流程的边界条件和异常处理未覆盖

#### 具体实施步骤
1. **检查现有测试文件**
   ```bash
   find tests -name "*init*" -type f
   ```

2. **分析未覆盖代码段**
   - 异常处理分支
   - 用户取消操作场景
   - 配置文件不存在场景
   - 权限错误处理

3. **补充测试用例**
   - 用户中断安装流程测试
   - 无效配置参数测试
   - 文件系统权限错误测试
   - API配置失败场景测试
   - MCP服务选择边界测试

4. **Mock策略**
   ```typescript
   // Mock外部依赖
   vi.mock('inquirer')
   vi.mock('node:fs')
   vi.mock('../utils/installer')
   vi.mock('../utils/config')
   
   // Mock用户交互场景
   const mockPrompt = vi.fn()
   ```

#### 预期测试用例
```typescript
describe('init command', () => {
  describe('error handling', () => {
    it('should handle user cancellation gracefully')
    it('should handle file permission errors')
    it('should handle invalid API configuration')
    it('should handle MCP service installation failure')
    it('should handle workflow selection cancellation')
  })
  
  describe('edge cases', () => {
    it('should handle existing config with invalid format')
    it('should handle partial installation recovery')
    it('should handle network connectivity issues')
  })
})
```

### 阶段2：auto-updater.ts测试补充 (预计40分钟)

#### 当前状态分析
- 覆盖率：16.32% (最严重)
- 缺失行数：41行
- 主要问题：自动更新逻辑几乎完全缺失测试

#### 具体实施步骤
1. **创建测试文件**
   ```bash
   tests/unit/utils/auto-updater.test.ts
   tests/unit/utils/auto-updater.edge.test.ts
   ```

2. **核心功能测试**
   - 版本检查逻辑
   - 更新下载流程
   - 更新安装流程
   - 回滚机制

3. **异常场景测试**
   - 网络连接失败
   - 下载中断
   - 安装权限不足
   - 版本检查失败

4. **Mock策略**
   ```typescript
   vi.mock('tinyexec')
   vi.mock('node:https')
   vi.mock('node:fs/promises')
   
   // Mock网络请求
   const mockHttps = {
     get: vi.fn(),
     request: vi.fn()
   }
   ```

#### 预期测试用例
```typescript
describe('AutoUpdater', () => {
  describe('version checking', () => {
    it('should check current version correctly')
    it('should detect available updates')
    it('should handle version API errors')
  })
  
  describe('update process', () => {
    it('should download updates successfully')
    it('should install updates correctly')
    it('should handle download failures')
    it('should rollback on installation failure')
  })
})
```

### 阶段3：features.ts测试补充 (预计30分钟)

#### 当前状态分析
- 覆盖率：74.03%
- 缺失行数：27行
- 主要问题：特性开关和条件逻辑分支未完全覆盖

#### 具体实施步骤
1. **分析特性开关逻辑**
2. **补充边界条件测试**
3. **添加平台特定特性测试**

### 阶段4：CCR config.ts测试补充 (预计25分钟)

#### 当前状态分析
- 覆盖率：57.40%
- 缺失行数：23行
- 主要问题：CCR代理配置的复杂场景未覆盖

#### 具体实施步骤
1. **补充配置验证测试**
2. **添加代理连接测试**
3. **完善错误处理测试**

## 执行顺序和验证

### 执行顺序
1. init.ts (最高影响)
2. auto-updater.ts (最低覆盖率)
3. features.ts (中等影响)
4. ccr/config.ts (CCR功能完善)

### 每阶段验证
```bash
# 运行特定文件测试
pnpm vitest src/commands/init.ts --coverage

# 检查覆盖率报告
pnpm test:coverage

# 验证所有测试通过
pnpm test
```

### 成功标准
- [ ] init.ts 覆盖率达到85%+
- [ ] auto-updater.ts 覆盖率达到80%+
- [ ] features.ts 覆盖率达到85%+
- [ ] ccr/config.ts 覆盖率达到85%+
- [ ] 整体补丁覆盖率达到90%+
- [ ] 所有现有测试继续通过
- [ ] 新增测试稳定可靠

## 风险控制

### 潜在风险
1. 新测试可能影响现有测试
2. Mock配置可能不兼容
3. 平台特定测试可能在CI中失败

### 缓解措施
1. 每个阶段独立验证
2. 使用项目现有Mock模式
3. 添加平台检测和跳过逻辑

## 预期结果

### 覆盖率提升
- 当前：80.03%
- 目标：90%+
- 提升：10%+

### 代码质量改进
- 更好的错误处理测试
- 更完整的边界条件覆盖
- 更稳定的CI/CD流程

---
*执行时间：2025-09-01*
*项目版本：v2.12.4*
*执行者：浮浮酱猫娘工程师*