import UIKit
import Display

private let colors: [UInt32: String] = [
    0x8e0000: "Berry",
    0xdec196: "Brandy",
    0x800b47: "Cherry",
    0xff7f50: "Coral",
    0xdb5079: "Cranberry",
    0xdc143c: "Crimson",
    0xe0b0ff: "Mauve",
    0xffc0cb: "Pink",
    0xff0000: "Red",
    0xff007f: "Rose",
    0x80461b: "Russet",
    0xff2400: "Scarlet",
    0xf1f1f1: "Seashell",
    0xff3399: "Strawberry",
    0xffbf00: "Amber",
    0xeb9373: "Apricot",
    0xfbe7b2: "Banana",
    0xa1c50a: "Citrus",
    0xb06500: "Ginger",
    0xffd700: "Gold",
    0xfde910: "Lemon",
    0xffa500: "Orange",
    0xffe5b4: "Peach",
    0xff6b53: "Persimmon",
    0xe4d422: "Sunflower",
    0xf28500: "Tangerine",
    0xffc87c: "Topaz",
    0xffff00: "Yellow",
    0x384910: "Clover",
    0x83aa5d: "Cucumber",
    0x50c878: "Emerald",
    0xb5b35c: "Olive",
    0x00ff00: "Green",
    0x00a86b: "Jade",
    0x29ab87: "Jungle",
    0xbfff00: "Lime",
    0x0bda51: "Malachite",
    0x98ff98: "Mint",
    0xaddfad: "Moss",
    0x315ba1: "Azure",
    0x0000ff: "Blue",
    0x0047ab: "Cobalt",
    0x4f69c6: "Indigo",
    0x017987: "Lagoon",
    0x71d9e2: "Aquamarine",
    0x120a8f: "Ultramarine",
    0x000080: "Navy",
    0x2f519e: "Sapphire",
    0x76d7ea: "Sky",
    0x008080: "Teal",
    0x40e0d0: "Turquoise",
    0x9966cc: "Amethyst",
    0x4d0135: "Blackberry",
    0x614051: "Eggplant",
    0xc8a2c8: "Lilac",
    0xb57edc: "Lavender",
    0xccccff: "Periwinkle",
    0x843179: "Plum",
    0x660099: "Purple",
    0xd8bfd8: "Thistle",
    0xda70d6: "Orchid",
    0x240a40: "Violet",
    0x3f2109: "Bronze",
    0x370202: "Chocolate",
    0x7b3f00: "Cinnamon",
    0x301f1e: "Cocoa",
    0x706555: "Coffee",
    0x796989: "Rum",
    0x4e0606: "Mahogany",
    0x782d19: "Mocha",
    0xc2b280: "Sand",
    0x882d17: "Sienna",
    0x780109: "Maple",
    0xf0e68c: "Khaki",
    0xb87333: "Copper",
    0xb94e48: "Chestnut",
    0xeed9c4: "Almond",
    0xfffdd0: "Cream",
    0xb9f2ff: "Diamond",
    0xa98307: "Honey",
    0xfffff0: "Ivory",
    0xeae0c8: "Pearl",
    0xeff2f3: "Porcelain",
    0xd1bea8: "Vanilla",
    0xffffff: "White",
    0x808080: "Gray",
    0x000000: "Black",
    0xe8f1d4: "Chrome",
    0x36454f: "Charcoal",
    0x0c0b1d: "Ebony",
    0xc0c0c0: "Silver",
    0xf5f5f5: "Smoke",
    0x262335: "Steel",
    0x4fa83d: "Apple",
    0x80b3c4: "Glacier",
    0xfebaad: "Melon",
    0xc54b8c: "Mulberry",
    0xa9c6c2: "Opal",
    0x54a5f8: "Blue"
]

private let adjectives: [String] = [
    "Ancient",
    "Antique",
    "Autumn",
    "Baby",
    "Barely",
    "Baroque",
    "Blazing",
    "Blushing",
    "Bohemian",
    "Bubbly",
    "Burning",
    "Buttered",
    "Classic",
    "Clear",
    "Cool",
    "Cosmic",
    "Cotton",
    "Cozy",
    "Crystal",
    "Dark",
    "Daring",
    "Darling",
    "Dawn",
    "Dazzling",
    "Deep",
    "Deepest",
    "Delicate",
    "Delightful",
    "Divine",
    "Double",
    "Downtown",
    "Dreamy",
    "Dusky",
    "Dusty",
    "Electric",
    "Enchanted",
    "Endless",
    "Evening",
    "Fantastic",
    "Flirty",
    "Forever",
    "Frigid",
    "Frosty",
    "Frozen",
    "Gentle",
    "Heavenly",
    "Hyper",
    "Icy",
    "Infinite",
    "Innocent",
    "Instant",
    "Luscious",
    "Lunar",
    "Lustrous",
    "Magic",
    "Majestic",
    "Mambo",
    "Midnight",
    "Millenium",
    "Morning",
    "Mystic",
    "Natural",
    "Neon",
    "Night",
    "Opaque",
    "Paradise",
    "Perfect",
    "Perky",
    "Polished",
    "Powerful",
    "Rich",
    "Royal",
    "Sheer",
    "Simply",
    "Sizzling",
    "Solar",
    "Sparkling",
    "Splendid",
    "Spicy",
    "Spring",
    "Stellar",
    "Sugared",
    "Summer",
    "Sunny",
    "Super",
    "Sweet",
    "Tender",
    "Tenacious",
    "Tidal",
    "Toasted",
    "Totally",
    "Tranquil",
    "Tropical",
    "True",
    "Twilight",
    "Twinkling",
    "Ultimate",
    "Ultra",
    "Velvety",
    "Vibrant",
    "Vintage",
    "Virtual",
    "Warm",
    "Warmest",
    "Whipped",
    "Wild",
    "Winsome"
]

private let subjectives: [String] = [
    "Ambrosia",
    "Attack",
    "Avalanche",
    "Blast",
    "Bliss",
    "Blossom",
    "Blush",
    "Burst",
    "Butter",
    "Candy",
    "Carnival",
    "Charm",
    "Chiffon",
    "Cloud",
    "Comet",
    "Delight",
    "Dream",
    "Dust",
    "Fantasy",
    "Flame",
    "Flash",
    "Fire",
    "Freeze",
    "Frost",
    "Glade",
    "Glaze",
    "Gleam",
    "Glimmer",
    "Glitter",
    "Glow",
    "Grande",
    "Haze",
    "Highlight",
    "Ice",
    "Illusion",
    "Intrigue",
    "Jewel",
    "Jubilee",
    "Kiss",
    "Lights",
    "Lollypop",
    "Love",
    "Luster",
    "Madness",
    "Matte",
    "Mirage",
    "Mist",
    "Moon",
    "Muse",
    "Myth",
    "Nectar",
    "Nova",
    "Parfait",
    "Passion",
    "Pop",
    "Rain",
    "Reflection",
    "Rhapsody",
    "Romance",
    "Satin",
    "Sensation",
    "Silk",
    "Shine",
    "Shadow",
    "Shimmer",
    "Sky",
    "Spice",
    "Star",
    "Sugar",
    "Sunrise",
    "Sunset",
    "Sun",
    "Twist",
    "Unbound",
    "Velvet",
    "Vibrant",
    "Waters",
    "Wine",
    "Wink",
    "Wonder",
    "Zone"
]

public func generateThemeName(accentColor: UIColor) -> String {
    var nearest: (color: UInt32, distance: Int32)?
    for (color, _) in colors {
        let distance = accentColor.distance(to: UIColor(rgb: color))
        if let currentNearest = nearest {
            if distance < currentNearest.distance {
                nearest = (color, distance)
            }
        } else {
            nearest = (color, distance)
        }
    }
    
    if let color = nearest?.color, let colorName = colors[color]?.capitalized {
        if arc4random() % 2 == 0 {
            return "\((adjectives.randomElement() ?? "").capitalized) \(colorName)"
        } else {
            return "\(colorName) \((subjectives.randomElement() ?? "").capitalized)"
        }
    } else {
        return ""
    }
}
