/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.dataloader.BatchLoaderContextProvider;
import org.dataloader.CacheKey;
import org.dataloader.CacheMap;
import org.dataloader.ValueCache;
import org.dataloader.ValueCacheOptions;
import org.dataloader.annotations.PublicApi;
import org.dataloader.impl.Assertions;
import org.dataloader.instrumentation.DataLoaderInstrumentation;
import org.dataloader.instrumentation.DataLoaderInstrumentationHelper;
import org.dataloader.scheduler.BatchLoaderScheduler;
import org.dataloader.stats.NoOpStatisticsCollector;
import org.dataloader.stats.StatisticsCollector;

@PublicApi
public class DataLoaderOptions {
    private static final BatchLoaderContextProvider NULL_PROVIDER = () -> null;
    private static final Supplier<StatisticsCollector> NOOP_COLLECTOR = NoOpStatisticsCollector::new;
    private static final ValueCacheOptions DEFAULT_VALUE_CACHE_OPTIONS = ValueCacheOptions.newOptions();
    private final boolean batchingEnabled;
    private final boolean cachingEnabled;
    private final boolean cachingExceptionsEnabled;
    private final CacheKey<?> cacheKeyFunction;
    private final CacheMap<?, ?> cacheMap;
    private final ValueCache<?, ?> valueCache;
    private final int maxBatchSize;
    private final Supplier<StatisticsCollector> statisticsCollector;
    private final BatchLoaderContextProvider environmentProvider;
    private final ValueCacheOptions valueCacheOptions;
    private final BatchLoaderScheduler batchLoaderScheduler;
    private final DataLoaderInstrumentation instrumentation;

    public DataLoaderOptions() {
        this.batchingEnabled = true;
        this.cachingEnabled = true;
        this.cachingExceptionsEnabled = true;
        this.cacheKeyFunction = null;
        this.cacheMap = null;
        this.valueCache = null;
        this.maxBatchSize = -1;
        this.statisticsCollector = NOOP_COLLECTOR;
        this.environmentProvider = NULL_PROVIDER;
        this.valueCacheOptions = DEFAULT_VALUE_CACHE_OPTIONS;
        this.batchLoaderScheduler = null;
        this.instrumentation = DataLoaderInstrumentationHelper.NOOP_INSTRUMENTATION;
    }

    private DataLoaderOptions(Builder builder) {
        this.batchingEnabled = builder.batchingEnabled;
        this.cachingEnabled = builder.cachingEnabled;
        this.cachingExceptionsEnabled = builder.cachingExceptionsEnabled;
        this.cacheKeyFunction = builder.cacheKeyFunction;
        this.cacheMap = builder.cacheMap;
        this.valueCache = builder.valueCache;
        this.maxBatchSize = builder.maxBatchSize;
        this.statisticsCollector = builder.statisticsCollector;
        this.environmentProvider = builder.environmentProvider;
        this.valueCacheOptions = builder.valueCacheOptions;
        this.batchLoaderScheduler = builder.batchLoaderScheduler;
        this.instrumentation = builder.instrumentation;
    }

    public static DataLoaderOptions newDefaultOptions() {
        return new DataLoaderOptions();
    }

    public static Builder newOptions() {
        return new Builder();
    }

    public static Builder newOptions(DataLoaderOptions otherOptions) {
        return new Builder(otherOptions);
    }

    public DataLoaderOptions transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataLoaderOptions that = (DataLoaderOptions)o;
        return this.batchingEnabled == that.batchingEnabled && this.cachingEnabled == that.cachingEnabled && this.cachingExceptionsEnabled == that.cachingExceptionsEnabled && this.maxBatchSize == that.maxBatchSize && Objects.equals(this.cacheKeyFunction, that.cacheKeyFunction) && Objects.equals(this.cacheMap, that.cacheMap) && Objects.equals(this.valueCache, that.valueCache) && Objects.equals(this.statisticsCollector, that.statisticsCollector) && Objects.equals(this.environmentProvider, that.environmentProvider) && Objects.equals(this.valueCacheOptions, that.valueCacheOptions) && Objects.equals(this.batchLoaderScheduler, that.batchLoaderScheduler);
    }

    public boolean batchingEnabled() {
        return this.batchingEnabled;
    }

    public boolean cachingEnabled() {
        return this.cachingEnabled;
    }

    public boolean cachingExceptionsEnabled() {
        return this.cachingExceptionsEnabled;
    }

    public Optional<CacheKey> cacheKeyFunction() {
        return Optional.ofNullable(this.cacheKeyFunction);
    }

    public Optional<CacheMap<?, ?>> cacheMap() {
        return Optional.ofNullable(this.cacheMap);
    }

    public int maxBatchSize() {
        return this.maxBatchSize;
    }

    public StatisticsCollector getStatisticsCollector() {
        return Assertions.nonNull(this.statisticsCollector.get());
    }

    public BatchLoaderContextProvider getBatchLoaderContextProvider() {
        return this.environmentProvider;
    }

    public Optional<ValueCache<?, ?>> valueCache() {
        return Optional.ofNullable(this.valueCache);
    }

    public ValueCacheOptions getValueCacheOptions() {
        return this.valueCacheOptions;
    }

    public BatchLoaderScheduler getBatchLoaderScheduler() {
        return this.batchLoaderScheduler;
    }

    public DataLoaderInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public static class Builder {
        private boolean batchingEnabled;
        private boolean cachingEnabled;
        private boolean cachingExceptionsEnabled;
        private CacheKey<?> cacheKeyFunction;
        private CacheMap<?, ?> cacheMap;
        private ValueCache<?, ?> valueCache;
        private int maxBatchSize;
        private Supplier<StatisticsCollector> statisticsCollector;
        private BatchLoaderContextProvider environmentProvider;
        private ValueCacheOptions valueCacheOptions;
        private BatchLoaderScheduler batchLoaderScheduler;
        private DataLoaderInstrumentation instrumentation;

        public Builder() {
            this(new DataLoaderOptions());
        }

        Builder(DataLoaderOptions other) {
            this.batchingEnabled = other.batchingEnabled;
            this.cachingEnabled = other.cachingEnabled;
            this.cachingExceptionsEnabled = other.cachingExceptionsEnabled;
            this.cacheKeyFunction = other.cacheKeyFunction;
            this.cacheMap = other.cacheMap;
            this.valueCache = other.valueCache;
            this.maxBatchSize = other.maxBatchSize;
            this.statisticsCollector = other.statisticsCollector;
            this.environmentProvider = other.environmentProvider;
            this.valueCacheOptions = other.valueCacheOptions;
            this.batchLoaderScheduler = other.batchLoaderScheduler;
            this.instrumentation = other.instrumentation;
        }

        public Builder setBatchingEnabled(boolean batchingEnabled) {
            this.batchingEnabled = batchingEnabled;
            return this;
        }

        public Builder setCachingEnabled(boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
            return this;
        }

        public Builder setCachingExceptionsEnabled(boolean cachingExceptionsEnabled) {
            this.cachingExceptionsEnabled = cachingExceptionsEnabled;
            return this;
        }

        public Builder setCacheKeyFunction(CacheKey<?> cacheKeyFunction) {
            this.cacheKeyFunction = cacheKeyFunction;
            return this;
        }

        public Builder setCacheMap(CacheMap<?, ?> cacheMap) {
            this.cacheMap = cacheMap;
            return this;
        }

        public Builder setValueCache(ValueCache<?, ?> valueCache) {
            this.valueCache = valueCache;
            return this;
        }

        public Builder setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder setStatisticsCollector(Supplier<StatisticsCollector> statisticsCollector) {
            this.statisticsCollector = statisticsCollector;
            return this;
        }

        public Builder setBatchLoaderContextProvider(BatchLoaderContextProvider environmentProvider) {
            this.environmentProvider = environmentProvider;
            return this;
        }

        public Builder setValueCacheOptions(ValueCacheOptions valueCacheOptions) {
            this.valueCacheOptions = valueCacheOptions;
            return this;
        }

        public Builder setBatchLoaderScheduler(BatchLoaderScheduler batchLoaderScheduler) {
            this.batchLoaderScheduler = batchLoaderScheduler;
            return this;
        }

        public Builder setInstrumentation(DataLoaderInstrumentation instrumentation) {
            this.instrumentation = Assertions.nonNull(instrumentation);
            return this;
        }

        public DataLoaderOptions build() {
            return new DataLoaderOptions(this);
        }
    }
}

