/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.stats;

import java.util.concurrent.atomic.LongAdder;
import org.dataloader.stats.Statistics;
import org.dataloader.stats.StatisticsCollector;
import org.dataloader.stats.context.IncrementBatchLoadCountByStatisticsContext;
import org.dataloader.stats.context.IncrementBatchLoadExceptionCountStatisticsContext;
import org.dataloader.stats.context.IncrementCacheHitCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadErrorCountStatisticsContext;

public class SimpleStatisticsCollector
implements StatisticsCollector {
    private final LongAdder loadCount = new LongAdder();
    private final LongAdder batchInvokeCount = new LongAdder();
    private final LongAdder batchLoadCount = new LongAdder();
    private final LongAdder cacheHitCount = new LongAdder();
    private final LongAdder batchLoadExceptionCount = new LongAdder();
    private final LongAdder loadErrorCount = new LongAdder();

    @Override
    public <K> void incrementLoadCount(IncrementLoadCountStatisticsContext<K> context) {
        this.loadCount.increment();
    }

    @Override
    @Deprecated
    public void incrementLoadCount() {
        this.incrementLoadCount(null);
    }

    @Override
    public <K> void incrementLoadErrorCount(IncrementLoadErrorCountStatisticsContext<K> context) {
        this.loadErrorCount.increment();
    }

    @Override
    @Deprecated
    public void incrementLoadErrorCount() {
        this.incrementLoadErrorCount(null);
    }

    @Override
    public <K> void incrementBatchLoadCountBy(long delta, IncrementBatchLoadCountByStatisticsContext<K> context) {
        this.batchInvokeCount.increment();
        this.batchLoadCount.add(delta);
    }

    @Override
    @Deprecated
    public void incrementBatchLoadCountBy(long delta) {
        this.incrementBatchLoadCountBy(delta, null);
    }

    @Override
    public <K> void incrementBatchLoadExceptionCount(IncrementBatchLoadExceptionCountStatisticsContext<K> context) {
        this.batchLoadExceptionCount.increment();
    }

    @Override
    @Deprecated
    public void incrementBatchLoadExceptionCount() {
        this.incrementBatchLoadExceptionCount(null);
    }

    @Override
    public <K> void incrementCacheHitCount(IncrementCacheHitCountStatisticsContext<K> context) {
        this.cacheHitCount.increment();
    }

    @Override
    @Deprecated
    public void incrementCacheHitCount() {
        this.incrementCacheHitCount(null);
    }

    @Override
    public Statistics getStatistics() {
        return new Statistics(this.loadCount.sum(), this.loadErrorCount.sum(), this.batchInvokeCount.sum(), this.batchLoadCount.sum(), this.batchLoadExceptionCount.sum(), this.cacheHitCount.sum());
    }

    public String toString() {
        return this.getStatistics().toString();
    }
}

