/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.log;

import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Optional;
import org.openqa.selenium.bidi.Event;
import org.openqa.selenium.bidi.log.ConsoleLogEntry;
import org.openqa.selenium.bidi.log.GenericLogEntry;
import org.openqa.selenium.bidi.log.JavascriptLogEntry;
import org.openqa.selenium.bidi.log.LogEntry;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;

public class Log {
    private static final Json JSON = new Json();

    private Log() {
    }

    public static Event<LogEntry> entryAdded() {
        return new Event<LogEntry>("log.entryAdded", params -> {
            String type = (String)params.get("type");
            Optional<GenericLogEntry> genericLogEntry = Optional.empty();
            Optional<ConsoleLogEntry> consoleLogEntry = Optional.empty();
            Optional<JavascriptLogEntry> javascriptLogEntry = Optional.empty();
            if (type != null) {
                try (StringReader reader = new StringReader(JSON.toJson(params));
                     JsonInput input = JSON.newInput(reader);){
                    if ("console".equals(type)) {
                        consoleLogEntry = Optional.ofNullable((ConsoleLogEntry)input.read((Type)((Object)ConsoleLogEntry.class)));
                    } else if ("javascript".equals(type)) {
                        javascriptLogEntry = Optional.ofNullable((JavascriptLogEntry)input.read((Type)((Object)JavascriptLogEntry.class)));
                    } else {
                        genericLogEntry = Optional.ofNullable((GenericLogEntry)input.read((Type)((Object)GenericLogEntry.class)));
                    }
                }
            }
            return new LogEntry(genericLogEntry, consoleLogEntry, javascriptLogEntry);
        });
    }
}

