
Each of these examples are designed to be SELF Contained. 
They contain code that is REPEATED from the other examples. 

There are typically only 1-2 files in each example that are different
from the other examples. See the area between the *** Lines.  

*********************
In this particular example, the only files different from the others are:
1) wb_master_phase_mon.sv in the src directory. 
2) The Environment itself instantiates the monitor and connects it to the VIF.
*****************************************
NONE OF THE OTHER FILES ARE DIFFERENT in these examples from the example in PART_2

The rest of the files are there so that you can just copy the directory over 
and just compile without doing too much work.

I expect you to go modify the monitor in the above file to learn more about UVM




*************************************************************
STEPS TO COMPILE AND RUN EXAMPLE
*************************************************************

Note: 
  1) To include the UVM1.0 inbuilt source from VCS installation:
     Inclusion of UVM_HOME can be replaced by -ntb_opts uvm command in Makefile
  2) To use the UVM source other than VCS installation directory:
     Set environment variable VCS_UVM_HOME to the uvm-1.0 installation directory

*************************************************************
Directory Structure of environment generated by UVMGEN
*************************************************************
-EXAMPLE
  	|
       -README.md ( This file)
       |
       -hdl/        ---> includes top module and inclusion of all environment files.
       |
       | - wb_env_top.sv  -- Top level file that instantiates everything
       | - dut.v     -- Dummy DUT
       |
       -env/        ---> includes environment related files (environment, ralenv)
       |  
       | - wb_slave_agent.sv  -- top level slave agent file
       | - wb_master_agent.sv -- top level master agent file
       | - wb_env_env.sv      -- the complete environment
       |
       -include/
       |
       -src/        ---> includes Transaction, configurations, driver, monitor, master/slave subenv, scoreboard, coverage related files.
       |  
       | - wb_slave.sv     --- Slave driver
       | - wb_slave_mon.sv  -- Slave monitor
       | - wb_slave_if.sv   -- slave interface
       | - wb_transaction.sv  -- transaction class
       | - wb_slave_seqr.sv   -- Slave Sequencer. This is not used in this example
       | - wb_master.sv     -- master driver
       | - wb_master_seqr.sv  -- master sequencer
       | - wb_master_agent_sequence_library.sv -- All the sequences for the master are HERE
       | - wb_master_if.sv  -- master interface
       | - wb_master_phase_mon.sv  -- master monitor
       | - wb_env_cov.sv   -- coverage
       | - wb_env_cfg.sv   -- env config class as an example. Not used much in the example
       |
       -tests/      ---> includes testbench module and testcases 
       |
       | - wb_env_tb_mod.sv 
       | - wb_env_test.sv
       | - wb_env_test_phase_cb.sv   --- This is the actual test you need to look at 
       |
       -run/        ---> Makefile







