/***********************************************
 *                                              *
 * Examples for the book Practical UVM          *
 *                                              *
 * Copyright Srivatsa Vasudevan 2010-2016       *
 * All rights reserved                          *
 *                                              *
 * Permission is granted to use this work       * 
 * provided this notice and attached license.txt*
 * are not removed/altered while redistributing *
 * See license.txt for details                  *
 *                                              *
 ************************************************/

/////////////////////////////////////////////////////////////////////
//
// WISHBONE Inter Connect
//

module wb_conmax_wrap(wb_master_if mast_if0,mast_if1,mast_if2,mast_if3,
		      mast_if4,mast_if5,mast_if6,mast_if7,
		      wb_slave_if slave_if0,slave_if1,slave_if2,slave_if3,
		      slave_if4,slave_if5,slave_if6,slave_if7,
		      slave_if8,slave_if9,slave_if10,slave_if11,
		      slave_if12,slave_if13,slave_if14,slave_if15, 
		      input bit clk,input bit rst);

   wb_conmax_top	#(32,
			  32,
			  4'hf,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2,
			  2'd2
			  ) dut (
				 .clk_i(		clk		),
				 .rst_i(		rst		),
				 .m0_data_i(mast_if0.DAT_O ),
				 .m0_data_o(mast_if0.DAT_I),
				 .m0_addr_i(mast_if0.ADR_O),
				 .m0_sel_i(mast_if0.SEL_O),
				 .m0_we_i(mast_if0.WE_O),
				 .m0_cyc_i(mast_if0.CYC_O),
				 .m0_stb_i(mast_if0.STB_O),
				 .m0_ack_o(mast_if0.ACK_I),
				 .m0_err_o(mast_if0.ERR_I),
				 .m0_rty_o(mast_if0.RTY_I),
				 
				 .m1_data_i(mast_if1.DAT_O ),
				 .m1_data_o(mast_if1.DAT_I),
				 .m1_addr_i(mast_if1.ADR_O),
				 .m1_sel_i(mast_if1.SEL_O),
				 .m1_we_i(mast_if1.WE_O),
				 .m1_cyc_i(mast_if1.CYC_O),
				 .m1_stb_i(mast_if1.STB_O),
				 .m1_ack_o(mast_if1.ACK_I),
				 .m1_err_o(mast_if1.ERR_I),
				 .m1_rty_o(mast_if1.RTY_I),
				 
				 .m2_data_i(mast_if2.DAT_O ),
				 .m2_data_o(mast_if2.DAT_I),
				 .m2_addr_i(mast_if2.ADR_O),
				 .m2_sel_i(mast_if2.SEL_O),
				 .m2_we_i(mast_if2.WE_O),
				 .m2_cyc_i(mast_if2.CYC_O),
				 .m2_stb_i(mast_if2.STB_O),
				 .m2_ack_o(mast_if2.ACK_I),
				 .m2_err_o(mast_if2.ERR_I),
				 .m2_rty_o(mast_if2.RTY_I),
				 
				 .m3_data_i(mast_if3.DAT_O ),
				 .m3_data_o(mast_if3.DAT_I),
				 .m3_addr_i(mast_if3.ADR_O),
				 .m3_sel_i(mast_if3.SEL_O),
				 .m3_we_i(mast_if3.WE_O),
				 .m3_cyc_i(mast_if3.CYC_O),
				 .m3_stb_i(mast_if3.STB_O),
				 .m3_ack_o(mast_if3.ACK_I),
				 .m3_err_o(mast_if3.ERR_I),
				 .m3_rty_o(mast_if3.RTY_I),
				 
				 .m4_data_i(mast_if4.DAT_O ),
				 .m4_data_o(mast_if4.DAT_I),
				 .m4_addr_i(mast_if4.ADR_O),
				 .m4_sel_i(mast_if4.SEL_O),
				 .m4_we_i(mast_if4.WE_O),
				 .m4_cyc_i(mast_if4.CYC_O),
				 .m4_stb_i(mast_if4.STB_O),
				 .m4_ack_o(mast_if4.ACK_I),
				 .m4_err_o(mast_if4.ERR_I),
				 .m4_rty_o(mast_if4.RTY_I),
				 
				 .m5_data_i(mast_if5.DAT_O ),
				 .m5_data_o(mast_if5.DAT_I),
				 .m5_addr_i(mast_if5.ADR_O),
				 .m5_sel_i(mast_if5.SEL_O),
				 .m5_we_i(mast_if5.WE_O),
				 .m5_cyc_i(mast_if5.CYC_O),
				 .m5_stb_i(mast_if5.STB_O),
				 .m5_ack_o(mast_if5.ACK_I),
				 .m5_err_o(mast_if5.ERR_I),
				 .m5_rty_o(mast_if5.RTY_I),
				 
				 .m6_data_i(mast_if6.DAT_O ),
				 .m6_data_o(mast_if6.DAT_I),
				 .m6_addr_i(mast_if6.ADR_O),
				 .m6_sel_i(mast_if6.SEL_O),
				 .m6_we_i(mast_if6.WE_O),
				 .m6_cyc_i(mast_if6.CYC_O),
				 .m6_stb_i(mast_if6.STB_O),
				 .m6_ack_o(mast_if6.ACK_I),
				 .m6_err_o(mast_if6.ERR_I),
				 .m6_rty_o(mast_if6.RTY_I),
				 
				 .m7_data_i(mast_if7.DAT_O ),
				 .m7_data_o(mast_if7.DAT_I),
				 .m7_addr_i(mast_if7.ADR_O),
				 .m7_sel_i(mast_if7.SEL_O),
				 .m7_we_i(mast_if7.WE_O),
				 .m7_cyc_i(mast_if7.CYC_O),
				 .m7_stb_i(mast_if7.STB_O),
				 .m7_ack_o(mast_if7.ACK_I),
				 .m7_err_o(mast_if7.ERR_I),
				 .m7_rty_o(mast_if7.RTY_I),
				 
				 .s0_data_i(slave_if0.DAT_O ),
				 .s0_data_o(slave_if0.DAT_I),
				 .s0_addr_o(slave_if0.ADR_I),
				 .s0_sel_o(slave_if0.SEL_I),
				 .s0_we_o(slave_if0.WE_I),
				 .s0_cyc_o(slave_if0.CYC_I),
				 .s0_stb_o(slave_if0.STB_I),
				 .s0_ack_i(slave_if0.ACK_O),
				 .s0_err_i(slave_if0.ERR_O),
				 .s0_rty_i(slave_if0.RTY_O),
				 
				 .s1_data_i(slave_if1.DAT_O ),
				 .s1_data_o(slave_if1.DAT_I),
				 .s1_addr_o(slave_if1.ADR_I),
				 .s1_sel_o(slave_if1.SEL_I),
				 .s1_we_o(slave_if1.WE_I),
				 .s1_cyc_o(slave_if1.CYC_I),
				 .s1_stb_o(slave_if1.STB_I),
				 .s1_ack_i(slave_if1.ACK_O),
				 .s1_err_i(slave_if1.ERR_O),
				 .s1_rty_i(slave_if1.RTY_O),
				 
				 .s2_data_i(slave_if2.DAT_O ),
				 .s2_data_o(slave_if2.DAT_I),
				 .s2_addr_o(slave_if2.ADR_I),
				 .s2_sel_o(slave_if2.SEL_I),
				 .s2_we_o(slave_if2.WE_I),
				 .s2_cyc_o(slave_if2.CYC_I),
				 .s2_stb_o(slave_if2.STB_I),
				 .s2_ack_i(slave_if2.ACK_O),
				 .s2_err_i(slave_if2.ERR_O),
				 .s2_rty_i(slave_if2.RTY_O),
				 
				 .s3_data_i(slave_if3.DAT_O ),
				 .s3_data_o(slave_if3.DAT_I),
				 .s3_addr_o(slave_if3.ADR_I),
				 .s3_sel_o(slave_if3.SEL_I),
				 .s3_we_o(slave_if3.WE_I),
				 .s3_cyc_o(slave_if3.CYC_I),
				 .s3_stb_o(slave_if3.STB_I),
				 .s3_ack_i(slave_if3.ACK_O),
				 .s3_err_i(slave_if3.ERR_O),
				 .s3_rty_i(slave_if3.RTY_O),
				 
				 .s4_data_i(slave_if4.DAT_O ),
				 .s4_data_o(slave_if4.DAT_I),
				 .s4_addr_o(slave_if4.ADR_I),
				 .s4_sel_o(slave_if4.SEL_I),
				 .s4_we_o(slave_if4.WE_I),
				 .s4_cyc_o(slave_if4.CYC_I),
				 .s4_stb_o(slave_if4.STB_I),
				 .s4_ack_i(slave_if4.ACK_O),
				 .s4_err_i(slave_if4.ERR_O),
				 .s4_rty_i(slave_if4.RTY_O),
				 
				 .s5_data_i(slave_if5.DAT_O ),
				 .s5_data_o(slave_if5.DAT_I),
				 .s5_addr_o(slave_if5.ADR_I),
				 .s5_sel_o(slave_if5.SEL_I),
				 .s5_we_o(slave_if5.WE_I),
				 .s5_cyc_o(slave_if5.CYC_I),
				 .s5_stb_o(slave_if5.STB_I),
				 .s5_ack_i(slave_if5.ACK_O),
				 .s5_err_i(slave_if5.ERR_O),
				 .s5_rty_i(slave_if5.RTY_O),
				 
				 .s6_data_i(slave_if6.DAT_O ),
				 .s6_data_o(slave_if6.DAT_I),
				 .s6_addr_o(slave_if6.ADR_I),
				 .s6_sel_o(slave_if6.SEL_I),
				 .s6_we_o(slave_if6.WE_I),
				 .s6_cyc_o(slave_if6.CYC_I),
				 .s6_stb_o(slave_if6.STB_I),
				 .s6_ack_i(slave_if6.ACK_O),
				 .s6_err_i(slave_if6.ERR_O),
				 .s6_rty_i(slave_if6.RTY_O),
				 
				 .s7_data_i(slave_if7.DAT_O ),
				 .s7_data_o(slave_if7.DAT_I),
				 .s7_addr_o(slave_if7.ADR_I),
				 .s7_sel_o(slave_if7.SEL_I),
				 .s7_we_o(slave_if7.WE_I),
				 .s7_cyc_o(slave_if7.CYC_I),
				 .s7_stb_o(slave_if7.STB_I),
				 .s7_ack_i(slave_if7.ACK_O),
				 .s7_err_i(slave_if7.ERR_O),
				 .s7_rty_i(slave_if7.RTY_O),
				 
				 .s8_data_i(slave_if8.DAT_O ),
				 .s8_data_o(slave_if8.DAT_I),
				 .s8_addr_o(slave_if8.ADR_I),
				 .s8_sel_o(slave_if8.SEL_I),
				 .s8_we_o(slave_if8.WE_I),
				 .s8_cyc_o(slave_if8.CYC_I),
				 .s8_stb_o(slave_if8.STB_I),
				 .s8_ack_i(slave_if8.ACK_O),
				 .s8_err_i(slave_if8.ERR_O),
				 .s8_rty_i(slave_if8.RTY_O),
				 
				 .s9_data_i(slave_if9.DAT_O ),
				 .s9_data_o(slave_if9.DAT_I),
				 .s9_addr_o(slave_if9.ADR_I),
				 .s9_sel_o(slave_if9.SEL_I),
				 .s9_we_o(slave_if9.WE_I),
				 .s9_cyc_o(slave_if9.CYC_I),
				 .s9_stb_o(slave_if9.STB_I),
				 .s9_ack_i(slave_if9.ACK_O),
				 .s9_err_i(slave_if9.ERR_O),
				 .s9_rty_i(slave_if9.RTY_O),
				 
				 .s10_data_i(slave_if10.DAT_O ),
				 .s10_data_o(slave_if10.DAT_I),
				 .s10_addr_o(slave_if10.ADR_I),
				 .s10_sel_o(slave_if10.SEL_I),
				 .s10_we_o(slave_if10.WE_I),
				 .s10_cyc_o(slave_if10.CYC_I),
				 .s10_stb_o(slave_if10.STB_I),
				 .s10_ack_i(slave_if10.ACK_O),
				 .s10_err_i(slave_if10.ERR_O),
				 .s10_rty_i(slave_if10.RTY_O),
				 
				 .s11_data_i(slave_if11.DAT_O ),
				 .s11_data_o(slave_if11.DAT_I),
				 .s11_addr_o(slave_if11.ADR_I),
				 .s11_sel_o(slave_if11.SEL_I),
				 .s11_we_o(slave_if11.WE_I),
				 .s11_cyc_o(slave_if11.CYC_I),
				 .s11_stb_o(slave_if11.STB_I),
				 .s11_ack_i(slave_if11.ACK_O),
				 .s11_err_i(slave_if11.ERR_O),
				 .s11_rty_i(slave_if11.RTY_O),
				 
				 .s12_data_i(slave_if12.DAT_O ),
				 .s12_data_o(slave_if12.DAT_I),
				 .s12_addr_o(slave_if12.ADR_I),
				 .s12_sel_o(slave_if12.SEL_I),
				 .s12_we_o(slave_if12.WE_I),
				 .s12_cyc_o(slave_if12.CYC_I),
				 .s12_stb_o(slave_if12.STB_I),
				 .s12_ack_i(slave_if12.ACK_O),
				 .s12_err_i(slave_if12.ERR_O),
				 .s12_rty_i(slave_if12.RTY_O),
				 
				 .s13_data_i(slave_if13.DAT_O ),
				 .s13_data_o(slave_if13.DAT_I),
				 .s13_addr_o(slave_if13.ADR_I),
				 .s13_sel_o(slave_if13.SEL_I),
				 .s13_we_o(slave_if13.WE_I),
				 .s13_cyc_o(slave_if13.CYC_I),
				 .s13_stb_o(slave_if13.STB_I),
				 .s13_ack_i(slave_if13.ACK_O),
				 .s13_err_i(slave_if13.ERR_O),
				 .s13_rty_i(slave_if13.RTY_O),
				 
				 .s14_data_i(slave_if14.DAT_O ),
				 .s14_data_o(slave_if14.DAT_I),
				 .s14_addr_o(slave_if14.ADR_I),
				 .s14_sel_o(slave_if14.SEL_I),
				 .s14_we_o(slave_if14.WE_I),
				 .s14_cyc_o(slave_if14.CYC_I),
				 .s14_stb_o(slave_if14.STB_I),
				 .s14_ack_i(slave_if14.ACK_O),
				 .s14_err_i(slave_if14.ERR_O),
				 .s14_rty_i(slave_if14.RTY_O),
				 
				 .s15_data_i(slave_if15.DAT_O ),
				 .s15_data_o(slave_if15.DAT_I),
				 .s15_addr_o(slave_if15.ADR_I),
				 .s15_sel_o(slave_if15.SEL_I),
				 .s15_we_o(slave_if15.WE_I),
				 .s15_cyc_o(slave_if15.CYC_I),
				 .s15_stb_o(slave_if15.STB_I),
				 .s15_ack_i(slave_if15.ACK_O),
				 .s15_err_i(slave_if15.ERR_O),
				 .s15_rty_i(slave_if15.RTY_O)
				 );

   
endmodule

