<!-- markdownlint-disable MD033 MD041 -->
<p align="center">
  <img alt="LOGO" src="https://cdn.jsdelivr.net/gh/MaaAssistantArknights/design@main/logo/maa-logo_512x512.png" width="256" height="256" />
</p>

<div align="center">

# MaaFramework

<!-- prettier-ignore-start -->
<!-- markdownlint-disable-next-line MD036 -->
_✨ 基于图像识别的自动化黑盒测试框架 ✨_
<!-- prettier-ignore-end -->

</div>

<p align="center">
  <img alt="C++" src="https://img.shields.io/badge/C++-20-%2300599C?logo=cplusplus">
  <img alt="platform" src="https://img.shields.io/badge/platform-Windows%20%7C%20Linux%20%7C%20macOS%20%7C%20Android-blueviolet">
  <br>
  <img alt="license" src="https://img.shields.io/github/license/MaaXYZ/MaaFramework">
  <img alt="activity" src="https://img.shields.io/github/commit-activity/m/MaaXYZ/MaaFramework?color=%23ff69b4">
  <img alt="stars" src="https://img.shields.io/github/stars/MaaXYZ/MaaFramework?style=social">
  <br>
  <a href="https://pypi.org/project/MaaFw/" target="_blank"><img alt="pypi" src="https://img.shields.io/badge/PyPI-3775A9?logo=pypi&logoColor=white"></a>
  <a href="https://www.nuget.org/packages/Maa.Framework.Runtimes" target="_blank"><img alt="nuget" src="https://img.shields.io/badge/NuGet-004880?logo=nuget"></a>
  <a href="https://www.npmjs.com/package/@maaxyz/maa-node" target="_blank"><img alt="npm" src="https://img.shields.io/badge/npm-CB3837?logo=npm"></a>
  <a href="https://mirrorchyan.com/zh/projects?source=maafw-badge" target="_blank"><img alt="mirrorc" src="https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5"></a>
</p>

<div align="center">

[English](./README_en.md) | [简体中文](./README.md)

</div>

## 简介

**MaaFramework** 是基于图像识别技术、运用 [MAA](https://github.com/MaaAssistantArknights/MaaAssistantArknights) 开发经验去芜存菁、完全重写的新一代自动化黑盒测试框架。

低代码的同时仍拥有高扩展性，旨在打造一款丰富、领先、且实用的开源库，助力开发者轻松编写出更好的黑盒测试程序，并推广普及。

## 即刻开始

- [快速开始](docs/zh_cn/1.1-快速开始.md)
- [集成文档](docs/zh_cn/2.1-集成文档.md)
- [Pipeline 协议](docs/zh_cn/3.1-任务流水线协议.md)

## 社区项目

### 通用 UI

- [MFAWPF](https://github.com/SweetSmellFox/MFAWPF) ![csharp](https://img.shields.io/badge/C%23-239120?logo=csharp&logoColor=white) ![license](https://img.shields.io/github/license/SweetSmellFox/MFAWPF) ![activity](https://img.shields.io/github/commit-activity/m/SweetSmellFox/MFAWPF?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/SweetSmellFox/MFAWPF?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  基于 MAA 全新架构的 通用 GUI。由 MaaFramework 强力驱动！

- [MFW-CFA](https://github.com/overflow65537/MFW-PyQt6) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/overflow65537/MFW-PyQt6) ![activity](https://img.shields.io/github/commit-activity/m/overflow65537/MFW-PyQt6?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/overflow65537/MFW-PyQt6?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  基于PySide6的通用GUI。由 MaaFramework 强力驱动！

- [MFAAvalonia](https://github.com/SweetSmellFox/MFAAvalonia) ![csharp](https://img.shields.io/badge/C%23-239120?logo=csharp&logoColor=white) ![license](https://img.shields.io/github/license/SweetSmellFox/MFAAvalonia) ![activity](https://img.shields.io/github/commit-activity/m/SweetSmellFox/MFAAvalonia?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/SweetSmellFox/MFAAvalonia?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  基于 Avalonia 的 通用 GUI。由 MaaFramework 强力驱动！

### 开发工具

- [MaaDebugger](https://github.com/MaaXYZ/MaaDebugger) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/MaaXYZ/MaaDebugger) ![activity](https://img.shields.io/github/commit-activity/m/MaaXYZ/MaaDebugger?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/MaaXYZ/MaaDebugger?style=social) [![pypi](https://img.shields.io/badge/PyPI-3776AB?logo=pypi&logoColor=white)](https://pypi.org/project/MaaDebugger/)  
  MaaFramework Pipeline 调试器

- [maa-support-extension](https://github.com/neko-para/maa-support-extension) ![Typescript](https://img.shields.io/badge/Typescript-8A2BE2?logo=typescript) ![activity](https://img.shields.io/github/commit-activity/m/neko-para/maa-support-extension?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/neko-para/maa-support-extension?style=social) [![marketplace](https://img.shields.io/badge/Visual%20Studio%20Marketplace-black?logo=vscodium&logoColor=#2F80ED)](https://marketplace.visualstudio.com/items?itemName=nekosu.maa-support)  
  MaaFramework VSCode 插件

- [MFATools](https://github.com/SweetSmellFox/MFATools) ![csharp](https://img.shields.io/badge/C%23-239120?logo=csharp&logoColor=white) ![license](https://img.shields.io/github/license/SweetSmellFox/MFATools) ![activity](https://img.shields.io/github/commit-activity/m/SweetSmellFox/MFATools?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/SweetSmellFox/MFATools?style=social)  
  基于WPF框架开发的工具界面，旨在提供类似于截图工具的功能

- [MaaPipelineEditor](https://github.com/kqcoxn/MaaPipelineEditor) ![Typescript](https://img.shields.io/badge/Typescript-8A2BE2?logo=typescript) ![activity](https://img.shields.io/github/commit-activity/m/kqcoxn/MaaPipelineEditor?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/kqcoxn/MaaPipelineEditor?style=social)  
  基于 react-flow 的 MaaFramework Pipeline 工作流式可视化编辑器，使用“无代码”流程图构建您的 Pipeline！

### 应用程序

- [M9A](https://github.com/MaaXYZ/M9A) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/MaaXYZ/M9A) ![activity](https://img.shields.io/github/commit-activity/m/MaaXYZ/M9A?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/MaaXYZ/M9A?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge) [![website](https://img.shields.io/badge/https://1999.fan-%234285F4)](https://1999.fan)  
  亿韭韭韭 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MAS](https://github.com/MaaXYZ/MaaAssistantSkland) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/MaaXYZ/MaaAssistantSkland) ![activity](https://img.shields.io/github/commit-activity/m/MaaXYZ/MaaAssistantSkland?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/MaaXYZ/MaaAssistantSkland?style=social)  
  森空岛 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MSBA](https://github.com/overflow65537/MAA_SnowBreak) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF)![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/overflow65537/MAA_SnowBreak) ![activity](https://img.shields.io/github/commit-activity/m/overflow65537/MAA_SnowBreak?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/overflow65537/MAA_SnowBreak?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  尘白禁区 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MaaYYs](https://github.com/TanyaShue/MaaYYs) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![qt](https://img.shields.io/badge/Qt6-41CD52?logo=Qt&logoColor=white) ![license](https://img.shields.io/github/license/TanyaShue/MaaYYs) ![activity](https://img.shields.io/github/commit-activity/m/TanyaShue/MaaYYs?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/TanyaShue/MaaYYs?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  阴阳师小助手。图像技术 + 模拟控制，当赛博屯屯鼠，自动日常，解放你的双手！由 MaaFramework 强力驱动！

- [MRA](https://github.com/Saratoga-Official/MRA) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/Saratoga-Official/MRA) ![activity](https://img.shields.io/github/commit-activity/m/Saratoga-Official/MRA?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/Saratoga-Official/MRA?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  战舰少女R 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MPA](https://github.com/overflow65537/MAA_Punish) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/overflow65537/MAA_Punish) ![activity](https://img.shields.io/github/commit-activity/m/overflow65537/MAA_Punish?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/overflow65537/MAA_Punish?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  战双帕弥什 小助手。图像技术 + 模拟控制，解放双手！由 玛丽的黑咖啡 2.0 强力驱动！

- [MaaYuan](https://github.com/syoius/MaaYuan) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/syoius/MaaYuan) ![activity](https://img.shields.io/github/commit-activity/m/syoius/MaaYuan?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/syoius/MaaYuan?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge) [![website](https://img.shields.io/badge/https://maayuan.top-%234285F4)](https://maayuan.top)  
  代号鸢/如鸢 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [Maa-HBR](https://github.com/KarylDAZE/Maa-HBR) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/KarylDAZE/Maa-HBR) ![activity](https://img.shields.io/github/commit-activity/m/KarylDAZE/Maa-HBR?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/KarylDAZE/Maa-HBR?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  炽焰天穹/HBR 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MaaGF2Exilium](https://github.com/DarkLingYun/MaaGF2Exilium) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/DarkLingYun/MaaGF2Exilium) ![activity](https://img.shields.io/github/commit-activity/m/DarkLingYun/MaaGF2Exilium?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/DarkLingYun/MaaGF2Exilium?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  少女前线2: 追放自动化助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MaaAshEchoes](https://github.com/moulai/MaaAshEchoes) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/moulai/MaaAshEchoes) ![activity](https://img.shields.io/github/commit-activity/m/moulai/MaaAshEchoes?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/moulai/MaaAshEchoes?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  白荆回廊 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MaaXuexi](https://github.com/ravizhan/MaaXuexi) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/ravizhan/MaaXuexi) ![activity](https://img.shields.io/github/commit-activity/m/ravizhan/MaaXuexi?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/ravizhan/MaaXuexi?style=social)  
  学习强国 自动化助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MACC](https://github.com/mxia9416/MACC) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/mxia9416/MACC) ![activity](https://img.shields.io/github/commit-activity/m/mxia9416/MACC?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/mxia9416/MACC?style=social)  
  无期迷途 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MAA_MHXY_MG](https://github.com/gitlihang/Maa_MHXY_MG) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/gitlihang/Maa_MHXY_MG) ![activity](https://img.shields.io/github/commit-activity/m/gitlihang/Maa_MHXY_MG?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/gitlihang/Maa_MHXY_MG?style=social)  
  梦幻西游手游 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MNMA](https://github.com/kqcoxn/MaaNewMoonAccompanying) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/kqcoxn/MaaNewMoonAccompanying) ![activity](https://img.shields.io/github/commit-activity/m/kqcoxn/MaaNewMoonAccompanying?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/kqcoxn/MaaNewMoonAccompanying?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  新月同行 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MaaTOT](https://github.com/Coxwtwo/MaaTOT) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/Coxwtwo/MaaTOT) ![activity](https://img.shields.io/github/commit-activity/m/Coxwtwo/MaaTOT?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/Coxwtwo/MaaTOT?style=social)  
  未定事件簿 小助手。图像技术 + 模拟控制，解放双手！由 MaaFramework 强力驱动！

- [MaaGumballs](https://github.com/KhazixW2/MaaGumballs) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![Python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/KhazixW2/MaaGumballs) ![activity](https://img.shields.io/github/commit-activity/m/KhazixW2/MaaGumballs?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/KhazixW2/MaaGumballs?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  不思议迷宫小助手是一款由图像识别与模拟控制技术驱动的辅助工具。它能够帮助大家解放双手，一键开启敲砖大冒险，由 MaaFramework 强力支持。

- [MMleo](https://github.com/fictionalflaw/MMleo) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![Python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/fictionalflaw/MMleo) ![activity](https://img.shields.io/github/commit-activity/m/fictionalflaw/MMleo?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/fictionalflaw/MMleo?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge)  
  偶像梦幻祭2小助手。使用图像识别+模拟控制技术，解放双手！助力屯屯鼠的制作人生涯！由 MaaFramework 强力驱动！

- [autodori](https://github.com/EvATive7/autodori) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![Python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/EvATive7/autodori) ![activity](https://img.shields.io/github/commit-activity/m/EvATive7/autodori?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/EvATive7/autodori?style=social)  
  BanG Dream邦多利小助手。图像识别+模拟控制，解放双手！由 MaaFramework、弦卷财団、TGW Group 强力驱动！

- [SLIMEIM_Maa](https://github.com/miaojiuqing/SLIMEIM_Maa) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![Python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/miaojiuqing/SLIMEIM_Maa) ![activity](https://img.shields.io/github/commit-activity/m/miaojiuqing/SLIMEIM_Maa?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/miaojiuqing/SLIMEIM_Maa?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/zh/projects?source=maafw-badge&rid=SLIMEIM_Maa)  
  魔王与龙的建国谭小助手。使用图像识别+模拟控制技术，解放双手！由 MaaFramework 强力驱动！


## 生态共建

MAA 正计划建设为一类项目，而非舟的单一软件。  

若您的项目依赖于 MaaFramework ，我们欢迎您将它命名为 MaaXXX, MXA, MAX 等等。当然，这是许可而不是限制，您也可以自由选择其他与 MAA 无关的名字，完全取决于您自己的想法！  

同时，我们也非常欢迎您提出 PR ，在上方的社区项目列表中添加上您的项目！

## 声明与许可

### 开源许可

本项目采用 [`LGPL-3.0`](./LICENSE.md) 许可证进行开源。

### 分发说明

本项目支持 GPU 加速功能，其在 Windows 平台上依赖于 Microsoft 提供的独立组件 [DirectML](https://learn.microsoft.com/en-us/windows/ai/directml/)。DirectML 并非本项目的开源部分，也不受 LGPL-3.0 的约束。为方便用户，我们随安装包附带了一个未经修改的 DirectML.dll 文件。如果您无需 GPU 加速功能，可安全删除该 DLL 文件，软件的核心功能仍可正常运行。

### 免责声明

#### 预期用途

本项目旨在为软件开发提供**自动化黑盒测试工具**，包括图像识别、界面操作模拟等合法技术场景。开发者应确保其使用方式符合所有适用法律法规及目标软件的服务条款。

#### 禁止滥用

禁止将本项目用于以下用途（包括但不限于）：

- 破坏、绕过或干扰任何软件、游戏、服务的正常功能（如反作弊机制、授权验证系统）。
- 开发或分发违反第三方服务条款的工具（如游戏外挂、作弊器、自动化脚本）。
- 任何侵犯他人合法权益或违反法律的行为（如数据窃取、网络攻击）。

#### 责任豁免

本项目按“原样”提供，作者**不承担**因以下行为导致的任何直接、间接或衍生责任：

- 使用者违反本声明或法律法规的行为。
- 第三方利用本项目开发的工具造成的损害（如账号封禁、法律纠纷）。
- 因使用本项目导致的任何技术或经济损失。

#### 用户义务

使用本项目即表示您同意：

- 自行承担所有使用风险。
- 确保您的应用场景合法，并已获得相关授权（如目标软件厂商的许可）。
- 若您的行为导致法律纠纷，您应独立承担责任并免除本项目作者的一切责任。

## 开发

_请留意，仅当您准备开发 MaaFramework 本身时，才需要阅读本章节内容。若您仅希望基于 MaaFramework 开发自己的应用，则请参考 [即刻开始](#即刻开始)。_

- [构建指南](docs/zh_cn/4.1-构建指南.md)
- [接口设计](docs/zh_cn/4.2-标准化接口设计.md)

## 鸣谢

### 开源库

- [opencv](https://github.com/opencv/opencv)  
  Open Source Computer Vision Library
- [fastdeploy](https://github.com/PaddlePaddle/FastDeploy)  
  ⚡️An Easy-to-use and Fast Deep Learning Model Deployment Toolkit for ☁️Cloud 📱Mobile and 📹Edge.
- [onnxruntime](https://github.com/microsoft/onnxruntime)  
  ONNX Runtime: cross-platform, high performance ML inferencing and training accelerator
- [boost](https://www.boost.org/)  
  Boost provides free peer-reviewed portable C++ source libraries.
- [libzmq](https://github.com/zeromq/libzmq)  
  ZeroMQ core engine in C++, implements ZMTP/3.1
- [cppzmq](https://github.com/zeromq/cppzmq)  
  Header-only C++ binding for libzmq
- [meojson](https://github.com/MistEO/meojson)  
  ✨ Next-gen C++ JSON/JSON5 Serialization Engine | Zero Dependency | Header-Only | Unleash JSON Potential
- [minitouch](https://github.com/DeviceFarmer/minitouch)  
  Minimal multitouch event producer for Android.
- [maatouch](https://github.com/MaaAssistantArknights/MaaTouch)  
  Android native implementation of minitouch input protocol
- [minicap](https://github.com/DeviceFarmer/minicap)  
  Stream real-time screen capture data out of Android devices.
- [zlib](https://github.com/madler/zlib)  
  A massively spiffy yet delicately unobtrusive compression library.
- [gzip-hpp](https://github.com/mapbox/gzip-hpp)  
  Gzip header-only C++ library
- ~~[protobuf](https://github.com/protocolbuffers/protobuf)~~  
  ~~Protocol Buffers - Google's data interchange format~~
- ~~[grpc](https://github.com/grpc/grpc)~~  
  ~~The C based gRPC (C++, Python, Ruby, Objective-C, PHP, C#)~~
- ~~[thrift](https://github.com/apache/thrift)~~  
  ~~Apache Thrift~~

### 开发者

感谢以下开发者对 MaaFramework 作出的贡献：

[![贡献者](https://contrib.rocks/image?repo=MaaXYZ/MaaFramework&max=1000)](https://github.com/MaaXYZ/MaaFramework/graphs/contributors)

## 讨论

- 集成/开发交流 QQ 群: 595990173

## 赞助

<!-- markdownlint-disable MD045 -->
<a href="https://afdian.com/a/misteo">
  <img width="200" src="https://pic1.afdiancdn.com/static/img/welcome/button-sponsorme.png">
</a>
