<!-- markdownlint-disable MD033 MD041 -->
<p align="center">
  <img alt="LOGO" src="https://cdn.jsdelivr.net/gh/MaaAssistantArknights/design@main/logo/maa-logo_512x512.png" width="256" height="256" />
</p>

<div align="center">

# MaaFramework

<!-- prettier-ignore-start -->
<!-- markdownlint-disable-next-line MD036 -->
_✨ An automation black-box testing framework based on image recognition ✨_
<!-- prettier-ignore-end -->

</div>

<p align="center">
  <img alt="C++" src="https://img.shields.io/badge/C++-20-%2300599C?logo=cplusplus">
  <img alt="platform" src="https://img.shields.io/badge/platform-Windows%20%7C%20Linux%20%7C%20macOS%20%7C%20Android-blueviolet">
  <br>
  <img alt="license" src="https://img.shields.io/github/license/MaaXYZ/MaaFramework">
  <img alt="activity" src="https://img.shields.io/github/commit-activity/m/MaaXYZ/MaaFramework?color=%23ff69b4">
  <img alt="stars" src="https://img.shields.io/github/stars/MaaXYZ/MaaFramework?style=social">
  <br>
  <a href="https://pypi.org/project/MaaFw/" target="_blank"><img alt="pypi" src="https://img.shields.io/badge/PyPI-3775A9?logo=pypi&logoColor=white"></a>
  <a href="https://www.nuget.org/packages/Maa.Framework.Runtimes" target="_blank"><img alt="nuget" src="https://img.shields.io/badge/NuGet-004880?logo=nuget"></a>
  <a href="https://www.npmjs.com/package/@maaxyz/maa-node" target="_blank"><img alt="npm" src="https://img.shields.io/badge/npm-CB3837?logo=npm"></a>
  <a href="https://mirrorchyan.com/en/projects?source=maafw-badge" target="_blank"><img alt="mirrorc" src="https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5"></a>
</p>

<div align="center">

[English](./README_en.md) | [简体中文](./README.md)

</div>

> This document is a machine-translated version of the original Chinese text. In case of any discrepancies, omissions, or ambiguities, [the Chinese version](./README.md) shall prevail.

## Introduction

**MaaFramework** is a next-generation automation black-box testing framework, completely rewritten and refined based on image recognition technology and the development experience of [MAA](https://github.com/MaaAssistantArknights/MaaAssistantArknights).

It offers low-code simplicity while maintaining high extensibility. The framework aims to create a rich, leading-edge, and practical open-source library, empowering developers to easily write better black-box test programs and promoting widespread use.

## Get Started

- [Quick Start](docs/en_us/1.1-QuickStarted.md)
- [Integration](docs/en_us/2.1-Integration.md)
- [Pipeline Protocol](docs/en_us/3.1-PipelineProtocol.md)

## Community Project

### Generic UI

- [MFAWPF](https://github.com/SweetSmellFox/MFAWPF) ![csharp](https://img.shields.io/badge/C%23-239120?logo=csharp&logoColor=white) ![license](https://img.shields.io/github/license/SweetSmellFox/MFAWPF) ![activity](https://img.shields.io/github/commit-activity/m/SweetSmellFox/MFAWPF?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/SweetSmellFox/MFAWPF?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  A Universal GUI based on MAA's new architecture. Powered by MaaFramework.

- [MFW-PyQt6](https://github.com/overflow65537/MFW-PyQt6) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/overflow65537/MFW-PyQt6) ![activity](https://img.shields.io/github/commit-activity/m/overflow65537/MFW-PyQt6?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/overflow65537/MFW-PyQt6?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  A generic GUI based on PyQt6. Powered by MaaFramework!

- [MFAAvalonia](https://github.com/SweetSmellFox/MFAAvalonia) ![csharp](https://img.shields.io/badge/C%23-239120?logo=csharp&logoColor=white) ![license](https://img.shields.io/github/license/SweetSmellFox/MFAAvalonia) ![activity](https://img.shields.io/github/commit-activity/m/SweetSmellFox/MFAAvalonia?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/SweetSmellFox/MFAAvalonia?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  A generic GUI based on Avalonia. Powered by MaaFramework!

### Development Tool

- [MaaDebugger](https://github.com/MaaXYZ/MaaDebugger) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/MaaXYZ/MaaDebugger) ![activity](https://img.shields.io/github/commit-activity/m/MaaXYZ/MaaDebugger?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/MaaXYZ/MaaDebugger?style=social) [![pypi](https://img.shields.io/badge/PyPI-3776AB?logo=pypi&logoColor=white)](https://pypi.org/project/MaaDebugger/)  
  MaaFramework Pipeline Debugger

- [maa-support-extension](https://github.com/neko-para/maa-support-extension) ![Typescript](https://img.shields.io/badge/Typescript-8A2BE2?logo=typescript) ![activity](https://img.shields.io/github/commit-activity/m/neko-para/maa-support-extension?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/neko-para/maa-support-extension?style=social) [![marketplace](https://img.shields.io/badge/Visual%20Studio%20Marketplace-black?logo=vscodium&logoColor=#2F80ED)](https://marketplace.visualstudio.com/items?itemName=nekosu.maa-support)  
  MaaFramework VSCode Extension

- [MFATools](https://github.com/SweetSmellFox/MFATools) ![csharp](https://img.shields.io/badge/C%23-239120?logo=csharp&logoColor=white) ![license](https://img.shields.io/github/license/SweetSmellFox/MFATools) ![activity](https://img.shields.io/github/commit-activity/m/SweetSmellFox/MFATools?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/SweetSmellFox/MFATools?style=social)  
  The tool interface is developed based on the WPF framework, aiming to provide functions similar to the screenshot tool.

- [MaaPipelineEditor](https://github.com/kqcoxn/MaaPipelineEditor) ![Typescript](https://img.shields.io/badge/Typescript-8A2BE2?logo=typescript) ![activity](https://img.shields.io/github/commit-activity/m/kqcoxn/MaaPipelineEditor?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/kqcoxn/MaaPipelineEditor?style=social)  
  MaaFramework Pipeline workflow visual editor based on react-flow. Create your Pipeline using a "no code" flowchart!

### Application

- [M9A](https://github.com/MaaXYZ/M9A) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/MaaXYZ/M9A) ![activity](https://img.shields.io/github/commit-activity/m/MaaXYZ/M9A?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/MaaXYZ/M9A?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge) [![website](https://img.shields.io/badge/https://1999.fan-%234285F4)](https://1999.fan)  
  A 1999 Assistant. Image technology + simulation control, freeing your hands! Powered by MaaFramework.

- [MAS](https://github.com/MaaXYZ/MaaAssistantSkland) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/MaaXYZ/MaaAssistantSkland) ![activity](https://img.shields.io/github/commit-activity/m/MaaXYZ/MaaAssistantSkland?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/MaaXYZ/MaaAssistantSkland?style=social)  
  A Skland Assistant. Image technology + simulation control, freeing your hands! Powered by MaaFramework.

- [MSBA](https://github.com/overflow65537/MAA_SnowBreak) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/overflow65537/MAA_SnowBreak) ![activity](https://img.shields.io/github/commit-activity/m/overflow65537/MAA_SnowBreak?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/overflow65537/MAA_SnowBreak?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  A Snow break Assistant. Image technology + simulation control, freeing your hands! Powered by MaaFramework.

- [MaaYYs](https://github.com/TanyaShue/MaaYYs) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![qt](https://img.shields.io/badge/Qt6-41CD52?logo=Qt&logoColor=white) ![license](https://img.shields.io/github/license/TanyaShue/MaaYYs) ![activity](https://img.shields.io/github/commit-activity/m/TanyaShue/MaaYYs?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/TanyaShue/MaaYYs?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  A brand new Onmyoji assistant powered by advanced architecture. Combining image recognition and simulated control, it automates daily tasks and frees your hands like a cyber-helper! Powered by MaaFramework!

- [MRA](https://github.com/Saratoga-Official/MRA) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/Saratoga-Official/MRA) ![activity](https://img.shields.io/github/commit-activity/m/Saratoga-Official/MRA?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/Saratoga-Official/MRA?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  An assistant for Warship Girls R. Image technology + simulation control, freeing your hands! Powered by MaaFramework.

- [MPA](https://github.com/overflow65537/MAA_Punish) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/overflow65537/MAA_Punish) ![activity](https://img.shields.io/github/commit-activity/m/overflow65537/MAA_Punish?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/overflow65537/MAA_Punish?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  A Punishing Gray Raven Assistant. Image technology + simulation control, freeing your hands! Powered by MistEO's Black Coffee 2.0.

- [MaaYuan](https://github.com/syoius/MaaYuan) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/syoius/MaaYuan) ![activity](https://img.shields.io/github/commit-activity/m/syoius/MaaYuan?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/syoius/MaaYuan?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge) [![website](https://img.shields.io/badge/https://maayuan.top-%234285F4)](https://maayuan.top)  
  An Ashes of the kingdom Assistant. Image technology + simulation control, freeing your hands! Powered by MaaFramework.

- [Maa-HBR](https://github.com/KarylDAZE/Maa-HBR) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/KarylDAZE/Maa-HBR) ![activity](https://img.shields.io/github/commit-activity/m/KarylDAZE/Maa-HBR?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/KarylDAZE/Maa-HBR?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  An assistant for Heaven Burns Red/HBR. Image technology + simulation control, freeing your hands! Powered by MaaFramework.

- [MaaGF2Exilium](https://github.com/DarkLingYun/MaaGF2Exilium) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/DarkLingYun/MaaGF2Exilium) ![activity](https://img.shields.io/github/commit-activity/m/DarkLingYun/MaaGF2Exilium?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/DarkLingYun/MaaGF2Exilium?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  An automation assistant for Girls' Frontline 2: Exilium, built on a brand-new architecture. Featuring image recognition technology and simulation control to free up your hands! Powered by MaaFramework!

- [MaaAshEchoes](https://github.com/moulai/MaaAshEchoes) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/moulai/MaaAshEchoes) ![activity](https://img.shields.io/github/commit-activity/m/moulai/MaaAshEchoes?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/moulai/MaaAshEchoes?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  An assistant for Ash Echoes. Image technology + simulation control, freeing your hands! Powered by MaaFramework.

- [MaaXuexi](https://github.com/ravizhan/MaaXuexi) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/ravizhan/MaaXuexi) ![activity](https://img.shields.io/github/commit-activity/m/ravizhan/MaaXuexi?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/ravizhan/MaaXuexi?style=social)  
  The Xuexi automation assistant based on a new architecture.Image technology + analogue control to free your hands!Powered by MaaFramework!

- [MACC](https://github.com/mxia9416/MACC) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/mxia9416/MACC) ![activity](https://img.shields.io/github/commit-activity/m/mxia9416/MACC?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/mxia9416/MACC?style=social)  
  MACC: Minos Assistant of Crisis Control is an assistant. Image technology + analogue control to free your hands! Powered by MaaFramework!

- [MAA_MHXY_MG](https://github.com/gitlihang/Maa_MHXY_MG) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/gitlihang/Maa_MHXY_MG) ![activity](https://img.shields.io/github/commit-activity/m/gitlihang/Maa_MHXY_MG?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/gitlihang/Maa_MHXY_MG?style=social)  
  Fantasy Westward Journey Mobile Assistant Based on New Architecture. Image technology + analogue control to free your hands! Powered by MaaFramework!

- [MNMA](https://github.com/kqcoxn/MaaNewMoonAccompanying) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/kqcoxn/MaaNewMoonAccompanying) ![activity](https://img.shields.io/github/commit-activity/m/kqcoxn/MaaNewMoonAccompanying?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/kqcoxn/MaaNewMoonAccompanying?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  A New Moon Accompanying Assistant. Image technology + simulation control, freeing your hands! Powered by MaaFramework.

- [MaaTOT](https://github.com/Coxwtwo/MaaTOT) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![license](https://img.shields.io/github/license/Coxwtwo/MaaTOT) ![activity](https://img.shields.io/github/commit-activity/m/Coxwtwo/MaaTOT?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/Coxwtwo/MaaTOT?style=social)  
  A Tears of Themis Assistant. Image technology + simulation control, freeing your hands! Powered by MaaFramework.

- [MaaGumballs](https://github.com/KhazixW2/MaaGumballs) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![Python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/KhazixW2/MaaGumballs) ![activity](https://img.shields.io/github/commit-activity/m/KhazixW2/MaaGumballs?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/KhazixW2/MaaGumballs?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  MaaGumballs is an assistant tool driven by image recognition and simulated control. It can help everyone free their hands and start an adventure of brick-breaking with one click, powered by the MaaFramework.

- [MMleo](https://github.com/fictionalflaw/MMleo) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![Python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/fictionalflaw/MMleo) ![activity](https://img.shields.io/github/commit-activity/m/fictionalflaw/MMleo?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/fictionalflaw/MMleo?style=social) [![mirrorc](https://img.shields.io/badge/MirrorChyan-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge)  
  Little Assistant for EnsembleStars Music. Free your hands with image recognition and simulated control technology! Boost the producer career of hamsters! Powered by MaaFramework!

- [autodori](https://github.com/EvATive7/autodori) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![Python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/EvATive7/autodori) ![activity](https://img.shields.io/github/commit-activity/m/EvATive7/autodori?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/EvATive7/autodori?style=social)  
  Assistant for BanG Dream! Image recognition + simulation control, freeing your hands! Powered by MaaFramework, Tsurumaki Foundation, TGW Group.  

- [SLIMEIM_Maa](https://github.com/miaojiuqing/SLIMEIM_Maa) ![Pipeline](https://img.shields.io/badge/Pipeline-%23876f69?logo=paddypower&logoColor=%23FFFFFF) ![Python](https://img.shields.io/badge/Python-3776AB?logo=python&logoColor=white) ![license](https://img.shields.io/github/license/miaojiuqing/SLIMEIM_Maa) ![activity](https://img.shields.io/github/commit-activity/m/miaojiuqing/SLIMEIM_Maa?color=%23ff69b4) ![stars](https://img.shields.io/github/stars/miaojiuqing/SLIMEIM_Maa?style=social) [![mirrorc](https://img.shields.io/badge/Mirror%E9%85%B1-%239af3f6?logo=countingworkspro&logoColor=4f46e5)](https://mirrorchyan.com/en/projects?source=maafw-badge&rid=SLIMEIM_Maa)  
  Assistant for the Founding Chronicles of the Demon King and Dragon.Free your hands with image recognition and simulated control technology! Powered by MaaFramework!
  
## Eco-Building

MAA is planned to be a category of projects rather than just a single piece of software.

If your project depends on MaaFramework, we welcome you to name it as MaaXXX, MXA, MAX, and so on. Of course, this is permission, not limitation. You can freely choose other names unrelated to MAA, depending on your own ideas!

We also welcome you to submit a PR to add your project to the community projects list above!

## Statement and License

### Open Source License

This project is open-sourced under the [`LGPL-3.0`](./LICENSE.md) license.

### Distribution Notice

This project supports GPU acceleration, which relies on an independent component provided by Microsoft: [DirectML](https://learn.microsoft.com/en-us/windows/ai/directml/) for the Windows platform. DirectML is not part of this project's open-source codebase and is not governed by the LGPL-3.0 license. For user convenience, an unmodified copy of the DirectML.dll file is included in the installation package. If GPU acceleration is not required, you may safely delete this DLL file without affecting the core functionality of the software.

### Disclaimer

#### Intended Use

This project is intended to provide **automated black-box testing tools** for software development, including image recognition, UI operation simulation, and other legitimate technical scenarios. Developers must ensure that their use of the project complies with all applicable laws, regulations, and the terms of service of the target software.

#### Prohibited Misuse

The use of this project for the following purposes is strictly prohibited (including but not limited to):

- Disrupting, circumventing, or interfering with the normal functioning of any software, game, or service (such as anti-cheat mechanisms or authorization systems).
- Developing or distributing tools that violate third-party terms of service (such as game cheats, hacking tools, or automation scripts).
- Engaging in any illegal activity or actions that infringe upon the legitimate rights of others (such as data theft or cyberattacks).

#### Liability Disclaimer

This project is provided "as is". The author **assumes no responsibility** for any direct, indirect, or consequential damages resulting from:

- User actions that violate this statement or applicable laws and regulations.
- Damages caused by third-party tools developed using this project (e.g., account bans, legal disputes).
- Any technical or financial losses incurred from the use of this project.

#### User Responsibilities

By using this project, you agree to:

- Assume all risks associated with its use.
- Ensure that your use case is legal and properly authorized (e.g., with permission from the target software vendor).
- Take full responsibility for any legal issues arising from your actions and hold the project author harmless from any liability.

## Development

_Please note that you only need to read this chapter if you are ready to develop MaaFramework itself. If you only want to develop applications based on MaaFramework, please refer to [Get Started](#get-started)._

- [How to build](docs/en_us/4.1-BuildGuide.md)
- [API Design](docs/en_us/4.2-StandardizedInterfaceDesign.md)

## Acknowledgments

### Open Source Libraries

- [opencv](https://github.com/opencv/opencv)  
  Open Source Computer Vision Library
- [fastdeploy](https://github.com/PaddlePaddle/FastDeploy)  
  ⚡️An Easy-to-use and Fast Deep Learning Model Deployment Toolkit for ☁️Cloud 📱Mobile and 📹Edge.
- [onnxruntime](https://github.com/microsoft/onnxruntime)  
  ONNX Runtime: cross-platform, high performance ML inferencing and training accelerator
- [boost](https://www.boost.org/)  
  Boost provides free peer-reviewed portable C++ source libraries.
- [libzmq](https://github.com/zeromq/libzmq)  
  ZeroMQ core engine in C++, implements ZMTP/3.1
- [cppzmq](https://github.com/zeromq/cppzmq)  
  Header-only C++ binding for libzmq
- [meojson](https://github.com/MistEO/meojson)  
  ✨ Next-gen C++ JSON/JSON5 Serialization Engine | Zero Dependency | Header-Only | Unleash JSON Potential
- [minitouch](https://github.com/DeviceFarmer/minitouch)  
  Minimal multitouch event producer for Android.
- [maatouch](https://github.com/MaaAssistantArknights/MaaTouch)  
  Android native implementation of minitouch input protocol
- [minicap](https://github.com/DeviceFarmer/minicap)  
  Stream real-time screen capture data out of Android devices.
- [zlib](https://github.com/madler/zlib)  
  A massively spiffy yet delicately unobtrusive compression library.
- [gzip-hpp](https://github.com/mapbox/gzip-hpp)  
  Gzip header-only C++ library
- ~~[protobuf](https://github.com/protocolbuffers/protobuf)~~  
  ~~Protocol Buffers - Google's data interchange format~~
- ~~[grpc](https://github.com/grpc/grpc)~~  
  ~~The C based gRPC (C++, Python, Ruby, Objective-C, PHP, C#)~~
- ~~[thrift](https://github.com/apache/thrift)~~  
  ~~Apache Thrift~~

### Developers

Thanks to the following developers for their contributions to MaaFramework:

[![Contributors](https://contrib.rocks/image?repo=MaaXYZ/MaaFramework&max=1000)](https://github.com/MaaXYZ/MaaFramework/graphs/contributors)

## Discussion

- QQ Group: 595990173

## Sponsor

<!-- markdownlint-disable MD045 -->
<a href="https://afdian.com/a/misteo">
  <img width="200" src="https://pic1.afdiancdn.com/static/img/welcome/button-sponsorme.png">
</a>
