# Terms

## MaaFW Terminology

- **Node**

    A complete Json Object that conforms to [the Pipeline protocol](3.1-PipelineProtocol.md).

- **Task**

    A logical sequence structure in which several **Node** are connected in a certain order, representing the entire process from beginning to end.

- **Entry**

    The first **Node** in a **Task**.

- **Pipeline**

    All **Node** contained in a `pipeline` folder.

- **Bundle**

    A folder stored in a standard resource structure, including `pipeline`, `model`, `image` and other folders.

- **Resource**

    A resource structure in which multiple **Bundles** are loaded in a certain order.

- **PI**

    `ProjectInterface`, A standardized project structure declaration that conforms to [the ProjectInterface definition](3.2-ProjectInterface.md).

- **Agent**

    💡 MaaFW v4.x version highlights, that it can separate the MaaFW body and `CustomRecognition` / `CustomAction` into two independent processes.  
    For example, the body runs in a common GUI written in C#, and at the same time runs your own Custom logic in Python code, breaking the language barrier.

## General terms

- **Binding**

    Provides glue code to convert MaaFW's C language interface to other programming languages ​​or operating system services.  
    Reference to [WIKI](https://en.wikipedia.org/wiki/Language_binding).

- **ROI**

    Define the image recognition boundary and perform relevant image processing only within this area.  
    Reference to [WIKI](https://en.wikipedia.org/wiki/Region_of_interest).

- **OCR**

    OCR software is used to convert handwritten, type-written or printed text into data that can be edited on a computer.  
    Reference to [WIKI](https://en.wikipedia.org/wiki/Optical_character_recognition).
