# Integrated Interface Overview

## About Binding

Different language bindings may have different naming conventions and are wrapped according to the [Standardized Interface Design](./4.2-StandardizedInterfaceDesign.md). Please search for the actual names yourself. Some interfaces may be used automatically internally and not provided directly (such as StringBuffer-related interfaces). Below are reference names for some interfaces across different bindings.

| C                              | Python Basic Interface                              | Python Standard Interface | NodeJS Basic Interface            | NodeJS Standard Interface |
| ------------------------------ | --------------------------------------------------- | ------------------------ | --------------------------------- | ------------------------ |
| MaaVersion()                   | Library.framework().MaaVersion()                    | Library.version()        | api.version()                     | Global.version           |
| MaaTaskerInited(tasker_handle) | Library.framework().MaaTaskerInited(tasker_handle)  | tasker.inited            | api.tasker_inited(tasker_handle)  | tasker.inited            |

## MaaUtility.h

### MaaVersion

Returns the version of `MaaFramework`.

### MaaSetGlobalOption

Set global options. Will be split into specific options in bindings.

-   LogDir

    Set the log path.

-   SaveDraw

    Set whether to save recognition results to `log path/vision`. When enabled, RecoDetail can retrieve draws.

-   StdoutLevel

    Set the log output level to stdout.

-   DebugMode

    Set whether to enable debug mode. In debug mode, RecoDetail can retrieve raw/draws; all tasks are treated as focus and produce callbacks.

## MaaResource.h

### MaaResourceCreate

-   `notify`: Callback for resource-related operations.

Create resource.

### MaaResourceDestroy

Destroy resource.

### MaaResourceRegisterCustomRecognition

-   `name`: Name
-   `recognition`: Custom recognizer

Register a custom recognizer named `name`.

### MaaResourceUnregisterCustomRecognition

-   `name`: Name

Remove the custom recognizer named `name`.

### MaaResourceClearCustomRecognition

Remove all custom recognizers.

### MaaResourceRegisterCustomAction

-   `name`: Name
-   `action`: Custom action

Register a custom action named `name`.

### MaaResourceUnregisterCustomAction

-   `name`: Name

Remove the custom action named `name`.

### MaaResourceClearCustomAction

Remove all custom actions.

### MaaResourcePostBundle

-   `path`: Resource path

Load resources from the path `path`.

### MaaResourceOverridePipeline

-   `pipeline_override`: JSON for overriding

Override `pipeline_override`.

### MaaResourceOverrideNext

-   `node_name`: Task name
-   `next`: Next list

Override the next list of `node_name` with `next`.

### MaaResourceGetNodeData

-   `node_name`: Task name

Get the current definition of task `node_name`.

### MaaResourceClear

Clear loaded content.

### MaaResourceStatus

-   `id`: Operation id

Query the status of operation with `id`.

### MaaResourceWait

-   `id`: Operation id

Wait for the operation with `id` to complete.

### MaaResourceLoaded

Check if resources loaded normally.

### MaaResourceSetOption

Set resource options. Will be split into specific options in bindings.

-   InferenceDevice

    Set inference device.

-   InferenceExecutionProvider

    Set inference provider.

### MaaResourceGetHash

Get resource hash.

### MaaResourceGetNodeList

Get task list.

## MaaController.h

### MaaAdbControllerCreate

-   `adb_path`: adb path
-   `address`: connection address
-   `screencap_methods`: all available screenshot methods
-   `input_methods`: all available input methods
-   `config`: extra config
-   `agent_path`: MaaAgentBinary path
-   `notify`: Callback for controller-related operations

Create Adb controller

> Screenshot and input methods will be speed tested at startup, selecting the fastest option.

### MaaWin32ControllerCreate

-   `hWnd`: window handle
-   `screencap_methods`: screenshot methods used
-   `input_methods`: input methods used
-   `notify`: Callback for controller-related operations

Create Win32 controller

### MaaCustomControllerCreate

-   `controller`: Custom control
-   `notify`: Callback for controller-related operations

Create custom controller

### MaaDbgControllerCreate

-   `read_path`: Input path, includes operations recorded via Recording option
-   `write_path`: Output path, includes execution results
-   `type`: Controller mode
-   `config`: Extra config
-   `notify`: Callback for controller-related operations

Create debug controller

### MaaControllerDestroy

Destroy controller

### MaaControllerSetOption

Set controller options. Will be split into specific options in bindings.

-   ScreenshotTargetLongSide

    Set screenshot scaling long side to specified length

-   ScreenshotTargetShortSide

    Set screenshot scaling short side to specified length

-   ScreenshotUseRawSize

    No scaling for screenshots

### MaaControllerPostConnection

Connect device

### MaaControllerPostClick

-   `x`, `y`: Click coordinates

Click

### MaaControllerPostSwipe

-   `x1`, `y1`: Start coordinates
-   `x2`, `y2`: End coordinates
-   `duration`: Swipe duration in ms

Swipe

### MaaControllerPostClickKey

-   `key`: Virtual key code
    -   [Adb Controller](https://developer.android.com/reference/android/view/KeyEvent)
    -   [Win32 Controller](https://learn.microsoft.com/en-us/windows/win32/inputdev/virtual-key-codes)

Click key

### MaaControllerPostKeyDown

-   `key`: Virtual key code
    -   [Adb Controller](https://developer.android.com/reference/android/view/KeyEvent)
    -   [Win32 Controller](https://learn.microsoft.com/en-us/windows/win32/inputdev/virtual-key-codes)

Key down

### MaaControllerPostKeyUp

-   `key`: Virtual key code
    -   [Adb Controller](https://developer.android.com/reference/android/view/KeyEvent)
    -   [Win32 Controller](https://learn.microsoft.com/en-us/windows/win32/inputdev/virtual-key-codes)

Key up

### MaaControllerPostInputText

-   `text`: Text to input

Input text

### MaaControllerPostStartApp

-   `intent`: Target app
    -   Adb Controller: package name or activity
    -   Win32 Controller: not supported yet

Start app

### MaaControllerPostStopApp

-   `intent`: Target app
    -   Adb Controller: package name
    -   Win32 Controller: not supported yet

Stop app

### MaaControllerPostTouchDown

-   `contact`: Contact number
    -   Adb Controller: finger number
    -   Win32 Controller: mouse button (0: left, 1: right, 2: middle)
-   `x`, `y`: Contact position
-   `pressure`: Contact pressure

Touch down

### MaaControllerPostTouchMove

-   `contact`: Contact number
    -   Adb Controller: finger number
    -   Win32 Controller: mouse button (0: left, 1: right, 2: middle)
-   `x`, `y`: Contact position
-   `pressure`: Contact pressure

Move

### MaaControllerPostTouchUp

-   `contact`: Contact number
    -   Adb Controller: finger number
    -   Win32 Controller: mouse button (0: left, 1: right, 2: middle)

Touch up

### MaaControllerPostScreencap

Screenshot

### MaaControllerStatus

-   `id`: Operation id

Query status of operation with `id`.

### MaaControllerWait

-   `id`: Operation id

Wait for operation with `id` to complete.

### MaaControllerConnected

Check if connected.

### MaaControllerCachedImage

Get the latest screenshot.

### MaaControllerGetUuid

Get device uuid.

## MaaTasker.h

### MaaTaskerCreate

-   `notify`: Callback for instance-related operations

Create instance

### MaaTaskerDestroy

Destroy instance

### MaaTaskerSetOption

Set instance options. Will be split into specific options in bindings.

No configurable options currently.

### MaaTaskerBindResource

-   `res`: Resource

Bind resource

### MaaTaskerBindController

-   `ctrl`: Controller

Bind controller

### MaaTaskerInited

Check if initialized correctly

### MaaTaskerPostTask

-   `entry`: Task entry
-   `pipeline_override`: JSON for overriding

Execute task

### MaaTaskerStatus

-   `id`: Operation id

Query status of operation with `id`.

### MaaTaskerWait

-   `id`: Operation id

Wait for operation with `id` to complete.

### MaaTaskerRunning

Check if instance is still running

### MaaTaskerPostStop

Stop instance

### MaaTaskerStopping

Check if instance is stopping (not yet stopped)

### MaaTaskerGetResource

Get bound resource

### MaaTaskerGetController

Get bound controller

### MaaTaskerClearCache

Clear all queryable information

### MaaTaskerGetRecognitionDetail

-   `reco_id`: Recognition id
-   `node_name [out]`: Node name
-   `algorithm [out]`: Recognition algorithm
-   `hit [out]`: Hit or not
-   `box [out]`: Hit position
-   `detail_json [out]`: Recognition details
-   `raw [out]`: Screenshot (valid only in debug mode)
-   `draws [out]`: Screenshot with recognition results (valid only in debug mode)

Get recognition info

### MaaTaskerGetNodeDetail

-   `node_id`: Node id
-   `node_name [out]`: Node name
-   `reco_id [out]`: Corresponding recognition id
-   `completed [out]`: Operation result

Get node info

### MaaTaskerGetTaskDetail

-   `task_id`: Task id
-   `entry [out]`: Task entry
-   `node_id_list [out]`: Node id list
-   `status [out]`: Task status

Get task info

### MaaTaskerGetLatestNode

-   `node_name`: Task name
-   `latest_id [out]`: Latest node id

Get latest node id for task `node_name`

## MaaContext.h

### MaaContextRunTask

-   `entry`: Task entry
-   `pipeline_override`: JSON for overriding

Synchronously execute task

### MaaContextRunRecognition

-   `entry`: Task name
-   `pipeline_override`: JSON for overriding
-   `image`: Previous screenshot

Synchronously execute recognition logic for `entry`

> Will not execute subsequent operations or next steps.

### MaaContextRunAction

-   `entry`: Task name
-   `pipeline_override`: JSON for overriding
-   `box`: Previous recognition position
-   `reco_detail`: Previous recognition details

Synchronously execute action logic for `entry`

> Will not execute subsequent next steps.

### MaaContextOverridePipeline

-   `pipeline_override`: JSON for overriding

Override `pipeline_override`

### MaaContextOverrideNext

-   `node_name`: Task name
-   `next`: Next list

Override next list of `node_name` with `next`

### MaaContextGetNodeData

-   `node_name`: Task name

Get current definition of task `node_name`

### MaaContextGetTaskId

Get corresponding task id

### MaaContextGetTasker

Get instance

### MaaContextClone

Clone context

## MaaToolkitConfig.h

### MaaToolkitConfigInitOption

-   `user_path`: Config storage path
-   `default_json`: Default config

Load global config from `user_path`

## MaaToolkitAdbDevice.h

### MaaToolkitAdbDeviceFind

Search all known Android emulators

### MaaToolkitAdbDeviceFindSpecified

-   `adb_path`: adb path

Search emulators using specified `adb_path`

## MaaToolkitDesktopWindow.h

### MaaToolkitDesktopWindowFindAll

Query all window info

## MaaToolkitProjectInterface

### MaaToolkitProjectInterfaceRegisterCustomRecognition

-   `inst_id`: Instance id
-   `name`: Name
-   `recognition`: Custom recognizer

Register a custom recognizer named `name` for MaaPiCli instance `id`

### MaaToolkitProjectInterfaceRegisterCustomAction

-   `inst_id`: Instance id
-   `name`: Name
-   `action`: Custom action

Register a custom action named `name` for MaaPiCli instance `id`

### MaaToolkitProjectInterfaceRunCli

-   `inst_id`: Instance id
-   `resource_path`: Resource path
-   `user_path`: Config storage path
-   `directly`: Non-interactive mode
-   `notify`: Callback for resource/controller/instance-related operations

Run MaaPiCli instance `id` using `interface.json` under `resource_path`

> When non-interactive mode is enabled, preconfigured tasks will be executed directly.

## MaaAgentClientAPI.h

### MaaAgentClientCreateV2

-   `identifier`: Listening address

Create Agent client

> If empty, auto-generate

### MaaAgentClientDestroy

Destroy Agent client

### MaaAgentClientIdentifier

Get actual listening address

### MaaAgentClientBindResource

-   `res`: Resource

Bind Agent client to resource `res`

### MaaAgentClientConnect

Connect

### MaaAgentClientDisconnect

Disconnect

### MaaAgentClientConnected

Check if connected

### MaaAgentClientAlive

Check if Agent server is still responsive

### MaaAgentClientSetTimeout

-   `milliseconds`: Timeout in ms

Set Agent server timeout

## MaaAgentServerAPI.h

### MaaAgentServerRegisterCustomRecognition

-   `name`: Name
-   `recognition`: Custom recognizer

Register a custom recognizer named `name`

### MaaAgentServerRegisterCustomAction

-   `name`: Name
-   `action`: Custom action

Register a custom action named `name`

### MaaAgentServerStartUp

-   `identifier`: Connection address

Start server and connect to `identifier`

### MaaAgentServerShutDown

Stop server

### MaaAgentServerJoin

Synchronously wait for server thread to end

### MaaAgentServerDetach

Detach server thread