# How to build

> [!TIP]
> _You only need to read this chapter if you are ready to develop MaaFramework itself. If you only want to develop applications based on MaaFramework, please refer to [Quick Started](1.1-QuickStarted.md)._

## Local Development

1. Download MaaDeps prebuilt

    ```sh
    python3 tools/maadeps-download.py
    ```

2. Configure cmake

    - Windows

    ```bash
    cmake --preset "MSVC 2022"
    ```

    - Linux / macOS

    ```bash
    cmake --preset "NinjaMulti"
    ```

3. Build the project using cmake

    ```bash
    cmake --build build --config Release
    cmake --install build --prefix install
    ```

The generated binaries and related files are located in the `install` directory.

For more details, refer to [Build CI](https://github.com/MaaXYZ/MaaFramework/blob/main/.github/workflows/build.yml).

## Online Development

Use Codespaces (Dev Container) to set up the basic development environment with one click (Ninja, CMake, g++-13):

[![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://github.com/codespaces/new?hide_repo_select=true&ref=master&repo=632024122)

Then follow the steps in [Local Development](#local-development).
