# Standardized High-Level Language Object-Oriented Interface Design

Binding can be divided into two steps:

1. Standardize the OOP (Object-Oriented Programming) encapsulation of the C API. Since the MaaFW (Mobile Application Framework) interface is relatively stable, once this step is completed, it does not require long-term maintenance.
2. Based on step 1, parse parameters such as callback messages, detail JSON, and pipeline overrides, and encapsulate them into different functions and structures. These fields may change with MaaFW updates and will need long-term follow-up with new versions of MaaFW.

If you wish to add a binding for a certain language to MaaFW, you can choose one of the following methods according to your available time and resources:

## Standardized Interface

1. **MaaTasker, MaaResource, MaaController** should be encapsulated as objects rather than procedural interfaces. For instance, interfaces like `MaaContextGetTasker` should return objects rather than handles. You may consider two models:
    1. Add a global handle-object reference dictionary, and use the handle to find and return the original object.
    2. The object is stateless and only responsible for referencing handles, directly creating and returning new objects (refer to the `own` field in Python bindings).
2. **MaaTaskId, MaaCtrlId, MaaResId** and other asynchronous action IDs should not be returned to the integrator. Encapsulate them into a `Job` class within the binding, providing methods like `wait`, `status`, and `get`.
3. The `Job` class should provide encapsulations for all methods that can operate on the given ID. For example, the `get` method of `TaskJob` should return encapsulated data obtained from `MaaTaskerGetTaskDetail`.
4. **MaaRecoId, MaaNodeId** and other query-type IDs should not be returned to the integrator. The binding should call interfaces like `MaaTaskerGetRecoDetail` and encapsulate the results into structures such as `RecoDetail` and `NodeDetail` before returning them.
5. **CustomAction, CustomRecognition, NotificationCallback**, etc., need to be encapsulated into an agent, preferably a virtual base class. The actual object passed to MaaFW should be a pointer within the agent, which will convert various parameters into types commonly used in the target language before passing them to the integrator.
6. In the agent for **CustomAction** and **CustomRecognition**, please encapsulate parameters of `MaaCustomRecognitionCallback/MaaCustomActionCallback` (excluding context) into structures before passing them to the integrator to avoid compatibility issues with future callback parameter additions. The return values should also be encapsulated into structures.
7. Each enumeration in `SetOption` should be split into separate interfaces, such as `set_screenshot_target_long_side`, rather than providing the specific enumeration to the integrator.
8. Buffers like **StringBuffer, ImageBuffer** should not be returned to the integrator. They need to be converted into the target language's standard string and image types before being provided.
9. For interfaces such as **BindResource, BindController, RegisterCustom**, ensure that a reference is kept to avoid garbage collection issues.
10. For the **Find** series of interfaces in `MaaToolkit`, directly return encapsulated arrays of structures.
11. Provide samples where the interface calls should not be fewer than those in the Python samples.

## Additional Parsing and Encapsulation

1. The NotificationCallback wrapped interface parses the message and dispatches it to different methods (refer to MaaMsg.h). For example, `on_resource_loading_starting(data)`. ResourceLoading can also be dispatched as an Event enumeration and Starting as a Type enumeration, such as `on_notification(event, type, data)`. Among them, `data` is the structure parsed by detail_json, instead of directly giving the original json.
2. For the NotificationCallback wrapped interface, you can consider adding the on_unknown_notification method to temporarily deal with the subsequent messages added by MaaFW. You can also consider adding the raw field or other fields representing unknown content to the structure parsed by detail_json.
3. Split detail_json obtained by `MaaTaskerGetRecognitionDetail` into all_results, filtered_results, best_result (note that best may be null), and parse them into different structures according to the algorithm
4. More: TODO...
