# Packaging

> Note: This document is about integrating with NodeJS

This project contains binary.  `@maaxyz/maa-node` package will require corresponding `MaaNode.node` from `@maaxyz/maa-node-${platform}-${arch}`. Meanwhile, as loaded `MaaNode.node` dynamic links `MaaFramework` library, and `Adb` controller relies on `AgentBinary`, it is strongly recommended to mark `@maaxyz/maa-node` as external dependencies and do not participate packaging.

If you do want to package it, the following should be take cared:

* Usually, packaging tool can only discover `MaaNode.node`, but won't aware its dependencies. All `dll/so/dylib` besides `MaaNode.node` should be placed the same directory to `MaaNode.node`.
* `Adb` controller will use `../agent` applying on the directory of **the library script** to search for MaaAgentBinary. It is also possible to manually configure it in code.

## maa-node-template

Refer to [maa-node-template](https://github.com/neko-para/maa-node-template). This template provides a simplified packaging solution with electron.

```shell
npm run build # use esbuild to build project, refer to scripts/build.mjs
npm run watch # use esbuild and vite to hot reload, refer to scripts/watch.mjs
npm run package # use electron-forge to package
```
