# 快速开始

## 开发思路

MaaFramework 提供三种集成方案，满足不同开发场景需求：

### 方案一：纯 JSON 低代码编程（通用 UI）

**适用场景**：快速入门、简单逻辑实现

**特点**:

- 零编码基础要求
- 通过 JSON 配置实现自动化流程
- 配套 [🎞️视频教程](https://www.bilibili.com/video/BV1yr421E7MW) 和 [⭐项目模板](https://github.com/MaaXYZ/MaaPracticeBoilerplate)

```jsonc
{
    "点击开始按钮": {
        "recognition": "OCR",          // 文字识别引擎
        "expected": "开始",            // 目标文本
        "action": "Click",             // 执行点击操作
        "next": ["点击确认图标"]        // 后续任务链
    },
    "点击确认图标": {
        "recognition": "TemplateMatch",// 图像模板匹配
        "template": "确认.png",        // 匹配素材路径
        "action": "Click"
    }
}
```

### 方案二：JSON + 自定义逻辑扩展（推荐）

**💡 v4.x 版本核心特性**

**特点**:

- 保留 JSON 低代码优势
- 通过 AgentServer 注册自定义任务模块
- 无缝衔接 [⭐项目模板](https://github.com/MaaXYZ/MaaPracticeBoilerplate)

```jsonc
{
    "点击确认图标": {
        "next": ["自定义处理模块"]
    },
    "自定义处理模块": {
        "recognition": "Custom",
        "custom_recognition": "MyReco",  // 自定义识别器ID
        "action": "Custom",
        "custom_action": "MyAct"         // 自定义动作ID
    }
}
```

💡 通用 UI 会自动连接您的 AgentServer 子进程，并在执行到 `MyReco`/`MyAct` 时，调用对应的识别/动作。

```python
# Python 伪代码示例
from maa.agent.agent_server import AgentServer

# 注册自定义识别器
@AgentServer.custom_recognition("MyReco")
class CustomReco:
    def analyze(ctx):
        return (10,10,100,100)  # 返回您自己处理的识别结果

# 注册自定义动作 
@AgentServer.custom_action("MyAct")
class CustomAction:
    def run(ctx):
        ctx.controller.post_click(100, 10).wait()  # 执行点击
        ctx.override_next(["TaskA", "TaskB"])      # 动态调整任务流

# 启动Agent服务
AgentServer.start_up(sock_id)
```

完整示例参考 [模板 Commit](https://github.com/MaaXYZ/MaaPracticeBoilerplate/commit/126a56cefc17bf6c8335c703387d8d3ee2dad4d1)。

### 方案三：全代码开发

**适用场景**:

- 深度定制需求
- 复杂业务逻辑实现
- 需要灵活控制执行流程

```python
# Python 伪代码示例
def main():
    # 执行 JSON 预定义任务
    result = tasker.post_task("点击开始按钮").wait().get()
    
    if result.completed:
        # 执行代码级操作
        tasker.controller.post_click(100, 100)
    else:
        # 获取当前屏幕截图
        image = tasker.controller.cached_image
        # 注册自定义动作
        tasker.resource.register_custom_action("MyAction", MyAction())
        # 执行混合任务链
        tasker.post_task("点击确认图标").wait()
```

## 资源准备

### 文件结构规范

*⭐若您使用项目模板，直接在 [文件夹](https://github.com/MaaXYZ/MaaPracticeBoilerplate/tree/main/assets/resource) 中修改即可。*

```tree
my_resource/
├── image/                # 图像素材库
│   ├── my_button_ok.png
│   └── my_icon_close.png
├── model/
│   └── ocr/              # 文字识别模型
│       ├── det.onnx
│       ├── keys.txt
│       └── rec.onnx
└── pipeline/             # 任务流水线
    ├── my_main.json
    └── my_subflow.json
```

其中以 `my_` 开头的文件/文件夹均可自行修改名称，其他的则为固定文件名，不可修改，下面依次介绍：

### 任务流水线

`my_resource/pipeline` 中的文件，包含主要的脚本执行逻辑，会递归读取目录中所有的 json 格式文件。

可参考 [任务流水线协议](3.1-任务流水线协议.md) 进行编写，一个简单的 [demo](https://github.com/MaaXYZ/MaaFramework/blob/main/sample/resource/pipeline/sample.json)

小工具：

- [JSON Schema](https://github.com/MaaXYZ/MaaFramework/blob/main/tools/pipeline.schema.json)
- [VSCode 插件](https://marketplace.visualstudio.com/items?itemName=nekosu.maa-support)
  - 基于 `interface.json` 配置资源
  - 支持跳转到任务定义、查找任务引用、重命名任务、补全任务、点击执行任务
  - 支持按照 MaaPiCli 模式执行
  - 支持连接后截图并裁剪图片

### 图像素材

`my_resource/image` 中的文件，主要为 pipeline 所用到的模板匹配图片、特征检测图片等，会按照 pipeline 中设定的 `template` 等字段读取对应的文件。

所使用的图片需要是无损原图缩放到 720p 后的裁剪。**除非你完全清楚 MaaFramework 在做什么，否则请使用下面的截图工具来获取图片。**

- [VSCode 插件](https://marketplace.visualstudio.com/items?itemName=nekosu.maa-support)
- [MFA 小工具](https://github.com/SweetSmellFox/MFATools)
- [图片裁剪及 ROI 获取工具](https://github.com/MaaXYZ/MaaFramework/tree/main/tools/ImageCropper)

### 文字识别模型文件

*⭐若您使用项目模板，直接按照其文档，运行 `configure.py` 即可自动部署模型文件。*

`my_resource/model/ocr` 中的文件，为 [PaddleOCR](https://github.com/PaddlePaddle/PaddleOCR) 转 ONNX 后的模型文件。

可使用我们的预转换文件：[MaaCommonAssets](https://github.com/MaaXYZ/MaaCommonAssets/tree/main/OCR)，选择需要的语种，按照 [上述](#准备资源文件) 目录结构存放即可。

若有需要也可以自行对 PaddleOCR 的官方预训练模型进行 fine-tuning （请自行参考 [PaddleOCR](https://github.com/PaddlePaddle/PaddleOCR) 官方文档），并转换成 ONNX 文件使用，转换命令可参考 [这里](https://github.com/MaaXYZ/MaaCommonAssets/tree/main/OCR#command)

## 调试

- 使用 [开发工具](https://github.com/MaaXYZ/MaaFramework/tree/main?tab=readme-ov-file#%E5%BC%80%E5%8F%91%E5%B7%A5%E5%85%B7)
- 部分工具会在同目录下生成 `config/maa_option.json` 文件，其中：

  - `logging`: 保存日志，会生成 `debug/maa.log`。默认 true 。
  - `save_draw`: 保存图像识别可视化结果，会保存运行期间所有图像识别可视化结果绘制图。默认 false 。
  - `stdout_level`: 控制台显示日志等级。默认 2（Error），可设为 0 关闭全部控制台日志，或设为 7 打开全部控制台日志。

- 若自行集成，可通过 `Toolkit.init_option` / `MaaToolkitConfigInitOption` 接口开启调试选项。生成的 json 文件同上。

## 运行

使用 通用 UI（如 MaaPiCli, MFA, MFW 等）或者 自行编写集成代码

### 使用 MaaPiCli

*⭐若您使用项目模板，直接按照其文档，运行 `install.py` 后即可自动打包相关文件*

使用 Release 包 bin 文件夹中的 MaaPiCli ，并编写 `interface.json` 置于同目录下，即可使用

- [interface.json 文档](3.2-ProjectInterface协议.md)
- [Sample](https://github.com/MaaXYZ/MaaFramework/blob/main/sample/interface.json)

实践:

- [M9A](https://github.com/MaaXYZ/M9A/tree/main/assets/interface.json)

### 自行编写集成代码

请参考 [集成文档](2.1-集成文档.md)
