# 术语

## MaaFW 专有术语

- **Node** | **节点**

    符合 [任务流水线（Pipeline）协议](3.1-任务流水线协议.md) 的一个完整的 Json Object。

- **Task** | **任务**

    若干 **Node** 按一定次序相连的逻辑顺序结构，表示从头到尾的整个过程。

- **Entry** | **入口**

    一个 **Task** 中的第一个 **Node**。

- **Pipeline** | **流水线**

    一个 `pipeline` 文件夹中包含的 **Node** 全体。

- **Bundle** | *暂无翻译*

    一个按标准资源结构存储的文件夹，包含 `pipeline`、`model`、`image` 等文件夹。

- **Resource** | **资源**

    多个 **Bundle** 按一定次序加载的资源结构。

- **PI** | **项目接口**

    `ProjectInterface`, 符合 [ProjectInterface 定义](3.2-ProjectInterface协议.md) 的标准化项目结构声明。

- **Agent** |  **执行代理**

    💡 MaaFW v4.x 版本亮点功能。可将 MaaFW 本体与 `CustomRecognition` / `CustomAction` 分离至独立的两个进程中。  
    例如本体运行在 C# 编写的通用 GUI 中，同时在 Python 代码中运行编写自己的 Custom 逻辑，打破语言壁垒。

## 通用术语

- **Binding** | **语言绑定**

    提供将 MaaFW 的 C 语言接口转换为其他编程语言或操作系统服务的胶水代码。  
    参考 [WIKI](https://en.wikipedia.org/wiki/Language_binding)。

- **ROI** | **感兴趣区域**

    定义图像识别边界，仅在该区域内进行相关图像处理。  
    参考 [WIKI](https://en.wikipedia.org/wiki/Region_of_interest)。

- **OCR** | **文字识别**

    对包含文本内容的图像进行处理和识别，并提取其中所包含的文字及排版信息。  
    参考 [WIKI](https://zh.wikipedia.org/wiki/%E5%85%89%E5%AD%A6%E5%AD%97%E7%AC%A6%E8%AF%86%E5%88%AB)。