# 集成接口一览

## 关于 binding

不同语言的 binding 会有不同的命名方式, 且会根据[标准化接口](./4.2-标准化接口设计.md)进行封装, 请自行搜索实际的名称. 部分接口可能直接在内部自动使用而不会提供(例如 StringBuffer 相关接口). 下面是一些接口在不同 binding 中的参考名称.

| C                              | Python 基础接口                                    | Python 标准接口   | NodeJS 基础接口                  | NodeJS 标准接口 |
| ------------------------------ | -------------------------------------------------- | ----------------- | -------------------------------- | --------------- |
| MaaVersion()                   | Library.framework().MaaVersion()                   | Library.version() | api.version()                    | Global.version  |
| MaaTaskerInited(tasker_handle) | Library.framework().MaaTaskerInited(tasker_handle) | tasker.inited     | api.tasker_inited(tasker_handle) | tasker.inited   |

## MaaUtility.h

### MaaVersion

返回 `MaaFramework` 的版本.

### MaaSetGlobalOption

设置全局配置. 在 binding 中会拆分为具体的配置.

-   LogDir

    设置日志路径

-   SaveDraw

    设置是否将识别保存到 `日志路径/vision` 中. 开启后 RecoDetail 将可以获取到 draws

-   StdoutLevel

    设置日志输出到 stdout 中的级别

-   DebugMode

    设置是否启用调试模式. 调试模式下, RecoDetail 将可以获取到 raw/draws; 所有任务都会被视为 focus 而产生回调

## MaaResource.h

### MaaResourceCreate

-   `notify`: 接收资源相关操作的回调

创建资源

### MaaResourceDestroy

销毁资源

### MaaResourceRegisterCustomRecognition

-   `name`: 名称
-   `recognition`: 自定义识别器

注册名为 `name` 的自定义识别器 `recognition`

### MaaResourceUnregisterCustomRecognition

-   `name`: 名称

移除名为 `name` 的自定义识别器

### MaaResourceClearCustomRecognition

移除所有自定义识别器

### MaaResourceRegisterCustomAction

-   `name`: 名称
-   `action`: 自定义操作

注册名为 `name` 的自定义操作 `action`

### MaaResourceUnregisterCustomAction

-   `name`: 名称

移除名为 `name` 的自定义操作

### MaaResourceClearCustomAction

移除所有自定义操作

### MaaResourcePostBundle

-   `path`: 资源路径

加载 `path` 路径下的资源

### MaaResourceOverridePipeline

-   `pipeline_override`: 用于覆盖的 json

覆盖 `pipeline_override`

### MaaResourceOverrideNext

-   `node_name`: 任务名
-   `next`: next 列表

覆盖 `node_name` 的 next 列表为 `next`

### MaaResourceGetNodeData

-   `node_name`: 任务名

获取 `node_name` 任务当前的定义

### MaaResourceClear

清除已加载内容

### MaaResourceStatus

-   `id`: 操作 id

查询 `id` 对应操作状态

### MaaResourceWait

-   `id`: 操作 id

等待 `id` 对应操作完成

### MaaResourceLoaded

判断是否加载正常

### MaaResourceSetOption

设置资源配置. 在 binding 中会拆分为具体的配置.

-   InferenceDevice

    设置推理设备

-   InferenceExecutionProvider

    设置推理库

### MaaResourceGetHash

获取资源 hash

### MaaResourceGetNodeList

获取任务列表

## MaaController.h

### MaaAdbControllerCreate

-   `adb_path`: adb 路径
-   `address`: 连接地址
-   `screencap_methods`: 所有可使用的截图方式
-   `input_methods`: 所有可使用的输入方式
-   `config`: 额外配置
-   `agent_path`: MaaAgentBinary 路径
-   `notify`: 接收控制器相关操作的回调

创建 Adb 控制器

> 截图方式和输入方式会在启动时进行测速, 选择最快的方案

### MaaWin32ControllerCreate

-   `hWnd`: 窗口句柄
-   `screencap_methods`: 使用的截图方式
-   `input_methods`: 使用的输入方式
-   `notify`: 接收控制器相关操作的回调

创建 Win32 控制器

### MaaCustomControllerCreate

-   `controller`: 自定义控制
-   `notify`: 接收控制器相关操作的回调

创建自定义控制器

### MaaDbgControllerCreate

-   `read_path`: 输入路径, 包含通过 Recording 选项记录的操作
-   `write_path`: 输出路径, 包含执行结果
-   `type`: 控制器模式
-   `config`: 额外配置
-   `notify`: 接收控制器相关操作的回调

创建调试控制器

### MaaControllerDestroy

销毁控制器

### MaaControllerSetOption

设置控制器配置. 在 binding 中会拆分为具体的配置.

-   ScreenshotTargetLongSide

    设置截图缩放长边到指定长度

-   ScreenshotTargetShortSide

    设置截图缩放短边到指定长度

-   ScreenshotUseRawSize

    设置截图不缩放

### MaaControllerPostConnection

连接设备

### MaaControllerPostClick

-   `x`, `y`: 点击坐标

点击

### MaaControllerPostSwipe

-   `x1`, `y1`: 起点坐标
-   `x2`, `y2`: 终点坐标
-   `duration`: 滑动时长 ms

滑动

### MaaControllerPostClickKey

-   `key`: 虚拟键码
    -   [Adb 控制器](https://developer.android.com/reference/android/view/KeyEvent)
    -   [Win32 控制器](https://learn.microsoft.com/en-us/windows/win32/inputdev/virtual-key-codes)

单击按键

### MaaControllerPostKeyDown

-   `key`: 虚拟键码
    -   [Adb 控制器](https://developer.android.com/reference/android/view/KeyEvent)
    -   [Win32 控制器](https://learn.microsoft.com/en-us/windows/win32/inputdev/virtual-key-codes)

按下键

### MaaControllerPostKeyUp

-   `key`: 虚拟键码
    -   [Adb 控制器](https://developer.android.com/reference/android/view/KeyEvent)
    -   [Win32 控制器](https://learn.microsoft.com/en-us/windows/win32/inputdev/virtual-key-codes)

抬起键

### MaaControllerPostInputText

-   `text`: 输入文本

输入文本

### MaaControllerPostStartApp

-   `intent`: 目标应用
    -   Adb 控制器: package name 或 activity
    -   Win32 控制器: 暂不支持

启动应用

### MaaControllerPostStopApp

-   `intent`: 目标应用
    -   Adb 控制器: package name
    -   Win32 控制器: 暂不支持

关闭应用

### MaaControllerPostTouchDown

-   `contact`: 触点编号
    -   Adb 控制器: 手指编号
    -   Win32 控制器: 鼠标按键(0: 左键, 1: 右键, 2: 中键)
-   `x`, `y`: 触点位置
-   `pressure`: 触点力度

按下

### MaaControllerPostTouchMove

-   `contact`: 触点编号
    -   Adb 控制器: 手指编号
    -   Win32 控制器: 鼠标按键(0: 左键, 1: 右键, 2: 中键)
-   `x`, `y`: 触点位置
-   `pressure`: 触点力度

移动

### MaaControllerPostTouchUp

-   `contact`: 触点编号
    -   Adb 控制器: 手指编号
    -   Win32 控制器: 鼠标按键(0: 左键, 1: 右键, 2: 中键)

抬起

### MaaControllerPostScreencap

截图

### MaaControllerStatus

-   `id`: 操作 id

查询 `id` 对应操作状态

### MaaControllerWait

-   `id`: 操作 id

等待 `id` 对应操作完成

### MaaControllerConnected

判断是否已连接

### MaaControllerCachedImage

获取最新一次截图

### MaaControllerGetUuid

获取设备 uuid

## MaaTasker.h

### MaaTaskerCreate

-   `notify`: 接收实例相关操作的回调

创建实例

### MaaTaskerDestroy

销毁实例

### MaaTaskerSetOption

设置实例配置. 在 binding 中会拆分为具体的配置.

暂无可配置项

### MaaTaskerBindResource

-   `res`: 资源

关联资源

### MaaTaskerBindController

-   `ctrl`: 控制器

关联控制器

### MaaTaskerInited

判断是否正确初始化

### MaaTaskerPostTask

-   `entry`: 任务入口
-   `pipeline_override`: 用于覆盖的 json

执行任务

### MaaTaskerStatus

-   `id`: 操作 id

查询 `id` 对应操作状态

### MaaTaskerWait

-   `id`: 操作 id

等待 `id` 对应操作完成

### MaaTaskerRunning

判断实例是否还在运行

### MaaTaskerPostStop

停止实例

### MaaTaskerStopping

判断实例是否正在停止中(尚未停止)

### MaaTaskerGetResource

获取关联的资源

### MaaTaskerGetController

获取关联的控制器

### MaaTaskerClearCache

清理所有可查询的信息

### MaaTaskerGetRecognitionDetail

-   `reco_id`: 识别号
-   `node_name [out]`: 节点名
-   `algorithm [out]`: 识别算法
-   `hit [out]`: 是否命中
-   `box [out]`: 命中位置
-   `detail_json [out]`: 识别详情
-   `raw [out]`: 截图(仅调试模式有效)
-   `draws [out]`: 附带识别结果的截图(仅调试模式有效)

获取识别信息

### MaaTaskerGetNodeDetail

-   `node_id`: 节点号
-   `node_name [out]`: 节点名
-   `reco_id [out]`: 对应识别号
-   `completed [out]`: 操作结果

获取节点信息

### MaaTaskerGetTaskDetail

-   `task_id`: 任务号
-   `entry [out]`: 任务入口
-   `node_id_list [out]`: 节点号列表
-   `status [out]`: 任务状态

获取任务信息

### MaaTaskerGetLatestNode

-   `node_name`: 任务名
-   `latest_id [out]`: 最新节点号

获取任务 `node_name` 的最新节点号

## MaaContext.h

### MaaContextRunTask

-   `entry`: 任务入口
-   `pipeline_override`: 用于覆盖的 json

同步执行任务

### MaaContextRunRecognition

-   `entry`: 任务名
-   `pipeline_override`: 用于覆盖的 json
-   `image`: 前序截图

同步执行 `entry` 对应的识别逻辑

> 不会执行后续操作, 不会执行后续 next

### MaaContextRunAction

-   `entry`: 任务名
-   `pipeline_override`: 用于覆盖的 json
-   `box`: 前序识别位置
-   `reco_detail`: 前序识别详情

同步执行 `entry` 对应的操作逻辑

> 不会执行后续 next

### MaaContextOverridePipeline

-   `pipeline_override`: 用于覆盖的 json

覆盖 `pipeline_override`

### MaaContextOverrideNext

-   `node_name`: 任务名
-   `next`: next 列表

覆盖 `node_name` 的 next 列表为 `next`

### MaaContextGetNodeData

-   `node_name`: 任务名

获取 `node_name` 任务当前的定义

### MaaContextGetTaskId

获取对应任务号

### MaaContextGetTasker

获取实例

### MaaContextClone

复制上下文

## MaaToolkitConfig.h

### MaaToolkitConfigInitOption

-   `user_path`: 配置存储路径
-   `default_json`: 默认配置

从 `user_path` 中加载全局配置

## MaaToolkitAdbDevice.h

### MaaToolkitAdbDeviceFind

搜索所有已知安卓模拟器

### MaaToolkitAdbDeviceFindSpecified

-   `adb_path`: adb 路径

根据指定 `adb_path` 搜索模拟器

## MaaToolkitDesktopWindow.h

### MaaToolkitDesktopWindowFindAll

查询所有窗口信息

## MaaToolkitProjectInterface

### MaaToolkitProjectInterfaceRegisterCustomRecognition

-   `inst_id`: 实例编号
-   `name`: 名称
-   `recognition`: 自定义识别器

为实例编号为 `id` 的 MaaPiCli 注册名为 `name` 的自定义识别器 `recognition`

### MaaToolkitProjectInterfaceRegisterCustomAction

-   `inst_id`: 实例编号
-   `name`: 名称
-   `action`: 自定义操作

为实例编号为 `id` 的 MaaPiCli 注册名为 `name` 的自定义操作 `action`

### MaaToolkitProjectInterfaceRunCli

-   `inst_id`: 实例编号
-   `resource_path`: 资源路径
-   `user_path`: 配置存储路径
-   `directly`: 非交互模式
-   `notify`: 接收资源/控制器/实例相关操作的回调

执行实例编号为 `id` 的 MaaPiCli, 使用 `resource_path` 路径下的 interface.json

> 启用非交互模式时, 将直接执行预配置的任务

## MaaAgentClientAPI.h

### MaaAgentClientCreateV2

-   `identifier`: 监听地址

创建 Agent 客户端

> 传入空则自动生成

### MaaAgentClientDestroy

销毁 Agent 客户端

### MaaAgentClientIdentifier

获取实际监听地址

### MaaAgentClientBindResource

-   `res`: 资源

将 Agent 客户端关联到资源 `res`

### MaaAgentClientConnect

连接

### MaaAgentClientDisconnect

断开连接

### MaaAgentClientConnected

判断是否已连接

### MaaAgentClientAlive

判断 Agent 服务端是否仍可响应

### MaaAgentClientSetTimeout

-   `milliseconds`: 超时时间 ms

设置 Agent 服务端超时时间

## MaaAgentServerAPI.h

### MaaAgentServerRegisterCustomRecognition

-   `name`: 名称
-   `recognition`: 自定义识别器

注册名为 `name` 的自定义识别器 `recognition`

### MaaAgentServerRegisterCustomAction

-   `name`: 名称
-   `action`: 自定义操作

注册名为 `name` 的自定义操作 `action`

### MaaAgentServerStartUp

-   `identifier`: 连接地址

启动服务, 连接到 `identifier`

### MaaAgentServerShutDown

停止服务

### MaaAgentServerJoin

同步等待服务线程结束

### MaaAgentServerDetach

分离服务线程
