# 标准化高级语言面向对象接口设计指南

MaaFW 的绑定（binding）设计可以分为两个步骤：

1. **标准化 C API 的 OOP 封装**：由于 MaaFW 接口相对稳定，完成封装后无需频繁维护。
2. **高级封装与回调解析**：在标准化封装基础上，解析回调参数（如 message、detail json、pipeline_override 等），并根据更新动态调整封装。随着 MaaFW 的更新，这部分需要持续维护。

开发者可以根据自身需求和时间选择其中一种方式，为 MaaFW 添加某语言的封装。

## 标准化接口设计

1. **对象化接口封装**：
   - MaaTasker、MaaResource、MaaController 等应设计为面向对象的接口，而非过程化的调用。例如 MaaContextGetTasker 需要返回对象而非 handle。
   - 可采用两种模型：
     1. 创建全局 handle-对象引用字典，通过 handle 查找并返回对应对象。
     2. 对象保持无状态，负责引用 handle，直接创建新对象返回。（参考 Python binding 中的 `own` 字段）

2. **异步任务封装**：
   - MaaTaskId、MaaCtrlId、MaaResId 等异步 ID 不直接返回给集成方，而是封装成 Job 类，提供 `wait`、`status`、`get` 等方法。

3. **Job 类封装**：
   - Job 类需封装基于 ID 的所有操作方法。例如 TaskJob 的 `get` 方法需返回 MaaTaskerGetTaskDetail 查询结果的封装。

4. **查询类 ID 封装**：
   - MaaRecoId、MaaNodeId 等查询 ID 不直接返回，需通过 MaaTaskerGetRecoDetail 等接口查询，并封装为 RecoDetail、NodeDetail 等结构体返回。

5. **回调封装**：
   - CustomAction、CustomRecognition、NotificationCallback 等需包装为虚基类。实际传递给 MaaFW 的是 agent 对象中的指针，由 agent 负责将参数转换为常用类型再交给集成方。

6. **参数结构封装**：
   - CustomAction、CustomRecognition 的 agent 中，将 MaaCustomRecognitionCallback/MaaCustomActionCallback 的参数封装成结构体，避免 Callback 参数变化导致兼容性问题。返回值同样需要封装。

7. **独立接口设计**：
   - SetOption 中的每个枚举应拆分为独立接口，例如 `set_screenshot_target_long_side`，而不直接暴露枚举值给集成方。

8. **缓冲区封装**：
   - StringBuffer、ImageBuffer 等不直接暴露给集成方，需转换为对应语言的字符串或图像类型后返回。

9. **引用管理**：
   - 在 BindResource、BindController、RegisterCustom 等接口中保持引用，防止被 GC（垃圾回收）。

10. **结构体数组返回**：
    - MaaToolkit 中的 Find 系列接口直接返回封装后的结构体数组。

11. **提供样例**：
    - 样例代码需展示的接口调用不少于 Python 版样例。

## 额外的回调解析封装

1. **回调解析与派发**：
   - NotificationCallback 需解析 message 并派发至不同方法（参考 MaaMsg.h），如 `on_resource_loading_starting(data)`。也可考虑将 ResourceLoading 作为事件枚举，Starting 作为类型枚举进行派发，如 `on_notification(event, type, data)`。`data` 为 detail_json 解析后的结构体，而非原始 JSON。

2. **未知消息处理**：
   - 可以增加 `on_unknown_notification` 方法，以应对未来可能新增的消息。同时，解析出的结构体中可加入 `raw` 字段或其他方式来表示未知内容。

3. **结果解析**：
   - `MaaTaskerGetRecognitionDetail` 获取的 detail_json 需拆分为 `all_results`、`filtered_results` 和 `best_result`（注意 best 可能为 null），并根据算法解析为不同的结构体。

4. **更多内容待补充**：TODO...
