# 自定义识别/操作

> 注意: 本文档是关于如何使用 NodeJS 进行集成
>
> 注意: 后面注册的函数的返回结果均可以是对应类型的Promise, 即你可以在其中进行异步操作. 大部分Context执行的操作是异步的.

## 自定义识别

```json
{
    "Task": {
        "recognition": "Custom",
        "custom_recognition": "myReco",
        "custom_recognition_param": {
            "msg": "Hello world!"
        },
    }
}
```

```typescript
export interface CustomRecognizerSelf {
    context: Context
    id: maa.TaskId
    name: string
    param: unknown
    image: maa.ImageData
}

res.register_custom_recognizer('myReco', function (this: CustomRecognizerSelf, self: CustomRecognizerSelf) {
    return [
        {
            x: 0,
            y: 0,
            width: 0,
            height: 0
        },
        '111'
    ]
})
```

下面是一个调用其它任务进行识别的例子

```typescript
inst.register_custom_recognizer('forward', (self) => {
    return self.context.run_recognition('another_task', self.image)
})
```

## 自定义任务

```json
{
    "Task": {
        "action": "Custom",
        "custom_action": "myAct",
        "custom_action_param": {
            "msg": "Hello world!"
        },
    }
}
```

```typescript
interface CustomActionSelf {
    context: Context
    id: maa.TaskId
    name: string
    param: unknown
    box: maa.Rect
    detail: string
}

inst.register_custom_action('myAct', function (this: CustomActionSelf, self: CustomActionSelf) => {
    return true
})
```

下面是一个调用其它任务进行操作的例子

```typescript
inst.register_custom_action('forward', (self) => {
    return self.context.run_action('another_task', box, detail)
})
```
