# 打包

> 注意: 本文档是关于如何使用 NodeJS 进行集成

本项目中包含二进制. `@maaxyz/maa-node`包会从`@maaxyz/maa-node-${platform}-${arch}`包中获取对应`MaaNode.node`. 同时, 由于被加载的`MaaNode.node`动态链接了`MaaFramework`库, 且`Adb`控制器依赖`AgentBinary`, 建议直接将`@maaxyz/maa-node`作为外部依赖不参与打包.

如果你确实想要打包, 需要注意以下要点:

* 通常打包工具只能发现`MaaNode.node`, 但不会意识到它的依赖. `MaaNode.node`旁边的所有`dll/so/dylib`应当一并放置在`MaaNode.node`同目录中.
* `Adb`控制器会使用**库脚本**所在目录的`../agent`目录来搜索MaaAgentBinary. 也可以手动在代码中配置.

## maa-node-template

可以参考 [maa-node-template](https://github.com/neko-para/maa-node-template). 该模板提供了简易的electron打包方案.

```shell
npm run build # 使用esbuild构建项目, 参考scripts/build.mjs
npm run watch # 使用esbuild和vite热重载, 参考scripts/watch.mjs
npm run package # 使用electron-forge进行打包
```
